

RECOVER(6)          UNIX Programmer's Manual           RECOVER(6)


NAME
     recover - recover a NetHack game interrupted by disaster

SYNOPSIS
     recover [ -d _d_i_r_e_c_t_o_r_y ] _b_a_s_e_1 _b_a_s_e_2 ...

DESCRIPTION
     Occasionally, a NetHack game will be interrupted by disaster
     when the game or the system crashes.  Prior to NetHack v3.1,
     these games were lost because various information like the
     player's inventory was kept only in memory.  Now, all per-
     tinent information can be written out to disk, so such games
     can be recovered at the point of the last level change.

     The _b_a_s_e options tell _r_e_c_o_v_e_r which files to process.  Each
     base option specifies recovery of a separate game.

     The -d option, which must be the first argument if it
     appears, supplies a directory which is the NetHack play-
     ground.  It overrides the value from NETHACKDIR, HACKDIR, or
     the directory specified by the game administrator during
     compilation (usually /usr/games/lib/nethackdir).

     For recovery to be possible, _n_e_t_h_a_c_k must have been compiled
     with the INSURANCE option, and the run-time option _c_h_e_c_k_-
     _p_o_i_n_t must also have been on.  NetHack normally writes out
     files for levels as the player leaves them, so they will be
     ready for return visits.  When checkpointing, NetHack also
     writes out the level entered and the current game state on
     every level change.  This naturally slows level changes down
     somewhat.

     The level file names are of the form base.nn, where nn is an
     internal bookkeeping number for the level.  The file base.0
     is used for game identity, locking, and, when checkpointing,
     for the game state.  Various OSes use different strategies
     for constructing the base name.  Microcomputers use the
     character name, possibly truncated and modified to be a
     legal filename on that system.  Multi-user systems use the
     (modified) character name prefixed by a user number to avoid
     conflicts, or "xlock" if the number of concurrent players is
     being limited.  It may be necessary to look in the play-
     ground to find the correct base name of the interrupted
     game.  _r_e_c_o_v_e_r will transform these level files into a save
     file of the same name as _n_e_t_h_a_c_k _w_o_u_l_d _h_a_v_e _u_s_e_d.

     Since _r_e_c_o_v_e_r must be able to read and delete files from the
     playground and create files in the save directory, it has
     interesting interactions with game security.  Giving ordi-
     nary players access to _r_e_c_o_v_e_r through setuid or setgid is
     tantamount to leaving the playground world-writable, with
     respect to both cheating and messing up other players.  For
     a single-user system, this of course does not change


Printed 1/20/93          9 January 1993                         1





RECOVER(6)          UNIX Programmer's Manual           RECOVER(6)


     anything, so some of the microcomputer ports install _r_e_c_o_v_e_r
     by default.

     For a multi-user system, the game administrator may want to
     arrange for all .0 files in the playground to be fed to
     recover when the host machine boots, and handle game crashes
     individually.  If the user population is sufficiently
     trustworthy, _r_e_c_o_v_e_r can be installed with the same permis-
     sions the _n_e_t_h_a_c_k executable has.  In either case, _r_e_c_o_v_e_r
     is easily compiled from the distribution utility directory.

NOTES
     Like _n_e_t_h_a_c_k itself, _r_e_c_o_v_e_r will overwrite existing save-
     files of the same name.  Savefiles created by _r_e_c_o_v_e_r are
     uncompressed; they may be compressed afterwards if desired,
     but even a compression-using _n_e_t_h_a_c_k will find them in the
     uncompressed form.

SEE ALSO
     nethack(6)

BUGS
     _r_e_c_o_v_e_r makes no attempt to find out if a base name speci-
     fies a game in progress.  If multiple machines share a play-
     ground, this would be impossible to determine.

     _r_e_c_o_v_e_r should be taught to use the nethack playground lock-
     ing mechanism to avoid conflicts.



























Printed 1/20/93          9 January 1993                         2




