Be sure to read WHATSNEW.TXT for the V2.1 additions!

CIRCA 7000
ARMIES OF ARMAGEDDON
 1995 Boku Strategy Games

TABLE OF CONTENTS

I. INTRODUCTION
II. OVERVIEW
III. STARTING THE GAME
   A. NEW AND SAVED GAMES
   B. E-MAIL GAMES
   C. FINISHED
   D. SPECIFYING GAME FILES
      1. FURTHER EXPLANATION
   E. SETTING UP THE ARMIES
IV. PLAYING THE GAME
   A. THE GAME SCREEN
   B. NEW RECRUITS AND VETERANS
   C. LOOKING AT THE BATTLEFIELD
   D. FACING DIRECTIONS
   E. BATTLEFIELD INFORMATION
   F. ENEMY INFORMATION
   G. YOUR ARMY'S INFORMATION
   H. THE BATTLEFIELD OBSCURED
V. PHASE I: THE MOVEMENT PHASE
   A. FIELD OF VIEW
   B. VEHICLES VS NON-VEHICLES
   C. MOVEMENT POINTS
   D. TERRAIN MOVEMENT MODIFIERS
   E. MOVING YOUR FORCES
   F. NON-VEHICLE TURNING
   G. HOVERERS AND BOATS
   H. MOVEMENT ORDERS
   I. VEHICLE RULES
      1. SPEED AND ACCELERATION
      2. DECELERATION
      3. DRIVING BACKWARDS
      4. TURNING VEHICLES
      5. COLLISIONS
      6. COLLISION DAMAGE
      7. COLLISION SPEED
      8. JUMPING OUT OF THE WAY
      9. RAMMERS
      10. TRANSPORTS
   J. DANGEROUS TERRAIN
   K. ENDING THE MOVEMENT PHASE
VI. PHASE II: TARGET PHASE
   A. CHOOSING AND TARGETING WEAPONS
   B. FIRING ARCS
   C. WEAPON RANGES
   D. FURTHER EXPLANATION
   E. FRIENDLY FIRE
   F. FIRING ORDERS
   G. SURVEY AND TARGET MODES
   H. BATTLE HONORS
VII. PHASE III: FIRING THE WEAPONS
   A. FURTHER EXPLANATION
   B. E-MAIL GAMES AND ENDING THE TURN
VIII. REPLAYS: THE UNOFFICIAL PHASE
   A. HIDDEN EVENTS
IX. END OF THE GAME
   A. CAMPAIGNS AND RECOVERING CASUALTIES
   B. BATTLE REPORT
   C. BECOMING A VETERAN
   D. VIEWING ALL YOUR FORCES
   E. IF ONLY...
X. MIST, SMOKE AND BUILDINGS - BATTLEFIELD ACCESSORIES
   A. MIST
   B. SMOKE
   C. BUILDINGS
XI. DESTROYING TERRAIN
XII. THE MENU BAR
   A. GAME
     1. Save Game
     2. Quit
     3. Retreat
   B. ORDERS
     1. No Orders
     2. Wait
     3. Remaining
     4. End Phase
   C. REPORTS
     1. Damage
	a. Vehicle Special Damage
     2. Objective
     3. Scenario
     4. Weapons
   D. INFO(RMATION)
     1. Wind
     2. Map
     3. Buildings
     4. Sound On/Off
XIII. THE GAME MAKER
   A. SUPPORT FILES
XIV. THE CHECKLIST
   A. ENTERING FILE NAMES DIRECTLY
XV. DRAW BOARD
   A. DRAW BOARD SCREEN
   B. CHOOSING A TERRAIN
   C. PUTTING TERRAIN ON THE BATTLEFIELD
   D. MENU
     1. Define Building
     2. Mist
     3. Fill All
     4. Full Map
     5. Block Size
     6. Save Board
     7. Load Board
     8. Finished
XVI. GAME STORY
   A. New Story
   B. Load Story
   C. Save Story
   D. Finished
XVII. END GAME
   A. CASUALTIES
   B. OCCUPY AN AREA
   C. DESTROY AN AREA
XVIII. PICK ARMY (A or B)
   A. PICK ARMY SCREEN
   B. ADDING FORCES TO YOUR ARMY
   C. REMOVING FORCES FROM YOUR ARMY
   D. ARMY POINTS
   E. MENU BAR
     1. Color
     2. Active/Reserve
     3. Ordering
     4. Add/Subtract
     5. Change Name
     6. New Army
     7. Load Army
     8. Save Army
     9. Finished
     10. Weapons
XIX. PLACE ARMY (A or B)
   A. NEXT
   B. MAP
   C. FINISHED
   D. RULES FOR PLACING FORCES
   E. PLACING TROOPS IN TRANSPORTS
   F. DESIGNATE SETUP AREA
XX. FINISHED
XXI. THE CUSTOMIZER
   A. OVERVIEW
   B. OPENING SCREEN
XXII. CUSTOMIZE FORCES
   A. DRAWING YOUR FORCES
   B. STATS
   C. FURTHER EXPLANATION ON WORKING OUT DAMAGE
   D. PICTURE
XXIII. CUSTOMIZE TERRAIN
XXIV.  CUSTOMIZE WEAPONS
XXV.   CUSTOMIZE PALETTE
XXVI.  CUSTOMIZE SOUNDS
XXVII. LAST FEW, RANDOM NOTES


I.  INTRODUCTION
Circa 7000 is a miniatures-based, strategy game with the emphasis on 
strategy.  Through deceivingly simple game play, players must coordinate 
individual troops, machines and vehicles into a formidable assault while 
being wary of falling ceilings, rough terrain, leaving trails, surprise 
attacks and a barrage of weapons from the enemy.

II.  OVERVIEW
Circa 7000 uses a Three Phase approach to war gaming.  In Phase I, all 
your troops move, with separate rules for foot troops and vehicles.  
During Phase II, all your forces choose their targets.  Phase III, they 
fire.

III.  STARTING THE GAME
To start the game, type "C7".  A7 opening sequence will appear.  Press 
any key to cut it short and get to the first screen.  Here, you are 
presented with three options for playing a battle - Play New Game, Play 
Saved Game and Play E-mail Game.  

A.  NEW AND SAVED GAMES
Playing a New Game or Saved Game is pretty straight forward.  Click on 
the box to the left of the option.  An "X" will appear in it and the 
selection will be highlighted.  If you want the players to be controlled 
by the computer, click on COMPUTER by the appropriate player to 
highlight it.  New Game files have an .SCN extension, Saved Games have 
an .GAM extension and E-mail Games have an .EML extension.

B.  E-MAIL GAMES
E-mail games are handled a little differently.  If you are starting an 
E-mail game, i.e. running from an .SCN file as opposed to an E-mail, 
then choose EMAIL GAME and below that START NEW GAME.  If you are 
running from an E-mail, then choose TAKE NEXT TURN.  

NOTE!!  When you save the turn file from E-mail, be sure you save it 
with a .EML extension so that C7 can recognize it as an E-mail file!

NOTE!!  When reading .EML files, the computer looks for the line "Begin 
decoding Circa7000 here:".   It is extremely important that you do not 
modify this line or any of the information that follows it.  However, 
it's perfectly acceptable to include any information you wish before 
this line.  This means you can save your E-mails without any 
modifications.

C.  FINISHED
When you have chosen the correct setup, click on the FINISHED bar at the 
bottom of the screen.  

D.  SPECIFYING GAME FILES
A new screen will appear, this time asking for six files.  Click on any 
of the boxes to change the file name.  (These can't be changed if you're 
continuing an E-mail game.)

The Game File should be entered first.  Once this has been entered, the 
computer will read the file header and set the remaining five 
accordingly.

(See The Customizer for information on how to build your own support 
files.) 

If your file names have changed or you want to use different support 
files, you can change the Terrain, Weapons, Forces, Color or Sound file 
names.   Otherwise, they should be set properly.

Once the files are declared, click on the button with the X.  (This is 
the equivalent to the FINISHED bar on screens without the free space.) 
To exit the game at this point, clear the Game File box and click on the 
X button.

1.  FURTHER EXPLANATION: All files have a fixed extension.  Scenarios 
have .SCN, saved games have .GAM, terrain files have .TRR, etc.  Anytime 
you are asked to provide a file name, a box with an attached director 
appears.  To specify a file you can type it in and press enter or double 
click on the file name within the directory.  Likewise, you can click 
once on a file within the directory and then edit the name with the 
keyboard.  If there are more than 30 files with the given extension, 
then you need to click on the MORE in the bottom right hand side of the 
directory box to scroll to the next set of file names.

E.  SETTING UP THE ARMIES (CHOICES SCREEN)
After specifying the Scenario name and clicking on the X button, a 
screen with a number of choices to specify will appear.  For the first 
couple games, accept the default and go straight to the X button to 
start the game.  The default allows you to play the battle exactly as 
defined with the armies already set up - no added mist and neither army 
familiar with the battlefield.

Once you played a game or two, you can use this screen to set up the 
armies differently and add mist to the game.  The choices for using 
armies are:

1.) Use the scenarios army.  This is the army that was Picked and 
designed in The Game Maker by the author of the scenario.
2.) Load an army from disk.  This allows you to specify an army file - 
perhaps an army from a previous battle - and use it in this scenario.  
When you exit this screen you will place the army on the field.
3.) Load Placement Army from disk.  This is the equivalent of loading an 
army with all the placement information already included.  The file will 
have a .PLA or .PLB extension.  Use this option when you are setting up 
an Email game.   Your opponent - making sure you both have the same 
files - can use the Game Maker to pick and place his army on the 
battlefield.  Then he can Email you that .PL? file which you can 
incorporate directly.  This way you never see your opponent's setup.

Once the army is picked, there are three things you can do with it:
1.) Use scenarios setup.  Used only with Use Scenarios Army, this 
option leaves the armys setup as the author of the scenario set it up.
2.) Set up in designated area.  This allows you to set up the army in 
the area specified by the author of the scenario.  Once you exit this 
screen, you will be prompted to place the army.  If the author neglected 
to specify an area, the entire screen fill be fuzzed over.  Simply 
grumble, press Escape and go back to the Choices Screen.
3.) Setup up anywhere on field.  This is the same as 2.), but the forces 
can be placed anywhere on the field.

Note that if you load the placement army from disk, these three choices 
are moot.

On this Choices Screen, you can also define the amount of mist you want 
on the board, if any at all.  The mist is randomly grown on the 
battlefield.

Army Familiar with Battlefield.  If these are xd, the entire board 
will be visible for that army.  This means that no areas will be fuzzed 
out.  This would be a logical choice for an army defending its home 
base - theres no need for an army to discover its own area.  

You may also choose this for a completely different reason: To speed up 
the game.  Between each turn and as each force moves, the forces do an 
entire sweep of the battlefield, filling in the parts of the field that 
havent been seen yet (the fuzzed over parts) as they come into view.  
This can take a significant amount of time when large parts of the 
battlefield have to be redrawn.

By making both sides familiar with the field, nothing has to be redrawn 
and the setup time will decrease significantly.  Note that this only 
affects the army discovering the battlefield.  Enemy forces will still 
not be visible unless a direct line of sight can be established.

When the appropriate choices have been xed, click on the button with 
the X on it in the lower right hand corner.  If you chose to place 
armies on the field, it will be done so now.

To set up an army, see PLACING ARMIES in The Game Maker section.  In 
addition to this basic information, there are a few more buttons.

SCAN - When setting up in a designated area, only the designated area is 
shown the rest is fuzzed out.  If you click on SCAN, the cursor will 
change to a pair of binoculars.  Click anywhere within the designated 
area (the area within the red outline) and a visual sweep of the area 
will be done, revealing what can be seen from the battlefield.  Its 
recommended that this is done from a number of spots to help you in 
deciding where to set up the enemy.

PLACE - Highlight this to actually place the forces on the field.

INFO - If this is highlighted, the left mouse button will give you 
information on the terrain instead of placing the forces.

Also on this screen, find a menu button in the upper left hand corner of 
the screen.  This contains two items: OBJECTIVES and SCENARIO.  These 
are explained in detail below.

When you are done, click on the FINISHED button.  When all the choices 
have been taken care of, the scenario will load up and the game will 
begin...

IV.  PLAYING THE GAME
The screen is split into three main areas.  Across the top is the menu 
bar.  To use these, simply click on them.  A list of options will drop 
from which you can choose.  A menu can only be chosen if it isn't 
dimmed.

A.  THE GAME SCREEN
The left side of the screen holds all the information you're going to 
need.  The active force - the one whose turn it is to act - will appear 
in a green box facing the same direction that the troop is facing on the 
battlefield.  If you ever "lose" the active troop (recognized because it 
blinks), you can click on the green box and the troop will be centered 
on the battlefield screen.  

B.  NEW RECRUITS AND VETERANS
Forces will be listed as either New Recruits or Veterans with a number 
after it.  New Recruit means they're in their first battle.  The number 
after Veteran shows how many battles that Force has fought in.

C.  LOOKING AT THE BATTLEFIELD
The largest area on the screen is the battlefield.  To move around the 
battlefield, click on any part of it with your right mouse button.  The 
square that the mouse was pointing at will be centered as best it can.  
If the mouse is pointing at a Force that still has to move or shoot that 
Phase, that force will become active.  This allows you to move and shoot 
forces without being restricted to a specific order.

You also can use the slide bars along the right and bottom of the 
battlefield screen to scroll the battlefield.  Click on either slide bar 
with the left button to move the battlefield along to that position.  
Alternately, you can click on the arrows on either end of the slide bar 
to move the battlefield by five squares.

All the forces on the battlefield are shown from a bird's eye view, that 
is, straight down from above.  Therefore, foot troops will usually 
consist of head and shoulders with arms and guns sticking out.  When you 
look at vehicles, you're looking down at the top of the vehicle.  

D.  FACING DIRECTIONS
Forces (your troops, machines and vehicles) can face 8 directions: up, 
down, left, right and to each corner. (The direction your Force is 
facing on the battlefield has a number of important implications which 
will become evident.) If you turn a troop around in a circle, he will 
face each of the eight directions.

E.  BATTLEFIELD INFORMATION
To find information about anything on the board, click the left mouse 
button on it.  This will cause a box to appear giving a picture of what 
you clicked on and some general information about it.  It will also give 
a status of it's condition.  

F.  ENEMY INFORMATION
General information is given about enemy forces in a pop up box.  This 
information is the best estimate your troops can give you under the 
circumstances and is relative to that particular type of enemy force.  

G.  YOUR ARMY'S INFORMATION
Exact and complete data is given about your troops.

H.  THE BATTLEFIELD OBSCURED
Lastly, part of the battlefield may be obscured with static fuzz.  The 
information box is right in telling you it's "Incomplete Data".  If your 
army is unfamiliar with the battlefield, then the terrain only becomes 
known as your troops are able to draw a line of sight (LoS) to it.  For 
example, you're in a building and the next room is all fuzz.  Moving one 
of your forces into the doorway will cause the room terrain to appear 
because now one of your troops has an LoS to it.  Once terrain appears, 
it doesn't fuzz over again.  

V.  PHASE I: THE MOVEMENT PHASE
A.  FIELD OF VIEW
In the information area on the left of the screen, an array of arrows is 
shown.  These are the arrows that you use to move your forces.  The 
highlighted arrows present your option for moving.

Each of your forces has a field of view (FoV) that ranges from 45 
degrees to 360 degrees in increments of 45 degrees.  A force cannot have 
an LoS on anything outside the FoV.  Troops mostly have an FoV of 180 
degrees meaning they can see directly their left or right.  If the 
troops want to see what's behind them, they have to physically turn 
around and let their FoV sweep the area.  Scorch marks, trails and enemy 
forces won't be shown on the battlefield unless one of your forces has 
an LoS to it.

B.  VEHICLES VS NON-VEHICLES
Forces divided into two distinct categories when it comes to moving: 
Vehicles and Non-vehicles.  What is or isn't a vehicle can become cloudy 
as you start designing your own forces (the designer makes the 
decision), but here are some characteristics: Non-vehicles have a flat 
movement rate that they can move each turn, turning as they wish.  
Vehicles have to accelerate, make wider turns and declare their speed at 
the beginning of their turn.  Vehicles can also mow over anything in 
their path.

C.  MOVEMENT POINTS
In general, moving your forces one square forward costs one movement 
point and moving to a diagonal square cost 1.25 movement points.  To 
move to a square, you must have at least half the movement points 
required to move to that square.  

D.  TERRAIN MOVEMENT MODIFIERS
To slow you down, different terrains, such as woods and water, have 
movement modifiers.  These are x1, x2, x4 and impassable.  If a terrain 
has a x2 movement modifier, then it takes twice as many movement points 
to move into that square.  Impassable means just that - no part of a 
force can enter that square.  One notable exception is boats and water.  
Boats can go over impassable water.   Impassable here refers to land 
based forces.  In general impassable terrain would cover such things as 
walls and boulders.

E.  MOVING YOUR FORCES
In Circa 7000, troops can only move forwards, move backwards, turn left 
and turn right.  (These last two are handled differently for vehicles 
and non-vehicles.  See below).   To move left, a force must turn left 
then walk forward.  Forces cannot slide left or right.  Each turn is 45 
degrees.

For example, a troop (facing North) wants to move three squares to the 
right and then face North again.  The sequence to do this is: turn 
right, turn right, forward, forward, forward, turn left, turn left.  
Once you get the hang of this, it's a snap.

In addition to clicking on the arrows with the mouse, the keypad 
correlates to the arrows matrix: '8' forward, '9' turn right, 2 is 
backwards, etc.

F.  NON-VEHICLE TURNING
Turning 45 degrees costs 0.25 movement points.  The first two turns are 
free.  So in the previous example, the troop would have used 3.50 
movement points (ignoring terrain modifiers).  Terrain modifiers 
increase the movement points for turns the same as moving square to 
square.  

G.  HOVERERS AND BOATS
Exceptions to the movement point rules include Boats and Hoverers.  
Hoverers can be air-cushioned vehicles or troops with jet packs.  The 
terrain modifiers have half the effect and trails aren't left behind.  
Hoverers still cannot enter impassable terrain.  Boats on the other hand 
ignore ALL terrain modifiers.  A boat on water isnt slowed down.  
Terrain modifiers are applied to land-based forces only.   Boats and 
Hoverer can be vehicles or non-vehicles.

H.  MOVEMENT ORDERS
Non-vehicles don't have to use their full movement rate.  To end their 
move, choose NO ORDERS from the Orders menu, hit the space bar or press 
0 (conveniently located under the thumb) on the keypad (see No Orders, 
below).  If you want to move other troops first, choose WAIT from the 
Orders menu (or press 'w') and that particular force will wait until 
everyone else still needing to move has moved before becoming active 
again.  

I.  VEHICLE RULES
Vehicles have a few additional rules that make them more powerful, but 
also a little harder to control.  

1.  SPEED AND ACCELERATION
At the beginning of the vehicle's turn, you must declare how fast the 
vehicle is going to move.  The speed window is determined by the 
vehicle's acceleration rate (ACC) (this is listed in the information box 
when you click on one of your vehicles.) Each turn, your vehicle can 
accelerate over it's present speed by this amount.  So if your 
dunebuggy's speed was 15 squares last turn and it has an ACC of 6 
squares, then it can go 21 squares this turn.

2.  DECELERATION
A vehicle can decelerate at twice its ACC.  The dunebuggy can accelerate 
6 squares and can, therefore, decelerate 12 squares.  If it went 15 
squares last turn it can slow down to 3 squares this turn.  At the 
beginning of the vehicle's turn, you will be shown the current speed of 
your vehicle, its ACC and the range of speed you can choose.  Each 
vehicle has a top speed that it can't exceed.

3.  DRIVING BACKWARDS
A vehicle can also go backwards provided it has come to a stop first.  
To go backwards, enter a negative speed.  (You can also enter partial 
speeds, such as 3.50 and 4.75.) The ACC is halved for going backwards.  

4.  TURNING VEHICLES
While non-vehicles can pivot on the spot, vehicles move during turns.  
The faster it's moving, the wider the turn will be.  This is determined 
by the vehicles Turn Rate.  If a vehicle has a turn rate of 4, then it 
can make 4 evenly spaced turns.  The space between turns is determined 
by the speed.  If a vehicle has a speed of 20, then it must move (20/4) 
= 5 squares before it can turn again.  

When your vehicle turns, it moves forward one square in the turn, it 
doesn't simply rotate.  

Unlike non-vehicles, vehicles MUST move their full specified speed each 
turn.  If you choose 20 squares for the dunebuggy, it must move 20 
squares before the Movement Phase will end.  You can choose the WAIT 
option from the Orders menu if you need to move someone out of your 
vehicle's way, but you don't have the NO ORDERS option.

5.  COLLISIONS
This brings us to collisions.  Collisions can be very detrimental a 
vehicle's health.  At the same time, it can be very detrimental to your 
enemy's health.  When you're about to collide, a warning box will come 
up.  If you can actually do something to avoid the collision - and want 
to - click on CANCEL and change your vehicles direction.  Otherwise, 
you're going to see your vehicle plow into something solid - impassable 
terrain, enemy forces or your forces.

6.  COLLISION DAMAGE
The amount of damage depends on several factors: the toughness and speed 
of the object you run into, the toughness of your vehicle and the speed 
you were traveling.  If your toughness is higher than what you run into, 
chances are strong you're going to inflict more damage than you take.

7.  COLLISION SPEED
Non-vehicles and terrain are considered to be standing still.  If you 
run into another vehicle, that vehicle's speed is taken into 
consideration.  If you hit another vehicle head on, your speeds are 
added together to figure out damage.  The higher the speed, the more 
damage spread around.  If you hit someone from behind, that vehicle's 
speed is subtracted from yours, resulting in relatively low damage.  
When you hit a vehicle from the side only your speed is taken into 
consideration.  Lastly, hitting vehicles at an angle is a compromise 
between a head-on (rear-end) and a side hit.   

8.  JUMPING OUT OF THE WAY
Troops are agile enough to see someone is going to run over them and 
jump out of the way - hopefully.  The slower a vehicle is moving, the 
better the chance of jumping out of the way, provided there is somewhere 
to jump.  Once a vehicle attains a speed above 6, the chances of 
avoiding it are slim.

When a vehicle does collide, most of the time it comes to a stop.  The 
exception is when the vehicle destroys what it runs into.  Depending on 
the strength differences of the colliders, how much damage a vehicle 
takes, the angle of collision and current speeds, your vehicle may still 
have movement left.  Tanks won't be slowed down much after running down 
a few troops.

9.  RAMMERS
Of course, some Generals like running into the enemy as an offensive 
tactic.  Entire squads have been obliterated by a rampaging war machine.  
These vehicles are a special subgroup called Rammers and are specially 
equipped with enemy munching apparati.  When these vehicles collide with 
something, they inflict twice the damage of a normal vehicle.

10.  TRANSPORTS
No point in walking when you can ride! Troops - smallest (Size 1) 
forces, non-vehicle - are the only forces that can enter a transport.  A 
transport, on the other hand, can be anything - vehicle, non-vehicle, 
any size, rammer or boat.  Theres no restriction.

To enter a transport, simply walk your guy into the transport force.  
Youll be asked if youre entering the transport.  Leaving the transport 
requires a little more effort.  Type u or choose UNLOAD from the 
ORDERS Menu.  In the left information area, a depressed area will appear 
with all the riders in it.  In addition, one raised area will appear 
with a troop in it right above the depressed area.  This is the 
unloading square.  The troop in here is the next to be unloaded.  To 
switch the unloading guy, click on any of the troops in the depressed 
area with the left mouse button, and that troop will appear in the 
unloading area.  

To actually unload the troop onto the battlefield, click on a square 
adjacent to the transport.  The troop will lose half its movement points 
and appear on the field facing away from the transport (be sure not to 
step on a mine!)

Once youre finished unloading troops, click on the FINISHED box next to 
the depressed area.  There are a few restrictions for jumping out of 
transports: you must be able to enter the area, the transport cant be 
moving twice the troops movement rate and the troop must have sufficient 
movement points left to make the move.  Once a troop leaves a transport, 
it may move normally.

J.  DANGEROUS TERRAIN
As if enemy fire and rammers werent enough to think about, stepping on 
and walking through certain terrains can be deadly, as well.  Some may 
be obvious: mines that blow up when walked on.  Others can be more 
subtle: troops disappearing without a trace in the swamps.

The chance of taking damage from terrain is dependent on the size of the 
force entering it.  Terrain can blow 100% of the time for troops, but 
not be set off at all by other sized forces.  See the terrain 
description for the lethality of a particular terrain.  Once terrain is 
set off or destroyed, it is no longer considered Dangerous.

K.  ENDING THE MOVEMENT PHASE
Normally, Phase I will end without any notification or fanfare.  The 
exception is when you still have troops inside transports.  In this 
case, an END PHASE button will appear.  If you want to leave your troops 
inside the transport, just click on this button and move on to Phase II.  
However, if you want to unload the troops, you need to click on the 
transport with the right mouse button, in which case youll be asked if 
you want to unload the troops.  

It is done this way because the transport has finished its movement and 
can no longer be activated.  Note that this procedure can be used 
throughout the Phase.  Again, once the troops leave the transport the 
Phase will continue on normally.

VI.  PHASE II: TARGET PHASE
The active force and all its weapons are shown on the info bar at the 
left of the screen.

A.  CHOOSING AND TARGETING WEAPONS
Forces can have up to three weapons that can be categorized as either 
primary or secondary weapons.  You can shoot either the primary OR the 
secondary weapons for each force each turn, but not weapons from both 
groups in the same turn.  For example, troops usually carry a gun 
(primary) and grenades (secondary).  The force can then shoot the gun or 
throw the grenade.

Each weapon is shown on the bottom of the information bar on the left of 
the screen.  Primary weapons will be displayed on green buttons and 
secondary weapons on gray buttons.  To specify which weapon you want to 
shoot, click on in with the left button.  The weapon will appear on a 
lightly-shaded button to show its active.  If you fire a primary 
weapon, the secondary weapons are no longer present as a choice.

Other than that, targeting is very straight forward.  The active force 
will blink, the weapon that is firing will be highlighted on the info 
bar on the left of the screen and all you have to do is point your 
cross-hair, mouse cursor at what you want to shoot and click the left 
button.  A small red dot will appear and then fade.

B.  FIRING ARCS
Each weapon has a firing arc that defines the sweep the weapon can 
cover.  The force is drawn above the weapon buttons and will have a 
number of colored arcs surrounding it.  These arcs show the firing arc 
of each weapon.  The color of the arc matches the color of the button 
face surrounding the picture of the weapon.

When targeting a weapon, you will not be shown what is and isnt within 
the weapons firing arc.  Trying to shoot outside the firing arc is 
representative of an over-ambitious gunner! Instead of not firing at 
all, the shot will follow the boundary of the firing arc.

C.  WEAPON RANGES
Another consideration is the range of the weapon.  They can't cover the 
entire field and some have quite a short range, such as the flame 
thrower.  When you're declaring all your targets in Phase II, these 
factors aren't represented anywhere on the board.  You can find the 
weapon range by clicking the right mouse button on the weapon picture.  
Use the range - in squares - to estimate the distance of your shot on 
the board.

If you fire outside your range, the weapon will go as far as it can, 
then hit where ever the range falls.  So if you pick up a real rookie in 
your army who tried firing directly behind him all the way across the 
field, the actual place the weapon hits will be at the maximum range 
along the weapon's firing arc boundary.

Lastly, in addition to the enemy, you can also target terrain.  This 
allows you to knock down walls or place an area effect weapon in a 
better position.

D.  FURTHER EXPLANATION: The way targeting works is useful to know.  The 
chance of your force actually hitting what it aims at is quite slim.  
Instead, when targeting, you're declaring a general area that your force 
is firing at.  This general area grows in size the further away you aim 
your weapon.  (If your force is right up close to where it's aiming, 
then the "general area" will be the one square you aimed at.) If your 
shot is inaccurate, then it will pick one of the forces (in either army) 
- or an empty square - within the general area and hit it.  

This mimics the general feel of spraying an area with fire as opposed to 
picking out one piece in the middle of the battle and firing only at it.  
It also keeps the enemy from picking out your strong pieces and winking 
them out in the midst of weaker guys, allowing you to set up screens.  
Of course, if your guy is standing all by himself, then he's the only 
target.

E.  FRIENDLY FIRE
It's in here.  Be careful when trying to shoot through your own army.  
Common sense works pretty well here...

F.  FIRING ORDERS
Normally, you can just aim all your weapons as they are presented.  In a 
few instances you may want to not fire some.  To not fire a weapon, 
choose NO ORDERS in the Orders menu (or press the spacebar).  To cycle 
one of your forces to the end, choose the WAIT command in Orders menu 
(or press 'w').  

G.  SURVEY AND TARGET MODES
Finally, if you want information about the board, click on the box with 
SURVEY MODE written in it at the bottom of the information bar.  This 
will give you an arrow to use on the screen.  The left button will now 
give information instead of targeting an area.  Click on TARGET MODE to 
return to targeting.  In both modes, the right mouse button will move 
you around the battlefield.

H.  BATTLE HONORS
Battle Honors are awarded to individual forces as the battle rages on 
and casualties accumulate.  Battle Honors are given for enemy casualties 
inflicted and taken away for friendly casualties.  The number awarded is 
based on the size of the enemy casualty - three for large forces, two 
for medium and one for small.  

The number of Battle Honors accumulated is displayed in several places: 
when the force is active, in the information box and again at the end of 
the game.   Battle Honors are shown using a series of bars and diamonds 
that have the following values:

Gray Bar                1 Battle Honor
Gold Bar                5 Battle Honors
Gray Diamond            10 Battle Honors
Gold Diamond            25 Battle Honors

During the battle, honors are only shown for known casualties.  For 
instance, if youre firing blindly into the woods and cause casualties, 
the Battle Honors wont show up until the end of the game.  If you crash 
into a transport full of troops and blow it up, youll see the Battle 
Honors for the transport during the game, but the honors for the troops 
inside will show up at the end.

VII.  PHASE III: FIRING THE WEAPONS
At this point, everything has moved and aimed its weapons, leaving you 
with very little control through the rest of the turn.  The information 
bar is the same as Phase II: the active force along with its weapons is 
shown.  The active weapon is highlighted.  However, the mode buttons 
have been replaced with a firing button.  When you're ready to watch the 
highlighted weapon fire, press that button.

The only input other than FIRE you can give is to choose which weapon 
will fire next.  You can choose your force as always, by activating it 
with a right mouse button click.  You can choose which weapon to fire 
next by clicking it with the left mouse button.  Beyond that, you can 
choose WAIT in the ORDERS menu.  

A.  FURTHER EXPLANATION: A target square isn't chosen until the weapon 
fires.  Then the deviation, if any, is worked out and a line of sight is 
traced from the weapon square to the target square.  If anything or 
anyone gets in the way, then that becomes the new target square, except 
in the case of weapons that ignore terrain.  So one may consider firing 
repeating weapons well past a squad (in order to spread out the area it 
can deviate) and allow the enemy to "get in the way" of the shots.

One last consideration: Forces bigger than troops have weapons that 
shoot from different parts of their body.  Run the forces through the 
Customizer to see the details, but this can make a big difference when 
your mech is half behind a building and decides to shoot both guns.

B.  E-MAIL GAMES AND ENDING THE TURN
After completing Phase III you can look around the battlefield and check 
out the latest stats in the REPORTS and ORDERS menus.  When you are 
finished, click on the END TURN button at the bottom of the information 
area.  

If you are playing an E-mail game, you will be prompted for a filename.  
The program will then switch to a text screen while the file is being 
compressed and text encoded.  This file is made up strictly of text and 
can be mailed to your opponent just like any other letter you would 
send.  You can also add your own message to the beginning of the file, 
if you wish, without damaging the data.  

VIII.  REPLAYS: THE UNOFFICIAL PHASE
At the beginning of the movement phase (except the first), you are given 
the option of watching your opponent's previous turn.  This is the only 
time that you'll be given the chance and you'll only get to see it once.

You can move around the battlefield before the Replay if you wish, 
looking at information on everything.  This shows the field as it 
currently is.  Once you acknowledge that you want to see the Replay, the 
forces of both sides are put back to where they were before the enemy's 
turn started.  After you finish looking around the board again, click on 
START.  The forces on the board will begin moving and shooting, 
replaying your opponent's moves.

A.  HIDDEN EVENTS
If your opponent is hidden in the undiscovered fuzz, then none of his 
movements will be shown.  The same goes for shooting.  However, when 
weapons are fired - even if you cannot see them - the screen will shift 
to that general area and you will hear the shot.  This gives an inkling 
to where the enemy is as your troops hear the shots being fired.

Clicking on the PAUSE button will freeze the Replay.  You may need to 
hold down the left mouse button briefly in order to get the Replay to 
pause.  Pressing CONTINUE will start it up again.  While it's paused, 
you can scroll around the battlefield.  

The Replay will continue until it's complete.  Then your turn will start 
at Phase I.

IX.  END OF THE GAME
Once the objectives of the battle have been met (See Objectives in the 
Menu section), the battle comes to an end.  A screen appears at the end 
of the turn declaring who won and how.  When you're finished with this, 
click on BATTLE REPORT.  

A.  CAMPAIGNS AND RECOVERING CASUALTIES
An interesting feature of Circa 7000, is that it can be used to play 
campaigns.  Just because your forces are knocked out of action, doesn't 
mean they're gone for good.  The winner - assumed to have control of the 
battlefield - gets 75% (on average) of his forces back.  This is due to 
medical supplies, friendly hands, etc.  The losing army gets 25% of his 
casualties back - mainly due to escapees.  Everyone lost in the losing 
army is simply listed as Missing in Action.  

B.  BATTLE REPORT
The Battle Report at the end shows the final status of all your forces.  
In addition to simply surviving, another benefit of seeing the end of a 
battle is that your forces have a chance of improving.  Any benefits 
will be listed in this report.  Skill Increase means +5% on the Shooting 
Skill.  Bigger, Tougher is an increase of hit points.  Better Armour is 
+1 to Toughness.  Don't expect anyone to become huge.

C.  BECOMING A VETERAN
Another interesting (but useless) feature is that your New Recruits 
become Veterans.  Each battle that your guys survive is tallied and 
noted in the ()'s after "Veteran" wherever you see the description.   

D.  VIEWING ALL YOUR FORCES
To scroll through the pages of your army, click on the "+" at the bottom 
right of the Battle Report.  To go to the previous page, click on the "-
".  When you're finished, click on the "X".  At this point, the armies 
are saved to disk.  You can add New Recruits using the Game Maker to 
bring your army up to strength and ready it for the next battle.

E.  IF ONLY...
Some people (wrong most of the time) think that if they just had "one 
more turn" they could have polished off the winner.  For that reason, at 
the end of the battle you're given the chance to play until one side is 
completely wiped out.  Just for the fun of it.  The armies aren't saved 
at the end and no score is kept.  It's just there as a chance to put to 
rest any "if only" questions.

X.  MIST, SMOKE AND BUILDINGS - BATTLEFIELD ACCESSORIES
A.  MIST
Mist, fog, call it what you will.  Its tough to see very far through.  
In Circa 7000, there are two visual impairments outside of terrain.  The 
first, mist, can be brought on randomly at the beginning of the battle 
when choosing your army set up.  It can also be manually put on the 
battlefield when designing the scenario in the Game Maker.  (See below).  

Each square of mist blocks visibility by 30%.  So at the most, you can 
see through four squares of mist.

B.  SMOKE
Smoke is the second and much thicker visual impairment.  Each square of 
smoke blocks visibility by 50% giving you a visibility range of two 
squares at the most.  Smoke is not manually put on the field, but rather 
a result of weaponry.  Usually, its a byproduct of explosions, but can 
also be put to good use offensively through the use of smoke grenades.  
Laying down a wall of smoke is great for concealing your movements from 
the enemy.

C.  BUILDINGS
Inside The Game Maker, when designing battlefields, buildings are 
defined.  A building - loosely defined - is an area with a ceiling.  
Buildings are defined separately because of the 2D nature of the 
battlefield.  

In terms of fighting the battle, buildings make a difference in only a 
one instance.
This instance is centered around weapons that ignore terrain.  Weapons 
that ignore terrain include grenade launchers and artillery when shells 
are lobbed over the terrain.  If these shots land on a building, the 
shots are assumed to hit the roof instead of the forces inside.  
Therefore, you may see a very powerful shot cover several wimpy troops, 
all of which survive.  Thats the roof acting as protection.

However, the roof is bound to collapse, breaking down the building and 
opening the troops inside to attack from these indirect weapons.  When 
ceilings collapse, they add significantly to the strength of the weapons 
attack - troops are therefore almost guaranteed to take heavy damages.

Note that if these weapons are shot from INSIDE the building, they will 
land INSIDE the building as normal.  They can also shoot outside as 
normal.  This allows, for example, bunkers to be built - underground 
structures housing artillery.

XI.  DESTROYING TERRAIN
Each type of terrain either has a set number of hit points or is defined 
as indestructible.  Once a terrain hits zero points, it is considered 
destroyed for the purpose of Game Ending objectives.   

Most terrain, when destroyed, doesnt change.  However, some, most 
notably building terrain, changes when destroyed to another type of 
terrain.  For example, consider the ceiling in a building.  It appears 
as a floor with perhaps computer equipment on it or chairs.  When this 
square is destroyed, its actually the roof collapsing, so the terrain 
may change to rubble.  The terrain, from there on out, then has all the 
stats of rubble.  If a wall collapses to rubble, the visibility will 
increase from 0% to that of the rubble - the same with the movement 
penalties.  Terrain can only be destroyed once.

XII.  THE MENU BAR
A.  GAME
1.  Save Game
You can save the game during Phases I and II.  Enter the name of the 
file when prompted.  Saved games have a .GAM extension.  In case you 
don't think of it, there is an Autosave feature that saves your game at 
the end of the first and second Phases in a file named "7000bkup.gam".   
This feature is always activated.

2.  Quit
To leave the game completely and return to DOS, use this button on the 
menu.

3.  Retreat
When the battle is hopeless, you can use this option to save a little 
face and a few forces.  This is treated the same as losing a battle.  
Casualties are worked out and armies are saved.

B.  ORDERS
1.  No Orders
This is an option during Phases I and II.  Use it when you're finished 
moving a force or you don't want a weapon to fire.  The following hot 
keys can be used: Spacebar (Phase I & II) or '0' (Phase I).

2.  Wait
This is available at all times.  It puts the current force at the end of 
the rotation.  You can also press w on the keyboard.

3.  Remaining
During any Phase, choose this option (or press 'r') to see which Forces 
still have to move (or shoot).  The Force will be marked with a red flag 
of some design.  You can move around the board as normal, but using the 
left mouse button on the field will cause the flags to disappear.

4.  End Phase
This can be used during Phases I and II and is equivalent to a group No 
Orders.  You can also press f as a hotkey.

C.  REPORTS
1.  Damage
The Damage Report lists all your forces and gives general health and 
status for them.  At the top of the list is your casualty percent 
showing the percent of your forces left in the battle.  Below that is a 
strength rating.  This doesn't count towards anything, but shows what 
percent of the army is left based on the points they cost.  F1 is the 
hotkey.

On the other side of the page is your opponent's army.  This gives 
general descriptions of their health and status.  The only forces shown 
are those your army is aware of.  If one of your opponent's forces is 
knocked out of action before you ever draw a LoS on it, then it will 
never appear in this list.  Casualty and Strength ratings are only given 
for yourself.

To move from page to page, click on the '-' and '+' buttons at the 
bottom right of the screen.  When you're finished, click on the 'X'.

a.  Vehicle Special Damage
If a vehicle takes a beating during a turn, chances are things will go 
wrong with it: lose a weapon, steering failure, cracked hulls, loss of 
power, etc.  This is represented by Special Vehicle Damage.  

It can occur in turns where you take more than six hit points of damage.  
The more damage absorbed, the higher the chance of taking this extra 
damage.  To see if your vehicle has any, click on any of your vehicle 
profiles in this report and hold the button down.  A small report will 
be shown.

2.  Objective
The Objective Report tells you the information needed to end the battle.  
The battle can be won in one of three ways.  The first is casualties - 
once the percent of casualties exceeds that army's tolerance level, the 
army loses.  The second and third entail destroying or occupying a 
certain area on the board.  Casualties, though, is always a fall back 
ending to a battle.  If the objective is occupying an area or destroying 
an area, this report will tell you what percent must be 
occupied/destroyed and what percent is currently.  It also tells you the 
casualty level tolerances.  F2 is the hotkey.

Once you are finished reading this, click a button.  If the objective is 
to occupy or destroy an area, that area is now lit up with a red pattern 
(providing you can see that part of the field.)  You can move around the 
area with the right mouse button as usual.  The left button will return 
the field to normal and allow you to continue with the game.

It may be that the scenario is set up so that both armies have 
objectives.  For instance, Army A may have to occupy 75% of a small 
building before Army B destroys 25% of it.  In scenarios such as these, 
the battle is over when only ONE army has accomplished its objective, 
with casualties always being the fall back game-ender.

So in the same battle, if Army A occupied 80% of it AND the building was 
destroyed by 50% already, the battle would end when 1) Army As 
occupation percent fell below 75% (due to casualties, etc.) or Army B 
lost so many casualties that it quit.  (This is also defined in the 
scenario.)

3.  Scenario
The scenario is the story that goes along with the battle.  A good 
scenario story should say who is fighting and why, along with a little 
background.  A good story makes the battle that much more interesting.  
F3 is the hotkey.

When you're finished reading it, click the mouse button.

4.  Weapons
All the weapons used are shown here.  Click on the NEXT and PREV buttons 
to cycle through them.  All information relevant to the battle is in 
here.  For more details, see The Customizer.  When you're finished, 
click outside the description box.  F4 is the hotkey.

D.  INFO(RMATION)
A few miscellaneous odds and ends reside in this menu.

1.  Wind
This shows a direction arrow pointing the direction the wind is blowing.  
It also contains a strength indicator to show how hard its blowing.  
The wind doesnt affect shooting, but does make the mist and smoke blow 
around.  Smoke is much more volatile than mist and readily dissipates in 
a heavy gust.  Click the mouse button to exit.  F5 is the hotkey.

2.  Map
This shows a blimp-eye view of the battlefield, displaying the entire 
field in  scale.  Forces show up as blue and red blips, sized according 
to the actual force.  You can view this map at any point, even when 
viewing objectives and such.   The additional graphics on the actual 
battlefield will appear here also.

In addition to getting your bearings straight, you can also use the map 
to traverse the battlefield.  Click on the battlefield with your left 
button to center the actual battlefield around that point.  In addition 
to putting a box around what is visible on the screen, the field itself 
is updated behind the map.

To exit, click anywhere off the battlefield.  F6 is the hotkey to 
reach the Map.

3.  Buildings
This allows you to see all the defined buildings by putting red roofs 
on them.   You can move around the field as normal with the right mouse 
button and also by using the Map.  If you get a No Building on 
Battlefield message, it only applies to what you can see.  Click the 
left mouse button on the battlefield to exit this mode.  F7 is the 
hotkey.

4.  Sound On/Off
Provided you have a Sound Blaster compatible sound card, you can use 
this option to toggle the sound off and on.  If you dont, this option 
will not appear.  F8 is the hotkey.

That's Circa 7000! After playing a few scenarios, you'll most likely 
want to start designing your own - drawing the battlefield, setting up 
the objective and picking the armies.  For that there's the Game Maker.

XIII.  THE GAME MAKER

The Game Maker is a utility that allows you to design your own complete 
battles - ready to be played using Circa 7000.  To build a battle a 
number of things must be done: the battlefield drawn, an ending 
designed, armies picked and placed on the battlefield and finally, a 
good story written to go with the battle.  (But not necessarily in that 
order.)

A.  SUPPORT FILES
To run the Game Maker, type "GMAKER" at the DOS prompt and press ENTER.  
The first screen that appears asks for the files that will be used to 
make the scenario - referred to as the Game Files.  These files used to 
make the game are the Forces File, Terrain File, Weapons File, Palette 
File and the Sound File.  The default files that came with the software 
package will be fine for the first couple scenarios you make.  At some 
point though, youll undoubtedly want to start changing these.  The 
Customizer, covered later, will help you with that.  For now, well 
concentrate on The Game Maker.  

These files can be chosen and changed using the same methods used 
throughout the rest of the Circa 7000 package.  When youre finished, 
click on the FINISHED box at the bottom of the screen.

XIV.  THE CHECKLIST
The next screen is the official checklist of the Game Maker.  It is a 
list of things you must do in order to make a scenario.  As you do each 
item, a check appears in the appropriate box and the file name is 
listed.  There are a few obvious orders that need to be considered.  For 
instance, you can't place an army before you pick it.  To choose an item 
on the list, click on the box with the left mouse button.  To get out of 
any of these choices without making any changes, press ESC.  

A.  ENTERING FILE NAMES DIRECTLY
It's recommended that you use the left mouse button and go through each 
of these options while making your scenario.  However, as a short cut, 
click on your choice with the right mouse button.  This will allow you 
to type in the file name which will appear to the right of the option.

You have to be careful because the program does not check the format 
when entering files directly.  It also allows you to specify the files 
in any order, i.e. you can specify the Place Army options before picking 
your army.  If you do specify a file this way that doesn't exist, the 
Game Maker will catch it while compiling your scenario.

XV.  DRAW BOARD
This choice allows you to design the basic field the battle will take 
place on - this includes all the terrain, buildings and mist.

A.  DRAW BOARD SCREEN
When the Draw Board screen appears, there will be a Menu bar in the 
upper left hand corner of the screen.  Below that will be 160 different 
terrain types that you may use.  To get to the rest, click on the blue 
MORE... button below the terrain.  The second set of 160 terrain will 
then be shown and accessible.  The rest of the screen displays the part 
of the battlefield that you can currently work on.  Initially it is all 
grassland.  

B.  CHOOSING A TERRAIN
To choose a terrain, simply click the left button on the terrain square.  
A box will appear around it, showing that it is the currently chosen 
terrain.  If you click the right mouse button on it, an information box 
will appear describing the terrain.

C.  PUTTING TERRAIN ON THE BATTLEFIELD
If you are in the game board section of the screen and you press the 
left mouse button, the chosen terrain will appear on the board.  If you 
drag the mouse around the board a trail of the terrain will follow.  
Move around the screen normally.

D.  MENU
The menu bar presents a number of choices.  Click with the left button 
to pull it down and to make choices.  Clicking elsewhere on the screen 
will cause the menu to disappear.  

1.  Define Building
Define where all your buildings are using this option (see the Building 
description in a previous section.) Instead of drawing terrain, though, 
this option will mark the squares.  Click on the SET button to set the 
markings and the CLEAR button to clear the markings.  When you finish, 
click on DONE or go back to the Menu.  The Menu will now read DROP 
TERRAIN instead of DEFINE BUILDING.

2.  Mist
Mist is placed the same way that you Define Buildings.  This mist will 
be in place for all scenarios using this battlefield until the it's 
modified and the mist removed.

3.  Fill All
When this is clicked on, the current terrain will fill the entire board.  
For example, to fill the entire board with forest, click the left mouse 
button on the forest terrain.  A box will appear around it.  Then go the 
menu bar, click on it.  Then click on FILL ALL.  Your board will then 
become all forest.

4.  Full Map
This option shows you a full preview of the board.  See the description 
in the INFO Menu from C7.

5.  Block Size
The Battlefield is 100x80 squares, filling them in one at a time could 
be time consuming and tedious without this option.  Block Size lets you 
change the size of the block you lay terrain down with to a size of 1x1, 
3x3, 5x3 or 7x7.  The whole block draws the same terrain.  

Simply click on the square of the size you want.  Alternately, type 1, 
3, 5 or 7 to pick the proper size.  This option works with all 
terrain marking and terrain laying routines, including mist, defining 
buildings, marking Placement areas and more, all of which will be 
described in the proper area.

6.  Save Board
It is important to save the board often to avoid losing any information.  
It is also necessary to save the board in order to be finished with it.  
When this selection has been made, you will be prompted for a name.  
This name will then be associated with this particular board and will 
appear in the checklist.  Battlefield files have a .BTT extension.

7.  Load Board
This allows you to load previous boards.  Once they are loaded you can 
edit them as you wish.  You will be warned if you are loading in a board 
over one that has been edited but not saved.

8.  Finished
Once everything is done to you satisfaction, and the game board has been 
saved, press on FINISH to take you back to the main menu.  Once you get 
there, you will notice the name of your game board to the right of Draw 
Board and a check to the left showing it has been completed.  

XVI.  GAME STORY
Every good game needs a good story to set it up.  When this choice is 
made from the checklist, you are taken to a text editor.  Here you write 
the entire scenario behind your battle - who is in it and why, what 
brought them here and the objectives of the battle.  Everything the 
players need to know to play each game should be included in this story.

To start typing in the scenario, click your mouse within the big text 
box in the center of the screen.  Doing so will cause the cursor to 
appear.  When you are finished typing, hit the 'ESC' button to bring the 
mouse cursor back again.

In the upper left corner, there is a menu bar.  By clicking on it, the 
menu will pull down, giving four choices.  

A.  New Story
To clear out the current story and start a new one, use this option.  
You will be warned if you are erasing anything that has not been saved.

B.  Load Story
This allows you to load in previous stories.  For this and all choices, 
loading a file will cause that file to appear in the checklist - unless 
you save it again under a different name.  So, to associate a file with 
your scenario, go to that choice, load the file and then you can leave 
without saving.

C.  Save Story
When choosing this, you will be prompted for a name to the story.  This 
is the only other way to associate a file with a scenario in the 
checklist.  Story files have a .STY extension.

D.  Finished
After you have saved your scenario and wish to leave the editor, you may 
make this selection to return to the main menu, where the Game Story 
will be checked off.

XVII.  END GAME
A.  CASUALTIES
When you select this, you will be presented with the casualty 
percentages for Armies A and B.  This is the casualty tolerance for each 
army.  Once these percentages are reached, an army will be considered to 
have lost the battle.  To increase and decrease these number, click on 
the +s and -s, respectively.  When they are set to the desired 
levels, click on FINISHED.

The next screen asks if you would like to Define Objectives or leave it 
at Casualties Only.  If you choose casualties only, then the Casualty 
Percentages alone will determine when the battle ends.  Choosing Define 
Objectives takes you to the battlefield.  For this reason, Draw Board 
must already be checked off.

Once you get to the battlefield screen, the information bar on the left 
contains a number of buttons.  Most of the buttons are doubled up - 
theres a set for Army A and a set for Army B.  The first button defines 
the objective.  Each time you click it, it flips to the next choice.  
The first is Occupy, followed by Destroy, followed by No Obj.  This last 
stands for No Objective.  If both armies choose No Objective, it would 
be the same as choosing Casualties only on the previous screen.

Before moving on, its probably a good idea to explain the different 
endings.

B.  OCCUPY AN AREA
To occupy a square a force or any part of it must be resting on the 
square.  An area is a collection of squares which may or may not be 
connected.  When calculating the percentage that an area is occupied, 
each square is looked at and its determined whether or not a force is 
on that square.  So if a 2x2 mech is halfway into an area then 2 
squares count towards the total.  It the same mech is fully within the 
area, then all four squares count towards the total.

C. DESTROY AN AREA
Terrain either has a set number of hit points (trees, bridges, walls, 
etc.) or is defined as indestructible (water).  Each time terrain 
takes a hit, points are subtracted from the hit points.  Once this 
reaches zero, the terrain is considered Destroyed.  

After clicking the button until the desired objective is displayed, you 
define the percent of the area that must be Occupied (Destroyed).  You 
do this by clicking on the + and - on either side of the percent.  
Note that these buttons make a sentence.  Reading down, they have the 
form Army A (B) must Occupy/Destroy XX% of the Marked Area.

Marking the area is as simple as laying terrain.  Make sure the SET A 
button is highlighted (by clicking on it) and then using the left 
button, drag the cursor over the battlefield where you want the marked 
area.  An A (or B) will print on each square.  To clear the letters, 
highlight the CLEAR A (B) button and do the same.  Squares that are 
marked for both A and B will have both an A and B printed on them.

There are three buttons across the bottom of the information box.  The 
first is DONE.  Click on this when all the buttons read properly and the 
battlefield has been properly marked.  The second is BLK.  This is the 
same as BLOCK SIZE from Draw Board.  The last is MAP and shows the 
overall of the battlefield.

XVIII.  PICK ARMY (A or B)
The makeup of the army is completely in your hands.  You choose what 
men, machines and vehicles to include in your army and how many of each.  
When picking your army, you also have the choice of what color uniform 
each of your forces should have.  This allows you to create battalions 
and squadrons along with any special forces and keep them separate with 
different color schemes.

A.  PICK ARMY SCREEN
The main part of the screen holds your army.  When the screen first 
appears, the box will be empty except for the word 'Army' in the upper 
left hand and 'Points' in the upper right hand corner.  On the right 
hand side of the screen are the available forces that you have to choose 
from to make up your army.  At the top of the screen are two menu bars 
labeled ARMY and MAKE UP.  Up to 50 different troop types are supported 
in Circa 7000.  

B.  ADDING FORCES TO YOUR ARMY
Each army can have an unlimited number of points using up to 200 forces.  
The value of each force is listed below its respective picture on the 
right of the screen.  To begin, one of the forces will have a box around 
it.  This indicates that it is the currently chosen force and its stats 
will appear in the lower right corner of the screen.  You can change the 
currently chosen force by clicking on other forces.  By clicking a 
second time on a boxed force, it will be added to your army and appear 
in the army portion of the screen.  

Note that there may be more forces than can be shown at one time, both 
in the army and in the choice of forces.  To access all of them, use the 
slide bars to the right of each listing.  This will scroll the choices 
and your army up and down.

C.  REMOVING FORCES FROM YOUR ARMY
If you decide that you do not want a piece in your army, you can then 
click the left mouse button on it in the army window and it will 
disappear.  Clicking the right mouse on a troop within this area will 
pop up a box describing its stats.  When first creating an army, these 
will all be the same.  However, when the vets come back from battle, you 
should see some changes.  Note that once you remove a veteran from your 
army, it cannot come back.  You will get a confirmation box making sure 
you do want to kick out a veteran before doing so.

D.  ARMY POINTS
When you add forces to your army the point total increases and when you 
take forces away, it decreases.  These points can be used as a tool to 
measure the strengths of the army.  Doing so can help you balance the 
battle.  It is also useful when playing an Email opponent, by choosing 
an army point limit and both sides sticking to it while choosing their 
army.  For instance, you may decide that each side may have up to 500 
points in the army.  It is then up to both of you to choose the best 
army within those constraints.

E.  MENU BAR
Picking your forces is only half the job of creating an army.  In 
addition, there are other modifications.  Click on the MAKE UP menu bar 
to see these following choices:

1.  COLOR
When you click on this, 32 color bars will appear below the menu bars 
and above the main window.  Click on a bar with your left mouse button 
to choose it.  When you do, a box will appear around it.  Now, if you 
click on any forces in your army, it will change to that color scheme.   
Note that 32 colors and 50 different forces can give you 1600 unique 
looking forces.

2.  ACTIVE/RESERVE
When this is chosen either an A (active) or R (reserve) will appear 
below each of your forces.  When a piece is active, that means it will 
appear in the next battle (as opposed to being left out).  Therefore, if 
the scenario only calls for a small force, or it is a city with streets 
too narrow for tanks, those pieces can be put on reserve and will not 
partake in the next adventure.  

Click on each piece to toggle between active and reserve.  This is 
mainly a way to keep from having to get rid of your veterans 
unnecessarily.  

3.  ORDERING 
Ordering your army isn't a necessity in choosing your army - simply a 
convenience.  More so, its a hold over from the first version that has 
lost much of its functionality.  (I couldnt bring myself to take 
something out that didnt hurt anything and may prove useful to someone.  
- Mike) When you choose this, a number will appear below each of your 
forces.  This is the order in which your forces will appear when placing 
them.   The numbers start out in the order you chose your army.

When chosen, two squares appear below the menu bar.  One is marked COUNT 
and the other REARRANGE.  The count box holds a number that is used to 
number the forces in the army.  When you click on a force, that force 
takes on the number in the count box.  The count then increases by one.  

So, for example, if the count is at 10 and you click on a force that is 
numbered 5, that force changes to 10.  The force that originally was 
numbered 10 is now numbered 5.

After you are finished ordering your army (or any time in between) click 
on REARRANGE.  This moves all the forces around so that they once again 
are numbered consecutively.  If there are any spaces in your line up, it 
also fills those in.  Lastly, you can increase the count by clicking on 
the '+' or '-'.  Or, conversely, click on the box itself and type in a 
number.

4.  ADD/SUBTRACT
Use this to go back to the default setting of adding and subtracting 
forces to your army.

Under the ARMY MENU you will find:

5.  CHANGE NAME
This changes the name of your army.  After picking this, a prompt will 
appear asking for a new name.  This name will then appear in the upper 
left corner of the army window.  Making the names of the armies fit in 
with the story adds extra flavor.

6.  NEW ARMY
This erases your current army and starts you over from scratch.  A 
warning will be given if there are any pending changes to your current 
army.

7.  LOAD ARMY
This allows you to bring in a old army from disk.  You can then continue 
to edit it as you wish.  If this is after a battle, only the survivors 
will be included.

8.  SAVE ARMY
The name under which you save your army does not necessarily have to be 
the name of the army.  However, some correlation makes it easier.  You 
must save your army before finishing.  

The extension of all armies - A or B - is .ARM.  Be sure you save your A 
and B army files under different names.

9.  FINISHED
After you have saved your army, this will take you back to the main 
menu.  To the right of Pick Army, the name of your saved army will 
appear.

10.  WEAPONS
To gather information on the weapons the Forces are equipped with, use 
this option.

XIX.  PLACE ARMY (A or B)
Placing your armies cannot be done until after they have been picked and 
the battlefield has been drawn.  Then you can proceed with this option.

The screen for this option is split into two sections - a narrow one on 
the left and a much larger one on the right.  On the right, the 
landscape listed next to Draw Board in the Main Menu will appear.  The 
left side of the screen is where the forces to be placed appear.

At the top of the left window under PLACING, a force from your army 
appears.  Below that is a grid of arrows pointing in the eight 
directions.  Click on the arrows to make the piece face in that 
direction.  Below that, several options are listed.

A.  NEXT
Shuffles to the next piece in the army.  This piece will come up again 
when all the other pieces have cycled through.

B.  MAP
This shows the overall map of the battlefield.

C.  FINISHED
When everything has been placed, click here.  You will be prompted for a 
name to save the placement under and then returned to the main menu.

The larger window housing the landscape is where the actual placing of 
the army occurs.  To move around the landscape, click the right button 
on a square to center it.

By pressing the left mouse button, the army piece shown in the left 
window will be placed on the landscape where the mouse is pointing.  
Note that the direction it faces depends on the direction its facing in 
the left window.  For example, to have a mech placed on the board facing 
to the right, you would click on the right facing arrow in the left 
window when the mech appears in above the arrows.  This causes the mech 
to face to the right.  Now you can place the mech on the landscape and 
it will be pointed in the correct direction.

After a piece has been placed, another piece will appear in the left 
window.  If you have placed a piece in the wrong position, click the 
left mouse button on it in the battlefield.  It will disappear from the 
battlefield and be placed back in the army pool.

Only the forces in your army that had been marked active will be placed 
on the battlefield and they cannot be placed on impassable terrain.

If a force cannot enter a certain terrain during the battle, it can not 
be placed on that terrain at the start of the battle.  

D.) RULES FOR PLACING FORCES
i.) Forces - except boats - cannot be place on impassable terrain.
ii.) Only troops that are defined as being able to Enter Water, may be 
place on terrain that is defined as Water.
iii.) All terrain that a Boat is on, must be defined as Water.
iv.) Only size 1 forces can enter terrain with the word Window in the 
name.  Mechs and vehicles werent designed for climbing through windows.

E.) PLACING TROOPS IN TRANSPORTS
Transports are placed normally on the battlefield.  When you wish to 
place a troop inside a transport, make sure the troop is the next to be 
placed on the field and click on the transport just as you would 
normally.  A question box will appear asking you if you want to load the 
troop inside the transport.

To empty a transport, click on it with the left button.  For any normal 
force or empty transport, the force would simply be placed back in the 
circulation.  With transports though, you are asked if you want to 
remove the transport, troops and all.  You will also be asked if you 
only want to empty the troops out.

Once all the forces have been placed, click on the FINISHED button.  If 
there are any unplaced forces, youll be asked if you want to make them 
reserves.

F. DESIGNATE SETUP AREA
The battlefield will now clear and a new information bar will appear.  
This one is used for defining the SETUP AREA.  At the beginning of the 
game, youre asked if you want to use the scenarios setup, set up an 
army in the designated area or set up your army anywhere.  This is where 
the designated area is defined.

Youd want to set up a designated area because it allows you to set up 
your army without knowing the entire board.  For instance, if its a 
break out scenario, then you may want one army to start within a certain 
room.  By designating that room as the set up area, you allow the player 
to set up his army how he wants but within certain restraints that hold 
consistent with the scenario.

To designate the area, make sure the top button reads SET (as opposed to 
CLEAR).  Then you can draw on the battlefield just as you would terrain 
or building markers.  To clear your markings, click on the SET button 
and it will toggle to CLEAR.  

Note that as you mark the designated area, the thermometer goes up.  
Once it hits the top, itll turn red and the FINISHED button will 
activate.  This means that youve defined a large enough area to hold an 
average sized army.   It certainly doesnt hurt to go above this 
recommended minimum.  

It also may not hurt to go below it.  For that reason, you can click on 
FINISHED at any point and still be allowed to exit.  Note that its 
considered bad form, however, to not define ANY setup area if you plan 
on sharing your scenarios with others.

Also included in the Information area is a BLK SIZE button.  Use this to 
define the size of the block used to mark the setup areas (like in other 
sections.) The other button is the MAP which shows the overall 
battlefield map.

XX.  FINISHED
Last in the main menu is the FINISHED choice.  When all the other 
choices in the list have been checked off, you may use this command.  
When clicked on, all the files in the checklist will be confirmed and 
you will be notified of what still has to be completed.  After this, you 
will be prompted for a name to be given to the entire scenario.  Under 
this name, all the information that you have provided, and all your 
designs will be compiled into the single file used by Circa 7000.

Once you've made several scenarios, you'll most likely find the choices 
for creating them somewhat limited.  This takes you to The Customizer, 
which allows you to create your own forces, terrain and weapons.


XXI.  THE CUSTOMIZER
A.  OVERVIEW
The Customizer allows you to make the building blocks of battles.  Up to 
320 terrains can be supported for any one battle along with 50 different 
forces and 40 weapons.  Using the Customizer, you can also put in your 
own sounds and change the color palette.

B.  OPENING SCREEN
When you start the Customizer (type 'CUSTOMIZ' at the DOS prompt), you 
will get a screen listing your options: Customize Forces, Terrain, 
Weapons, Palette or Sounds.  Click on any of these to go to option.

Once you learn how one of these options work, you'll find the others 
follow the same format.

XXII.  CUSTOMIZE FORCES
The screen is split into a number of areas.  The upper left and right 
hand sides display large green, gridded boxes.  These are used for 
drawing the force.  The lower left hand side holds the forces.  Ten 
boxes of the fifty boxes are shown.  To see the rest, us the slide bar 
to the right of the boxes.

The lower right hand side holds the palette of 160 colors and across the 
bottom are most of the menu buttons.

To start, load in a Forces file by clicking on the LOAD FORCES button at 
the bottom left hand side of the screen.  The ten boxes will fill with 
pictures of forces.  Use the slide bar to view the rest.  If there is an 
empty box, that means there is no force there.  To select a force, click 
on it with the left mouse button.  The dark red box will highlight to a 
brighter red.

A.  DRAWING YOUR FORCES
To edit the picture of a force, first select it, then click on the gray 
up arrow to the left of the forces.  The force will be transferred to 
the large, green editing boxes.

When drawing a new picture, use the left box to draw the force so that 
it is facing the top of the screen.  If the force isn't centered 
properly use the UP, DOWN, << and >> buttons to move it around.  If you 
want to start a new picture, but one is already in the boxes, click the 
CLEAR button and the picture will be erased from the editing boxes.  

Also use the CLEAR box to specify what size force you want to work on.  
The options are 16, 32 or 48.  This refers to the number of pixels the 
forces are on a side.

As you've seen from C7 and The Game Maker, parts of the forces change 
colors as you change schemes.  These colors that change are located in 
the center column between the two editing boxes.  To see how the colors 
change, click on the CYCLE button.  Everything that uses these Changing 
Colors will switch to the next color scheme.  When you're finished 
drawing your force, use this button to ensure your force is drawn 
properly.

These Changing Colors come in groups of five and are defined in 
Customize Palette.  The default is 5 shades of the same color used for 
shading your force.  But nothing stops you from only having 3 shades of 
a color and using the other 2 Changing Colors for contrast - like 
stripes.  

Above the Changing Colors is a green box.  This is the background color.  
Any erasing must be done with this colors.  This green does not get 
drawn on the battlefield, but any other color will.

In addition to these six colors, you can also use the palette of 160 
colors lined up on the bottom right side of the screen.  When used in 
the force, these colors will not change from color scheme to color 
scheme.  Use these colors for weapons, wheels, markings and other static 
parts.  

Click on any of these colors with the right mouse button to change them.  
If you want to change the Changing Colors scheme, click on the palette 
colors with the right mouse button - the palette colors match the color 
schemes.

With a color picked, you can start drawing your force.  This is done by 
pressing down the left mouse button and dragging the mouse.  The grid 
squares will change to the color as the mouse passes over it.  To clear 
a square without choosing the green box, use the right mouse button.

When you are finished drawing the force in the left editing box, click 
on the gray, right-facing arrow at the top, middle of the screen.  This 
will move the force to the right editing box, rotating it 45 degrees 
clockwise as it does it.

Note that there is no one-to-one correspondence between the pixels of 
the straight up and diagonal force.  Therefore, the Customizer 
mathematically rotates the force and then filters the image to fill in 
the empty spaces.  This works fairly well, but almost always needs some 
kind of touch up.  This editing box works the same as the left editing 
box.

When both forces are finished, highlight the force box that you want the 
image in and click on the gray arrow to the right of the forces.

The buttons on the page are as follows:
SAVE FORCES and LOAD FORCES - work like any other save and load options.  
It's recommended that you don't change 7000FRCS.FRC - the standard 
forces file.  This way you're not forcing others to overwrite their game 
files when swapping files.  Also, if a number of people did this, you 
wouldn't know if you have the proper Forces File.  Try to choose a 
descriptive and unique name.

DELETE and DELETE ALL - Use DELETE to erase the highlighted force.  Use 
DELETE ALL to erase them all.

B.  STATS
This page contains a lot of information that needs to be defined!  
Anything written in tan can be clicked on to change information.  To 
exit this page, click the FINISHED button or click the right mouse 
button on an empty space.  Here's what everything means:

NAME - Click on this to change the name of the force.  Note that's it is 
EXTREMELY IMPORTANT that all forces have a unique name!!  The name is 
used to draw the force - having the same name means the wrong force will 
be drawn!!

VIEWING ARC - Where the force can see.

VEHICLE - Uses Vehicle movement rules.

HOVERER - Halves terrain movement penalties.  Won't leave a path.

RAMMER - Doubles damage when it crashed into things.  Note that a force 
must be a vehicle to initiate a crash!

BOAT - Can only move in terrain defined as Water.

TRANSPORT - Can carry Small, Non-Vehicle forces.

ENTER WATER - Can enter terrain marked as Water.  If it's "NO", then 
terrain defined as Water is impassable.

WEAPONS
To pick weapons, click on the NEXT and PREV listed below each weapon.  
If "None" appears as the name, then that weapon slot is empty.

PRIMARY WEAPON - Click on this to toggle it to SECONDARY weapon.  See 
the rules in C7 for Primary and Secondary weapons.

FIRING ARC - Click on the +'s and -'s next to the S(tart) or F(inish) 
initials to move the arc around in a circle.  This represents where the 
weapon can fire with up being the front of the force.  

Note that it probably doesn't make sense to have a viewing arc to the 
front 90 degrees and the ability to fire to the rear 90 degrees.  (But 
we do it anyway. We rationalize by explaining that during the course of 
battle, the force can only afford the occasional cursory glance to the 
rear to fire - or better yet, auto-targeters. )

PLACEMENT - this shows where the weapon fires from.  It can be important 
on larger forces.  For example, a mech half behind a wall will fire one 
weapon fine, the other will blow right there as it immediately hits the 
wall.  Click on the '+' and '-' to move the purple square.  

SHOOTING SKILL - The percent chance a force will hit what it's aiming 
at.

MOVEMENT - The Top Speed a vehicle can reach.  The normal Movement 
Points a non-vehicle moves.

ACCELERATION - The amount a vehicle can increase its speed each turn.  A 
vehicle can decelerate at twice this rate.  This doesn't apply to non-
vehicles.

TURN RATE - The maximum number of times a vehicle can move a turn.  The 
current speed is divided by the turn ratio.  This number specifies how 
many Movement Points a vehicle must move before it can turn again.  
Therefore, the higher the Turn Rate, the more maneuverable a force is.

WOUNDS - The number of hits a force can take before it's removed from 
the battle.

TOUGHNESS - The armor level of a force.  The higher the toughness, the 
harder it is to wound the force.

SAVE - After a force is hit, a random number 1 to 10 is picked.  If this 
number is greater than the Save, the force avoids damage.

POINTS - How much a force "costs" when picking armies in The Game Maker.  
To get an idea of what it's worth, click on the EST. PNTS (Estimate 
Points) button to the right of it.  The Customizer will take into 
account movement, weapons and other factors and assign a Points value to 
the force.  If you think this is too high or low, feel free to change it 
using the +'s and -'s as normal.

STEALTH - This specifies the maximum distance an enemy force can be away 
for the force to still be visible on the field.  For instance, a Spy 
force has a  Stealth value of 10.  This means an enemy force has to be 
within 10 squares of the Spy to see it on the battlefield.

The Stealth rating is also affected by terrain Visibility ratings.  If 
the enemy force has to look through a window (Visibility = 50%) to see 
the spy, then the enemy force has to be within 5 squares of it (10x50% = 
5).

1.  FURTHER EXPLANATION ON WORKING OUT DAMAGE
To find the chances of a force being hit, compare the toughness of the 
force to the strength of the weapon shooting at it.  If they are the 
same, then there is a 50% chance the force will take a hit.  For each 
point of difference, this chance changes by 10%.  A strength 4 weapon 
has a 60% chance of damaging a force with a 3 toughness.  A strength 4 
weapon has a 40% chance of damaging a Toughness 5 force.

The SAVE stat gives your force a chance of nullifying the damage - 
perhaps by small size, thick armor or just an unlucky shot.  To see if 
damage is nullified, a random number from 1 to 10 is picked.  If it is 
higher than the forces Save factor, then damage is nullified.

Below, you will see weapons also have a save modifier.  This is a 
negative number and is the modification to the random number.  If the 
random number is 8 and the weapons save is -2, then the random number 
becomes 6.  This is then the final number compared with the force's 
Save.

For example, a troop has a save of 7 and is shot by a weapon with a save 
of -2.  An 8 is randomly generated - which would save the force from 
damage.  But the weapons Save is added, giving a 6, and the troop takes 
damage.

The bottom line is: the lower the save of a force, the better chance it 
will avoid damage.  While the bigger the modifier of the weapon, the 
greater the chance it will cause damage.  

C.  PICTURE
Circa 7000 allows you to draw pictures of all the forces to be displayed 
along with them during the game.  These pictures can be anything - 
faces, badges, markings or actual pictures of the force to give it more 
depth.

Drawing pictures is simple.  Click the color you want with the left 
mouse button and draw on the canvas the same way you did the editing 
squares.  Use FILL to change the entire canvas to the highlighted color.  
PEN1, PEN2 and PEN3 are different sized pens.  Use PEN1 to change one 
color at a time.  Use PEN2 and PEN3 to change more squares at a time.

You can LOAD and SAVE PICTURES like any other file, but this isn't 
necessary.  The Picture is saved automatically with the stats and force 
picture.  Picture files have a .PCT extension.

When you're finished, click the FINISHED button or right click the mouse 
button on any empty space.

XXIII.  CUSTOMIZE TERRAIN
Circa 7000 supports up to 320 different terrains at a time.  The boxes 
that hold these are shown across the bottom half of the screen.  The 
upper right portion of the screen is where the terrain is drawn.  The 
center holds the palette and the left contains a number of buttons.

To draw a force, click the color you want with the left mouse button and 
draw as normal in the editing box.  As you draw, more copies in actual 
size are drawn just to the left.  This shows you how the pieces will fit 
together with each other and also how they appear on their own.

To the left of the editing box - which is 16x16 - you'll see a small 4x4 
editing box.  This is what the Full Map uses to draw the entire field 
out in The Game Maker and during the game.  Draw your terrain again in 
this box.  There will be very little detail, but it should represent the 
terrain rather well.

Below the editing box are two arrows - one pointing down and one 
pointing up.  When you're finished drawing your terrain, highlight a 
terrain box and click on the gray down arrow.  The image will be 
transferred to that box.  To edit a previously drawn terrain, highlight 
the terrain and click the up arrow to transfer to the editing box.

Click on the terrain name to change it.  When a terrain hits 0 wounds, 
it is considered destroyed.  If you want it to change to a different 
terrain upon being destroyed, click on the name following "When 
destroyed, changes to:".  A tan message will say "Click on Terrain".  
Use the left button to click on the destroyed terrain image.

For example, a boulder is defined as impassable.  Make a second terrain 
showing rubble strewn about and call it Blasted Boulder.  When the 
boulder is destroyed, set up the Boulder terrain so it reads: "When 
destroyed, changes to: Blasted Boulder".  This is also useful for 
ceilings collapsing in buildings.  If terrain doesn't change to 
something else, then define it so it changes to itself.

NOTE!! The Changes To When Destroyed stat points to another terrain as 
it appears in the line up.  This allows different terrain squares to 
have the same name.  But it also means than when you move terrain around 
and load in terrain files on top of each other, you will probably have 
to modify this stat for all the terrain switched.

The buttons:
SAVE TERRAIN and LOAD TERRAIN - Works the same as all the others.  See 
the note under SAVE FORCES and LOAD FORCES above.

DELETE and DELETE ALL - DELETE erase the highlighted terrain.  DELETE 
ALL erases all the terrain.

FILL - Changes the entire editing image to the same color.

DETAILS
This brings up a new page used to define all the details of the terrain.  
When you're finished, click on the EXIT button or click the right mouse 
button on an empty space.  You can also get to the DETAILS page by 
clicking on a terrain using the right mouse button.  

Change the stats by clicking on the YES's, NO's, +'s and -'s, except 
where noted otherwise.

NAME - Click on this to type in a new one - just like on the main page.

TOUGHNESS - Terrain takes hits just like Forces.  The higher this 
number, the harder the terrain is to damage.

MOVEMENT - The extra number of Movement Points it takes to enter this 
terrain.  x1 is normal, x2 means it take double the normal amount of 
1.00 and 1.25, etc.  Impassable means no force can enter it.  The only 
exception is Boats, which can enter impassable water.

FOLLOWING FORCES LEAVE A PATH - As it says.  

NUMBER OF HITS - Once this reaches zero, the terrain is considered 
destroyed.

DIMINISHES VISIBILITY BY - This is used for viewing the battlefield.  If 
something diminishes visibility by 100% (like walls), then nothing can 
see past it.  If it is 50% (like woods), then you can see through two 
squares of it.  If it's 0%, then you can see forever.  In other words, 
one this stat adds up to 100% or greater along a line of sight, nothing 
beyond that can be seen.

DIMINISHES FIREPOWER BY - The is the same as the previous stat, except 
it applies to shooting and how far weapons can shoot through this 
particular terrain.  If these two stats appear similar, consider how 
easy it is to see through drapes and how easy it is to shoot through 
drapes.

DANGEROUS TERRAIN - If terrain is defined as Dangerous, then it has a 
chance of blowing as forces pass over it.

Except for WATER, the following stats are only applied if terrain is 
defined as Dangerous:

STRENGTH - The higher this stat, the greater the chance of damaging a 
force.  Note that in making terrain Dangerous, you're essentially 
defining it as a weapon.

DAMAGE - The maximum number of wounds it can cause per square. 
(Explosions cover more than one square.)

EFFECT - What the Force sees as the terrain blows.  See the Weapons 
section for the list of effects.  Click on the description to cycle 
through the options.

SIZE - If the Effect is an explosion, this defines the size of it.

SAVE - The lower this is, the lower the chance the Force will be able to 
shrug off the damage.

CHANCE OF BLOWING - Not all Dangerous Terrain responds the same to 
different sized forces.  For example, pressure sensitive mines will have 
a greater chance of going off from larger forces.  On the other hand, 
sucking swampland will more readily take a troop.

Define the chances for each sized force using the +'s and   -'s as 
normal.

WATER - See the Forces description for ENTER WATER and BOATS for the 
effects of this stat.  Note that this stat can be more creatively 
applied.  For instance, some worlds can't sustain life without special 
gear.  Define the outside world to be WATER and only allow troops with 
the gear to ENTER WATER.

XXIV.  CUSTOMIZE WEAPONS
The Weapons Page is setup just like the Forces page, except only one 
picture of the weapon has to be drawn.  Between Customize Terrain and 
Customize Forces, nearly all the stats related to weaponry have been 
defined.  Up to 40 weapons can be defined.

Drawing the weapons picture is done the same as on the Forces page.  
Highlight the weapon (using the slide bar to scroll through them) and 
use the gray, up arrow to put it in the editing box.  Only the 160 
palette colors can be used with the extra wide blue button being used to 
draw the background.  Note that the background can be any color.  Center 
the image using the UP, DOWN, << and >> buttons.  Clear the image using 
the CLEAR button.

In the upper, right side of the screen, you can choose the weapons shot 
and type of effect it produces.  The type of shots a weapon can fire 
are: Bullets, Rocket, Cone of Flames, Thin Laser, Flaming (red) Ball, 
Steel (gray) Ball, Thick Laser, Double Laser, Stream of Flames, Solid 
Laser or Can't see it fire at all.

The effects can be - Heavy Dark Smoke, Thin Wispy Smoke, Red Splat, 
Explosion, Heavy White Smoke, Billows Smoke or no effect at all.  

STATS
NAME - Click on this to type in a new one.

STRENGTH - The higher this is, the greater the chance of damaging 
terrain and forces.

LONG RANGE - The distance a weapon can shoot.

SHORT RANGE - An arbitrary range splitting what's considered a "Long 
Ranged" shot from a "Short Ranged" shot.

LONG RANGE BONUS - A modifier to the shooting skill for weapons aimed 
out in the Long Ranges.

SHORT RANGE BONUS - A modifier to the shooting skill for the weapons 
aimed in the Short Range.

DAMAGE (PER SQUARE) - The maximum amount of damage per square.  If this 
is 5, the terrain or force will take 1-5 points of damage.

AREA OF EXPLOSION - Only applies when the effect is an explosion and 
defines how big the explosion will be.

SAVE - Modifies the Save factor of the Force it hits.

NUMBER OF SHOTS - If this is REPEAT, a weapon will fire 2-4 times in a 
row, else it just shoots once.

IGNORES TERRAIN - If this is YES, the FIREPOWER DIMINISHED BY factor is 
ignored along with all forces in the weapons path.  The weapon is 
assumed to have a long, arching path and can land in areas not even seen 
yet.  Great for artillery.  (See the Building Rules for the game.)

And lastly, the buttons:

DELETE and DELETE ALL - DELETE erases the highlighted weapon, DELETE ALL 
erases all of them.

SAVE WEAPONS and LOAD WEAPONS - See SAVE FORCES and LOAD FORCES for 
notes.

XXV.  CUSTOMIZE PALETTE
This section allows you to change the 160 colors associated with the 
palette.  The page is laid out in 32 columns of 5 colors. Each set of 5 
colors is referred to as a "Scheme".

To highlight an individual color, click it with the left mouse button.  
To highlight an entire scheme, click any color within it with the right 
mouse button.

To change a scheme, highlight it and click the GET SCHEME button.  The 
middle color is the controlling color.  You can change it by clicking 
the +'s and -'s under the Red, Green and Blue numbers.  The two colors 
above and two colors below are the same color, but varying shades.  

To lighten and darken any color in the scheme, click on the +'s and -'s 
under the LUM next to the color.  LUM stands for illuminate.

When you're finished setting the scheme, highlight where you want it to 
go and click on PUT SCHEME.

You can also do this one color at a time.  Highlight the color and click 
on GET COLOR.  Use the +'s and -'s to change the Red, Green and Blue 
hues and click on PUT COLOR to change the highlight color back in the 
palette.

Use SAVE PAL and LOAD PAL like you would other files.  It is suggested 
that you do not modify 7000CLRS.PAL since this will effect most 
scenarios drawn.

XXVI.  CUSTOMIZE SOUNDS
The last major, modifiable aspect is Sound.  Circa 7000 uses .VOC files 
of up to 200K in length.  However, you may not always want a file that 
large.

When a sound it to be played, Circa 7000 opens the file and transfers to 
extended memory from where it's played.  If you use a 200K .VOC file, 
there's going to be a noticeable delay, especially on slower machines 
with slower disk drives.  

From this, you've probably deduced that the sound file is nothing but a 
list of file names - and you're right.

Customize Sounds is split into two pages.  Use the NEXT PAGE and PREV 
PAGE button to switch between the two.  Each page has 12 boxes on it and 
a small description like Bullets or Double Laser.  These descriptions 
indicate when the sound will be played.  To specify the file name, click 
on the black square to the right of the name.  To test the sound, click 
on the button with the "X" to the left of the description.

If you don't hear any sound, see the Quick Start Manual for solutions.

All the descriptions are self-explanatory except the Random Noise 
section.  These five .VOC files can be played at any point in the three 
Phases of the game instead of a distinct specified time.  This adds a 
bit more depth to the other Phases - instead of sound only when a weapon 
fires.

After specifying  all 24 files, click on the BUILD & SAVE SOUND FILE to 
compile it all.  Note that if a file is specified but not present during 
the game, the file is ignored all together.

XXVII.  BIBLIOGRAPHY/CREDITS
SVGACC - The Super VGA Graphics Library, 1993-1995, Zephyr Software,  
Stephen L. Balkum and Daniel A. Sill.

The Data Compression Book, Mark Nelson, 1992, M&T Publishing, Inc.

The Harper Book of Quotations, Robert I. Fitzhenry, 1993, 
HarperPerennial.

The Developer Kit for Sound Blaster Series, 1991, Creative Labs, Inc.

EGA/VGA A Programmer's Reference Guide, 2nd Ed., Bradley Dyck Kliewer, 
1990, McGraw Hill

Ken Allgood, sound files.

Erik Battle, terrain and forces original artwork.

XXVIII.  LAST FEW, RANDOM NOTES
That covers all the important aspects of the Customizer.  If you look at 
the .TRR, .FRC, .WPN, .PAL and .SND files, you'll notice that they are 
simply text files.  These can be sent straight over E-mail without any 
concern, though due to the size, you'll most likely want to compress 
some of them.  

The files aren't encoded at all in order to make things easier and to 
allow a simple text editor to manipulate them.

As always, we're interested in what you have to say about Circa 7000!! 
We've worked hard to produce a game that puts the power and creativity 
in the hands of the users!  Please send all your comments, complaints, 
and questions to cooney@ix.netcom.com or through the mail to:

Boku Strategy Games
PO Box 2181
El Segundo, CA 90245-1281

And, of course, if you're using some one else's copy of Circa 7000, 
there's no need to share because we have plenty more copies here for 
you!  Please see ORDER.TXT and help Boku stay in the business of 
bringing you quality games!!

