'       Mysterious Song
'
'       Support Module III
'
'$INCLUDE: 'BWSB.BI'
'$INCLUDE: 'GDMTYPE.BI'
'$INCLUDE: 'msong.bi'

DECLARE FUNCTION MultiKey% (T%)
DECLARE SUB InitBWSB ()
DECLARE SUB LoadAndPlay (ModFile$)
DECLARE SUB UnloadMod ()

TYPE MSEConfigFile
  SoundCard     AS INTEGER
  BaseIO        AS INTEGER
  IRQ           AS INTEGER
  DMA           AS INTEGER
  SoundQuality  AS INTEGER
END TYPE

TYPE RegTypeX
  ax AS INTEGER
  bx AS INTEGER
  cx AS INTEGER
  dx AS INTEGER
  bp AS INTEGER
  SI AS INTEGER
  DI AS INTEGER
  Flags AS INTEGER
  ds AS INTEGER
  es AS INTEGER
END TYPE

TYPE RegType
  ax AS INTEGER
  bx AS INTEGER
  cx AS INTEGER
  dx AS INTEGER
  bp AS INTEGER
  SI AS INTEGER
  DI AS INTEGER
  Flags AS INTEGER
END TYPE

DIM SHARED ModHead         AS GDMHeader       'Module Header
DIM SHARED SndDevMSE(6)    AS STRING          'Array of MSE file names
DIM SHARED MSEConfig       AS MSEConfigFile   'Structure of MSE configuration file

REM $DYNAMIC
SUB InitBWSB

Freemem& = FRE(-1) - 80000
a& = SETMEM(-Freemem&)

SndDevMSE(1) = "GUS"
SndDevMSE(2) = "SB1X"
SndDevMSE(3) = "SB2X"
SndDevMSE(4) = "SBPRO"
SndDevMSE(5) = "SB16"
SndDevMSE(6) = "PAS"

OPEN "mse.cfg" FOR BINARY AS 1
  GET 1, , MSEConfig
CLOSE 1
MusicOn% = MSEConfig.SoundCard

IF MusicOn% = 0 THEN EXIT SUB
MSE$ = SndDevMSE(MSEConfig.SoundCard) + ".MSE"

SELECT CASE MSEConfig.SoundQuality
CASE 0: Ov = 16
CASE 1: Ov = 22
CASE 2: Ov = 45
CASE 3: Ov = 8
END SELECT

ErrorFlag = LoadMSE(MSE$, 0, Ov, 4096, MSEConfig.BaseIO, MSEConfig.IRQ, MSEConfig.DMA)

SELECT CASE ErrorFlag
CASE 0
CASE 1: PRINT "Base I/O address autodetection failure": END
CASE 2: PRINT "IRQ level autodetection failure": END
CASE 3: PRINT "DMA channel autodetection failure": END
CASE 4: PRINT "DMA channel not supported": END
CASE 6: PRINT "Sound device does not respond": END
CASE 7: PRINT "Memory control blocks destroyed": END
CASE 8: PRINT "Insufficient memory for mixing buffers": END
CASE 9: PRINT "Insufficient memory for MSE file": END
CASE 10: PRINT "MSE has invalid identification string (corrupt/non-existant)": END
CASE 11: PRINT "MSE disk read failure": END
CASE 12: PRINT "MVSOUND.SYS not loaded (required for PAS use)": END
CASE ELSE: PRINT "Unknown error on MSE startup" + STR$(ErrorFlag): END
END SELECT

END SUB

SUB LoadAndPlay (ModFile$)

IF MusicOn% = 0 THEN EXIT SUB

TestMOD:
IF LEN(ModFile$) = 0 THEN END
IF INSTR(ModFile$, ".") = 0 THEN ModFile$ = ModFile$ + ".GDM"

IF EmsExist THEN ErrorFlag = 1 ELSE ErrorFlag = 0   'Setup EMS use flag
File = FREEFILE
OPEN ModFile$ FOR BINARY AS File

LoadGDM FILEATTR(File, 2), 0, ErrorFlag, VARSEG(ModHead), VARPTR(ModHead)

SELECT CASE ErrorFlag
CASE 0
CASE 1: SCREEN 0: PRINT "Module is corrupt": 'Z = MultiKey(-2): END
CASE 2: SCREEN 0: PRINT "Could not autodetect module type": 'Z = MultiKey(-2): END
CASE 3: SCREEN 0: PRINT "Bad format ID": 'Z = MultiKey(-2): END
CASE 4: SCREEN 0: PRINT "Out of memory": PRINT FRE(-1): 'Z = MultiKey(-2): END
CASE 5: SCREEN 0: PRINT "Cannot unpack samples": 'Z = MultiKey(-2): END
CASE 6: SCREEN 0: PRINT "AdLib samples not supported": 'Z = MultiKey(-2): END
CASE ELSE: SCREEN 0: PRINT "Unknown Load Error:" + STR$(ErrorFlag): 'Z = MultiKey(-2): END
END SELECT

MusicChannels = 0                      'Start out at zero..
FOR J = 1 TO 32                        'Scan for used music channels
  IF ASC(MID$(ModHead.PanMap, J, 1)) <> &HFF THEN
    MusicChannels = MusicChannels + 1
  END IF
NEXT

OverRate& = StartOutput(MusicChannels + 1, 0)'Start your (sound) engines
StartMusic                                'Revv up the music playing

END SUB

SUB UnloadMod

IF MusicOn% = 0 THEN EXIT SUB

CLOSE
StopMusic
StopOutput
UnloadModule

END SUB

