 Q 2BIL; -----------------------------------------------------------------------------
; PTE.CFG
; -----------------------------------------------------------------------------
; PTE configuration file: Main Section (Physical Planets)
;
; Rev. 1.1
;
; (c) 3000AD 1997
; -----------------------------------------------------------------------------

;bc_race= params

; 0 MIXED
; 1 TERRAN
; 2 EMPIRIAN
; 3 VESPERON
; 4 CREDIAN
; 5 KANDORIAN
; 6 MANDORIAN
; 7 ZELON
; 8 VALKERIE
; 9 FALKERIE
;10 GAMMULAN
;11 SYRION
;12 DROIDAN
;13 GALAXIAN
;14 UNIDENTIFIED
;15 ALLY
;16 NEUTRAL
;17 ENEMY
;18 RANDOM

;bc_caste=params

; 0 MILITARY
; 1 EXPLORER
; 2 COLONIST
; 3 SCIENTIST
; 4 EARTHCOM
; 5 POLICE
; 6 RAIDER
; 7 INSURGENT
; 8 ASSASSIN
; 9 DIPLOMAT
;10 MERCENERY
;11 PARAMEDIC
;12 HACKER
;13 TRADER
;14 CRIMINAL
;15 COMMERCIAL
;16 JOURNALIST
;17 WORKER
;18 TOURIST
;19 HAZARD
;20 HARMLESS
;21 AGGRESSIVE
;22 RANDOM

;bc_skill= params

; 1 LOW
; 2
; 3 MED
; 4
; 5 HIGH

;flags= params for autogeneration

;no_naval_objects    - prevents AG from generating naval objects, incl nfleet
;no_air_objects      - prevents AG from generating air objects
;no_compound_objects - prevents AG from generating compound objects
;no_dynamic_objects  - prevents AG from generating dynamic objects
;no_autogen          - disables AG for this planet
;ag_regions_only     - enables  AG to occur only in 'regions'

;region= params for region definition

;x1,y1,x2,y2,bc_race,bc_caste,bc_skill,techlev,deflev

;x1,y1    = top/left coord
;x2,y2    = lower/right coord
;bc_race  = any valid 'race' or 'default'
;bc_caste = any valid 'caste' or 'default'
;bc_skill = any valid 'skill' or 'default'
;techlev  = tech level
;deflev   = defense level

; ---------------------------------------------------------------------------
; Physical Planets
; ---------------------------------------------------------------------------

; DEFAULT entry: will be used whenever pteEnterPhysicalPlanet() is called
; with an invalid planet as argument
; Its setup like earth's moon currently, in order to enable flying to
; all the (undefined) moons with bcflight

[physical_planet]
name=default
type=moon
size=25
techlev=10
deflev=5
seed=100
fog=2
gbm=mtype1
gbmpal=cold
flags=ag_regions_only

[physical_planet]
name=test
type=earth
size=25
techlev=10
deflev=5
seed=0
fog=0
gbm=default
gbmpal=default
flags=ag_regions_only

; ---------------------------------------------------------------------------
; TERRAN QUADRANT
; ---------------------------------------------------------------------------

; ---- SOL ----

[physical_planet]
name=mercury
type=volcanic
size=50
techlev=10
deflev=5
seed=200
fog=0
gbm=ptype1
gbmpal=hot
bc_race=1
flags=no_autogen

[physical_planet]
name=venus
type=desert
size=200
techlev=10
deflev=5
seed=300
fog=0
gbm=ptype2
gbmpal=hot
bc_race=10
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=earth
type=earth
size=200
techlev=10
deflev=5
seed=400
fog=0
gbm=ptype3
gbmpal=temp
bc_race=1
flags=ag_regions_only
region=0,0,49,199,17,22,3,default,default 
region=50,0,99,199,15,22,3,5,3            
region=100,0,149,199,1,7,2,3,2            
region=150,0,199,199,1,22,3,5,5           
mzone=earth1,75,100

[physical_planet]
name=moonp
type=moon
size=25
techlev=10
deflev=5
seed=500
fog=0
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=mars
type=mars
size=150
techlev=10
deflev=5
seed=600
fog=0
gbm=ptype4
gbmpal=temp
bc_race=10
flags=no_naval_objects
flags=ag_regions_only
region=0,0,49,199,17,22,3,default,default 
region=50,0,99,199,15,22,3,5,3            
region=100,0,149,199,1,7,2,3,2            
region=150,0,199,199,1,22,3,5,5           

[physical_planet]
name=phobos
type=moon
size=25
techlev=10
deflev=5
seed=700
fog=1
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=deimos
type=moon
size=50
techlev=10
deflev=5
seed=800
fog=0
gbm=mtype2
gbmpal=cold
bc_race=1
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=jupiter
type=barren
size=400
techlev=10
deflev=5
seed=900
fog=4
gbm=ptype5
gbmpal=cold
bc_race=10
flags=no_autogen

[physical_planet]
name=io
type=moon
size=100
techlev=10
deflev=5
seed=1000
fog=4
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=europa
type=moon
size=100
techlev=10
deflev=5
seed=1100
fog=3
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=ganymede
type=moon
size=100
techlev=10
deflev=5
seed=1200
fog=4
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=callisto
type=moon
size=100
techlev=10
deflev=5
seed=1300
fog=3
gbm=mtype2
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=metis
type=moon
size=75
techlev=10
deflev=5
seed=1400
fog=4
gbm=mtype2
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=adrastea
type=moon
size=75
techlev=10
deflev=5
seed=1500
fog=4
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=amalthea
type=moon
size=75
techlev=10
deflev=5
seed=1600
fog=3
gbm=mtype3
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=thede
type=moon
size=100
techlev=10
deflev=5
seed=1700
fog=4
gbm=mtype3
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=leda
type=moon
size=100
techlev=10
deflev=5
seed=1800
fog=4
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=himalia
type=moon
size=75
techlev=10
deflev=5
seed=1900
fog=3
gbm=mtype4
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=lysithea
type=moon
size=75
techlev=10
deflev=5
seed=2000
fog=3
gbm=mtype2
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=elara
type=moon
size=75
techlev=10
deflev=5
seed=2100
fog=4
gbm=mtype3
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=ananke
type=moon
size=100
techlev=10
deflev=5
seed=2200
fog=4
gbm=mtype4
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=larme
type=moon
size=75
techlev=10
deflev=5
seed=2300
fog=3
gbm=mtype4
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=pasiphae
type=moon
size=75
techlev=10
deflev=5
seed=2400
fog=3
gbm=mtype2
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=sinope
type=moon
size=75
techlev=10
deflev=5
seed=2500
fog=4
gbm=mtype4
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=saturn
type=barren
size=350
techlev=10
deflev=5
seed=2600
fog=4
gbm=ptype6
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=phoebe
type=moon
size=75
techlev=10
deflev=5
seed=2700
fog=3
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=lapetus
type=moon
size=75
techlev=10
deflev=5
seed=2800
fog=3
gbm=mtype2
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=hyperion
type=moon
size=100
techlev=10
deflev=5
seed=2900
fog=4
gbm=mtype3
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=titan
type=moon
size=100
techlev=10
deflev=5
seed=3000
fog=4
gbm=mtype4
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=rhea
type=moon
size=75
techlev=10
deflev=5
seed=3100
fog=3
gbm=mtype5
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=dione
type=moon
size=125
techlev=10
deflev=5
seed=3200
fog=4
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=tethys
type=moon
size=75
techlev=10
deflev=5
seed=3300
fog=3
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=encledau
type=moon
size=75
techlev=10
deflev=5
seed=3400
fog=4
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=mimas
type=moon
size=75
techlev=10
deflev=5
seed=3500
fog=4
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=atlas
type=moon
size=100
techlev=10
deflev=5
seed=3600
fog=4
gbm=mtype2
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=epimethe
type=moon
size=100
techlev=10
deflev=5
seed=3700
fog=3
gbm=mtype2
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=janus
type=moon
size=100
techlev=10
deflev=5
seed=3800
fog=3
gbm=mtype2
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=thetus
type=moon
size=125
techlev=10
deflev=5
seed=3900
fog=4
gbm=mtype2
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=calpio
type=moon
size=125
techlev=10
deflev=5
seed=4000
fog=3
gbm=mtype2
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=telesto
type=moon
size=125
techlev=10
deflev=5
seed=4100
fog=3
gbm=mtype3
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=sat16
type=moon
size=125
techlev=10
deflev=5
seed=4200
fog=4
gbm=mtype3
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=sat17
type=moon
size=125
techlev=10
deflev=5
seed=4300
fog=4
gbm=mtype4
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=sat18
type=moon
size=100
techlev=10
deflev=5
seed=4400
fog=3
gbm=mtype5
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=uranus
type=iceplanet
size=300
techlev=10
deflev=5
seed=4500
fog=4
gbm=ptype7
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=miranda
type=moon
size=125
techlev=10
deflev=5
seed=4600
fog=3
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=ariel
type=moon
size=100
techlev=10
deflev=5
seed=4700
fog=4
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=umbriel
type=moon
size=125
techlev=10
deflev=5
seed=4800
fog=4
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=titania
type=moon
size=125
techlev=10
deflev=5
seed=4900
fog=3
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=oberon
type=moon
size=125
techlev=10
deflev=5
seed=5000
fog=4
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=ura06
type=moon
size=75
techlev=10
deflev=5
seed=5100
fog=3
gbm=mtype2
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=ura07
type=moon
size=75
techlev=10
deflev=5
seed=5200
fog=3
gbm=mtype3
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=ura08
type=moon
size=50
techlev=10
deflev=5
seed=5300
fog=4
gbm=mtype4
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=ura09
type=moon
size=75
techlev=10
deflev=5
seed=5400
fog=3
gbm=mtype5
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=ura10
type=moon
size=75
techlev=10
deflev=5
seed=5500
fog=4
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=ura11
type=moon
size=75
techlev=10
deflev=5
seed=5600
fog=3
gbm=mtype2
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=ura12
type=moon
size=125
techlev=10
deflev=5
seed=5700
fog=3
gbm=mtype3
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=ura13
type=moon
size=125
techlev=10
deflev=5
seed=5800
fog=4
gbm=mtype4
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=ura14
type=moon
size=125
techlev=10
deflev=5
seed=5900
fog=4
gbm=mtype5
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=ura15
type=moon
size=125
techlev=10
deflev=5
seed=6000
fog=4
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=neptune
type=iceplanet
size=250
techlev=10
deflev=5
seed=6100
fog=3
gbm=ptype8
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=triton
type=moon
size=75
techlev=10
deflev=5
seed=6200
fog=3
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=nereid
type=moon
size=75
techlev=10
deflev=5
seed=6300
fog=3
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=nep03
type=moon
size=75
techlev=10
deflev=5
seed=6400
fog=3
gbm=mtype2
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=nep04
type=moon
size=75
techlev=10
deflev=5
seed=6500
fog=2
gbm=mtype3
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=nep05
type=moon
size=75
techlev=10
deflev=5
seed=6600
fog=2
gbm=mtype4
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=nep06
type=moon
size=75
techlev=10
deflev=5
seed=6700
fog=2
gbm=mtype5
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=nep07
type=moon
size=100
techlev=10
deflev=5
seed=6800
fog=3
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=nep08
type=moon
size=75
techlev=10
deflev=5
seed=6900
fog=4
gbm=mtype5
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=pluto
type=iceplanet
size=50
techlev=10
deflev=5
seed=7000
fog=2
gbm=ptype9
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
name=charon
type=moon
size=25
techlev=10
deflev=5
seed=7100
fog=2
gbm=mtype5
gbmpal=cold
bc_race=1
flags=no_autogen

; ---- ALPHA CENTAURI ----

[physical_planet]
name=centris
type=volcanic
size=300
techlev=10
deflev=5
seed=7200
fog=0
gbm=ptype1
gbmpal=hot
bc_race=2
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=cen01
type=moon
size=25
techlev=10
deflev=5
seed=7300
fog=0
gbm=mtype1
gbmpal=cold
bc_race=2
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=cen02
type=moon
size=25
techlev=10
deflev=5
seed=7400
fog=0
gbm=mtype2
gbmpal=cold
bc_race=2
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=nevuela
type=desert
size=100
techlev=10
deflev=5
seed=7500
fog=0
gbm=ptype3
gbmpal=temp
bc_race=2
flags=ag_regions_only

[physical_planet]
name=nev01
type=moon
size=25
techlev=10
deflev=5
seed=7600
fog=0
gbm=mtype3
gbmpal=cold
bc_race=2
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=varan
type=earth
size=200
techlev=10
deflev=5
seed=7700
fog=0
gbm=ptype1
gbmpal=temp
bc_race=2
flags=ag_regions_only

[physical_planet]
name=var01
type=moon
size=25
techlev=10
deflev=5
seed=7800
fog=0
gbm=mtype1
gbmpal=cold
bc_race=2
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=var02
type=moon
size=25
techlev=10
deflev=5
seed=7900
fog=0
gbm=mtype2
gbmpal=cold
bc_race=2
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=var03
type=moon
size=25
techlev=10
deflev=5
seed=8000
fog=0
gbm=mtype3
gbmpal=cold
bc_race=2
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=cronus
type=mars
size=250
techlev=10
deflev=5
seed=8100
fog=0
gbm=ptype8
gbmpal=temp
bc_race=2
flags=ag_regions_only

[physical_planet]
name=treas
type=barren
size=500
techlev=10
deflev=5
seed=8200
fog=0
gbm=ptype6
gbmpal=temp
bc_race=2
flags=ag_regions_only

[physical_planet]
name=tramis
type=iceplanet
size=50
techlev=10
deflev=5
seed=8300
fog=4
gbm=ptype2
gbmpal=cold
bc_race=2
flags=ag_regions_only

[physical_planet]
name=tra01
type=moon
size=25
techlev=10
deflev=5
seed=8400
fog=0
gbm=mtype1
gbmpal=cold
bc_race=2
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=tra02
type=moon
size=25
techlev=10
deflev=5
seed=8500
fog=0
gbm=mtype3
gbmpal=cold
bc_race=2
flags=no_naval_objects
flags=ag_regions_only

; ---- BARNARDS STAR ------------------------

[physical_planet]
name=sygan
type=earth
size=250
techlev=10
deflev=5
seed=8600
fog=0
gbm=ptype2
gbmpal=temp
bc_race=0
flags=ag_regions_only

[physical_planet]
name=syg01
type=moon
size=25
techlev=10
deflev=5
seed=8700
fog=0
gbm=mtype1
gbmpal=cold
bc_race=0
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=syg02
type=moon
size=25
techlev=10
deflev=5
seed=8800
fog=0
gbm=mtype4
gbmpal=cold
bc_race=0
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=zilon
type=desert
size=350
techlev=10
deflev=5
seed=8900
fog=0
gbm=ptype4
gbmpal=temp
bc_race=0
flags=ag_regions_only

[physical_planet]
name=zil01
type=moon
size=25
techlev=10
deflev=5
seed=9000
fog=0
gbm=mtype1
gbmpal=cold
bc_race=0
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=zil02
type=moon
size=25
techlev=10
deflev=5
seed=9100
fog=0
gbm=mtype2
gbmpal=cold
bc_race=0
flags=no_naval_objects
flags=ag_regions_only

; ---- SIRIUS ------------------------------

[physical_planet]
name=lyrius
type=volcanic
size=500
techlev=10
deflev=5
seed=9200
fog=0
gbm=ptype5
gbmpal=hot
bc_race=0
flags=ag_regions_only

[physical_planet]
name=lyr01
type=moon
size=50
techlev=10
deflev=5
seed=9300
fog=2
gbm=mtype4
gbmpal=cold
bc_race=0
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=lyr02
type=moon
size=50
techlev=10
deflev=5
seed=9400
fog=3
gbm=mtype5
gbmpal=cold
bc_race=0
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=lennen
type=desert
size=300
techlev=10
deflev=5
seed=9500
fog=1
gbm=ptype7
gbmpal=temp
bc_race=0
flags=ag_regions_only

[physical_planet]
name=len01
type=moon
size=100
techlev=10
deflev=5
seed=9600
fog=0
gbm=mtype5
gbmpal=cold
bc_race=0
flags=no_naval_objects
flags=ag_regions_only

; ---- OMICRON ERIDANI ----

[physical_planet]
name=midae
type=desert
size=250
techlev=10
deflev=5
seed=9700
fog=0
gbm=ptype6
gbmpal=temp
bc_race=3
flags=ag_regions_only

[physical_planet]
name=mid01
type=moon
size=75
techlev=10
deflev=5
seed=9800
fog=0
gbm=mtype1
gbmpal=cold
bc_race=3
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=mid02
type=moon
size=25
techlev=10
deflev=5
seed=9900
fog=0
gbm=mtype2
gbmpal=hot
bc_race=3
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=canaan
type=earth
size=200
techlev=10
deflev=5
seed=10000
fog=1
gbm=ptype3
gbmpal=temp
bc_race=3
flags=ag_regions_only

[physical_planet]
name=frellis
type=earth
size=200
techlev=10
deflev=5
seed=10100
fog=2
gbm=ptype4
gbmpal=cold
bc_race=3
flags=ag_regions_only

[physical_planet]
name=fre01
type=moon
size=100
techlev=10
deflev=5
seed=10200
fog=0
gbm=mtype1
gbmpal=cold
bc_race=3
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=fre02
type=moon
size=25
techlev=10
deflev=5
seed=10300
fog=0
gbm=mtype2
gbmpal=cold
bc_race=3
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=ramis
type=mars
size=300
techlev=10
deflev=5
seed=10400
fog=0
gbm=ptype5
gbmpal=hot
bc_race=3
flags=ag_regions_only

[physical_planet]
name=ram01
type=moon
size=125
techlev=10
deflev=5
seed=10500
fog=2
gbm=mtype1
gbmpal=hot
bc_race=3
flags=no_naval_objects
flags=ag_regions_only

; ---- TAU CETI ----------------------------

[physical_planet]
name=xylan
type=earth
size=250
techlev=10
deflev=5
seed=10600
fog=1
gbm=ptype3
gbmpal=temp
bc_race=0
flags=ag_regions_only

[physical_planet]
name=arima
type=mars
size=400
techlev=10
deflev=5
seed=10700
fog=0
gbm=ptype9
gbmpal=temp
bc_race=0
flags=ag_regions_only

[physical_planet]
name=ari01
type=moon
size=25
techlev=10
deflev=5
seed=10800
fog=0
gbm=mtype1
gbmpal=cold
bc_race=0
flags=no_autogen

[physical_planet]
name=ari02
type=moon
size=125
techlev=10
deflev=5
seed=10900
fog=3
gbm=mtype2
gbmpal=cold
bc_race=0
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=eori
type=barren
size=300
techlev=10
deflev=5
seed=11000
fog=1
gbm=ptype1
gbmpal=cold
bc_race=0
flags=ag_regions_only

[physical_planet]
name=eor01
type=moon
size=125
techlev=10
deflev=5
seed=11100
fog=4
gbm=mtype2
gbmpal=cold
bc_race=0
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=eor02
type=moon
size=125
techlev=10
deflev=5
seed=11200
fog=3
gbm=mtype3
gbmpal=cold
bc_race=0
flags=no_naval_objects
flags=ag_regions_only

; ---- POLARIS ----

[physical_planet]
name=polar1
type=desert
size=250
techlev=10
deflev=5
seed=11300
fog=0
gbm=ptype2
gbmpal=temp
bc_race=0
flags=ag_regions_only

[physical_planet]
name=polar2
type=earth
size=250
techlev=10
deflev=5
seed=11400
fog=0
gbm=ptype3
gbmpal=cold
bc_race=0
flags=ag_regions_only

[physical_planet]
name=pol01
type=moon
size=75
techlev=10
deflev=5
seed=11500
fog=0
gbm=mtype3
gbmpal=cold
bc_race=0
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=pol02
type=moon
size=125
techlev=10
deflev=5
seed=11600
fog=2
gbm=mtype4
gbmpal=cold
bc_race=0
flags=no_naval_objects
flags=ag_regions_only

; ---- PROCYON ----

[physical_planet]
name=actisiv
type=iceplanet
size=50
techlev=10
deflev=5
seed=11700
fog=2
gbm=ptype1
gbmpal=cold
bc_race=0
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=act01
type=moon
size=75
techlev=10
deflev=5
seed=11800
fog=0
gbm=mtype1
gbmpal=cold
bc_race=0
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=actisv
type=iceplanet
size=150
techlev=10
deflev=5
seed=11900
fog=2
gbm=ptype2
gbmpal=cold
bc_race=0
flags=no_naval_objects
flags=ag_regions_only

; ---------------------------------------------------------------------------
; CREDIAN QUADRANT
; ---------------------------------------------------------------------------

; ---- TRENIS ----

[physical_planet]
name=ronusiv
type=volcanic
size=100
techlev=10
deflev=5
seed=12000
fog=0
gbm=ptype1
gbmpal=hot
bc_race=4
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=ron01
type=moon
size=25
techlev=10
deflev=5
seed=12100
fog=2
gbm=mtype1
gbmpal=cold
bc_race=4
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=ron02
type=moon
size=50
techlev=10
deflev=5
seed=12200
fog=0
gbm=mtype2
gbmpal=cold
bc_race=4
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=antis
type=desert
size=250
techlev=10
deflev=5
seed=12300
fog=0
gbm=ptype7
gbmpal=temp
bc_race=4
flags=ag_regions_only

[physical_planet]
name=herin
type=barren
size=300
techlev=10
deflev=5
seed=12400
fog=0
gbm=ptype4
gbmpal=temp
bc_race=4
flags=ag_regions_only

[physical_planet]
name=her01
type=moon
size=125
techlev=10
deflev=5
seed=12500
fog=4
gbm=mtype1
gbmpal=cold
bc_race=4
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=her02
type=moon
size=125
techlev=10
deflev=5
seed=12600
fog=3
gbm=mtype2
gbmpal=cold
bc_race=4
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=her03
type=moon
size=25
techlev=10
deflev=5
seed=12700
fog=0
gbm=mtype3
gbmpal=cold
bc_race=4
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=scorpia
type=iceplanet
size=150
techlev=10
deflev=5
seed=12800
fog=2
gbm=ptype5
gbmpal=cold
bc_race=4
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=sco01
type=moon
size=75
techlev=10
deflev=5
seed=12900
fog=1
gbm=mtype1
gbmpal=temp
bc_race=4
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=darain
type=barren
size=300
techlev=10
deflev=5
seed=13000
fog=0
gbm=ptype1
gbmpal=hot
bc_race=4
flags=ag_regions_only

; ---- KRYNON ----

[physical_planet]
name=tyrus2
type=earth
size=250
techlev=10
deflev=5
seed=13100
fog=0
gbm=ptype1
gbmpal=temp
bc_race=5
flags=ag_regions_only

[physical_planet]
name=tyr01
type=moon
size=125
techlev=10
deflev=5
seed=13200
fog=0
gbm=mtype1
gbmpal=cold
bc_race=5
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=tyr02
type=moon
size=25
techlev=10
deflev=5
seed=13300
fog=0
gbm=mtype2
gbmpal=cold
bc_race=5
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=lydan
type=mars
size=300
techlev=10
deflev=5
seed=13400
fog=0
gbm=ptype9
gbmpal=temp
bc_race=5
flags=ag_regions_only

; ---- LANIX-V ----

[physical_planet]
name=zelana
type=mars
size=300
techlev=10
deflev=5
seed=13500
fog=0
gbm=ptype9
gbmpal=temp
bc_race=7
flags=ag_regions_only

[physical_planet]
name=zel01
type=moon
size=125
techlev=10
deflev=5
seed=13600
fog=0
gbm=mtype1
gbmpal=cold
bc_race=7
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=zel02
type=moon
size=125
techlev=10
deflev=5
seed=13700
fog=2
gbm=mtype2
gbmpal=cold
bc_race=7
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=zel03
type=moon
size=100
techlev=10
deflev=5
seed=13800
fog=0
gbm=mtype3
gbmpal=hot
bc_race=7
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=zel04
type=moon
size=125
techlev=10
deflev=5
seed=13900
fog=0
gbm=mtype4
gbmpal=cold
bc_race=7
flags=no_naval_objects
flags=ag_regions_only

; ---- CYRIAN ----

[physical_planet]
name=rinaal
type=volcanic
size=100
techlev=10
deflev=5
seed=14000
fog=0
gbm=ptype1
gbmpal=hot
bc_race=6
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=rin01
type=moon
size=25
techlev=10
deflev=5
seed=14100
fog=2
gbm=mtype2
gbmpal=cold
bc_race=6
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=rin02
type=moon
size=50
techlev=10
deflev=5
seed=14200
fog=0
gbm=mtype3
gbmpal=cold
bc_race=6
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=rin03
type=moon
size=25
techlev=10
deflev=5
seed=14300
fog=0
gbm=mtype4
gbmpal=cold
bc_race=6
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=rin04
type=moon
size=25
techlev=10
deflev=5
seed=14400
fog=0
gbm=mtype5
gbmpal=cold
bc_race=6
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=pravis
type=earth
size=250
techlev=10
deflev=5
seed=14500
fog=0
gbm=ptype2
gbmpal=temp
bc_race=6
flags=ag_regions_only

[physical_planet]
name=pra01
type=moon
size=59
techlev=10
deflev=5
seed=14600
fog=4
gbm=mtype1
gbmpal=cold
bc_race=6
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=pra02
type=moon
size=25
techlev=10
deflev=5
seed=14700
fog=0
gbm=mtype2
gbmpal=temp
bc_race=6
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=capella
type=mars
size=350
techlev=10
deflev=5
seed=14800
fog=0
gbm=ptype6
gbmpal=temp
bc_race=6
flags=ag_regions_only

[physical_planet]
name=cap01
type=moon
size=25
techlev=10
deflev=5
seed=14900
fog=0
gbm=mtype5
gbmpal=cold
bc_race=6
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=hadar9
type=iceplanet
size=200
techlev=10
deflev=5
seed=15000
fog=3
gbm=ptype1
gbmpal=cold
bc_race=6
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=had01
type=moon
size=125
techlev=10
deflev=5
seed=15100
fog=0
gbm=mtype1
gbmpal=cold
bc_race=6
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=had02
type=moon
size=25
techlev=10
deflev=5
seed=15200
fog=0
gbm=mtype5
gbmpal=cold
bc_race=6
flags=no_naval_objects
flags=ag_regions_only

; ---- TAU RANIS ----

[physical_planet]
name=krystar
type=desert
size=150
techlev=10
deflev=5
seed=15300
fog=0
gbm=ptype5
gbmpal=temp
bc_race=0
flags=ag_regions_only

[physical_planet]
name=kry01
type=moon
size=125
techlev=10
deflev=5
seed=15400
fog=2
gbm=mtype1
gbmpal=cold
bc_race=0
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=rebelan
type=earth
size=250
techlev=10
deflev=5
seed=15500
fog=0
gbm=ptype4
gbmpal=temp
bc_race=0
flags=ag_regions_only

[physical_planet]
name=reb01
type=moon
size=75
techlev=10
deflev=5
seed=15600
fog=0
gbm=mtype3
gbmpal=cold
bc_race=0
flags=no_naval_objects
flags=ag_regions_only

; ---- ARENIS ----

[physical_planet]
name=khan
type=desert
size=400
techlev=10
deflev=5
seed=15700
fog=0
gbm=ptype8
gbmpal=temp
bc_race=0
flags=ag_regions_only

; ---- XYON ----

[physical_planet]
name=chanis1
type=mars
size=100
techlev=10
deflev=5
seed=15800
fog=0
gbm=ptype3
gbmpal=temp
bc_race=0
flags=ag_regions_only

[physical_planet]
name=cha01
type=moon
size=50
techlev=10
deflev=5
seed=15900
fog=0
gbm=mtype1
gbmpal=cold
bc_race=0
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=cha02
type=moon
size=25
techlev=10
deflev=5
seed=16000
fog=3
gbm=mtype2
gbmpal=cold
bc_race=0
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=chanis2
type=barren
size=150
techlev=10
deflev=5
seed=16100
fog=0
gbm=ptype1
gbmpal=temp
bc_race=0
flags=no_naval_objects
flags=ag_regions_only

; ---------------------------------------------------------------------------
; GAMMULAN QUADRANT
; ---------------------------------------------------------------------------

; ---- OMEGA CENTAURI ----

[physical_planet]
name=lv184
type=desert
size=200
techlev=10
deflev=5
seed=16200
fog=0
gbm=ptype9
gbmpal=temp
bc_race=8
flags=ag_regions_only

[physical_planet]
name=kruger
type=mars
size=250
techlev=10
deflev=5
seed=16300
fog=0
gbm=ptype1
gbmpal=temp
bc_race=8
flags=ag_regions_only

[physical_planet]
name=kru01
type=moon
size=125
techlev=10
deflev=5
seed=16400
fog=3
gbm=mtype1
gbmpal=hot
bc_race=8
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=kru02
type=moon
size=125
techlev=10
deflev=5
seed=16500
fog=2
gbm=mtype2
gbmpal=hot
bc_race=8
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=kru03
type=moon
size=25
techlev=10
deflev=5
seed=16600
fog=4
gbm=mtype3
gbmpal=cold
bc_race=8
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=otura6
type=earth
size=250
techlev=10
deflev=5
seed=16700
fog=0
gbm=ptype8
gbmpal=temp
bc_race=8
flags=ag_regions_only

[physical_planet]
name=otura9
type=iceplanet
size=400
techlev=10
deflev=5
seed=16800
fog=3
gbm=ptype8
gbmpal=cold
bc_race=8
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=otu01
type=moon
size=75
techlev=10
deflev=5
seed=16900
fog=3
gbm=mtype5
gbmpal=cold
bc_race=8
flags=no_naval_objects
flags=ag_regions_only

; ---- ALPHA CYGNI ----

[physical_planet]
name=lv103
type=desert
size=250
techlev=10
deflev=5
seed=17000
fog=0
gbm=ptype9
gbmpal=temp
bc_race=9
flags=ag_regions_only

[physical_planet]
name=lv104
type=earth
size=300
techlev=10
deflev=5
seed=17100
fog=0
gbm=ptype1
gbmpal=temp
bc_race=9
flags=ag_regions_only

[physical_planet]
name=lv104_01
type=moon
size=25
techlev=10
deflev=5
seed=17200
fog=0
gbm=mtype1
gbmpal=cold
bc_race=9
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=lv105
type=mars
size=100
techlev=10
deflev=5
seed=17300
fog=0
gbm=ptype4
gbmpal=temp
bc_race=9
flags=ag_regions_only

[physical_planet]
name=lv105_01
type=moon
size=125
techlev=10
deflev=5
seed=17400
fog=0
gbm=mtype1
gbmpal=cold
bc_race=9
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=lv105_02
type=moon
size=75
techlev=10
deflev=5
seed=17500
fog=0
gbm=mtype2
gbmpal=cold
bc_race=9
flags=no_naval_objects
flags=ag_regions_only

; ---- GAMMULA ----

[physical_planet]
name=gamma1
type=mars
size=400
techlev=10
deflev=5
seed=17600
fog=0
gbm=ptype3
gbmpal=temp
bc_race=10
flags=ag_regions_only

[physical_planet]
name=gamma2
type=desert
size=400
techlev=10
deflev=5
seed=17700
fog=0
gbm=ptype4
gbmpal=temp
bc_race=10
flags=ag_regions_only

[physical_planet]
name=gam01
type=moon
size=25
techlev=10
deflev=5
seed=17800
fog=0
gbm=mtype1
gbmpal=cold
bc_race=10
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=gam02
type=moon
size=125
techlev=10
deflev=5
seed=17900
fog=3
gbm=mtype2
gbmpal=temp
bc_race=10
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=gam03
type=moon
size=25
techlev=10
deflev=5
seed=18000
fog=4
gbm=mtype3
gbmpal=hot
bc_race=10
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=tyrinis
type=earth
size=250
techlev=10
deflev=5
seed=18100
fog=0
gbm=ptype7
gbmpal=cold
bc_race=10
flags=ag_regions_only

[physical_planet]
name=tyri01
type=moon
size=125
techlev=10
deflev=5
seed=18200
fog=2
gbm=mtype1
gbmpal=cold
bc_race=10
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=tyri02
type=moon
size=75
techlev=10
deflev=5
seed=18300
fog=0
gbm=mtype2
gbmpal=cold
bc_race=10
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=tyri03
type=moon
size=25
techlev=10
deflev=5
seed=18400
fog=0
gbm=mtype1
gbmpal=cold
bc_race=10
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=tyri04
type=moon
size=25
techlev=10
deflev=5
seed=18500
fog=0
gbm=mtype2
gbmpal=cold
bc_race=10
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=lv110
type=mars
size=300
techlev=10
deflev=5
seed=18600
fog=0
gbm=ptype5
gbmpal=hot
bc_race=10
flags=ag_regions_only

[physical_planet]
name=lv110_01
type=moon
size=25
techlev=10
deflev=5
seed=18700
fog=3
gbm=mtype1
gbmpal=cold
bc_race=10
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=lv110_02
type=moon
size=25
techlev=10
deflev=5
seed=18800
fog=3
gbm=mtype3
gbmpal=cold
bc_race=10
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=lv115
type=iceplanet
size=250
techlev=10
deflev=5
seed=18900
fog=4
gbm=ptype1
gbmpal=cold
bc_race=10
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=lv115_01
type=moon
size=25
techlev=10
deflev=5
seed=19000
fog=1
gbm=mtype4
gbmpal=cold
bc_race=10
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=lv115_02
type=moon
size=25
techlev=10
deflev=5
seed=19100
fog=3
gbm=mtype5
gbmpal=cold
bc_race=10
flags=no_naval_objects
flags=ag_regions_only

; ---- ALPHA GAMMA ----

[physical_planet]
name=chalinis
type=desert
size=100
techlev=10
deflev=5
seed=19200
fog=0
gbm=ptype2
gbmpal=hot
bc_race=10
flags=ag_regions_only

[physical_planet]
name=chal01
type=moon
size=100
techlev=10
deflev=5
seed=19300
fog=4
gbm=mtype2
gbmpal=hot
bc_race=10
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=crystar
type=mars
size=250
techlev=10
deflev=5
seed=19400
fog=0
gbm=ptype2
gbmpal=hot
bc_race=10
flags=ag_regions_only

[physical_planet]
name=cry01
type=moon
size=50
techlev=10
deflev=5
seed=19500
fog=1
gbm=mtype1
gbmpal=hot
bc_race=10
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=cry02
type=moon
size=50
techlev=10
deflev=5
seed=19600
fog=1
gbm=mtype2
gbmpal=hot
bc_race=10
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=cry03
type=moon
size=25
techlev=10
deflev=5
seed=19700
fog=0
gbm=mtype3
gbmpal=cold
bc_race=10
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=mantisi
type=barren
size=300
techlev=10
deflev=5
seed=19800
fog=0
gbm=ptype4
gbmpal=temp
bc_race=10
flags=ag_regions_only

; ---- CYRON ----

[physical_planet]
name=cyronvi
type=earth
size=250
techlev=10
deflev=5
seed=19900
fog=1
gbm=ptype7
gbmpal=temp
bc_race=8
flags=ag_regions_only

; ---- REGULUS ----

[physical_planet]
name=regisiv
type=desert
size=200
techlev=10
deflev=5
seed=20000
fog=0
gbm=ptype5
gbmpal=hot
bc_race=10
flags=ag_regions_only

[physical_planet]
name=reg01
type=moon
size=125
techlev=10
deflev=5
seed=20100
fog=0
gbm=mtype1
gbmpal=hot
bc_race=10
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=regisvi
type=earth
size=300
techlev=10
deflev=5
seed=20200
fog=0
gbm=ptype6
gbmpal=temp
bc_race=10
flags=no_naval_objects
flags=ag_regions_only

; ---------------------------------------------------------------------------
; SYRION QUADRANT
; ---------------------------------------------------------------------------

; ---- ALPHA CANIS ----

[physical_planet]
name=sarien
type=desert
size=100
techlev=10
deflev=5
seed=20300
fog=0
gbm=ptype2
gbmpal=temp
bc_race=11
flags=ag_regions_only

[physical_planet]
name=sar01
type=moon
size=125
techlev=10
deflev=5
seed=20400
fog=2
gbm=mtype1
gbmpal=cold
bc_race=11
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=sar02
type=moon
size=25
techlev=10
deflev=5
seed=20500
fog=3
gbm=mtype3
gbmpal=cold
bc_race=11
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=tarean
type=earth
size=200
techlev=10
deflev=5
seed=20600
fog=0
gbm=ptype5
gbmpal=temp
bc_race=11
flags=ag_regions_only

[physical_planet]
name=tar01
type=moon
size=125
techlev=10
deflev=5
seed=20700
fog=3
gbm=mtype1
gbmpal=temp
bc_race=11
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=lv125
type=barren
size=250
techlev=10
deflev=5
seed=20800
fog=0
gbm=ptype2
gbmpal=temp
bc_race=11
flags=ag_regions_only

[physical_planet]
name=lv125_01
type=moon
size=100
techlev=10
deflev=5
seed=20900
fog=4
gbm=mtype3
gbmpal=cold
bc_race=11
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=lv130
type=iceplanet
size=100
techlev=10
deflev=5
seed=21000
fog=2
gbm=ptype5
gbmpal=cold
bc_race=11
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=lv130_01
type=moon
size=100
techlev=10
deflev=5
seed=21100
fog=2
gbm=mtype3
gbmpal=cold
bc_race=11
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=lv130_02
type=moon
size=75
techlev=10
deflev=5
seed=21200
fog=1
gbm=mtype4
gbmpal=cold
bc_race=11
flags=no_naval_objects
flags=ag_regions_only

; ---- VEGA ERIDANI ----

[physical_planet]
name=droia
type=mars
size=200
techlev=10
deflev=5
seed=21300
fog=0
gbm=ptype2
gbmpal=temp
bc_race=11
flags=ag_regions_only

[physical_planet]
name=alteris
type=earth
size=250
techlev=10
deflev=5
seed=21400
fog=3
gbm=ptype3
gbmpal=cold
bc_race=11
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=obsidia
type=barren
size=300
techlev=10
deflev=5
seed=21500
fog=4
gbm=ptype4
gbmpal=cold
bc_race=11
flags=no_naval_objects
flags=ag_regions_only

; ---- OMEGA ERIDANI ----

[physical_planet]
name=mondial
type=volcanic
size=300
techlev=10
deflev=5
seed=21600
fog=0
gbm=ptype9
gbmpal=hot
bc_race=12
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=mon01
type=moon
size=125
techlev=10
deflev=5
seed=21700
fog=2
gbm=mtype1
gbmpal=cold
bc_race=12
flags=no_naval_objects
flags=ag_regions_only

[physical_planet]
name=ylisia
type=mars
size=200
techlev=10
deflev=5
seed=21800
fog=0
gbm=ptype1
gbmpal=temp
bc_race=12
flags=ag_regions_only

[physical_planet]
name=yli01
type=moon
size=125
techlev=10
deflev=5
seed=21900
fog=1
gbm=mtype2
gbmpal=cold
bc_race=12
flags=no_naval_objects
flags=ag_regions_only

; ---- ALPHA MAJORA ----

[physical_planet]
name=majoris
type=barren
size=400
techlev=10
deflev=5
seed=22000
fog=0
gbm=ptype1
gbmpal=temp
bc_race=12
flags=ag_regions_only

[physical_planet]
name=maj01
type=moon
size=50
techlev=10
deflev=5
seed=22100
fog=0
gbm=mtype1
gbmpal=cold
bc_race=12
flags=no_naval_objects
flags=ag_regions_only

;Supernova 10

[physical_planet]
name=strgazer
type=earth
size=300
techlev=10
deflev=5
seed=22200
fog=0
gbm=ptype1
gbmpal=temp
bc_race=13
flags=no_naval_objects
flags=ag_regions_only

; ---------------------------------------------------------------------------
; XTREME CARNAGE WORLD
; ---------------------------------------------------------------------------

[physical_planet]
;Gammulan
name=farstar
type=earth
size=100
techlev=10
deflev=5
seed=22300
fog=0
gbm=ptype3
gbmpal=temp
bc_race=10

[physical_planet]
;Gammulan
name=trion
type=mars
size=50
techlev=10
deflev=5
seed=22400
fog=0
gbm=ptype1
gbmpal=hot
bc_race=10

[physical_planet]
;Gammulan
name=Satini
type=moon
size=25
techlev=10
deflev=5
seed=22500
fog=0
gbm=mtype1
gbmpal=cold
bc_race=10
flags=no_naval_objects
flags=no_compound_objects

[physical_planet]
;Gammulan
name=HellsEye
type=iceplanet
size=150
techlev=10
deflev=5
seed=22600
fog=2
gbm=mtype1
gbmpal=cold
bc_race=10
flags=no_naval_objects
flags=no_compound_objects

; ---------------------------------------------------------------------------
; BC3K DEMO WORLD
; ---------------------------------------------------------------------------

[physical_planet]
;Terran
name=newearth
type=earth1
size=100
techlev=10
deflev=5
seed=22700
fog=0
gbm=ptype3
gbmpal=temp
bc_race=1
flags=no_autogen

[physical_planet]
;Terran
name=tyan
type=moon1
size=75
techlev=10
deflev=5
seed=22800
fog=0
gbm=mtype1
gbmpal=cold
bc_race=1
flags=no_autogen

[physical_planet]
;Empirian
name=marin
type=mars1
size=50
techlev=10
deflev=5
seed=22900
fog=0
gbm=ptype1
gbmpal=temp
bc_race=2
flags=no_autogen

[physical_planet]
;Gammulan
name=bandis
type=desert1
size=100
techlev=10
deflev=5
seed=23000
fog=0
gbm=mtype3
gbmpal=temp
bc_race=10
flags=no_autogen

[physical_planet]
;Gammulan
name=baydan
type=volcanic1
size=25
techlev=10
deflev=5
seed=23100
fog=0
gbm=ptype1
gbmpal=hot
bc_race=10
flags=no_autogen

[physical_planet]
;Vesperon
name=zendis
type=iceplanet1
size=100
techlev=10
deflev=5
seed=23200
fog=4
gbm=ptype1
gbmpal=cold
bc_race=3
flags=no_autogen

; ---------------------------------------------------------------------------
; Include Section
; ---------------------------------------------------------------------------

[include]
file=objects

[include]
file=ptypes

[include]
file=textures

[end]
; -----------------------------------------------------------------------------
; PTYPES.CFG
; -----------------------------------------------------------------------------
; PTE configuration file: TYPES Section (Planet/Climate Types)
;
; Rev. 1.1
;
; (c) 3000AD 1995
; -----------------------------------------------------------------------------


; -------------------------------------------
; definitions for planet TYPE: "earth"
; -------------------------------------------

[planet]
type=earth              ; the type name
climate=arctic
climate=moderate        ; one of the climate zones present on this planet
climate=hot
climate=desert          ; another climate
map=map00001              
map=map00002              
map=map00003              
map=map00004
map=map00005              
map=map00006              
map=map00007
map=map00008
map=map00009
map=map00010              
map=map00011
map=map00012             
map=map00013             
map=map00014
map=map00015
map=map00016

[climate]
planet=earth
type=arctic
palette=er_arc
rock=snw03a
soil=snw02a
vegetation=snw01a
water=wtr05a

[climate]
planet=earth            ; this defines this climate for planet type earth
type=moderate           ; name of the climate
palette=er_mod
rock=rck01a             ; the four basic textures
soil=clf01a
vegetation=veg08a
water=wtr05a

[climate]
planet=earth            
type=hot           
palette=er_hot
rock=clf03a             
soil=dst02a
vegetation=veg05a
water=wtr05a

[climate]
planet=earth
type=desert
palette=er_des
rock=clf03a
soil=veg08a
vegetation=dst02a
water=wtr05a

; -------------------------------------------
; definitions for planet TYPE: "mars"
; -------------------------------------------

[planet]
type=mars        
climate=mars_1   
climate=mars_2   
map=map00017      
map=map00018              
map=map00019
map=map00020
map=map00021              
map=map00022              
map=map00023
map=map00024
map=map00025
map=map00026
map=map00027
map=map00028              
map=map00029              
map=map00030
map=map00031
map=map00032

[climate]
planet=mars       
type=mars_1
palette=ma_std
rock=mnt02a             
soil=clf01a
vegetation=mon05a
water=mon03a

[climate]
planet=mars
type=mars_2
palette=ma_std
rock=mnt04a
soil=mnt02a
vegetation=snw02a
water=mon03a


; -------------------------------------------
; definitions for planet TYPE: moon
; -------------------------------------------

[planet]
type=moon
climate=standard_moon
map=map00033              
map=map00034              
map=map00035
map=map00036
map=map00037              
map=map00038              
map=map00039
map=map00040
map=map00041
map=map00042
map=map00043
map=map00044              
map=map00045              
map=map00046
map=map00047
map=map00048

[climate]
planet=moon
type=standard_moon
palette=mo_std
rock=mnt04a
soil=mon03a
vegetation=mon07a
water=mon04a

; -------------------------------------------
; definitions for planet TYPE: "barren"
; -------------------------------------------

[planet]
type=barren              
climate=arctic
climate=moderate
climate=desert
map=map00049              
map=map00050              
map=map00051              
map=map00052
map=map00053              
map=map00054              
map=map00055
map=map00056
map=map00057
map=map00058              
map=map00059
map=map00060             
map=map00061             
map=map00062
map=map00063
map=map00064

[climate]
planet=barren
type=arctic
palette=er_arc
rock=snw03a
soil=snw02a
vegetation=snw01a
water=snw01a

[climate]
planet=barren
type=moderate
palette=barren
rock=mon01a
soil=mon08a
vegetation=mon06a
water=wtr05a

[climate]
planet=barren
type=desert
palette=er_des
rock=mon01a
soil=mon08a
vegetation=dst02a
water=mon02a


; -------------------------------------------
; definitions for planet TYPE: desert 
; -------------------------------------------

[planet]
type=desert
climate=desert_1
climate=desert_2
map=map00065              
map=map00066              
map=map00067
map=map00068
map=map00069              
map=map00070              
map=map00071
map=map00072
map=map00073
map=map00074
map=map00075              
map=map00076              
map=map00077
map=map00078
map=map00079
map=map00080

[climate]
planet=desert
type=desert_1
palette=er_des
rock=clf03a
soil=veg08a
vegetation=dst02a
water=wtr05a

[climate]
planet=desert
type=desert_2
palette=er_des
rock=dst02a
soil=dst02a
vegetation=mon08a
water=dst02a

; -------------------------------------------
; definitions for planet TYPE: "volcanic"
; -------------------------------------------

[planet]
type=volcanic              
climate=volcanic
map=map00081              
map=map00082              
map=map00083
map=map00084              
map=map00085              
map=map00086
map=map00087
map=map00088
map=map00089              
map=map00090
map=map00091             
map=map00092             
map=map00093
map=map00094
map=map00095
map=map00096

[climate]
planet=volcanic
type=volcanic
palette=volcanic
rock=mnt04a
soil=mnt02a
vegetation=lva03a
water=mon03a

; -------------------------------------------
; definitions for planet TYPE: iceplanet 
; -------------------------------------------

[planet]
type=iceplanet
climate=frozen
map=map00097              
map=map00098
map=map00099
map=map00100
map=map00101              
map=map00102              
map=map00103
map=map00104
map=map00105
map=map00106
map=map00107
map=map00108              
map=map00109              
map=map00110
map=map00111
map=map00112

[climate]
planet=iceplanet
type=frozen
palette=er_arc
rock=snw03a
soil=snw02a
vegetation=snw01a
water=snw01a

; ----------------------------------------------------
;      Special set of ptype definitions for Demo
;      using only on set of 16 maps for all types
; ----------------------------------------------------

; -------------------------------------------
; definitions for planet TYPE: "earth1"
; -------------------------------------------

[planet]
type=earth1             
climate=arctic
climate=moderate       
climate=hot
climate=desert         
map=map00001              
map=map00002              
map=map00003              
map=map00004
map=map00005              
map=map00006              
map=map00007
map=map00008
map=map00009
map=map00010              
map=map00011
map=map00012             
map=map00013             
map=map00014
map=map00015
map=map00016

[climate]
planet=earth1
type=arctic
palette=er_arc
rock=snw03a
soil=snw02a
vegetation=snw01a
water=wtr05a

[climate]
planet=earth1
type=moderate
palette=er_mod
rock=rck01a  
soil=clf01a
vegetation=veg08a
water=wtr05a

[climate]
planet=earth1            
type=hot           
palette=er_hot
rock=clf03a             
soil=dst02a
vegetation=veg05a
water=wtr05a

[climate]
planet=earth1
type=desert
palette=er_des
rock=clf03a
soil=veg08a
vegetation=dst02a
water=wtr05a

; -------------------------------------------
; definitions for planet TYPE: "mars1"
; -------------------------------------------

[planet]
type=mars1        
climate=mars_1   
climate=mars_2   
map=map00001              
map=map00002              
map=map00003              
map=map00004
map=map00005              
map=map00006              
map=map00007
map=map00008
map=map00009
map=map00010              
map=map00011
map=map00012             
map=map00013             
map=map00014
map=map00015
map=map00016

[climate]
planet=mars1       
type=mars_1
palette=ma_std
rock=mnt02a             
soil=clf01a
vegetation=mon05a
water=mon03a

[climate]
planet=mars1
type=mars_2
palette=ma_std
rock=mnt04a
soil=mnt02a
vegetation=snw02a
water=mon03a

; -------------------------------------------
; definitions for planet TYPE: moon1
; -------------------------------------------

[planet]
type=moon1
climate=standard_moon
map=map00001              
map=map00002              
map=map00003              
map=map00004
map=map00005              
map=map00006              
map=map00007
map=map00008
map=map00009
map=map00010              
map=map00011
map=map00012             
map=map00013             
map=map00014
map=map00015
map=map00016

[climate]
planet=moon1
type=standard_moon
palette=mo_std
rock=mnt04a
soil=mon03a
vegetation=mon07a
water=mon04a

; -------------------------------------------
; definitions for planet TYPE: "barren1"
; -------------------------------------------

[planet]
type=barren1              
climate=arctic
climate=moderate
climate=desert
map=map00001              
map=map00002              
map=map00003              
map=map00004
map=map00005              
map=map00006              
map=map00007
map=map00008
map=map00009
map=map00010              
map=map00011
map=map00012             
map=map00013             
map=map00014
map=map00015
map=map00016

[climate]
planet=barren1
type=arctic
palette=er_arc
rock=snw03a
soil=snw02a
vegetation=snw01a
water=snw01a

[climate]
planet=barren1
type=moderate
palette=barren
rock=mon01a
soil=mon08a
vegetation=mon06a
water=wtr05a

[climate]
planet=barren1
type=desert
palette=er_des
rock=mon01a
soil=mon08a
vegetation=dst02a
water=mon02a


; -------------------------------------------
; definitions for planet TYPE: desert1 
; -------------------------------------------

[planet]
type=desert1
climate=desert_1
climate=desert_2
map=map00001              
map=map00002              
map=map00003              
map=map00004
map=map00005              
map=map00006              
map=map00007
map=map00008
map=map00009
map=map00010              
map=map00011
map=map00012             
map=map00013             
map=map00014
map=map00015
map=map00016

[climate]
planet=desert1
type=desert_1
palette=er_des
rock=clf03a
soil=veg08a
vegetation=dst02a
water=wtr05a

[climate]
planet=desert1
type=desert_2
palette=er_des
rock=dst02a
soil=dst02a
vegetation=mon08a
water=dst02a

; -------------------------------------------
; definitions for planet TYPE: "volcanic1"
; -------------------------------------------

[planet]
type=volcanic1              
climate=volcanic
map=map00001              
map=map00002              
map=map00003              
map=map00004
map=map00005              
map=map00006              
map=map00007
map=map00008
map=map00009
map=map00010              
map=map00011
map=map00012             
map=map00013             
map=map00014
map=map00015
map=map00016

[climate]
planet=volcanic1
type=volcanic
palette=volcanic
rock=mnt04a
soil=mnt02a
vegetation=lva03a
water=mon03a

; -------------------------------------------
; definitions for planet TYPE: "iceplanet1" 
; -------------------------------------------

[planet]
type=iceplanet1
climate=frozen
map=map00001              
map=map00002              
map=map00003
map=map00004
map=map00005              
map=map00006              
map=map00007
map=map00008
map=map00009
map=map00010              
map=map00011
map=map00012             
map=map00013             
map=map00014
map=map00015
map=map00016

[climate]
planet=iceplanet1
type=frozen
palette=er_arc
rock=snw03a
soil=snw02a
vegetation=snw01a
water=snw01a

[end]
; -----------------------------------------------------------------------------
; PTYPES.CFG
; -----------------------------------------------------------------------------
; PTE configuration file: TEXTURES Section
;
; Rev. 1.0
;
; (c) 3000AD 1995
; -----------------------------------------------------------------------------


;
; ---------------------------------------------------------------------------
; Texture Definitions
; ---------------------------------------------------------------------------
; required items: name, at least one colour base and mapto entry
; Note: each base and its mapto entry have to follow directly after each other
; Valid keywords for mapto are: grey, green, brown, blue, red

;

[texture]
name=clf01a              ;main texture
base=112
mapto=brown
transition=clf01a

[texture]
name=clf01b              ;main texture
base=48
mapto=grey
transition=clf01b

[texture]
name=clf02a              ;main texture
base=144
mapto=grey
transition=clf02a

[texture]
name=clf02b              ;main texture
base=64
mapto=red
transition=clf02b

[texture]
name=clf03a              ;main texture
base=144
mapto=grey
transition=clf03a

[texture]
name=dst01a              ;main texture
base=112
mapto=brown
transition=dst01a

[texture]
name=dst02a              ;main texture
base=112
mapto=brown
transition=dst02a


; LAVA textures: don't worry about strange mapto entries
; again the palette used is totally non-standard

[texture]
name=lva01a
base=64
mapto=red
transition=lva01a

[texture]
name=lva02a
base=144
mapto=red
transition=lva02a

[texture]
name=lva02b
base=144
mapto=red
transition=lva02b

[texture]
name=lva03a
base=64
mapto=red
transition=lva03a

; MOON textures

[texture]
name=mon01a              ;main texture
base=112
mapto=grey
transition=mon01a

[texture]
name=mon02a              ;main texture
base=112
mapto=grey
transition=mon02a

[texture]
name=mon03a              ;main texture
base=144
mapto=green              ; special case: the green ramp in ptepal3 is a
reversed
transition=mon03a        ; grey ramp

[texture]
name=mon04a              ;main texture
base=144
mapto=green              ; special case: the green ramp in ptepal3 is a
reversed
transition=mon04a        ; grey ramp

[texture]
name=mon05a              ;main texture
base=64
mapto=brown
transition=mon05a

[texture]
name=mon06a              ;main texture
base=64
mapto=green
transition=mon06a

[texture]
name=mon07a              ;main texture
base=64
mapto=green              ; special case: the green ramp in ptepal3 is a
reversed
transition=mon07a        ; grey ramp

[texture]
name=mon08a              ;main texture
base=144
mapto=brown
transition=mon08a

[texture]
name=mnt01a              ;main texture
base=32
mapto=grey
transition=mnt01a

[texture]
name=mnt02a              ;main texture
base=112
mapto=green
transition=mnt02a

[texture]
name=mnt03a              ;main texture
base=144
mapto=green              ; special case: the green ramp in ptepal3 is a
reversed
transition=mnt03a        ; grey ramp

[texture]
name=mnt04a              ;main texture
base=144
mapto=green
transition=mnt04a

[texture]
name=mnt04b              ;main texture
base=112
mapto=brown
transition=mnt04b

[texture]
name=rck01a              ;main texture
base=112
mapto=grey
transition=rck01a

[texture]
name=rck01b              ;main texture
base=144
mapto=grey
transition=rck01b

[texture]
name=rck02a              ;main texture
base=112
mapto=brown
transition=rck02a

[texture]
name=snw01a              ;main texture
base=144
mapto=green
transition=snw01a

[texture]
name=snw02a              ;main texture
base=144
mapto=brown
transition=snw02a

[texture]
name=snw03a              ;main texture
base=144
mapto=grey
transition=snw03a

[texture]
name=veg01a              ;main texture
base=96
mapto=green
transition=veg01a

[texture]
name=veg01b              ;main texture
base=96
mapto=green
base=104
mapto=blue
transition=veg01b

[texture]
name=veg02a              ;main texture
base=96
mapto=green
base=104
mapto=blue
transition=veg02a

[texture]
name=veg03a              ;main texture
base=96
mapto=green
base=104
mapto=blue
transition=veg03a

[texture]
name=veg04a              ;main texture
base=96
mapto=green
base=104
mapto=blue
transition=veg04a

[texture]
name=veg05a              ;main texture
base=96
mapto=green
base=104
mapto=brown
transition=veg05a

[texture]
name=veg05b              ;main texture
base=96
mapto=green
base=104
mapto=blue
transition=veg05b

[texture]
name=veg06a              ;main texture
base=96
mapto=green
base=104
mapto=blue
transition=veg06a

[texture]
name=veg07a              ;main texture
base=96
mapto=green
base=104
mapto=blue
transition=veg07a

[texture]
name=veg08a              ;main texture
base=96
mapto=green
base=104
mapto=blue
transition=veg08a

[texture]
name=wtr01a              ;main texture-no transitions
base=104
mapto=blue

[texture]
name=wtr02a              ;main texture-no transitions
base=104
mapto=blue

[texture]
name=wtr03a              ;main texture-no transitions
base=104
mapto=blue

[texture]
name=wtr04a              ;main texture-no transitions
base=104
mapto=blue

[texture]
name=wtr05a              ;main texture-no transitions
base=104
mapto=blue

[texture]
name=wtr06a              ;main texture-no transitions
base=64
mapto=red

[texture]
name=wtr07a              ;main texture-no transitions
base=144
mapto=grey


[dummy]                  ; foreign entry for testing
dummy_value=IdontKnow
dummy2=super_dummy
dummy3=WellYouGuessedIt:MegaDummy


; ---- SPECIAL TEXTURES --------------------------------------------------

[texture]
id=1024         ; must be the first entry for a special_texture
name=site01a
base=128
mapto=grey

[texture]
id=1025
name=site02a
base=112
mapto=grey

[texture]
id=1026
name=site03a
base=144
mapto=grey

[texture]
id=1027
name=site04a
base=48
mapto=grey
base=96
mapto=green

[texture]
id=1028
name=site05a
base=144
mapto=grey
base=96
mapto=green

[texture]
id=1029
name=site05b
base=144
mapto=grey

[texture]
id=1030
name=site06a
base=144
mapto=grey
base=112
mapto=brown

[texture]
id=1031
name=site07a
base=144
mapto=grey

[texture]
id=1032
name=site08a
base=144
mapto=grey

[texture]
id=1033
name=site09a
base=144
mapto=grey
base=112
mapto=brown

[texture]
id=1034
name=site10a
base=32
mapto=grey

[texture]
id=1035
name=site11a
base=32
mapto=grey

[texture]
id=1036
name=site12a
base=32
mapto=grey
base=128
mapto=brown

[texture]
id=1037
name=site13a
base=32
mapto=grey
base=128
mapto=brown
base=96
mapto=green

[texture]
id=1038
name=site14a
base=32
mapto=grey
base=128
mapto=brown
base=96
mapto=green

[texture]
id=1039
name=site15a
base=32
mapto=grey
base=128
mapto=brown
base=96
mapto=green

[texture]
id=1040
name=site16a
base=32
mapto=grey
base=128
mapto=brown
base=96
mapto=green

[texture]
id=1041
name=site17a
base=16
mapto=grey
base=128
mapto=brown

[texture]
id=2048
name=site99a
base=0
mapto=grey
base=16
mapto=blue
base=32
mapto=brown
base=48
mapto=green
size=8
scale=1

[texture]
id=2049
name=site99b
base=0
mapto=grey
base=16
mapto=blue
base=32
mapto=brown
base=48
mapto=green
size=7
scale=1

[end]
; -----------------------------------------------------------------------------
; OBJECTS.CFG
; -----------------------------------------------------------------------------
; PTE configuration file: OBJECTS Section
;
; Rev. 1.2
;
; (c) 3000AD 1995-96
; -----------------------------------------------------------------------------

;site_tx = params. Texture id obtained from TEXTURES.CFG

;1024= site01a
;1025= site02a
;1026= site03a
;1027= site04a
;1028= site05a
;1029= site05b
;1030= site06a
;1031= site07a
;1032= site08a
;1033= site09a
;1034= site10a
;1035= site11a
;1036= site12a
;1037= site13a
;1038= site14a
;1039= site15a
;1040= site16a
;1041= site17a
;2048= site99a
;2049= site99b

;class= params for autogeneration

;compound  - non ai collection of objects
;static    - non ai single object
;dynamic   - ai surface object
;airborne  - same as 'dynamic' but airborne
;nfleet    - same as 'dynamic' but seaborne

;techlev= params

;flags= params for autogeneration

;no_autogen - prevents AG from generating 'this' compound object

; ----- COMPOUND Objects ------------------------------------------------------

[object]
type_id=1
type=city1
techlev=1
class=compound
site_tx=1034

extents=-434407 451668 -448838 439874 0 0 886075 888712 0
[object]
type_id=2
type=city2
techlev=1
class=compound
site_tx=2048

extents=-440042 421165 -431380 447639 0 0 861207 879019 0
[object]
type_id=3
type=city3
techlev=1
class=compound
site_tx=1036

extents=-429472 492913 -447591 442324 0 0 922385 889915 0
[object]
type_id=4
type=city4
techlev=1
class=compound
site_tx=1037

extents=-429472 492913 -447591 442324 0 0 922385 889915 0
[object]
type_id=5
type=city5
techlev=1
class=compound
site_tx=1038

extents=-429472 492913 -447591 442324 0 0 922385 889915 0
[object]
type_id=6
type=city6
techlev=1
class=compound
site_tx=1039

extents=-429472 492913 -447591 442324 0 0 922385 889915 0
[object]
type_id=7
type=city7
techlev=1
class=compound
site_tx=1040

extents=-429472 492913 -447591 442324 0 0 922385 889915 0
[object]
type_id=8
type=city8
techlev=1
class=compound
site_tx=1041

extents=-440042 421165 -431380 447639 0 0 861207 879019 0
[object]
type_id=9
type=fact1
techlev=1
class=compound
site_tx=1028

extents=-491948 -46123 -367724 -39993 0 0 445825 327731 0
[object]
type_id=10
type=fact2
techlev=1
class=compound
site_tx=1028

extents=-501180 -209598 -367724 -80410 0 0 291582 287314 0
[object]
type_id=11
type=fact3
techlev=1
class=compound
site_tx=1029

extents=-491948 -46123 -367724 -39993 0 0 445825 327731 0
[object]
type_id=12
type=fact4
techlev=1
class=compound
site_tx=1029

extents=-491948 -46123 -367724 -39993 0 0 445825 327731 0
[object]
type_id=13
type=fact5
techlev=1
class=compound
site_tx=1040

extents=-491948 -46123 -367724 -39993 0 0 445825 327731 0
[object]
type_id=14
type=fact6
techlev=1
class=compound
site_tx=1040

extents=-501180 -209598 -367724 -80410 0 0 291582 287314 0
[object]
type_id=15
type=fact7
techlev=1
class=compound
site_tx=1040

extents=-501180 -209598 -367724 -80410 0 0 291582 287314 0
[object]
type_id=16
type=fact8
techlev=1
class=compound
site_tx=1040

extents=-501180 -209598 -367724 -80410 0 0 291582 287314 0
[object]
type_id=17
type=milbse1
techlev=1
class=compound
site_tx=1034

extents=-402889 393270 -354769 323258 0 0 796159 678027 0
[object]
type_id=18
type=milbse2
techlev=1
class=compound
site_tx=1035

extents=-402889 393270 -354769 323258 0 0 796159 678027 0
[object]
type_id=19
type=milbse3
techlev=1
class=compound
site_tx=1036

extents=-402889 393270 -354769 323258 0 0 796159 678027 0
[object]
type_id=20
type=milbse4
techlev=1
class=compound
site_tx=1034

extents=-402889 393270 -354769 323258 0 0 796159 678027 0
[object]
type_id=21
type=milbse5
techlev=1
class=compound
site_tx=1035

extents=-402889 393270 -354769 323258 0 0 796159 678027 0
[object]
type_id=22
type=milbse6
techlev=1
class=compound
site_tx=1036

extents=-402889 393270 -354769 323258 0 0 796159 678027 0
[object]
type_id=23
type=milbse7
techlev=1
class=compound
site_tx=1034

extents=-402889 393270 -354769 323258 0 0 796159 678027 0
[object]
type_id=24
type=milbse8
techlev=1
class=compound
site_tx=1035

extents=-402889 393270 -354769 323258 0 0 796159 678027 0
[object]
type_id=25
type=navbse1
techlev=1
class=compound
site_tx=1034

extents=-492086 468484 -479241 301685 0 147 960570 780926 147
[object]
type_id=26
type=navbse2
techlev=1
class=compound
site_tx=1035

extents=-492086 468484 -479241 301685 0 147 960570 780926 147
[object]
type_id=27
type=navbse3
techlev=1
class=compound
site_tx=1036

extents=-492086 468484 -479241 301685 0 147 960570 780926 147
[object]
type_id=28
type=navbse4
techlev=1
class=compound
site_tx=1034

extents=-492086 468484 -479241 301685 0 147 960570 780926 147
[object]
type_id=29
type=navbse5
techlev=1
class=compound
site_tx=1035

extents=-492086 468484 -479241 301685 0 147 960570 780926 147
[object]
type_id=30
type=navbse6
techlev=1
class=compound
site_tx=1036

extents=-492086 468484 -479241 301685 0 147 960570 780926 147
[object]
type_id=31
type=navbse7
techlev=1
class=compound
site_tx=1034

extents=-492086 468484 -479241 301685 0 147 960570 780926 147
[object]
type_id=32
type=navbse8
techlev=1
class=compound
site_tx=1035

extents=-481520 399939 -480639 352822 -6870662 1 881459 833461 6870663
[object]
type_id=34
type=nuplant1
techlev=1
class=compound
site_tx=1034

extents=-136424 129778 -86668 131139 -3434308 0 266202 217807 3434308
[object]
type_id=35
type=soplant1
techlev=1
class=compound
site_tx=1035

extents=-192398 212286 -111249 161135 0 70 404684 272384 70
[object]
type_id=36
type=wplant1
techlev=1
class=compound
site_tx=1034

extents=-15473 96925 -33754 27472 0 0 112398 61226 0

; ---- STATIC Objects --------------------------------------------------------

[object]
type_id=37
type=bldg1
techlev=1
class=static

extents=-151460 151460 -148576 154345 0 7494 302920 302921 7494
[object]
type_id=38
type=bldg2
techlev=1
class=static

extents=-110734 110734 -109780 111689 0 5590 221468 221469 5590
[object]
type_id=39
type=bldg3
techlev=1
class=static

extents=-65965 58457 -62211 62211 0 4990 124422 124422 4990
[object]
type_id=40
type=bldg4
techlev=1
class=static

extents=-62147 59065 -56497 64714 0 5336 121212 121211 5336
[object]
type_id=41
type=bldg5
techlev=1
class=static

extents=-64153 60047 -59021 65180 0 4951 124200 124201 4951
[object]
type_id=42
type=bldg6
techlev=1
class=static

extents=-70060 67416 -66095 71382 0 6688 137476 137477 6688
[object]
type_id=43
type=bldg7
techlev=1
class=static

extents=-47973 45657 -44517 49113 0 4193 93630 93630 4193
[object]
type_id=44
type=bldg8
techlev=1
class=static

extents=-75300 68516 -69873 73943 0 3089 143816 143816 3089
[object]
type_id=45
type=bldg9
techlev=1
class=static

extents=-75104 70482 -47758 49298 0 4001 145586 97056 4001
[object]
type_id=46
type=bldg10
techlev=1
class=static

extents=-35409 30841 -31412 34838 0 2967 66250 66250 2967
[object]
type_id=47
type=bldg11
techlev=1
class=static

extents=-49465 45907 -46974 48398 0 1301 95372 95372 1301
[object]
type_id=48
type=bldg12
techlev=1
class=static

extents=-80900 86892 -78902 88890 0 1316 167792 167792 1316
[object]
type_id=49
type=bldg13
techlev=1
class=static

extents=-75906 77903 -73908 79901 0 1823 153809 153809 1823
[object]
type_id=50
type=bldg14
techlev=1
class=static

extents=-102873 100875 -96880 106868 0 984 203748 203748 984
[object]
type_id=51
type=bldg15
techlev=1
class=static

extents=-98878 92885 -95881 95881 0 2684 191763 191762 2684
[object]
type_id=108
type=bldg16
techlev=1
class=static

extents=-86892 88890 -85894 89889 0 1085 175782 175783 1085
[object]
type_id=52
type=bldg17
techlev=1
class=static

extents=-87018 87766 -86043 88740 0 1544 174784 174783 1544
[object]
type_id=53
type=bldg18
techlev=1
class=static

extents=-135958 136706 -131487 141176 0 1333 272664 272663 1333
[object]
type_id=54
type=bldg19
techlev=1
class=static

extents=-60801 61048 -59161 62688 0 3089 121849 121849 3089
[object]
type_id=55
type=bldg20
techlev=1
class=static

extents=-59803 60048 -58025 61826 0 1244 119851 119851 1244
[object]
type_id=56
type=twr1
techlev=1
class=static

extents=-107744 80024 -93981 93787 0 10432 187768 187768 10432
[object]
type_id=57
type=twr2
techlev=1
class=static

extents=-49815 52058 -51034 50840 0 8517 101873 101874 8517
[object]
type_id=58
type=twr3
techlev=1
class=static

extents=-48817 47064 -47039 48842 0 8741 95881 95881 8741
[object]
type_id=59
type=twr4
techlev=1
class=static

extents=-89159 74048 -81604 81604 0 7851 163207 163208 7851
[object]
type_id=60
type=twr5
techlev=1
class=static

extents=-54766 53100 -54236 53630 0 5282 107866 107866 5282
[object]
type_id=61
type=factry1
techlev=1
class=static

extents=-42705 40542 -39191 44056 0 511 83247 83247 511
[object]
type_id=62
type=factry2
techlev=1
class=static

extents=-66904 64379 -61013 70270 0 650 131283 131283 650
[object]
type_id=63
type=factry3
techlev=1
class=static

extents=-66720 81547 -68573 79693 0 658 148267 148266 658
[object]
type_id=64
type=factry4
techlev=1
class=static

extents=-154008 156119 -144515 165612 0 902 310127 310127 902
[object]
type_id=65
type=factry5
techlev=1
class=static

extents=-83536 84607 -88891 79252 0 758 168143 168143 758
[object]
type_id=66
type=nplant
techlev=1
class=static

extents=-176420 151915 -173968 154366 0 1591 328335 328334 1591
[object]
type_id=67
type=splant
techlev=1
class=static

extents=-76423 76424 -79845 73001 0 340 152847 152846 340
[object]
type_id=68
type=punit
techlev=1
class=static

extents=-50158 47516 -47956 49718 0 1069 97674 97674 1069
[object]
type_id=69
type=pgen
techlev=1
class=static

extents=-61999 61030 -78144 85894 0 659 123029 164038 659
[object]
type_id=70
type=tank
techlev=1
class=static

extents=-25174 24039 -21767 27445 0 483 49213 49212 483
[object]
type_id=71
type=ftank
techlev=1
class=static

extents=-28068 28068 -28588 27548 0 307 56136 56136 307
[object]
type_id=72
type=adump
techlev=1
class=static

extents=-57725 62126 -74366 70455 0 159 119851 144821 159
[object]
type_id=73
type=bunker
techlev=1
class=static

extents=-50009 49868 -48537 51339 0 550 99877 99876 550
[object]
type_id=74
type=lpad
techlev=1
class=static

extents=-38400 39217 -48613 52291 0 267 77617 100904 267
[object]
type_id=75
type=comctr1
techlev=1
class=static

extents=-107533 109087 -108306 108314 0 1933 216620 216620 1933
[object]
type_id=76
type=comctr2
techlev=1
class=static

extents=-62000 65937 -62491 65446 0 2203 127937 127937 2203
[object]
type_id=77
type=resctr1
techlev=1
class=static

extents=-88927 82459 -87848 83538 0 1040 171386 171386 1040
[object]
type_id=78
type=cc1
techlev=1
class=static

extents=-117226 117230 -116189 118267 0 1609 234456 234456 1609
[object]
type_id=79
type=cc2
techlev=1
class=static

extents=-210506 207164 -207163 215519 0 1243 417670 422682 1243
[object]
type_id=80
type=hq1
techlev=1
class=static

extents=-159376 172883 -212050 217455 0 1035 332259 429505 1035
[object]
type_id=81
type=hq2
techlev=1
class=static

; ---- STARBASES (special case COMPOUND Objects --------------------------------

extents=-92778 93538 -96579 113311 0 1159 186316 209890 1159
[object]
type_id=82
type=strbse1
techlev=1
class=compound
site_tx=1034
flags=no_autogen

extents=-215076 195702 -199513 219195 0 0 410778 418708 0
[object]
type_id=83
type=strbse2
techlev=1
class=compound
site_tx=1035
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=84
type=strbse3
techlev=1
class=compound
site_tx=1036
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=85
type=strbse4
techlev=1
class=compound
site_tx=1034
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=86
type=strbse5
techlev=1
class=compound
site_tx=1035
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=87
type=strbse6
techlev=1
class=compound
site_tx=1036
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=88
type=strbse7
techlev=1
class=compound
site_tx=1034
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=89
type=strbse8
techlev=1
class=compound
site_tx=1035
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=33
type=strbse9
techlev=1
class=compound
site_tx=1036
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=90
type=strbse10
techlev=1
class=compound
site_tx=1034
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=91
type=strbse11
techlev=1
class=compound
site_tx=1035
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=92
type=strbse12
techlev=1
class=compound
site_tx=1036
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=93
type=strbse13
techlev=1
class=compound
site_tx=1034
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=94
type=strbse14
techlev=1
class=compound
site_tx=1035
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=95
type=strbse15
techlev=1
class=compound
site_tx=1036
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=96
type=strbse16
techlev=1
class=compound
site_tx=1034
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=97
type=strbse17
techlev=1
class=compound
site_tx=1035
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=98
type=strbse18
techlev=1
class=compound
site_tx=1034
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=99
type=strbse19
techlev=1
class=compound
site_tx=1035
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=100
type=strbse20
techlev=1
class=compound
site_tx=1036
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=101
type=strbse21
techlev=1
class=compound
site_tx=1034
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=102
type=strbse22
techlev=1
class=compound
site_tx=1035
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=103
type=strbse23
techlev=1
class=compound
site_tx=1036
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=104
type=strbse24
techlev=1
class=compound
site_tx=1034
flags=no_autogen

extents=-215076 195702 -199513 219195 -842 0 410778 418708 842
[object]
type_id=105
type=strbse25
techlev=1
class=compound
site_tx=1035
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=106
type=strbse26
techlev=1
class=compound
site_tx=1036
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=107
type=strbse27
techlev=1
class=compound
site_tx=1034
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=109
type=strbse28
techlev=1
class=compound
site_tx=1035
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=110
type=strbse29
techlev=1
class=compound
site_tx=1036
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=111
type=strbse30
techlev=1
class=compound
site_tx=1034
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=112
type=strbse31
techlev=1
class=compound
site_tx=1035
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=113
type=strbse32
techlev=1
class=compound
site_tx=1036
flags=no_autogen

extents=-215076 195702 -199513 219195 0 15 410778 418708 15
[object]
type_id=114
type=strbse33
techlev=1
class=compound
site_tx=1034
flags=no_autogen

extents=-215076 195702 -199513 219195 0 15 410778 418708 15
[object]
type_id=115
type=strbse34
techlev=1
class=compound
site_tx=1035
flags=no_autogen

extents=-215076 195702 -199513 219195 0 73 410778 418708 73
[object]
type_id=116
type=strbse35
techlev=1
class=compound
site_tx=1036
flags=no_autogen

extents=-215076 195702 -199513 219195 0 15 410778 418708 15
[object]
type_id=117
type=strbse36
techlev=1
class=compound
site_tx=1034
flags=no_autogen

extents=-215076 195702 -199513 219195 0 44 410778 418708 44
[object]
type_id=118
type=strbse37
techlev=1
class=compound
site_tx=1035
flags=no_autogen

extents=-215076 195702 -199513 219195 0 15 410778 418708 15
[object]
type_id=119
type=strbse38
techlev=1
class=compound
site_tx=1036
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=120
type=strbse39
techlev=1
class=compound
site_tx=1034
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=121
type=strbse40
techlev=1
class=compound
site_tx=1035
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=122
type=strbse41
techlev=1
class=compound
site_tx=1036
flags=no_autogen

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=123
type=strbse42
techlev=1
class=compound
site_tx=1034
flags=no_autogen

; ---- STARBASES (special case STATIC Objects ----------------------------------

extents=-215076 195702 -199513 219195 0 31 410778 418708 31
[object]
type_id=124
type=earthb
techlev=1
class=static
flags=no_autogen

extents=-523639 390588 -352691 358472 -4 1801 914227 711163 1805
[object]
type_id=125
type=marsb
techlev=1
class=static
flags=no_autogen

extents=-371739 334564 -322948 376386 0 7178 706303 699334 7178
[object]
type_id=126
type=centrisb
techlev=1
class=static
flags=no_autogen

extents=-407758 271106 -354861 326208 -3 6042 678864 681069 6045
[object]
type_id=127
type=varaxb
techlev=1
class=static
flags=no_autogen

extents=-305505 286729 -296969 279904 -4 3562 592234 576873 3566
[object]
type_id=128
type=tramisb
techlev=1
class=static
flags=no_autogen

extents=-227613 233268 -238924 221957 -9 1944 460881 460881 1953
[object]
type_id=129
type=syganb
techlev=1
class=static
flags=no_autogen

extents=-349801 361362 -352691 358472 -4 1801 711163 711163 1805
[object]
type_id=130
type=lyriusb
techlev=1
class=static
flags=no_autogen

extents=-371739 334564 -322948 376386 0 7178 706303 699334 7178
[object]
type_id=131
type=badranb
techlev=1
class=static
flags=no_autogen

extents=-407758 271106 -354861 326208 -3 6042 678864 681069 6045
[object]
type_id=132
type=frellisb
techlev=1
class=static
flags=no_autogen

extents=-305505 286729 -296969 279904 -4 3562 592234 576873 3566
[object]
type_id=133
type=xylanb
techlev=1
class=static
flags=no_autogen

extents=-227613 233268 -238924 221957 -9 1944 460881 460881 1953
[object]
type_id=134
type=caronb
techlev=1
class=static
flags=no_autogen

extents=-349801 361362 -352691 358472 -4 1801 711163 711163 1805
[object]
type_id=135
type=polar1b
techlev=1
class=static
flags=no_autogen

extents=-371739 334564 -322948 376386 0 7178 706303 699334 7178
[object]
type_id=136
type=eltinb
techlev=1
class=static
flags=no_autogen

extents=-407758 271106 -354861 326208 -3 6042 678864 681069 6045
[object]
type_id=137
type=actisvb
techlev=1
class=static
flags=no_autogen

extents=-305505 286729 -296969 279904 -4 3562 592234 576873 3566
[object]
type_id=138
type=trenisb
techlev=1
class=static
flags=no_autogen

extents=-227613 233268 -238924 221957 -9 1944 460881 460881 1953
[object]
type_id=139
type=belinb
techlev=1
class=static
flags=no_autogen

extents=-349801 361362 -352691 358472 -4 1801 711163 711163 1805
[object]
type_id=140
type=scorpiab
techlev=1
class=static
flags=no_autogen

extents=-371739 334564 -322948 376386 0 7178 706303 699334 7178
[object]
type_id=141
type=simpixb
techlev=1
class=static
flags=no_autogen

extents=-407758 271106 -354861 326208 -3 6042 678864 681069 6045
[object]
type_id=142
type=krynonb
techlev=1
class=static
flags=no_autogen

extents=-305505 286729 -296969 279904 -4 3562 592234 576873 3566
[object]
type_id=143
type=lanixvb
techlev=1
class=static
flags=no_autogen

extents=-227613 233268 -238924 221957 -9 1944 460881 460881 1953
[object]
type_id=144
type=cyrianb
techlev=1
class=static
flags=no_autogen

extents=-349801 361362 -352691 358472 -4 1801 711163 711163 1805
[object]
type_id=145
type=hadar9b
techlev=1
class=static
flags=no_autogen

extents=-371739 334564 -322948 376386 0 7178 706303 699334 7178
[object]
type_id=146
type=tauranib
techlev=1
class=static
flags=no_autogen

extents=-407758 271106 -354861 326208 -3 6042 678864 681069 6045
[object]
type_id=147
type=arenisb
techlev=1
class=static
flags=no_autogen

extents=-305505 286729 -296969 279904 -4 3562 592234 576873 3566
[object]
type_id=148
type=xyonb
techlev=1
class=static
flags=no_autogen

extents=-227613 233268 -238924 221957 -9 1944 460881 460881 1953
[object]
type_id=149
type=omega9b
techlev=1
class=static
flags=no_autogen

extents=-349801 361362 -352691 358472 -4 1801 711163 711163 1805
[object]
type_id=150
type=alidisb
techlev=1
class=static
flags=no_autogen

extents=-371739 334564 -322948 376386 0 7178 706303 699334 7178
[object]
type_id=151
type=alphacyb
techlev=1
class=static
flags=no_autogen

extents=-407758 271106 -354861 326208 -3 6042 678864 681069 6045
[object]
type_id=152
type=lv105b
techlev=1
class=static
flags=no_autogen

extents=-305505 286729 -296969 279904 -4 3562 592234 576873 3566
[object]
type_id=153
type=gammab
techlev=1
class=static
flags=no_autogen

extents=-227613 233268 -238924 221957 -9 1944 460881 460881 1953
[object]
type_id=154
type=gammulab
techlev=1
class=static
flags=no_autogen

extents=-349801 361362 -352691 358472 -4 1801 711163 711163 1805
[object]
type_id=155
type=tyrinisb
techlev=1
class=static
flags=no_autogen

extents=-371739 334564 -322948 376386 0 7178 706303 699334 7178
[object]
type_id=156
type=lv110b
techlev=1
class=static
flags=no_autogen

extents=-407758 271106 -354861 326208 -3 6042 678864 681069 6045
[object]
type_id=157
type=alphagab
techlev=1
class=static
flags=no_autogen

extents=-305505 286729 -296969 279904 -4 3562 592234 576873 3566
[object]
type_id=158
type=crystarb
techlev=1
class=static
flags=no_autogen

extents=-227613 233268 -238924 221957 -9 1944 460881 460881 1953
[object]
type_id=159
type=cyronvib
techlev=1
class=static
flags=no_autogen

extents=-349801 361362 -352691 358472 -4 1801 711163 711163 1805
[object]
type_id=160
type=regulusb
techlev=1
class=static
flags=no_autogen

extents=-371739 334564 -322948 376386 0 7178 706303 699334 7178
[object]
type_id=161
type=sarienb
techlev=1
class=static
flags=no_autogen

extents=-407758 271106 -354861 326208 -3 6042 678864 681069 6045
[object]
type_id=162
type=tareanb
techlev=1
class=static
flags=no_autogen

extents=-305505 286729 -296969 279904 -4 3562 592234 576873 3566
[object]
type_id=163
type=olindab
techlev=1
class=static
flags=no_autogen

extents=-227613 233268 -238924 221957 -9 1944 460881 460881 1953
[object]
type_id=164
type=ylisiab
techlev=1
class=static
flags=no_autogen

extents=-349801 361362 -352691 358472 -4 1801 711163 711163 1805
[object]
type_id=165
type=majorisb
techlev=1
class=static
flags=no_autogen

; ---- AIRBORNE Objects ------------------------------------------------------

extents=-371739 334564 -322948 376386 0 7178 706303 699334 7178
[object]
type_id=166
type=lfighter
techlev=1
class=airborne

extents=-31969 28513 -30241 30241 -55 55 60482 60482 110
[object]
type_id=167
type=sfighter
techlev=1
class=airborne

extents=-26764 27756 -27095 27425 -45 45 54520 54520 90
[object]
type_id=168
type=raven
techlev=1
class=airborne

extents=-36590 36650 -36839 36400 -80 80 73240 73239 160
[object]
type_id=169
type=defender
techlev=1
class=airborne

extents=-16570 17269 -17019 16821 -68 68 33839 33840 136
[object]
type_id=170
type=vandal
techlev=1
class=airborne

extents=-37059 34684 -36109 35634 -140 140 71743 71743 280
[object]
type_id=171
type=zenstar
techlev=1
class=airborne

extents=-27435 26431 -27101 26766 -105 105 53866 53867 210
[object]
type_id=172
type=strdrone
techlev=1
class=airborne

extents=-15741 14020 -14708 15052 -68 68 29761 29760 136
[object]
type_id=173
type=infil
techlev=1
class=airborne

extents=-24650 23073 -23843 23729 -51 51 47723 47572 102
[object]
type_id=174
type=corsair
techlev=1
class=airborne

extents=-21727 23586 -22299 22585 -43 43 45313 44884 86
[object]
type_id=175
type=viper
techlev=1
class=airborne

extents=-26559 24144 -24446 25050 -79 79 50703 49496 158
[object]
type_id=176
type=strfghtr
techlev=1
class=airborne

extents=-20765 21872 -22010 20626 -132 132 42637 42636 264
[object]
type_id=177
type=icmk1
techlev=1
class=airborne

extents=-15715 17453 -16174 16994 -59 59 33168 33168 118
[object]
type_id=178
type=ic
techlev=1
class=airborne

extents=-21316 19808 -20081 21043 -81 81 41124 41124 162
[object]
type_id=179
type=nfighter
techlev=1
class=airborne

extents=-28671 30034 -30025 28680 -91 91 58705 58705 182
[object]
type_id=180
type=templon
techlev=1
class=airborne

extents=-22452 20887 -21800 21539 -118 118 43339 43339 236
[object]
type_id=181
type=mantis
techlev=1
class=airborne

extents=-23145 20002 -21573 21573 -54 54 43147 43146 108
[object]
type_id=182
type=strlance
techlev=1
class=airborne

extents=-15742 17582 -16341 16686 -107 107 33324 33027 214
[object]
type_id=183
type=aurora
techlev=1
class=airborne

extents=-23775 23169 -23169 22564 -54 54 46944 45733 108
[object]
type_id=184
type=inter
techlev=1
class=airborne

extents=-23799 19417 -21212 22004 -31 31 43216 43216 62
[object]
type_id=185
type=sentinel
techlev=1
class=airborne

extents=-18171 18844 -18731 18171 -46 46 37015 36902 92
[object]
type_id=186
type=lhtstar
techlev=1
class=airborne

extents=-33412 25422 -29074 29761 -72 72 58834 58835 144
[object]
type_id=187
type=zodiac
techlev=1
class=airborne

extents=-23935 23364 -23802 23497 -41 41 47299 47299 82
[object]
type_id=188
type=alinix
techlev=1
class=airborne

extents=-25695 25653 -26190 25157 -54 54 51348 51347 108
[object]
type_id=189
type=starmonk
techlev=1
class=airborne

extents=-20418 19680 -19926 20172 -20 20 40098 40098 40
[object]
type_id=190
type=hag
techlev=1
class=airborne

extents=-15390 17152 -16380 16161 -37 37 32542 32541 74
[object]
type_id=191
type=lag
techlev=1
class=airborne

extents=-10500 10078 -10191 10257 -23 23 20578 20448 46
[object]
type_id=192
type=marinels
techlev=1
class=airborne

extents=-3358 2757 -3076 3038 -11 11 6115 6114 22
[object]
type_id=193
type=marinea
techlev=1
class=airborne

extents=-344 625 -226 227 -19 19 969 453 38
[object]
type_id=194
type=marineb
techlev=1
class=airborne

extents=-359 438 -226 227 -19 19 797 453 38
[object]
type_id=195
type=marinee
techlev=1
class=airborne

extents=-424 850 -242 243 -19 19 1274 485 38
[object]
type_id=196
type=marinef
techlev=1
class=airborne

; ---- NAVAL Objects ---------------------------------------------------------

extents=-377 690 -243 242 -22 26 1067 485 48
[object]
type_id=197
type=naval1a
techlev=1
class=naval

extents=-261970 199753 -179013 179013 0 1597 461723 358026 1597
[object]
type_id=198
type=naval1b
techlev=1
class=naval

extents=-306382 268238 -215314 212623 0 1784 574620 427937 1784
[object]
type_id=199
type=naval2
techlev=1
class=naval

extents=-16448 13233 -14557 15123 2 112 29681 29680 110
[object]
type_id=200
type=naval3
techlev=1
class=naval

; ---- NAVAL FLEET Objects ---------------------------------------------------

extents=-17085 16650 -16650 17085 1 139 33735 33735 138
[object]
type_id=201
type=navflt1
techlev=1
class=nfleet

extents=-129797 194817 -128328 127540 0 0 324614 255868 0
[object]
type_id=202
type=navflt2
techlev=1
class=nfleet

extents=-129797 194817 -128328 127540 0 0 324614 255868 0
[object]
type_id=203
type=navflt3
techlev=1
class=nfleet

extents=-129797 194817 -128328 127540 0 0 324614 255868 0
[object]
type_id=204
type=navflt4
techlev=1
class=nfleet

; ---- DYNAMIC Objects -------------------------------------------------------

extents=-129797 194817 -128328 127540 0 0 324614 255868 0
[object]
type_id=205
type=atv
techlev=1
class=dynamic

extents=-14019 12775 -13127 13667 -11 59 26794 26794 70
[object]
type_id=206
type=gcv1a
techlev=1
class=dynamic

extents=-13497 12042 -12769 12769 0 113 25539 25538 113
[object]
type_id=207
type=gcv1b
techlev=1
class=dynamic

extents=-21086 18770 -19685 20170 2 85 39856 39855 83
[object]
type_id=208
type=gcv1c
techlev=1
class=dynamic

extents=-16810 15516 -15978 16348 0 100 32326 32326 100
[object]
type_id=209
type=gcv2a
techlev=1
class=dynamic

extents=-20371 19434 -20488 19318 -1 139 39805 39806 140
[object]
type_id=210
type=gcv2b
techlev=1
class=dynamic

extents=-17927 16083 -17210 16595 -1 166 34010 33805 167
[object]
type_id=211
type=gcv2c
techlev=1
class=dynamic

extents=-18143 16258 -17554 16847 -1 139 34401 34401 140
[object]
type_id=212
type=mdrone
techlev=1
class=dynamic

extents=-8606 8482 -8544 8544 0 61 17088 17088 61
[object]
type_id=213
type=marinec
techlev=1
class=dynamic

extents=-391 764 -242 243 -19 19 1155 485 38
[object]
type_id=214
type=marined
techlev=1
class=dynamic

extents=-372 646 -243 242 -22 26 1018 485 48
[object]
type_id=215
type=marineg
techlev=1
class=dynamic

extents=-300 635 -226 227 -19 19 935 453 38
[object]
type_id=216
type=marineh
techlev=1
class=dynamic

extents=-316 572 -226 227 -19 23 888 453 42
[object]
type_id=217
type=tsx1
techlev=1
class=dynamic

extents=-17373 16815 -17154 17034 1 135 34188 34188 134
[object]
type_id=218
type=tsx2
techlev=1
class=dynamic

extents=-14896 14986 -14657 15225 2 160 29882 29882 158
[object]
type_id=219
type=acm
techlev=1
class=dynamic

extents=-22566 21164 -21725 22006 -3 403 43730 43731 406
[object]
type_id=220
type=adv
techlev=1
class=dynamic

extents=-13619 12674 -13147 13145 0 246 26293 26292 246
[object]
type_id=221
type=ax10
techlev=1
class=dynamic

extents=-30314 31082 -30698 30698 5 268 61396 61396 263
[object]
type_id=222
type=ax21
techlev=1
class=dynamic

extents=-34246 34305 -34101 34101 -4 326 68551 68202 330
[object]
type_id=223
type=ax25
techlev=1
class=dynamic

extents=-27546 27238 -27238 27546 0 275 54784 54784 275
[object]
type_id=224
type=gdn4
techlev=1
class=dynamic

extents=-29605 29605 -29974 29235 -3 193 59210 59209 196
[object]
type_id=225
type=gdn7
techlev=1
class=dynamic

extents=-19266 19502 -19736 19032 -3 156 38768 38768 159
[object]
type_id=226
type=mk1p
techlev=1
class=dynamic

extents=-13620 12780 -13453 12947 1 282 26400 26400 281
[object]
type_id=227
type=mk2p
techlev=1
class=dynamic

extents=-15037 13776 -14676 14136 2 287 28813 28812 285
[object]
type_id=228
type=xp10
techlev=1
class=dynamic

extents=-17755 16745 -17462 17038 0 223 34500 34500 223
[object]
type_id=229
type=xp15
techlev=1
class=dynamic

extents=-16311 15427 -15564 16174 2 170 31738 31738 168
[object]
type_id=230
type=mk3p
techlev=1
class=dynamic

extents=-19640 19362 -19640 19362 0 550 39002 39002 550
[object]
type_id=231
type=mk1d
techlev=1
class=dynamic

extents=-23840 24170 -24005 24005 -1 287 48010 48010 288
[object]
type_id=232
type=mk2d
techlev=1
class=dynamic

extents=-14745 14542 -14440 14847 -25 238 29287 29287 263
[object]
type_id=233
type=ewr
techlev=1
class=dynamic

extents=-34304 36703 -38862 32145 0 676 71007 71007 676

; ---- Military Bases Objects-------------------------------------------------

[object]
type_id=234
type=bsecmd1
techlev=1
class=static

extents=-80124 63056 -72537 70642 0 483 143180 143179 483
[object]
type_id=235
type=bsecmd2
techlev=1
class=static

extents=-92287 106596 -89425 109458 0 603 198883 198883 603
[object]
type_id=236
type=bsecmd3
techlev=1
class=static

extents=-116894 102198 -106206 112887 0 603 219092 219093 603
[object]
type_id=237
type=bsecmd4
techlev=1
class=static

extents=-83554 69491 -59150 64527 0 954 153045 123677 954
[object]
type_id=238
type=bsecmd5
techlev=1
class=static

extents=-148868 155455 -167312 209470 0 1272 304323 376782 1272
[object]
type_id=239
type=bsecmd6
techlev=1
class=static

extents=-57081 59977 -56667 55013 0 848 117058 111680 848
[object]
type_id=240
type=bsecmd7
techlev=1
class=static

; ---- SPECIAL Objects -------------------------------------------------------

extents=-112259 109664 -88898 88250 0 848 221923 177148 848
[end]
        0xx00 0 lll     lllll 0|x0 0f  8l8vv ``     0```0 `00` f<<f   0000   00`            00      0` || 0p0000 x8` x8x <l x 8`x 000 xxx x|p 00  00  00  00` 0``0       `00` x0 0 |x 0x ff|ff <ff< lfffl bhxhb bhxh` <ff>  x00000x x flxlf ```bf   8ll8 ff|`` xx ff|lf xpx 0000x  x0  l88l x00x ƌ2f x`````x `0 xx 8l           00     x|v   ``|ff xx   |v xx   8l``` v|  `lvff 0 p000x  x`flxl p00000x       xx   ff|`  v|  vf`   |x   0|004 v   x0   l   l8l   |  0d   0000   0000 v              
    ,,           T TTTTTTTTTTTT                                                            jjjjjjijjjjijjiijjjjjjjjjkjijjijkjijjijkjijjikjiikjikjikǐkjikƐkjikȐkjikȐĐkjikȐǐkikȐǐkjkȐȐkijkȐȐkjijkȐǐkjiikȐȐkjijik ȐȐkjjiijkjjkl ŐiiȐkijkjjkjiijkjjlkǐȐkiijkjjijkiijkjĐjlkǐȐkiÐijkjijjkjkjĐjlǐȐkiÐijkjijkjiƐjlǐȐkĐikjijkjiǐjliiȐlkiƐikjkjiiŐjliǐi lkǐikjikiʐlmii ljÐÐjkjikiÐǐilmiiiljƐÐjkijkjĐiÐilmiiljĐikijkjːiŐklmiilkiƐĐikjijkːiijklmiilji͐kjijkiϐjklmiilkjiĐƐjkjiikiÐiǐiklm iimlkjiŐÐjkjiikjÐiiklklm iimlklkjiikjiikjikljkm!iimliiklkikiiikljÐijlkiĐkmiimliĐiklkiikiiijlkijlkiiÐikmiimliĐiklkijkiiijijlkiĐiŐkmiimliƐjklkiijjiklki̐jmiimkiƐÐjklkjiijiiklkiАjmii mkiƐɐjklkjiiiijiklkiːijmii mki̐ijklkiijiklkĐiȐijmiiimkiiːiĐiklkiiÐiĀjiiklkiiiǐiijmiŀiiiimki̐iĐjlkiiijijlkiiiiĐikmiimljiɐiŐjlkiiÐijjliĐiiŐikmiimljiƐiiĐklkiiÐÐijljiijmiimkiiȐikljijiÐŐijiiljiijlmiimlkiǐikljijiÐĐijiiklkiijlmljimnmiiiimjikmlkiŐilijiĐŐijikmkiÐjlmljilnm ijiiÀijmjikmlkiÐjlkiijijiĐŐijijmlikmljilnmĀiiijmjikmljjlkiijÀiŐʐijijlmlmjilnmiÀiimjiÐikmlkijiĐɐijijlmkilnĀiiimjiiikmlkjiĐʐijilmkiknjiiiikmnmiilmljjiÐʐijilmkiiknjiiimnmjiiÐjlmljijiÐːijikmkiÐiknjiijkmnliiƐjlmliijjiÐ͐ijiikmliijmnjii mnkiÐijmlijiiÐÐ͐ijiijmliijlnii mnmkiiÐikmkijiĐÐΐijjmjilnjiiinmjiiÐikmkiijiĐŐ̐ijlmjiilnjiiinmnljiÐilmjiijiĐǐːijiilmkikmnkijnmjiĀiiinkjmnmljilmjjiːʐijiilmkikmnlijmnmjŀiinkijmnmliijmljji̐ɐijiikmnlikmnlijmnmkjjiŀjnkikmnmkijmljiʐɐijikmnmnljijimnkjjiŀjnkijikmnmliijiʐƐiijijmnmjijimnkjĀiÀjnjiikmnmkijiɐÐiijijmnmjijmonkjjijijnjikmkijiɐǐiÀjilnlimonkÀjiÀijmnjiijnmjjiɐƐiijilnkijnonkjÀjiiÀjmnliiijmnmjijiɐĐiÐijiknliijmnonÀjjijmnmkiÐijmnlijiȐǐijiiknmilnonjijjmonmjiiknlijiɐƐijiijmnmjilnonojjjknonmjilnkijiiɐijkjijmnjiknonlikojijknomijmnljilnkiijiɐijkjjmnkiknonlikojijknomiknlijmnmjiijiÐiÐijkilnlkmnonmikojjnoliknkjmnmjjkjiȐijkiiknomjijnojkjnoliilnmjkjiɐijkjiknomkijnojijnolilnliikjiiÐijkiknonkijnomjijokilnlikjiÐijkjmnjijomjijokiimnkijkjiijkijmonkijnomjjonkimnkijkjiijkjlonlijijmomjijkonkijnmjkjiijkjilnolijmononjijlonomjijnmjikjiijkiknomilomjimonjijlonjiknomjiknmjkjiijklkiiknonjilnomjimonjjlonjilnomjilnlkjiijkljnonjknonkilonjjkjiijkjiijlonimonlimonkikjiijkljjmonkilonkjkjkjmonijmononkiikjiijklkjjmonlilonkjkjklkjklkjmomijmonjiikjiiijklkjilolikonjklkjkjlomiknomjijklkjiiĀjklkjilomimomklkjklkjlnjiknomjjkjiijjkjiiknoniilomkjkjijkjkjiijkjlnmjilolijiiijjijnonjiknkjkjijkjjkjkjjkjmnmiilolijiĀiijjjnojiknkjkjijkjkjjkjjkjkmnlimonkiijiÀiijjkjmokijnljkjijkjjkjƐjkmnliijnonkjkjijiŀiijjijkijloljmnljijkjkjkjiijknkjnonjjkjiiÀjijĀijkjlomjijjkjjkjjnmkjjkjkjjiijknomjkjijijÀjkjikmkjkjijkj jkjkjjkmlikmnonmkjkj jkjiijljijkjiÀjijjkjijkjijklkjjkjjmnonmmkik,-onmlmkjkj jklkjijijkjÀiÀijkjjiijklmlkjjkjjlmnoƕmikÖ,+nmnmkikjkjklmlkjijijkjƀijkjijiijklmnmlkj ijkjilnmn+-+Ėm&Õi Ö,+)mÕnmkijkjjklmnmlkjiijjjijiijklmnmlkj ijkikmn))+Õmm +-,+)&m))nmnmijkjkijklmnmlkjijŀjijijkjijklmnmlkjk ikkmn+,+,)&kj kœmm)+nonkjkjkj kjklmnmlkjiijijjijijkiijklmnmlkj jkkmnm+,Đ! km+.-n+-onkjkjk kjklmnmlkjikjijjijkljijklmnmlkjkjk kjkmnmm) Ó!Ó! ! ! !!k,++-/.omijkj kjklklmnmlkjipilkjijijklmkjklmnmljkjkjk jkkmnm)mj ȓ!!   ! !œ!km-.,nmlijkjkjkjkjkjklmnmlkjiilkjijklkiijlmnmlkiikj kjmnmnƕmē ĀiiȀ Ó!!i)-.,+nljkjkjkijlklmnmlkjijlkjijklklkijkmnmlmlkiÐiklkjk jkkmn)Õ! kÀiĐiŐiiŐiÀǓ ,+nmljkjkjkiÐjlmnmlkjijklkjjijkjklmnmlmljȐjlkjikjkjnonoĖ)k kjĀiԐŐiÀjĀ $!k+,Önmnkjkj kjklkiƐilmlmlkjijkjijijkjijkjklmkːjlkjk jkinon+Ö) ŀiҐʐijij( k)mnkjkj kjklkiɐjlmlmlkjkjijiijkjklmk͐jklkjjkkno+) ƀi̐ِiik$!" kŖnmjkjÓjklkjːjlmlkjijijkjklklmlmkiΐilkjkjjkimno,+!kÀiÐi ! ! Őiijē!++nmjjkj!kjklj͐jlkjijkjjklmliѐilmlkkjmnÖ)kiiǐ ̓!  ! !!!ŐiiÀÓ j,-,+)nmlkjkjkÓkljɐƐklkjiijkjkljǐ̐ilmlklkkjkmnÖnmkkiiÐ!ʓ!Đ Ɠ!iÐiik!! j,+)mlmjjkklkljʐÐiklkjkjijkjklkiĐ̐ilkmkjklmn)kiǐ !œ! Đ !ē ŐiÀk! kĖmnkjkmkljːĐjlkjkjijjklŐ͐ilmlmlkjjkmnmĕiĐ ! ! Ð$Ðiij! mmnmkijkjijkmlmlj̐iklkjijijkljԐilmljjklkknnkiƐ!! !! ÐÐ$" Đii ! )+,nmlkjjkjiklmljϐiklkjijijklkԐilmlikjln)miĐ! iÐ"!Ői! ÖmlkkjklmljÐϐiklkjijklkiҐjlmljijkjmn)k!iƐ"! !Ð!ǐ! jmmkjjiiljҐjlkjijkliѐjklkijkjkimnĕ iŐ!Ð! Ȑ ! mmnmjkjkjijljƐːklkjjklkiǐŐiklkijkklkjmnm&iiŐœ! Ð ""Đi! kmnmkjkjkjijlkjŐiklkjijkjiklkiijlmlkkkmnm ȐƓ! Ó Ɛi mnmkjmklmlkjijlkiikjijklkjliijkmnmlkmkjlmnk Ɛȓ!Đi kmÖnmkmklmljiklkijlklkjijklkjlkjijklmnmlk kmnm ŐƓ$ !ÓĐi kmlkik mklmnmljiikljjlkjijklkijlkjijklmnmlkj! kimÕm ǐœ$ÓÓƐ Õmkjk! klmnmlkjiikljjlkjijkljkljijklmnmlmnmlkjiÓkim iƐ!ƓÔÐiǓƐi mkjkÓ iklmlmlmnmlkjijkljklklkjjklklkijlmnlkmlkjijÓkimkiĐʓ͓$ϓ!!Ɠ! !Γ$ÔɓŐi kmkjkjijlmlmnmljijklkjijkjkiijklmnmlkmljkjkmj!Ő!!Ó$Γ$ϓ!!ē!! ! !Ó$Ó$ēÔ$$ɓǐ  jmkjjjkjlmlmnmlkjijkjkjkiiklmnmlk#mlkjkjk&kimj Ő!!!œ$ϓϓ! !Ó!! !!ȓ$Ô$˓ǐ mkjjkjklm jlmnmlkjijkjijkjkiijkmnml $Òlkl'kjklmm Ő !! ɓ̓ÔΓ! ! !Ó!!!&Ó! Ĕ$˓ ǐ ēkjik'k $$klmnmkjiijijijklnonmlkmo##pklkjjk Đ !Ó!˓ ! !   $ɓ! Ɛ !kkjijkjkkj p onklmnmkjiijijijklmnonmlo32o#jmmkjjŐ ē!!Ɠ$$ؐŀ !אiÀi$͓!Őijkkmkmkj  # /32omklmnmlkjiijjklmnmlo3o23ojknomkj Ő !ғi !i$͓!Đi kmolkj #02o2olmnmlkjijijklmlko02o13o# jknjlomkjĐ!!ϓ!ϓ!Őkjkmonimnkj o02o1olmlkjijklo14.jkjmoklokjĐ!!͓i! ϓ!Ði jkmonjnkjo21olkjjklmo3/jkjlolĐkonkjÐǐĀđŐÓ! ! !̓ !ɓ!Ó!!Ɛ "Āǐjmomjnmjo20olkjijklmo3olkjkomiǐkonkjĐĐÐ!! !!̓! !$Ǔ!œ!Ó ǐ  ÑȐjmomŐlnljko1omlkjijklmlmo3omkniĐikonkj!!! ! ē!ȓ! $͓!!Ó!Đi  jomiiĐmoljlo10olkjjklmlkonjilojÐikomonkjiĐm !! ! !ʓ$ !Ôȓ!œ!ĐikmÐjmomoliÐinonjloklkjijklkjkjpBkokijnonijonkjij  mk! !! !ē!Ɠ !$$!ē!!!Óiikmijmokilokiiomi@pjkjklkjijklkjkpCkolimonjijokjiÀmjÐ! ! ! !!ē!!Ó!$!!! ƐijkmjmokiimonjjolApjkjjkjkip@jnonokÐiokjijĀ͑ȑ ! Ò mē! ! !!Ɠ!!ɓ! !Ó! ÐijmÑőijmokijnonokBp@kjkjijkljBp@inoliilokjijkmk"Ó! !! !! ! Ɠ!ɓ!!ē!! ÐmijkmomiĐijojCpiklkjjklkjApAimoiikokjijiiŀiҀjjkmj"ē! ! ! !œ! ! $!Ó!!! !!Ó kmkjkjj̀iƀiÀiikjknolimonj@pBiklkjjklkj@pBlojijnominokjijm ! !  ! !œÐՐ! ǐӐē!ē ! !! !Ó kmijknoilokiinon@pAijklkjijkjpBkokinoniimokjijkmkÐ "!Ó$  ! !!ēĀϑ ! ŀđÑœ!Ó'œ!!!! kmkijknonimonjinomiAp@jkjijkjBpCkonokimokjijkmkmkmkjÑ    !!œ !ē! ! ! ! !  Ɠ!Ó$ē! ! ! ! !  ÐkjijijjÀijknoniinomolBpC@ikjjklmkAp@jnoliÐiknomjِƀjjjjjÀǐ œ͐ɐ ! ܐ&ĐÐjj΀i̐jknoliÐijnokBpBjlkjijklkApAimoniiinomomjÐȐ ! Őː !Ő͐Đjknonmonjikonj@CpBjlkjijklk@CpAimoniimolikomjkʐ! !  ! Őjknomijnonjilon@CpAjkjjijkjkiCpBloilolikomk! ! ! ! $&$ÑjkjkomikomimomiAp@jkjkjijijkljBpCkomiĐimomkj !  ÑjkoniĐilonoliApC@ikjijklkApC@jnojŐjnomj ! ÑjkonkĐinokBpBjlkjjk@C@jnokÐimonjinomj !!  $Ñjkokimonjjnk@BpAjkjijklki@CpAmollonjinomj !! !!Ñjknjimomijonj@CAklkjijkljBpBlomknokinomj@ !"!Āknojjnolkom@C@iklkjjkljBpBlolimomjji !  "iknomjknomACB@iklkjijkjklkjAC@knilomimomjji !  $ ijiknjlnmimolBCBikjijkjk@C@jnjknonjlomji !$" iiÀknmiilnlmnk@BCAjkjijki@CAjmokjnonklnmji !  " Điknmiimnkimnj@BC@jkjijkiBCAilnonkknji !! !!nkjmnmj@CB@jkjijkjiACBlnljmnmii@ !Ԑ ! ĐӐ"ÓknmjjnmiACBijkjjkjACBknmilnmi ! !  ! ! !"!  !  lnmjknlACAijijkj@CB@jmilnjĐ !Ԑ ! Аǐ Ó!imnlikmkBCAjijkiBC@jmnkĐ  Ґ! Đʐ͐"!mj@B@jijkjACAilk !  "!ilj@B@ikjjijjkjABA !  !Ó @BAijiĀijkj@B !  Ó!@BAjkjiijkj@BA  !   ""!@B@ijkjiijkji@   !"!@ijiiji  !  "" ijiii !  "!i  "$! !  $!! "! ! " iÀjkjϐ ĐÐjÀiiiiiiijkɐ  ! jŀiijk   ! !"!" !Ó! ! !  jiijkj !  ! ! !  "!ē! !"$! !      ijÀiijklkj !   !"    ! !"!$$"!    ijkjjijklkjijƑiÀiij  !"!   !"$$#"!#"!  ! !  jiŐiÑÐijkjiÑĀiƀjkjiklk  !"!   ! !"$"$$"#"!  !kjiijiiijkjijk  !  !"!   kjiiiĐǑkijiiijijkj@  @jkjkjiiiijjǑŐijiȒjÒljkiijiiiikj@   @@ijkjiiijjkkēlȒjiijijkjǓkĔklkljjiiiklkjiː!  !  @  @ "!"##!"! !ijkjiijklklÓlĔ mƓjÑiijĒjĔÕ$ĖÔÓljkjiiiklklkjiȐ  ! ! !@ !  @ #$#"#"#"#  ijklkjkjijijkklÔÕ$Ė#ÕĔkÒjiijÒjÕ-&/(Õmjkiiijjjŀiɀiijkjiɐ ! ! ! ! ! @ ! ! ! @!#$#"$"#$#!#"$ !  ijkjƀjiŀiijijkl./&12,ÕŒjiijÒj.&0/))ÔmjkiiiiiiĐiĐiÐijiĀƐ  ! ! ! ! @A ! A@!"#$"#"#"#"!  Ā ijiĐiiАijijklÕ./0&23&-.+ŒjiijĒjÔÕ&&.-ÔljkiiiiiʐiiiÐijiĀȀ  ! "! ! !A@!"!@A ! !"#"#"#"#$#!Ók ! !iiiiiĐiiӐijijklÔÖ)01ÕÔkĒjiijiĒjÓŔ"ĕÓljkjiiiÐiii̐iiiiÐ̀  ! ! ! AA !"#"#$#$#"#"!  đ !iiiŐiiѐijkklŔ"ĕ"ŔējÒjiijijjkjÒēlēklkijiiiƐiÐiŐiiÐiiiiÐ À !  ! !"!"! ! A@A !"!"#$"$#"#$$#$   !ÐiiiǐiѐiijkjlÓkēlœÒjjiijikliljlkjijiiiiǐiːiiǐiÐ  !  ! ! ! !"! !"!!"#'$"#$#$#"# "!ĐiiƐiАiijikljljlkjiiĐǐĐĐÐiiÐiАiȐiiÐ  p œ! ! "!#"!"!"!"!"$"$"#$&'$#$$ &,& !#" ! ĐiiĐiАĐŀiiiiÐ pÐ œ!""!"!""!"!"!"!"!"!"!"#$'&$"#$''$#"),.+#$#!$!Ɛi̐ʐijiiÐ ē!"!"$"ē$#!""!"!"#"#*&$#$(&'&$!)+.-.,#$#"#!ĐiijƀiiiÐ !ÐĐ"!""$#$#Ó$Ó$Ó"!"#$('#$&'&$-/+.,""!#Ðii ǐiÐiiŐĐiÐiÐ Đ"$"!"Ó$#$##$#$#$$"##"#$&$'(#$'&&$#+/./-)-,-. !#ĐiÐiŐiÐiiĐ    !АiǐːiiiÐŐ!"!"!"!"!"!"ē"!"! .-.,.-+.-iiiĐiÐiƐĐ !  iiÐÐĐ! !"!" !"!"! !"!"""! ! !"! ! !  *.,*-,-.-iii !  jiiÐĐ ! "!"! !"! !"!"!#"! !"! ! -.--.-+ii!"ijiÐĐ ! "! ! ! !"!"!"! ! !   ),.-,+-,*ÐiÐiijiÐÐƐ !  *,.-,&*+-,+iiÐi jiÐĐii ! ǐiȐĐ̐ +.-++,-iiÐi!jiÐij Đii&-.-+,-,-,'ÐiĐii! jiÐiÐj ĐiΐƐ)-,+**,-ǐii!!jiȐj !Đ,-+ĕ*-,ǐii!!jiŐji !Đ +-,-,+ɐi!jiiƐj  &,,iȐj "jiǐiĐij  kji(&ijk ĐiÐij  jii kjiiÐijk kjjkȐi! ijÐi kjjjÀjjkkjÀijkjk&Ȑi!!jǐikjjÀjjkējkjkÓiiÐi!!jŐii Ð!ij !Őiji!"jĐiÐȐji " jĐiÐÐȐji  !jŐiÐÐȐj! "jŐiÐÐĐiÐj" ijƐiÐ Ȑj# jĐiÐ Ð  Ȑ" jǐiÐÒÐ  Ȑ"  jƐiÐĒ Đ!  Đ"   jŐiÐ  Ð Ó! "jƐiÐĒ Ð Đ!!"iːÒÐē Ð!  !jiɐÒ ē  Ð! !jɐÓ  Ð!"jȐÓkÐ! "jȐÓk ! "!ƐiÐjÓkk! !ʐjÓkkÐ!!ǐjÓk Ð!!ŐŐÓkÐ! !ŐŐÓkjk  ʐkj !ĐÐmjk !ŐÐ mjÀijk! ŐÐjmlkjjkjiĐĀjk " ̐kj ijkm ÐkjÐ m ÐjÐÐj  ÐĐj!  ÐŐj!  Ðj!  j  j !Ðk! !Ðij! " Đhhj  !Ðb`hhij  !d`ah`a`h`hb`bhj! jĐb`bacah`bh`aj!  j`ahbh`h`bah`j! jh`  h ! hj  bhj !ahb`abh`ah`bhbhj  hbhb`abh`b`cbhj!jih`h`h`h`ah`ab`h! jiڐÐ hhhh`h!jiiȐːÐh!jiiȐǐɐƐh ji̐ÐÐh`hÐĐÐÐǐƐĐÐ ahbhbhb`baba`Ð ÐĐɐĐÐĐĐbabhb`abcbcahÐ  ÐŐːɐĐĐĐhbhÐ !Ðahj! !ÐpsHIJJKJJJJJJJJIHsph!  !ÐABA@BA@ABABABABABABA@A@hh!  !iÐ``ahh !  !ibc`acb`ahb`hba`  "accababchbaabhi!  "c`c`a`abh`ab`hi"!  !!iÑ``ac`#  !!`b``c`i"#   "`ca````c`i!!  ! #`c``ab``cah`h``i! ! !  !#bc````ac``c`ch`h`bhi" !   #``acacc``ca`c`cbda`h`b`ababa`#!!   "Ñb`a`bc``ca`abdb`ahdhab`babh#!      "bac``ca`a`h`hah`hh`h#!    #pFGFC`c``a`aabc@@#!!     #MMcbcbc``bc``JMMIhh$"!    !#pFEd``c`cbHKKshahb`h$#!    !#ac``aach@@abh`h`ch`ah`ah#!     #`ca``c`abahbcba`ab#"  "`caac`a`hbca`hbabj$" !"ac```hhj$#        ! "b```j# !   !  !    !  !ic```hj"!bc``ahahhh"!"`cb`cab`h`ha`h`ah#! "`c`cba`hba`bhbc`#" "c`cb a`ah`h`a`abh`h$" !`cb`cb h`hhah$"!`cach#"!`ca``ac`#!!`aca``ac`#!! `aa``#"! @`a`ca@ABCp "!ÐÑ IJIHG`a`dbJLLK "#!" Ő pMMK```JKLKKJ $"   "#" CEED@ECDEDC@ea``c@@#$#   ! !  !    !"  ac```!#$ȅ"! !   !   ! ! psppqrp ! ÐÑ ca  pprppprpAp jÐ ac !  ApA@Bpp@pqBApA  j ```` ! ! @p@qpAppppA j```  @p@ApppqBptp@prAptp   bb   pAptqprBpsqpppAs@q@Btq@!c @ABr@@rB@rppAprpApqrp@!cc @prqApAprqprpAqpprpArA!`a`c`  qAps@qrBppppq@prpqp@prB ```a  BAqrpArp@prpAA  c``b !  pApppp aca``bc`jkp rq@`cca``bj@Bqrq! stqppAi A@@A@A@`aceca``cdc@BCB@@ik ApqAqt  !"! !"#$&'&$$! vqBAqp@BsJJKJKJKJKIpa`cbLMMsik B@pqA@pYvw !#$$&'&$"#"! !"!    !"#$&& rApB@qp!HMMLMLMLEc`ca@HJLKJKLJKJKJqi pq@@Bp@Ast (&'&$#"! !  "!"#$#$&ÆBrpB@qAApBCCDEDACBCBCABCBc`a@A@A@A@A@@ik pqAAr@@Bpq@BXs $'$#$#"! ! !"! !"#"! "vwxYB@qrqpBAqBqpc`a  ijpq@BrA@Bpqr@pXYxv !"#"! !"!   !"!"$vu!pApp@qqpBArpppb`a   jppqrAB@qqq@ppBp v"! !"! ! !"!     !"! XBBBpp@qp@AArpApa`arpqj pAprAB@qq@pppB@pX! !"!   ! !"!"!Ã"!   !  !vt@Bp@BrpAp@qqq@BArppa`aprsrssHssrpqA@B@qqq@pAprB@pAtv! ! !  !    !Ã"!"!"""!  !  ! tq@q@AqpBp@qpq@BApp ``bsHsIHHIsIHr pqAp@qp@q@pApqA@q@X !  ! !""!"!""!"!""! !   !"vuBqqq@AqpAq@ppq@BApBr  `c`bpHsIHIsIr  rBqAB@rp@p@q@qqA@qrqBv" !   ! !"!"!!""!""!"!"!  "uX@Aprq@Aqq@q@p@pq@AApqp!a`c`sI sIHsIHpqrqAB@rp@pAr@qq@A@qAAXu"  !  ! !!"!"!ă"!"!"!"! "AqqA@pAqA@qpqAp@prpprqp`c``c`sIsIHsIH @pApqrsrpppApAqq@AqAp@AqA! !  ! !!"!""ăÃ"!""!""! tuXApApApAprAp@prp `a`bca`bcbabcaba`sIsIHIsHH  pqB@pA@rpApBpBpBXv  !"!""!"Ã" !Ã"!""!" qBBqB@pBpAp@ApAphhccaba`ab`bcbcsI sIHIsHI pqpBBAApBBpB@pqB@pt!"!""!Ã"  ""!""! tAqp@Aqp@BqppB@p@qA@hhacbabcacbabaccbcasI sIsHHI !@AAq@p@pBpqB@pqA@pAt!"!"!""! ! ""!""  t@@qp@App@AqpAp@BA@BA@sI sIsIHssIH !@ABp@@B@p@qqA@qpA@qq@utu !""!""! !"! ""!"!"pqpApqq@@pq@@pq@p@AqqpBA@@@s rsrsrs !@BpqqB@q@rp@Ap@ApBq "!"!""! !" !"" @BpqpBpqAp@@prq@pHKJKLJMLKJKMLKLMLMLMLKMLKMLJHq!q!Aq@pAp@Bppqp@!"!""! !"! !Ã"! utq@ApqpBqB@@BqBpApqpB@ rsHsHsrqp! ! BpqqBp@BqB@pApqpA@qutu!"Ã" !"ÃÃ! ""  tq@@pAqp@Bqp@BqB Ɛ  BqB@pqB@q@@pqp@But !"" !"ă"! "!AqpA@Bp@q@Aqp@AqqpB@  ! ApqqA@qpAAqqAqBApqp!"! "!Ã  pAApApqA@pq@@A ĐÐ "!! @AAp@BpBqpA@BpB! """!"" !tqApB@@pBBqBpqp@ !#$$#!Ɛ! !"$'&'# AB@pBpqpA@pArtu!""!!!!trA@Bp@@BpBqp@ApA  !#$#$"!" !"$'('('('"#! ABpB@pqB@pqB@Appu"! !!tBABpAAp@@pqp@  "#$" ! "'('("  !  !  $&$"!@qq@ApqpABpBqt !           T TTTTTTTTTTTT      $$$(((,,,000444888<<<@@@DDDHHHLLLPPPTTTXXX\\\```dddhhhlllppptttxxx|||(  4  D  P  `  l  |                    $ 0 D T ` t            T  ` p|  , (8 0H(<T,@d4Hp8P@X\d p$|,8@$L,`DlH|\ĈlДxܤ䰔д04$<4,D0<L8PTD`\Plh\|tdp|и̼  ,,(8<4HHDTXP`h\pxh|xĴ                                                                                                                                                                                                                                                                                             
    ? ,,           T TTTTTTTTTTTT @                                                           jjjjjjjjjjijkjjikjikÐkjkĐkkĐÐkjkĐĐkjjikĐĐkjjikjlÐĐkiikjkjÐjlĐĐkikjikjijliĐ lkÐikkÐilmiiiljÐjkkǐjliiljǐkiikiÐil iiljjkiljilimiimliklkiikiiiiliŐmiimliÐklkiijikliȐmiimiȐklkiijiilkiĐijmiiimkƐijliiijliikmiimliÐikliijiilkiijmjmniimimkiiljiÐijimlimjilniijmimjliijiĐijlmkilniimiiimljiŐijimkinjiijmniÐjmiijiǐijimliilniimnmikmijiŐijimkiknkjnmiinkjnlimjjiƐŐijimlknlijnmjÀnkiknmkjmjiŐÐijimnmijinÀinjiknmijiŐÐiijinkinokjjijniijnjjiŐÐijiinmilojijonmiknijiĐijkjnkiknoliojijnoiknlijnjjiiijkiinominojjnoiilnkjiĐijkininojijoilnikjiijkjolimomjjkonijnjkjiijkinmilomionjjlojkomiknjkjiijkljjonilokjkkjonimokikjiijklkjioikojklkkjominojiklkjiijkjinilmjkijkkjijkjlmiloijiijjkjokijnjjkjjkjÐjmljokjkjijiijijkojijjkjjkjnmkjkjjijnojkjijijkjjiijlmlkjjklmnoÕik,+mikjjklmljijjkjÀijijklnmlkj jkkmn)+m -,)mnmnijkjijklmnmkjijÀjjijkiklmnmlj km,! m.-+okjkjk jklmnmlkjkjijjklijmnmlikj kmnÕiiĀ !-.+nkjkjkilmnmkilkjjijkjlnmjĐlkjijkno ji͐j !,nmnkjkjkliÐimlmlkikjijiikjklmlmkǐilkjkin,!ii! Ðij!ÖnjjkjkjkljƐjlkjkjjkjklÐƐimlklkkjkmkii!œ Ói! j,)lmjkklkljŐklkjkjjjklƐimljknmiÐ ! !$ij! mnmijkiklmjƐilkjijjkliʐlmlijknk!iĐ! !!Đ! jmkjilɐlkjjklkiÐÐklikklkjnmĐÓ!  "i mnkjkjkilkÐiklkjijkljljijlnmlk kmnm ĐÓ$ !imlik klmnmjiikljlkjijkljljjlnmljkimÐÓ᐀ÓÐmkkilmnljjljlkjjkijkmnlkmljkkmj!!$Ǔ$Ǔ!! ! !$$$$ēÐ jmjjkjlmlmljijkjjiknomko#klkjk Ó!Ɠ ! $ē!Ð kjkk oklnkjiijjkmnlo3jknokj!ɓ i$Ǔi kokj 0olmnmkjijklmo/klonjƐÐ ! !Ɠ !ē!!!Ð ǐjmojmjo0olkjijklmo3oknionj!! Ɠ! $ʓi  joiÐmljo1olkjjlkjBokinononjij m!! !œ !$!!!imijmoloiioi@jklkjjklp@ioiiokjijkmk"! !! !Ó!Ɠ!!!mijkoiiojpkjjljpBojinomiokjim! !  ! !ʐ! ΐ!! !! kmijkoiloiio@pjkljijklmp@joiikoj̐ÀjÀjÐ ƐĐ ΐjjǀƐjnoliinokplkjijklkCAioioikojŐ ! jnminojio@pkjjkjBCoiimokj! jkoniioiACikjjkliCAoonnmj  !jknmoioj@ClkjjkljBomomj ! "iknmnoABilkjiijkiCAjojoknj !"iniinkmj@CkjijkjiABnjni@ !ʐ ʐ"njniABijkjjkj@Bminj !ʐ!ȐŐinimBAjjjkjA ! !@Aijiijkj@A! "@ijii  "i $ !"ijkĐ ! jijkj !  ! !!  "! ! !   ijiÀiÀjkjiklk  !  ! !"$"#!!kjijiiÑkijiijikj@  @jkjkjiiiijjđijikjÓkklkjjiiiklkjiƐ! ! @  @"!"##"! !ijkjijl Óiijj.0jkiiiiĐijiÐ ! ! ! !A ! A!"$"#"#"#"   ijiiiȐijik/&23&.+jiijijljkjiiiiiƐiǀ ! !AA !"#"#$#"! iÐiɐikl""jiĐ̐iŐi p ! "#"!"!"$#$&$ &!# !iiiȐŐiji !"!"$"$#"!"#$('&!+..$"#iijÀiiѐ ÐiiÐii "$"$#$#$#$""&$'#$&#+./-. !#iiÐiiÐ  ii !"! "! !"!#"! "! ! .-.-+ii!jiÐÐ !,.,&*-,Đi  jiij ɐÐ)-+,-Ðii!!jiji!+-,-,Ői!"jiÐiij ji&ikĐj !jÐikjjjkĐi!"jiĐi jiĐj" ji  Đ" jŐ "   !iƐ!!jĐ !"Ðijkk!!Őjk! Ɛk !Ð mÀik"Ɛj jmj Ðj j hh !dah`hb`h! h  !h`aha`hbiΐÐ hhiiĐÐĐÐh ƐƐbach!h !ABABABA@ "cbhbb!  !!`ac#!#ca`a`h` ! #c``cd`baba!   "bac``ah!   !#pEdc`bHKsah`h# #`a`cbabab"    ! "b`j#!  !    !!Ðb`ahh! "Ðcbahb`bhc"!`ac"!aa`ac`!! IJIH`adJLLK#   # CEDED@e`c@@#ppr! ca  rprppp `  p@pppAs@t@!c @Brr@rppp@rpB`a BArr@rp a``jpst A@@aeac@C@@i At "!"#$#$B@CCEACBCBCc`@A@A@ q@Bq@Xs '$#$#"! !   !"!"v!@qqBApb`  pABqq@ v"! ! "!"!  !! qApBpq@pp `ssIHIIHpq@qpApAq   !""!"!"!"!  uXAqAq@qq@pqa`c`sIsHIpqq@rr@q@@AXu !  !!!"!"" tuXAprrp `abc`cbacb`sIsHIH pqrpBv !""!"" "!" t@qpApApBA@AsIsIsHsI @B@@BpAqAqu!"!"!" ""@pqpq@qHKLJLKLKMKLMJqqq@@q@!""!!"!Ap@pqApAqB pAqAqqpqp!!"!qAp@pqp!#$#Ð! !"'&#@qp@pArt!"!!tApAAp@pq@  "#$"! "'('(" !! $!@qAqABpBt!           T TTTTTTTTTTTT      $$$(((,,,000444888<<<@@@DDDHHHLLLPPPTTTXXX\\\```dddhhhlllppptttxxx|||(  4  D  P  `  l  |                    $ 0 D T ` t            T  ` p|  , (8 0H(<T,@d4Hp8P@X\d p$|,8@$L,`DlH|\ĈlДxܤ䰔д04$<4,D0<L8PTD`\Plh\|tdp|и̼  ,,(8<4HHDTXP`h\pxh|xĴ                                                                                                                                                                                                                                                                                             j
       DEFAULT.PAL    MAIN                  PB    h     6s'    , J      _     _ 5      #
      z    G &     I     V    Hܱ    l&    c&    Ѕ      `F    I#	     o_              	 z2    k_=
     %     /a      9Z    	       UF      N*    
k 1           (
      K "	                                  {#       v                              BLDG2.3D                                 lx                              BLDG3.3D                         T      z                              BLDG4.3D                         Ԃ{      ,~                              BLDG5.3D                         {                                     BLDG6.3D                             D   Ё                              BLDG7.3D                                                              BLDG8.3D                                                              BLDG9.3D                         艵       \                           	   BLDG10.3D                      	   艵    D                                 BLDG1.3D                      
   芵                                      BLDG1.3D                                                               BLDG1.3D                         8       쇵                              BLDG2.3D                      
   T       p                              BLDG2.3D                         T_A                                   BLDG3.3D                         TnV
                                 BLDG3.3D                         TE     습                              BLDG3.3D                         TQU   D                              BLDG4.3D                         萵       T                              BLDG4.3D                         䒵       @                              TWR1.3D                         䒵    D   Pu                              TWR2.3D                         0       {                              TWR3.3D                         0    D   ،                              BLDG8.3D                         0        茵                              BLDG8.3D                         04     }                              TWR1.3D                         t0                              TWR1.3D                         e       ؏                              BLDG1.3D                         ؘ#                                     BLDG1.3D                         ؘ    D                                 BLDG7.3D                                                              BLDG7.3D                             D   0                              TWR2.3D                                                               BLDG6.3D 
      BLDG1.3D    BLDG2.3D    BLDG3.3D    BLDG4.3D    BLDG5.3D    BLDG6.3D    BLDG7.3D    BLDG8.3D    BLDG9.3D 	   BLDG10.3D    TWR1.3D    TWR2.3D    TWR3.3D j
       DEFAULT.PAL    MAIN                 c;    h     ]L%    Qy    TO	     _c     s*     2A    7 $l
      -\     X	 FH     $    !      w     Ⱥ      N    N    RO          	 \      	     V 6l     E x      I     0>Y     0 <     p9    U      0                                 {#       v                              BLDG1.3D                                 lx                              BLDG1.3D                         T      y                              BLDG1.3D                         Ԃ{      z                              BLDG3.3D                         {       ,~                              BLDG3.3D                             D                                 BLDG3.3D                                Ё                              BLDG2.3D                                                              BLDG2.3D                         (
                             	   BLDG11.3D                      	   艵        \                           	   BLDG11.3D                      
   芵                                   	   BLDG11.3D                                                             	   BLDG12.3D                                                             	   BLDG13.3D                      
   T                                   	   BLDG13.3D                         T                                   	   BLDG15.3D                         T        습                           	   BLDG15.3D                         T        `                           	   BLDG15.3D                         T        D                           	   BLDG15.3D                         T        T                           	   BLDG16.3D                                 茵                           	   BLDG16.3D                         䒵        ȏ                           	   BLDG16.3D                                 ؏                           	   BLDG17.3D                         0                                   	   BLDG17.3D                         0                                    	   BLDG18.3D                         0                                   	   BLDG18.3D                                                            	   BLDG20.3D                             4   蒵                           	   BLDG20.3D                         ؘ#       `                           	   BLDG20.3D                         ؘ    D   \                           	   BLDG19.3D       BLDG1.3D    BLDG2.3D 	   BLDG11.3D 	   BLDG12.3D 	   BLDG13.3D 	   BLDG15.3D 	   BLDG16.3D 	   BLDG17.3D 	   BLDG18.3D 	   BLDG19.3D 	   BLDG20.3D    BLDG3.3D j
       DEFAULT.PAL    MAIN                  % d        S     4    *!	     	 `     Bb     y t    G &      qP     j&I     p;    l&    c&    d:    `F    /	     ?     bK          J      K	     :5z     /a      9Z    L ,      UF      N*    J uL
           (
      K "	                                  {#       v                              BLDG2.3D                                 lx                              BLDG3.3D                         T      z                              BLDG4.3D                         Ԃ{      ,~                              BLDG5.3D                         {                                     BLDG6.3D                             D   Ё                              BLDG7.3D                                                              BLDG8.3D                                                              BLDG9.3D                         艵        \                           	   BLDG10.3D                      	   艵                                      BLDG1.3D                      
   芵                                       BLDG1.3D                                                                BLDG1.3D                         8        쇵                              BLDG2.3D                      
   T        p                              BLDG2.3D                         T                                      BLDG3.3D                         T                                      BLDG3.3D                         T        습                              BLDG3.3D                         T        D                              BLDG4.3D                         萵        T                              BLDG4.3D                         䒵        @                              TWR1.3D                         䒵        Pu                              TWR2.3D                         0        {                              TWR3.3D                         0        ،                              BLDG8.3D                         0        茵                              BLDG8.3D                         0         }                              TWR1.3D                         t    0                                 TWR1.3D                                 ؏                              BLDG1.3D                         ؘ#                                     BLDG1.3D                         ؘ    D                                 BLDG7.3D                                                              BLDG7.3D                                 0                              TWR2.3D                                                               BLDG6.3D 
      BLDG1.3D    BLDG2.3D    BLDG3.3D    BLDG4.3D    BLDG5.3D    BLDG6.3D    BLDG7.3D    BLDG8.3D    BLDG9.3D 	   BLDG10.3D    TWR1.3D    TWR2.3D    TWR3.3D j
       DEFAULT.PAL    MAIN                  % d        S     4    *!	     	 `     Bb     y t    G &      qP     j&I     p;    l&    c&    d:    `F    /	     ?     bK          J      K	     :5z     /a      9Z    L ,      UF      N*    J uL
           (
      K "	                                  {#       v                              BLDG2.3D                                 lx                              BLDG3.3D                         T      z                              BLDG4.3D                         Ԃ{      ,~                              BLDG5.3D                         {                                     BLDG6.3D                             D   Ё                              BLDG7.3D                                                              BLDG8.3D                                                              BLDG9.3D                         艵        \                           	   BLDG10.3D                      	   艵                                      BLDG1.3D                      
   芵                                       BLDG1.3D                                                                BLDG1.3D                         8        쇵                              BLDG2.3D                      
   T        p                              BLDG2.3D                         T                                      BLDG3.3D                         T                                      BLDG3.3D                         T        습                              BLDG3.3D                         T        D                              BLDG4.3D                         萵        T                              BLDG4.3D                         䒵        @                              TWR1.3D                         䒵        Pu                              TWR2.3D                         0        {                              TWR3.3D                         0        ،                              BLDG8.3D                         0        茵                              BLDG8.3D                         0         }                              TWR1.3D                         t    0                                 TWR1.3D                                 ؏                              BLDG1.3D                         ؘ#                                     BLDG1.3D                         ؘ    D                                 BLDG7.3D                                                              BLDG7.3D                                 0                              TWR2.3D                                                               BLDG6.3D 
      BLDG1.3D    BLDG2.3D    BLDG3.3D    BLDG4.3D    BLDG5.3D    BLDG6.3D    BLDG7.3D    BLDG8.3D    BLDG9.3D 	   BLDG10.3D    TWR1.3D    TWR2.3D    TWR3.3D j
       DEFAULT.PAL    MAIN                  % d        S     4    *!	     	 `     Bb     y t    G &      qP     j&I     p;    l&    c&    d:    `F    /	     ?     bK          J      K	     :5z     /a      9Z    L ,      UF      N*    J uL
           (
      K "	                                  {#       v                              BLDG2.3D                                 lx                              BLDG3.3D                         T      z                              BLDG4.3D                         Ԃ{      ,~                              BLDG5.3D                         {                                     BLDG6.3D                             D   Ё                              BLDG7.3D                                                              BLDG8.3D                                                              BLDG9.3D                         艵        \                           	   BLDG10.3D                      	   艵                                      BLDG1.3D                      
   芵                                       BLDG1.3D                                                                BLDG1.3D                         8        쇵                              BLDG2.3D                      
   T        p                              BLDG2.3D                         T                                      BLDG3.3D                         T                                      BLDG3.3D                         T        습                              BLDG3.3D                         T        D                              BLDG4.3D                         萵        T                              BLDG4.3D                         䒵        @                              TWR1.3D                         䒵        Pu                              TWR2.3D                         0        {                              TWR3.3D                         0        ،                              BLDG8.3D                         0        茵                              BLDG8.3D                         0         }                              TWR1.3D                         t    0                                 TWR1.3D                                 ؏                              BLDG1.3D                         ؘ#                                     BLDG1.3D                         ؘ    D                                 BLDG7.3D                                                              BLDG7.3D                                 0                              TWR2.3D                                                               BLDG6.3D 
      BLDG1.3D    BLDG2.3D    BLDG3.3D    BLDG4.3D    BLDG5.3D    BLDG6.3D    BLDG7.3D    BLDG8.3D    BLDG9.3D 	   BLDG10.3D    TWR1.3D    TWR2.3D    TWR3.3D j
       DEFAULT.PAL    MAIN                 c;    h     ]L%    Qy    TO	     _c     s*     2A    7 $l
      -\     X	 FH     $    !      w     Ⱥ      N    N    RO          	 \      	     V 6l     E x      I     0>Y     0 <     p9    U      0                                 ĵ                                     BLDG1.3D                         ĵ,   õ                              BLDG1.3D                         |ɵ       ,                              BLDG1.3D                         |ɵ       õ                              BLDG3.3D                         xʵ,   x   Ƶ                              BLDG3.3D                         \̵5       Ƶ                              BLDG3.3D                         \̵    D   <ǵ                              BLDG2.3D                         \̵        <ʵ                              BLDG2.3D                         ͵       ̵                           	   BLDG11.3D                      	   ͵       `͵                           	   BLDG11.3D                      
   ϵ       \ε                           	   BLDG11.3D                         е       ϵ                           	   BLDG12.3D                         е       Hе                           	   BLDG13.3D                      
   ѵ       xѵ                           	   BLDG13.3D                         8ӵ       0ҵ                           	   BLDG15.3D                         8ӵ       ҵ                           	   BLDG15.3D                         dԵ       pӵ                           	   BLDG15.3D                         $յ       Ե                           	   BLDG15.3D                         ֵ       (յ                           	   BLDG16.3D                         ֵ    D   pֵ                           	   BLDG16.3D                         ׵       ֵ                           	   BLDG16.3D                         ׵    D   ׵                           	   BLDG17.3D                         ڵ?   	   ׵                           	   BLDG17.3D                         ۵       ׵                           	   BLDG18.3D                         ݵ       8۵                           	   BLDG18.3D                         xߵ       H۵                           	   BLDG20.3D                                ۵                           	   BLDG20.3D                         `       hܵ                           	   BLDG20.3D                         ÷       ܵ                           	   BLDG19.3D       BLDG1.3D    BLDG2.3D 	   BLDG11.3D 	   BLDG12.3D 	   BLDG13.3D 	   BLDG15.3D 	   BLDG16.3D 	   BLDG17.3D 	   BLDG18.3D 	   BLDG19.3D 	   BLDG20.3D    BLDG3.3D j
       DEFAULT.PAL    MAIN                  % d        S     4    *!	     	 `     Bb     y t    G &      qP     j&I     p;    l&    c&    d:    `F    /	     ?     bK          J      K	     :5z     /a      9Z    L ,      UF      N*    J uL
           (
      K "	                                  ĵ                                     BLDG2.3D                         |ɵ                                      BLDG3.3D                         |ɵ        ,                              BLDG4.3D                         xʵ        õ                              BLDG5.3D                         xʵ        ĵ                              BLDG6.3D                         \̵        ĵ                              BLDG7.3D                         \̵        Ƶ                              BLDG8.3D                         ̵        Ƶ                              BLDG9.3D                         ͵        <ǵ                           	   BLDG10.3D                      	   ϵ        ,ʵ                              BLDG1.3D                      
   е        <ʵ                              BLDG1.3D                         еD   D   `͵                              BLDG1.3D                         е        \ε                              BLDG2.3D                      
   ѵ        ϵ                              BLDG2.3D                         8ӵ        ϵ                              BLDG3.3D                         8ӵD   D   е                              BLDG3.3D                         dԵ        ѵ                              BLDG3.3D                         ֵ        ҵ                              BLDG4.3D                         ֵ        ҵ                              BLDG4.3D                         ׵        @                              TWR1.3D                         ׵                                      TWR2.3D                         ۵        į                              TWR3.3D                         ۵    4   ӵ                              BLDG8.3D                         ۵      (յ                              BLDG8.3D                         xߵ                                      TWR1.3D                         ߵ                                      TWR1.3D                         `        pֵ                              BLDG1.3D                         ÷        ֵ                              BLDG1.3D                         ÷÷ķ׵                              BLDG7.3D                         ÷        ׵                              BLDG7.3D                         dŷ                                      TWR2.3D                         dŷ        ׵                              BLDG6.3D 
      BLDG1.3D    BLDG2.3D    BLDG3.3D    BLDG4.3D    BLDG5.3D    BLDG6.3D    BLDG7.3D    BLDG8.3D    BLDG9.3D 	   BLDG10.3D    TWR1.3D    TWR2.3D    TWR3.3D j
       DEFAULT.PAL    MAIN                  % d        S     4    *!	     	 `     Bb     y t    G &      qP     j&I     p;    l&    c&    d:    `F    /	     ?     bK          J      K	     :5z     /a      9Z    L ,      UF      N*    J uL
           (
      K "	                                  ĵ                                     BLDG2.3D                         |ɵ                                      BLDG3.3D                         |ɵ        ,                              BLDG4.3D                         xʵ        õ                              BLDG5.3D                         xʵ        ĵ                              BLDG6.3D                         \̵        ĵ                              BLDG7.3D                         \̵        Ƶ                              BLDG8.3D                         ̵        Ƶ                              BLDG9.3D                         ͵        <ǵ                           	   BLDG10.3D                      	   ϵ        ,ʵ                              BLDG1.3D                      
   е        <ʵ                              BLDG1.3D                         еD   D   `͵                              BLDG1.3D                         е        \ε                              BLDG2.3D                      
   ѵ        ϵ                              BLDG2.3D                         8ӵ        ϵ                              BLDG3.3D                         8ӵD   D   е                              BLDG3.3D                         dԵ        ѵ                              BLDG3.3D                         ֵ        ҵ                              BLDG4.3D                         ֵ        ҵ                              BLDG4.3D                         ׵        @                              TWR1.3D                         ׵                                      TWR2.3D                         ۵        į                              TWR3.3D                         ۵    4   ӵ                              BLDG8.3D                         ۵      (յ                              BLDG8.3D                         xߵ                                      TWR1.3D                         ߵ                                      TWR1.3D                         `        pֵ                              BLDG1.3D                         ÷        ֵ                              BLDG1.3D                         ÷÷ķ׵                              BLDG7.3D                         ÷        ׵                              BLDG7.3D                         dŷ                                      TWR2.3D                         dŷ        ׵                              BLDG6.3D 
      BLDG1.3D    BLDG2.3D    BLDG3.3D    BLDG4.3D    BLDG5.3D    BLDG6.3D    BLDG7.3D    BLDG8.3D    BLDG9.3D 	   BLDG10.3D    TWR1.3D    TWR2.3D    TWR3.3D j
       DEFAULT.PAL    MAIN              
   o'Y    +    1p    3    Pr        L    G        U    >        d    
                            t       (~                           
   FACTRY3.3D                         ؄                                  
   FACTRY4.3D                                x                              PUNIT.3D                         ,       @                              PGEN.3D                         ,                                     FTANK.3D                         ,       L                              FTANK.3D                         艵       ܄                           
   FACTRY1.3D                         艵    D                               
   FACTRY1.3D                         芵       Ї                           
   FACTRY1.3D                      	                                     
   FACTRY1.3D                      
                                     
   FACTRY1.3D                         0   p                           
   FACTRY1.3D                         
           Z      
   FACTRY4.3D    
   FACTRY1.3D 
   FACTRY3.3D 
   FACTRY4.3D    PUNIT.3D    PGEN.3D    FTANK.3D j
       DEFAULT.PAL    MAIN                 1p    0j     \F    L    G        U    >        ]    T    ]     o    ^                                           (~                              PUNIT.3D                         ؄       @                              PGEN.3D                                                              FTANK.3D                         ,                                  
   FACTRY1.3D                         ,       L                           
   FACTRY1.3D                         ,       ܄                           
   FACTRY1.3D                         艵                                   
   FACTRY1.3D                         艵    D   Ї                           
   FACTRY1.3D                         芵                                  
   FACTRY1.3D                      	                                     
   FACTRY1.3D                      
          p                           
   FACTRY1.3D                         0                              
   FACTRY1.3D                         
                              
   FACTRY1.3D                      
   ͵
   습                           
   FACTRY1.3D                             
   \                           
   FACTRY1.3D    
   FACTRY1.3D 
   FACTRY3.3D 
   FACTRY4.3D    PUNIT.3D    PGEN.3D    FTANK.3D j
       DEFAULT.PAL    MAIN              
   o'Y    +    1p    3    Pr        L    G        U    >        d    
                            t       (~                           
   FACTRY3.3D                         ؄                                  
   FACTRY4.3D                                x                              PUNIT.3D                         ,       @                              PGEN.3D                         ,                                     FTANK.3D                         ,       L                              FTANK.3D                         艵       ܄                           
   FACTRY1.3D                         艵    D                               
   FACTRY1.3D                         芵       Ї                           
   FACTRY1.3D                      	                                     
   FACTRY1.3D                      
                                     
   FACTRY1.3D                         0   p                           
   FACTRY1.3D                         
           Z      
   FACTRY4.3D    
   FACTRY1.3D 
   FACTRY3.3D 
   FACTRY4.3D    PUNIT.3D    PGEN.3D    FTANK.3D j
       DEFAULT.PAL    MAIN              
   o'Y    +    1p    3    Pr        L    G        U    >        d    
                            t       (~                           
   FACTRY3.3D                         ؄                                  
   FACTRY4.3D                                x                              PUNIT.3D                         ,       @                              PGEN.3D                         ,                                     FTANK.3D                         ,       L                              FTANK.3D                         艵       ܄                           
   FACTRY1.3D                         艵    D                               
   FACTRY1.3D                         芵       Ї                           
   FACTRY1.3D                      	                                     
   FACTRY1.3D                      
                                     
   FACTRY1.3D                         0   p                           
   FACTRY1.3D                         
           Z      
   FACTRY4.3D    
   FACTRY1.3D 
   FACTRY3.3D 
   FACTRY4.3D    PUNIT.3D    PGEN.3D    FTANK.3D j
       DEFAULT.PAL    MAIN              
   o'Y    +    1p    3    Pr        L    G        U    >        d    
                            t       (~                           
   FACTRY3.3D                         ؄                                  
   FACTRY4.3D                                x                              PUNIT.3D                         ,       @                              PGEN.3D                         ,                                     FTANK.3D                         ,       L                              FTANK.3D                         艵       ܄                           
   FACTRY1.3D                         艵    D                               
   FACTRY1.3D                         芵       Ї                           
   FACTRY1.3D                      	                                     
   FACTRY1.3D                      
                                     
   FACTRY1.3D                         0   p                           
   FACTRY1.3D                         
           Z      
   FACTRY4.3D    
   FACTRY1.3D 
   FACTRY3.3D 
   FACTRY4.3D    PUNIT.3D    PGEN.3D    FTANK.3D j
       DEFAULT.PAL    MAIN                 1p    0j     \F    L    G        U    >        ]    T    ]     o    ^                                           (~                              PUNIT.3D                         ؄       @                              PGEN.3D                                                              FTANK.3D                         ,                                  
   FACTRY1.3D                         ,       L                           
   FACTRY1.3D                         ,       ܄                           
   FACTRY1.3D                         艵                                   
   FACTRY1.3D                         艵    D   Ї                           
   FACTRY1.3D                         芵                                  
   FACTRY1.3D                      	                                     
   FACTRY1.3D                      
          p                           
   FACTRY1.3D                         0                              
   FACTRY1.3D                         
                              
   FACTRY1.3D                      
   ͵
   습                           
   FACTRY1.3D                             
   \                           
   FACTRY1.3D    
   FACTRY1.3D 
   FACTRY3.3D 
   FACTRY4.3D    PUNIT.3D    PGEN.3D    FTANK.3D j
       DEFAULT.PAL    MAIN                 1p    0j     \F    L    G        U    >        ]    T    ]     o    ^                                           (~                              PUNIT.3D                         ؄       @                              PGEN.3D                                                              FTANK.3D                         ,                                  
   FACTRY1.3D                         ,       L                           
   FACTRY1.3D                         ,       ܄                           
   FACTRY1.3D                         艵                                   
   FACTRY1.3D                         艵    D   Ї                           
   FACTRY1.3D                         芵                                  
   FACTRY1.3D                      	                                     
   FACTRY1.3D                      
          p                           
   FACTRY1.3D                         0                              
   FACTRY1.3D                         
                              
   FACTRY1.3D                      
   ͵
   습                           
   FACTRY1.3D                             
   \                           
   FACTRY1.3D    
   FACTRY1.3D 
   FACTRY3.3D 
   FACTRY4.3D    PUNIT.3D    PGEN.3D    FTANK.3D j
       DEFAULT.PAL    MAIN                 1p    0j     \F    L    G        U    >        ]    T    ]     o    ^                                           (~                              PUNIT.3D                         ؄       @                              PGEN.3D                                                              FTANK.3D                         ,                                  
   FACTRY1.3D                         ,       L                           
   FACTRY1.3D                         ,       ܄                           
   FACTRY1.3D                         艵                                   
   FACTRY1.3D                         艵    D   Ї                           
   FACTRY1.3D                         芵                                  
   FACTRY1.3D                      	                                     
   FACTRY1.3D                      
          p                           
   FACTRY1.3D                         0                              
   FACTRY1.3D                         
                              
   FACTRY1.3D                      
   ͵
   습                           
   FACTRY1.3D                             
   \                           
   FACTRY1.3D    
   FACTRY1.3D 
   FACTRY3.3D 
   FACTRY4.3D    PUNIT.3D    PGEN.3D    FTANK.3D j
       DEFAULT.PAL    MAIN                z0    0    Qa      }a  ?    0  C    -           0  zQa    z}a  ?  z0  C  z-   z    z0  S       c  Ng  uE                      	   FA_02.PCX        
   A  @                   @   
   A  @                  	   FA_02.PCX        
   A  @   	   A                
   A  @                  	   FA_02.PCX           A           A               A                    	   FA_02.PCX           A     
   A  A         A      A                    	   FA_03.PCX        	   >         0   @      0       	   >                     	   FA_03.PCX        	   >         >  @      0   @   	   >                     	   FA_01.PCX                       ?                                    	   FA_01.PCX                
     ?          ?                          	   FA_01.PCX        
                @              
                        	   FA_01.PCX        
              @          @   
                        	   FA_01.PCX           J          s   @          @      J                      	   FA_01.PCX           6                    `   @      6                      	   FA_01.PCX              ?      6          `   @         ?                  	   FA_01.PCX                       ?      `   @                           	   FA_01.PCX              @         ?      `             @                  	   FA_01.PCX           s          y   @                 s                      	   FA_01.PCX        
   s   @      J               @   
   s   @                  	   FA_01.PCX                  	   6           `   @                            	   FA_01.PCX        	   6       
      ?       `   @   	   6                      	   FA_01.PCX        
      ?                `   @   
      ?                  	   FA_01.PCX              ?         @       `             ?                  	   FA_01.PCX           y   @   
   s                      y   @       j
       DEFAULT.PAL    MAIN                N  |  |  N  /|  N  /    N  |      l|  |  l/|  l/    l|        ٢    |_  _<U  8q    
                     FA02_02.PCX           (                           (                       FA02_02.PCX           (                  (        (                       FA02_01.PCX           <                   ?      <                        FA02_01.PCX           <           ?       <   ?      <                        FA02_01.PCX           <         <   ?        ?      <                        FA02_01.PCX           <           ?              <                        FA02_01.PCX              ?                           ?                     FA02_01.PCX              ?                   ?         ?                     FA02_01.PCX                       ?         ?                              FA02_01.PCX                       ?                         j
       DEFAULT.PAL    MAIN                `  "  }  O  	      `  &s  }  O        D"  }   	      D&s  }           's  }    ڌ}    h             `  's  }   `  ڌ}  O  h    O        h     w  Eg  Qr]   h  f*   wf*  Egf*  Qr] f*                       FA03_02.PCX                                 ?                              FA03_02.PCX                        ?         ?                              FA03_01.PCX           
         3        3  ;      
                        FA03_01.PCX           
         3  ;       
   ;      
                        FA03_01.PCX           
         
   ;      3  ;      
                        FA03_01.PCX           
         3  ;      3        
                        FA03_01.PCX                       ;         ;                              FA03_01.PCX                       ;                                       FA03_02.PCX        
                        ?   
                           FA03_02.PCX        
               ?   	      ?   
                           FA03_01.PCX           
      
   3     	   3  ;      
                        FA03_01.PCX           
      	   3  ;      
   ;      
                        FA03_01.PCX           
         
   ;   
   3  ;      
                        FA03_01.PCX           
      
   3  ;      3        
                        FA03_01.PCX              ;                           ;                     FA03_01.PCX              ;                  ;         ;                     FA03_01.PCX                 
      ;   	      ;                              FA03_01.PCX                 	      ;   
                      j
       DEFAULT.PAL    MAIN                  
     [    [      
     E
   E[  E[    E
     5 !    K    	jun   
                     FA04_02.PCX                                 ?                              FA04_02.PCX                        ?         ?                              FA04_01.PCX                              ?                              FA04_01.PCX                      ?          ?                              FA04_01.PCX                       ?        ?                              FA04_01.PCX                      ?                                      FA04_01.PCX              ?               
            ?                     FA04_01.PCX              ?      
          
   ?         ?                     FA04_01.PCX                       ?      
   ?                              FA04_01.PCX                    
   ?      
                   j
       DEFAULT.PAL    MAIN             8   ƌ       ƌ       u[       u[       ƌ    R  ƌ    R  u[    R  u[    R                +       +           R      R  +    R  +    R  S  1     S  @     "  @     "  1     S  1  R  S  @  R  "  @  R  "  1  R  3f5  8     5  8     DD  8     DD  8     Q	 8   ZQ	 8   ZDD  8   3fDD  8   3f5  :    5  :    DD  :    DD  :    Q	 :  ZQ	 :  ZDD  :  3fDD  :    CD                CD      LSCD    LS  LS    LSCD      U b c  M c  ݰ*c  5 c  y[ b )  A )  Ѷ*)  	5 )  @                  	   AB_01.PCX           r   6      r   |      r   |      r   6                  	   AB_01.PCX           r   6      r   |       r   6      r   6                  	   AB_01.PCX              6      r   6       r   6         6                  	   AB_01.PCX              6       r   6         6         6                  	   AB_01.PCX              |         6         6         |                  	   AB_01.PCX              |         6         |         |                  	   AB_01.PCX           r   <         <         <      r   <                  	   AB_01.PCX           r   <         <      r   <      r   <                  	   AB_01.PCX           r   |      r   6         6      r   |                  	   AB_01.PCX           r   |         6         |      r   |                  	   AB_01.PCX           
   4      
         
         
   4                  	   AB_01.PCX           
   4      
         
   4      
   4                  	   AB_01.PCX        
   X   4      
   4      
   4   
   X   4                  	   AB_01.PCX        
   X   4      
   4   	   X   4   
   X   4                  	   AB_01.PCX           X      
   X   4   	   X   4      X                     	   AB_01.PCX           X      	   X   4   
   X         X                     	   AB_01.PCX           
         X      
   X         
                     	   AB_01.PCX           
      
   X         
         
                     	   AB_01.PCX           
         
   4   
   X   4      
                     	   AB_01.PCX           
      
   X   4      X         
                     	   AB_01.PCX                       -        -                          	   AB_01.PCX                       -                                   	   AB_01.PCX                                                           	   AB_01.PCX                                                           	   AB_01.PCX              -                          -                 	   AB_01.PCX              -                 -        -                 	   AB_01.PCX              -        -        -        -                 	   AB_01.PCX              -        -        -        -                 	   AB_01.PCX              -                          -                 	   AB_01.PCX              -                 -        -                 	   AD_01.PCX                                                           	   AD_01.PCX                                                           	   AD_01.PCX        !                           !                        	   AD_01.PCX        !                            !                        	   AD_01.PCX        %                           %                        	   AD_01.PCX        %                  $         %                        	   AD_01.PCX                  %         !                                  	   AD_01.PCX        !         %         $         !                        	   AD_01.PCX                             :                              	   AD_01.PCX                    :         5                              	   AD_01.PCX           5         :                  5                     	   AD_01.PCX                    :                                       	   AD_01.PCX            :         :                   :                     	   AD_01.PCX            :               '             :                     	   AD_01.PCX        "                     :      "                        	   AD_01.PCX        "            :      !   :      "                        	   AD_01.PCX        $   5         5               $   5                     	   AD_01.PCX        $   5               #         $   5                     	   AD_01.PCX        &                     5      &                        	   AD_01.PCX        &            5      %   5      &                        	   AD_01.PCX        '         &             :      '                        	   AD_01.PCX            :      &         %   5          :                     	   AD_01.PCX        !   :      $   5      #         !   :                     	   AD_01.PCX        !   :      #         "         !   :                        FA05_01.PCX        -         ,         (      ?   -                           FA05_01.PCX        -         (      ?   )      ?   -                        	   AD_01.PCX        +      .   *      .   )         +      .                  	   AD_01.PCX        +      .   )         (         +      .                  	   AD_01.PCX        /      .   ,         -         /      .                  	   AD_01.PCX        /      .   -         .      .   /      .                  	   AD_01.PCX        ,         /      .   +      .   ,                        	   AD_01.PCX        ,         +      .   (         ,                        	   AD_01.PCX        .      .   -         )         .      .                  	   AD_01.PCX        .      .   )         *      .   .      .       j
       DEFAULT.PAL    MAIN                 O  A         
h    (	 @    d
 Ɔ     #x     Ls           GbRN    Q Fl         T     6o      N3                                        @                           
   BSECMD1.3D                         T                               FTANK.3D                         ܚ                                     ADUMP.3D                         P       ܘ                           	   BUNKER.3D                         l5                                  
   COMCTR1.3D                         D5                                 TSX1.3D                         D    D                                 EWR.3D                         DT   쉵                              AX10.3D                                L                              MK1P.3D                      	   ~   􌵂                              AX10.3D                      
   9  p                              MK1P.3D                             	                                 MK3P.3D                         \4       \                              MECH1.3D                      
   D>       l                              GCV1A.3D 
   
   BSECMD1.3D    FTANK.3D    ADUMP.3D 	   BUNKER.3D 
   COMCTR1.3D    TSX1.3D    EWR.3D    AX10.3D    MK1P.3D    MK3P.3D    MECH1.3D    GCV1A.3D    RADAR.3D j
       DEFAULT.PAL    MAIN                 O  A         
h    (	 @    d
 Ɔ     #x     Ls           GbRN    Q Fl         T     6o      N3                                        @                           
   BSECMD1.3D                         T                               FTANK.3D                         ܚ                                     ADUMP.3D                         P       ܘ                           	   BUNKER.3D                         l5                                  
   COMCTR1.3D                         D5                                 TSX1.3D                         D    D                                 EWR.3D                         DT   쉵                              AX10.3D                                L                              MK1P.3D                      	   ~   􌵂                              AX10.3D                      
   9  p                              MK1P.3D                             	                                 MK3P.3D                         \4       \                              MECH1.3D                      
   D>       l                              GCV1A.3D 
   
   BSECMD1.3D    FTANK.3D    ADUMP.3D 	   BUNKER.3D 
   COMCTR1.3D    TSX1.3D    EWR.3D    AX10.3D    MK1P.3D    MK3P.3D    MECH1.3D    GCV1A.3D    RADAR.3D j
       DEFAULT.PAL    MAIN                 O  A         
h    (	 @    d
 Ɔ     #x     Ls           GbRN    Q Fl         T     6o      N3                                        @                           
   BSECMD1.3D                         T                               FTANK.3D                         ܚ                                     ADUMP.3D                         P       ܘ                           	   BUNKER.3D                         l5                                  
   COMCTR1.3D                         D5                                 TSX1.3D                         D    D                                 EWR.3D                         DT   쉵                              AX10.3D                                L                              MK1P.3D                      	   ~   􌵂                              AX10.3D                      
   9  p                              MK1P.3D                             	                                 MK3P.3D                         \4       \                              MECH1.3D                      
   D>       l                              GCV1A.3D 
   
   BSECMD1.3D    FTANK.3D    ADUMP.3D 	   BUNKER.3D 
   COMCTR1.3D    TSX1.3D    EWR.3D    AX10.3D    MK1P.3D    MK3P.3D    MECH1.3D    GCV1A.3D    RADAR.3D j
       DEFAULT.PAL    MAIN                 O  A         
h    (	 @    d
 Ɔ     #x     Ls           GbRN    Q Fl         T     6o      N3                                        @                           
   BSECMD1.3D                         T                               FTANK.3D                         ܚ                                     ADUMP.3D                         P       ܘ                           	   BUNKER.3D                         l5                                  
   COMCTR1.3D                         D5                                 TSX1.3D                         D    D                                 EWR.3D                         DT   쉵                              AX10.3D                                L                              MK1P.3D                      	   ~   􌵂                              AX10.3D                      
   9  p                              MK1P.3D                             	                                 MK3P.3D                         \4       \                              MECH1.3D                      
   D>       l                              GCV1A.3D 
   
   BSECMD1.3D    FTANK.3D    ADUMP.3D 	   BUNKER.3D 
   COMCTR1.3D    TSX1.3D    EWR.3D    AX10.3D    MK1P.3D    MK3P.3D    MECH1.3D    GCV1A.3D    RADAR.3D j
       DEFAULT.PAL    MAIN                 O  A         
h    (	 @    d
 Ɔ     #x     Ls           GbRN    Q Fl         T     6o      N3                                        @                           
   BSECMD1.3D                         T                               FTANK.3D                         ܚ                                     ADUMP.3D                         P       ܘ                           	   BUNKER.3D                         l5                                  
   COMCTR1.3D                         D5                                 TSX1.3D                         D    D                                 EWR.3D                         DT   쉵                              AX10.3D                                L                              MK1P.3D                      	   ~   􌵂                              AX10.3D                      
   9  p                              MK1P.3D                             	                                 MK3P.3D                         \4       \                              MECH1.3D                      
   D>       l                              GCV1A.3D 
   
   BSECMD1.3D    FTANK.3D    ADUMP.3D 	   BUNKER.3D 
   COMCTR1.3D    TSX1.3D    EWR.3D    AX10.3D    MK1P.3D    MK3P.3D    MECH1.3D    GCV1A.3D    RADAR.3D j
       DEFAULT.PAL    MAIN                 O  A         
h    (	 @    d
 Ɔ     #x     Ls           GbRN    Q Fl         T     6o      N3                                        @                           
   BSECMD1.3D                         T                               FTANK.3D                         ܚ                                     ADUMP.3D                         P       ܘ                           	   BUNKER.3D                         l5                                  
   COMCTR1.3D                         D5                                 TSX1.3D                         D    D                                 EWR.3D                         DT   쉵                              AX10.3D                                L                              MK1P.3D                      	   ~   􌵂                              AX10.3D                      
   9  p                              MK1P.3D                             	                                 MK3P.3D                         \4       \                              MECH1.3D                      
   D>       l                              GCV1A.3D 
   
   BSECMD1.3D    FTANK.3D    ADUMP.3D 	   BUNKER.3D 
   COMCTR1.3D    TSX1.3D    EWR.3D    AX10.3D    MK1P.3D    MK3P.3D    MECH1.3D    GCV1A.3D    RADAR.3D j
       DEFAULT.PAL    MAIN                 O  A         
h    (	 @    d
 Ɔ     #x     Ls           GbRN    Q Fl         T     6o      N3                                        @                           
   BSECMD1.3D                         T                               FTANK.3D                         ܚ                                     ADUMP.3D                         P       ܘ                           	   BUNKER.3D                         l5                                  
   COMCTR1.3D                         D5                                 TSX1.3D                         D    D                                 EWR.3D                         DT   쉵                              AX10.3D                                L                              MK1P.3D                      	   ~   􌵂                              AX10.3D                      
   9  p                              MK1P.3D                             	                                 MK3P.3D                         \4       \                              MECH1.3D                      
   D>       l                              GCV1A.3D 
   
   BSECMD1.3D    FTANK.3D    ADUMP.3D 	   BUNKER.3D 
   COMCTR1.3D    TSX1.3D    EWR.3D    AX10.3D    MK1P.3D    MK3P.3D    MECH1.3D    GCV1A.3D    RADAR.3D j
       DEFAULT.PAL    MAIN                 O  A         
h    (	 @    d
 Ɔ     #x     Ls           GbRN    Q Fl         T     6o      N3                                        @                           
   BSECMD1.3D                         T                               FTANK.3D                         ܚ                                     ADUMP.3D                         P       ܘ                           	   BUNKER.3D                         l5                                  
   COMCTR1.3D                         D5                                 TSX1.3D                         D    D                                 EWR.3D                         DT   쉵                              AX10.3D                                L                              MK1P.3D                      	   ~   􌵂                              AX10.3D                      
   9  p                              MK1P.3D                             	                                 MK3P.3D                         \4       \                              MECH1.3D                      
   D>       l                              GCV1A.3D 
   
   BSECMD1.3D    FTANK.3D    ADUMP.3D 	   BUNKER.3D 
   COMCTR1.3D    TSX1.3D    EWR.3D    AX10.3D    MK1P.3D    MK3P.3D    MECH1.3D    GCV1A.3D    RADAR.3D j
       DEFAULT.PAL    MAIN                      +~     [    n    {-    c
     u)    b
      NF0          @           t.y     @ 6I    4/ Z   JI  U4  N                                      <       @                              FTANK.3D                         D       \                              ADUMP.3D                         L~       0                           	   BUNKER.3D                         p                              TSX1.3D                         оX                              EWR.3D                         ׵lص쉵                              AX10.3D                         \y       L                              MK1P.3D                         Xy       􌵂                              AX10.3D                                p                              MK1P.3D                      	       D                                 MK3P.3D                      
           H                              MECH1.3D                                                              GCV1A.3D                             D                              
   COMCTR2.3D                      
   쭵~       P                              RADAR.3D                         ~                                     MECH2.3D                         ~                                  
   BSECMD5.3D       FTANK.3D    ADUMP.3D 	   BUNKER.3D    TSX1.3D    EWR.3D    AX10.3D    MK1P.3D    MK3P.3D    MECH1.3D    GCV1A.3D 
   COMCTR2.3D    RADAR.3D    MECH2.3D 
   BSECMD5.3D j
       DEFAULT.PAL    MAIN                      +~     [    n    {-    c
     u)    b
      NF0          @           t.y     @ 6I    4/ Z   JI  U4  N                                      <       @                              FTANK.3D                         D       \                              ADUMP.3D                         L~       0                           	   BUNKER.3D                         p                              TSX1.3D                         оX                              EWR.3D                         ׵lص쉵                              AX10.3D                         \y       L                              MK1P.3D                         Xy       􌵂                              AX10.3D                                p                              MK1P.3D                      	       D                                 MK3P.3D                      
           H                              MECH1.3D                                                              GCV1A.3D                             D                              
   COMCTR2.3D                      
   쭵~       P                              RADAR.3D                         ~                                     MECH2.3D                         ~                                  
   BSECMD5.3D       FTANK.3D    ADUMP.3D 	   BUNKER.3D    TSX1.3D    EWR.3D    AX10.3D    MK1P.3D    MK3P.3D    MECH1.3D    GCV1A.3D 
   COMCTR2.3D    RADAR.3D    MECH2.3D 
   BSECMD5.3D j
       DEFAULT.PAL    MAIN                      +~     [    n    {-    c
     u)    b
      NF0          @           t.y     @ 6I    4/ Z   JI  U4  N                                      <       @                              FTANK.3D                         D       \                              ADUMP.3D                         L~       0                           	   BUNKER.3D                         p                              TSX1.3D                         оX                              EWR.3D                         ׵lص쉵                              AX10.3D                         \y       L                              MK1P.3D                         Xy       􌵂                              AX10.3D                                p                              MK1P.3D                      	       D                                 MK3P.3D                      
           H                              MECH1.3D                                                              GCV1A.3D                             D                              
   COMCTR2.3D                      
   쭵~       P                              RADAR.3D                         ~                                     MECH2.3D                         ~                                  
   BSECMD5.3D       FTANK.3D    ADUMP.3D 	   BUNKER.3D    TSX1.3D    EWR.3D    AX10.3D    MK1P.3D    MK3P.3D    MECH1.3D    GCV1A.3D 
   COMCTR2.3D    RADAR.3D    MECH2.3D 
   BSECMD5.3D j
       DEFAULT.PAL    MAIN                      +~     [    n    {-    c
     u)    b
      NF0          @           t.y     @ 6I    4/ Z   JI  U4  N                                      <       @                              FTANK.3D                         D       \                              ADUMP.3D                         L~       0                           	   BUNKER.3D                         p                              TSX1.3D                         оX                              EWR.3D                         ׵lص쉵                              AX10.3D                         \y       L                              MK1P.3D                         Xy       􌵂                              AX10.3D                                p                              MK1P.3D                      	       D                                 MK3P.3D                      
           H                              MECH1.3D                                                              GCV1A.3D                             D                              
   COMCTR2.3D                      
   쭵~       P                              RADAR.3D                         ~                                     MECH2.3D                         ~                                  
   BSECMD5.3D       FTANK.3D    ADUMP.3D 	   BUNKER.3D    TSX1.3D    EWR.3D    AX10.3D    MK1P.3D    MK3P.3D    MECH1.3D    GCV1A.3D 
   COMCTR2.3D    RADAR.3D    MECH2.3D 
   BSECMD5.3D j
       DEFAULT.PAL    MAIN                      +~     [    n    {-    c
     u)    b
      NF0          @           t.y     @ 6I    4/ Z   JI  U4  N                                      <       @                              FTANK.3D                         D       \                              ADUMP.3D                         L~       0                           	   BUNKER.3D                         p                              TSX1.3D                         оX                              EWR.3D                         ׵lص쉵                              AX10.3D                         \y       L                              MK1P.3D                         Xy       􌵂                              AX10.3D                                p                              MK1P.3D                      	       D                                 MK3P.3D                      
           H                              MECH1.3D                                                              GCV1A.3D                             D                              
   COMCTR2.3D                      
   쭵~       P                              RADAR.3D                         ~                                     MECH2.3D                         ~                                  
   BSECMD5.3D       FTANK.3D    ADUMP.3D 	   BUNKER.3D    TSX1.3D    EWR.3D    AX10.3D    MK1P.3D    MK3P.3D    MECH1.3D    GCV1A.3D 
   COMCTR2.3D    RADAR.3D    MECH2.3D 
   BSECMD5.3D j
       DEFAULT.PAL    MAIN                      +~     [    n    {-    c
     u)    b
      NF0          @           t.y     @ 6I    4/ Z   JI  U4  N                                      <       @                              FTANK.3D                         D       \                              ADUMP.3D                         L~       0                           	   BUNKER.3D                         p                              TSX1.3D                         оX                              EWR.3D                         ׵lص쉵                              AX10.3D                         \y       L                              MK1P.3D                         Xy       􌵂                              AX10.3D                                p                              MK1P.3D                      	       D                                 MK3P.3D                      
           H                              MECH1.3D                                                              GCV1A.3D                             D                              
   COMCTR2.3D                      
   쭵~       P                              RADAR.3D                         ~                                     MECH2.3D                         ~                                  
   BSECMD5.3D       FTANK.3D    ADUMP.3D 	   BUNKER.3D    TSX1.3D    EWR.3D    AX10.3D    MK1P.3D    MK3P.3D    MECH1.3D    GCV1A.3D 
   COMCTR2.3D    RADAR.3D    MECH2.3D 
   BSECMD5.3D j
       DEFAULT.PAL    MAIN                      +~     [    n    {-    c
     u)    b
      NF0          @           t.y     @ 6I    4/ Z   JI  U4  N                                      <       @                              FTANK.3D                         D       \                              ADUMP.3D                         L~       0                           	   BUNKER.3D                         p                              TSX1.3D                         оX                              EWR.3D                         ׵lص쉵                              AX10.3D                         \y       L                              MK1P.3D                         Xy       􌵂                              AX10.3D                                p                              MK1P.3D                      	       D                                 MK3P.3D                      
           H                              MECH1.3D                                                              GCV1A.3D                             D                              
   COMCTR2.3D                      
   쭵~       P                              RADAR.3D                         ~                                     MECH2.3D                         ~                                  
   BSECMD5.3D       FTANK.3D    ADUMP.3D 	   BUNKER.3D    TSX1.3D    EWR.3D    AX10.3D    MK1P.3D    MK3P.3D    MECH1.3D    GCV1A.3D 
   COMCTR2.3D    RADAR.3D    MECH2.3D 
   BSECMD5.3D j
       DEFAULT.PAL    MAIN                      +~     [    n    {-    c
     u)    b
      NF0          @           t.y     @ 6I    4/ Z   JI  U4  N                                      <       @                              FTANK.3D                         D       \                              ADUMP.3D                         L~       0                           	   BUNKER.3D                         p                              TSX1.3D                         оX                              EWR.3D                         ׵lص쉵                              AX10.3D                         \y       L                              MK1P.3D                         Xy       􌵂                              AX10.3D                                p                              MK1P.3D                      	       D                                 MK3P.3D                      
           H                              MECH1.3D                                                              GCV1A.3D                             D                              
   COMCTR2.3D                      
   쭵~       P                              RADAR.3D                         ~                                     MECH2.3D                         ~                                  
   BSECMD5.3D       FTANK.3D    ADUMP.3D 	   BUNKER.3D    TSX1.3D    EWR.3D    AX10.3D    MK1P.3D    MK3P.3D    MECH1.3D    GCV1A.3D 
   COMCTR2.3D    RADAR.3D    MECH2.3D 
   BSECMD5.3D j
       DEFAULT.PAL    MAIN              
        A             R    q  d      nq    D  
     YF       =  j    	                            ġ                                     PUNIT.3D                                                              PGEN.3D                         4P@                              FTANK.3D                         p͵͵`                           	   BLDG11.3D                         :   p                           	   NPLANT.3D                         \:       쉵                              AX25.3D                         D&       L                              MK2D.3D                             $   H                              GCV1A.3D                      	          Р                              MECH1.3D 	   	   BLDG11.3D    FTANK.3D    PGEN.3D    PUNIT.3D 	   NPLANT.3D    AX25.3D    MK2D.3D    GCV1A.3D    MECH1.3D j
       DEFAULT.PAL    MAIN                 J    6r     lPi     XU        R    T  r
  h     t     N h r
  7     b  r
  " ɶ    	                            d                                  	   SPLANT.3D                         Į       @                              PUNIT.3D                                $                              PGEN.3D                                                               FTANK.3D                         X                                  	   BLDG11.3D                         X       p                              AX25.3D                         𳵂   @                                 AX25.3D                      	          t                              MK1D.3D                         J                                     GCV1B.3D    	   SPLANT.3D 	   BLDG11.3D    FTANK.3D    PGEN.3D    PUNIT.3D    AX25.3D    MK1D.3D    GCV1B.3D j
       DEFAULT.PAL    MAIN                 T               R             v+    S  {     ̙  ɘ         c                                          x                              PUNIT.3D                         ĵ       p                              PGEN.3D                         ĵ                                     FTANK.3D                         |ɵ,       <                           	   BLDG11.3D                         |ɵ    D   T                              ADUMP.3D                         xʵ                                     ADUMP.3D                         xʵ    D   x                              AX10.3D                         \̵                                     AX10.3D                         \̵    D   į                              MK2D.3D                      	   ̵                                      MK2D.3D                      
   ͵.       ,                              GCV2A.3D    	   BLDG11.3D    FTANK.3D    PGEN.3D    PUNIT.3D    ADUMP.3D    AX10.3D    MK2D.3D    GCV2A.3D j
       DEFAULT.PAL    MAIN                =  \@  f =  f               =\@  f =f K    K       o    @  76   wX     A  ǆ =A  P8~A  9y A                    
   SKYS01.PCX           ?                        ?      ?                      
   SKYS01.PCX           ?              ?      ?   ?      ?                         SKYS_01.PCX                       
     >   
                             SKYS_01.PCX                    >   
      >                                 SKYS_01.PCX              
              >            
                    SKYS_01.PCX              
     >         >   
        
                    SKYS_01.PCX           ?   
         
               ?   
                    SKYS_01.PCX           ?   
                ?         ?   
                    SKYS_01.PCX           ?   
     ?                   ?   
                    SKYS_01.PCX           ?   
                   
     ?   
        @ANIMATE-XPLG2,0,-1                        (H	   Fk<
   4'1   Hhh   P      @ANIMATE-XPL6,0,-2                        (
   Hh)   P:4'   hF   P:4'    j
       DEFAULT.PAL    MAIN                {m  R  4  {m  O4  {m  O    {m  R      R  4  O4  O    R      ؚ  z   ^O)    y )   [)  !M)  X  )  
                  
   SB01_B.PCX                                 ?                           
   SB01_B.PCX                        ?         ?                           
   SB01_A.PCX           ,   $         $               ,   $                  
   SB01_A.PCX           ,   $                ,         ,   $                  
   SB01_A.PCX           ,   $      ,                  ,   $                  
   SB01_A.PCX           ,   $                  $      ,   $                  
   SB01_A.PCX                       $      3   $                           
   SB01_A.PCX                    3   $       3                              
   SB01_A.PCX              $               3            $                  
   SB01_A.PCX              $      3         3   $         $       j
       DEFAULT.PAL    MAIN                m  M    m            .     7M    7  p    p.     0e     p  )  q   
                  
   SB02_B.PCX                                 ?                           
   SB02_B.PCX                        ?         ?                           
   SB02_A.PCX           
         3        3  ;      
                     
   SB02_A.PCX           
         3  ;       
   ;      
                     
   SB02_A.PCX           
         
   ;      3  ;      
                     
   SB02_A.PCX           
         3  ;      3        
                     
   SB02_A.PCX              ;                           ;                  
   SB02_A.PCX              ;                   ;         ;                  
   SB02_A.PCX                       ;         ;                           
   SB02_A.PCX                       ;                         j
       DEFAULT.PAL    MAIN                f    [ f  [ f      f          [ [            @   X    xG  ;#   
                  
   SB03_B.PCX                                 ?                           
   SB03_B.PCX                        ?         ?                           
   SB03_A.PCX              J         J                   J                  
   SB03_A.PCX              J                              J                  
   SB03_A.PCX              J                             J                  
   SB03_A.PCX              J                   J         J                  
   SB03_A.PCX                        J      >   J                            
   SB03_A.PCX                     >   J       >                                
   SB03_A.PCX              J                >             J                  
   SB03_A.PCX              J      >          >   J         J       j
       DEFAULT.PAL    MAIN                  y     ,    ,      y     wy   w,  w,    wy     # |   DY   d  ԚlG   
                  
   SB04_A.PCX              @      %   @       %             @                  
   SB04_A.PCX              @       %                       @                  
   SB04_B.PCX           8         @        @         8                     
   SB04_B.PCX           8         @          8          8                     
   SB04_B.PCX           8         8          @         8                     
   SB04_B.PCX           8         @         @        8                     
   SB04_B.PCX                                                             
   SB04_B.PCX                                                               
   SB04_B.PCX                                                             
   SB04_B.PCX                                                 j
       DEFAULT.PAL    MAIN                &       &     &       &         Z     Z   Z     Z        ;   ) L  p  #   
                  
   SB05_B.PCX                                 ?                           
   SB05_B.PCX                        ?         ?                           
   SB05_A.PCX                                ;                           
   SB05_A.PCX                       ;          ;                           
   SB05_A.PCX                       ;         ;                           
   SB05_A.PCX                       ;                                    
   SB05_A.PCX              ;               (            ;                  
   SB05_A.PCX              ;      (          (   ;         ;                  
   SB05_A.PCX                       ;      (   ;                           
   SB05_A.PCX                    (   ;      (                   j
       DEFAULT.PAL    MAIN                  L(               L(     4L(   4  4    4L(     ;     X  d   xA   
                  
   SB06_B.PCX                    +          +   8                           
   SB06_B.PCX                     +   8         8                           
   SB06_A.PCX           +   ?         ?               +   ?                  
   SB06_A.PCX           +   ?                +         +   ?                  
   SB06_A.PCX           +   ?      +                  +   ?                  
   SB06_A.PCX           +   ?                  ?      +   ?                  
   SB06_A.PCX                       ?      8   ?                           
   SB06_A.PCX                    8   ?       8                              
   SB06_A.PCX              ?               8            ?                  
   SB06_A.PCX              ?      8         8   ?         ?       j
       DEFAULT.PAL    MAIN                v  @ & v  l& v  l    v  @     [@ & [l& [l    [@     O  P  ! P  ڴ$P  TjU P  
                  
   SB07_B.PCX                    !          !   ?                           
   SB07_B.PCX                     !   ?         ?                           
   SB07_A.PCX              ;         ;                  ;                  
   SB07_A.PCX              ;                            ;                  
   SB07_A.PCX              ;                           ;                  
   SB07_A.PCX              ;                  ;         ;                  
   SB07_A.PCX                         ;      a   ;                            
   SB07_A.PCX                     a   ;       a                               
   SB07_A.PCX               ;                a             ;                  
   SB07_A.PCX               ;      a         a   ;          ;       j
       DEFAULT.PAL    MAIN                vz   B  vz  B  vz      vz        B  B            zI   .   XvF  ¨   
                  
   SB08_B.PCX           @  H      #   H       #          @  H                  
   SB08_B.PCX           @  H       #          @         @  H                  
   SB08_A.PCX           "         ?        ?  ?      "                     
   SB08_A.PCX           "         ?  ?       "   ?      "                     
   SB08_A.PCX           "         "   ?      ?  ?      "                     
   SB08_A.PCX           "         ?  ?      ?        "                     
   SB08_A.PCX               ?                H             ?                  
   SB08_A.PCX               ?      H          H   ?          ?                  
   SB08_A.PCX                         ?      H   ?                            
   SB08_A.PCX                     H   ?      H                    j
       DEFAULT.PAL    MAIN                Tx  s  5M Tx  5M Tx      Tx  s      s  5M 5M     s        u   k c  _      
                  
   SKYS08.PCX           ?   ?          ?                  ?   ?                  
   SKYS08.PCX           ?   ?                  ?          ?   ?                     SKYS_08.PCX           b         b                   b                        SKYS_08.PCX           b                              b                        SKYS_08.PCX           b         b                   b                        SKYS_08.PCX           b                             b                        SKYS_08.PCX                    ^         ^                                 SKYS_08.PCX                    ^                                           SKYS_08.PCX                             ^                                 SKYS_08.PCX                    ^         ^                   j
       DEFAULT.PAL    MAIN                bp  	  _  bp  :_  bp  :    bp  	      	  o  :o  :    	        p   e /  w$$      
                  
   SB10_B.PCX                                                            
   SB10_B.PCX                                                            
   SB10_A.PCX                                                           
   SB10_A.PCX                                                            
   SB10_A.PCX              ?                           ?                  
   SB10_A.PCX              ?                  ?         ?                  
   SB10_A.PCX                       ?         ?                           
   SB10_A.PCX              K                            K                  
   SB10_A.PCX                       K                                    
   SB10_A.PCX                                                j
       DEFAULT.PAL    MAIN                  l  ܷ   "ܷ   "      l      j+l  ܷ j+"ܷ j+"    j+l        r   o\   1  v     r #  o\ #  1#  v #  
                     SKYS_03.PCX              y         7          7         y                     SKYS_03.PCX              y          7         y         y                  
   SKYS03.PCX           7   ^     y   ^     y   >      7   ^                 
   SKYS03.PCX           7   ^     y   >       7   >      7   ^                 
   SKYS03.PCX           7   ^     7   >      y   >      7   ^                 
   SKYS03.PCX           7   ^     y   >      y   ^     7   ^                 
   SKYS03.PCX              >         ^        ^        >                  
   SKYS03.PCX              >         ^         >         >                  
   SKYS03.PCX              ^        >         >         ^                 
   SKYS03.PCX              ^        >         ^        ^      j
       DEFAULT.PAL    MAIN                  <     f   f      <      ]`<   ]`f ]`f    ]`<           ` &  ?  W
      i;  ` &i;  ?i;  W
 i;    H w  p[ 0(w  X ̰w   w  
                     SKYS_04.PCX           A   ~         ~          >      A   ~                     SKYS_04.PCX           A   ~          >      A   >      A   ~                  
   SKYS04.PCX           >   ?      >                  >   ?                  
   SKYS04.PCX           >   ?                   ?      >   ?                  
   SKYS04.PCX           >         >   ?         ?      >                     
   SKYS04.PCX           >            ?               >                     
   SKYS04.PCX                    =         =   ?                           
   SKYS04.PCX                    =   ?          ?                           
   SKYS04.PCX                       ?      =   ?                           
   SKYS04.PCX                    =   ?      =                   j
       DEFAULT.PAL    MAIN                  (  U   qU   q      (      k(  U kqU kq    k(         i  e 'i  5i   i  Z  5  Lg X5  f5    5  
                     SKYS_05.PCX           ?   ?          ?                  ?   ?                     SKYS_05.PCX           ?   ?                  ?          ?   ?                  
   SKYS05.PCX                        3     /   3                           
   SKYS05.PCX                     /   3      /                                
   SKYS05.PCX              3               /             3                 
   SKYS05.PCX              3     /          /   3        3                 
   SKYS05.PCX              3     1   3     1             3                 
   SKYS05.PCX              3     1                        3                 
   SKYS05.PCX              3               1             3                 
   SKYS05.PCX              3     1          1   3        3      j
       DEFAULT.PAL    MAIN                m  O   m  m m  m    m  O      gO   gm gm    gO       y %  ֑ %  Zv%  h^# %    )   6)  :Dp)  H_ )  
                     SKYS_06.PCX           ?   ?          ?                  ?   ?                     SKYS_06.PCX           ?   ?                  ?          ?   ?                  
   SKYS06.PCX                              `                              
   SKYS06.PCX                     `         `                               
   SKYS06.PCX                              `                              
   SKYS06.PCX                    `         `                             
   SKYS06.PCX                   ]        ]                             
   SKYS06.PCX                   ]                                       
   SKYS06.PCX                            ]                             
   SKYS06.PCX                   ]         ]                 j
       DEFAULT.PAL    MAIN                .  Q  .  .  p.  Q  pQ    pQ  ph  w =R =_R=t6  =
                     SKYS_07.PCX           ;                            ;                        SKYS_07.PCX           ;                   ;         ;                     
   SKYS07.PCX                    ;         ;   :                           
   SKYS07.PCX                    ;   :          :                           
   SKYS07.PCX              *              ;            *                 
   SKYS07.PCX              *     ;         ;   *        *                 
   SKYS07.PCX                       *     ?   *                          
   SKYS07.PCX                    ?   *      ?                              
   SKYS07.PCX              *              ?            *                 
   SKYS07.PCX                    ?   :      ?                   j
       DEFAULT.PAL    MAIN                c  Fg  N c  N c      c  Fg      ^Fg  N ^N ^    ^Fg       %    L  V  X@>     ( #  G 2O#  #  A  #  
                  
   SKYS09.PCX           ?   ?          ?                  ?   ?                  
   SKYS09.PCX           ?   ?                  ?          ?   ?                     SKYS_09.PCX           b         b                   b                        SKYS_09.PCX           b                              b                        SKYS_09.PCX           b         b                   b                        SKYS_09.PCX           b                             b                        SKYS_09.PCX                    ^         ^                                 SKYS_09.PCX                    ^                                           SKYS_09.PCX                             ^                                 SKYS_09.PCX                    ^         ^                   j
       DEFAULT.PAL    MAIN                	X      	X  5 z    z5     5 `      y=  P      `  5 y=  P  5 +      Է  nt  \D  ,    ݊  e      ,u  M_E  /    
                     SKYS_10.PCX           @         4   ;         <      @                        SKYS_10.PCX           @            <   	             @                        SKYS_10.PCX           @   [   	       ]         ?      @   [                  
   SKYS10.PCX           @           @   T         T     @                      
   SKYS10.PCX           @              T  	              @                      
   SKYS10.PCX           @          @   T          T     @                      
   SKYS10.PCX           @               T                @                      
   SKYS10.PCX                        T     ?   T                           
   SKYS10.PCX                     ?   T     ?                                
   SKYS10.PCX                        T     >   T                           
   SKYS10.PCX                     >   T     >                                
   SKYS10.PCX        	                T     >   T  	                         
   SKYS10.PCX        	             >   T     >       	              j
       DEFAULT.PAL    MAIN                Tx  s  5M Tx  5M Tx      Tx  s      s  5M 5M     s      z   {  d o{  _{  ,? {    ڷ )   )  n^)  A )  
                  
   SKYS08.PCX           ?   ?          ?                  ?   ?                  
   SKYS08.PCX           ?   ?                  ?          ?   ?                     SKYS_08.PCX           b         b                   b                        SKYS_08.PCX           b                              b                        SKYS_08.PCX           b         b                   b                        SKYS_08.PCX           b                             b                        SKYS_08.PCX                    ^         ^                                 SKYS_08.PCX                    ^                                           SKYS_08.PCX                             ^                                 SKYS_08.PCX                    ^         ^                   j
       DEFAULT.PAL    MAIN                l    1 l  vB1 l  vB    l        L  Y* LvBY* LvB    L           q  lq  k     Pf   qPf  lqPf  k Pf  
                     SKYS_02.PCX           ?                          ?      ?                         SKYS_02.PCX           ?               ?      ?   ?      ?                      
   SKYS02.PCX           =   !      =                  =   !                  
   SKYS02.PCX           =   !                   T      =   !                  
   SKYS02.PCX           =         =   !         T      =                     
   SKYS02.PCX           =                           =                     
   SKYS02.PCX                    >         >                              
   SKYS02.PCX                    >                                        
   SKYS02.PCX                       !      >   !                           
   SKYS02.PCX                    >   !      >                   j
       DEFAULT.PAL    MAIN                (o    r        t    0 hp      t O /      w  }X   O ) e   e  we  }d e  	                  	   TW_01.PCX               ?      ?   ?       ?            ?                  	   TW_01.PCX           @   ?               ?        @   ?                  	   TW_01.PCX               ?      ?   ?      @            ?                  	   TW_01.PCX               ?      @                      ?                  	   TW_01.PCX               ?      ?   ?      ?            ?                  	   TW_01.PCX               ?      ?                     ?                  	   TW_01.PCX              ?         ?          ?         ?                  	   TW_01.PCX           ?   ?         ?         ?      ?   ?                  	   TW_01.PCX               ?         ?      ?   ?          ?       j
       DEFAULT.PAL    MAIN                *    X *  [X   ݪ      $U        X [X Nݪ    N$U      K6   i&    i&  @i&  / i&  K6   a    a  @a  / a  
                  	   TW_02.PCX           %   
      7                  %   
                  	   TW_02.PCX           %   
                   
      %   
                  	   TW_02.PCX           7         %   
         
      7                     	   TW_02.PCX           7            
               7                     	   TW_02.PCX           	         6         %   
      	                     	   TW_02.PCX           	         %   
          
      	                     	   TW_02.PCX           %   
         
          
      %   
                  	   TW_02.PCX           %   
          
      %   
      %   
                  	   TW_02.PCX           	            
      %   
      	                     	   TW_02.PCX           	         %   
      6         	          j
       DEFAULT.PAL    MAIN                
+  	  Z 
+  Z t      t  -      	  Z Z N    N-               )   #      j    j  )j   # j  
                  	   TW_03.PCX           %   
      7                  %   
                  	   TW_03.PCX           %   
                   
      %   
                  	   TW_03.PCX           7         %   
         
      7                     	   TW_03.PCX           7            
               7                     	   TW_03.PCX           	         6         %   
      	                     	   TW_03.PCX           	         %   
          
      	                     	   TW_03.PCX           %   
         
          
      %   
                  	   TW_03.PCX           %   
          
      %   
      %   
                  	   TW_03.PCX           	            
      %   
      	                     	   TW_03.PCX           	         %   
      6         	          j
       DEFAULT.PAL    MAIN                       C|       C%    { ] Ԑ   c   ,o  #Bf   i Ԑ 3q  ] 3q  ,o3q  /<f 3q  	                  	   TW_04.PCX                             7                             	   TW_04.PCX                    7                                      	   TW_04.PCX                                                           	   TW_04.PCX                              7                             	   TW_04.PCX                     7                                     	   TW_04.PCX                                                          	   TW_04.PCX                             7                             	   TW_04.PCX                    7                                     	   TW_04.PCX                                               j
       DEFAULT.PAL    MAIN                       2 {  3    {  v         + 2 + w3    wv      )  ?   <     Q      ? ;  uB ;  ;  Q  ;  
                  
   TW_05B.PCX           w                   6         w                      
   TW_05B.PCX           w         6   {      U   (      w                     
   TW_05B.PCX           I   {     7            (      I   {                 
   TW_05B.PCX              {     U   (      6   {        {                 	   TW_05.PCX           8   {        {     i   (      8   {                 	   TW_05.PCX           8   {     i   (       V   (      8   {                 	   TW_05.PCX           )                      (      )                     	   TW_05.PCX           )             (      )   (      )                     	   TW_05.PCX           8         V          i          8                     	   TW_05.PCX           8         i                   8          j
       DEFAULT.PAL    MAIN             F   1  Q/ t/ Q/ ';)/ Zc/ w8zP/ 6>/ Ӈ/ ta  ,)  E.)    )  a  z)  a  zl   ta  ,l   :-l     Ȁl   iav  Jv  LCv  j*v  Jo   @KAo   $j)o   iao   O   E  O   E  o   Do     O   O   A:o     o   ͽj4  1ok4  h2p4  B4  ͽj    1ok    h2p    B      f  rx  =3e  rx  hb- rx    I rx  =3e  x   hb- x     I x     f  x         }43    D;V  BC  {#  1  Qo   Qo   ';)o   Zco   w8zPo   6>o   Ӈo   *9      a`  fC/  e  3  | 3  !3  tlt 3  K                  	   NP_04.PCX                                 
                            	   NP_04.PCX           7                            7                     	   NP_04.PCX           =   %               7         =   %                  	   NP_04.PCX           -   :               =   %      -   :                  	   NP_04.PCX              :               -   :         :                  	   NP_04.PCX              &                  :         &                  	   NP_04.PCX              
                  &         
                  	   NP_01.PCX                 	      ?   
      2                           	   NP_01.PCX                 
      2                                    	   NP_01.PCX           ?   +         +         ?      ?   +                  	   NP_01.PCX           ?   +         ?   
   ?   ?      ?   +                  	   NP_01.PCX        	   p   +      8   +   
   8   ?   	   p   +                  	   NP_01.PCX        	   p   +   
   8   ?      o   ?   	   p   +                  	   NP_01.PCX           7   +   
   \   +      \   ?      7   +                  	   NP_01.PCX           7   +      \   ?      7   ?      7   +                  	   NP_01.PCX           ?                           ?                     	   NP_01.PCX           ?                  ?         ?                     	   NP_03.PCX           8          *         *  ?      8                      	   NP_03.PCX           8          *  ?      :   ?      8                      	   NP_03.PCX                     ,          .   ?                            	   NP_03.PCX                     .   ?         ?                            	   NP_03.PCX           v  ?      5   ?      5         v  ?                  	   NP_03.PCX           v  ?      5         s        v  ?                  	   NP_03.PCX           '   ?      h  ?      e        '   ?                  	   NP_03.PCX           '   ?      e        '         '   ?                  	   NP_01.PCX           >   .      ~   -         e     >   .                  	   NP_01.PCX           >   .         e     B   e     >   .                  	   NP_03.PCX                ?   !   @   @   "   @              ?                  	   NP_03.PCX                ?   "   @      #                  ?                  	   NP_01.PCX        !   }   !       (   !   $   (   @   !   }   !                  	   NP_01.PCX        !   }   !   $   (   @   %   }   @   !   }   !                  	   NP_01.PCX        #   '   !   "   }   !   &   }   @   #   '   !                  	   NP_01.PCX        #   '   !   &   }   @   '   '   @   #   '   !                  	   NP_01.PCX        "       !   !   ?   !   %   ?   @   "       !                  	   NP_01.PCX        "       !   %   ?   @   &       @   "       !                  	   NP_01.PCX            @   !   #       !   '       @       @   !                  	   NP_01.PCX            @   !   '       @   $   @   @       @   !                  	   NP_03.PCX        (           )         *      >   (                          	   NP_03.PCX        (   @       *      >   +   ?   <   (   @                      	   NP_01.PCX        *   /       )          ,      ?   *   /                      	   NP_01.PCX        *   /       ,      ?   -   /   ?   *   /                      	   NP_01.PCX        (   Z       +   
       .   
   ?   (   Z                      	   NP_01.PCX        (   Z       .   
   ?   /   Z   ?   (   Z                      	   NP_01.PCX        )          (           /       ?   )                         	   NP_01.PCX        )          /       ?   ,      ?   )                         	   NP_01.PCX        +   =       *          -      ?   +   =                      	   NP_01.PCX        +   =       -      ?   .   =   ?   +   =                      	   NP_02.PCX        0                              0                         	   NP_02.PCX        0                   1         0                         	   NP_02.PCX        2                             2                        	   NP_02.PCX        2                    0          2                        	   NP_02.PCX        3                           3                        	   NP_02.PCX        3                  2         3                        	   NP_02.PCX        4   m         m               4   m                     	   NP_02.PCX        4   m               3         4   m                     	   NP_02.PCX        5   R         R         m      5   R                     	   NP_02.PCX        5   R         m      4   m      5   R                     	   NP_02.PCX        6   7         7         R      6   7                     	   NP_02.PCX        6   7         R      5   R      6   7                     	   NP_02.PCX        1                     7      1                        	   NP_02.PCX        1            7      6   7      1                        	   NP_02.PCX        7       >   0          1         7       >                  	   NP_02.PCX        7       >   1         8      >   7       >                  	   NP_02.PCX        9      >   2         0          9      >                  	   NP_02.PCX        9      >   0          7       >   9      >                  	   NP_02.PCX        :      >   3         2         :      >                  	   NP_02.PCX        :      >   2         9      >   :      >                  	   NP_02.PCX        ;   m   >   4   m      3         ;   m   >                  	   NP_02.PCX        ;   m   >   3         :      >   ;   m   >                  	   NP_02.PCX        <   R   >   5   R      4   m      <   R   >                  	   NP_02.PCX        <   R   >   4   m      ;   m   >   <   R   >                  	   NP_02.PCX        =   7   >   6   7      5   R      =   7   >                  	   NP_02.PCX        =   7   >   5   R      <   R   >   =   7   >                  	   NP_02.PCX        8      >   1         6   7      8      >                  	   NP_02.PCX        8      >   6   7      =   7   >   8      >       j
       DEFAULT.PAL    MAIN                        qu     h  qu     h              ou     h  ou     h        f      Y     h  Y     h  f      f      Y     h  Y     h  f      lH      V;     h  V;     h  lH      jH      S;     h  S;     h  jH      (           h       h  (      (           h       h  (      	      z   h  z   h  	      	      x   h  x   h  	        qu     52qu     52        ou     52ou     52    f    Y     52Y     52f    f    Y     52Y     52f    lH    V;     52V;     52lH    jH    S;     52S;     52jH    (         52     52(    (         52     52(    {    {  {}    2{}    2  {    {  y}    2y}    2  {    {      2    2  {    {      2    2  {    {  }    2}    2  {    {  y    2y    2  W        W                    W    @  W    v    v    @  	    z   52z   52	    	    x   52x   52	    {    {      2    2  {    {      2    2     
   
  $
  {8  
    Z 
  &M g
  
  ve  
  B                  	   SP_02.PCX               ?          K      @   K          ?                  	   SP_02.PCX               ?      @   K       @   ?          ?                  	   SP_02.PCX               ?      @   ?      @   K          ?                  	   SP_02.PCX               ?      @   K          K          ?                  	   SP_02.PCX               ?   
       K   	   @   K          ?                  	   SP_02.PCX               ?   	   @   K      @   ?          ?                  	   SP_02.PCX               ?      @   ?   
   @   K          ?                  	   SP_02.PCX               ?   
   @   K          K          ?                  	   SP_02.PCX               ?          K      @   K          ?                  	   SP_02.PCX               ?      @   K      @   ?          ?                  	   SP_02.PCX               ?      @   ?      @   K          ?                  	   SP_02.PCX               ?      @   K          K          ?                  	   SP_02.PCX               ?          K      @   K          ?                  	   SP_02.PCX               ?      @   K      @   ?          ?                  	   SP_02.PCX               ?      @   ?      @   K          ?                  	   SP_02.PCX               ?      @   K          K          ?                  	   SP_02.PCX        #       ?   "       K   !   @   K   #       ?                  	   SP_02.PCX        #       ?   !   @   K       @   ?   #       ?                  	   SP_02.PCX        '       ?   $   @   ?   %   @   K   '       ?                  	   SP_02.PCX        '       ?   %   @   K   &       K   '       ?                  	   SP_02.PCX        +       ?   *       K   )   @   K   +       ?                  	   SP_02.PCX        +       ?   )   @   K   (   @   ?   +       ?                  	   SP_02.PCX        /       ?   ,   @   ?   -   @   K   /       ?                  	   SP_02.PCX        /       ?   -   @   K   .       K   /       ?                  	   SP_02.PCX        3       ?   2       K   1   @   K   3       ?                  	   SP_02.PCX        3       ?   1   @   K   0   @   ?   3       ?                  	   SP_02.PCX        7       ?   4   @   ?   5   @   K   7       ?                  	   SP_02.PCX        7       ?   5   @   K   6       K   7       ?                  	   SP_02.PCX        ;       ?   :       K   9   @   K   ;       ?                  	   SP_02.PCX        ;       ?   9   @   K   8   @   ?   ;       ?                  	   SP_02.PCX        ?       ?   <   @   ?   =   @   K   ?       ?                  	   SP_02.PCX        ?       ?   =   @   K   >       K   ?       ?                  	   SP_02.PCX        C       ?   B       K   A   @   K   C       ?                  	   SP_02.PCX        C       ?   A   @   K   @   @   ?   C       ?                  	   SP_02.PCX        G       ?   D   @   ?   E   @   K   G       ?                  	   SP_02.PCX        G       ?   E   @   K   F       K   G       ?                  	   SP_02.PCX        K       ?   J       K   I      K   K       ?                  	   SP_02.PCX        K       ?   I      K   H      ?   K       ?                  	   SP_02.PCX        O       ?   L      ?   M      K   O       ?                  	   SP_02.PCX        O       ?   M      K   N       K   O       ?                  	   SP_02.PCX        S       ?   R       K   Q      K   S       ?                  	   SP_02.PCX        S       ?   Q      K   P      ?   S       ?                  	   SP_02.PCX        W       ?   T      ?   U      K   W       ?                  	   SP_02.PCX        W       ?   U      K   V       K   W       ?                  	   SP_02.PCX        [       ?   Z       K   Y      K   [       ?                  	   SP_02.PCX        [       ?   Y      K   X      ?   [       ?                  	   SP_02.PCX        _       ?   \      ?   ]      K   _       ?                  	   SP_02.PCX        _       ?   ]      K   ^       K   _       ?                  	   SP_02.PCX        g   ?   +   d      +   e         g   ?   +                  	   SP_02.PCX        g   ?   +   e         f   ?      g   ?   +                  	   SP_01.PCX        d   ?      g        c        d   ?                     	   SP_01.PCX        d   ?      c        `   ?      d   ?                     	   SP_01.PCX        f        e   ?      a   ?   @   f                       	   SP_01.PCX        f        a   ?   @   b     @   f                       	   SP_01.PCX        e      Y   d          `          e      Y                  	   SP_01.PCX        e         `       @   a      @   e                        	   SP_01.PCX        g          f      Y   b         g                         	   SP_01.PCX        g          b         c          g                         	   SP_02.PCX        k       ?   j       K   i   @   K   k       ?                  	   SP_02.PCX        k       ?   i   @   K   h   @   ?   k       ?                  	   SP_02.PCX        o       ?   l   @   ?   m   @   K   o       ?                  	   SP_02.PCX        o       ?   m   @   K   n       K   o       ?                  	   SP_02.PCX        s       ?   r       K   q      K   s       ?                  	   SP_02.PCX        s       ?   q      K   p      ?   s       ?                  	   SP_02.PCX        w       ?   t      ?   u      K   w       ?                  	   SP_02.PCX        w       ?   u      K   v       K   w       ?       j
       DEFAULT.PAL    MAIN             @   A*  Z*  Z-   @*   @Y7  DY7  A*  Z*  Z-   @*   @Y7  DY7  V  24    V    V  '  V  24  '  24      '  24  '  V  ,4    V    V  '  V  ,4  '  ,4      '  ,4  '  o  ;     o  ;  D  o  sD  o  s   o      o    o  l    o  l  	   $*  ;     $*  ;  D  $*  sD  $*  s   $*      $*    $*  l    $*  l  	   A  *  Z  *  Z  -   @  *   @  Y7  D  Y7  A7)  *  Z7)  *  Z7)  -   @7)  *   @7)  Y7  D7)  Y7  8 3  `    (`  MP`  -CX( `  t[    ?     ?  -?  +\  ?  B                  	   PU_03.PCX              1          ?         9         1                  	   PU_03.PCX              1         9         (         1                  	   PU_03.PCX              (         9         [         (                  	   PU_03.PCX              (         [         T         (                  	   PU_03.PCX              7         9          ?         7                  	   PU_03.PCX              7          ?         ;         7                  	   PU_03.PCX              X         [         9         X                  	   PU_03.PCX              X         9         7         X                  	   PU_03.PCX        
      '         (         T   
      '                  	   PU_03.PCX        
      '         T   	      R   
      '                  	   PU_03.PCX              .         1         (         .                  	   PU_03.PCX              .         (   
      '         .                  	   PU_03.PCX              ;         .         7         ;                  	   PU_03.PCX              7         .   
      '         7                  	   PU_03.PCX              7   
      '         X         7                  	   PU_03.PCX              X   
      '   	      R         X                  	   PU_01.PCX           )         )   ?         ?      )                     	   PU_01.PCX           )            ?   
            )                     	   PU_01.PCX           )   ?      )                  )   ?                  	   PU_01.PCX           )   ?                  ?      )   ?                  	   PU_01.PCX              ?               )            ?                  	   PU_01.PCX              ?      )         )   ?         ?                  	   PU_01.PCX                       ?   
   )   ?                           	   PU_01.PCX                 
   )   ?      )                              	   PU_01.PCX           V   ?      V         V         V   ?                  	   PU_01.PCX           V   ?      V         V   ?      V   ?                  	   PU_01.PCX           )   ?      )   ?      )         )   ?                  	   PU_01.PCX           )   ?      )         )         )   ?                  	   PU_01.PCX        *         "      ?   !     ?   *                        	   PU_01.PCX        *         !     ?   )        *                        	   PU_01.PCX        %   T        T  ?      0   ?   %   T                    	   PU_01.PCX        %   T        0   ?   $   0      %   T                    	   PU_01.PCX        '   0         0   ?      T  ?   '   0                     	   PU_01.PCX        '   0         T  ?   &   T     '   0                     	   PU_01.PCX        )        !     ?       0   ?   )                       	   PU_01.PCX        )            0   ?   (   0      )                       	   PU_01.PCX        +   0      #   0   ?   "     ?   +   0                     	   PU_01.PCX        +   0      "     ?   *        +   0                     	   PU_03.PCX        #   &         @         @   >   #   &                     	   PU_03.PCX        #   &         @   >   "   &   %   #   &                     	   PU_03.PCX        "   &   %      @   >         >   "   &   %                  	   PU_03.PCX        "   &   %         >   !      %   "   &   %                  	   PU_03.PCX        !   Z   %      @   >      @      !   Z   %                  	   PU_03.PCX        !   Z   %      @          Z      !   Z   %                  	   PU_03.PCX        $   @      +   &      %   @   >   $   @                     	   PU_03.PCX        %   @   >   +   &      *   &   %   %   @   >                  	   PU_03.PCX        %   @   >   *   &   %   &      >   %   @   >                  	   PU_03.PCX        &      >   *   &   %   )      %   &      >                  	   PU_03.PCX        &   @   >   )   Z   %   '   @      &   @   >                  	   PU_03.PCX        '   @      )   Z   %   (   Z      '   @                     	   PU_03.PCX        1      1   ,      ?   -      9   1      1                  	   PU_03.PCX        1      1   -      9   0      (   1      1                  	   PU_03.PCX        0      (   -      9   .      [   0      (                  	   PU_03.PCX        0      (   .      [   /      T   0      (                  	   PU_03.PCX        3      7   -      9   ,      ?   3      7                  	   PU_03.PCX        3      7   ,      ?   2      ;   3      7                  	   PU_03.PCX        4      X   .      [   -      9   4      X                  	   PU_03.PCX        4      X   -      9   3      7   4      X                  	   PU_03.PCX        6      '   0      (   /      T   6      '                  	   PU_03.PCX        6      '   /      T   5      R   6      '                  	   PU_03.PCX        7      .   1      1   0      (   7      .                  	   PU_03.PCX        7      .   0      (   6      '   7      .                  	   PU_03.PCX        2      ;   7      .   3      7   2      ;                  	   PU_03.PCX        3      7   7      .   6      '   3      7                  	   PU_03.PCX        3      7   6      '   4      X   3      7                  	   PU_03.PCX        4      X   6      '   5      R   4      X       j
       DEFAULT.PAL    MAIN             .   ^H      ^S      T\      'QtU      ^H  d%  ^S  d%  T\    'QtU    ^    ^    T    'Q    ^d%  ^d%  T  'Q  ڮ     ڮ           ڮ  E\3  ڮ      E\3  q  <  /t  q  U  Z  q  U_  7  q  W     q     q  7  q  sZ  q  /t  q    }  ^<  /t  ^U  Z  ^U_  7  ^W     ^   ^7  ^sZ  ^/t  ^  }  k  2@    9.2@  u02@  ; 2@  6                  	   PG_03.PCX           7        -   |     7        7                    	   PG_03.PCX           7        -   |      -   |     7                    	   PG_03.PCX           6   |     >        6   |     6   |                 	   PG_03.PCX           6   |     >        >        6   |                 	   PG_03.PCX           >        7        >        >                    	   PG_03.PCX           >        7        7        >                    	   PG_03.PCX           -   |     7        6   |     -   |                 	   PG_03.PCX           6   |     7        >        6   |                 	   PG_03.PCX           -   |     7        7        -   |                 	   PG_03.PCX           -   |     7        -   |     -   |                 	   PG_03.PCX           >     
   6   |  	   6   |     >                    	   PG_03.PCX           >     	   6   |  
   >        >                    	   PG_03.PCX           7        >     
   >        7                    	   PG_03.PCX           7     
   >        7        7                    	   PG_03.PCX           7        -   |  
   6   |     7                    	   PG_03.PCX           7     
   6   |     >        7                    	   PG_03.PCX           e         ;         6         e                     	   PG_03.PCX           e         6         e         e                     	   PG_03.PCX           e   W     e         e         e   W                 	   PG_03.PCX           e   W     e         e   W     e   W                 	   PG_03.PCX           ;         e         e         ;                     	   PG_03.PCX           ;         e         6         ;                     	   PG_03.PCX           ;   W     ;         e         ;   W                 	   PG_03.PCX           ;   W     e         e   W     ;   W                 	   PG_02.PCX              B         N          >         B                  	   PG_02.PCX               >         N      0   B          >                  	   PG_02.PCX           0                  ;         0                     	   PG_02.PCX           ;                  ?         ;                     	   PG_02.PCX           ?                            ?                     	   PG_02.PCX           ?                   =   7      ?                     	   PG_02.PCX           =   7                   7      =   7                  	   PG_02.PCX        "      N   !      B   )      >   "      N                  	   PG_02.PCX        "      N   )      >   (   0   B   "      N                  	   PG_02.PCX        "         (   0      '   ;      "                        	   PG_02.PCX        "         '   ;      &   ?      "                        	   PG_02.PCX        "         &   ?      #          "                        	   PG_02.PCX        #          &   ?      %   =   7   #                         	   PG_02.PCX        #          %   =   7   $      7   #                         	   PG_01.PCX        !   8         8           C       !   8                     	   PG_01.PCX        !   8          C       )   C      !   8                     	   PG_01.PCX        "   .         .          8       "   .                     	   PG_01.PCX        "   .         8       !   8      "   .                     	   PG_01.PCX        #   #         #          .       #   #                     	   PG_01.PCX        #   #         .       "   .      #   #                     	   PG_01.PCX        $                      #       $                        	   PG_01.PCX        $            #       #   #      $                        	   PG_01.PCX        &   b         b          q       &   b                     	   PG_01.PCX        &   b         q       %   q      &   b                     	   PG_01.PCX        '   W         W          b       '   W                     	   PG_01.PCX        '   W         b       &   b      '   W                     	   PG_01.PCX        (   M         M          W       (   M                     	   PG_01.PCX        (   M         W       '   W      (   M                     	   PG_01.PCX        )   C          C          M       )   C                     	   PG_01.PCX        )   C         M       (   M      )   C          j
       DEFAULT.PAL    MAIN             1   	  "G  	  G  G  "G  	  "W  	  W  W  "W        0\    S  S	  N  R	    E"   "   S	  "   R	  I"   *        &  ''  *"     "     "   '"     0\  #)  0\      0\      0\        #)                      .  0\  )  .  0\    0\  #0\  .      )  .            #    C\  x    kf      n        &  I  &  qA~&  i$  &  0                  	   FT_03.PCX                             C                              	   FT_03.PCX                    C         C                              	   FT_03.PCX           +   4         4         )      +   4                  	   FT_03.PCX           +   4         )      +   )      +   4                  	   FT_03.PCX                                ?                               	   FT_03.PCX                      ?         ?                               	   FT_03.PCX                               ?                               	   FT_03.PCX                     ?         ?                               	   FT_02.PCX        "                    !      +   "                        	   FT_02.PCX        $   <   +              #   <      $   <   +                  	   FT_02.PCX           +   <              $   <   +      +   <                  	   FT_02.PCX              <                 +   <         <                  	   FT_02.PCX        !      +                    <   !      +                  	   FT_02.PCX                            "                                 	   FT_02.PCX           +                             +                     	   FT_02.PCX        #   <                    +      #   <                     	   FT_01.PCX              X         X   
      %         X                  	   FT_01.PCX        
      %         X         %   
      %                  	   FT_01.PCX              )         )         [         )                  	   FT_01.PCX              [         )         [         [                  	   FT_01.PCX        	      Z   
      Z         '   	      Z                  	   FT_01.PCX              '   
      Z         '         '                  	   FT_01.PCX              '         '         Z         '                  	   FT_01.PCX              Z         '         Z         Z                  	   FT_01.PCX        
      %         %   	      X   
      %                  	   FT_01.PCX        	      X         %   
      X   	      X                  	   FT_01.PCX              X         X         %         X                  	   FT_01.PCX              %         X         %         %                  	   FT_01.PCX              &         &         Y         &                  	   FT_01.PCX              Y         &         Y         Y                  	   FT_01.PCX              Y         Y         &         Y                  	   FT_01.PCX              &         Y         &         &                  	   FT_01.PCX        %      X   !      X         %   %      X                  	   FT_01.PCX        %      X         %         %   %      X                  	   FT_01.PCX        '      )   #      )         [   '      )                  	   FT_01.PCX        '      )         [          [   '      )                  	   FT_01.PCX              Z         Z   $      '         Z                  	   FT_01.PCX              Z   $      '   (      '         Z                  	   FT_01.PCX              '         '   "      Z         '                  	   FT_01.PCX              '   "      Z   &      Z         '                  	   FT_03.PCX               "      }   "      }   @          "                  	   FT_03.PCX               "      }   @          @          "                  	   FT_03.PCX                @      }   @      }   "           @                  	   FT_03.PCX                @      }   "          "           @                  	   FT_01.PCX        &      &   "      &   !      Y   &      &                  	   FT_01.PCX        &      &   !      Y   %      Y   &      &                  	   FT_01.PCX        (      Y   $      Y   #      &   (      Y                  	   FT_01.PCX        (      Y   #      &   '      &   (      Y       j
       DEFAULT.PAL    MAIN             B   Y6D      [N      O  N      L  0D      Y.    [.  l   O  .  f   L  .    U        U        <      <      .  '    .  '    .    .    Y˻    [u    O  {    L  ѻ    Y  [l   O  f   L    (      *              '    '            -          5  :*  :    :    *            5-    :-  *  -  :    -  :    -  *    -      -    -    	  +     	  O   O   +     	  +    	  O  O  +    !C  Z  
  Z  
  r
  r!C  
  r4  k   M  u  k     Uk   XYk   H                  	   FT_01.PCX              X         X         %         X                  	   FT_01.PCX              %         X         %         %                  	   FT_01.PCX        
      )         )         [   
      )                  	   FT_01.PCX              [         )         [         [                  	   FT_01.PCX               Z         Z         '          Z                  	   FT_01.PCX              '         Z         '         '                  	   FT_01.PCX              '         '   	      Z         '                  	   FT_01.PCX        	      Z         '   
      Z   	      Z                  	   FT_01.PCX              %         %          X         %                  	   FT_01.PCX               X         %         X          X                  	   FT_01.PCX              X         X         %         X                  	   FT_01.PCX              %         X         %         %                  	   FT_01.PCX        	      &   
      &         Y   	      &                  	   FT_01.PCX              Y   
      &         Y         Y                  	   FT_01.PCX              Y         Y   
      &         Y                  	   FT_01.PCX        
      &         Y         &   
      &                  	   FT_01.PCX              X         X         %         X                  	   FT_01.PCX              X         %         %         X                  	   FT_01.PCX              )         )         [         )                  	   FT_01.PCX              )         [         [         )                  	   FT_01.PCX              Z         Z         '         Z                  	   FT_01.PCX              Z         '         '         Z                  	   FT_01.PCX              '         '         Z         '                  	   FT_01.PCX              '         Z         Z         '                  	   FT_01.PCX              %         %         X         %                  	   FT_01.PCX              %         X         X         %                  	   FT_01.PCX              X         X         %         X                  	   FT_01.PCX              X         %         %         X                  	   FT_01.PCX              &         &         Y         &                  	   FT_01.PCX              &         Y         Y         &                  	   FT_01.PCX              Y         Y         &         Y                  	   FT_01.PCX              Y         &         &         Y                  	   FT_01.PCX        ,      X   $      X   #      %   ,      X                  	   FT_01.PCX        ,      X   #      %   +      %   ,      X                  	   FT_01.PCX        0      )   (      )   '      [   0      )                  	   FT_01.PCX        0      )   '      [   /      [   0      )                  	   FT_01.PCX        *      Z   "      Z   )      '   *      Z                  	   FT_01.PCX        *      Z   )      '   1      '   *      Z                  	   FT_01.PCX        .      '   &      '   %      Z   .      '                  	   FT_01.PCX        .      '   %      Z   -      Z   .      '                  	   FT_03.PCX        +       "   #   }   "   "   }   @   +       "                  	   FT_03.PCX        +       "   "   }   @   *       @   +       "                  	   FT_03.PCX        /       @   '   }   @   &   }   "   /       @                  	   FT_03.PCX        /       @   &   }   "   .       "   /       @                  	   FT_01.PCX        %   h   &   !   h   @   $   h   Y   %   h   &                  	   FT_01.PCX        )   h   Y   !   h   @   (   h   &   )   h   Y                  	   FT_01.PCX        ,      Y          @   -      &   ,      Y                  	   FT_01.PCX        0      &          @   1      Y   0      &                  	   FT_01.PCX        -      &   %      &   $      Y   -      &                  	   FT_01.PCX        -      &   $      Y   ,      Y   -      &                  	   FT_01.PCX        1      Y   )      Y   (      &   1      Y                  	   FT_01.PCX        1      Y   (      &   0      &   1      Y                  	   FT_01.PCX        "   =   X   !       >   )      {   "   =   X                  	   FT_01.PCX        #   =   %   !       >   "   =   X   #   =   %                  	   FT_01.PCX        $         !       >   #   =   %   $                        	   FT_01.PCX        &      %   !   @   >   %   &      &      %                  	   FT_01.PCX        '      X   !   @   >   &      %   '      X                  	   FT_01.PCX        (   &   {   !   @   >   '      X   (   &   {                  	   FT_01.PCX        1      {           >   *   =   X   1      {                  	   FT_01.PCX        *   =   X           >   +   =   %   *   =   X                  	   FT_01.PCX        +   =   %           >   ,         +   =   %                  	   FT_01.PCX        -   &          @   >   .      %   -   &                     	   FT_01.PCX        .      %       @   >   /      X   .      %                  	   FT_01.PCX        /      X       @   >   0   &   {   /      X                  	   FT_02.PCX        6   .   '   9   .   '   5   .   -   6   .   '                  	   FT_02.PCX        6   .   '   5   .   -   2   .   -   6   .   '                  	   FT_02.PCX        7      '   6   .   '   2   .   -   7      '                  	   FT_02.PCX        7      '   2   .   -   3      -   7      '                  	   FT_02.PCX        8   P   '   7   P   '   3   P   -   8   P   '                  	   FT_02.PCX        8   P   '   3   P   -   4   P   -   8   P   '                  	   FT_02.PCX        9   .   '   8      '   4      -   9   .   '                  	   FT_02.PCX        9   .   '   4      -   5   .   -   9   .   '       j
       DEFAULT.PAL    MAIN             E   "X  i  T  "X  i    "X  BJ  T  "X  BJ    	i  T  	i    	BJ  T  	BJ    "X  T  "X    "X  T  "X    	T  	  	T  	  "X  []T  "X  []  "X  4T  "X  4  	[]T  	[]  	4T  	4  |e    \  g    \  &R  %R  J  [  d    [  We  H[  U	H[      No      p  >  Q=  &      u  z      u  R8    7    "X  #r  T  "X  #r    "X    T  "X      	#r  T  	#r    	  T  	    `
  (d  I  c  \  K  c  \  BRc  ZARc  Rr  Vt      &     blD        Z     V  .	    TZt     2 vb   Nr 2	  
  Z    N  ,    ֵ  z  \    L                  	   AD_02.PCX           (                           (                    	   AD_02.PCX           (                  (        (                    	   AD_02.PCX           7   ?      7                  7   ?                  	   AD_02.PCX           7   ?                   ?      7   ?                  	   AD_02.PCX           +                   ?      +                     	   AD_02.PCX           +           ?       +   ?      +                     	   AD_02.PCX           +         +   ?        ?      +                     	   AD_02.PCX           +           ?              +                     	   AD_01.PCX           7         7   ?         ?      7                     	   AD_01.PCX           7            ?               7                     	   AD_02.PCX           (     
                     (                    	   AD_02.PCX           (                 (        (                    	   AD_02.PCX        
   7   ?      7      	         
   7   ?                  	   AD_02.PCX        
   7   ?   	               ?   
   7   ?                  	   AD_02.PCX        	   +      
             ?   	   +                     	   AD_02.PCX        	   +           ?      +   ?   	   +                     	   AD_02.PCX           +      
   +   ?        ?      +                     	   AD_02.PCX           +           ?              +                     	   AD_01.PCX           7         7   ?         ?      7                     	   AD_01.PCX           7            ?   
            7                     	   AD_02.PCX           (                          (                    	   AD_02.PCX           (                 (        (                    	   AD_02.PCX           7   ?      7                  7   ?                  	   AD_02.PCX           7   ?                  ?      7   ?                  	   AD_02.PCX           +                   ?      +                     	   AD_02.PCX           +           ?      +   ?      +                     	   AD_02.PCX           +         +   ?        ?      +                     	   AD_02.PCX           +           ?              +                     	   AD_01.PCX           7         7   ?         ?      7                     	   AD_01.PCX           7            ?               7                     	   AD_02.PCX                 1      !   4     !                           	   AD_02.PCX                 4     !                                   	   AD_02.PCX                3     !   2      !                          	   AD_02.PCX                2      !                                   	   AD_02.PCX                                                          	   AD_02.PCX                                                         	   AD_02.PCX                                                        	   AD_02.PCX                                                         	   AD_02.PCX            ;          G                  ;                      	   AD_02.PCX            ;               #             ;                      	   AD_02.PCX        "                          "                        	   AD_02.PCX        "            G      !   :       "                        	   AD_02.PCX        $   4   #       ;       #         $   4   #                  	   AD_02.PCX        $   4   #   #         '     #   $   4   #                  	   AD_02.PCX        &     #   "         !   :       &     #                  	   AD_02.PCX        &     #   !   :       %   3   #   &     #                  	   AD_02.PCX           2      2   2   !   1      !      2                     	   AD_02.PCX           2      1      !               2                     	   AD_02.PCX                 4      !   3   2   !                           	   AD_02.PCX                 3   2   !      2                              	   AD_02.PCX           )         2                  )                     	   AD_02.PCX           )                          )                     	   AD_02.PCX                            2                             	   AD_02.PCX                   2         (                             	   AD_02.PCX        !             )              !                         	   AD_02.PCX        !                      $      !                         	   AD_02.PCX        #   #                 (      #   #                     	   AD_02.PCX        #   #         (      "          #   #                     	   AD_02.PCX        %      #   !              $      %      #                  	   AD_02.PCX        %      #       $      $   +  #   %      #                  	   AD_02.PCX        '   *  #   #   #      "          '   *  #                  	   AD_02.PCX        '   *  #   "          &      #   '   *  #                  	   AD_02.PCX        .   (     *         (         .   (                    	   AD_02.PCX        .   (     (         ,   (     .   (                    	   AD_02.PCX        *   7   ?   +   7      )         *   7   ?                  	   AD_02.PCX        *   7   ?   )         (      ?   *   7   ?                  	   AD_02.PCX        )   +      -        ,     ?   )   +                     	   AD_02.PCX        )   +      ,     ?   (   +   ?   )   +                     	   AD_02.PCX        +   +      *   +   ?   .     ?   +   +                     	   AD_02.PCX        +   +      .     ?   /        +   +                     	   AD_01.PCX        /   7      .   7   ?   ,      ?   /   7                     	   AD_01.PCX        /   7      ,      ?   -         /   7                     	   AD_03.PCX        1   ?   @   0      %   4   C  @   1   ?   @                  	   AD_03.PCX        2   ?   ?   0      e   1   ?      2   ?   ?                  	   AD_03.PCX        3   C  ?   0      e   2   ?   ?   3   C  ?                  	   AD_03.PCX        4        0      e   3     ?   4            j
       DEFAULT.PAL    MAIN             l   <?  ?  ?  ?  *5  ?  <*5  ?  {<  Q  {<  Q  8  Q  8  Q  ?X  a  f@  _S  ?X  a  ?  U  ?  T  <X  a  =  h  	=   i  CN  ~E  CN  |E  ;  `  pD  O  ;  `  pD  O  U<  !R  72?  S  yO  M  rF  v_  yO  M  tF  v_  ?  K    A5  K    A5  ԰    ?  ԰    ?  K  A5  K  A5  ԰  ?  ԰  u&  {    u&  :    9  :    9  {    u&  {  u&  :  9  :  9  {  5  qk      
5  a      "  a      "  k      5  qk    
5  a    "  a    "  k    >  PU      95  ZU      M5  g      ?  g      >  PU    95  ZU    M5  g    ?  g        U    dA    W      U  dA  W  !                !        
a      a      O      
O      
a    a    O    
O    5  a     5  X   X   a     5  a  ?  5  X?  X?  a  ?  gk      a      a      gk      gk    a    a    gk      2 \  =) 7\  8/\    \  ;,  \ ,    ,  fW,  R  ,  f                  	   AB_01.PCX                       -        -                          	   AB_01.PCX                       -                                    	   AB_01.PCX                                                            	   AB_01.PCX                                                            	   AB_01.PCX              -                          -                 	   AB_01.PCX              -                 -        -                 	   AB_01.PCX              -        -        -        -                 	   AB_01.PCX              -        -        -        -                 	   AB_01.PCX              -                          -                 	   AB_01.PCX              -                 -        -                 	   AB_04.PCX                  
          	                                   	   AB_04.PCX        
                              
                         	   AB_04.PCX               #   	   ?   @        @         #                  	   AB_04.PCX        
          
                    
                         	   AB_04.PCX        
      #      ?   @  	      @  
      #                  	   AB_04.PCX        
      #      >   @         @  
      #                  	   AB_04.PCX                    `   A      ?                              	   AB_04.PCX           =         `   F                =                     	   AB_04.PCX                    `   A      ?                              	   AB_04.PCX           =         `   F                =                     	   AB_04.PCX                    `   A      ?                              	   AB_04.PCX           =         `   F                =                     	   AB_04.PCX                    `   A      ?                              	   AB_04.PCX           =         `   F                =                     	   AB_04.PCX                    `   A      ?                              	   AB_04.PCX           =         `   F                =                     	   AB_04.PCX                    `   A      ?                              	   AB_04.PCX           =         `   F                =                     	   AB_01.PCX                  #      -        -                           	   AB_01.PCX                        -                                    	   AB_01.PCX        !                            !                        	   AB_01.PCX        !                           !                        	   AB_01.PCX        #      -  "      -        -  #      -                 	   AB_01.PCX        #      -        -        -  #      -                 	   AB_01.PCX        #      -            !         #      -                 	   AB_01.PCX        #      -  !         "      -  #      -                 	   AB_01.PCX        (         +      -  '      -  (                        	   AB_01.PCX        (         '      -  $         (                        	   AB_01.PCX        )         (         $         )                        	   AB_01.PCX        )         $         %         )                        	   AB_01.PCX        +      -  *      -  &      -  +      -                 	   AB_01.PCX        +      -  &      -  '      -  +      -                 	   AB_01.PCX        +      -  (         )         +      -                 	   AB_01.PCX        +      -  )         *      -  +      -                 	   AB_01.PCX        0         3      -  /      -  0                        	   AB_01.PCX        0         /      -  ,         0                        	   AB_01.PCX        1         0         ,         1                        	   AB_01.PCX        1         ,         -         1                        	   AB_01.PCX        3      -  2      -  .      -  3      -                 	   AB_01.PCX        3      -  .      -  /      -  3      -                 	   AB_01.PCX        3      -  0         1         3      -                 	   AB_01.PCX        3      -  1         2      -  3      -                 	   AB_01.PCX        8         ;      -  7      -  8                        	   AB_01.PCX        8         7      -  4         8                        	   AB_01.PCX        9         8         4         9                        	   AB_01.PCX        9         4         5         9                        	   AB_01.PCX        ;      -  :      -  6      -  ;      -                 	   AB_01.PCX        ;      -  6      -  7      -  ;      -                 	   AB_01.PCX        ;      -  8         9         ;      -                 	   AB_01.PCX        ;      -  9         :      -  ;      -                 	   AB_01.PCX        @         C      -  ?      -  @                        	   AB_01.PCX        @         ?      -  <         @                        	   AB_01.PCX        A         @         <         A                        	   AB_01.PCX        A         <         =         A                        	   AB_01.PCX        C      -  B      -  >      -  C      -                 	   AB_01.PCX        C      -  >      -  ?      -  C      -                 	   AB_01.PCX        C      -  @         A         C      -                 	   AB_01.PCX        C      -  A         B      -  C      -                 	   AB_01.PCX        H         K      -  G      -  H                        	   AB_01.PCX        H         G      -  D         H                        	   AB_01.PCX        I         H         D         I                        	   AB_01.PCX        I         D         E         I                        	   AB_01.PCX        K      -  J      -  F      -  K      -                 	   AB_01.PCX        K      -  F      -  G      -  K      -                 	   AB_01.PCX        K      -  H         I         K      -                 	   AB_01.PCX        K      -  I         J      -  K      -                 	   AB_01.PCX        P         S      -  O      -  P                        	   AB_01.PCX        P         O      -  L         P                        	   AB_01.PCX        Q         P         L         Q                        	   AB_01.PCX        Q         L         M         Q                        	   AB_01.PCX        S      -  R      -  N      -  S      -                 	   AB_01.PCX        S      -  N      -  O      -  S      -                 	   AB_01.PCX        S      -  P         Q         S      -                 	   AB_01.PCX        S      -  Q         R      -  S      -                 	   AB_03.PCX        [          X       ?   Y      ?   [                         	   AB_03.PCX        [          Y      ?   Z         [                         	   AB_02.PCX        X      ?   [   s   ?   W   s      X      ?                  	   AB_02.PCX        X      ?   W   s      T         X      ?                  	   AB_02.PCX        Z   s   ?   Y      ?   U         Z   s   ?                  	   AB_02.PCX        Z   s   ?   U         V   s      Z   s   ?                  	   AB_02.PCX        Y      ?   X   "   ?   T   "      Y      ?                  	   AB_02.PCX        Y      ?   T   "      U         Y      ?                  	   AB_02.PCX        [   "   ?   Z      ?   V         [   "   ?                  	   AB_02.PCX        [   "   ?   V         W   "      [   "   ?                  	   AB_01.PCX        `         c      -  _      -  `                        	   AB_01.PCX        `         _      -  \         `                        	   AB_01.PCX        a         `         \         a                        	   AB_01.PCX        a         \         ]         a                        	   AB_01.PCX        c      -  b      -  ^      -  c      -                 	   AB_01.PCX        c      -  ^      -  _      -  c      -                 	   AB_01.PCX        c      -  `         a         c      -                 	   AB_01.PCX        c      -  a         b      -  c      -      j
       DEFAULT.PAL    MAIN             &   ބ    5    d        $      $    M      M  d      5    G  +      G  $    K$    K+      G  +  3  G  $3  K$3  K+  3  /  "{      Y+      LZ            Yh      #  h      tQ        tQ  LZ      #  +      s  Xf  W  =f  U1f  X#3  f  Q    s  \  s  kZ5  s  67 s  c  1  Z    yZ  	Z  Ef  Z                    	   LP_04.PCX           H   0                 H         H   0                  	   LP_04.PCX           0   G                 H   0      0   G                  	   LP_04.PCX              G                 0   G         G                  	   LP_04.PCX           9   0       `         P   G      9   0                  	   LP_04.PCX           9          `         9   0      9                     	   LP_04.PCX           P   8       `   _      9   O      P   8                  	   LP_04.PCX           0   8           _         8      0   8                  	   LP_04.PCX           H   O           _      0   8      H   O                  	   LP_03.PCX           ?   ?   
      ?         k      ?   ?                  	   LP_03.PCX           ?   ?         k      ?   k      ?   ?                  	   LP_03.PCX              ?   
   4   ?   	   4            ?                  	   LP_03.PCX              ?   	   4      
               ?                  	   LP_03.PCX           4   ?         ?               4   ?                  	   LP_03.PCX           4   ?               4         4   ?                  	   LP_02.PCX        
   0   ?         ?            
   0   ?                  	   LP_02.PCX        
   0   ?            	   0      
   0   ?                  	   LP_02.PCX              ?      0   ?   
   0            ?                  	   LP_02.PCX              ?   
   0                     ?                  	   LP_04.PCX           G   0                G         G   0                  	   LP_04.PCX           0   G                G   0      0   G                  	   LP_04.PCX              G                0   G         G                  	   LP_04.PCX           8   0      _          O   G      8   0                  	   LP_04.PCX           8         _          8   0      8                     	   LP_04.PCX           O   8      _   `      8   P      O   8                  	   LP_04.PCX           0   8         `         8      0   8                  	   LP_04.PCX           G   P         `      0   8      G   P       j
       DEFAULT.PAL    MAIN             @     B    (        d      .  @d        BJ(  (  J(    d  J(  .  @d  J(  6  8  T    E  8  T   E     T   P     T   6  8    E  r8    E       P       8Қ  T   ^X  T   8X  T     T   8Қ    nX    :X        <r            /  X      8/        <r  J(    J(  /  X  J(  8/    J(  K0eT   KFT   cRT   fceT   K0e  KP  cH  fce  8    9"e    
d        8J(  9"eJ(  
dJ(  J(  (j\   (X  \   D  X  \   D  j\   (j&\  (X  &\  D  X  &\  D  j&\  U   $  w '$  O$  l"+ $    x   -< J7  /  I    :                     RC01_02.PCX               ?      @   @      @             ?                     RC01_02.PCX               ?      @                       ?                     RC01_01.PCX           }   !      (   !      (   @      }   !                     RC01_01.PCX           }   !      (   @       }   @      }   !                     RC01_01.PCX           '   !      }   !      }   @      '   !                     RC01_01.PCX           '   !      }   @      '   @      '   !                     RC01_01.PCX               !      ?   !       ?   @          !                     RC01_01.PCX               !       ?   @          @          !                     RC01_01.PCX           @   !          !          @      @   !                     RC01_01.PCX           @   !          @      @   @      @   !                  	   NP_01.PCX                    ?      
                                 	   NP_01.PCX        
            ?         ?      
                        	   NP_03.PCX           *      
   8          *  ?      *                     	   NP_03.PCX           *  ?   
   8       	   :   ?      *  ?                  	   NP_03.PCX           ,                 
   .   ?      ,                      	   NP_03.PCX        
   .   ?                   ?   
   .   ?                  	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8          *  ?      *                     	   NP_03.PCX           *  ?      8          :   ?      *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                     RC01_02.PCX           @   @          ?      @         @   @                     RC01_02.PCX           @             ?                @                        RC01_01.PCX           (   !      }   !      (   @      (   !                     RC01_01.PCX           (   @      }   !      }   @      (   @                     RC01_01.PCX           }   !      '   !      }   @      }   !                     RC01_01.PCX           }   @      '   !      '   @      }   @                     RC01_01.PCX           ?   !          !      ?   @      ?   !                     RC01_01.PCX           ?   @          !          @      ?   @                     RC01_01.PCX               !      @   !          @          !                     RC01_01.PCX               @      @   !      @   @          @                  	   NP_01.PCX        '   ?      $         %         '   ?                     	   NP_01.PCX        '   ?      %         &   ?      '   ?                     	   NP_03.PCX        %   8       $   *          *  ?   %   8                      	   NP_03.PCX        %   8           *  ?   !   :   ?   %   8                      	   NP_03.PCX        '          &   ,       "   .   ?   '                         	   NP_03.PCX        '          "   .   ?   #      ?   '                            RC01_02.PCX        /       ?   ,   @   @   -   @      /       ?                     RC01_02.PCX        /       ?   -   @      .          /       ?                     RC01_01.PCX        ,   }   !   /   (   !   +   (   @   ,   }   !                     RC01_01.PCX        ,   }   !   +   (   @   (   }   @   ,   }   !                     RC01_01.PCX        .   '   !   -   }   !   )   }   @   .   '   !                     RC01_01.PCX        .   '   !   )   }   @   *   '   @   .   '   !                     RC01_01.PCX        -       !   ,   ?   !   (   ?   @   -       !                     RC01_01.PCX        -       !   (   ?   @   )       @   -       !                     RC01_01.PCX        /   @   !   .       !   *       @   /   @   !                     RC01_01.PCX        /   @   !   *       @   +   @   @   /   @   !                     RC01_02.PCX        7           4         5      >   7                             RC01_02.PCX        7   @       5      >   6   ?   <   7   @                         RC01_01.PCX        5   /       4          0      ?   5   /                         RC01_01.PCX        5   /       0      ?   1   /   ?   5   /                         RC01_01.PCX        7   Z       6   
       2   
   ?   7   Z                         RC01_01.PCX        7   Z       2   
   ?   3   Z   ?   7   Z                         RC01_01.PCX        4          7           3       ?   4                            RC01_01.PCX        4          3       ?   0      ?   4                            RC01_01.PCX        6   =       5          1      ?   6   =                         RC01_01.PCX        6   =       1      ?   2   =   ?   6   =           j
       DEFAULT.PAL    MAIN             X   .( lF  ^( 2  F  ' +F  ^( 2     ' +   | IF  L nF  | I   L n   {  F  |  F  {     |       'G    щ    ZG  n    '   G  '    G  _ X   G  ^   e $<G  E zN   G  }_   6' G  N'   f  <G  ^  <G  .      N  u' %lš    F  Z F   F  Z        !>  F  c0  F  !>     c0     +0  F  +  F  +0     +     *D  G  J|ű    r|O G  |    Z. G  A    *2 G  aM    1j  G  2z    
jd  G  1ov    1  G  !F    G  4    
|1  G  Dd  G  ҞF    2|v      š  {      {      c0      V}p      {  P$  {  P$  c0  P$  V}p  P$     &I  X  U&I  à&I  b" &I  O 3  &I   ,&I  u&I  Q  &I  ;X  m  # _m  ŧw;m  /c m  h                     4XNB_02.PCX        	   b                            	   b                        4XNB_02.PCX        
             `       	         
                           4XNB_02.PCX                            
   \                                 4XNB_02.PCX           ]   +                         ]   +                     4XNB_02.PCX              ,       `            +         ,                     4XNB_02.PCX                               c   ,                              RC02_02.PCX              z   	      6         6         z                     RC02_02.PCX              z         6         z         z                     RC02_02.PCX              z         6      5   6         z                     RC02_02.PCX              z      5   6      5   z         z                     RC02_02.PCX           2   z      2   6   
      6      2   z                     RC02_02.PCX           2   z   
      6         z      2   z                     RC02_02.PCX              z         6         6         z                     RC02_02.PCX              z         6         z         z                     RC02_02.PCX              z         6          6         z                     RC02_02.PCX              z          6          z         z                     RC02_02.PCX               z   
       6   	      6          z                     RC02_02.PCX               z   	      6         z          z                     4XNB_01.PCX                      5          D   D                               4XNB_01.PCX           H             D   
   9   C      H                         4XNB_01.PCX        !             5   @         @   !                           4XNB_01.PCX                     6       
   D   C                               4XNB_01.PCX           H       
      C      :   D      H                         4XNB_01.PCX        !            6   @         @   !                           4XNB_01.PCX                     6          D   C                               4XNB_01.PCX           H             C      :   D      H                         4XNB_01.PCX        !            6   @         @   !                           4XNB_01.PCX                     6          D   C                               4XNB_01.PCX           H             C      :   D      H                         4XNB_01.PCX        !            6   @         @   !                           4XNB_01.PCX                     5          D   D                               4XNB_01.PCX           H             D      9   C      H                         4XNB_01.PCX        !            5   @         @   !                           4XNB_01.PCX                     5         C   D                               4XNB_01.PCX           G             D      9   C      G                         4XNB_01.PCX        !            5   A         @   !                           4XNB_01.PCX                     5          D   D                               4XNB_01.PCX           H             D      9   C      H                         4XNB_01.PCX        !            5   @         @   !                           4XNB_01.PCX                     6          D   C                               4XNB_01.PCX           H             C      :   D      H                         4XNB_01.PCX        !            6   @         @   !                           4XNB_01.PCX                     5          D   D                               4XNB_01.PCX           H             D      9   C      H                         4XNB_01.PCX        !            5   @         @   !                           4XNB_01.PCX            	          7          E   C       	                         4XNB_01.PCX            I             C      ;   C       I                         4XNB_01.PCX        !             7   @       	   @   !                            4XNB_02.PCX        +   b      "           $          +   b                        4XNB_02.PCX        ,         "   `       +         ,                           4XNB_02.PCX        #         "          ,   \      #                           4XNB_02.PCX        '   ]   +   "         #         '   ]   +                     4XNB_02.PCX        (      ,   "   `      '      +   (      ,                     4XNB_02.PCX        $         "          (   c   ,   $                           RC02_02.PCX        -      z   +      6   $      6   -      z                     RC02_02.PCX        -      z   $      6   &      z   -      z                     RC02_02.PCX        )      z   '      6   #   5   6   )      z                     RC02_02.PCX        )      z   #   5   6   %   5   z   )      z                     RC02_02.PCX        %   2   z   #   2   6   ,      6   %   2   z                     RC02_02.PCX        %   2   z   ,      6   .      z   %   2   z                     RC02_02.PCX        &      z   $      6   (      6   &      z                     RC02_02.PCX        &      z   (      6   *      z   &      z                     RC02_02.PCX        *      z   (      6   '       6   *      z                     RC02_02.PCX        *      z   '       6   )       z   *      z                     RC02_02.PCX        .       z   ,       6   +      6   .       z                     RC02_02.PCX        .       z   +      6   -      z   .       z                     4XNB_01.PCX        0          B   5       @   D   D   0                            4XNB_01.PCX        0   H       @      D   /   9   C   0   H                         4XNB_01.PCX        C         B   5   @   0      @   C                           4XNB_01.PCX        2          0   6       /   D   C   2                            4XNB_01.PCX        2   H       /      C   1   :   D   2   H                         4XNB_01.PCX        C         0   6   @   2      @   C                           4XNB_01.PCX        4          2   6       1   D   C   4                            4XNB_01.PCX        4   H       1      C   3   :   D   4   H                         4XNB_01.PCX        C         2   6   @   4      @   C                           4XNB_01.PCX        6          4   6       3   D   C   6                            4XNB_01.PCX        6   H       3      C   5   :   D   6   H                         4XNB_01.PCX        C         4   6   @   6      @   C                           4XNB_01.PCX        8          6   5       5   D   D   8                            4XNB_01.PCX        8   H       5      D   7   9   C   8   H                         4XNB_01.PCX        C         6   5   @   8      @   C                           4XNB_01.PCX        :          8   5      7   C   D   :                            4XNB_01.PCX        :   G       7      D   9   9   C   :   G                         4XNB_01.PCX        C         8   5   A   :      @   C                           4XNB_01.PCX        <          :   5       9   D   D   <                            4XNB_01.PCX        <   H       9      D   ;   9   C   <   H                         4XNB_01.PCX        C         :   5   @   <      @   C                           4XNB_01.PCX        >          <   6       ;   D   C   >                            4XNB_01.PCX        >   H       ;      C   =   :   D   >   H                         4XNB_01.PCX        C         <   6   @   >      @   C                           4XNB_01.PCX        A          >   5       =   D   D   A                            4XNB_01.PCX        A   H       =      D   ?   9   C   A   H                         4XNB_01.PCX        C         >   5   @   A      @   C                           4XNB_01.PCX        B   	       A   7       ?   E   C   B   	                         4XNB_01.PCX        B   I       ?      C   @   ;   C   B   I                         4XNB_01.PCX        C          A   7   @   B   	   @   C                            4XNB_02.PCX        K     ?   H      ?   I          K     ?                     4XNB_02.PCX        K     ?   I          J   z      K     ?                     4XNB_02.PCX        I   ?       H           D       ?   I   ?                         4XNB_02.PCX        I   ?       D       ?   E   ?   ?   I   ?                         4XNB_02.PCX        H          K         G     ?   H                            4XNB_02.PCX        H          G     ?   D      ?   H                            4XNB_02.PCX        J   z      I          E      ?   J   z                        4XNB_02.PCX        J   z      E      ?   F   z  ?   J   z          j
       DEFAULT.PAL    MAIN             y   5        c  p      6m    a    5    x6  c  p  x6  6mx6  ax6  = X  Dw Ds'   = '   4 *'     J'   Dw DsX  = X  4 *X    JX  avj  avj  xa!vj  a   xa!   
  Lvj  
  ,vj  
  L   
  ,   Zvj  ZLvj  Z   ZL    j     Hfj  (D6  0awj  alH   ej  76  kj  ػC  j  8  kj    `NNj  `Z  kj  [j  (    `  "     k Z    
  ,    ,  F    " x6  k Zx6  
  ,x6  ,  Fx6  s '   HV* '   
 '   p8 '   s X  HV* X  
 X  p8 X     vj  (     m     z     *:     ( x6  m x6  z x6  *: x6     vj    'P  vj          'P      J Ez vj  I j  vj   J Ez    I j     c  vj  z vj  c     z    	
  #G j  )B  4   QB  V j  d  d   9   j     v   	  
 j  @  Td   0 F j    4   /    j    v        j           |  j  ќ      A  8  j  	    j  d      B        !   L v  _  f* _  F=_  6 _    k  | Hk  U>  k   k  ? r F   %F  LBHF  o F                       4XNB_02.PCX             ?         ?                  ?                     4XNB_02.PCX             ?                z           ?                     4XNB_02.PCX           ?                          ?      ?                         4XNB_02.PCX           ?               ?      ?   ?      ?                         4XNB_02.PCX                                ?                               4XNB_02.PCX                       ?          ?                               4XNB_02.PCX           z                      ?      z                        4XNB_02.PCX           z            ?      z  ?      z                        4XNB_01.PCX        
   @         ?   ?            
   @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?   
      ?      	         	   ?                     4XNB_02.PCX           	      
      ?   	            	                        4XNB_02.PCX              ?         ?   
               ?                     4XNB_02.PCX        
               ?            
                           4XNB_02.PCX        
      ?         ?   	         
      ?                     4XNB_02.PCX        	               ?   
         	                           4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX           b                              b                        4XNB_02.PCX                    `                                           4XNB_02.PCX                              \                                 4XNB_02.PCX           ]   +                        ]   +                     4XNB_02.PCX              ,      `            +         ,                     4XNB_02.PCX                              c   ,                              RC02_02.PCX              z         6         6         z                     RC02_02.PCX              z         6         z         z                     RC02_02.PCX              z         6      5   6         z                     RC02_02.PCX              z      5   6      5   z         z                     RC02_02.PCX           2   z      2   6         6      2   z                     RC02_02.PCX           2   z         6         z      2   z                     RC02_02.PCX              z         6         6         z                     RC02_02.PCX              z         6         z         z                     RC02_02.PCX              z         6          6         z                     RC02_02.PCX              z          6          z         z                     RC02_02.PCX               z          6         6          z                     RC02_02.PCX               z         6         z          z                     4XNB_01.PCX                  1   5       /   D   D                               4XNB_01.PCX           H       /      D      9   C      H                         4XNB_01.PCX        2         1   5   @         @   2                           4XNB_01.PCX        !             6          D   C   !                            4XNB_01.PCX        !   H             C       :   D   !   H                         4XNB_01.PCX        2            6   @   !      @   2                           4XNB_01.PCX        #          !   6           D   C   #                            4XNB_01.PCX        #   H              C   "   :   D   #   H                         4XNB_01.PCX        2         !   6   @   #      @   2                           4XNB_01.PCX        %          #   6       "   D   C   %                            4XNB_01.PCX        %   H       "      C   $   :   D   %   H                         4XNB_01.PCX        2         #   6   @   %      @   2                           4XNB_01.PCX        '          %   5       $   D   D   '                            4XNB_01.PCX        '   H       $      D   &   9   C   '   H                         4XNB_01.PCX        2         %   5   @   '      @   2                           4XNB_01.PCX        )          '   5      &   C   D   )                            4XNB_01.PCX        )   G       &      D   (   9   C   )   G                         4XNB_01.PCX        2         '   5   A   )      @   2                           4XNB_01.PCX        +          )   5       (   D   D   +                            4XNB_01.PCX        +   H       (      D   *   9   C   +   H                         4XNB_01.PCX        2         )   5   @   +      @   2                           4XNB_01.PCX        -          +   6       *   D   C   -                            4XNB_01.PCX        -   H       *      C   ,   :   D   -   H                         4XNB_01.PCX        2         +   6   @   -      @   2                           4XNB_01.PCX        0          -   5       ,   D   D   0                            4XNB_01.PCX        0   H       ,      D   .   9   C   0   H                         4XNB_01.PCX        2         -   5   @   0      @   2                           4XNB_01.PCX        1   	       0   7       .   E   C   1   	                         4XNB_01.PCX        1   I       .      C   /   ;   C   1   I                         4XNB_01.PCX        2          0   7   @   1   	   @   2                            4XNB_02.PCX        :     ?   7      ?   8          :     ?                     4XNB_02.PCX        :     ?   8          9   z      :     ?                     4XNB_02.PCX        8   ?       7           3       ?   8   ?                         4XNB_02.PCX        8   ?       3       ?   4   ?   ?   8   ?                         4XNB_02.PCX        7          :         6     ?   7                            4XNB_02.PCX        7          6     ?   3      ?   7                            4XNB_02.PCX        9   z      8          4      ?   9   z                        4XNB_02.PCX        9   z      4      ?   5   z  ?   9   z                        4XNB_01.PCX        ?   @      B   ?   ?   @         ?   @                        4XNB_01.PCX        @         B   ?   ?   A      ?   @                           4XNB_02.PCX        B   	   ?   ?      ?   >   	      B   	   ?                     4XNB_02.PCX        >   	      ?      ?   ;         >   	                        4XNB_02.PCX        @      ?   A      ?   <         @      ?                     4XNB_02.PCX        <         A      ?   =         <                           4XNB_02.PCX        ?      ?   @      ?   ;         ?      ?                     4XNB_02.PCX        ;         @      ?   <         ;                           4XNB_02.PCX        A      ?   B      ?   =         A      ?                     4XNB_02.PCX        =         B      ?   >         =                           4XNB_02.PCX        T   b      C           M          T   b                        4XNB_02.PCX        U         C   `       T         U                           4XNB_02.PCX        L         C          U   \      L                           4XNB_02.PCX        P   ]   +   C         L         P   ]   +                     4XNB_02.PCX        Q      ,   C   `      P      +   Q      ,                     4XNB_02.PCX        M         C          Q   c   ,   M                           4XNB_02.PCX        K     ?   H      ?   I          K     ?                     4XNB_02.PCX        K     ?   I          J   z      K     ?                     4XNB_02.PCX        I   ?       H           D       ?   I   ?                         4XNB_02.PCX        I   ?       D       ?   E   ?   ?   I   ?                         4XNB_02.PCX        H          K         G     ?   H                            4XNB_02.PCX        H          G     ?   D      ?   H                            4XNB_02.PCX        J   z      I          E      ?   J   z                        4XNB_02.PCX        J   z      E      ?   F   z  ?   J   z                        RC02_02.PCX        V      z   T      6   M      6   V      z                     RC02_02.PCX        V      z   M      6   O      z   V      z                     RC02_02.PCX        R      z   P      6   L   5   6   R      z                     RC02_02.PCX        R      z   L   5   6   N   5   z   R      z                     RC02_02.PCX        N   2   z   L   2   6   U      6   N   2   z                     RC02_02.PCX        N   2   z   U      6   W      z   N   2   z                     RC02_02.PCX        O      z   M      6   Q      6   O      z                     RC02_02.PCX        O      z   Q      6   S      z   O      z                     RC02_02.PCX        S      z   Q      6   P       6   S      z                     RC02_02.PCX        S      z   P       6   R       z   S      z                     RC02_02.PCX        W       z   U       6   T      6   W       z                     RC02_02.PCX        W       z   T      6   V      z   W       z                     4XNB_01.PCX        Y          k   5       i   D   D   Y                            4XNB_01.PCX        Y   H       i      D   X   9   C   Y   H                         4XNB_01.PCX        l         k   5   @   Y      @   l                           4XNB_01.PCX        [          Y   6       X   D   C   [                            4XNB_01.PCX        [   H       X      C   Z   :   D   [   H                         4XNB_01.PCX        l         Y   6   @   [      @   l                           4XNB_01.PCX        ]          [   6       Z   D   C   ]                            4XNB_01.PCX        ]   H       Z      C   \   :   D   ]   H                         4XNB_01.PCX        l         [   6   @   ]      @   l                           4XNB_01.PCX        _          ]   6       \   D   C   _                            4XNB_01.PCX        _   H       \      C   ^   :   D   _   H                         4XNB_01.PCX        l         ]   6   @   _      @   l                           4XNB_01.PCX        a          _   5       ^   D   D   a                            4XNB_01.PCX        a   H       ^      D   `   9   C   a   H                         4XNB_01.PCX        l         _   5   @   a      @   l                           4XNB_01.PCX        c          a   5      `   C   D   c                            4XNB_01.PCX        c   G       `      D   b   9   C   c   G                         4XNB_01.PCX        l         a   5   A   c      @   l                           4XNB_01.PCX        e          c   5       b   D   D   e                            4XNB_01.PCX        e   H       b      D   d   9   C   e   H                         4XNB_01.PCX        l         c   5   @   e      @   l                           4XNB_01.PCX        g          e   6       d   D   C   g                            4XNB_01.PCX        g   H       d      C   f   :   D   g   H                         4XNB_01.PCX        l         e   6   @   g      @   l                           4XNB_01.PCX        j          g   5       f   D   D   j                            4XNB_01.PCX        j   H       f      D   h   9   C   j   H                         4XNB_01.PCX        l         g   5   @   j      @   l                           4XNB_01.PCX        k   	       j   7       h   E   C   k   	                         4XNB_01.PCX        k   I       h      C   i   ;   C   k   I                         4XNB_01.PCX        l          j   7   @   k   	   @   l              j
       DEFAULT.PAL    MAIN             H   RɄ  i    -2  i   R!2  i     i   RɄ  -  !2  -  M+2  -    -  Y@  Ʉ  i   '@  -2  i   Y"  !2  i   "    i   Y@  Ʉ  -  @  !2  -  V"  +2  -  "    -  >V    s   >V  tb s   wb s     s   >V    0s  >V  tb 0s  wb 0s    0s      i     2  i   ¡  2  i   f  ӄ  i       -    
2  -  š  2  -  f  ӄ  -  V  :      
W  Ƅ        Z      Z        V  :  ]2  
W  Ƅ  ]2    Z  ]2  Z    ]2    i     CTi   <  RTi   X<  i     -    OT-  <  ET-  X<  -    "    j      '               "]2  j  ]2  '   ]2    ]2  ©pTs   ©1  s    1  s    pTs   ©pT0s  ©1  0s   1  0s   pT0s   l   ]{ I  :       <   & :b   <  Y    @                  	   NP_01.PCX           ?                           ?                     	   NP_01.PCX           ?                  ?         ?                     	   NP_03.PCX           8          *          *  ?      8                      	   NP_03.PCX           8           *  ?      :   ?      8                      	   NP_03.PCX                     ,          .   ?                            	   NP_03.PCX                     .   ?         ?                            	   NP_01.PCX           ?               
            ?                     	   NP_01.PCX           ?      
            ?         ?                     	   NP_03.PCX        
   8          *         *  ?   
   8                      	   NP_03.PCX        
   8          *  ?   	   :   ?   
   8                      	   NP_03.PCX                     ,       
   .   ?                            	   NP_03.PCX                  
   .   ?         ?                               RC01_02.PCX                                  >                              RC01_02.PCX              >      @          ?   <         >                     RC01_01.PCX                     /             ?                               RC01_01.PCX              ?      /          /   ?         ?                     RC01_01.PCX           
          Z          
   ?      
                         RC01_01.PCX           
   ?      Z          Z   ?      
   ?                     RC01_01.PCX                                    ?                                RC01_01.PCX               ?                   ?          ?                     RC01_01.PCX                     =             ?                               RC01_01.PCX              ?      =          =   ?         ?                  	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8          *  ?      *                     	   NP_03.PCX           *  ?      8          :   ?      *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                     RC01_02.PCX        $   @   @   '       ?   %   @      $   @   @                     RC01_02.PCX        %   @      '       ?   &          %   @                        RC01_01.PCX        '   (   !   $   }   !   #   (   @   '   (   !                     RC01_01.PCX        #   (   @   $   }   !       }   @   #   (   @                     RC01_01.PCX        %   }   !   &   '   !   !   }   @   %   }   !                     RC01_01.PCX        !   }   @   &   '   !   "   '   @   !   }   @                     RC01_01.PCX        $   ?   !   %       !       ?   @   $   ?   !                     RC01_01.PCX            ?   @   %       !   !       @       ?   @                     RC01_01.PCX        &       !   '   @   !   "       @   &       !                     RC01_01.PCX        "       @   '   @   !   #   @   @   "       @                  	   NP_01.PCX        /   ?      ,         -         /   ?                     	   NP_01.PCX        /   ?      -         .   ?      /   ?                     	   NP_03.PCX        -   8       ,   *      (   *  ?   -   8                      	   NP_03.PCX        -   8       (   *  ?   )   :   ?   -   8                      	   NP_03.PCX        /          .   ,       *   .   ?   /                         	   NP_03.PCX        /          *   .   ?   +      ?   /                            RC01_02.PCX        7       ?   4   @   @   5   @      7       ?                     RC01_02.PCX        7       ?   5   @      6          7       ?                     RC01_01.PCX        4   }   !   7   (   !   3   (   @   4   }   !                     RC01_01.PCX        4   }   !   3   (   @   0   }   @   4   }   !                     RC01_01.PCX        6   '   !   5   }   !   1   }   @   6   '   !                     RC01_01.PCX        6   '   !   1   }   @   2   '   @   6   '   !                     RC01_01.PCX        5       !   4   ?   !   0   ?   @   5       !                     RC01_01.PCX        5       !   0   ?   @   1       @   5       !                     RC01_01.PCX        7   @   !   6       !   2       @   7   @   !                     RC01_01.PCX        7   @   !   2       @   3   @   @   7   @   !                     RC01_02.PCX        ?           <         =      >   ?                             RC01_02.PCX        ?   @       =      >   >   ?   <   ?   @                         RC01_01.PCX        =   /       <          8      ?   =   /                         RC01_01.PCX        =   /       8      ?   9   /   ?   =   /                         RC01_01.PCX        ?   Z       >   
       :   
   ?   ?   Z                         RC01_01.PCX        ?   Z       :   
   ?   ;   Z   ?   ?   Z                         RC01_01.PCX        <          ?           ;       ?   <                            RC01_01.PCX        <          ;       ?   8      ?   <                            RC01_01.PCX        >   =       =          9      ?   >   =                         RC01_01.PCX        >   =       9      ?   :   =   ?   >   =           j
       DEFAULT.PAL    MAIN             `   D    i   D  Gm  i   &  Vm  i   ;'    i   D    -  D  Tm  -  &  Jm  -  ;'    -  \  &    )\        m          \  &]2  )\    ]2  m  ]2  ]2  T  i     i     i   3E  i   T  -    -    -  3E  -  T2 i   2 i    i   3N i   T2 -  2 -   -  3N -  )H s   H s   s   )s   )H 0s  H 0s  0s  )0s  bi   bTi   ci   Xi   b-  ba-  Y-  X-  i   Ti   ci   Qi   -  a-  Y-  Q-  s   
s   @  
s   @  s   0s  
0s  @  
0s  @  0s      i     Gm  i     Vm  i       i       -  *  Tm  -    Jm  -      -  ,  &            W4       3     ,  &]2      ]2  W4   ]2  3 ]2  *tm  s   *J s   ZJ J s   ZJ tm  s   *tm  0s  *J 0s  ZJ J 0s  ZJ tm  0s  'a       AG)2  tܠ        X  *2  phV   V                  	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8           *  ?      *                     	   NP_03.PCX            *  ?      8          :   ?       *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                     RC01_02.PCX           @   @          ?   
   @         @   @                     RC01_02.PCX        
   @             ?             
   @                        RC01_01.PCX           (   !      }   !      (   @      (   !                     RC01_01.PCX           (   @      }   !      }   @      (   @                     RC01_01.PCX        
   }   !      '   !   	   }   @   
   }   !                     RC01_01.PCX        	   }   @      '   !   
   '   @   	   }   @                     RC01_01.PCX           ?   !   
       !      ?   @      ?   !                     RC01_01.PCX           ?   @   
       !   	       @      ?   @                     RC01_01.PCX               !      @   !   
       @          !                     RC01_01.PCX        
       @      @   !      @   @   
       @                  	   NP_01.PCX           ?                           ?                     	   NP_01.PCX           ?                  ?         ?                     	   NP_03.PCX           8          *         *  ?      8                      	   NP_03.PCX           8          *  ?      :   ?      8                      	   NP_03.PCX                     ,          .   ?                            	   NP_03.PCX                     .   ?         ?                            	   NP_01.PCX           ?                           ?                     	   NP_01.PCX           ?                  ?         ?                     	   NP_03.PCX           8          *         *  ?      8                      	   NP_03.PCX           8          *  ?      :   ?      8                      	   NP_03.PCX                     ,          .   ?                            	   NP_03.PCX                     .   ?         ?                               RC01_02.PCX        $         '           %      >   $                           RC01_02.PCX        %      >   '   @       &   ?   <   %      >                     RC01_01.PCX        $          %   /              ?   $                            RC01_01.PCX               ?   %   /       !   /   ?          ?                     RC01_01.PCX        &   
       '   Z       "   
   ?   &   
                         RC01_01.PCX        "   
   ?   '   Z       #   Z   ?   "   
   ?                     RC01_01.PCX        '           $          #       ?   '                             RC01_01.PCX        #       ?   $                 ?   #       ?                     RC01_01.PCX        %          &   =       !      ?   %                            RC01_01.PCX        !      ?   &   =       "   =   ?   !      ?                  	   NP_01.PCX        /   ?      ,         -         /   ?                     	   NP_01.PCX        /   ?      -         .   ?      /   ?                     	   NP_03.PCX        -   8       ,   *      (   *  ?   -   8                      	   NP_03.PCX        -   8       (   *  ?   )   :   ?   -   8                      	   NP_03.PCX        /          .   ,       *   .   ?   /                         	   NP_03.PCX        /          *   .   ?   +      ?   /                         	   NP_01.PCX        7   ?      4         5         7   ?                     	   NP_01.PCX        7   ?      5         6   ?      7   ?                     	   NP_03.PCX        5   8       4   *      0   *  ?   5   8                      	   NP_03.PCX        5   8       0   *  ?   1   :   ?   5   8                      	   NP_03.PCX        7          6   ,       2   .   ?   7                         	   NP_03.PCX        7          2   .   ?   3      ?   7                            RC01_02.PCX        <         ?           =      >   <                           RC01_02.PCX        =      >   ?   @       >   ?   <   =      >                     RC01_01.PCX        <          =   /       8      ?   <                            RC01_01.PCX        8      ?   =   /       9   /   ?   8      ?                     RC01_01.PCX        >   
       ?   Z       :   
   ?   >   
                         RC01_01.PCX        :   
   ?   ?   Z       ;   Z   ?   :   
   ?                     RC01_01.PCX        ?           <          ;       ?   ?                             RC01_01.PCX        ;       ?   <          8      ?   ;       ?                     RC01_01.PCX        =          >   =       9      ?   =                            RC01_01.PCX        9      ?   >   =       :   =   ?   9      ?                  	   NP_01.PCX        G   ?      D         E         G   ?                     	   NP_01.PCX        G   ?      E         F   ?      G   ?                     	   NP_03.PCX        E   8       D   *      @   *  ?   E   8                      	   NP_03.PCX        E   8       @   *  ?   A   :   ?   E   8                      	   NP_03.PCX        G          F   ,       B   .   ?   G                         	   NP_03.PCX        G          B   .   ?   C      ?   G                            RC01_02.PCX        O       ?   L   @   @   M   @      O       ?                     RC01_02.PCX        O       ?   M   @      N          O       ?                     RC01_01.PCX        L   }   !   O   (   !   K   (   @   L   }   !                     RC01_01.PCX        L   }   !   K   (   @   H   }   @   L   }   !                     RC01_01.PCX        N   '   !   M   }   !   I   }   @   N   '   !                     RC01_01.PCX        N   '   !   I   }   @   J   '   @   N   '   !                     RC01_01.PCX        M       !   L   ?   !   H   ?   @   M       !                     RC01_01.PCX        M       !   H   ?   @   I       @   M       !                     RC01_01.PCX        O   @   !   N       !   J       @   O   @   !                     RC01_01.PCX        O   @   !   J       @   K   @   @   O   @   !                     RC01_02.PCX        W           T         U      >   W                             RC01_02.PCX        W   @       U      >   V   ?   <   W   @                         RC01_01.PCX        U   /       T          P      ?   U   /                         RC01_01.PCX        U   /       P      ?   Q   /   ?   U   /                         RC01_01.PCX        W   Z       V   
       R   
   ?   W   Z                         RC01_01.PCX        W   Z       R   
   ?   S   Z   ?   W   Z                         RC01_01.PCX        T          W           S       ?   T                            RC01_01.PCX        T          S       ?   P      ?   T                            RC01_01.PCX        V   =       U          Q      ?   V   =                         RC01_01.PCX        V   =       Q      ?   R   =   ?   V   =           j
       DEFAULT.PAL    MAIN             o   c    _0     
     6=     c B  _0  B  
  B  6=  B        9      B  B  9B  B  
 ƋB  
 Ƌ   *           ȶ   
 ƋB  * B    B    ȶB     S      $  L   =P   B  S   B  $  LB  =PB  F  O  A      -      ƩRx      EX      A  (  -  (  ƩRx  (  EX  (  2>    g&<          b      2>(  g&<(    (  b  (    =N    O                =N(  O(  (    (    O  O          U  'x  O  U    O  U  'x     U         O  ǩQx  O       ǩQx     ^  O  kU  ƙ  &0  O  vFm  ƙ    O  Zv  ƙ  -  
  O    /m  ƙ  I  Y^  O  ,  EU  ƙ  H  .  O  ,  7  ƙ  ,    O  ~    ƙ  ZKO  f  ƙ  !  O  .  O  V  ƙ  7  ƙ  zF     k        P    U        V  4      k  (    P(  U    (  V  4  (  G       p    n   Z8y      [  S  )[  A;[  
x  [  "  %  4 
%  :%  ZXV %  x                     4XNB_01.PCX           @         ?   ?               @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?                	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                   ?                     4XNB_02.PCX                        ?                                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_01.PCX           @         ?   ?   
            @                        4XNB_01.PCX        
            ?   ?         ?   
                           4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX        
      ?         ?   	         
      ?                     4XNB_02.PCX        	               ?   
         	                           4XNB_02.PCX              ?   
      ?                  ?                     4XNB_02.PCX                 
      ?   	                                    4XNB_02.PCX              ?         ?   
               ?                     4XNB_02.PCX        
               ?            
                           4XNB_01.PCX           @         ?   ?               @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_01.PCX           @          ?   ?               @                        4XNB_01.PCX                     ?   ?         ?                              4XNB_02.PCX            	   ?         ?      	          	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?          ?                  ?                     4XNB_02.PCX                        ?                                       4XNB_02.PCX        B   b      !           ;          B   b                        4XNB_02.PCX        C         !   `       B         C                           4XNB_02.PCX        :         !          C   \      :                           4XNB_02.PCX        >   ]   +   !         :         >   ]   +                     4XNB_02.PCX        ?      ,   !   `      >      +   ?      ,                     4XNB_02.PCX        ;         !          ?   c   ,   ;                           4XNB_02.PCX        )     ?   &      ?   '          )     ?                     4XNB_02.PCX        )     ?   '          (   z      )     ?                     4XNB_02.PCX        '   ?       &           "       ?   '   ?                         4XNB_02.PCX        '   ?       "       ?   #   ?   ?   '   ?                         4XNB_02.PCX        &          )         %     ?   &                            4XNB_02.PCX        &          %     ?   "      ?   &                            4XNB_02.PCX        (   z      '          #      ?   (   z                        4XNB_02.PCX        (   z      #      ?   $   z  ?   (   z                        4XNB_02.PCX        1     ?   .      ?   /          1     ?                     4XNB_02.PCX        1     ?   /          0   z      1     ?                     4XNB_02.PCX        /   ?       .           *       ?   /   ?                         4XNB_02.PCX        /   ?       *       ?   +   ?   ?   /   ?                         4XNB_02.PCX        .          1         -     ?   .                            4XNB_02.PCX        .          -     ?   *      ?   .                            4XNB_02.PCX        0   z      /          +      ?   0   z                        4XNB_02.PCX        0   z      +      ?   ,   z  ?   0   z                        4XNB_02.PCX        9     ?   6      ?   7          9     ?                     4XNB_02.PCX        9     ?   7          8   z      9     ?                     4XNB_02.PCX        7   ?       6           2       ?   7   ?                         4XNB_02.PCX        7   ?       2       ?   3   ?   ?   7   ?                         4XNB_02.PCX        6          9         5     ?   6                            4XNB_02.PCX        6          5     ?   2      ?   6                            4XNB_02.PCX        8   z      7          3      ?   8   z                        4XNB_02.PCX        8   z      3      ?   4   z  ?   8   z                        RC02_02.PCX        D      z   B      6   ;      6   D      z                     RC02_02.PCX        D      z   ;      6   =      z   D      z                     RC02_02.PCX        @      z   >      6   :   5   6   @      z                     RC02_02.PCX        @      z   :   5   6   <   5   z   @      z                     RC02_02.PCX        <   2   z   :   2   6   C      6   <   2   z                     RC02_02.PCX        <   2   z   C      6   E      z   <   2   z                     RC02_02.PCX        =      z   ;      6   ?      6   =      z                     RC02_02.PCX        =      z   ?      6   A      z   =      z                     RC02_02.PCX        A      z   ?      6   >       6   A      z                     RC02_02.PCX        A      z   >       6   @       z   A      z                     RC02_02.PCX        E       z   C       6   B      6   E       z                     RC02_02.PCX        E       z   B      6   D      z   E       z                     4XNB_01.PCX        G          Y   5       W   D   D   G                            4XNB_01.PCX        G   H       W      D   F   9   C   G   H                         4XNB_01.PCX        Z         Y   5   @   G      @   Z                           4XNB_01.PCX        I          G   6       F   D   C   I                            4XNB_01.PCX        I   H       F      C   H   :   D   I   H                         4XNB_01.PCX        Z         G   6   @   I      @   Z                           4XNB_01.PCX        K          I   6       H   D   C   K                            4XNB_01.PCX        K   H       H      C   J   :   D   K   H                         4XNB_01.PCX        Z         I   6   @   K      @   Z                           4XNB_01.PCX        M          K   6       J   D   C   M                            4XNB_01.PCX        M   H       J      C   L   :   D   M   H                         4XNB_01.PCX        Z         K   6   @   M      @   Z                           4XNB_01.PCX        O          M   5       L   D   D   O                            4XNB_01.PCX        O   H       L      D   N   9   C   O   H                         4XNB_01.PCX        Z         M   5   @   O      @   Z                           4XNB_01.PCX        Q          O   5      N   C   D   Q                            4XNB_01.PCX        Q   G       N      D   P   9   C   Q   G                         4XNB_01.PCX        Z         O   5   A   Q      @   Z                           4XNB_01.PCX        S          Q   5       P   D   D   S                            4XNB_01.PCX        S   H       P      D   R   9   C   S   H                         4XNB_01.PCX        Z         Q   5   @   S      @   Z                           4XNB_01.PCX        U          S   6       R   D   C   U                            4XNB_01.PCX        U   H       R      C   T   :   D   U   H                         4XNB_01.PCX        Z         S   6   @   U      @   Z                           4XNB_01.PCX        X          U   5       T   D   D   X                            4XNB_01.PCX        X   H       T      D   V   9   C   X   H                         4XNB_01.PCX        Z         U   5   @   X      @   Z                           4XNB_01.PCX        Y   	       X   7       V   E   C   Y   	                         4XNB_01.PCX        Y   I       V      C   W   ;   C   Y   I                         4XNB_01.PCX        Z          X   7   @   Y   	   @   Z                            4XNB_02.PCX        b     ?   _      ?   `          b     ?                     4XNB_02.PCX        b     ?   `          a   z      b     ?                     4XNB_02.PCX        `   ?       _           [       ?   `   ?                         4XNB_02.PCX        `   ?       [       ?   \   ?   ?   `   ?                         4XNB_02.PCX        _          b         ^     ?   _                            4XNB_02.PCX        _          ^     ?   [      ?   _                            4XNB_02.PCX        a   z      `          \      ?   a   z                        4XNB_02.PCX        a   z      \      ?   ]   z  ?   a   z          j
       DEFAULT.PAL    MAIN             p   
C  >       [     
C  >  .;    [  .;  7       Cj       7    .;  Cj    .;  uZ     =     uZ  .;  =  .;  #          #  .;    .;  
C  ]     2   
C  ].;    2.;  7  Ca   Cj  n~   7  Ca.;  Cj  n~.;        .;  .;  #e   sb   #e.;  sb.;  κ     _     u_     6     Ϻ  .;  _  .;  u_  .;  6  .;  
 1E.;    .;  
 1E   * u          4p   
 1E.;  * u.;    .;    4p.;  F  Ak      -'      Ʃ1            Ak  P$  -'  P$  Ʃ1  P$    P$  ^c  F  F  ^c        U  1  F  U  %F  U  1     U  %   OF  ǩ1  F  O   ǩ1       G      &>  G  v&    KM  G  /    -  u>  G    &    I    G  ,      H   G  ,  +  ,  fG  ~  P  ZG  f<  G  =G  Vg  P  z   ơ  k  ^      }    U  %    V  2    k  ^P$    }P$  U  %P$  V  2P$  }    M  s  ^3M  ;;=M   M  ~e v  5  [ 5  5  ٟS  5    G Y  qE *BY  ?<Y  ū  Y  t                     4XNB_01.PCX           ?   ?      @                  ?   ?                     4XNB_01.PCX           ?   ?                  ?      ?   ?                     4XNB_02.PCX              ?      	   ?      	            ?                     4XNB_02.PCX              ?      	                     ?                     4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX              ?                            ?                     4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX              ?                           ?                     4XNB_01.PCX           ?   ?      @                  ?   ?                     4XNB_01.PCX           ?   ?            
      ?      ?   ?                     4XNB_02.PCX              ?      	   ?   	   	            ?                     4XNB_02.PCX              ?   	   	                     ?                     4XNB_02.PCX        
      ?         ?   
         
      ?                     4XNB_02.PCX        
      ?   
                  
      ?                     4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX              ?            
               ?                     4XNB_01.PCX           @         ?   ?               @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_01.PCX           @         ?   ?               @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_01.PCX        $   @      '   ?   ?   %         $   @                        4XNB_01.PCX        %         '   ?   ?   &      ?   %                           4XNB_02.PCX        '   	   ?   $      ?   #   	      '   	   ?                     4XNB_02.PCX        #   	      $      ?             #   	                        4XNB_02.PCX        %      ?   &      ?   !         %      ?                     4XNB_02.PCX        !         &      ?   "         !                           4XNB_02.PCX        $      ?   %      ?             $      ?                     4XNB_02.PCX                  %      ?   !                                     4XNB_02.PCX        &      ?   '      ?   "         &      ?                     4XNB_02.PCX        "         '      ?   #         "                           4XNB_01.PCX        (   @      1   ?   ?   /         (   @                        4XNB_01.PCX        /         1   ?   ?   )      ?   /                           4XNB_02.PCX        1   	   ?   .      ?   -   	      1   	   ?                     4XNB_02.PCX        -   	      .      ?   *         -   	                        4XNB_02.PCX        /      ?   0      ?   +         /      ?                     4XNB_02.PCX        +         0      ?   ,         +                           4XNB_02.PCX        .      ?   /      ?   *         .      ?                     4XNB_02.PCX        *         /      ?   +         *                           4XNB_02.PCX        0      ?   1      ?   ,         0      ?                     4XNB_02.PCX        ,         1      ?   -         ,                           4XNB_02.PCX        C   b      2           <          C   b                        4XNB_02.PCX        D         2   `       C         D                           4XNB_02.PCX        ;         2          D   \      ;                           4XNB_02.PCX        ?   ]   +   2         ;         ?   ]   +                     4XNB_02.PCX        @      ,   2   `      ?      +   @      ,                     4XNB_02.PCX        <         2          @   c   ,   <                           4XNB_02.PCX        :     ?   7      ?   8          :     ?                     4XNB_02.PCX        :     ?   8          9   z      :     ?                     4XNB_02.PCX        8   ?       7           3       ?   8   ?                         4XNB_02.PCX        8   ?       3       ?   4   ?   ?   8   ?                         4XNB_02.PCX        7          :         6     ?   7                            4XNB_02.PCX        7          6     ?   3      ?   7                            4XNB_02.PCX        9   z      8          4      ?   9   z                        4XNB_02.PCX        9   z      4      ?   5   z  ?   9   z                        RC02_02.PCX        E      z   C      6   <      6   E      z                     RC02_02.PCX        E      z   <      6   >      z   E      z                     RC02_02.PCX        A      z   ?      6   ;   5   6   A      z                     RC02_02.PCX        A      z   ;   5   6   =   5   z   A      z                     RC02_02.PCX        =   2   z   ;   2   6   D      6   =   2   z                     RC02_02.PCX        =   2   z   D      6   F      z   =   2   z                     RC02_02.PCX        >      z   <      6   @      6   >      z                     RC02_02.PCX        >      z   @      6   B      z   >      z                     RC02_02.PCX        B      z   @      6   ?       6   B      z                     RC02_02.PCX        B      z   ?       6   A       z   B      z                     RC02_02.PCX        F       z   D       6   C      6   F       z                     RC02_02.PCX        F       z   C      6   E      z   F       z                     4XNB_01.PCX        H          Z   5       X   D   D   H                            4XNB_01.PCX        H   H       X      D   G   9   C   H   H                         4XNB_01.PCX        [         Z   5   @   H      @   [                           4XNB_01.PCX        J          H   6       G   D   C   J                            4XNB_01.PCX        J   H       G      C   I   :   D   J   H                         4XNB_01.PCX        [         H   6   @   J      @   [                           4XNB_01.PCX        L          J   6       I   D   C   L                            4XNB_01.PCX        L   H       I      C   K   :   D   L   H                         4XNB_01.PCX        [         J   6   @   L      @   [                           4XNB_01.PCX        N          L   6       K   D   C   N                            4XNB_01.PCX        N   H       K      C   M   :   D   N   H                         4XNB_01.PCX        [         L   6   @   N      @   [                           4XNB_01.PCX        P          N   5       M   D   D   P                            4XNB_01.PCX        P   H       M      D   O   9   C   P   H                         4XNB_01.PCX        [         N   5   @   P      @   [                           4XNB_01.PCX        R          P   5      O   C   D   R                            4XNB_01.PCX        R   G       O      D   Q   9   C   R   G                         4XNB_01.PCX        [         P   5   A   R      @   [                           4XNB_01.PCX        T          R   5       Q   D   D   T                            4XNB_01.PCX        T   H       Q      D   S   9   C   T   H                         4XNB_01.PCX        [         R   5   @   T      @   [                           4XNB_01.PCX        V          T   6       S   D   C   V                            4XNB_01.PCX        V   H       S      C   U   :   D   V   H                         4XNB_01.PCX        [         T   6   @   V      @   [                           4XNB_01.PCX        Y          V   5       U   D   D   Y                            4XNB_01.PCX        Y   H       U      D   W   9   C   Y   H                         4XNB_01.PCX        [         V   5   @   Y      @   [                           4XNB_01.PCX        Z   	       Y   7       W   E   C   Z   	                         4XNB_01.PCX        Z   I       W      C   X   ;   C   Z   I                         4XNB_01.PCX        [          Y   7   @   Z   	   @   [                            4XNB_02.PCX        c     ?   `      ?   a          c     ?                     4XNB_02.PCX        c     ?   a          b   z      c     ?                     4XNB_02.PCX        a   ?       `           \       ?   a   ?                         4XNB_02.PCX        a   ?       \       ?   ]   ?   ?   a   ?                         4XNB_02.PCX        `          c         _     ?   `                            4XNB_02.PCX        `          _     ?   \      ?   `                            4XNB_02.PCX        b   z      a          ]      ?   b   z                        4XNB_02.PCX        b   z      ]      ?   ^   z  ?   b   z          j
       DEFAULT.PAL    MAIN             -   M-*  M-    (  ;  -2  *  -2      @)  (  @)  ;  2   d  *  2   d      (   :R  (  (   :R  ;  V  1  *  V  1      JG  (  (  JG  (  ;  V  *   *  V           "G  (  ˭(  "G  ;  ˭;             4    R  	       !          P g0  oP |  0  1  0  yP  P  `  p  `  `    `     i   ӄi  i  sˌ  i  <                     CC02_02.PCX               N         @      ?   @          N                     CC02_02.PCX               N      ?   @      8   N          N                     CC02_02.PCX              o          N      8   N         o                     CC02_02.PCX              o      8   N      8   o         o                     CC02_02.PCX           ?   B      ,   4         4      ?   B                     CC02_02.PCX              B      R   4      ?   B         B                     CC02_01.PCX              @               ?            @                     CC02_01.PCX              @      ?         ?   @         @                     CC02_02.PCX           8   N      ?   @         @      8   N                     CC02_02.PCX           8   N         @          N      8   N                     CC02_02.PCX           8   o      8   N          N      8   o                     CC02_02.PCX           8   o          N         o      8   o                     CC02_02.PCX           ?   B      R   4      l   4      ?   B                     CC02_02.PCX           ?   B      l   4         B      ?   B                     CC02_01.PCX           ?   @      ?                  ?   @                     CC02_01.PCX           ?   @                  @      ?   @                     CC02_02.PCX           8   N      ?   @         @      8   N                     CC02_02.PCX           8   N         @         N      8   N                     CC02_02.PCX        	   8   o      8   N         N   	   8   o                     CC02_02.PCX        	   8   o         N         o   	   8   o                     CC02_02.PCX        
   ?   B      R   4      l   4   
   ?   B                     CC02_02.PCX        
   ?   B      l   4         B   
   ?   B                     CC02_01.PCX           ?   @   
   ?                  ?   @                     CC02_01.PCX           ?   @                  @      ?   @                     CC02_02.PCX           7   N      ?   @         @      7   N                     CC02_02.PCX           7   N         @         N      7   N                     CC02_02.PCX        
   7   o      7   N         N   
   7   o                     CC02_02.PCX        
   7   o         N   	      o   
   7   o                     CC02_02.PCX           ?   B      R   4      l   4      ?   B                     CC02_02.PCX           ?   B      l   4   
      B      ?   B                     CC02_01.PCX           ?   @      ?      
            ?   @                     CC02_01.PCX           ?   @   
               @      ?   @                     CC02_02.PCX           8   N      ?   @         @      8   N                     CC02_02.PCX           8   N         @         N      8   N                     CC02_02.PCX           8   o      8   N         N      8   o                     CC02_02.PCX           8   o         N   
      o      8   o                     CC02_02.PCX           ?   B      R   4      E   4      ?   B                     CC02_02.PCX           ?   B      E   4         B      ?   B                     CC02_01.PCX           ?   @      ?                  ?   @                     CC02_01.PCX           ?   @                  @      ?   @                     CC02_02.PCX              N         @      ?   @         N                     CC02_02.PCX              N      ?   @      8   N         N                     CC02_02.PCX              o         N      8   N         o                     CC02_02.PCX              o      8   N      8   o         o                     CC02_02.PCX           ?   B      ,   4         4      ?   B                     CC02_02.PCX              B      R   4      ?   B         B                     CC02_01.PCX              @               ?            @                     CC02_01.PCX              @      ?         ?   @         @                     CC02_02.PCX              4         4         4         4                     CC02_02.PCX           ,   4         4         4      ,   4                     CC02_02.PCX           9   4         4      ,   4      9   4                     CC02_02.PCX           ,   4         4      9   4      ,   4                     CC02_02.PCX              4         4      ,   4         4                     CC02_02.PCX              4         4         4         4                     CC02_02.PCX               '   !       '       -             '                     CC02_02.PCX        $       '          '   "         $       '                     CC02_02.PCX               '       -      "                '                     CC02_02.PCX        !       '   $       '   #         !       '                     CC02_02.PCX        !       '   #             -      !       '                     CC02_02.PCX        $       '   "         #         $       '       j
       DEFAULT.PAL    MAIN             %   e   p  y     i  >  a  -Z      s    ˖  >  \d  _  >  R+      U          e  >  Ԗ  >  R4         E  I>    ҫ    {  R j  
>  Z  @.    ;s+    ^ >  )s+     t   >  'e  >  -s    a+9V      
    7 e  ;jqz  
m   xe  $   R   !  Gw    0                     NEWCC1_B.PCX        
                :          :   
                           NEWCC1_B.PCX        
                :      >      
                           NEWCC1_B.PCX                        :          :                              NEWCC1_B.PCX                        :      >                                 NEWCC1_B.PCX                        :          :                              NEWCC1_B.PCX                        :   	   >                                 NEWCC1_B.PCX        	                :          :   	                           NEWCC1_B.PCX        	                :      >      	                           NEWCC1_B.PCX                        :          :                              NEWCC1_B.PCX                        :   
   >                                 NEWCC1_B.PCX                        :          :                              NEWCC1_B.PCX                        :      >                                 NEWCC1_B.PCX                        :          :                              NEWCC1_B.PCX                        :      >                                 NEWCC1_B.PCX                        :          :                              NEWCC1_B.PCX                        :      >                                 NEWCC1_A.PCX           %   8   
                       %   8                     NEWCC1_A.PCX           %   8                   8      %   8                     NEWCC1_A.PCX           !   ?      %   8         8      !   ?                     NEWCC1_A.PCX           !   ?         8         ?      !   ?                     NEWCC1_A.PCX           %   8                          %   8                     NEWCC1_A.PCX           %   8                   8      %   8                     NEWCC1_A.PCX           !   ?      %   8         8      !   ?                     NEWCC1_A.PCX           !   ?         8         ?      !   ?                     NEWCC1_A.PCX           %   8             	             %   8                     NEWCC1_A.PCX           %   8   	                8      %   8                     NEWCC1_A.PCX           !   ?      %   8         8      !   ?                     NEWCC1_A.PCX           !   ?         8         ?      !   ?                     NEWCC1_A.PCX           %   8   	                       %   8                     NEWCC1_A.PCX           %   8             
      8      %   8                     NEWCC1_A.PCX           !   ?      %   8   
      8      !   ?                     NEWCC1_A.PCX           !   ?   
      8         ?      !   ?                     NEWCC1_A.PCX           %   8             
             %   8                     NEWCC1_A.PCX           %   8   
                8      %   8                     NEWCC1_A.PCX           !   ?      %   8         8      !   ?                     NEWCC1_A.PCX           !   ?         8         ?      !   ?                     NEWCC1_A.PCX           %   8                          %   8                     NEWCC1_A.PCX           %   8                   8      %   8                     NEWCC1_A.PCX           !   ?      %   8         8      !   ?                     NEWCC1_A.PCX           !   ?         8         ?      !   ?                     NEWCC1_A.PCX           %   8                          %   8                     NEWCC1_A.PCX           %   8                   8      %   8                     NEWCC1_A.PCX           !   ?      %   8         8      !   ?                     NEWCC1_A.PCX           !   ?         8         ?      !   ?                     NEWCC1_A.PCX           %   8                          %   8                     NEWCC1_A.PCX           %   8                   8      %   8                     NEWCC1_A.PCX           !   ?      %   8         8      !   ?                     NEWCC1_A.PCX           !   ?         8         ?      !   ?       j
       DEFAULT.PAL    MAIN             "   z|e    me  (  C!e  &que  /&  e  )    e      ;    [      <  	   (  C!  (  C!A  .      &qu  &quA  Pm    /&    /&  A  c        m  )        mA  )    A    /    .  u           1  þb  !   1  w [   3/[  H7[    [  -                     HQ02_02.PCX              ;                3            ;                     HQ02_02.PCX                     !         !   ;                              HQ02_02.PCX           e          !   /               e                        HQ02_02.PCX                     a   /                                       HQ02_02.PCX           3             /      ]         3                        HQ02_02.PCX              !         ;      3            !                     HQ02_02.PCX              !      3      
               !                     HQ02_02.PCX                             !   ;                              HQ02_02.PCX                    !   ;          !                              HQ02_02.PCX           r         e                  r                        HQ02_02.PCX           r                           r                        HQ02_02.PCX        	   
                        	   
                        HQ02_02.PCX        	   
                        	   
                        HQ02_02.PCX        
            3         ]      
                           HQ02_02.PCX        
            ]      	   M      
                           HQ02_02.PCX              ;         !   
               ;                     HQ02_02.PCX              ;   
            3            ;                     HQ02_02.PCX                                 !                              HQ02_02.PCX                        !      !   ;                              HQ02_02.PCX           e         r                  e                        HQ02_02.PCX           e                           e                        HQ02_02.PCX                 	   
                                          HQ02_02.PCX                                                              HQ02_02.PCX           3      
         	   M         3                        HQ02_02.PCX           3      	   M         ]         3                        HQ02_01.PCX           8         8   ;         ;      8                        HQ02_01.PCX           8            ;               8                        HQ02_01.PCX        
   3   K      8   E         E   
   3   K                     HQ02_01.PCX        
   3   K         E        K   
   3   K                     HQ02_01.PCX                       ;      >   ;                              HQ02_01.PCX                    >   ;      >                                 HQ02_01.PCX              K         E      >   E         K                     HQ02_01.PCX              K      >   E   
   3   K         K                     HQ02_01.PCX           =         =   ;        ;      =                        HQ02_01.PCX           =           ;              =                        HQ02_01.PCX           6   K      =   E        E      6   K                     HQ02_01.PCX           6   K        E        K      6   K                     HQ02_01.PCX           5         5   ;         ;      5                        HQ02_01.PCX           5            ;               5                        HQ02_01.PCX           .   K      5   E         E      .   K                     HQ02_01.PCX           .   K         E        K      .   K                     HQ02_01.PCX           7         7   ;         ;      7                        HQ02_01.PCX           7            ;               7                        HQ02_01.PCX           1   K      7   E         E      1   K                     HQ02_01.PCX           1   K         E        K      1   K       j
       DEFAULT.PAL    MAIN                    tK  US    Z  US  tKZ  ~ Tz    Tz       z  )    d   L      W  z     ~ z  )  ~ d   L~     W~ z  @       R  @R     2 ;   |;  w||;  {|6  ;           *        
   RECC02.PCX        
      ?      a          !   ?   
      ?         *        
   RECC02.PCX                     !          a   ?                   *        
   RECC02.PCX           a       
   !   ?         ?      a             *        
   RECC02.PCX           [      	   .   ?       b          [            *        
   RECC02.PCX           [      
     ?   	   .   ?      [            *        
   RECC02.PCX            a       	      ?      !   ?       a             *        
   RECC02.PCX           !   ?          @      a         !   ?         *        
   RECC02.PCX           !         a   ?               !            *        
   RECC01.PCX           /           ?               /           *        
   RECC01.PCX           /     
   /  ?         ?      /           *        
   RECC01.PCX        
   /  ?            	      ?   
   /  ?         *        
   RECC01.PCX        
   /  ?      /              
   /  ?         *        
   RECC03.PCX                         @                             *        
   RECC03.PCX                        @          @                   *        
   RECC02.PCX        
           b   ?      .      
              *        
   RECC02.PCX        
   O          ?      "   ?   
   O           *        
   RECC01.PCX           !         -   ?         ?      !            *        
   RECC01.PCX                   !            ?                 *        
   RECC01.PCX        	      ?                   ?   	      ?         *        
   RECC01.PCX        
   -   ?      !            ?   
   -   ?         *        
   RECC01.PCX           !                    ?      !            *        
   RECC01.PCX                 
      ?          ?                j
       DEFAULT.PAL    MAIN             '     ^  z  X  e        ^  z  X  e      [  l    m  z  Y    z  `        g     !dZ  z  m  z  Ԛ>      F      z          /  P_  $z  f  W    `-    m  ^  +!z  ""z  L2      "'z  !iZ  z      #?a      Z   3    .h         W  W<  <   o   6   -6  'uK6  FE  6  0                     CCC01_01.PCX        
   %   8                       
   %   8                     CCC01_01.PCX        
   %   8                    8   
   %   8                     CCC01_01.PCX           !   ?   
   %   8          8      !   ?                     CCC01_01.PCX           !   ?          8         ?      !   ?                     CCC01_02.PCX                       :         :                              CCC01_02.PCX                       :      >                                 CCC01_01.PCX           %   8                          %   8                     CCC01_01.PCX           %   8                   8      %   8                     CCC01_01.PCX           !   ?      %   8         8      !   ?                     CCC01_01.PCX           !   ?         8         ?      !   ?                     CCC01_02.PCX                       :         :                              CCC01_02.PCX                       :      >                                 CCC01_01.PCX           %   8                          %   8                     CCC01_01.PCX           %   8                   8      %   8                     CCC01_01.PCX           !   ?      %   8         8      !   ?                     CCC01_01.PCX           !   ?         8         ?      !   ?                     CCC01_02.PCX                       :         :                              CCC01_02.PCX                       :      >                                 CCC01_01.PCX        
   %   8                       
   %   8                     CCC01_01.PCX        
   %   8             	      8   
   %   8                     CCC01_01.PCX           !   ?   
   %   8   	      8      !   ?                     CCC01_01.PCX           !   ?   	      8         ?      !   ?                     CCC01_02.PCX                       :         :                              CCC01_02.PCX                       :      >                                 CCC01_01.PCX           %   8                          %   8                     CCC01_01.PCX           %   8             
      8      %   8                     CCC01_01.PCX           !   ?      %   8   
      8      !   ?                     CCC01_01.PCX           !   ?   
      8         ?      !   ?                     CCC01_02.PCX                       :         :                              CCC01_02.PCX                       :      >                                 CCC01_01.PCX           %   8                          %   8                     CCC01_01.PCX           %   8                   8      %   8                     CCC01_01.PCX           !   ?      %   8         8      !   ?                     CCC01_01.PCX           !   ?         8         ?      !   ?                     CCC01_02.PCX                       :         :                              CCC01_02.PCX                       :      >                                 CCC01_01.PCX           %   8                          %   8                     CCC01_01.PCX           %   8                   8      %   8                     CCC01_01.PCX           !   ?      %   8         8      !   ?                     CCC01_01.PCX           !   ?         8         ?      !   ?                     CCC01_02.PCX                       :         :                              CCC01_02.PCX                       :      >                                 CCC01_01.PCX           %   8                          %   8                     CCC01_01.PCX           %   8                   8      %   8                     CCC01_01.PCX           !   ?      %   8         8      !   ?                     CCC01_01.PCX           !   ?         8         ?      !   ?                     CCC01_02.PCX                       :         :                              CCC01_02.PCX                       :      >                   j
       DEFAULT.PAL    MAIN             8          *     *  /*  h'*  'U}  *  x     *    |  *  {l@  ы\  @    @  ]  t  @  $    @  u  @    ok@  Ɗ@    _A    h    kB  ~R    i      S  &    ߖ  4
     8  ,1,  ,1     nVϏ   nV\=    ,          Ϗ    \=      ,             FT Ϗ     FT \=  f E  ,  f E       '   Ϗ   '   \=  
f b0,  8b,  
f b0    8b    [& QUϏ  [Ϗ  [& QU\=  [\=       /  C5-  I      U      U  K^U  Ic  U  N                     CCC02_02.PCX           @   W      7   H      O          @   W                     CCC02_02.PCX           @   W      O       -   `          @   W                     CCC02_02.PCX           ?   W      H   H      w   H      ?   W                     CCC02_02.PCX           ?   W      w   H         W      ?   W                     CCC02_02.PCX        "            0         H   H   "                           CCC02_02.PCX        "            H   H      ?   W   "                           CCC02_02.PCX        &   ?   (      H   7      0   _   &   ?   (                     CCC02_02.PCX        &   ?   (      0   _   "      _   &   ?   (                     CCC02_02.PCX        ,   @   (      7   7         7   ,   @   (                     CCC02_02.PCX        ,      (      H   7   &   ?   (   ,      (                     CCC02_02.PCX        -   `   `      O   `      7   7   -   `   `                     CCC02_02.PCX        -   `   `      7   7   ,   @   (   -   `   `                     CCC02_02.PCX           7   7          `         7      7   7                     CCC02_02.PCX           O   `          `      7   7      O   `                     CCC02_02.PCX           7   H                 O          7   H                     CCC02_02.PCX              H                 7   H         H                     CCC02_02.PCX           0          _          H   H      0                        CCC02_02.PCX           H   7       _   `      0   _      H   7                     CCC02_02.PCX           "   3      /   ,      6   1      "   3                     CCC02_02.PCX           "   3      6   1      #   ;      "   3                     CCC02_02.PCX              /      "   3      #   ;         /                     CCC02_02.PCX              /      #   ;         5         /                     CCC02_02.PCX              "         /         5         "                     CCC02_02.PCX              "         5   	      #         "                     CCC02_02.PCX                       "   	      #                              CCC02_02.PCX                 	      #   
   	                                 CCC02_02.PCX                          
   	                                 CCC02_02.PCX                 
   	                                          CCC02_02.PCX           ,                           ,                        CCC02_02.PCX           ,                  1   	      ,                        CCC02_02.PCX           3         ,         1   	      3                        CCC02_02.PCX           3         1   	   
   <         3                        CCC02_02.PCX           /   ,      3      
   <         /   ,                     CCC02_02.PCX           /   ,   
   <         6   1      /   ,                     CCC02_02.PCX                     /   ,      "   3                               CCC02_02.PCX                     "   3         /                               CCC02_02.PCX                        /         "                               CCC02_02.PCX                        "                                        CCC02_02.PCX                                                                CCC02_02.PCX                              ,                                  CCC02_02.PCX                     ,         3                                  CCC02_02.PCX                     3         /   ,                               CCC02_02.PCX              N         @   /   ?   @         N                     CCC02_02.PCX              N   /   ?   @   )   8   N         N                     CCC02_02.PCX              o         N   )   8   N         o                     CCC02_02.PCX              o   )   8   N   +   8   o         o                     CCC02_01.PCX              @            -   ?            @                     CCC02_01.PCX              @   -   ?      /   ?   @         @                     CCC02_02.PCX           8   M      ?   @         @      8   M                     CCC02_02.PCX           8   M         @         M      8   M                     CCC02_02.PCX           8   o      8   M         M      8   o                     CCC02_02.PCX           8   o         M         o      8   o                     CCC02_01.PCX           ?   @      ?                    ?   @                     CCC02_01.PCX           ?   @                   @      ?   @                     CCC02_02.PCX            8   N   #   ?   @         @       8   N                     CCC02_02.PCX            8   N         @         N       8   N                     CCC02_02.PCX        !   8   o       8   N         N   !   8   o                     CCC02_02.PCX        !   8   o         N         o   !   8   o                     CCC02_01.PCX        #   ?   @   "   ?               #   ?   @                     CCC02_01.PCX        #   ?   @                  @   #   ?   @                     CCC02_02.PCX        $   7   N   '   ?   @   #      @   $   7   N                     CCC02_02.PCX        $   7   N   #      @          N   $   7   N                     CCC02_02.PCX        %   7   o   $   7   N          N   %   7   o                     CCC02_02.PCX        %   7   o          N   !      o   %   7   o                     CCC02_01.PCX        '   ?   @   &   ?      "         '   ?   @                     CCC02_01.PCX        '   ?   @   "         #      @   '   ?   @                     CCC02_02.PCX        (      M   .      @   '   ?   @   (      M                     CCC02_02.PCX        (      M   '   ?   @   $   9   M   (      M                     CCC02_02.PCX        *      o   (      M   $   9   M   *      o                     CCC02_02.PCX        *      o   $   9   M   %   9   o   *      o                     CCC02_01.PCX        .      @   ,          &   ?       .      @                     CCC02_01.PCX        .      @   &   ?       '   ?   @   .      @                     CCC02_02.PCX        )      N   /      @   .   ?   @   )      N                     CCC02_02.PCX        )      N   .   ?   @   (   8   N   )      N                     CCC02_02.PCX        +      o   )      N   (   8   N   +      o                     CCC02_02.PCX        +      o   (   8   N   *   8   o   +      o                     CCC02_01.PCX        /      @   -         ,   ?      /      @                     CCC02_01.PCX        /      @   ,   ?      .   ?   @   /      @       j
       DEFAULT.PAL    MAIN             +       G   .  t    a2u  2A   t   t     z   Z'    a        3     T      S &    Bb    Z'nn  J  J  a nn  S   S      3 nn     PW      PW   T  nn   D    D   S &nn  Bbnn  u I  d  u I  d  Fj ^  )   t)  )  \^)  `z " )   8  )  եF)  v+Õ )  w > )  d 1)  J{)  Q )  6                     HQ01_02.PCX           i   N      b   B      v          i   N                     HQ01_02.PCX           i   N      v                    i   N                     HQ01_02.PCX              N         B         B         N                     HQ01_02.PCX              N         B         N         N                     HQ01_02.PCX           ;         I         ]   B      ;                        HQ01_02.PCX           ;         ]   B      V   N      ;                        HQ01_02.PCX              1         =      	   _         1                     HQ01_02.PCX           V   1      I   _      ;   _      V   1                     HQ01_02.PCX              1         =         =         1                     HQ01_02.PCX              1         =         1         1                     HQ01_02.PCX              `      v   `      b   =         `                     HQ01_02.PCX              `      b   =      i   1         `                     HQ01_02.PCX              =       1   `         =         =                     HQ01_02.PCX              `       1   `         =         `                     HQ01_02.PCX              B       1                       B                     HQ01_02.PCX              B       1             B         B                     HQ01_02.PCX           	          1             B      	                        HQ01_02.PCX              =       1   `      	   _         =                     HQ01_01.PCX           E     
   E  ?        ?      E                       HQ01_01.PCX           E          ?              E                       HQ01_01.PCX           :         :   ?   
     ?      :                        HQ01_01.PCX           :      
     ?              :                        HQ01_01.PCX        	                 ?      z   ?   	                            HQ01_01.PCX        	             z   ?      z      	                            HQ01_01.PCX        
   z         z   ?          ?   
   z                        HQ01_01.PCX        
   z             ?   	          
   z                        HQ01_01.PCX                     ?      :   ?                             HQ01_01.PCX                   :   ?   
   :                                HQ01_01.PCX                     ?      E  ?                             HQ01_01.PCX                   E  ?      E                               HQ01_01.PCX        
               	      =  	   
                           HQ01_01.PCX        
            =  	      ^     
                           HQ01_01.PCX              I         >      =  >         I                     HQ01_01.PCX              I      =  >      =  I         I                     HQ01_01.PCX           >         O   	        	      >                        HQ01_01.PCX           >           	   
            >                        HQ01_01.PCX              I         >        >         I                     HQ01_01.PCX              I        >        I         I                     HQ01_01.PCX           !         B   	         	      !                        HQ01_01.PCX           !            	      ~         !                        HQ01_01.PCX              I         >      O   >         I                     HQ01_01.PCX              I      O   >      O   I         I                     HQ01_01.PCX           ?         O   	         	      ?                        HQ01_01.PCX                    B   	      !                                 HQ01_01.PCX           O   I      O   >         >      O   I                     HQ01_01.PCX           O   I         >         I      O   I                     HQ01_01.PCX                     	         	                             HQ01_01.PCX                   O   	      ?                                HQ01_01.PCX             I        >         >        I                     HQ01_01.PCX             I         >         I        I                     HQ01_01.PCX           ^        =  	         	      ^                       HQ01_01.PCX           ^           	              ^                       HQ01_01.PCX           =  I      =  >         >      =  I                     HQ01_01.PCX           =  I         >         I      =  I       j
       DEFAULT.PAL    MAIN             !   יu      "QH    #11     lw       x     _         x0     -  -    f s        G    )f     [            dC  d7    "  	"    x'    vC  j"f          6    ٹ  Z    Z  WZ   @  Z   d Z  - zZ  AZ  4ʕ Z  F	 I Z  Y Z  CZ  L6  Z                       RC02_01.PCX                     5          D   D                               RC02_01.PCX           H             D       9   C      H                         RC02_01.PCX                    5   @         @                              RC02_01.PCX                     6           D   C                               RC02_01.PCX           H              C      :   D      H                         RC02_01.PCX                    6   @         @                              RC02_01.PCX                     6          D   C                               RC02_01.PCX           H             C      :   D      H                         RC02_01.PCX                    6   @         @                              RC02_01.PCX                     6          D   C                               RC02_01.PCX           H             C      :   D      H                         RC02_01.PCX                    6   @         @                              RC02_01.PCX        	             5          D   D   	                            RC02_01.PCX        	   H             D      9   C   	   H                         RC02_01.PCX                    5   @   	      @                              RC02_01.PCX                  	   5         C   D                               RC02_01.PCX           G             D   
   9   C      G                         RC02_01.PCX                 	   5   A         @                              RC02_01.PCX        
             5       
   D   D   
                            RC02_01.PCX        
   H       
      D      9   C   
   H                         RC02_01.PCX                    5   @   
      @                              RC02_01.PCX                  
   6          D   C                               RC02_01.PCX           H             C      :   D      H                         RC02_01.PCX                 
   6   @         @                              RC02_01.PCX                     5          D   D                               RC02_01.PCX           H             D      9   C      H                         RC02_01.PCX                    5   @         @                              RC02_01.PCX           	          7          E   C      	                         RC02_01.PCX           I             C      ;   C      I                         RC02_01.PCX                     7   @      	   @                 j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                         4R       @                              PUNIT.3D                         4    D                                 PGEN.3D                         P                                     ATV.3D                                                              GCV1A.3D                                                              GCV2A.3D                         3       t                              TSX1.3D                         Ĳ3       h                              AX10.3D                             $   t                              MK1P.3D                      	   𳵂                                     MK1D.3D                      
                                        MECH1.3D                         丵       Ш                              MECH2.3D                                ਵ                           	   NPLANT.3D                      
       P                                  RADAR.3D                         D                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                         4R       @                              PUNIT.3D                         4    D                                 PGEN.3D                         P                                     ATV.3D                                                              GCV1A.3D                                                              GCV2A.3D                         3       t                              TSX1.3D                         Ĳ3       h                              AX10.3D                             $   t                              MK1P.3D                      	   𳵂                                     MK1D.3D                      
                                        MECH1.3D                         丵       Ш                              MECH2.3D                                ਵ                           	   NPLANT.3D                      
       P                                  RADAR.3D                         D                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                         4L       @                              PUNIT.3D                         4    D                                 PGEN.3D                         PS                                     ATV.3D                         "                                     GCV1A.3D                         "                                     GCV2A.3D                         "       t                              TSX1.3D                         Ĳ"       h                              AX10.3D                                t                              MK1P.3D                      	   𳵂                                     MK1D.3D                      
                                        MECH1.3D                         丵       Ш                              MECH2.3D                                ਵ                           	   NPLANT.3D                      
       D                                  RADAR.3D                         D                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                         p                              EWR.3D                                                              PUNIT.3D                                t                              PGEN.3D                         L       h                              ATV.3D                         \       Ȯ                              GCV1A.3D                                                              GCV2A.3D                             D                                 TSX1.3D                         켵       x                              AX10.3D                         켵    D   Ĥ                              MK1P.3D                      	                                        MK1D.3D                      
          D                              MECH1.3D                                                          MECH2.3D                                İ                           	   NPLANT.3D                      
   ĵ                                     RADAR.3D                         ĵ                                  	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                  ĵlȵȵ                              EWR.3D                         ĵ,   õ                              PUNIT.3D                         xʵ        į                              PGEN.3D                         xʵ                                      ATV.3D                         \̵                                      GCV1A.3D                         \̵        ,                              GCV2A.3D                         ̵                                      TSX1.3D                         ͵                                       AX10.3D                         ϵ                                      MK1P.3D                      	   е                                      MK1D.3D                      
   еD   D   Ƶ                              MECH1.3D                         е        Ƶ                              MECH2.3D                         ѵ        <ǵ                           	   NPLANT.3D                      
   8ӵ        ȵ                              RADAR.3D                         8ӵD   D   ɵ                           	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                  ĵlȵȵ                              EWR.3D                         ĵ,   õ                              PUNIT.3D                         xʵ        į                              PGEN.3D                         xʵ                                      ATV.3D                         \̵                                      GCV1A.3D                         \̵        ,                              GCV2A.3D                         ̵                                      TSX1.3D                         ͵                                       AX10.3D                         ϵ                                      MK1P.3D                      	   е                                      MK1D.3D                      
   еD   D   Ƶ                              MECH1.3D                         е        Ƶ                              MECH2.3D                         ѵ        <ǵ                           	   NPLANT.3D                      
   8ӵ        ȵ                              RADAR.3D                         8ӵD   D   ɵ                           	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                  ĵ                                     EWR.3D                         ĵ,                                    PUNIT.3D                         xʵ       į                              PGEN.3D                         xʵ    D                                 ATV.3D                         \̵                                     GCV1A.3D                         \̵ѷD   ,                              GCV2A.3D                         ̵                                      TSX1.3D                         ͵!                                      AX10.3D                         ϵ@                                     MK1P.3D                      	   е!                                     MK1D.3D                      
   е    D   Ƶ                              MECH1.3D                         е!       Ƶ                              MECH2.3D                         ѵ@       <ǵ                           	   NPLANT.3D                      
   8ӵ!       ȵ                              RADAR.3D                         8ӵ    D   ɵ                           	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                  ĵ                                     EWR.3D                         ĵ,                                    PUNIT.3D                         xʵ       į                              PGEN.3D                         xʵ    D                                 ATV.3D                         \̵                                     GCV1A.3D                         \̵ѷD   ,                              GCV2A.3D                         ̵                                      TSX1.3D                         ͵!                                      AX10.3D                         ϵ@                                     MK1P.3D                      	   е!                                     MK1D.3D                      
   е    D   Ƶ                              MECH1.3D                         е!       Ƶ                              MECH2.3D                         ѵ@       <ǵ                           	   NPLANT.3D                      
   8ӵ!       ȵ                              RADAR.3D                         8ӵ    D   ɵ                           	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                  ĵ                                     EWR.3D                         ĵ,                                    PUNIT.3D                         xʵ       į                              PGEN.3D                         xʵ    D                                 ATV.3D                         \̵                                     GCV1A.3D                         \̵ѷD   ,                              GCV2A.3D                         ̵                                      TSX1.3D                         ͵!                                      AX10.3D                         ϵ@                                     MK1P.3D                      	   е!                                     MK1D.3D                      
   е    D   Ƶ                              MECH1.3D                         е!       Ƶ                              MECH2.3D                         ѵ@       <ǵ                           	   NPLANT.3D                      
   8ӵ!       ȵ                              RADAR.3D                         8ӵ    D   ɵ                           	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                  ĵ                                     EWR.3D                         ĵ,                                    PUNIT.3D                         xʵ       į                              PGEN.3D                         xʵ    D                                 ATV.3D                         \̵                                     GCV1A.3D                         \̵ѷD   ,                              GCV2A.3D                         ̵                                      TSX1.3D                         ͵!                                      AX10.3D                         ϵ@                                     MK1P.3D                      	   е!                                     MK1D.3D                      
   е    D   Ƶ                              MECH1.3D                         е!       Ƶ                              MECH2.3D                         ѵ@       <ǵ                           	   NPLANT.3D                      
   8ӵ!       ȵ                              RADAR.3D                         8ӵ    D   ɵ                           	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                  ĵ                                     EWR.3D                         ĵ,                                    PUNIT.3D                         xʵ       į                              PGEN.3D                         xʵ    D                                 ATV.3D                         \̵                                     GCV1A.3D                         \̵ѷD   ,                              GCV2A.3D                         ̵                                      TSX1.3D                         ͵!                                      AX10.3D                         ϵ@                                     MK1P.3D                      	   е!                                     MK1D.3D                      
   е    D   Ƶ                              MECH1.3D                         е!       Ƶ                              MECH2.3D                         ѵ@       <ǵ                           	   NPLANT.3D                      
   8ӵ!       ȵ                              RADAR.3D                         8ӵ    D   ɵ                           	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                  ĵ                                     EWR.3D                         ĵ,                                    PUNIT.3D                         xʵ       į                              PGEN.3D                         xʵ    D                                 ATV.3D                         \̵                                     GCV1A.3D                         \̵ѷD   ,                              GCV2A.3D                         ̵                                      TSX1.3D                         ͵!                                      AX10.3D                         ϵ@                                     MK1P.3D                      	   е!                                     MK1D.3D                      
   е    D   Ƶ                              MECH1.3D                         е!       Ƶ                              MECH2.3D                         ѵ@       <ǵ                           	   NPLANT.3D                      
   8ӵ!       ȵ                              RADAR.3D                         8ӵ    D   ɵ                           	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                  ĵ                                     EWR.3D                         ĵ,                                    PUNIT.3D                         xʵ       į                              PGEN.3D                         xʵ    D                                 ATV.3D                         \̵                                     GCV1A.3D                         \̵ѷD   ,                              GCV2A.3D                         ̵                                      TSX1.3D                         ͵!                                      AX10.3D                         ϵ@                                     MK1P.3D                      	   е!                                     MK1D.3D                      
   е    D   Ƶ                              MECH1.3D                         е!       Ƶ                              MECH2.3D                         ѵ@       <ǵ                           	   NPLANT.3D                      
   8ӵ!       ȵ                              RADAR.3D                         8ӵ    D   ɵ                           	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                  ĵ                                     EWR.3D                         ĵ,                                    PUNIT.3D                         xʵ       į                              PGEN.3D                         xʵ    D                                 ATV.3D                         \̵                                     GCV1A.3D                         \̵ѷD   ,                              GCV2A.3D                         ̵                                      TSX1.3D                         ͵!                                      AX10.3D                         ϵ@                                     MK1P.3D                      	   е!                                     MK1D.3D                      
   е    D   Ƶ                              MECH1.3D                         е!       Ƶ                              MECH2.3D                         ѵ@       <ǵ                           	   NPLANT.3D                      
   8ӵ!       ȵ                              RADAR.3D                         8ӵ    D   ɵ                           	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                  ĵ                                     EWR.3D                         ĵ,                                    PUNIT.3D                         xʵ       į                              PGEN.3D                         xʵ    D                                 ATV.3D                         \̵                                     GCV1A.3D                         \̵ѷD   ,                              GCV2A.3D                         ̵                                      TSX1.3D                         ͵!                                      AX10.3D                         ϵ@                                     MK1P.3D                      	   е!                                     MK1D.3D                      
   е    D   Ƶ                              MECH1.3D                         е!       Ƶ                              MECH2.3D                         ѵ@       <ǵ                           	   NPLANT.3D                      
   8ӵ!       ȵ                              RADAR.3D                         8ӵ    D   ɵ                           	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                  ĵ                                     EWR.3D                         ĵ,                                    PUNIT.3D                         xʵ       į                              PGEN.3D                         xʵ    D                                 ATV.3D                         \̵                                     GCV1A.3D                         \̵ѷD   ,                              GCV2A.3D                         ̵                                      TSX1.3D                         ͵!                                      AX10.3D                         ϵ@                                     MK1P.3D                      	   е!                                     MK1D.3D                      
   е    D   Ƶ                              MECH1.3D                         е!       Ƶ                              MECH2.3D                         ѵ@       <ǵ                           	   NPLANT.3D                      
   8ӵ!       ȵ                              RADAR.3D                         8ӵ    D   ɵ                           	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                  ĵ                                     EWR.3D                         ĵ,                                    PUNIT.3D                         xʵ       į                              PGEN.3D                         xʵ    D                                 ATV.3D                         \̵                                     GCV1A.3D                         \̵ѷD   ,                              GCV2A.3D                         ̵                                      TSX1.3D                         ͵!                                      AX10.3D                         ϵ@                                     MK1P.3D                      	   е!                                     MK1D.3D                      
   е    D   Ƶ                              MECH1.3D                         е!       Ƶ                              MECH2.3D                         ѵ@       <ǵ                           	   NPLANT.3D                      
   8ӵ!       ȵ                              RADAR.3D                         8ӵ    D   ɵ                           	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                  ĵ                                     EWR.3D                         ĵ,                                    PUNIT.3D                         xʵ       į                              PGEN.3D                         xʵ    D                                 ATV.3D                         \̵                                     GCV1A.3D                         \̵ѷD   ,                              GCV2A.3D                         ̵                                      TSX1.3D                         ͵!                                      AX10.3D                         ϵ@                                     MK1P.3D                      	   е!                                     MK1D.3D                      
   е    D   Ƶ                              MECH1.3D                         е!       Ƶ                              MECH2.3D                         ѵ@       <ǵ                           	   NPLANT.3D                      
   8ӵ!       ȵ                              RADAR.3D                         8ӵ    D   ɵ                           	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                  ĵ                                     EWR.3D                         ĵ,                                    PUNIT.3D                         xʵ       į                              PGEN.3D                         xʵ    D                                 ATV.3D                         \̵                                     GCV1A.3D                         \̵ѷD   ,                              GCV2A.3D                         ̵                                      TSX1.3D                         ͵!                                      AX10.3D                         ϵ@                                     MK1P.3D                      	   е!                                     MK1D.3D                      
   е    D   Ƶ                              MECH1.3D                         е!       Ƶ                              MECH2.3D                         ѵ@       <ǵ                           	   NPLANT.3D                      
   8ӵ!       ȵ                              RADAR.3D                         8ӵ    D   ɵ                           	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                  ĵ                                     EWR.3D                         ĵ,                                    PUNIT.3D                         xʵ       į                              PGEN.3D                         xʵ    D                                 ATV.3D                         \̵                                     GCV1A.3D                         \̵ѷD   ,                              GCV2A.3D                         ̵                                      TSX1.3D                         ͵!                                      AX10.3D                         ϵ@                                     MK1P.3D                      	   е!                                     MK1D.3D                      
   е    D   Ƶ                              MECH1.3D                         е!       Ƶ                              MECH2.3D                         ѵ@       <ǵ                           	   NPLANT.3D                      
   8ӵ!       ȵ                              RADAR.3D                         8ӵ    D   ɵ                           	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                  ĵ                                     EWR.3D                         ĵ,                                    PUNIT.3D                         xʵ       į                              PGEN.3D                         xʵ    D                                 ATV.3D                         \̵                                     GCV1A.3D                         \̵ѷD   ,                              GCV2A.3D                         ̵                                      TSX1.3D                         ͵!                                      AX10.3D                         ϵ@                                     MK1P.3D                      	   е!                                     MK1D.3D                      
   е    D   Ƶ                              MECH1.3D                         е!       Ƶ                              MECH2.3D                         ѵ@       <ǵ                           	   NPLANT.3D                      
   8ӵ!       ȵ                              RADAR.3D                         8ӵ    D   ɵ                           	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN                   Z    ~47     ih            |o:      )
  qk         _     z d      `           s          [t    μ  f     &l                                  ĵ                                     EWR.3D                         ĵ,                                    PUNIT.3D                         xʵ       į                              PGEN.3D                         xʵ    D                                 ATV.3D                         \̵                                     GCV1A.3D                         \̵ѷD   ,                              GCV2A.3D                         ̵                                      TSX1.3D                         ͵!                                      AX10.3D                         ϵ@                                     MK1P.3D                      	   е!                                     MK1D.3D                      
   е    D   Ƶ                              MECH1.3D                         е!       Ƶ                              MECH2.3D                         ѵ@       <ǵ                           	   NPLANT.3D                      
   8ӵ!       ȵ                              RADAR.3D                         8ӵ    D   ɵ                           	   EARTHB.3D       EWR.3D 	   NPLANT.3D    PUNIT.3D    PGEN.3D    ATV.3D    GCV1A.3D    GCV2A.3D    TSX1.3D    AX10.3D    MK1P.3D    MK1D.3D    MECH1.3D    MECH2.3D    RADAR.3D 	   EARTHB.3D j
       DEFAULT.PAL    MAIN             p   
C  >       [     
C  >  .;    [  .;  7       Cj       7    .;  Cj    .;  uZ     =     uZ  .;  =  .;  #          #  .;    .;  
C  ]     2   
C  ].;    2.;  7  Ca   Cj  n~   7  Ca.;  Cj  n~.;        .;  .;  #e   sb   #e.;  sb.;  κ     _     u_     6     Ϻ  .;  _  .;  u_  .;  6  .;  
 1E.;    .;  
 1E   * u          4p   
 1E.;  * u.;    .;    4p.;  F  Ak      -'      Ʃ1            Ak  P$  -'  P$  Ʃ1  P$    P$  ^c  F  F  ^c        U  1  F  U  %F  U  1     U  %   OF  ǩ1  F  O   ǩ1       G      &>  G  v&    KM  G  /    -  u>  G    &    I    G  ,      H   G  ,  +  ,  fG  ~  P  ZG  f<  G  =G  Vg  P  z   ơ  k  ^      }    U  %    V  2    k  ^P$    }P$  U  %P$  V  2P$  }    M  s  ^3M  ;;=M   M  ~e v  5  [ 5  5  ٟS  5    G Y  qE *BY  ?<Y  ū  Y  w                     4XNB_01.PCX           ?   ?      @                  ?   ?                     4XNB_01.PCX           ?   ?                  ?      ?   ?                     4XNB_02.PCX              ?      	   ?      	            ?                     4XNB_02.PCX              ?      	                     ?                     4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX              ?                            ?                     4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX              ?                           ?                     4XNB_01.PCX           ?   ?      @                  ?   ?                     4XNB_01.PCX           ?   ?            
      ?      ?   ?                     4XNB_02.PCX              ?      	   ?   	   	            ?                     4XNB_02.PCX              ?   	   	                     ?                     4XNB_02.PCX        
      ?         ?   
         
      ?                     4XNB_02.PCX        
      ?   
                  
      ?                     4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX              ?            
               ?                     4XNB_01.PCX           @         ?   ?               @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_01.PCX           @         ?   ?               @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_01.PCX        $   @      '   ?   ?   %         $   @                        4XNB_01.PCX        %         '   ?   ?   &      ?   %                           4XNB_02.PCX        '   	   ?   $      ?   #   	      '   	   ?                     4XNB_02.PCX        #   	      $      ?             #   	                        4XNB_02.PCX        %      ?   &      ?   !         %      ?                     4XNB_02.PCX        !         &      ?   "         !                           4XNB_02.PCX        $      ?   %      ?             $      ?                     4XNB_02.PCX                  %      ?   !                                     4XNB_02.PCX        &      ?   '      ?   "         &      ?                     4XNB_02.PCX        "         '      ?   #         "                           4XNB_01.PCX        (   @      1   ?   ?   /         (   @                        4XNB_01.PCX        /         1   ?   ?   )      ?   /                           4XNB_02.PCX        1   	   ?   .      ?   -   	      1   	   ?                     4XNB_02.PCX        -   	      .      ?   *         -   	                        4XNB_02.PCX        /      ?   0      ?   +         /      ?                     4XNB_02.PCX        +         0      ?   ,         +                           4XNB_02.PCX        .      ?   /      ?   *         .      ?                     4XNB_02.PCX        *         /      ?   +         *                           4XNB_02.PCX        0      ?   1      ?   ,         0      ?                     4XNB_02.PCX        ,         1      ?   -         ,                           4XNB_02.PCX        C   b      2           <          C   b                        4XNB_02.PCX        D         2   `       C         D                           4XNB_02.PCX        ;         2          D   \      ;                           4XNB_02.PCX        ?   ]   +   2         ;         ?   ]   +                     4XNB_02.PCX        @      ,   2   `      ?      +   @      ,                     4XNB_02.PCX        <         2          @   c   ,   <                           4XNB_02.PCX        :     ?   7      ?   8          :     ?                     4XNB_02.PCX        :     ?   8          9   z      :     ?                     4XNB_02.PCX        8   ?       7           3       ?   8   ?                         4XNB_02.PCX        8   ?       3       ?   4   ?   ?   8   ?                         4XNB_02.PCX        7          :         6     ?   7                            4XNB_02.PCX        7          6     ?   3      ?   7                            4XNB_02.PCX        9   z      8          4      ?   9   z                        4XNB_02.PCX        9   z      4      ?   5   z  ?   9   z                        RC02_02.PCX        E      z   C      6   <      6   E      z                     RC02_02.PCX        E      z   <      6   >      z   E      z                     RC02_02.PCX        A      z   ?      6   ;   5   6   A      z                     RC02_02.PCX        A      z   ;   5   6   =   5   z   A      z                     RC02_02.PCX        =   2   z   ;   2   6   D      6   =   2   z                     RC02_02.PCX        =   2   z   D      6   F      z   =   2   z                     RC02_02.PCX        >      z   <      6   @      6   >      z                     RC02_02.PCX        >      z   @      6   B      z   >      z                     RC02_02.PCX        B      z   @      6   ?       6   B      z                     RC02_02.PCX        B      z   ?       6   A       z   B      z                     RC02_02.PCX        F       z   D       6   C      6   F       z                     RC02_02.PCX        F       z   C      6   E      z   F       z                     4XNB_01.PCX        H          Z   5       X   D   D   H                            4XNB_01.PCX        H   H       X      D   G   9   C   H   H                         4XNB_01.PCX        [         Z   5   @   H      @   [                           4XNB_01.PCX        J          H   6       G   D   C   J                            4XNB_01.PCX        J   H       G      C   I   :   D   J   H                         4XNB_01.PCX        [         H   6   @   J      @   [                           4XNB_01.PCX        L          J   6       I   D   C   L                            4XNB_01.PCX        L   H       I      C   K   :   D   L   H                         4XNB_01.PCX        [         J   6   @   L      @   [                           4XNB_01.PCX        N          L   6       K   D   C   N                            4XNB_01.PCX        N   H       K      C   M   :   D   N   H                         4XNB_01.PCX        [         L   6   @   N      @   [                           4XNB_01.PCX        P          N   5       M   D   D   P                            4XNB_01.PCX        P   H       M      D   O   9   C   P   H                         4XNB_01.PCX        [         N   5   @   P      @   [                           4XNB_01.PCX        R          P   5      O   C   D   R                            4XNB_01.PCX        R   G       O      D   Q   9   C   R   G                         4XNB_01.PCX        [         P   5   A   R      @   [                           4XNB_01.PCX        T          R   5       Q   D   D   T                            4XNB_01.PCX        T   H       Q      D   S   9   C   T   H                         4XNB_01.PCX        [         R   5   @   T      @   [                           4XNB_01.PCX        V          T   6       S   D   C   V                            4XNB_01.PCX        V   H       S      C   U   :   D   V   H                         4XNB_01.PCX        [         T   6   @   V      @   [                           4XNB_01.PCX        Y          V   5       U   D   D   Y                            4XNB_01.PCX        Y   H       U      D   W   9   C   Y   H                         4XNB_01.PCX        [         V   5   @   Y      @   [                           4XNB_01.PCX        Z   	       Y   7       W   E   C   Z   	                         4XNB_01.PCX        Z   I       W      C   X   ;   C   Z   I                         4XNB_01.PCX        [          Y   7   @   Z   	   @   [                            4XNB_02.PCX        c     ?   `      ?   a          c     ?                     4XNB_02.PCX        c     ?   a          b   z      c     ?                     4XNB_02.PCX        a   ?       `           \       ?   a   ?                         4XNB_02.PCX        a   ?       \       ?   ]   ?   ?   a   ?                         4XNB_02.PCX        `          c         _     ?   `                            4XNB_02.PCX        `          _     ?   \      ?   `                            4XNB_02.PCX        b   z      a          ]      ?   b   z                        4XNB_02.PCX        b   z      ]      ?   ^   z  ?   b   z            @ANIMATE-XPLG2,0,-5                     d   |յ   e           f   q    g           d   |ɵ,յ      @ANIMATE-XPL5,0,-5                     h   |յ    i   q    j           k   |ɵ,յh   [   6         @ANIMATE-XPLG1,0,-1                     l   |յ    m           n   |ɵ,յo   Z      l   \   :       j
       DEFAULT.PAL    MAIN             y   5        c  p      6m    a    5    x6  c  p  x6  6mx6  ax6  = X  Dw Ds'   = '   4 *'     J'   Dw DsX  = X  4 *X    JX  avj  avj  xa!vj  a   xa!   
  Lvj  
  ,vj  
  L   
  ,   Zvj  ZLvj  Z   ZL    j     Hfj  (D6  0awj  alH   ej  76  kj  ػC  j  8  kj    `NNj  `Z  kj  [j  (    `  "     k Z    
  ,    ,  F    " x6  k Zx6  
  ,x6  ,  Fx6  s '   HV* '   
 '   p8 '   s X  HV* X  
 X  p8 X     vj  (     m     z     *:     ( x6  m x6  z x6  *: x6     vj    'P  vj          'P      J Ez vj  I j  vj   J Ez    I j     c  vj  z vj  c     z    	
  #G j  )B  4   QB  V j  d  d   9   j     v   	  
 j  @  Td   0 F j    4   /    j    v        j           |  j  ќ      A  8  j  	    j  d      B        !   L v  _  f* _  F=_  6 _    k  | Hk  U>  k   k  ? r F   %F  LBHF  o F                       4XNB_02.PCX             ?         ?                  ?                     4XNB_02.PCX             ?                z           ?                     4XNB_02.PCX           ?                          ?      ?                         4XNB_02.PCX           ?               ?      ?   ?      ?                         4XNB_02.PCX                                ?                               4XNB_02.PCX                       ?          ?                               4XNB_02.PCX           z                      ?      z                        4XNB_02.PCX           z            ?      z  ?      z                        4XNB_01.PCX        
   @         ?   ?            
   @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?   
      ?      	         	   ?                     4XNB_02.PCX           	      
      ?   	            	                        4XNB_02.PCX              ?         ?   
               ?                     4XNB_02.PCX        
               ?            
                           4XNB_02.PCX        
      ?         ?   	         
      ?                     4XNB_02.PCX        	               ?   
         	                           4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX           b                              b                        4XNB_02.PCX                    `                                           4XNB_02.PCX                              \                                 4XNB_02.PCX           ]   +                        ]   +                     4XNB_02.PCX              ,      `            +         ,                     4XNB_02.PCX                              c   ,                              RC02_02.PCX              z         6         6         z                     RC02_02.PCX              z         6         z         z                     RC02_02.PCX              z         6      5   6         z                     RC02_02.PCX              z      5   6      5   z         z                     RC02_02.PCX           2   z      2   6         6      2   z                     RC02_02.PCX           2   z         6         z      2   z                     RC02_02.PCX              z         6         6         z                     RC02_02.PCX              z         6         z         z                     RC02_02.PCX              z         6          6         z                     RC02_02.PCX              z          6          z         z                     RC02_02.PCX               z          6         6          z                     RC02_02.PCX               z         6         z          z                     4XNB_01.PCX                  1   5       /   D   D                               4XNB_01.PCX           H       /      D      9   C      H                         4XNB_01.PCX        2         1   5   @         @   2                           4XNB_01.PCX        !             6          D   C   !                            4XNB_01.PCX        !   H             C       :   D   !   H                         4XNB_01.PCX        2            6   @   !      @   2                           4XNB_01.PCX        #          !   6           D   C   #                            4XNB_01.PCX        #   H              C   "   :   D   #   H                         4XNB_01.PCX        2         !   6   @   #      @   2                           4XNB_01.PCX        %          #   6       "   D   C   %                            4XNB_01.PCX        %   H       "      C   $   :   D   %   H                         4XNB_01.PCX        2         #   6   @   %      @   2                           4XNB_01.PCX        '          %   5       $   D   D   '                            4XNB_01.PCX        '   H       $      D   &   9   C   '   H                         4XNB_01.PCX        2         %   5   @   '      @   2                           4XNB_01.PCX        )          '   5      &   C   D   )                            4XNB_01.PCX        )   G       &      D   (   9   C   )   G                         4XNB_01.PCX        2         '   5   A   )      @   2                           4XNB_01.PCX        +          )   5       (   D   D   +                            4XNB_01.PCX        +   H       (      D   *   9   C   +   H                         4XNB_01.PCX        2         )   5   @   +      @   2                           4XNB_01.PCX        -          +   6       *   D   C   -                            4XNB_01.PCX        -   H       *      C   ,   :   D   -   H                         4XNB_01.PCX        2         +   6   @   -      @   2                           4XNB_01.PCX        0          -   5       ,   D   D   0                            4XNB_01.PCX        0   H       ,      D   .   9   C   0   H                         4XNB_01.PCX        2         -   5   @   0      @   2                           4XNB_01.PCX        1   	       0   7       .   E   C   1   	                         4XNB_01.PCX        1   I       .      C   /   ;   C   1   I                         4XNB_01.PCX        2          0   7   @   1   	   @   2                            4XNB_02.PCX        :     ?   7      ?   8          :     ?                     4XNB_02.PCX        :     ?   8          9   z      :     ?                     4XNB_02.PCX        8   ?       7           3       ?   8   ?                         4XNB_02.PCX        8   ?       3       ?   4   ?   ?   8   ?                         4XNB_02.PCX        7          :         6     ?   7                            4XNB_02.PCX        7          6     ?   3      ?   7                            4XNB_02.PCX        9   z      8          4      ?   9   z                        4XNB_02.PCX        9   z      4      ?   5   z  ?   9   z                        4XNB_01.PCX        ?   @      B   ?   ?   @         ?   @                        4XNB_01.PCX        @         B   ?   ?   A      ?   @                           4XNB_02.PCX        B   	   ?   ?      ?   >   	      B   	   ?                     4XNB_02.PCX        >   	      ?      ?   ;         >   	                        4XNB_02.PCX        @      ?   A      ?   <         @      ?                     4XNB_02.PCX        <         A      ?   =         <                           4XNB_02.PCX        ?      ?   @      ?   ;         ?      ?                     4XNB_02.PCX        ;         @      ?   <         ;                           4XNB_02.PCX        A      ?   B      ?   =         A      ?                     4XNB_02.PCX        =         B      ?   >         =                           4XNB_02.PCX        T   b      C           M          T   b                        4XNB_02.PCX        U         C   `       T         U                           4XNB_02.PCX        L         C          U   \      L                           4XNB_02.PCX        P   ]   +   C         L         P   ]   +                     4XNB_02.PCX        Q      ,   C   `      P      +   Q      ,                     4XNB_02.PCX        M         C          Q   c   ,   M                           4XNB_02.PCX        K     ?   H      ?   I          K     ?                     4XNB_02.PCX        K     ?   I          J   z      K     ?                     4XNB_02.PCX        I   ?       H           D       ?   I   ?                         4XNB_02.PCX        I   ?       D       ?   E   ?   ?   I   ?                         4XNB_02.PCX        H          K         G     ?   H                            4XNB_02.PCX        H          G     ?   D      ?   H                            4XNB_02.PCX        J   z      I          E      ?   J   z                        4XNB_02.PCX        J   z      E      ?   F   z  ?   J   z                        RC02_02.PCX        V      z   T      6   M      6   V      z                     RC02_02.PCX        V      z   M      6   O      z   V      z                     RC02_02.PCX        R      z   P      6   L   5   6   R      z                     RC02_02.PCX        R      z   L   5   6   N   5   z   R      z                     RC02_02.PCX        N   2   z   L   2   6   U      6   N   2   z                     RC02_02.PCX        N   2   z   U      6   W      z   N   2   z                     RC02_02.PCX        O      z   M      6   Q      6   O      z                     RC02_02.PCX        O      z   Q      6   S      z   O      z                     RC02_02.PCX        S      z   Q      6   P       6   S      z                     RC02_02.PCX        S      z   P       6   R       z   S      z                     RC02_02.PCX        W       z   U       6   T      6   W       z                     RC02_02.PCX        W       z   T      6   V      z   W       z                     4XNB_01.PCX        Y          k   5       i   D   D   Y                            4XNB_01.PCX        Y   H       i      D   X   9   C   Y   H                         4XNB_01.PCX        l         k   5   @   Y      @   l                           4XNB_01.PCX        [          Y   6       X   D   C   [                            4XNB_01.PCX        [   H       X      C   Z   :   D   [   H                         4XNB_01.PCX        l         Y   6   @   [      @   l                           4XNB_01.PCX        ]          [   6       Z   D   C   ]                            4XNB_01.PCX        ]   H       Z      C   \   :   D   ]   H                         4XNB_01.PCX        l         [   6   @   ]      @   l                           4XNB_01.PCX        _          ]   6       \   D   C   _                            4XNB_01.PCX        _   H       \      C   ^   :   D   _   H                         4XNB_01.PCX        l         ]   6   @   _      @   l                           4XNB_01.PCX        a          _   5       ^   D   D   a                            4XNB_01.PCX        a   H       ^      D   `   9   C   a   H                         4XNB_01.PCX        l         _   5   @   a      @   l                           4XNB_01.PCX        c          a   5      `   C   D   c                            4XNB_01.PCX        c   G       `      D   b   9   C   c   G                         4XNB_01.PCX        l         a   5   A   c      @   l                           4XNB_01.PCX        e          c   5       b   D   D   e                            4XNB_01.PCX        e   H       b      D   d   9   C   e   H                         4XNB_01.PCX        l         c   5   @   e      @   l                           4XNB_01.PCX        g          e   6       d   D   C   g                            4XNB_01.PCX        g   H       d      C   f   :   D   g   H                         4XNB_01.PCX        l         e   6   @   g      @   l                           4XNB_01.PCX        j          g   5       f   D   D   j                            4XNB_01.PCX        j   H       f      D   h   9   C   j   H                         4XNB_01.PCX        l         g   5   @   j      @   l                           4XNB_01.PCX        k   	       j   7       h   E   C   k   	                         4XNB_01.PCX        k   I       h      C   i   ;   C   k   I                         4XNB_01.PCX        l          j   7   @   k   	   @   l                @ANIMATE-XPLG2,0,-5                     m   (`tٵn          o           p       P   m      |        @ANIMATE-XPLG1,0,-1                     q   (`    r       Яs           t   P   |յq     h         @ANIMATE-XPL5,0,-5                     u   (`    v       w           x   |յ(`u   i          j
       DEFAULT.PAL    MAIN             l   ?  ?  *  *  <:  (R  <:  R  0  R  0  (R  ?  \  ?  
G  *  
G  *  \  u:  V  R  u:  zL  R  H0  zL  R  H0  V  R  ޲޲w(R  wR  KR  K(R  \  
G  
G  \  V  R  zL  R  zL  R  V  R  ]7  _  q    0    X  K#       R    ]7  E        l  =  #  l     R  q  ]7  E  q  ]7  _    5N  m  q  5N  R  q  ]7  E  q     R  q     m  q  ]7  Bz  q  5N  m    5N  R    ]7  E       R       m    ]7  Bz    pn^  u)  P   >)       /          7   B                    w       \    0    &               B̒B5m      i  &  5m  &  ̒    %YY  >Y  HY  Y  j^  nj^  Ho^  o^  pY  n^  n^  pn^  Hn^  Hn^  p\n^  Y  Y  pY  HY  HY  p\Y  -o<  F  `,F  fXF  <F    ߄ F  /C F  iF  _8 F    k3 F  k3 F  SF  S  F                    
   B_POST.PCX           +                        ?      +                      
   B_POST.PCX           +              ?      7   ?      +                      
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?          ?                            
   B_POST.PCX           +                       ?      +                      
   B_POST.PCX           +             ?      7   ?      +                      
   B_POST.PCX           +                              +                      
   B_POST.PCX           +                    +          +                      
   B_POST.PCX        
   +                       ?   
   +                      
   B_POST.PCX        
   +             ?   	   7   ?   
   +                      
   B_POST.PCX                     +       
   7   ?                            
   B_POST.PCX                  
   7   ?         ?                            
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX           +       
          	      ?      +                      
   B_POST.PCX           +       	      ?   
   7   ?      +                      
   B_POST.PCX           +                 
             +                      
   B_POST.PCX           +       
             +          +                      
   B_POST.PCX           +                       ?      +                      
   B_POST.PCX           +             ?      7   ?      +                      
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX           +                       ?      +                      
   B_POST.PCX           +             ?      7   ?      +                      
   B_POST.PCX           +                              +                      
   B_POST.PCX           +                    +          +                      
   B_POST.PCX           +                       ?      +                      
   B_POST.PCX           +             ?      7   ?      +                      
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX           +                       ?      +                      
   B_POST.PCX           +             ?      7   ?      +                      
   B_POST.PCX           +                              +                      
   B_POST.PCX           +                    +          +                      
   T2_PAD.PCX        *   /   :               /   >       *   /   :                  
   T2_PAD.PCX        +      :               *   /   :   +      :                  
   T2_PAD.PCX        ,                      +      :   ,                         
   T2_PAD.PCX        -                     ,          -                        
   T2_PAD.PCX        .   /                  -         .   /                     
   T2_PAD.PCX        /   >                   .   /      /   >                         T2_RAMP.PCX        $         #   <      "   <   $   $                           T2_RAMP.PCX        $         "   <   $   !      $   $                           T2_RAMP.PCX        %      $   (         $         %      $                     T2_RAMP.PCX        %      $   $         !      $   %      $                     T2_RAMP.PCX        '   <      &   <   $   "   <   $   '   <                        T2_RAMP.PCX        '   <      "   <   $   #   <      '   <                        T2_RAMP.PCX        (         %      $   &   <   $   (                           T2_RAMP.PCX        (         &   <   $   '   <      (                        
   BUILD9.PCX        5         )         0      7   5                        
   BUILD9.PCX        0      7   )         1   .   7   0      7                  
   BUILD9.PCX        1   .   7   )         2   =      1   .   7                  
   BUILD9.PCX        2   =      )         3   .      2   =                     
   BUILD9.PCX        3   .      )         4         3   .                     
   BUILD9.PCX        4         )         5         4                        
   BUILD9.PCX        0      7   *      7   /         0      7                  
   BUILD9.PCX        0      7   /         5         0      7                  
   BUILD9.PCX        1   .   7   +   .   7   *      7   1   .   7                  
   BUILD9.PCX        1   .   7   *      7   0      7   1   .   7                  
   BUILD9.PCX        2   =      ,   =      +   .   7   2   =                     
   BUILD9.PCX        2   =      +   .   7   1   .   7   2   =                     
   BUILD9.PCX        4         .         -   .      4                        
   BUILD9.PCX        4         -   .      3   .      4                        
   BUILD9.PCX        5         /         .         5                        
   BUILD9.PCX        5         .         4         5                        
   T2_PAD.PCX        T   /   :   6           Y   >       T   /   :                  
   T2_PAD.PCX        U      :   6           T   /   :   U      :                  
   T2_PAD.PCX        V          6           U      :   V                         
   T2_PAD.PCX        W         6           V          W                        
   T2_PAD.PCX        X   /      6           W         X   /                     
   T2_PAD.PCX        Y   >       6           X   /      Y   >                      
   BUILD8.PCX        ;   $   (  B   6      A         ;   $   (                 
   BUILD8.PCX        ;   $   (  A         7      (  ;   $   (                 
   BUILD8.PCX        7   )   )  A   :      @         7   )   )                 
   BUILD8.PCX        7   )   )  @         8      )  7   )   )                 
   BUILD8.PCX        8   -   (  @   ?      ?         8   -   (                 
   BUILD8.PCX        8   -   (  ?         9      (  8   -   (                 
   BUILD8.PCX        9   $   (  ?   6      >         9   $   (                 
   BUILD8.PCX        9   $   (  >         :      (  9   $   (                 
   BUILD8.PCX        :   )   )  >   :      C         :   )   )                 
   BUILD8.PCX        :   )   )  C         <      )  :   )   )                 
   BUILD8.PCX        <   -   (  C   ?      B         <   -   (                 
   BUILD8.PCX        <   -   (  B         ;      (  <   -   (                 
   BUILD9.PCX        >         =   `   /   C         >                        
   BUILD9.PCX        ?      /   =      /   >   ^      ?      /                  
   BUILD9.PCX        @   ]   =   =         ?         @   ]   =                  
   BUILD9.PCX        A      <   =   `      @      =   A      <                  
   BUILD9.PCX        B         =          A   a   <   B                        
   BUILD9.PCX        C   b      =       /   B      .   C   b                        T2_FLOOR.PCX        E   `   w   D   A   A   J   ~   A   E   `   w                     T2_FLOOR.PCX        F   "   w   D   A   A   E   `   w   F   "   w                     T2_FLOOR.PCX        G      A   D   A   A   F   "   w   G      A                     T2_FLOOR.PCX        H   "      D   A   A   G      A   H   "                        T2_FLOOR.PCX        I   `      D   A   A   H   "      I   `                        T2_FLOOR.PCX        J   ~   A   D   A   A   I   `      J   ~   A                     T2_RAMP.PCX        N         M   <      L   <   $   N                           T2_RAMP.PCX        N         L   <   $   K      $   N                           T2_RAMP.PCX        O      $   R         N         O      $                     T2_RAMP.PCX        O      $   N         K      $   O      $                     T2_RAMP.PCX        Q   <      P   <   $   L   <   $   Q   <                        T2_RAMP.PCX        Q   <      L   <   $   M   <      Q   <                        T2_RAMP.PCX        R         O      $   P   <   $   R                           T2_RAMP.PCX        R         P   <   $   Q   <      R                        
   BUILD9.PCX        _         S         Z      7   _                        
   BUILD9.PCX        Z      7   S         [   .   7   Z      7                  
   BUILD9.PCX        [   .   7   S         \   =      [   .   7                  
   BUILD9.PCX        \   =      S         ]   .      \   =                     
   BUILD9.PCX        ]   .      S         ^         ]   .                     
   BUILD9.PCX        ^         S         _         ^                        
   BUILD9.PCX        Z      7   T      7   Y         Z      7                  
   BUILD9.PCX        Z      7   Y         _         Z      7                  
   BUILD9.PCX        [   .   7   U   .   7   T      7   [   .   7                  
   BUILD9.PCX        [   .   7   T      7   Z      7   [   .   7                  
   BUILD9.PCX        \   =      V   =      U   .   7   \   =                     
   BUILD9.PCX        \   =      U   .   7   [   .   7   \   =                     
   BUILD9.PCX        ^         X         W   .      ^                        
   BUILD9.PCX        ^         W   .      ]   .      ^                        
   BUILD9.PCX        _         Y         X         _                        
   BUILD9.PCX        _         X         ^         _               @ANIMATE-XPL5,0,-1                     `   |յP   a      
  b   {      c   {   P˵`      ˵      @ANIMATE-XPLG2,0,-5                     d   |յ|ɵe    
  b   f      c   g   ˵`   d   ˵         @ANIMATE-XPLG1,0,-1                     h   |յ(`i   e   `   j   f   Q   k   d   m   h      |ɵ    j
       DEFAULT.PAL    MAIN             L   (,  gQ  ",  Q  +  
?  Q  Q  UQ  ɦ8  Q  æx>  Q        }      z    n    UN.      B  %M  B	  
  %M  =B  %M  ő  %M  @      U        U  V   @V      %M  R  %M  ͝%M  >%M  3  #,  !B  +  :  !B    GF    ,  +  %  7  	,    7    m   H!B  Ȧ:  !B  E  s,  $  7    7    ,  UQ    0    d  .    +  9  Q  +  :  !B  ,  %  7  ,    7  #,  H!B  VQ  0    U.    ٦9  Q  Ȧ:  !B  %  7  ܦ  7  7!B  	    G    'C  G  O  G  μB  G  C  G  Q  G  G  BG  k  A  GK  A  L^A  ϓY  A    :3 A  ' ?A  {A  o  A  g  M A  U A  *A  _  A  X                     BUILD10.PCX        %   8   =        =      C     %   8   =                     BUILD10.PCX        %   8   =      C     $   |      %   8   =                     BUILD10.PCX        '   <                 G  >   '   <                        BUILD10.PCX        '   |           >   &   8   >   '   |                        BUILD10.PCX               =         =         H          =                     BUILD10.PCX              H         =   <      W         H                     BUILD10.PCX        <      W         =         d   <      W                     BUILD10.PCX              d   +      =         =         d                     BUILD10.PCX              d         =         H         d                     BUILD10.PCX              $            9               $                     BUILD10.PCX        !   8   $        $      C     !   8   $                     BUILD10.PCX        !   8   $      C         |      !   8   $                     BUILD10.PCX        >   -      <           G  $   >   -                        BUILD10.PCX        >   m           $   !   8   $   >   m                        BUILD10.PCX           8   =         =      R  H      8   =                     BUILD10.PCX           8   =      R  H      m   H      8   =                     BUILD10.PCX           8   =        =         =      8   =                     BUILD10.PCX           8   =         =      8   =      8   =                     BUILD10.PCX        1   1   4        4      G     1   1   4                     BUILD10.PCX        1   q   4              8      1   q   4                     BUILD10.PCX           8      +        *   N  4      8                        BUILD10.PCX           8      *   N  4      q   4      8                        BUILD10.PCX           8   =        =   +     =      8   =                     BUILD10.PCX           8   =   +     =      8   =      8   =                     BUILD10.PCX           0   H        H      G  =      0   H                     BUILD10.PCX           p   H        =      8   =      p   H                     BUILD10.PCX        "   8   $        $   9   O     "   8   $                     BUILD10.PCX        "   8   $   9   O     ;   p      "   8   $                     BUILD10.PCX        #   <                 G  $   #   <                        BUILD10.PCX        #   |           $   "   8   $   #   |                        BUILD10.PCX           8   =      8   =      m   H      8   =                     BUILD10.PCX           8   =      m   H   >   m   W      8   =                     BUILD10.PCX           8   =   >   m   W   !   8   d      8   =                     BUILD10.PCX           8   =   "   8   d      8   =      8   =                     BUILD10.PCX           8   =   "   8   d      p   H      8   =                     BUILD10.PCX           p      "   8   $   ;   p         p                        BUILD11.PCX        1   N                   N      1   N                        BUILD11.PCX        	   6                1   N      	   6                        BUILD11.PCX        
                    	   6      
                            BUILD11.PCX           1      *   1         `         1                        BUILD11.PCX           1         `      
   `         1                     
   T3_PAD.PCX        9                  8   7   	   9                        
   T3_PAD.PCX        8   7   	            
   :   
   8   7   	                  
   T3_PAD.PCX           :   5   
   :   
               :   5                  
   T3_PAD.PCX           :   5                  >      :   5                  
   T3_PAD.PCX        :   7   6   8   7   	   
   :   
   :   7   6                  
   T3_PAD.PCX        :   7   6   
   :   
      :   5   :   7   6                  
   T3_PAD.PCX              >   ;      >   :   7   6         >                  
   T3_PAD.PCX              >   :   7   6      :   5         >                     T3_FLOOR.PCX              w                            w                     T3_FLOOR.PCX              w                    w         w                  
   T3_PAD.PCX                 <         =   7                              
   T3_PAD.PCX                 =   7         :                              
   T3_PAD.PCX           :   8      :      =   7         :   8                  
   T3_PAD.PCX           :   8   =   7      ?   7   9      :   8                  
   T3_PAD.PCX              >               :            >                  
   T3_PAD.PCX              >      :         :   8         >                  
   T3_PAD.PCX        >      >         >   ?   7   9   >      >                  
   T3_PAD.PCX        ?   7   9         >      :   8   ?   7   9                     BUILD10.PCX           F   =         $      ]         F   =                     BUILD10.PCX           ]            $               ]                        BUILD10.PCX           :   $      }   >      b         :   $                     BUILD10.PCX           :   $      b                  :   $                     BUILD10.PCX        %      =      =   >         =   %      =                     BUILD10.PCX        &   =   >      =   >   %      =   &   =   >                     BUILD10.PCX        "      $   %   F   =   $   ]      "      $                     BUILD10.PCX        "      $   $   ]      #         "      $                     BUILD10.PCX        &   }   >   !   :   $   '   b      &   }   >                     BUILD10.PCX        '   b      !   :   $             '   b                        BUILD10.PCX        /   K   d   (   G   =   .      ~   /   K   d                     BUILD10.PCX        .      ~   (      =   -   <   ~   .      ~                     BUILD10.PCX        -   |   ~   (     =   ,   <   d   -   |   ~                     BUILD10.PCX        ,   <   d   (     =   +   @   =   ,   <   d                     BUILD10.PCX        +          (         *       5   +                            BUILD10.PCX        *       5   (         )      5   *       5                     BUILD10.PCX        0   G   =   7   K   d   6      ~   0   G   =                     BUILD10.PCX        0      =   6      ~   5   <   ~   0      =                     BUILD10.PCX        0     =   5   |   ~   4   <   d   0     =                     BUILD10.PCX        0     =   4   <   d   3   @   =   0     =                     BUILD10.PCX        0         3          2       5   0                           BUILD10.PCX        0         2       5   1      5   0                           BUILD11.PCX        ;   A      9   A   =   8   {   5   ;   A                        BUILD11.PCX        ;   A      8   {   5   :   {   
   ;   A                        BUILD11.PCX        ?         =      8   <   >   >   ?                           BUILD11.PCX        ?         <   >   >   >   >      ?               @ANIMATE-XPL5,0,-5                     @   Ĳ$   A     $   B      $   C     $   @                @ANIMATE-XPLG2,0,-5                     D   Ĳ$   E      $   F   V   $   G          D   į          @ANIMATE-XPLG1,0,-1                     H   Ĳ$   I   V   $   J          K   L    H           j
       DEFAULT.PAL    MAIN             T   3O-  O-  -  3-  "-  -   
   
  OA   
  OA   
  xA  -  -  -  xA  -  ߫y߫]!]!yo  Qp    m  ف    o    m  (~  
  ~(~  
Qp    ~ف    7҆7.y  x  .y  x  ҆  s    ]t  ]tscF*    cF*  u  @.J  3@.J  3  .J  u    .J    F*  F*    
    u    .J  3  .J  3.J  u  .J  
  A  G  1`  G  b  A?  A?   b   1`  ZG  A  ZG  D  "  E]  "  b  A?  A?  0b  0E]    D    y  z  y  z  Z      T-  8#%  	v  %  =    T      ԕ    ӆ      or  .  Wy    g                  	   B_PAD.PCX            0   :      0         @          0   :                  	   B_PAD.PCX              :      0          0   :         :                  	   B_PAD.PCX           ?         p         O   :      ?                     	   B_PAD.PCX           O         p         ?         O                     
   B_RAMP.PCX                   >        >   
                          
   B_RAMP.PCX                   >   
   	      
                          
   B_RAMP.PCX        
                         
                        
   B_RAMP.PCX        
                 	      
   
                        
   B_RAMP.PCX           >     
   >         >   
      >                    
   B_RAMP.PCX           >        >   
      >        >                    
   B_RAMP.PCX                
         
   >                             
   B_RAMP.PCX                
   >         >                            	   B_PAD.PCX           -          -         .         -                     	   B_PAD.PCX           -         .         .         -                     	   B_PAD.PCX           ,         ,          -         ,                     	   B_PAD.PCX           ,          -         -         ,                     	   B_PAD.PCX           +         +         ,         +                     	   B_PAD.PCX           +         ,         ,         +                     	   B_PAD.PCX           ,         ,         +         ,                     	   B_PAD.PCX           ,         +         +         ,                     	   B_PAD.PCX           -         -         ,         -                     	   B_PAD.PCX           -         ,         ,         -                     	   B_PAD.PCX           .         .         -         .                     	   B_PAD.PCX           .         -         -         .                        BUILD_7.PCX           U   $      
   $        $      U   $                     BUILD_7.PCX             $      
   $      2  $        $                     BUILD_7.PCX             $        $         $        $                     BUILD_7.PCX           U   $      2  $      
   $      U   $                     BUILD_7.PCX                     $         $                             BUILD_7.PCX                   U   $      1                                BUILD_7.PCX           1         U   $        $      1                        BUILD_7.PCX           1           $              1                        BUILD_7.PCX            \        2  $      
   $       \                       BUILD_7.PCX                    M   $   !   #                                 BUILD_7.PCX        "   #         M   $      r  $   "   #                        BUILD_7.PCX        "   #         r  $   #        "   #                     
   BUILD5.PCX        $         %   *      &   7      $                        
   BUILD5.PCX        $         &   7      '         $                        
   BUILD5.PCX        (         )   7      *   *      (                        
   BUILD5.PCX        (         *   *      +         (                        
   BUILD5.PCX        ,        -        .   7      ,                       
   BUILD5.PCX        ,        .   7      /         ,                       
   BUILD5.PCX        0         1   7      2        0                        
   BUILD5.PCX        0         2        3        0                        
   BUILD6.PCX        '         &         1         '                        
   BUILD6.PCX        '         1         0         '                        
   BUILD6.PCX        +   ;      *   ;      %         +   ;                     
   BUILD6.PCX        +   ;      %         $         +   ;                     
   BUILD6.PCX        /         .         )   E      /                        
   BUILD6.PCX        /         )   E      (   E      /                        
   BUILD5.PCX        )   *      .   
      *   J      )   *                     
   BUILD5.PCX        *         .   J      -        *                        
   BUILD5.PCX        *         -         %         *                        
   BUILD5.PCX        %         -         2   +     %                        
   BUILD5.PCX        %   @      2        &   `      %   @                     
   BUILD5.PCX        &   `      2        1         &   `                     
   BUILD5.PCX        /   
      (   *      +   J      /   
                     
   BUILD5.PCX        /   J      +         ,        /   J                     
   BUILD5.PCX        ,         +         $         ,                        
   BUILD5.PCX        ,         $         3   +     ,                        
   BUILD5.PCX        3        $   @      '   `      3                       
   BUILD5.PCX        3        '   `      0         3                       
   BUILD5.PCX        4     M   5   =   M   6   1      4     M                  
   BUILD5.PCX        4     M   6   1      7        4     M                  
   BUILD5.PCX        8        9   1      :   =   M   8                       
   BUILD5.PCX        8        :   =   M   ;     M   8                       
   BUILD5.PCX        <         =   O      >   1      <                        
   BUILD5.PCX        <         >   1      ?        <                        
   BUILD5.PCX        @        A   1      B   O      @                       
   BUILD5.PCX        @         B         C         @                        
   BUILD6.PCX        ;   /   >   :   /      5         ;   /   >                  
   BUILD6.PCX        ;   /   >   5         4      >   ;   /   >                  
   BUILD6.PCX        C   6   9   B   6      =         C   6   9                  
   BUILD6.PCX        C   6   9   =         <      9   C   6   9                  
   BUILD5.PCX        9         >         :   P   M   9                        
   BUILD5.PCX        :   P      >         =         :   P                     
   BUILD5.PCX        :         =         5   /      :                        
   BUILD5.PCX        5   o      =   $     B         5   o                     
   BUILD5.PCX        5   o      B         6   4      5   o                     
   BUILD5.PCX        6   t      B   \      A   :      6   t                     
   BUILD5.PCX        ?         8         ;   P   M   ?                        
   BUILD5.PCX        ?         ;   P      <         ?                        
   BUILD5.PCX        <         ;         4   /      <                        
   BUILD5.PCX        <   $     4   o      C         <   $                    
   BUILD5.PCX        C         4   o      7   4      C                        
   BUILD5.PCX        C   \      7   t      @   :      C   \                        BUILD_7.PCX             $        $         $        $                     BUILD_7.PCX           V   $      0  $         $      V   $                     BUILD_7.PCX           V   $         $        $      V   $                     BUILD_7.PCX             $         $      0  $        $                     BUILD_7.PCX           2         V   $        $      2                        BUILD_7.PCX           2           $      
        2                        BUILD_7.PCX                     $         $                             BUILD_7.PCX           
        V   $      2         
                       BUILD_7.PCX        !   %         O   $      p  $   !   %                        BUILD_7.PCX        !   %         p  $   "        !   %                        BUILD_7.PCX        #   Z        0  $         $   #   Z                       BUILD_7.PCX        #           O   $       %      #                          B_FLOOR.PCX        D   y     E   y   y   F     y   D   y                       B_FLOOR.PCX        D   y     F     y   G       D   y           @ANIMATE-XPL5,0,-5                     H   t   I   5   A   J      @   K         H   lີ      @ANIMATE-XPLG1,0,-1                     L       M   5       N   D   D   O          L                @ANIMATE-XPLG2,0,-5                     P   D   Q   9   C   R   H       S          P   ̸        j
       DEFAULT.PAL    MAIN             H   V  ~   r  ~   f  ~   V  ~   V  !  h  !  n  !  V  !  V  8  ~   r  8  ~   f     ~   V     ~   V  8  !  h  r8  !  n     !  V     !  V  ,J      ,J      .   V  .   V  ,J  9   ,J  9   .9  V  .9  Қ  ~   X  ~   X  ~   @  ~   Қ  !  X  !  X  !  @  !  r            X            r  o<    o<  X  o<    o<  0e~   *F~   3R~   2e~   0e!  8P!  3H!  2e!      `"e    \sd    s    o<  `"eo<  \sdo<  so<  $j   $X     J  X     J  j   $j9  $X  9  J  X  9  J  j9       ;G  Mu  B+       Z;  2 "Z;  |Z;  J  Z;  B                  	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8           *  ?      *                     	   NP_03.PCX            *  ?      8          :   ?       *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                  	   NP_01.PCX                    ?      
                                 	   NP_01.PCX        
            ?         ?      
                        	   NP_03.PCX           *      
   8          *  ?      *                     	   NP_03.PCX           *  ?   
   8       	   :   ?      *  ?                  	   NP_03.PCX           ,                 
   .   ?      ,                      	   NP_03.PCX        
   .   ?                   ?   
   .   ?                     RC01_02.PCX                                  >                                RC01_02.PCX           @             >      ?   <      @                         RC01_01.PCX           /                       ?      /                         RC01_01.PCX           /             ?      /   ?      /                         RC01_01.PCX           Z          
          
   ?      Z                         RC01_01.PCX           Z          
   ?      Z   ?      Z                         RC01_01.PCX                                    ?                               RC01_01.PCX                         ?         ?                               RC01_01.PCX           =                       ?      =                         RC01_01.PCX           =             ?      =   ?      =                      	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8          *  ?      *                     	   NP_03.PCX           *  ?      8          :   ?      *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                     RC01_02.PCX        $   @   @   '       ?   %   @      $   @   @                     RC01_02.PCX        %   @      '       ?   &          %   @                        RC01_01.PCX        '   (   !   $   }   !   #   (   @   '   (   !                     RC01_01.PCX        #   (   @   $   }   !       }   @   #   (   @                     RC01_01.PCX        %   }   !   &   '   !   !   }   @   %   }   !                     RC01_01.PCX        !   }   @   &   '   !   "   '   @   !   }   @                     RC01_01.PCX        $   ?   !   %       !       ?   @   $   ?   !                     RC01_01.PCX            ?   @   %       !   !       @       ?   @                     RC01_01.PCX        &       !   '   @   !   "       @   &       !                     RC01_01.PCX        "       @   '   @   !   #   @   @   "       @                  	   NP_01.PCX        /   ?      ,         -         /   ?                     	   NP_01.PCX        /   ?      -         .   ?      /   ?                     	   NP_03.PCX        -   8       ,   *      (   *  ?   -   8                      	   NP_03.PCX        -   8       (   *  ?   )   :   ?   -   8                      	   NP_03.PCX        /          .   ,       *   .   ?   /                         	   NP_03.PCX        /          *   .   ?   +      ?   /                            RC01_02.PCX        7       ?   4   @   @   5   @      7       ?                     RC01_02.PCX        7       ?   5   @      6          7       ?                     RC01_01.PCX        4   }   !   7   (   !   3   (   @   4   }   !                     RC01_01.PCX        4   }   !   3   (   @   0   }   @   4   }   !                     RC01_01.PCX        6   '   !   5   }   !   1   }   @   6   '   !                     RC01_01.PCX        6   '   !   1   }   @   2   '   @   6   '   !                     RC01_01.PCX        5       !   4   ?   !   0   ?   @   5       !                     RC01_01.PCX        5       !   0   ?   @   1       @   5       !                     RC01_01.PCX        7   @   !   6       !   2       @   7   @   !                     RC01_01.PCX        7   @   !   2       @   3   @   @   7   @   !                     RC01_02.PCX        ?           <         =      >   ?                             RC01_02.PCX        ?   @       =      >   >   ?   <   ?   @                         RC01_01.PCX        =   /       <          8      ?   =   /                         RC01_01.PCX        =   /       8      ?   9   /   ?   =   /                         RC01_01.PCX        ?   Z       >   
       :   
   ?   ?   Z                         RC01_01.PCX        ?   Z       :   
   ?   ;   Z   ?   ?   Z                         RC01_01.PCX        <          ?           ;       ?   <                            RC01_01.PCX        <          ;       ?   8      ?   <                            RC01_01.PCX        >   =       =          9      ?   >   =                         RC01_01.PCX        >   =       9      ?   :   =   ?   >   =             @ANIMATE-XPLG1,0,-1                     @   4    A   j       B   4      C   U      @                @ANIMATE-XPL9,0,-2                     D   4   E        F   U      G          D   ة        j
       DEFAULT.PAL    MAIN             @     B    (        d      .  @d        BJ(  (  J(    d  J(  .  @d  J(  6  8  T    E  8  T   E     T   P     T   6  8    E  r8    E       P       8Қ  T   ^X  T   8X  T     T   8Қ    nX    :X        <r            /  X      8/        <r  J(    J(  /  X  J(  8/    J(  K0eT   KFT   cRT   fceT   K0e  KP  cH  fce  8    9"e    
d        8J(  9"eJ(  
dJ(  J(  (j\   (X  \   D  X  \   D  j\   (j&\  (X  &\  D  X  &\  D  j&\  U   $  w '$  O$  l"+ $    x   -< J7  /  I    <                     RC01_02.PCX               ?      @   @      @             ?                     RC01_02.PCX               ?      @                       ?                     RC01_01.PCX           }   !      (   !      (   @      }   !                     RC01_01.PCX           }   !      (   @       }   @      }   !                     RC01_01.PCX           '   !      }   !      }   @      '   !                     RC01_01.PCX           '   !      }   @      '   @      '   !                     RC01_01.PCX               !      ?   !       ?   @          !                     RC01_01.PCX               !       ?   @          @          !                     RC01_01.PCX           @   !          !          @      @   !                     RC01_01.PCX           @   !          @      @   @      @   !                  	   NP_01.PCX                    ?      
                                 	   NP_01.PCX        
            ?         ?      
                        	   NP_03.PCX           *      
   8          *  ?      *                     	   NP_03.PCX           *  ?   
   8       	   :   ?      *  ?                  	   NP_03.PCX           ,                 
   .   ?      ,                      	   NP_03.PCX        
   .   ?                   ?   
   .   ?                  	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8          *  ?      *                     	   NP_03.PCX           *  ?      8          :   ?      *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                     RC01_02.PCX           @   @          ?      @         @   @                     RC01_02.PCX           @             ?                @                        RC01_01.PCX           (   !      }   !      (   @      (   !                     RC01_01.PCX           (   @      }   !      }   @      (   @                     RC01_01.PCX           }   !      '   !      }   @      }   !                     RC01_01.PCX           }   @      '   !      '   @      }   @                     RC01_01.PCX           ?   !          !      ?   @      ?   !                     RC01_01.PCX           ?   @          !          @      ?   @                     RC01_01.PCX               !      @   !          @          !                     RC01_01.PCX               @      @   !      @   @          @                  	   NP_01.PCX        '   ?      $         %         '   ?                     	   NP_01.PCX        '   ?      %         &   ?      '   ?                     	   NP_03.PCX        %   8       $   *          *  ?   %   8                      	   NP_03.PCX        %   8           *  ?   !   :   ?   %   8                      	   NP_03.PCX        '          &   ,       "   .   ?   '                         	   NP_03.PCX        '          "   .   ?   #      ?   '                            RC01_02.PCX        /       ?   ,   @   @   -   @      /       ?                     RC01_02.PCX        /       ?   -   @      .          /       ?                     RC01_01.PCX        ,   }   !   /   (   !   +   (   @   ,   }   !                     RC01_01.PCX        ,   }   !   +   (   @   (   }   @   ,   }   !                     RC01_01.PCX        .   '   !   -   }   !   )   }   @   .   '   !                     RC01_01.PCX        .   '   !   )   }   @   *   '   @   .   '   !                     RC01_01.PCX        -       !   ,   ?   !   (   ?   @   -       !                     RC01_01.PCX        -       !   (   ?   @   )       @   -       !                     RC01_01.PCX        /   @   !   .       !   *       @   /   @   !                     RC01_01.PCX        /   @   !   *       @   +   @   @   /   @   !                     RC01_02.PCX        7           4         5      >   7                             RC01_02.PCX        7   @       5      >   6   ?   <   7   @                         RC01_01.PCX        5   /       4          0      ?   5   /                         RC01_01.PCX        5   /       0      ?   1   /   ?   5   /                         RC01_01.PCX        7   Z       6   
       2   
   ?   7   Z                         RC01_01.PCX        7   Z       2   
   ?   3   Z   ?   7   Z                         RC01_01.PCX        4          7           3       ?   4                            RC01_01.PCX        4          3       ?   0      ?   4                            RC01_01.PCX        6   =       5          1      ?   6   =                         RC01_01.PCX        6   =       1      ?   2   =   ?   6   =             @ANIMATE-XPLG2,0,-2                     8   4   9           :   t{    ;           8   T      @ANIMATE-XPLG1,0,-1                     <   4    =   t{    >           ?   T<   #          j
       DEFAULT.PAL    MAIN             H   RɄ  i    -2  i   R!2  i     i   RɄ  -  !2  -  M+2  -    -  Y@  Ʉ  i   '@  -2  i   Y"  !2  i   "    i   Y@  Ʉ  -  @  !2  -  V"  +2  -  "    -  >V    s   >V  tb s   wb s     s   >V    0s  >V  tb 0s  wb 0s    0s      i     2  i   ¡  2  i   f  ӄ  i       -    
2  -  š  2  -  f  ӄ  -  V  :      
W  Ƅ        Z      Z        V  :  ]2  
W  Ƅ  ]2    Z  ]2  Z    ]2    i     CTi   <  RTi   X<  i     -    OT-  <  ET-  X<  -    "    j      '               "]2  j  ]2  '   ]2    ]2  ©pTs   ©1  s    1  s    pTs   ©pT0s  ©1  0s   1  0s   pT0s   l   ]{ I  :       <   & :b   <  Y    B                  	   NP_01.PCX           ?                           ?                     	   NP_01.PCX           ?                  ?         ?                     	   NP_03.PCX           8          *          *  ?      8                      	   NP_03.PCX           8           *  ?      :   ?      8                      	   NP_03.PCX                     ,          .   ?                            	   NP_03.PCX                     .   ?         ?                            	   NP_01.PCX           ?               
            ?                     	   NP_01.PCX           ?      
            ?         ?                     	   NP_03.PCX        
   8          *         *  ?   
   8                      	   NP_03.PCX        
   8          *  ?   	   :   ?   
   8                      	   NP_03.PCX                     ,       
   .   ?                            	   NP_03.PCX                  
   .   ?         ?                               RC01_02.PCX                                  >                              RC01_02.PCX              >      @          ?   <         >                     RC01_01.PCX                     /             ?                               RC01_01.PCX              ?      /          /   ?         ?                     RC01_01.PCX           
          Z          
   ?      
                         RC01_01.PCX           
   ?      Z          Z   ?      
   ?                     RC01_01.PCX                                    ?                                RC01_01.PCX               ?                   ?          ?                     RC01_01.PCX                     =             ?                               RC01_01.PCX              ?      =          =   ?         ?                  	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8          *  ?      *                     	   NP_03.PCX           *  ?      8          :   ?      *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                     RC01_02.PCX        $   @   @   '       ?   %   @      $   @   @                     RC01_02.PCX        %   @      '       ?   &          %   @                        RC01_01.PCX        '   (   !   $   }   !   #   (   @   '   (   !                     RC01_01.PCX        #   (   @   $   }   !       }   @   #   (   @                     RC01_01.PCX        %   }   !   &   '   !   !   }   @   %   }   !                     RC01_01.PCX        !   }   @   &   '   !   "   '   @   !   }   @                     RC01_01.PCX        $   ?   !   %       !       ?   @   $   ?   !                     RC01_01.PCX            ?   @   %       !   !       @       ?   @                     RC01_01.PCX        &       !   '   @   !   "       @   &       !                     RC01_01.PCX        "       @   '   @   !   #   @   @   "       @                  	   NP_01.PCX        /   ?      ,         -         /   ?                     	   NP_01.PCX        /   ?      -         .   ?      /   ?                     	   NP_03.PCX        -   8       ,   *      (   *  ?   -   8                      	   NP_03.PCX        -   8       (   *  ?   )   :   ?   -   8                      	   NP_03.PCX        /          .   ,       *   .   ?   /                         	   NP_03.PCX        /          *   .   ?   +      ?   /                            RC01_02.PCX        7       ?   4   @   @   5   @      7       ?                     RC01_02.PCX        7       ?   5   @      6          7       ?                     RC01_01.PCX        4   }   !   7   (   !   3   (   @   4   }   !                     RC01_01.PCX        4   }   !   3   (   @   0   }   @   4   }   !                     RC01_01.PCX        6   '   !   5   }   !   1   }   @   6   '   !                     RC01_01.PCX        6   '   !   1   }   @   2   '   @   6   '   !                     RC01_01.PCX        5       !   4   ?   !   0   ?   @   5       !                     RC01_01.PCX        5       !   0   ?   @   1       @   5       !                     RC01_01.PCX        7   @   !   6       !   2       @   7   @   !                     RC01_01.PCX        7   @   !   2       @   3   @   @   7   @   !                     RC01_02.PCX        ?           <         =      >   ?                             RC01_02.PCX        ?   @       =      >   >   ?   <   ?   @                         RC01_01.PCX        =   /       <          8      ?   =   /                         RC01_01.PCX        =   /       8      ?   9   /   ?   =   /                         RC01_01.PCX        ?   Z       >   
       :   
   ?   ?   Z                         RC01_01.PCX        ?   Z       :   
   ?   ;   Z   ?   ?   Z                         RC01_01.PCX        <          ?           ;       ?   <                            RC01_01.PCX        <          ;       ?   8      ?   <                            RC01_01.PCX        >   =       =          9      ?   >   =                         RC01_01.PCX        >   =       9      ?   :   =   ?   >   =             @ANIMATE-XPL5,0,-5                     @   4   A           B   ,s    C           @   T      @ANIMATE-XPLG2,0,-1                     D   4    E   ,s    F           G   TD   2   A       j
       DEFAULT.PAL    MAIN             `   D    i   D  Gm  i   &  Vm  i   ;'    i   D    -  D  Tm  -  &  Jm  -  ;'    -  \  &    )\        m          \  &]2  )\    ]2  m  ]2  ]2  T  i     i     i   3E  i   T  -    -    -  3E  -  T2 i   2 i    i   3N i   T2 -  2 -   -  3N -  )H s   H s   s   )s   )H 0s  H 0s  0s  )0s  bi   bTi   ci   Xi   b-  ba-  Y-  X-  i   Ti   ci   Qi   -  a-  Y-  Q-  s   
s   @  
s   @  s   0s  
0s  @  
0s  @  0s      i     Gm  i     Vm  i       i       -  *  Tm  -    Jm  -      -  ,  &            W4       3     ,  &]2      ]2  W4   ]2  3 ]2  *tm  s   *J s   ZJ J s   ZJ tm  s   *tm  0s  *J 0s  ZJ J 0s  ZJ tm  0s  'a       AG)2  tܠ        X  *2  phV   X                  	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8           *  ?      *                     	   NP_03.PCX            *  ?      8          :   ?       *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                     RC01_02.PCX           @   @          ?   
   @         @   @                     RC01_02.PCX        
   @             ?             
   @                        RC01_01.PCX           (   !      }   !      (   @      (   !                     RC01_01.PCX           (   @      }   !      }   @      (   @                     RC01_01.PCX        
   }   !      '   !   	   }   @   
   }   !                     RC01_01.PCX        	   }   @      '   !   
   '   @   	   }   @                     RC01_01.PCX           ?   !   
       !      ?   @      ?   !                     RC01_01.PCX           ?   @   
       !   	       @      ?   @                     RC01_01.PCX               !      @   !   
       @          !                     RC01_01.PCX        
       @      @   !      @   @   
       @                  	   NP_01.PCX           ?                           ?                     	   NP_01.PCX           ?                  ?         ?                     	   NP_03.PCX           8          *         *  ?      8                      	   NP_03.PCX           8          *  ?      :   ?      8                      	   NP_03.PCX                     ,          .   ?                            	   NP_03.PCX                     .   ?         ?                            	   NP_01.PCX           ?                           ?                     	   NP_01.PCX           ?                  ?         ?                     	   NP_03.PCX           8          *         *  ?      8                      	   NP_03.PCX           8          *  ?      :   ?      8                      	   NP_03.PCX                     ,          .   ?                            	   NP_03.PCX                     .   ?         ?                               RC01_02.PCX        $         '           %      >   $                           RC01_02.PCX        %      >   '   @       &   ?   <   %      >                     RC01_01.PCX        $          %   /              ?   $                            RC01_01.PCX               ?   %   /       !   /   ?          ?                     RC01_01.PCX        &   
       '   Z       "   
   ?   &   
                         RC01_01.PCX        "   
   ?   '   Z       #   Z   ?   "   
   ?                     RC01_01.PCX        '           $          #       ?   '                             RC01_01.PCX        #       ?   $                 ?   #       ?                     RC01_01.PCX        %          &   =       !      ?   %                            RC01_01.PCX        !      ?   &   =       "   =   ?   !      ?                  	   NP_01.PCX        /   ?      ,         -         /   ?                     	   NP_01.PCX        /   ?      -         .   ?      /   ?                     	   NP_03.PCX        -   8       ,   *      (   *  ?   -   8                      	   NP_03.PCX        -   8       (   *  ?   )   :   ?   -   8                      	   NP_03.PCX        /          .   ,       *   .   ?   /                         	   NP_03.PCX        /          *   .   ?   +      ?   /                         	   NP_01.PCX        7   ?      4         5         7   ?                     	   NP_01.PCX        7   ?      5         6   ?      7   ?                     	   NP_03.PCX        5   8       4   *      0   *  ?   5   8                      	   NP_03.PCX        5   8       0   *  ?   1   :   ?   5   8                      	   NP_03.PCX        7          6   ,       2   .   ?   7                         	   NP_03.PCX        7          2   .   ?   3      ?   7                            RC01_02.PCX        <         ?           =      >   <                           RC01_02.PCX        =      >   ?   @       >   ?   <   =      >                     RC01_01.PCX        <          =   /       8      ?   <                            RC01_01.PCX        8      ?   =   /       9   /   ?   8      ?                     RC01_01.PCX        >   
       ?   Z       :   
   ?   >   
                         RC01_01.PCX        :   
   ?   ?   Z       ;   Z   ?   :   
   ?                     RC01_01.PCX        ?           <          ;       ?   ?                             RC01_01.PCX        ;       ?   <          8      ?   ;       ?                     RC01_01.PCX        =          >   =       9      ?   =                            RC01_01.PCX        9      ?   >   =       :   =   ?   9      ?                  	   NP_01.PCX        G   ?      D         E         G   ?                     	   NP_01.PCX        G   ?      E         F   ?      G   ?                     	   NP_03.PCX        E   8       D   *      @   *  ?   E   8                      	   NP_03.PCX        E   8       @   *  ?   A   :   ?   E   8                      	   NP_03.PCX        G          F   ,       B   .   ?   G                         	   NP_03.PCX        G          B   .   ?   C      ?   G                            RC01_02.PCX        O       ?   L   @   @   M   @      O       ?                     RC01_02.PCX        O       ?   M   @      N          O       ?                     RC01_01.PCX        L   }   !   O   (   !   K   (   @   L   }   !                     RC01_01.PCX        L   }   !   K   (   @   H   }   @   L   }   !                     RC01_01.PCX        N   '   !   M   }   !   I   }   @   N   '   !                     RC01_01.PCX        N   '   !   I   }   @   J   '   @   N   '   !                     RC01_01.PCX        M       !   L   ?   !   H   ?   @   M       !                     RC01_01.PCX        M       !   H   ?   @   I       @   M       !                     RC01_01.PCX        O   @   !   N       !   J       @   O   @   !                     RC01_01.PCX        O   @   !   J       @   K   @   @   O   @   !                     RC01_02.PCX        W           T         U      >   W                             RC01_02.PCX        W   @       U      >   V   ?   <   W   @                         RC01_01.PCX        U   /       T          P      ?   U   /                         RC01_01.PCX        U   /       P      ?   Q   /   ?   U   /                         RC01_01.PCX        W   Z       V   
       R   
   ?   W   Z                         RC01_01.PCX        W   Z       R   
   ?   S   Z   ?   W   Z                         RC01_01.PCX        T          W           S       ?   T                            RC01_01.PCX        T          S       ?   P      ?   T                            RC01_01.PCX        V   =       U          Q      ?   V   =                         RC01_01.PCX        V   =       Q      ?   R   =   ?   V   =             @ANIMATE-XPL5,0,-5                     X   t   Y           Z   (    [           X   Ĳ      @ANIMATE-XPLG1,0,-1                     \   t    ]   (    ^           _   l\   =          j
       DEFAULT.PAL    MAIN             o   c    _0     
     6=     c B  _0  B  
  B  6=  B        9      B  B  9B  B  
 ƋB  
 Ƌ   *           ȶ   
 ƋB  * B    B    ȶB     S      $  L   =P   B  S   B  $  LB  =PB  F  O  A      -      ƩRx      EX      A  (  -  (  ƩRx  (  EX  (  2>    g&<          b      2>(  g&<(    (  b  (    =N    O                =N(  O(  (    (    O  O          U  'x  O  U    O  U  'x     U         O  ǩQx  O       ǩQx     ^  O  kU  ƙ  &0  O  vFm  ƙ    O  Zv  ƙ  -  
  O    /m  ƙ  I  Y^  O  ,  EU  ƙ  H  .  O  ,  7  ƙ  ,    O  ~    ƙ  ZKO  f  ƙ  !  O  .  O  V  ƙ  7  ƙ  zF     k        P    U        V  4      k  (    P(  U    (  V  4  (  G       p    n   Z8y      [  S  )[  A;[  
x  [  "  %  4 
%  :%  ZXV %  {                     4XNB_01.PCX           @         ?   ?               @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?                	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                   ?                     4XNB_02.PCX                        ?                                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_01.PCX           @         ?   ?   
            @                        4XNB_01.PCX        
            ?   ?         ?   
                           4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX        
      ?         ?   	         
      ?                     4XNB_02.PCX        	               ?   
         	                           4XNB_02.PCX              ?   
      ?                  ?                     4XNB_02.PCX                 
      ?   	                                    4XNB_02.PCX              ?         ?   
               ?                     4XNB_02.PCX        
               ?            
                           4XNB_01.PCX           @         ?   ?               @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_01.PCX           @          ?   ?               @                        4XNB_01.PCX                     ?   ?         ?                              4XNB_02.PCX            	   ?         ?      	          	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?          ?                  ?                     4XNB_02.PCX                        ?                                       4XNB_02.PCX        B   b      !           ;          B   b                        4XNB_02.PCX        C         !   `       B         C                           4XNB_02.PCX        :         !          C   \      :                           4XNB_02.PCX        >   ]   +   !         :         >   ]   +                     4XNB_02.PCX        ?      ,   !   `      >      +   ?      ,                     4XNB_02.PCX        ;         !          ?   c   ,   ;                           4XNB_02.PCX        )     ?   &      ?   '          )     ?                     4XNB_02.PCX        )     ?   '          (   z      )     ?                     4XNB_02.PCX        '   ?       &           "       ?   '   ?                         4XNB_02.PCX        '   ?       "       ?   #   ?   ?   '   ?                         4XNB_02.PCX        &          )         %     ?   &                            4XNB_02.PCX        &          %     ?   "      ?   &                            4XNB_02.PCX        (   z      '          #      ?   (   z                        4XNB_02.PCX        (   z      #      ?   $   z  ?   (   z                        4XNB_02.PCX        1     ?   .      ?   /          1     ?                     4XNB_02.PCX        1     ?   /          0   z      1     ?                     4XNB_02.PCX        /   ?       .           *       ?   /   ?                         4XNB_02.PCX        /   ?       *       ?   +   ?   ?   /   ?                         4XNB_02.PCX        .          1         -     ?   .                            4XNB_02.PCX        .          -     ?   *      ?   .                            4XNB_02.PCX        0   z      /          +      ?   0   z                        4XNB_02.PCX        0   z      +      ?   ,   z  ?   0   z                        4XNB_02.PCX        9     ?   6      ?   7          9     ?                     4XNB_02.PCX        9     ?   7          8   z      9     ?                     4XNB_02.PCX        7   ?       6           2       ?   7   ?                         4XNB_02.PCX        7   ?       2       ?   3   ?   ?   7   ?                         4XNB_02.PCX        6          9         5     ?   6                            4XNB_02.PCX        6          5     ?   2      ?   6                            4XNB_02.PCX        8   z      7          3      ?   8   z                        4XNB_02.PCX        8   z      3      ?   4   z  ?   8   z                        RC02_02.PCX        D      z   B      6   ;      6   D      z                     RC02_02.PCX        D      z   ;      6   =      z   D      z                     RC02_02.PCX        @      z   >      6   :   5   6   @      z                     RC02_02.PCX        @      z   :   5   6   <   5   z   @      z                     RC02_02.PCX        <   2   z   :   2   6   C      6   <   2   z                     RC02_02.PCX        <   2   z   C      6   E      z   <   2   z                     RC02_02.PCX        =      z   ;      6   ?      6   =      z                     RC02_02.PCX        =      z   ?      6   A      z   =      z                     RC02_02.PCX        A      z   ?      6   >       6   A      z                     RC02_02.PCX        A      z   >       6   @       z   A      z                     RC02_02.PCX        E       z   C       6   B      6   E       z                     RC02_02.PCX        E       z   B      6   D      z   E       z                     4XNB_01.PCX        G          Y   5       W   D   D   G                            4XNB_01.PCX        G   H       W      D   F   9   C   G   H                         4XNB_01.PCX        Z         Y   5   @   G      @   Z                           4XNB_01.PCX        I          G   6       F   D   C   I                            4XNB_01.PCX        I   H       F      C   H   :   D   I   H                         4XNB_01.PCX        Z         G   6   @   I      @   Z                           4XNB_01.PCX        K          I   6       H   D   C   K                            4XNB_01.PCX        K   H       H      C   J   :   D   K   H                         4XNB_01.PCX        Z         I   6   @   K      @   Z                           4XNB_01.PCX        M          K   6       J   D   C   M                            4XNB_01.PCX        M   H       J      C   L   :   D   M   H                         4XNB_01.PCX        Z         K   6   @   M      @   Z                           4XNB_01.PCX        O          M   5       L   D   D   O                            4XNB_01.PCX        O   H       L      D   N   9   C   O   H                         4XNB_01.PCX        Z         M   5   @   O      @   Z                           4XNB_01.PCX        Q          O   5      N   C   D   Q                            4XNB_01.PCX        Q   G       N      D   P   9   C   Q   G                         4XNB_01.PCX        Z         O   5   A   Q      @   Z                           4XNB_01.PCX        S          Q   5       P   D   D   S                            4XNB_01.PCX        S   H       P      D   R   9   C   S   H                         4XNB_01.PCX        Z         Q   5   @   S      @   Z                           4XNB_01.PCX        U          S   6       R   D   C   U                            4XNB_01.PCX        U   H       R      C   T   :   D   U   H                         4XNB_01.PCX        Z         S   6   @   U      @   Z                           4XNB_01.PCX        X          U   5       T   D   D   X                            4XNB_01.PCX        X   H       T      D   V   9   C   X   H                         4XNB_01.PCX        Z         U   5   @   X      @   Z                           4XNB_01.PCX        Y   	       X   7       V   E   C   Y   	                         4XNB_01.PCX        Y   I       V      C   W   ;   C   Y   I                         4XNB_01.PCX        Z          X   7   @   Y   	   @   Z                            4XNB_02.PCX        b     ?   _      ?   `          b     ?                     4XNB_02.PCX        b     ?   `          a   z      b     ?                     4XNB_02.PCX        `   ?       _           [       ?   `   ?                         4XNB_02.PCX        `   ?       [       ?   \   ?   ?   `   ?                         4XNB_02.PCX        _          b         ^     ?   _                            4XNB_02.PCX        _          ^     ?   [      ?   _                            4XNB_02.PCX        a   z      `          \      ?   a   z                        4XNB_02.PCX        a   z      \      ?   ]   z  ?   a   z            @ANIMATE-XPLG1,0,-1                     c   |յ   d         e           f           c                 @ANIMATE-XPL5,0,-5                     g   |յ|ɵh         i           j           g                 @ANIMATE-XPLG2,0,-5                     k   |յ(`l   |յ   m           n   @ɵ    k               j
       DEFAULT.PAL    MAIN             y   5        c  p      6m    a    5    x6  c  p  x6  6mx6  ax6  = X  Dw Ds'   = '   4 *'     J'   Dw DsX  = X  4 *X    JX  avj  avj  xa!vj  a   xa!   
  Lvj  
  ,vj  
  L   
  ,   Zvj  ZLvj  Z   ZL    j     Hfj  (D6  0awj  alH   ej  76  kj  ػC  j  8  kj    `NNj  `Z  kj  [j  (    `  "     k Z    
  ,    ,  F    " x6  k Zx6  
  ,x6  ,  Fx6  s '   HV* '   
 '   p8 '   s X  HV* X  
 X  p8 X     vj  (     m     z     *:     ( x6  m x6  z x6  *: x6     vj    'P  vj          'P      J Ez vj  I j  vj   J Ez    I j     c  vj  z vj  c     z    	
  #G j  )B  4   QB  V j  d  d   9   j     v   	  
 j  @  Td   0 F j    4   /    j    v        j           |  j  ќ      A  8  j  	    j  d      B        !   L v  _  f* _  F=_  6 _    k  | Hk  U>  k   k  ? r F   %F  LBHF  o F                       4XNB_02.PCX             ?         ?                  ?                     4XNB_02.PCX             ?                z           ?                     4XNB_02.PCX           ?                          ?      ?                         4XNB_02.PCX           ?               ?      ?   ?      ?                         4XNB_02.PCX                                ?                               4XNB_02.PCX                       ?          ?                               4XNB_02.PCX           z                      ?      z                        4XNB_02.PCX           z            ?      z  ?      z                        4XNB_01.PCX        
   @         ?   ?            
   @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?   
      ?      	         	   ?                     4XNB_02.PCX           	      
      ?   	            	                        4XNB_02.PCX              ?         ?   
               ?                     4XNB_02.PCX        
               ?            
                           4XNB_02.PCX        
      ?         ?   	         
      ?                     4XNB_02.PCX        	               ?   
         	                           4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX           b                              b                        4XNB_02.PCX                    `                                           4XNB_02.PCX                              \                                 4XNB_02.PCX           ]   +                        ]   +                     4XNB_02.PCX              ,      `            +         ,                     4XNB_02.PCX                              c   ,                              RC02_02.PCX              z         6         6         z                     RC02_02.PCX              z         6         z         z                     RC02_02.PCX              z         6      5   6         z                     RC02_02.PCX              z      5   6      5   z         z                     RC02_02.PCX           2   z      2   6         6      2   z                     RC02_02.PCX           2   z         6         z      2   z                     RC02_02.PCX              z         6         6         z                     RC02_02.PCX              z         6         z         z                     RC02_02.PCX              z         6          6         z                     RC02_02.PCX              z          6          z         z                     RC02_02.PCX               z          6         6          z                     RC02_02.PCX               z         6         z          z                     4XNB_01.PCX                  1   5       /   D   D                               4XNB_01.PCX           H       /      D      9   C      H                         4XNB_01.PCX        2         1   5   @         @   2                           4XNB_01.PCX        !             6          D   C   !                            4XNB_01.PCX        !   H             C       :   D   !   H                         4XNB_01.PCX        2            6   @   !      @   2                           4XNB_01.PCX        #          !   6           D   C   #                            4XNB_01.PCX        #   H              C   "   :   D   #   H                         4XNB_01.PCX        2         !   6   @   #      @   2                           4XNB_01.PCX        %          #   6       "   D   C   %                            4XNB_01.PCX        %   H       "      C   $   :   D   %   H                         4XNB_01.PCX        2         #   6   @   %      @   2                           4XNB_01.PCX        '          %   5       $   D   D   '                            4XNB_01.PCX        '   H       $      D   &   9   C   '   H                         4XNB_01.PCX        2         %   5   @   '      @   2                           4XNB_01.PCX        )          '   5      &   C   D   )                            4XNB_01.PCX        )   G       &      D   (   9   C   )   G                         4XNB_01.PCX        2         '   5   A   )      @   2                           4XNB_01.PCX        +          )   5       (   D   D   +                            4XNB_01.PCX        +   H       (      D   *   9   C   +   H                         4XNB_01.PCX        2         )   5   @   +      @   2                           4XNB_01.PCX        -          +   6       *   D   C   -                            4XNB_01.PCX        -   H       *      C   ,   :   D   -   H                         4XNB_01.PCX        2         +   6   @   -      @   2                           4XNB_01.PCX        0          -   5       ,   D   D   0                            4XNB_01.PCX        0   H       ,      D   .   9   C   0   H                         4XNB_01.PCX        2         -   5   @   0      @   2                           4XNB_01.PCX        1   	       0   7       .   E   C   1   	                         4XNB_01.PCX        1   I       .      C   /   ;   C   1   I                         4XNB_01.PCX        2          0   7   @   1   	   @   2                            4XNB_02.PCX        :     ?   7      ?   8          :     ?                     4XNB_02.PCX        :     ?   8          9   z      :     ?                     4XNB_02.PCX        8   ?       7           3       ?   8   ?                         4XNB_02.PCX        8   ?       3       ?   4   ?   ?   8   ?                         4XNB_02.PCX        7          :         6     ?   7                            4XNB_02.PCX        7          6     ?   3      ?   7                            4XNB_02.PCX        9   z      8          4      ?   9   z                        4XNB_02.PCX        9   z      4      ?   5   z  ?   9   z                        4XNB_01.PCX        ?   @      B   ?   ?   @         ?   @                        4XNB_01.PCX        @         B   ?   ?   A      ?   @                           4XNB_02.PCX        B   	   ?   ?      ?   >   	      B   	   ?                     4XNB_02.PCX        >   	      ?      ?   ;         >   	                        4XNB_02.PCX        @      ?   A      ?   <         @      ?                     4XNB_02.PCX        <         A      ?   =         <                           4XNB_02.PCX        ?      ?   @      ?   ;         ?      ?                     4XNB_02.PCX        ;         @      ?   <         ;                           4XNB_02.PCX        A      ?   B      ?   =         A      ?                     4XNB_02.PCX        =         B      ?   >         =                           4XNB_02.PCX        T   b      C           M          T   b                        4XNB_02.PCX        U         C   `       T         U                           4XNB_02.PCX        L         C          U   \      L                           4XNB_02.PCX        P   ]   +   C         L         P   ]   +                     4XNB_02.PCX        Q      ,   C   `      P      +   Q      ,                     4XNB_02.PCX        M         C          Q   c   ,   M                           4XNB_02.PCX        K     ?   H      ?   I          K     ?                     4XNB_02.PCX        K     ?   I          J   z      K     ?                     4XNB_02.PCX        I   ?       H           D       ?   I   ?                         4XNB_02.PCX        I   ?       D       ?   E   ?   ?   I   ?                         4XNB_02.PCX        H          K         G     ?   H                            4XNB_02.PCX        H          G     ?   D      ?   H                            4XNB_02.PCX        J   z      I          E      ?   J   z                        4XNB_02.PCX        J   z      E      ?   F   z  ?   J   z                        RC02_02.PCX        V      z   T      6   M      6   V      z                     RC02_02.PCX        V      z   M      6   O      z   V      z                     RC02_02.PCX        R      z   P      6   L   5   6   R      z                     RC02_02.PCX        R      z   L   5   6   N   5   z   R      z                     RC02_02.PCX        N   2   z   L   2   6   U      6   N   2   z                     RC02_02.PCX        N   2   z   U      6   W      z   N   2   z                     RC02_02.PCX        O      z   M      6   Q      6   O      z                     RC02_02.PCX        O      z   Q      6   S      z   O      z                     RC02_02.PCX        S      z   Q      6   P       6   S      z                     RC02_02.PCX        S      z   P       6   R       z   S      z                     RC02_02.PCX        W       z   U       6   T      6   W       z                     RC02_02.PCX        W       z   T      6   V      z   W       z                     4XNB_01.PCX        Y          k   5       i   D   D   Y                            4XNB_01.PCX        Y   H       i      D   X   9   C   Y   H                         4XNB_01.PCX        l         k   5   @   Y      @   l                           4XNB_01.PCX        [          Y   6       X   D   C   [                            4XNB_01.PCX        [   H       X      C   Z   :   D   [   H                         4XNB_01.PCX        l         Y   6   @   [      @   l                           4XNB_01.PCX        ]          [   6       Z   D   C   ]                            4XNB_01.PCX        ]   H       Z      C   \   :   D   ]   H                         4XNB_01.PCX        l         [   6   @   ]      @   l                           4XNB_01.PCX        _          ]   6       \   D   C   _                            4XNB_01.PCX        _   H       \      C   ^   :   D   _   H                         4XNB_01.PCX        l         ]   6   @   _      @   l                           4XNB_01.PCX        a          _   5       ^   D   D   a                            4XNB_01.PCX        a   H       ^      D   `   9   C   a   H                         4XNB_01.PCX        l         _   5   @   a      @   l                           4XNB_01.PCX        c          a   5      `   C   D   c                            4XNB_01.PCX        c   G       `      D   b   9   C   c   G                         4XNB_01.PCX        l         a   5   A   c      @   l                           4XNB_01.PCX        e          c   5       b   D   D   e                            4XNB_01.PCX        e   H       b      D   d   9   C   e   H                         4XNB_01.PCX        l         c   5   @   e      @   l                           4XNB_01.PCX        g          e   6       d   D   C   g                            4XNB_01.PCX        g   H       d      C   f   :   D   g   H                         4XNB_01.PCX        l         e   6   @   g      @   l                           4XNB_01.PCX        j          g   5       f   D   D   j                            4XNB_01.PCX        j   H       f      D   h   9   C   j   H                         4XNB_01.PCX        l         g   5   @   j      @   l                           4XNB_01.PCX        k   	       j   7       h   E   C   k   	                         4XNB_01.PCX        k   I       h      C   i   ;   C   k   I                         4XNB_01.PCX        l          j   7   @   k   	   @   l                @ANIMATE-XPLG2,0,-5                     m   (`tٵn          o           p       P   m      |        @ANIMATE-XPLG1,0,-1                     q   (`    r       Яs           t   P   |յq     h         @ANIMATE-XPL5,0,-5                     u   (`    v       w           x   |յ(`u   i          j
       DEFAULT.PAL    MAIN             p   
C  >       [     
C  >  .;    [  .;  7       Cj       7    .;  Cj    .;  uZ     =     uZ  .;  =  .;  #          #  .;    .;  
C  ]     2   
C  ].;    2.;  7  Ca   Cj  n~   7  Ca.;  Cj  n~.;        .;  .;  #e   sb   #e.;  sb.;  κ     _     u_     6     Ϻ  .;  _  .;  u_  .;  6  .;  
 1E.;    .;  
 1E   * u          4p   
 1E.;  * u.;    .;    4p.;  F  Ak      -'      Ʃ1            Ak  P$  -'  P$  Ʃ1  P$    P$  ^c  F  F  ^c        U  1  F  U  %F  U  1     U  %   OF  ǩ1  F  O   ǩ1       G      &>  G  v&    KM  G  /    -  u>  G    &    I    G  ,      H   G  ,  +  ,  fG  ~  P  ZG  f<  G  =G  Vg  P  z   ơ  k  ^      }    U  %    V  2    k  ^P$    }P$  U  %P$  V  2P$  }    M  s  ^3M  ;;=M   M  ~e v  5  [ 5  5  ٟS  5    G Y  qE *BY  ?<Y  ū  Y  w                     4XNB_01.PCX           ?   ?      @                  ?   ?                     4XNB_01.PCX           ?   ?                  ?      ?   ?                     4XNB_02.PCX              ?      	   ?      	            ?                     4XNB_02.PCX              ?      	                     ?                     4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX              ?                            ?                     4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX              ?                           ?                     4XNB_01.PCX           ?   ?      @                  ?   ?                     4XNB_01.PCX           ?   ?            
      ?      ?   ?                     4XNB_02.PCX              ?      	   ?   	   	            ?                     4XNB_02.PCX              ?   	   	                     ?                     4XNB_02.PCX        
      ?         ?   
         
      ?                     4XNB_02.PCX        
      ?   
                  
      ?                     4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX              ?            
               ?                     4XNB_01.PCX           @         ?   ?               @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_01.PCX           @         ?   ?               @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_01.PCX        $   @      '   ?   ?   %         $   @                        4XNB_01.PCX        %         '   ?   ?   &      ?   %                           4XNB_02.PCX        '   	   ?   $      ?   #   	      '   	   ?                     4XNB_02.PCX        #   	      $      ?             #   	                        4XNB_02.PCX        %      ?   &      ?   !         %      ?                     4XNB_02.PCX        !         &      ?   "         !                           4XNB_02.PCX        $      ?   %      ?             $      ?                     4XNB_02.PCX                  %      ?   !                                     4XNB_02.PCX        &      ?   '      ?   "         &      ?                     4XNB_02.PCX        "         '      ?   #         "                           4XNB_01.PCX        (   @      1   ?   ?   /         (   @                        4XNB_01.PCX        /         1   ?   ?   )      ?   /                           4XNB_02.PCX        1   	   ?   .      ?   -   	      1   	   ?                     4XNB_02.PCX        -   	      .      ?   *         -   	                        4XNB_02.PCX        /      ?   0      ?   +         /      ?                     4XNB_02.PCX        +         0      ?   ,         +                           4XNB_02.PCX        .      ?   /      ?   *         .      ?                     4XNB_02.PCX        *         /      ?   +         *                           4XNB_02.PCX        0      ?   1      ?   ,         0      ?                     4XNB_02.PCX        ,         1      ?   -         ,                           4XNB_02.PCX        C   b      2           <          C   b                        4XNB_02.PCX        D         2   `       C         D                           4XNB_02.PCX        ;         2          D   \      ;                           4XNB_02.PCX        ?   ]   +   2         ;         ?   ]   +                     4XNB_02.PCX        @      ,   2   `      ?      +   @      ,                     4XNB_02.PCX        <         2          @   c   ,   <                           4XNB_02.PCX        :     ?   7      ?   8          :     ?                     4XNB_02.PCX        :     ?   8          9   z      :     ?                     4XNB_02.PCX        8   ?       7           3       ?   8   ?                         4XNB_02.PCX        8   ?       3       ?   4   ?   ?   8   ?                         4XNB_02.PCX        7          :         6     ?   7                            4XNB_02.PCX        7          6     ?   3      ?   7                            4XNB_02.PCX        9   z      8          4      ?   9   z                        4XNB_02.PCX        9   z      4      ?   5   z  ?   9   z                        RC02_02.PCX        E      z   C      6   <      6   E      z                     RC02_02.PCX        E      z   <      6   >      z   E      z                     RC02_02.PCX        A      z   ?      6   ;   5   6   A      z                     RC02_02.PCX        A      z   ;   5   6   =   5   z   A      z                     RC02_02.PCX        =   2   z   ;   2   6   D      6   =   2   z                     RC02_02.PCX        =   2   z   D      6   F      z   =   2   z                     RC02_02.PCX        >      z   <      6   @      6   >      z                     RC02_02.PCX        >      z   @      6   B      z   >      z                     RC02_02.PCX        B      z   @      6   ?       6   B      z                     RC02_02.PCX        B      z   ?       6   A       z   B      z                     RC02_02.PCX        F       z   D       6   C      6   F       z                     RC02_02.PCX        F       z   C      6   E      z   F       z                     4XNB_01.PCX        H          Z   5       X   D   D   H                            4XNB_01.PCX        H   H       X      D   G   9   C   H   H                         4XNB_01.PCX        [         Z   5   @   H      @   [                           4XNB_01.PCX        J          H   6       G   D   C   J                            4XNB_01.PCX        J   H       G      C   I   :   D   J   H                         4XNB_01.PCX        [         H   6   @   J      @   [                           4XNB_01.PCX        L          J   6       I   D   C   L                            4XNB_01.PCX        L   H       I      C   K   :   D   L   H                         4XNB_01.PCX        [         J   6   @   L      @   [                           4XNB_01.PCX        N          L   6       K   D   C   N                            4XNB_01.PCX        N   H       K      C   M   :   D   N   H                         4XNB_01.PCX        [         L   6   @   N      @   [                           4XNB_01.PCX        P          N   5       M   D   D   P                            4XNB_01.PCX        P   H       M      D   O   9   C   P   H                         4XNB_01.PCX        [         N   5   @   P      @   [                           4XNB_01.PCX        R          P   5      O   C   D   R                            4XNB_01.PCX        R   G       O      D   Q   9   C   R   G                         4XNB_01.PCX        [         P   5   A   R      @   [                           4XNB_01.PCX        T          R   5       Q   D   D   T                            4XNB_01.PCX        T   H       Q      D   S   9   C   T   H                         4XNB_01.PCX        [         R   5   @   T      @   [                           4XNB_01.PCX        V          T   6       S   D   C   V                            4XNB_01.PCX        V   H       S      C   U   :   D   V   H                         4XNB_01.PCX        [         T   6   @   V      @   [                           4XNB_01.PCX        Y          V   5       U   D   D   Y                            4XNB_01.PCX        Y   H       U      D   W   9   C   Y   H                         4XNB_01.PCX        [         V   5   @   Y      @   [                           4XNB_01.PCX        Z   	       Y   7       W   E   C   Z   	                         4XNB_01.PCX        Z   I       W      C   X   ;   C   Z   I                         4XNB_01.PCX        [          Y   7   @   Z   	   @   [                            4XNB_02.PCX        c     ?   `      ?   a          c     ?                     4XNB_02.PCX        c     ?   a          b   z      c     ?                     4XNB_02.PCX        a   ?       `           \       ?   a   ?                         4XNB_02.PCX        a   ?       \       ?   ]   ?   ?   a   ?                         4XNB_02.PCX        `          c         _     ?   `                            4XNB_02.PCX        `          _     ?   \      ?   `                            4XNB_02.PCX        b   z      a          ]      ?   b   z                        4XNB_02.PCX        b   z      ]      ?   ^   z  ?   b   z            @ANIMATE-XPLG2,0,-5                     d   |յ   e           f   q    g           d   |ɵ,յ      @ANIMATE-XPL5,0,-5                     h   |յ    i   q    j           k   |ɵ,յh   [   6         @ANIMATE-XPLG1,0,-1                     l   |յ    m           n   |ɵ,յo   Z      l   \   :       j
       DEFAULT.PAL    MAIN             X   .( lF  ^( 2  F  ' +F  ^( 2     ' +   | IF  L nF  | I   L n   {  F  |  F  {     |       'G    щ    ZG  n    '   G  '    G  _ X   G  ^   e $<G  E zN   G  }_   6' G  N'   f  <G  ^  <G  .      N  u' %lš    F  Z F   F  Z        !>  F  c0  F  !>     c0     +0  F  +  F  +0     +     *D  G  J|ű    r|O G  |    Z. G  A    *2 G  aM    1j  G  2z    
jd  G  1ov    1  G  !F    G  4    
|1  G  Dd  G  ҞF    2|v      š  {      {      c0      V}p      {  P$  {  P$  c0  P$  V}p  P$     &I  X  U&I  à&I  b" &I  O 3  &I   ,&I  u&I  Q  &I  ;X  m  # _m  ŧw;m  /c m  k                     4XNB_02.PCX        	   b                            	   b                        4XNB_02.PCX        
             `       	         
                           4XNB_02.PCX                            
   \                                 4XNB_02.PCX           ]   +                         ]   +                     4XNB_02.PCX              ,       `            +         ,                     4XNB_02.PCX                               c   ,                              RC02_02.PCX              z   	      6         6         z                     RC02_02.PCX              z         6         z         z                     RC02_02.PCX              z         6      5   6         z                     RC02_02.PCX              z      5   6      5   z         z                     RC02_02.PCX           2   z      2   6   
      6      2   z                     RC02_02.PCX           2   z   
      6         z      2   z                     RC02_02.PCX              z         6         6         z                     RC02_02.PCX              z         6         z         z                     RC02_02.PCX              z         6          6         z                     RC02_02.PCX              z          6          z         z                     RC02_02.PCX               z   
       6   	      6          z                     RC02_02.PCX               z   	      6         z          z                     4XNB_01.PCX                      5          D   D                               4XNB_01.PCX           H             D   
   9   C      H                         4XNB_01.PCX        !             5   @         @   !                           4XNB_01.PCX                     6       
   D   C                               4XNB_01.PCX           H       
      C      :   D      H                         4XNB_01.PCX        !            6   @         @   !                           4XNB_01.PCX                     6          D   C                               4XNB_01.PCX           H             C      :   D      H                         4XNB_01.PCX        !            6   @         @   !                           4XNB_01.PCX                     6          D   C                               4XNB_01.PCX           H             C      :   D      H                         4XNB_01.PCX        !            6   @         @   !                           4XNB_01.PCX                     5          D   D                               4XNB_01.PCX           H             D      9   C      H                         4XNB_01.PCX        !            5   @         @   !                           4XNB_01.PCX                     5         C   D                               4XNB_01.PCX           G             D      9   C      G                         4XNB_01.PCX        !            5   A         @   !                           4XNB_01.PCX                     5          D   D                               4XNB_01.PCX           H             D      9   C      H                         4XNB_01.PCX        !            5   @         @   !                           4XNB_01.PCX                     6          D   C                               4XNB_01.PCX           H             C      :   D      H                         4XNB_01.PCX        !            6   @         @   !                           4XNB_01.PCX                     5          D   D                               4XNB_01.PCX           H             D      9   C      H                         4XNB_01.PCX        !            5   @         @   !                           4XNB_01.PCX            	          7          E   C       	                         4XNB_01.PCX            I             C      ;   C       I                         4XNB_01.PCX        !             7   @       	   @   !                            4XNB_02.PCX        +   b      "           $          +   b                        4XNB_02.PCX        ,         "   `       +         ,                           4XNB_02.PCX        #         "          ,   \      #                           4XNB_02.PCX        '   ]   +   "         #         '   ]   +                     4XNB_02.PCX        (      ,   "   `      '      +   (      ,                     4XNB_02.PCX        $         "          (   c   ,   $                           RC02_02.PCX        -      z   +      6   $      6   -      z                     RC02_02.PCX        -      z   $      6   &      z   -      z                     RC02_02.PCX        )      z   '      6   #   5   6   )      z                     RC02_02.PCX        )      z   #   5   6   %   5   z   )      z                     RC02_02.PCX        %   2   z   #   2   6   ,      6   %   2   z                     RC02_02.PCX        %   2   z   ,      6   .      z   %   2   z                     RC02_02.PCX        &      z   $      6   (      6   &      z                     RC02_02.PCX        &      z   (      6   *      z   &      z                     RC02_02.PCX        *      z   (      6   '       6   *      z                     RC02_02.PCX        *      z   '       6   )       z   *      z                     RC02_02.PCX        .       z   ,       6   +      6   .       z                     RC02_02.PCX        .       z   +      6   -      z   .       z                     4XNB_01.PCX        0          B   5       @   D   D   0                            4XNB_01.PCX        0   H       @      D   /   9   C   0   H                         4XNB_01.PCX        C         B   5   @   0      @   C                           4XNB_01.PCX        2          0   6       /   D   C   2                            4XNB_01.PCX        2   H       /      C   1   :   D   2   H                         4XNB_01.PCX        C         0   6   @   2      @   C                           4XNB_01.PCX        4          2   6       1   D   C   4                            4XNB_01.PCX        4   H       1      C   3   :   D   4   H                         4XNB_01.PCX        C         2   6   @   4      @   C                           4XNB_01.PCX        6          4   6       3   D   C   6                            4XNB_01.PCX        6   H       3      C   5   :   D   6   H                         4XNB_01.PCX        C         4   6   @   6      @   C                           4XNB_01.PCX        8          6   5       5   D   D   8                            4XNB_01.PCX        8   H       5      D   7   9   C   8   H                         4XNB_01.PCX        C         6   5   @   8      @   C                           4XNB_01.PCX        :          8   5      7   C   D   :                            4XNB_01.PCX        :   G       7      D   9   9   C   :   G                         4XNB_01.PCX        C         8   5   A   :      @   C                           4XNB_01.PCX        <          :   5       9   D   D   <                            4XNB_01.PCX        <   H       9      D   ;   9   C   <   H                         4XNB_01.PCX        C         :   5   @   <      @   C                           4XNB_01.PCX        >          <   6       ;   D   C   >                            4XNB_01.PCX        >   H       ;      C   =   :   D   >   H                         4XNB_01.PCX        C         <   6   @   >      @   C                           4XNB_01.PCX        A          >   5       =   D   D   A                            4XNB_01.PCX        A   H       =      D   ?   9   C   A   H                         4XNB_01.PCX        C         >   5   @   A      @   C                           4XNB_01.PCX        B   	       A   7       ?   E   C   B   	                         4XNB_01.PCX        B   I       ?      C   @   ;   C   B   I                         4XNB_01.PCX        C          A   7   @   B   	   @   C                            4XNB_02.PCX        K     ?   H      ?   I          K     ?                     4XNB_02.PCX        K     ?   I          J   z      K     ?                     4XNB_02.PCX        I   ?       H           D       ?   I   ?                         4XNB_02.PCX        I   ?       D       ?   E   ?   ?   I   ?                         4XNB_02.PCX        H          K         G     ?   H                            4XNB_02.PCX        H          G     ?   D      ?   H                            4XNB_02.PCX        J   z      I          E      ?   J   z                        4XNB_02.PCX        J   z      E      ?   F   z  ?   J   z            @ANIMATE-XPLG2,0,-5                     L   µ   M           N   q    O           L   ŵ      @ANIMATE-XPLG1,0,-1                     P   Ƶ   Q           R   q    S           P   ŵ      @ANIMATE-XPL5,0,-5                     T   Ƶ    U   q    V           W   µŵT   V   5       j
       DEFAULT.PAL    MAIN             L   (,  gQ  ",  Q  +  
?  Q  Q  UQ  ɦ8  Q  æx>  Q        }      z    n    UN.      B  %M  B	  
  %M  =B  %M  ő  %M  @      U        U  V   @V      %M  R  %M  ͝%M  >%M  3  #,  !B  +  :  !B    GF    ,  +  %  7  	,    7    m   H!B  Ȧ:  !B  E  s,  $  7    7    ,  UQ    0    d  .    +  9  Q  +  :  !B  ,  %  7  ,    7  #,  H!B  VQ  0    U.    ٦9  Q  Ȧ:  !B  %  7  ܦ  7  7!B  	    G    'C  G  O  G  μB  G  C  G  Q  G  G  BG  k  A  GK  A  L^A  ϓY  A    :3 A  ' ?A  {A  o  A  g  M A  U A  *A  _  A  X                     BUILD10.PCX        %   8   =        =      C     %   8   =                     BUILD10.PCX        %   8   =      C     $   |      %   8   =                     BUILD10.PCX        '   <                 G  >   '   <                        BUILD10.PCX        '   |           >   &   8   >   '   |                        BUILD10.PCX               =         =         H          =                     BUILD10.PCX              H         =   <      W         H                     BUILD10.PCX        <      W         =         d   <      W                     BUILD10.PCX              d   +      =         =         d                     BUILD10.PCX              d         =         H         d                     BUILD10.PCX              $            9               $                     BUILD10.PCX        !   8   $        $      C     !   8   $                     BUILD10.PCX        !   8   $      C         |      !   8   $                     BUILD10.PCX        >   -      <           G  $   >   -                        BUILD10.PCX        >   m           $   !   8   $   >   m                        BUILD10.PCX           8   =         =      R  H      8   =                     BUILD10.PCX           8   =      R  H      m   H      8   =                     BUILD10.PCX           8   =        =         =      8   =                     BUILD10.PCX           8   =         =      8   =      8   =                     BUILD10.PCX        1   1   4        4      G     1   1   4                     BUILD10.PCX        1   q   4              8      1   q   4                     BUILD10.PCX           8      +        *   N  4      8                        BUILD10.PCX           8      *   N  4      q   4      8                        BUILD10.PCX           8   =        =   +     =      8   =                     BUILD10.PCX           8   =   +     =      8   =      8   =                     BUILD10.PCX           0   H        H      G  =      0   H                     BUILD10.PCX           p   H        =      8   =      p   H                     BUILD10.PCX        "   8   $        $   9   O     "   8   $                     BUILD10.PCX        "   8   $   9   O     ;   p      "   8   $                     BUILD10.PCX        #   <                 G  $   #   <                        BUILD10.PCX        #   |           $   "   8   $   #   |                        BUILD10.PCX           8   =      8   =      m   H      8   =                     BUILD10.PCX           8   =      m   H   >   m   W      8   =                     BUILD10.PCX           8   =   >   m   W   !   8   d      8   =                     BUILD10.PCX           8   =   "   8   d      8   =      8   =                     BUILD10.PCX           8   =   "   8   d      p   H      8   =                     BUILD10.PCX           p      "   8   $   ;   p         p                        BUILD11.PCX        1   N                   N      1   N                        BUILD11.PCX        	   6                1   N      	   6                        BUILD11.PCX        
                    	   6      
                            BUILD11.PCX           1      *   1         `         1                        BUILD11.PCX           1         `      
   `         1                     
   T3_PAD.PCX        9                  8   7   	   9                        
   T3_PAD.PCX        8   7   	            
   :   
   8   7   	                  
   T3_PAD.PCX           :   5   
   :   
               :   5                  
   T3_PAD.PCX           :   5                  >      :   5                  
   T3_PAD.PCX        :   7   6   8   7   	   
   :   
   :   7   6                  
   T3_PAD.PCX        :   7   6   
   :   
      :   5   :   7   6                  
   T3_PAD.PCX              >   ;      >   :   7   6         >                  
   T3_PAD.PCX              >   :   7   6      :   5         >                     T3_FLOOR.PCX              w                            w                     T3_FLOOR.PCX              w                    w         w                  
   T3_PAD.PCX                 <         =   7                              
   T3_PAD.PCX                 =   7         :                              
   T3_PAD.PCX           :   8      :      =   7         :   8                  
   T3_PAD.PCX           :   8   =   7      ?   7   9      :   8                  
   T3_PAD.PCX              >               :            >                  
   T3_PAD.PCX              >      :         :   8         >                  
   T3_PAD.PCX        >      >         >   ?   7   9   >      >                  
   T3_PAD.PCX        ?   7   9         >      :   8   ?   7   9                     BUILD10.PCX           F   =         $      ]         F   =                     BUILD10.PCX           ]            $               ]                        BUILD10.PCX           :   $      }   >      b         :   $                     BUILD10.PCX           :   $      b                  :   $                     BUILD10.PCX        %      =      =   >         =   %      =                     BUILD10.PCX        &   =   >      =   >   %      =   &   =   >                     BUILD10.PCX        "      $   %   F   =   $   ]      "      $                     BUILD10.PCX        "      $   $   ]      #         "      $                     BUILD10.PCX        &   }   >   !   :   $   '   b      &   }   >                     BUILD10.PCX        '   b      !   :   $             '   b                        BUILD10.PCX        /   K   d   (   G   =   .      ~   /   K   d                     BUILD10.PCX        .      ~   (      =   -   <   ~   .      ~                     BUILD10.PCX        -   |   ~   (     =   ,   <   d   -   |   ~                     BUILD10.PCX        ,   <   d   (     =   +   @   =   ,   <   d                     BUILD10.PCX        +          (         *       5   +                            BUILD10.PCX        *       5   (         )      5   *       5                     BUILD10.PCX        0   G   =   7   K   d   6      ~   0   G   =                     BUILD10.PCX        0      =   6      ~   5   <   ~   0      =                     BUILD10.PCX        0     =   5   |   ~   4   <   d   0     =                     BUILD10.PCX        0     =   4   <   d   3   @   =   0     =                     BUILD10.PCX        0         3          2       5   0                           BUILD10.PCX        0         2       5   1      5   0                           BUILD11.PCX        ;   A      9   A   =   8   {   5   ;   A                        BUILD11.PCX        ;   A      8   {   5   :   {   
   ;   A                        BUILD11.PCX        ?         =      8   <   >   >   ?                           BUILD11.PCX        ?         <   >   >   >   >      ?               @ANIMATE-XPL5,0,-5                     @   Ĳ$   A     $   B      $   C     $   @                @ANIMATE-XPLG2,0,-5                     D   Ĳ$   E      $   F   V   $   G          D   į          @ANIMATE-XPLG1,0,-1                     H   Ĳ$   I   V   $   J          K   L    H           j
       DEFAULT.PAL    MAIN             T   3O-  O-  -  3-  "-  -   
   
  OA   
  OA   
  xA  -  -  -  xA  -  ߫y߫]!]!yo  Qp    m  ف    o    m  (~  
  ~(~  
Qp    ~ف    7҆7.y  x  .y  x  ҆  s    ]t  ]tscF*    cF*  u  @.J  3@.J  3  .J  u    .J    F*  F*    
    u    .J  3  .J  3.J  u  .J  
  A  G  1`  G  b  A?  A?   b   1`  ZG  A  ZG  D  "  E]  "  b  A?  A?  0b  0E]    D    y  z  y  z  Z      T-  8#%  	v  %  =    T      ԕ    ӆ      or  .  Wy    g                  	   B_PAD.PCX            0   :      0         @          0   :                  	   B_PAD.PCX              :      0          0   :         :                  	   B_PAD.PCX           ?         p         O   :      ?                     	   B_PAD.PCX           O         p         ?         O                     
   B_RAMP.PCX                   >        >   
                          
   B_RAMP.PCX                   >   
   	      
                          
   B_RAMP.PCX        
                         
                        
   B_RAMP.PCX        
                 	      
   
                        
   B_RAMP.PCX           >     
   >         >   
      >                    
   B_RAMP.PCX           >        >   
      >        >                    
   B_RAMP.PCX                
         
   >                             
   B_RAMP.PCX                
   >         >                            	   B_PAD.PCX           -          -         .         -                     	   B_PAD.PCX           -         .         .         -                     	   B_PAD.PCX           ,         ,          -         ,                     	   B_PAD.PCX           ,          -         -         ,                     	   B_PAD.PCX           +         +         ,         +                     	   B_PAD.PCX           +         ,         ,         +                     	   B_PAD.PCX           ,         ,         +         ,                     	   B_PAD.PCX           ,         +         +         ,                     	   B_PAD.PCX           -         -         ,         -                     	   B_PAD.PCX           -         ,         ,         -                     	   B_PAD.PCX           .         .         -         .                     	   B_PAD.PCX           .         -         -         .                        BUILD_7.PCX           U   $      
   $        $      U   $                     BUILD_7.PCX             $      
   $      2  $        $                     BUILD_7.PCX             $        $         $        $                     BUILD_7.PCX           U   $      2  $      
   $      U   $                     BUILD_7.PCX                     $         $                             BUILD_7.PCX                   U   $      1                                BUILD_7.PCX           1         U   $        $      1                        BUILD_7.PCX           1           $              1                        BUILD_7.PCX            \        2  $      
   $       \                       BUILD_7.PCX                    M   $   !   #                                 BUILD_7.PCX        "   #         M   $      r  $   "   #                        BUILD_7.PCX        "   #         r  $   #        "   #                     
   BUILD5.PCX        $         %   *      &   7      $                        
   BUILD5.PCX        $         &   7      '         $                        
   BUILD5.PCX        (         )   7      *   *      (                        
   BUILD5.PCX        (         *   *      +         (                        
   BUILD5.PCX        ,        -        .   7      ,                       
   BUILD5.PCX        ,        .   7      /         ,                       
   BUILD5.PCX        0         1   7      2        0                        
   BUILD5.PCX        0         2        3        0                        
   BUILD6.PCX        '         &         1         '                        
   BUILD6.PCX        '         1         0         '                        
   BUILD6.PCX        +   ;      *   ;      %         +   ;                     
   BUILD6.PCX        +   ;      %         $         +   ;                     
   BUILD6.PCX        /         .         )   E      /                        
   BUILD6.PCX        /         )   E      (   E      /                        
   BUILD5.PCX        )   *      .   
      *   J      )   *                     
   BUILD5.PCX        *         .   J      -        *                        
   BUILD5.PCX        *         -         %         *                        
   BUILD5.PCX        %         -         2   +     %                        
   BUILD5.PCX        %   @      2        &   `      %   @                     
   BUILD5.PCX        &   `      2        1         &   `                     
   BUILD5.PCX        /   
      (   *      +   J      /   
                     
   BUILD5.PCX        /   J      +         ,        /   J                     
   BUILD5.PCX        ,         +         $         ,                        
   BUILD5.PCX        ,         $         3   +     ,                        
   BUILD5.PCX        3        $   @      '   `      3                       
   BUILD5.PCX        3        '   `      0         3                       
   BUILD5.PCX        4     M   5   =   M   6   1      4     M                  
   BUILD5.PCX        4     M   6   1      7        4     M                  
   BUILD5.PCX        8        9   1      :   =   M   8                       
   BUILD5.PCX        8        :   =   M   ;     M   8                       
   BUILD5.PCX        <         =   O      >   1      <                        
   BUILD5.PCX        <         >   1      ?        <                        
   BUILD5.PCX        @        A   1      B   O      @                       
   BUILD5.PCX        @         B         C         @                        
   BUILD6.PCX        ;   /   >   :   /      5         ;   /   >                  
   BUILD6.PCX        ;   /   >   5         4      >   ;   /   >                  
   BUILD6.PCX        C   6   9   B   6      =         C   6   9                  
   BUILD6.PCX        C   6   9   =         <      9   C   6   9                  
   BUILD5.PCX        9         >         :   P   M   9                        
   BUILD5.PCX        :   P      >         =         :   P                     
   BUILD5.PCX        :         =         5   /      :                        
   BUILD5.PCX        5   o      =   $     B         5   o                     
   BUILD5.PCX        5   o      B         6   4      5   o                     
   BUILD5.PCX        6   t      B   \      A   :      6   t                     
   BUILD5.PCX        ?         8         ;   P   M   ?                        
   BUILD5.PCX        ?         ;   P      <         ?                        
   BUILD5.PCX        <         ;         4   /      <                        
   BUILD5.PCX        <   $     4   o      C         <   $                    
   BUILD5.PCX        C         4   o      7   4      C                        
   BUILD5.PCX        C   \      7   t      @   :      C   \                        BUILD_7.PCX             $        $         $        $                     BUILD_7.PCX           V   $      0  $         $      V   $                     BUILD_7.PCX           V   $         $        $      V   $                     BUILD_7.PCX             $         $      0  $        $                     BUILD_7.PCX           2         V   $        $      2                        BUILD_7.PCX           2           $      
        2                        BUILD_7.PCX                     $         $                             BUILD_7.PCX           
        V   $      2         
                       BUILD_7.PCX        !   %         O   $      p  $   !   %                        BUILD_7.PCX        !   %         p  $   "        !   %                        BUILD_7.PCX        #   Z        0  $         $   #   Z                       BUILD_7.PCX        #           O   $       %      #                          B_FLOOR.PCX        D   y     E   y   y   F     y   D   y                       B_FLOOR.PCX        D   y     F     y   G       D   y           @ANIMATE-XPL5,0,-5                     H   t   I   5   A   J      @   K         H   lີ      @ANIMATE-XPLG1,0,-1                     L       M   5       N   D   D   O          L                @ANIMATE-XPLG2,0,-5                     P   D   Q   9   C   R   H       S          P   ̸        j
       DEFAULT.PAL    MAIN             H   p  p  &  &  e  @)  e  @)  A2  @)  A2  @)  p    p  w"  &  w"  &    e  8r  @)  e  [1  @)  A2  [1  @)  A2  8r  @)  <<@)  @)  @)  @)  n4      _  _  l  _  ^  Ϣ|ϢB  ^  m  ^        &)ZS&)ZS  <  <w"  w"    8r  @)  [1  @)  [1  @)  8r  @)  6!  6!  \6!  \Y  6!  O  6!  }F  6!    F  6!      6!  *F  x  6!  *F  ?6!    Q6!    6!  Hn  ï  D  h  D  D  d  D  p       r  4Z  y   T  U   Ǯ ?  tB[  _    O                     BUILD15.PCX           <         <                 <                        BUILD15.PCX           <                         <                        BUILD14.PCX           v         I                    v                        BUILD14.PCX           v                           v                        BUILD14.PCX           	          6         {        	                         BUILD14.PCX           I                           I                         BUILD14.PCX           *                   K        *                         BUILD14.PCX           j                   4         j                         BUILD14.PCX           U         j          4         U                        BUILD14.PCX           U         4                 U                        BUILD15.PCX           <         <      
           <                        BUILD15.PCX           <      
                   <                        BUILD14.PCX        
   v         I                
   v                        BUILD14.PCX        
   v               	        
   v                        BUILD14.PCX           	          6      
   {        	                         BUILD14.PCX           I       
                    I                         BUILD14.PCX           *                   K        *                         BUILD14.PCX           j                  4         j                         BUILD14.PCX           U      
   j       	   4         U                        BUILD14.PCX           U      	   4      
           U                        BUILD15.PCX           <         <                 <                        BUILD15.PCX           <                         <                        BUILD14.PCX           v         I                   v                        BUILD14.PCX           v                          v                        BUILD14.PCX           	          6         {        	                         BUILD14.PCX           I                           I                         BUILD14.PCX           *                   K        *                         BUILD14.PCX           j                  4         j                         BUILD14.PCX           U         j          4         U                        BUILD14.PCX           U         4                 U                        BUILD14.PCX           f      1   S      0   _        f                        BUILD14.PCX           f      0   _                f                        BUILD14.PCX           (      5         4           (                        BUILD14.PCX           (      4                   (                        BUILD14.PCX                7   )     6                                   BUILD14.PCX                6            (                                BUILD14.PCX                ;   _     :   T                                BUILD14.PCX                :   T         h                                BUILD14.PCX                 2   a     1   T                                 BUILD14.PCX                 1   T         f                                 BUILD14.PCX           f      4   S      3   a        f                        BUILD14.PCX           f      3   a     !           f                        BUILD14.PCX        "   ,      8         7        "   ,                        BUILD14.PCX        "   ,      7                "   ,                        BUILD14.PCX                :   -     9                                   BUILD14.PCX                9         #   ,                                BUILD14.PCX                 0         ;   .                                 BUILD14.PCX                 ;   .                                          BUILD14.PCX                 6   -      5                                    BUILD14.PCX                 5                                             BUILD14.PCX        !         3   *      2         !                           BUILD14.PCX        !         2                   !                           BUILD14.PCX        #         9         8   )      #                           BUILD14.PCX        #         8   )      "         #                           5_FLOOR.PCX        '      x   $         %   ~      '      x                     5_FLOOR.PCX        '      x   %   ~      &   ~   x   '      x                     BUILD15.PCX        /   <      ,   <      -        /   <                        BUILD15.PCX        /   <      -        .        /   <                        BUILD14.PCX        -   v      ,   I       (         -   v                        BUILD14.PCX        -   v      (         )        -   v                        BUILD14.PCX        /   	       .   6      *   {     /   	                         BUILD14.PCX        /   I       *        +         /   I                         BUILD14.PCX        ,   *       /         +   K     ,   *                         BUILD14.PCX        ,   j       +        (   4      ,   j                         BUILD14.PCX        .   U      -   j       )   4      .   U                        BUILD14.PCX        .   U      )   4      *        .   U                     	   5_PAD.PCX        ;   A      0   A   %   :   %      ;   A                     	   5_PAD.PCX        :   %      0   A   %   1   %   %   :   %                     	   5_PAD.PCX        :   %      1   %   %   4      %   :   %                     	   5_PAD.PCX        4      %   1   %   %   2   %   A   4      %                  	   5_PAD.PCX        4      %   2   %   A   3      A   4      %                  	   5_PAD.PCX        :   %      4      %   7         :   %                     	   5_PAD.PCX        :   %   [   7      [   8      ?   :   %   [                  	   5_PAD.PCX        :   %   [   8      ?   9   %   ?   :   %   [                  	   5_PAD.PCX        7   Z      4   Z   %   6   >      7   Z                     	   5_PAD.PCX        6   >      4   Z   %   5   >   %   6   >            @ANIMATE-XPLG1,0,-1                     <      =           >   q    ?           <   4      @ANIMATE-XPLG2,0,-5                     @   Ĳ   A           B   q    C           @   p      @ANIMATE-XPL5,0,-5                     D   Ĳ    E   q    F           G   pD   4   6       j
       DEFAULT.PAL    MAIN             M   ,w  t    A  ]3  ,U  ˣ73  Q  LH  ]3  gb  ?73  
#   X
#   ;     7~     7~H     y     =z   J=z   J      nW   i     K%     K%  jZ   m  ;     _b        r     J  L%     `  K     `          @  ?  2  E  }L  O  ?  W  ڟL  kl  5m  _N  t  b  t  /     S     (7 h7     t    'c  t  \>  J     >  1T       t  Ō  t            m  -L  }L    wM  ?  Sd  NL  i  {?  l  h5m  eQ  Bw5m  l  uS   j:  l   q  5m    }w5m  l       l   Gl  5m  AQ  5m  )l     (:  ;   h   Xh   (T hT     G  J  G  DVG  ,D  G  Վ ^p G  > pjG  8ºG   G    ; G  #s \G  BG  i  G  N                     BUILD12.PCX        #   x   1   ?   G   1   =   #     #   x   1                     BUILD12.PCX        #   x   1   =   #             #   x   1                     BUILD12.PCX        @      1   $   8   1      \     @      1                     BUILD12.PCX        @   G   1           >   #     @   G   1                     BUILD12.PCX        7      '  5   D      9         7      '                    BUILD12.PCX        7      '  9         ;      '  7      '                    BUILD12.PCX        '   ?     %   y      )         '   ?                       BUILD12.PCX        '   ?     )         +       '   ?                       BUILD13.PCX        )   ;                 *   m   |   )   ;                         BUILD13.PCX        %   m             _   )   ;   `   %   m                        BUILD13.PCX        &             _   _   %   -      &                           BUILD13.PCX              _          _   &   R            _                     BUILD13.PCX            R   |                          R   |                     BUILD13.PCX        *   -   |       _             |   *   -   |                     BUILD13.PCX             3      7         7   3        3                     BUILD13.PCX             3              7           3                     BUILD13.PCX        /           ,   3   -   ,      /                          BUILD13.PCX        /             3      ,   3   /                          BUILD12.PCX        3      )  1   '      6   x      3      )                    BUILD12.PCX        3      )  6   x      8      )  3      )                    BUILD12.PCX        ,   ?     *   g                ,   ?                       BUILD12.PCX        ,   ?               "        ,   ?                       BUILD12.PCX           ,  
         5         	      ,  
                     BUILD12.PCX           ,  
      &  5         5      ,  
                     BUILD12.PCX           &  5   .      	         5      &  5                     BUILD12.PCX           &  5   0   ,  
   .      	      &  5                     BUILD12.PCX        <      )  :   7      2         <      )                    BUILD12.PCX        <      )  2         4      )  <      )                    BUILD12.PCX        $   s   1   #   L   1      /     $   s   1                     BUILD12.PCX        $   s   1      /             $   s   1                     4_FLOOR.PCX           +   (      5   /   
   >   E      +   (                     4_FLOOR.PCX           +   (   
   >   E   	   ,   g      +   (                     4_FLOOR.PCX           +   (   	   ,   g         g      +   (                     4_FLOOR.PCX           +   (         g          G      +   (                     4_FLOOR.PCX           +   (          G         (      +   (                     4_FLOOR.PCX        
   >   E      5   /      E   ?   
   >   E                     4_FLOOR.PCX           E   ?      5   /      M   #      E   ?                     4_FLOOR.PCX           E   ?      M   #      V   9      E   ?                     4_FLOOR.PCX           V   9      M   #      m   9      V   9                     4_FLOOR.PCX           m   9      M   #      v   %      m   9                     4_FLOOR.PCX           v   %      M   #      k         v   %                     4_FLOOR.PCX           k         M   #      S         k                        4_FLOOR.PCX        
   >   E      E   ?      d   b   
   >   E                     4_FLOOR.PCX           d   b      E   ?      n   _      d   b                     4_FLOOR.PCX           d   b      n   _         _      d   b                     4_FLOOR.PCX           d   b         _   
      u      d   b                     4_FLOOR.PCX           d   b   
      u      d   u      d   b                     BUILD12.PCX           3           7               3                       BUILD12.PCX           3        ,  7         7      3                    	   4_PAD.PCX        9                     :      ;   9                         	   4_PAD.PCX        5                    9          5                        	   4_PAD.PCX        6   .                 5         6   .                     	   4_PAD.PCX        1   >                 6   .      1   >                     	   4_PAD.PCX        2   /   ;              1   >      2   /   ;                  	   4_PAD.PCX        :      ;              2   /   ;   :      ;                     BUILD12.PCX        !   -        P      &         !   -                       BUILD12.PCX        !   -     &         (        !   -                       BUILD12.PCX        "   8         q               "   8                       BUILD12.PCX        "   8              !   
    "   8                       BUILD13.PCX        @         ?      %   #      %   @                           BUILD13.PCX        @         #      %   $         @                           BUILD12.PCX        (        &   (      %         (                          BUILD12.PCX        (        %         '        (                          BUILD12.PCX        +   *     )   O      *         +   *                       BUILD12.PCX        +   *     *         ,        +   *                       BUILD12.PCX        0   ,  7   -         .      7   0   ,  7                     BUILD12.PCX        0   ,  7   /   3     -         0   ,  7                     BUILD12.PCX        4      )  2   A      1         4      )                    BUILD12.PCX        4      )  1         3      (  4      )                    BUILD12.PCX        8      *  6   8      5         8      *                    BUILD12.PCX        8      *  5         7      *  8      *                    BUILD12.PCX        ;      (  9   (      :   y      ;      (                    BUILD12.PCX        ;      (  :   y      <      (  ;      (                    BUILD12.PCX        ?      1   @   3   1   >   P     ?      1                     BUILD12.PCX        ?   L   1   >        =   /     ?   L   1         @ANIMATE-XPL9,0,-5                     A   4   B           C   {    D           A   T      @ANIMATE-XPLG2,0,-5                     E   4    F   {    G           H   TE   6             @ANIMATE-XPLG1,0,-1                     I   4    J           K   TL   6       I   X   /       j
       DEFAULT.PAL    MAIN             l   ?  ?  *  *  <:  (R  <:  R  0  R  0  (R  ?  \  ?  
G  *  
G  *  \  u:  V  R  u:  zL  R  H0  zL  R  H0  V  R  ޲޲w(R  wR  KR  K(R  \  
G  
G  \  V  R  zL  R  zL  R  V  R  ]7  _  q    0    X  K#       R    ]7  E        l  =  #  l     R  q  ]7  E  q  ]7  _    5N  m  q  5N  R  q  ]7  E  q     R  q     m  q  ]7  Bz  q  5N  m    5N  R    ]7  E       R       m    ]7  Bz    pn^  u)  P   >)       /          7   B                    w       \    0    &               B̒B5m      i  &  5m  &  ̒    %YY  >Y  HY  Y  j^  nj^  Ho^  o^  pY  n^  n^  pn^  Hn^  Hn^  p\n^  Y  Y  pY  HY  HY  p\Y  -o<  F  `,F  fXF  <F    ߄ F  /C F  iF  _8 F    k3 F  k3 F  SF  S  F                    
   B_POST.PCX           +                        ?      +                      
   B_POST.PCX           +              ?      7   ?      +                      
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?          ?                            
   B_POST.PCX           +                       ?      +                      
   B_POST.PCX           +             ?      7   ?      +                      
   B_POST.PCX           +                              +                      
   B_POST.PCX           +                    +          +                      
   B_POST.PCX        
   +                       ?   
   +                      
   B_POST.PCX        
   +             ?   	   7   ?   
   +                      
   B_POST.PCX                     +       
   7   ?                            
   B_POST.PCX                  
   7   ?         ?                            
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX           +       
          	      ?      +                      
   B_POST.PCX           +       	      ?   
   7   ?      +                      
   B_POST.PCX           +                 
             +                      
   B_POST.PCX           +       
             +          +                      
   B_POST.PCX           +                       ?      +                      
   B_POST.PCX           +             ?      7   ?      +                      
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX           +                       ?      +                      
   B_POST.PCX           +             ?      7   ?      +                      
   B_POST.PCX           +                              +                      
   B_POST.PCX           +                    +          +                      
   B_POST.PCX           +                       ?      +                      
   B_POST.PCX           +             ?      7   ?      +                      
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX           +                       ?      +                      
   B_POST.PCX           +             ?      7   ?      +                      
   B_POST.PCX           +                              +                      
   B_POST.PCX           +                    +          +                      
   T2_PAD.PCX        *   /   :               /   >       *   /   :                  
   T2_PAD.PCX        +      :               *   /   :   +      :                  
   T2_PAD.PCX        ,                      +      :   ,                         
   T2_PAD.PCX        -                     ,          -                        
   T2_PAD.PCX        .   /                  -         .   /                     
   T2_PAD.PCX        /   >                   .   /      /   >                         T2_RAMP.PCX        $         #   <      "   <   $   $                           T2_RAMP.PCX        $         "   <   $   !      $   $                           T2_RAMP.PCX        %      $   (         $         %      $                     T2_RAMP.PCX        %      $   $         !      $   %      $                     T2_RAMP.PCX        '   <      &   <   $   "   <   $   '   <                        T2_RAMP.PCX        '   <      "   <   $   #   <      '   <                        T2_RAMP.PCX        (         %      $   &   <   $   (                           T2_RAMP.PCX        (         &   <   $   '   <      (                        
   BUILD9.PCX        5         )         0      7   5                        
   BUILD9.PCX        0      7   )         1   .   7   0      7                  
   BUILD9.PCX        1   .   7   )         2   =      1   .   7                  
   BUILD9.PCX        2   =      )         3   .      2   =                     
   BUILD9.PCX        3   .      )         4         3   .                     
   BUILD9.PCX        4         )         5         4                        
   BUILD9.PCX        0      7   *      7   /         0      7                  
   BUILD9.PCX        0      7   /         5         0      7                  
   BUILD9.PCX        1   .   7   +   .   7   *      7   1   .   7                  
   BUILD9.PCX        1   .   7   *      7   0      7   1   .   7                  
   BUILD9.PCX        2   =      ,   =      +   .   7   2   =                     
   BUILD9.PCX        2   =      +   .   7   1   .   7   2   =                     
   BUILD9.PCX        4         .         -   .      4                        
   BUILD9.PCX        4         -   .      3   .      4                        
   BUILD9.PCX        5         /         .         5                        
   BUILD9.PCX        5         .         4         5                        
   T2_PAD.PCX        T   /   :   6           Y   >       T   /   :                  
   T2_PAD.PCX        U      :   6           T   /   :   U      :                  
   T2_PAD.PCX        V          6           U      :   V                         
   T2_PAD.PCX        W         6           V          W                        
   T2_PAD.PCX        X   /      6           W         X   /                     
   T2_PAD.PCX        Y   >       6           X   /      Y   >                      
   BUILD8.PCX        ;   $   (  B   6      A         ;   $   (                 
   BUILD8.PCX        ;   $   (  A         7      (  ;   $   (                 
   BUILD8.PCX        7   )   )  A   :      @         7   )   )                 
   BUILD8.PCX        7   )   )  @         8      )  7   )   )                 
   BUILD8.PCX        8   -   (  @   ?      ?         8   -   (                 
   BUILD8.PCX        8   -   (  ?         9      (  8   -   (                 
   BUILD8.PCX        9   $   (  ?   6      >         9   $   (                 
   BUILD8.PCX        9   $   (  >         :      (  9   $   (                 
   BUILD8.PCX        :   )   )  >   :      C         :   )   )                 
   BUILD8.PCX        :   )   )  C         <      )  :   )   )                 
   BUILD8.PCX        <   -   (  C   ?      B         <   -   (                 
   BUILD8.PCX        <   -   (  B         ;      (  <   -   (                 
   BUILD9.PCX        >         =   `   /   C         >                        
   BUILD9.PCX        ?      /   =      /   >   ^      ?      /                  
   BUILD9.PCX        @   ]   =   =         ?         @   ]   =                  
   BUILD9.PCX        A      <   =   `      @      =   A      <                  
   BUILD9.PCX        B         =          A   a   <   B                        
   BUILD9.PCX        C   b      =       /   B      .   C   b                        T2_FLOOR.PCX        E   `   w   D   A   A   J   ~   A   E   `   w                     T2_FLOOR.PCX        F   "   w   D   A   A   E   `   w   F   "   w                     T2_FLOOR.PCX        G      A   D   A   A   F   "   w   G      A                     T2_FLOOR.PCX        H   "      D   A   A   G      A   H   "                        T2_FLOOR.PCX        I   `      D   A   A   H   "      I   `                        T2_FLOOR.PCX        J   ~   A   D   A   A   I   `      J   ~   A                     T2_RAMP.PCX        N         M   <      L   <   $   N                           T2_RAMP.PCX        N         L   <   $   K      $   N                           T2_RAMP.PCX        O      $   R         N         O      $                     T2_RAMP.PCX        O      $   N         K      $   O      $                     T2_RAMP.PCX        Q   <      P   <   $   L   <   $   Q   <                        T2_RAMP.PCX        Q   <      L   <   $   M   <      Q   <                        T2_RAMP.PCX        R         O      $   P   <   $   R                           T2_RAMP.PCX        R         P   <   $   Q   <      R                        
   BUILD9.PCX        _         S         Z      7   _                        
   BUILD9.PCX        Z      7   S         [   .   7   Z      7                  
   BUILD9.PCX        [   .   7   S         \   =      [   .   7                  
   BUILD9.PCX        \   =      S         ]   .      \   =                     
   BUILD9.PCX        ]   .      S         ^         ]   .                     
   BUILD9.PCX        ^         S         _         ^                        
   BUILD9.PCX        Z      7   T      7   Y         Z      7                  
   BUILD9.PCX        Z      7   Y         _         Z      7                  
   BUILD9.PCX        [   .   7   U   .   7   T      7   [   .   7                  
   BUILD9.PCX        [   .   7   T      7   Z      7   [   .   7                  
   BUILD9.PCX        \   =      V   =      U   .   7   \   =                     
   BUILD9.PCX        \   =      U   .   7   [   .   7   \   =                     
   BUILD9.PCX        ^         X         W   .      ^                        
   BUILD9.PCX        ^         W   .      ]   .      ^                        
   BUILD9.PCX        _         Y         X         _                        
   BUILD9.PCX        _         X         ^         _               @ANIMATE-XPL5,0,-1                     `   |յP   a      
  b   {      c   {   P˵`      ˵      @ANIMATE-XPLG2,0,-5                     d   |յ|ɵe    
  b   f      c   g   ˵`   d   ˵         @ANIMATE-XPLG1,0,-1                     h   |յ(`i   e   `   j   f   Q   k   d   m   h      |ɵ    j
       DEFAULT.PAL    MAIN             H   V  ~   r  ~   f  ~   V  ~   V  !  h  !  n  !  V  !  V  8  ~   r  8  ~   f     ~   V     ~   V  8  !  h  r8  !  n     !  V     !  V  ,J      ,J      .   V  .   V  ,J  9   ,J  9   .9  V  .9  Қ  ~   X  ~   X  ~   @  ~   Қ  !  X  !  X  !  @  !  r            X            r  o<    o<  X  o<    o<  0e~   *F~   3R~   2e~   0e!  8P!  3H!  2e!      `"e    \sd    s    o<  `"eo<  \sdo<  so<  $j   $X     J  X     J  j   $j9  $X  9  J  X  9  J  j9       ;G  Mu  B+       Z;  2 "Z;  |Z;  J  Z;  B                  	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8           *  ?      *                     	   NP_03.PCX            *  ?      8          :   ?       *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                  	   NP_01.PCX                    ?      
                                 	   NP_01.PCX        
            ?         ?      
                        	   NP_03.PCX           *      
   8          *  ?      *                     	   NP_03.PCX           *  ?   
   8       	   :   ?      *  ?                  	   NP_03.PCX           ,                 
   .   ?      ,                      	   NP_03.PCX        
   .   ?                   ?   
   .   ?                     RC01_02.PCX                                  >                                RC01_02.PCX           @             >      ?   <      @                         RC01_01.PCX           /                       ?      /                         RC01_01.PCX           /             ?      /   ?      /                         RC01_01.PCX           Z          
          
   ?      Z                         RC01_01.PCX           Z          
   ?      Z   ?      Z                         RC01_01.PCX                                    ?                               RC01_01.PCX                         ?         ?                               RC01_01.PCX           =                       ?      =                         RC01_01.PCX           =             ?      =   ?      =                      	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8          *  ?      *                     	   NP_03.PCX           *  ?      8          :   ?      *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                     RC01_02.PCX        $   @   @   '       ?   %   @      $   @   @                     RC01_02.PCX        %   @      '       ?   &          %   @                        RC01_01.PCX        '   (   !   $   }   !   #   (   @   '   (   !                     RC01_01.PCX        #   (   @   $   }   !       }   @   #   (   @                     RC01_01.PCX        %   }   !   &   '   !   !   }   @   %   }   !                     RC01_01.PCX        !   }   @   &   '   !   "   '   @   !   }   @                     RC01_01.PCX        $   ?   !   %       !       ?   @   $   ?   !                     RC01_01.PCX            ?   @   %       !   !       @       ?   @                     RC01_01.PCX        &       !   '   @   !   "       @   &       !                     RC01_01.PCX        "       @   '   @   !   #   @   @   "       @                  	   NP_01.PCX        /   ?      ,         -         /   ?                     	   NP_01.PCX        /   ?      -         .   ?      /   ?                     	   NP_03.PCX        -   8       ,   *      (   *  ?   -   8                      	   NP_03.PCX        -   8       (   *  ?   )   :   ?   -   8                      	   NP_03.PCX        /          .   ,       *   .   ?   /                         	   NP_03.PCX        /          *   .   ?   +      ?   /                            RC01_02.PCX        7       ?   4   @   @   5   @      7       ?                     RC01_02.PCX        7       ?   5   @      6          7       ?                     RC01_01.PCX        4   }   !   7   (   !   3   (   @   4   }   !                     RC01_01.PCX        4   }   !   3   (   @   0   }   @   4   }   !                     RC01_01.PCX        6   '   !   5   }   !   1   }   @   6   '   !                     RC01_01.PCX        6   '   !   1   }   @   2   '   @   6   '   !                     RC01_01.PCX        5       !   4   ?   !   0   ?   @   5       !                     RC01_01.PCX        5       !   0   ?   @   1       @   5       !                     RC01_01.PCX        7   @   !   6       !   2       @   7   @   !                     RC01_01.PCX        7   @   !   2       @   3   @   @   7   @   !                     RC01_02.PCX        ?           <         =      >   ?                             RC01_02.PCX        ?   @       =      >   >   ?   <   ?   @                         RC01_01.PCX        =   /       <          8      ?   =   /                         RC01_01.PCX        =   /       8      ?   9   /   ?   =   /                         RC01_01.PCX        ?   Z       >   
       :   
   ?   ?   Z                         RC01_01.PCX        ?   Z       :   
   ?   ;   Z   ?   ?   Z                         RC01_01.PCX        <          ?           ;       ?   <                            RC01_01.PCX        <          ;       ?   8      ?   <                            RC01_01.PCX        >   =       =          9      ?   >   =                         RC01_01.PCX        >   =       9      ?   :   =   ?   >   =             @ANIMATE-XPLG1,0,-1                     @   4    A   j       B   4      C   U      @                @ANIMATE-XPL9,0,-2                     D   4   E        F   U      G          D   ة        j
       DEFAULT.PAL    MAIN             @     B    (        d      .  @d        BJ(  (  J(    d  J(  .  @d  J(  6  8  T    E  8  T   E     T   P     T   6  8    E  r8    E       P       8Қ  T   ^X  T   8X  T     T   8Қ    nX    :X        <r            /  X      8/        <r  J(    J(  /  X  J(  8/    J(  K0eT   KFT   cRT   fceT   K0e  KP  cH  fce  8    9"e    
d        8J(  9"eJ(  
dJ(  J(  (j\   (X  \   D  X  \   D  j\   (j&\  (X  &\  D  X  &\  D  j&\  U   $  w '$  O$  l"+ $    x   -< J7  /  I    <                     RC01_02.PCX               ?      @   @      @             ?                     RC01_02.PCX               ?      @                       ?                     RC01_01.PCX           }   !      (   !      (   @      }   !                     RC01_01.PCX           }   !      (   @       }   @      }   !                     RC01_01.PCX           '   !      }   !      }   @      '   !                     RC01_01.PCX           '   !      }   @      '   @      '   !                     RC01_01.PCX               !      ?   !       ?   @          !                     RC01_01.PCX               !       ?   @          @          !                     RC01_01.PCX           @   !          !          @      @   !                     RC01_01.PCX           @   !          @      @   @      @   !                  	   NP_01.PCX                    ?      
                                 	   NP_01.PCX        
            ?         ?      
                        	   NP_03.PCX           *      
   8          *  ?      *                     	   NP_03.PCX           *  ?   
   8       	   :   ?      *  ?                  	   NP_03.PCX           ,                 
   .   ?      ,                      	   NP_03.PCX        
   .   ?                   ?   
   .   ?                  	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8          *  ?      *                     	   NP_03.PCX           *  ?      8          :   ?      *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                     RC01_02.PCX           @   @          ?      @         @   @                     RC01_02.PCX           @             ?                @                        RC01_01.PCX           (   !      }   !      (   @      (   !                     RC01_01.PCX           (   @      }   !      }   @      (   @                     RC01_01.PCX           }   !      '   !      }   @      }   !                     RC01_01.PCX           }   @      '   !      '   @      }   @                     RC01_01.PCX           ?   !          !      ?   @      ?   !                     RC01_01.PCX           ?   @          !          @      ?   @                     RC01_01.PCX               !      @   !          @          !                     RC01_01.PCX               @      @   !      @   @          @                  	   NP_01.PCX        '   ?      $         %         '   ?                     	   NP_01.PCX        '   ?      %         &   ?      '   ?                     	   NP_03.PCX        %   8       $   *          *  ?   %   8                      	   NP_03.PCX        %   8           *  ?   !   :   ?   %   8                      	   NP_03.PCX        '          &   ,       "   .   ?   '                         	   NP_03.PCX        '          "   .   ?   #      ?   '                            RC01_02.PCX        /       ?   ,   @   @   -   @      /       ?                     RC01_02.PCX        /       ?   -   @      .          /       ?                     RC01_01.PCX        ,   }   !   /   (   !   +   (   @   ,   }   !                     RC01_01.PCX        ,   }   !   +   (   @   (   }   @   ,   }   !                     RC01_01.PCX        .   '   !   -   }   !   )   }   @   .   '   !                     RC01_01.PCX        .   '   !   )   }   @   *   '   @   .   '   !                     RC01_01.PCX        -       !   ,   ?   !   (   ?   @   -       !                     RC01_01.PCX        -       !   (   ?   @   )       @   -       !                     RC01_01.PCX        /   @   !   .       !   *       @   /   @   !                     RC01_01.PCX        /   @   !   *       @   +   @   @   /   @   !                     RC01_02.PCX        7           4         5      >   7                             RC01_02.PCX        7   @       5      >   6   ?   <   7   @                         RC01_01.PCX        5   /       4          0      ?   5   /                         RC01_01.PCX        5   /       0      ?   1   /   ?   5   /                         RC01_01.PCX        7   Z       6   
       2   
   ?   7   Z                         RC01_01.PCX        7   Z       2   
   ?   3   Z   ?   7   Z                         RC01_01.PCX        4          7           3       ?   4                            RC01_01.PCX        4          3       ?   0      ?   4                            RC01_01.PCX        6   =       5          1      ?   6   =                         RC01_01.PCX        6   =       1      ?   2   =   ?   6   =             @ANIMATE-XPLG2,0,-2                     8   4   9           :   t{    ;           8   T      @ANIMATE-XPLG1,0,-1                     <   4    =   t{    >           ?   T<   #          j
       DEFAULT.PAL    MAIN             H   RɄ  i    -2  i   R!2  i     i   RɄ  -  !2  -  M+2  -    -  Y@  Ʉ  i   '@  -2  i   Y"  !2  i   "    i   Y@  Ʉ  -  @  !2  -  V"  +2  -  "    -  >V    s   >V  tb s   wb s     s   >V    0s  >V  tb 0s  wb 0s    0s      i     2  i   ¡  2  i   f  ӄ  i       -    
2  -  š  2  -  f  ӄ  -  V  :      
W  Ƅ        Z      Z        V  :  ]2  
W  Ƅ  ]2    Z  ]2  Z    ]2    i     CTi   <  RTi   X<  i     -    OT-  <  ET-  X<  -    "    j      '               "]2  j  ]2  '   ]2    ]2  ©pTs   ©1  s    1  s    pTs   ©pT0s  ©1  0s   1  0s   pT0s   l   ]{ I  :       <   & :b   <  Y    B                  	   NP_01.PCX           ?                           ?                     	   NP_01.PCX           ?                  ?         ?                     	   NP_03.PCX           8          *          *  ?      8                      	   NP_03.PCX           8           *  ?      :   ?      8                      	   NP_03.PCX                     ,          .   ?                            	   NP_03.PCX                     .   ?         ?                            	   NP_01.PCX           ?               
            ?                     	   NP_01.PCX           ?      
            ?         ?                     	   NP_03.PCX        
   8          *         *  ?   
   8                      	   NP_03.PCX        
   8          *  ?   	   :   ?   
   8                      	   NP_03.PCX                     ,       
   .   ?                            	   NP_03.PCX                  
   .   ?         ?                               RC01_02.PCX                                  >                              RC01_02.PCX              >      @          ?   <         >                     RC01_01.PCX                     /             ?                               RC01_01.PCX              ?      /          /   ?         ?                     RC01_01.PCX           
          Z          
   ?      
                         RC01_01.PCX           
   ?      Z          Z   ?      
   ?                     RC01_01.PCX                                    ?                                RC01_01.PCX               ?                   ?          ?                     RC01_01.PCX                     =             ?                               RC01_01.PCX              ?      =          =   ?         ?                  	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8          *  ?      *                     	   NP_03.PCX           *  ?      8          :   ?      *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                     RC01_02.PCX        $   @   @   '       ?   %   @      $   @   @                     RC01_02.PCX        %   @      '       ?   &          %   @                        RC01_01.PCX        '   (   !   $   }   !   #   (   @   '   (   !                     RC01_01.PCX        #   (   @   $   }   !       }   @   #   (   @                     RC01_01.PCX        %   }   !   &   '   !   !   }   @   %   }   !                     RC01_01.PCX        !   }   @   &   '   !   "   '   @   !   }   @                     RC01_01.PCX        $   ?   !   %       !       ?   @   $   ?   !                     RC01_01.PCX            ?   @   %       !   !       @       ?   @                     RC01_01.PCX        &       !   '   @   !   "       @   &       !                     RC01_01.PCX        "       @   '   @   !   #   @   @   "       @                  	   NP_01.PCX        /   ?      ,         -         /   ?                     	   NP_01.PCX        /   ?      -         .   ?      /   ?                     	   NP_03.PCX        -   8       ,   *      (   *  ?   -   8                      	   NP_03.PCX        -   8       (   *  ?   )   :   ?   -   8                      	   NP_03.PCX        /          .   ,       *   .   ?   /                         	   NP_03.PCX        /          *   .   ?   +      ?   /                            RC01_02.PCX        7       ?   4   @   @   5   @      7       ?                     RC01_02.PCX        7       ?   5   @      6          7       ?                     RC01_01.PCX        4   }   !   7   (   !   3   (   @   4   }   !                     RC01_01.PCX        4   }   !   3   (   @   0   }   @   4   }   !                     RC01_01.PCX        6   '   !   5   }   !   1   }   @   6   '   !                     RC01_01.PCX        6   '   !   1   }   @   2   '   @   6   '   !                     RC01_01.PCX        5       !   4   ?   !   0   ?   @   5       !                     RC01_01.PCX        5       !   0   ?   @   1       @   5       !                     RC01_01.PCX        7   @   !   6       !   2       @   7   @   !                     RC01_01.PCX        7   @   !   2       @   3   @   @   7   @   !                     RC01_02.PCX        ?           <         =      >   ?                             RC01_02.PCX        ?   @       =      >   >   ?   <   ?   @                         RC01_01.PCX        =   /       <          8      ?   =   /                         RC01_01.PCX        =   /       8      ?   9   /   ?   =   /                         RC01_01.PCX        ?   Z       >   
       :   
   ?   ?   Z                         RC01_01.PCX        ?   Z       :   
   ?   ;   Z   ?   ?   Z                         RC01_01.PCX        <          ?           ;       ?   <                            RC01_01.PCX        <          ;       ?   8      ?   <                            RC01_01.PCX        >   =       =          9      ?   >   =                         RC01_01.PCX        >   =       9      ?   :   =   ?   >   =             @ANIMATE-XPL5,0,-5                     @   4   A           B   ,s    C           @   T      @ANIMATE-XPLG2,0,-1                     D   4    E   ,s    F           G   TD   2   A       j
       DEFAULT.PAL    MAIN             `   D    i   D  Gm  i   &  Vm  i   ;'    i   D    -  D  Tm  -  &  Jm  -  ;'    -  \  &    )\        m          \  &]2  )\    ]2  m  ]2  ]2  T  i     i     i   3E  i   T  -    -    -  3E  -  T2 i   2 i    i   3N i   T2 -  2 -   -  3N -  )H s   H s   s   )s   )H 0s  H 0s  0s  )0s  bi   bTi   ci   Xi   b-  ba-  Y-  X-  i   Ti   ci   Qi   -  a-  Y-  Q-  s   
s   @  
s   @  s   0s  
0s  @  
0s  @  0s      i     Gm  i     Vm  i       i       -  *  Tm  -    Jm  -      -  ,  &            W4       3     ,  &]2      ]2  W4   ]2  3 ]2  *tm  s   *J s   ZJ J s   ZJ tm  s   *tm  0s  *J 0s  ZJ J 0s  ZJ tm  0s  'a       AG)2  tܠ        X  *2  phV   X                  	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8           *  ?      *                     	   NP_03.PCX            *  ?      8          :   ?       *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                     RC01_02.PCX           @   @          ?   
   @         @   @                     RC01_02.PCX        
   @             ?             
   @                        RC01_01.PCX           (   !      }   !      (   @      (   !                     RC01_01.PCX           (   @      }   !      }   @      (   @                     RC01_01.PCX        
   }   !      '   !   	   }   @   
   }   !                     RC01_01.PCX        	   }   @      '   !   
   '   @   	   }   @                     RC01_01.PCX           ?   !   
       !      ?   @      ?   !                     RC01_01.PCX           ?   @   
       !   	       @      ?   @                     RC01_01.PCX               !      @   !   
       @          !                     RC01_01.PCX        
       @      @   !      @   @   
       @                  	   NP_01.PCX           ?                           ?                     	   NP_01.PCX           ?                  ?         ?                     	   NP_03.PCX           8          *         *  ?      8                      	   NP_03.PCX           8          *  ?      :   ?      8                      	   NP_03.PCX                     ,          .   ?                            	   NP_03.PCX                     .   ?         ?                            	   NP_01.PCX           ?                           ?                     	   NP_01.PCX           ?                  ?         ?                     	   NP_03.PCX           8          *         *  ?      8                      	   NP_03.PCX           8          *  ?      :   ?      8                      	   NP_03.PCX                     ,          .   ?                            	   NP_03.PCX                     .   ?         ?                               RC01_02.PCX        $         '           %      >   $                           RC01_02.PCX        %      >   '   @       &   ?   <   %      >                     RC01_01.PCX        $          %   /              ?   $                            RC01_01.PCX               ?   %   /       !   /   ?          ?                     RC01_01.PCX        &   
       '   Z       "   
   ?   &   
                         RC01_01.PCX        "   
   ?   '   Z       #   Z   ?   "   
   ?                     RC01_01.PCX        '           $          #       ?   '                             RC01_01.PCX        #       ?   $                 ?   #       ?                     RC01_01.PCX        %          &   =       !      ?   %                            RC01_01.PCX        !      ?   &   =       "   =   ?   !      ?                  	   NP_01.PCX        /   ?      ,         -         /   ?                     	   NP_01.PCX        /   ?      -         .   ?      /   ?                     	   NP_03.PCX        -   8       ,   *      (   *  ?   -   8                      	   NP_03.PCX        -   8       (   *  ?   )   :   ?   -   8                      	   NP_03.PCX        /          .   ,       *   .   ?   /                         	   NP_03.PCX        /          *   .   ?   +      ?   /                         	   NP_01.PCX        7   ?      4         5         7   ?                     	   NP_01.PCX        7   ?      5         6   ?      7   ?                     	   NP_03.PCX        5   8       4   *      0   *  ?   5   8                      	   NP_03.PCX        5   8       0   *  ?   1   :   ?   5   8                      	   NP_03.PCX        7          6   ,       2   .   ?   7                         	   NP_03.PCX        7          2   .   ?   3      ?   7                            RC01_02.PCX        <         ?           =      >   <                           RC01_02.PCX        =      >   ?   @       >   ?   <   =      >                     RC01_01.PCX        <          =   /       8      ?   <                            RC01_01.PCX        8      ?   =   /       9   /   ?   8      ?                     RC01_01.PCX        >   
       ?   Z       :   
   ?   >   
                         RC01_01.PCX        :   
   ?   ?   Z       ;   Z   ?   :   
   ?                     RC01_01.PCX        ?           <          ;       ?   ?                             RC01_01.PCX        ;       ?   <          8      ?   ;       ?                     RC01_01.PCX        =          >   =       9      ?   =                            RC01_01.PCX        9      ?   >   =       :   =   ?   9      ?                  	   NP_01.PCX        G   ?      D         E         G   ?                     	   NP_01.PCX        G   ?      E         F   ?      G   ?                     	   NP_03.PCX        E   8       D   *      @   *  ?   E   8                      	   NP_03.PCX        E   8       @   *  ?   A   :   ?   E   8                      	   NP_03.PCX        G          F   ,       B   .   ?   G                         	   NP_03.PCX        G          B   .   ?   C      ?   G                            RC01_02.PCX        O       ?   L   @   @   M   @      O       ?                     RC01_02.PCX        O       ?   M   @      N          O       ?                     RC01_01.PCX        L   }   !   O   (   !   K   (   @   L   }   !                     RC01_01.PCX        L   }   !   K   (   @   H   }   @   L   }   !                     RC01_01.PCX        N   '   !   M   }   !   I   }   @   N   '   !                     RC01_01.PCX        N   '   !   I   }   @   J   '   @   N   '   !                     RC01_01.PCX        M       !   L   ?   !   H   ?   @   M       !                     RC01_01.PCX        M       !   H   ?   @   I       @   M       !                     RC01_01.PCX        O   @   !   N       !   J       @   O   @   !                     RC01_01.PCX        O   @   !   J       @   K   @   @   O   @   !                     RC01_02.PCX        W           T         U      >   W                             RC01_02.PCX        W   @       U      >   V   ?   <   W   @                         RC01_01.PCX        U   /       T          P      ?   U   /                         RC01_01.PCX        U   /       P      ?   Q   /   ?   U   /                         RC01_01.PCX        W   Z       V   
       R   
   ?   W   Z                         RC01_01.PCX        W   Z       R   
   ?   S   Z   ?   W   Z                         RC01_01.PCX        T          W           S       ?   T                            RC01_01.PCX        T          S       ?   P      ?   T                            RC01_01.PCX        V   =       U          Q      ?   V   =                         RC01_01.PCX        V   =       Q      ?   R   =   ?   V   =             @ANIMATE-XPL5,0,-5                     X   t   Y           Z   (    [           X   Ĳ      @ANIMATE-XPLG1,0,-1                     \   t    ]   (    ^           _   l\   =          j
       DEFAULT.PAL    MAIN             l   ?  ?  *  *  <:  (R  <:  R  0  R  0  (R  ?  \  ?  
G  *  
G  *  \  u:  V  R  u:  zL  R  H0  zL  R  H0  V  R  ޲޲w(R  wR  KR  K(R  \  
G  
G  \  V  R  zL  R  zL  R  V  R  ]7  _  q    0    X  K#       R    ]7  E        l  =  #  l     R  q  ]7  E  q  ]7  _    5N  m  q  5N  R  q  ]7  E  q     R  q     m  q  ]7  Bz  q  5N  m    5N  R    ]7  E       R       m    ]7  Bz    pn^  u)  P   >)       /          7   B                    w       \    0    &               B̒B5m      i  &  5m  &  ̒    %YY  >Y  HY  Y  j^  nj^  Ho^  o^  pY  n^  n^  pn^  Hn^  Hn^  p\n^  Y  Y  pY  HY  HY  p\Y  -o<  F  `,F  fXF  <F    ߄ F  /C F  iF  _8 F    k3 F  k3 F  SF  S  F                    
   B_POST.PCX           +                        ?      +                      
   B_POST.PCX           +              ?      7   ?      +                      
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?          ?                            
   B_POST.PCX           +                       ?      +                      
   B_POST.PCX           +             ?      7   ?      +                      
   B_POST.PCX           +                              +                      
   B_POST.PCX           +                    +          +                      
   B_POST.PCX        
   +                       ?   
   +                      
   B_POST.PCX        
   +             ?   	   7   ?   
   +                      
   B_POST.PCX                     +       
   7   ?                            
   B_POST.PCX                  
   7   ?         ?                            
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX           +       
          	      ?      +                      
   B_POST.PCX           +       	      ?   
   7   ?      +                      
   B_POST.PCX           +                 
             +                      
   B_POST.PCX           +       
             +          +                      
   B_POST.PCX           +                       ?      +                      
   B_POST.PCX           +             ?      7   ?      +                      
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX           +                       ?      +                      
   B_POST.PCX           +             ?      7   ?      +                      
   B_POST.PCX           +                              +                      
   B_POST.PCX           +                    +          +                      
   B_POST.PCX           +                       ?      +                      
   B_POST.PCX           +             ?      7   ?      +                      
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX           +                       ?      +                      
   B_POST.PCX           +             ?      7   ?      +                      
   B_POST.PCX           +                              +                      
   B_POST.PCX           +                    +          +                      
   T2_PAD.PCX        *   /   :               /   >       *   /   :                  
   T2_PAD.PCX        +      :               *   /   :   +      :                  
   T2_PAD.PCX        ,                      +      :   ,                         
   T2_PAD.PCX        -                     ,          -                        
   T2_PAD.PCX        .   /                  -         .   /                     
   T2_PAD.PCX        /   >                   .   /      /   >                         T2_RAMP.PCX        $         #   <      "   <   $   $                           T2_RAMP.PCX        $         "   <   $   !      $   $                           T2_RAMP.PCX        %      $   (         $         %      $                     T2_RAMP.PCX        %      $   $         !      $   %      $                     T2_RAMP.PCX        '   <      &   <   $   "   <   $   '   <                        T2_RAMP.PCX        '   <      "   <   $   #   <      '   <                        T2_RAMP.PCX        (         %      $   &   <   $   (                           T2_RAMP.PCX        (         &   <   $   '   <      (                        
   BUILD9.PCX        5         )         0      7   5                        
   BUILD9.PCX        0      7   )         1   .   7   0      7                  
   BUILD9.PCX        1   .   7   )         2   =      1   .   7                  
   BUILD9.PCX        2   =      )         3   .      2   =                     
   BUILD9.PCX        3   .      )         4         3   .                     
   BUILD9.PCX        4         )         5         4                        
   BUILD9.PCX        0      7   *      7   /         0      7                  
   BUILD9.PCX        0      7   /         5         0      7                  
   BUILD9.PCX        1   .   7   +   .   7   *      7   1   .   7                  
   BUILD9.PCX        1   .   7   *      7   0      7   1   .   7                  
   BUILD9.PCX        2   =      ,   =      +   .   7   2   =                     
   BUILD9.PCX        2   =      +   .   7   1   .   7   2   =                     
   BUILD9.PCX        4         .         -   .      4                        
   BUILD9.PCX        4         -   .      3   .      4                        
   BUILD9.PCX        5         /         .         5                        
   BUILD9.PCX        5         .         4         5                        
   T2_PAD.PCX        T   /   :   6           Y   >       T   /   :                  
   T2_PAD.PCX        U      :   6           T   /   :   U      :                  
   T2_PAD.PCX        V          6           U      :   V                         
   T2_PAD.PCX        W         6           V          W                        
   T2_PAD.PCX        X   /      6           W         X   /                     
   T2_PAD.PCX        Y   >       6           X   /      Y   >                      
   BUILD8.PCX        ;   $   (  B   6      A         ;   $   (                 
   BUILD8.PCX        ;   $   (  A         7      (  ;   $   (                 
   BUILD8.PCX        7   )   )  A   :      @         7   )   )                 
   BUILD8.PCX        7   )   )  @         8      )  7   )   )                 
   BUILD8.PCX        8   -   (  @   ?      ?         8   -   (                 
   BUILD8.PCX        8   -   (  ?         9      (  8   -   (                 
   BUILD8.PCX        9   $   (  ?   6      >         9   $   (                 
   BUILD8.PCX        9   $   (  >         :      (  9   $   (                 
   BUILD8.PCX        :   )   )  >   :      C         :   )   )                 
   BUILD8.PCX        :   )   )  C         <      )  :   )   )                 
   BUILD8.PCX        <   -   (  C   ?      B         <   -   (                 
   BUILD8.PCX        <   -   (  B         ;      (  <   -   (                 
   BUILD9.PCX        >         =   `   /   C         >                        
   BUILD9.PCX        ?      /   =      /   >   ^      ?      /                  
   BUILD9.PCX        @   ]   =   =         ?         @   ]   =                  
   BUILD9.PCX        A      <   =   `      @      =   A      <                  
   BUILD9.PCX        B         =          A   a   <   B                        
   BUILD9.PCX        C   b      =       /   B      .   C   b                        T2_FLOOR.PCX        E   `   w   D   A   A   J   ~   A   E   `   w                     T2_FLOOR.PCX        F   "   w   D   A   A   E   `   w   F   "   w                     T2_FLOOR.PCX        G      A   D   A   A   F   "   w   G      A                     T2_FLOOR.PCX        H   "      D   A   A   G      A   H   "                        T2_FLOOR.PCX        I   `      D   A   A   H   "      I   `                        T2_FLOOR.PCX        J   ~   A   D   A   A   I   `      J   ~   A                     T2_RAMP.PCX        N         M   <      L   <   $   N                           T2_RAMP.PCX        N         L   <   $   K      $   N                           T2_RAMP.PCX        O      $   R         N         O      $                     T2_RAMP.PCX        O      $   N         K      $   O      $                     T2_RAMP.PCX        Q   <      P   <   $   L   <   $   Q   <                        T2_RAMP.PCX        Q   <      L   <   $   M   <      Q   <                        T2_RAMP.PCX        R         O      $   P   <   $   R                           T2_RAMP.PCX        R         P   <   $   Q   <      R                        
   BUILD9.PCX        _         S         Z      7   _                        
   BUILD9.PCX        Z      7   S         [   .   7   Z      7                  
   BUILD9.PCX        [   .   7   S         \   =      [   .   7                  
   BUILD9.PCX        \   =      S         ]   .      \   =                     
   BUILD9.PCX        ]   .      S         ^         ]   .                     
   BUILD9.PCX        ^         S         _         ^                        
   BUILD9.PCX        Z      7   T      7   Y         Z      7                  
   BUILD9.PCX        Z      7   Y         _         Z      7                  
   BUILD9.PCX        [   .   7   U   .   7   T      7   [   .   7                  
   BUILD9.PCX        [   .   7   T      7   Z      7   [   .   7                  
   BUILD9.PCX        \   =      V   =      U   .   7   \   =                     
   BUILD9.PCX        \   =      U   .   7   [   .   7   \   =                     
   BUILD9.PCX        ^         X         W   .      ^                        
   BUILD9.PCX        ^         W   .      ]   .      ^                        
   BUILD9.PCX        _         Y         X         _                        
   BUILD9.PCX        _         X         ^         _               @ANIMATE-XPL5,0,-1                     `   |յP   a      
  b   {      c   {   P˵`      ˵      @ANIMATE-XPLG2,0,-5                     d   |յ|ɵe    
  b   f      c   g   ˵`   d   ˵         @ANIMATE-XPLG1,0,-1                     h   |յ(`i   e   `   j   f   Q   k   d   m   h      |ɵ    j
       DEFAULT.PAL    MAIN             L   (,  gQ  ",  Q  +  
?  Q  Q  UQ  ɦ8  Q  æx>  Q        }      z    n    UN.      B  %M  B	  
  %M  =B  %M  ő  %M  @      U        U  V   @V      %M  R  %M  ͝%M  >%M  3  #,  !B  +  :  !B    GF    ,  +  %  7  	,    7    m   H!B  Ȧ:  !B  E  s,  $  7    7    ,  UQ    0    d  .    +  9  Q  +  :  !B  ,  %  7  ,    7  #,  H!B  VQ  0    U.    ٦9  Q  Ȧ:  !B  %  7  ܦ  7  7!B  	    G    'C  G  O  G  μB  G  C  G  Q  G  G  BG  k  A  GK  A  L^A  ϓY  A    :3 A  ' ?A  {A  o  A  g  M A  U A  *A  _  A  X                     BUILD10.PCX        %   8   =        =      C     %   8   =                     BUILD10.PCX        %   8   =      C     $   |      %   8   =                     BUILD10.PCX        '   <                 G  >   '   <                        BUILD10.PCX        '   |           >   &   8   >   '   |                        BUILD10.PCX               =         =         H          =                     BUILD10.PCX              H         =   <      W         H                     BUILD10.PCX        <      W         =         d   <      W                     BUILD10.PCX              d   +      =         =         d                     BUILD10.PCX              d         =         H         d                     BUILD10.PCX              $            9               $                     BUILD10.PCX        !   8   $        $      C     !   8   $                     BUILD10.PCX        !   8   $      C         |      !   8   $                     BUILD10.PCX        >   -      <           G  $   >   -                        BUILD10.PCX        >   m           $   !   8   $   >   m                        BUILD10.PCX           8   =         =      R  H      8   =                     BUILD10.PCX           8   =      R  H      m   H      8   =                     BUILD10.PCX           8   =        =         =      8   =                     BUILD10.PCX           8   =         =      8   =      8   =                     BUILD10.PCX        1   1   4        4      G     1   1   4                     BUILD10.PCX        1   q   4              8      1   q   4                     BUILD10.PCX           8      +        *   N  4      8                        BUILD10.PCX           8      *   N  4      q   4      8                        BUILD10.PCX           8   =        =   +     =      8   =                     BUILD10.PCX           8   =   +     =      8   =      8   =                     BUILD10.PCX           0   H        H      G  =      0   H                     BUILD10.PCX           p   H        =      8   =      p   H                     BUILD10.PCX        "   8   $        $   9   O     "   8   $                     BUILD10.PCX        "   8   $   9   O     ;   p      "   8   $                     BUILD10.PCX        #   <                 G  $   #   <                        BUILD10.PCX        #   |           $   "   8   $   #   |                        BUILD10.PCX           8   =      8   =      m   H      8   =                     BUILD10.PCX           8   =      m   H   >   m   W      8   =                     BUILD10.PCX           8   =   >   m   W   !   8   d      8   =                     BUILD10.PCX           8   =   "   8   d      8   =      8   =                     BUILD10.PCX           8   =   "   8   d      p   H      8   =                     BUILD10.PCX           p      "   8   $   ;   p         p                        BUILD11.PCX        1   N                   N      1   N                        BUILD11.PCX        	   6                1   N      	   6                        BUILD11.PCX        
                    	   6      
                            BUILD11.PCX           1      *   1         `         1                        BUILD11.PCX           1         `      
   `         1                     
   T3_PAD.PCX        9                  8   7   	   9                        
   T3_PAD.PCX        8   7   	            
   :   
   8   7   	                  
   T3_PAD.PCX           :   5   
   :   
               :   5                  
   T3_PAD.PCX           :   5                  >      :   5                  
   T3_PAD.PCX        :   7   6   8   7   	   
   :   
   :   7   6                  
   T3_PAD.PCX        :   7   6   
   :   
      :   5   :   7   6                  
   T3_PAD.PCX              >   ;      >   :   7   6         >                  
   T3_PAD.PCX              >   :   7   6      :   5         >                     T3_FLOOR.PCX              w                            w                     T3_FLOOR.PCX              w                    w         w                  
   T3_PAD.PCX                 <         =   7                              
   T3_PAD.PCX                 =   7         :                              
   T3_PAD.PCX           :   8      :      =   7         :   8                  
   T3_PAD.PCX           :   8   =   7      ?   7   9      :   8                  
   T3_PAD.PCX              >               :            >                  
   T3_PAD.PCX              >      :         :   8         >                  
   T3_PAD.PCX        >      >         >   ?   7   9   >      >                  
   T3_PAD.PCX        ?   7   9         >      :   8   ?   7   9                     BUILD10.PCX           F   =         $      ]         F   =                     BUILD10.PCX           ]            $               ]                        BUILD10.PCX           :   $      }   >      b         :   $                     BUILD10.PCX           :   $      b                  :   $                     BUILD10.PCX        %      =      =   >         =   %      =                     BUILD10.PCX        &   =   >      =   >   %      =   &   =   >                     BUILD10.PCX        "      $   %   F   =   $   ]      "      $                     BUILD10.PCX        "      $   $   ]      #         "      $                     BUILD10.PCX        &   }   >   !   :   $   '   b      &   }   >                     BUILD10.PCX        '   b      !   :   $             '   b                        BUILD10.PCX        /   K   d   (   G   =   .      ~   /   K   d                     BUILD10.PCX        .      ~   (      =   -   <   ~   .      ~                     BUILD10.PCX        -   |   ~   (     =   ,   <   d   -   |   ~                     BUILD10.PCX        ,   <   d   (     =   +   @   =   ,   <   d                     BUILD10.PCX        +          (         *       5   +                            BUILD10.PCX        *       5   (         )      5   *       5                     BUILD10.PCX        0   G   =   7   K   d   6      ~   0   G   =                     BUILD10.PCX        0      =   6      ~   5   <   ~   0      =                     BUILD10.PCX        0     =   5   |   ~   4   <   d   0     =                     BUILD10.PCX        0     =   4   <   d   3   @   =   0     =                     BUILD10.PCX        0         3          2       5   0                           BUILD10.PCX        0         2       5   1      5   0                           BUILD11.PCX        ;   A      9   A   =   8   {   5   ;   A                        BUILD11.PCX        ;   A      8   {   5   :   {   
   ;   A                        BUILD11.PCX        ?         =      8   <   >   >   ?                           BUILD11.PCX        ?         <   >   >   >   >      ?               @ANIMATE-XPL5,0,-5                     @   Ĳ$   A     $   B      $   C     $   @                @ANIMATE-XPLG2,0,-5                     D   Ĳ$   E      $   F   V   $   G          D   į          @ANIMATE-XPLG1,0,-1                     H   Ĳ$   I   V   $   J          K   L    H           j
       DEFAULT.PAL    MAIN             T   3O-  O-  -  3-  "-  -   
   
  OA   
  OA   
  xA  -  -  -  xA  -  ߫y߫]!]!yo  Qp    m  ف    o    m  (~  
  ~(~  
Qp    ~ف    7҆7.y  x  .y  x  ҆  s    ]t  ]tscF*    cF*  u  @.J  3@.J  3  .J  u    .J    F*  F*    
    u    .J  3  .J  3.J  u  .J  
  A  G  1`  G  b  A?  A?   b   1`  ZG  A  ZG  D  "  E]  "  b  A?  A?  0b  0E]    D    y  z  y  z  Z      T-  8#%  	v  %  =    T      ԕ    ӆ      or  .  Wy    g                  	   B_PAD.PCX            0   :      0         @          0   :                  	   B_PAD.PCX              :      0          0   :         :                  	   B_PAD.PCX           ?         p         O   :      ?                     	   B_PAD.PCX           O         p         ?         O                     
   B_RAMP.PCX                   >        >   
                          
   B_RAMP.PCX                   >   
   	      
                          
   B_RAMP.PCX        
                         
                        
   B_RAMP.PCX        
                 	      
   
                        
   B_RAMP.PCX           >     
   >         >   
      >                    
   B_RAMP.PCX           >        >   
      >        >                    
   B_RAMP.PCX                
         
   >                             
   B_RAMP.PCX                
   >         >                            	   B_PAD.PCX           -          -         .         -                     	   B_PAD.PCX           -         .         .         -                     	   B_PAD.PCX           ,         ,          -         ,                     	   B_PAD.PCX           ,          -         -         ,                     	   B_PAD.PCX           +         +         ,         +                     	   B_PAD.PCX           +         ,         ,         +                     	   B_PAD.PCX           ,         ,         +         ,                     	   B_PAD.PCX           ,         +         +         ,                     	   B_PAD.PCX           -         -         ,         -                     	   B_PAD.PCX           -         ,         ,         -                     	   B_PAD.PCX           .         .         -         .                     	   B_PAD.PCX           .         -         -         .                        BUILD_7.PCX           U   $      
   $        $      U   $                     BUILD_7.PCX             $      
   $      2  $        $                     BUILD_7.PCX             $        $         $        $                     BUILD_7.PCX           U   $      2  $      
   $      U   $                     BUILD_7.PCX                     $         $                             BUILD_7.PCX                   U   $      1                                BUILD_7.PCX           1         U   $        $      1                        BUILD_7.PCX           1           $              1                        BUILD_7.PCX            \        2  $      
   $       \                       BUILD_7.PCX                    M   $   !   #                                 BUILD_7.PCX        "   #         M   $      r  $   "   #                        BUILD_7.PCX        "   #         r  $   #        "   #                     
   BUILD5.PCX        $         %   *      &   7      $                        
   BUILD5.PCX        $         &   7      '         $                        
   BUILD5.PCX        (         )   7      *   *      (                        
   BUILD5.PCX        (         *   *      +         (                        
   BUILD5.PCX        ,        -        .   7      ,                       
   BUILD5.PCX        ,        .   7      /         ,                       
   BUILD5.PCX        0         1   7      2        0                        
   BUILD5.PCX        0         2        3        0                        
   BUILD6.PCX        '         &         1         '                        
   BUILD6.PCX        '         1         0         '                        
   BUILD6.PCX        +   ;      *   ;      %         +   ;                     
   BUILD6.PCX        +   ;      %         $         +   ;                     
   BUILD6.PCX        /         .         )   E      /                        
   BUILD6.PCX        /         )   E      (   E      /                        
   BUILD5.PCX        )   *      .   
      *   J      )   *                     
   BUILD5.PCX        *         .   J      -        *                        
   BUILD5.PCX        *         -         %         *                        
   BUILD5.PCX        %         -         2   +     %                        
   BUILD5.PCX        %   @      2        &   `      %   @                     
   BUILD5.PCX        &   `      2        1         &   `                     
   BUILD5.PCX        /   
      (   *      +   J      /   
                     
   BUILD5.PCX        /   J      +         ,        /   J                     
   BUILD5.PCX        ,         +         $         ,                        
   BUILD5.PCX        ,         $         3   +     ,                        
   BUILD5.PCX        3        $   @      '   `      3                       
   BUILD5.PCX        3        '   `      0         3                       
   BUILD5.PCX        4     M   5   =   M   6   1      4     M                  
   BUILD5.PCX        4     M   6   1      7        4     M                  
   BUILD5.PCX        8        9   1      :   =   M   8                       
   BUILD5.PCX        8        :   =   M   ;     M   8                       
   BUILD5.PCX        <         =   O      >   1      <                        
   BUILD5.PCX        <         >   1      ?        <                        
   BUILD5.PCX        @        A   1      B   O      @                       
   BUILD5.PCX        @         B         C         @                        
   BUILD6.PCX        ;   /   >   :   /      5         ;   /   >                  
   BUILD6.PCX        ;   /   >   5         4      >   ;   /   >                  
   BUILD6.PCX        C   6   9   B   6      =         C   6   9                  
   BUILD6.PCX        C   6   9   =         <      9   C   6   9                  
   BUILD5.PCX        9         >         :   P   M   9                        
   BUILD5.PCX        :   P      >         =         :   P                     
   BUILD5.PCX        :         =         5   /      :                        
   BUILD5.PCX        5   o      =   $     B         5   o                     
   BUILD5.PCX        5   o      B         6   4      5   o                     
   BUILD5.PCX        6   t      B   \      A   :      6   t                     
   BUILD5.PCX        ?         8         ;   P   M   ?                        
   BUILD5.PCX        ?         ;   P      <         ?                        
   BUILD5.PCX        <         ;         4   /      <                        
   BUILD5.PCX        <   $     4   o      C         <   $                    
   BUILD5.PCX        C         4   o      7   4      C                        
   BUILD5.PCX        C   \      7   t      @   :      C   \                        BUILD_7.PCX             $        $         $        $                     BUILD_7.PCX           V   $      0  $         $      V   $                     BUILD_7.PCX           V   $         $        $      V   $                     BUILD_7.PCX             $         $      0  $        $                     BUILD_7.PCX           2         V   $        $      2                        BUILD_7.PCX           2           $      
        2                        BUILD_7.PCX                     $         $                             BUILD_7.PCX           
        V   $      2         
                       BUILD_7.PCX        !   %         O   $      p  $   !   %                        BUILD_7.PCX        !   %         p  $   "        !   %                        BUILD_7.PCX        #   Z        0  $         $   #   Z                       BUILD_7.PCX        #           O   $       %      #                          B_FLOOR.PCX        D   y     E   y   y   F     y   D   y                       B_FLOOR.PCX        D   y     F     y   G       D   y           @ANIMATE-XPL5,0,-5                     H   t   I   5   A   J      @   K         H   lີ      @ANIMATE-XPLG1,0,-1                     L       M   5       N   D   D   O          L                @ANIMATE-XPLG2,0,-5                     P   D   Q   9   C   R   H       S          P   ̸        j
       DEFAULT.PAL    MAIN             o   c    _0     
     6=     c B  _0  B  
  B  6=  B        9      B  B  9B  B  
 ƋB  
 Ƌ   *           ȶ   
 ƋB  * B    B    ȶB     S      $  L   =P   B  S   B  $  LB  =PB  F  O  A      -      ƩRx      EX      A  (  -  (  ƩRx  (  EX  (  2>    g&<          b      2>(  g&<(    (  b  (    =N    O                =N(  O(  (    (    O  O          U  'x  O  U    O  U  'x     U         O  ǩQx  O       ǩQx     ^  O  kU  ƙ  &0  O  vFm  ƙ    O  Zv  ƙ  -  
  O    /m  ƙ  I  Y^  O  ,  EU  ƙ  H  .  O  ,  7  ƙ  ,    O  ~    ƙ  ZKO  f  ƙ  !  O  .  O  V  ƙ  7  ƙ  zF     k        P    U        V  4      k  (    P(  U    (  V  4  (  G       p    n   Z8y      [  S  )[  A;[  
x  [  "  %  4 
%  :%  ZXV %  {                     4XNB_01.PCX           @         ?   ?               @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?                	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                   ?                     4XNB_02.PCX                        ?                                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_01.PCX           @         ?   ?   
            @                        4XNB_01.PCX        
            ?   ?         ?   
                           4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX        
      ?         ?   	         
      ?                     4XNB_02.PCX        	               ?   
         	                           4XNB_02.PCX              ?   
      ?                  ?                     4XNB_02.PCX                 
      ?   	                                    4XNB_02.PCX              ?         ?   
               ?                     4XNB_02.PCX        
               ?            
                           4XNB_01.PCX           @         ?   ?               @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_01.PCX           @          ?   ?               @                        4XNB_01.PCX                     ?   ?         ?                              4XNB_02.PCX            	   ?         ?      	          	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?          ?                  ?                     4XNB_02.PCX                        ?                                       4XNB_02.PCX        B   b      !           ;          B   b                        4XNB_02.PCX        C         !   `       B         C                           4XNB_02.PCX        :         !          C   \      :                           4XNB_02.PCX        >   ]   +   !         :         >   ]   +                     4XNB_02.PCX        ?      ,   !   `      >      +   ?      ,                     4XNB_02.PCX        ;         !          ?   c   ,   ;                           4XNB_02.PCX        )     ?   &      ?   '          )     ?                     4XNB_02.PCX        )     ?   '          (   z      )     ?                     4XNB_02.PCX        '   ?       &           "       ?   '   ?                         4XNB_02.PCX        '   ?       "       ?   #   ?   ?   '   ?                         4XNB_02.PCX        &          )         %     ?   &                            4XNB_02.PCX        &          %     ?   "      ?   &                            4XNB_02.PCX        (   z      '          #      ?   (   z                        4XNB_02.PCX        (   z      #      ?   $   z  ?   (   z                        4XNB_02.PCX        1     ?   .      ?   /          1     ?                     4XNB_02.PCX        1     ?   /          0   z      1     ?                     4XNB_02.PCX        /   ?       .           *       ?   /   ?                         4XNB_02.PCX        /   ?       *       ?   +   ?   ?   /   ?                         4XNB_02.PCX        .          1         -     ?   .                            4XNB_02.PCX        .          -     ?   *      ?   .                            4XNB_02.PCX        0   z      /          +      ?   0   z                        4XNB_02.PCX        0   z      +      ?   ,   z  ?   0   z                        4XNB_02.PCX        9     ?   6      ?   7          9     ?                     4XNB_02.PCX        9     ?   7          8   z      9     ?                     4XNB_02.PCX        7   ?       6           2       ?   7   ?                         4XNB_02.PCX        7   ?       2       ?   3   ?   ?   7   ?                         4XNB_02.PCX        6          9         5     ?   6                            4XNB_02.PCX        6          5     ?   2      ?   6                            4XNB_02.PCX        8   z      7          3      ?   8   z                        4XNB_02.PCX        8   z      3      ?   4   z  ?   8   z                        RC02_02.PCX        D      z   B      6   ;      6   D      z                     RC02_02.PCX        D      z   ;      6   =      z   D      z                     RC02_02.PCX        @      z   >      6   :   5   6   @      z                     RC02_02.PCX        @      z   :   5   6   <   5   z   @      z                     RC02_02.PCX        <   2   z   :   2   6   C      6   <   2   z                     RC02_02.PCX        <   2   z   C      6   E      z   <   2   z                     RC02_02.PCX        =      z   ;      6   ?      6   =      z                     RC02_02.PCX        =      z   ?      6   A      z   =      z                     RC02_02.PCX        A      z   ?      6   >       6   A      z                     RC02_02.PCX        A      z   >       6   @       z   A      z                     RC02_02.PCX        E       z   C       6   B      6   E       z                     RC02_02.PCX        E       z   B      6   D      z   E       z                     4XNB_01.PCX        G          Y   5       W   D   D   G                            4XNB_01.PCX        G   H       W      D   F   9   C   G   H                         4XNB_01.PCX        Z         Y   5   @   G      @   Z                           4XNB_01.PCX        I          G   6       F   D   C   I                            4XNB_01.PCX        I   H       F      C   H   :   D   I   H                         4XNB_01.PCX        Z         G   6   @   I      @   Z                           4XNB_01.PCX        K          I   6       H   D   C   K                            4XNB_01.PCX        K   H       H      C   J   :   D   K   H                         4XNB_01.PCX        Z         I   6   @   K      @   Z                           4XNB_01.PCX        M          K   6       J   D   C   M                            4XNB_01.PCX        M   H       J      C   L   :   D   M   H                         4XNB_01.PCX        Z         K   6   @   M      @   Z                           4XNB_01.PCX        O          M   5       L   D   D   O                            4XNB_01.PCX        O   H       L      D   N   9   C   O   H                         4XNB_01.PCX        Z         M   5   @   O      @   Z                           4XNB_01.PCX        Q          O   5      N   C   D   Q                            4XNB_01.PCX        Q   G       N      D   P   9   C   Q   G                         4XNB_01.PCX        Z         O   5   A   Q      @   Z                           4XNB_01.PCX        S          Q   5       P   D   D   S                            4XNB_01.PCX        S   H       P      D   R   9   C   S   H                         4XNB_01.PCX        Z         Q   5   @   S      @   Z                           4XNB_01.PCX        U          S   6       R   D   C   U                            4XNB_01.PCX        U   H       R      C   T   :   D   U   H                         4XNB_01.PCX        Z         S   6   @   U      @   Z                           4XNB_01.PCX        X          U   5       T   D   D   X                            4XNB_01.PCX        X   H       T      D   V   9   C   X   H                         4XNB_01.PCX        Z         U   5   @   X      @   Z                           4XNB_01.PCX        Y   	       X   7       V   E   C   Y   	                         4XNB_01.PCX        Y   I       V      C   W   ;   C   Y   I                         4XNB_01.PCX        Z          X   7   @   Y   	   @   Z                            4XNB_02.PCX        b     ?   _      ?   `          b     ?                     4XNB_02.PCX        b     ?   `          a   z      b     ?                     4XNB_02.PCX        `   ?       _           [       ?   `   ?                         4XNB_02.PCX        `   ?       [       ?   \   ?   ?   `   ?                         4XNB_02.PCX        _          b         ^     ?   _                            4XNB_02.PCX        _          ^     ?   [      ?   _                            4XNB_02.PCX        a   z      `          \      ?   a   z                        4XNB_02.PCX        a   z      \      ?   ]   z  ?   a   z            @ANIMATE-XPLG1,0,-1                     c   |յ   d         e           f           c                 @ANIMATE-XPL5,0,-5                     g   |յ|ɵh         i           j           g                 @ANIMATE-XPLG2,0,-5                     k   |յ(`l   |յ   m           n   @ɵ    k               j
       DEFAULT.PAL    MAIN             y   5        c  p      6m    a    5    x6  c  p  x6  6mx6  ax6  = X  Dw Ds'   = '   4 *'     J'   Dw DsX  = X  4 *X    JX  avj  avj  xa!vj  a   xa!   
  Lvj  
  ,vj  
  L   
  ,   Zvj  ZLvj  Z   ZL    j     Hfj  (D6  0awj  alH   ej  76  kj  ػC  j  8  kj    `NNj  `Z  kj  [j  (    `  "     k Z    
  ,    ,  F    " x6  k Zx6  
  ,x6  ,  Fx6  s '   HV* '   
 '   p8 '   s X  HV* X  
 X  p8 X     vj  (     m     z     *:     ( x6  m x6  z x6  *: x6     vj    'P  vj          'P      J Ez vj  I j  vj   J Ez    I j     c  vj  z vj  c     z    	
  #G j  )B  4   QB  V j  d  d   9   j     v   	  
 j  @  Td   0 F j    4   /    j    v        j           |  j  ќ      A  8  j  	    j  d      B        !   L v  _  f* _  F=_  6 _    k  | Hk  U>  k   k  ? r F   %F  LBHF  o F                       4XNB_02.PCX             ?         ?                  ?                     4XNB_02.PCX             ?                z           ?                     4XNB_02.PCX           ?                          ?      ?                         4XNB_02.PCX           ?               ?      ?   ?      ?                         4XNB_02.PCX                                ?                               4XNB_02.PCX                       ?          ?                               4XNB_02.PCX           z                      ?      z                        4XNB_02.PCX           z            ?      z  ?      z                        4XNB_01.PCX        
   @         ?   ?            
   @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?   
      ?      	         	   ?                     4XNB_02.PCX           	      
      ?   	            	                        4XNB_02.PCX              ?         ?   
               ?                     4XNB_02.PCX        
               ?            
                           4XNB_02.PCX        
      ?         ?   	         
      ?                     4XNB_02.PCX        	               ?   
         	                           4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX           b                              b                        4XNB_02.PCX                    `                                           4XNB_02.PCX                              \                                 4XNB_02.PCX           ]   +                        ]   +                     4XNB_02.PCX              ,      `            +         ,                     4XNB_02.PCX                              c   ,                              RC02_02.PCX              z         6         6         z                     RC02_02.PCX              z         6         z         z                     RC02_02.PCX              z         6      5   6         z                     RC02_02.PCX              z      5   6      5   z         z                     RC02_02.PCX           2   z      2   6         6      2   z                     RC02_02.PCX           2   z         6         z      2   z                     RC02_02.PCX              z         6         6         z                     RC02_02.PCX              z         6         z         z                     RC02_02.PCX              z         6          6         z                     RC02_02.PCX              z          6          z         z                     RC02_02.PCX               z          6         6          z                     RC02_02.PCX               z         6         z          z                     4XNB_01.PCX                  1   5       /   D   D                               4XNB_01.PCX           H       /      D      9   C      H                         4XNB_01.PCX        2         1   5   @         @   2                           4XNB_01.PCX        !             6          D   C   !                            4XNB_01.PCX        !   H             C       :   D   !   H                         4XNB_01.PCX        2            6   @   !      @   2                           4XNB_01.PCX        #          !   6           D   C   #                            4XNB_01.PCX        #   H              C   "   :   D   #   H                         4XNB_01.PCX        2         !   6   @   #      @   2                           4XNB_01.PCX        %          #   6       "   D   C   %                            4XNB_01.PCX        %   H       "      C   $   :   D   %   H                         4XNB_01.PCX        2         #   6   @   %      @   2                           4XNB_01.PCX        '          %   5       $   D   D   '                            4XNB_01.PCX        '   H       $      D   &   9   C   '   H                         4XNB_01.PCX        2         %   5   @   '      @   2                           4XNB_01.PCX        )          '   5      &   C   D   )                            4XNB_01.PCX        )   G       &      D   (   9   C   )   G                         4XNB_01.PCX        2         '   5   A   )      @   2                           4XNB_01.PCX        +          )   5       (   D   D   +                            4XNB_01.PCX        +   H       (      D   *   9   C   +   H                         4XNB_01.PCX        2         )   5   @   +      @   2                           4XNB_01.PCX        -          +   6       *   D   C   -                            4XNB_01.PCX        -   H       *      C   ,   :   D   -   H                         4XNB_01.PCX        2         +   6   @   -      @   2                           4XNB_01.PCX        0          -   5       ,   D   D   0                            4XNB_01.PCX        0   H       ,      D   .   9   C   0   H                         4XNB_01.PCX        2         -   5   @   0      @   2                           4XNB_01.PCX        1   	       0   7       .   E   C   1   	                         4XNB_01.PCX        1   I       .      C   /   ;   C   1   I                         4XNB_01.PCX        2          0   7   @   1   	   @   2                            4XNB_02.PCX        :     ?   7      ?   8          :     ?                     4XNB_02.PCX        :     ?   8          9   z      :     ?                     4XNB_02.PCX        8   ?       7           3       ?   8   ?                         4XNB_02.PCX        8   ?       3       ?   4   ?   ?   8   ?                         4XNB_02.PCX        7          :         6     ?   7                            4XNB_02.PCX        7          6     ?   3      ?   7                            4XNB_02.PCX        9   z      8          4      ?   9   z                        4XNB_02.PCX        9   z      4      ?   5   z  ?   9   z                        4XNB_01.PCX        ?   @      B   ?   ?   @         ?   @                        4XNB_01.PCX        @         B   ?   ?   A      ?   @                           4XNB_02.PCX        B   	   ?   ?      ?   >   	      B   	   ?                     4XNB_02.PCX        >   	      ?      ?   ;         >   	                        4XNB_02.PCX        @      ?   A      ?   <         @      ?                     4XNB_02.PCX        <         A      ?   =         <                           4XNB_02.PCX        ?      ?   @      ?   ;         ?      ?                     4XNB_02.PCX        ;         @      ?   <         ;                           4XNB_02.PCX        A      ?   B      ?   =         A      ?                     4XNB_02.PCX        =         B      ?   >         =                           4XNB_02.PCX        T   b      C           M          T   b                        4XNB_02.PCX        U         C   `       T         U                           4XNB_02.PCX        L         C          U   \      L                           4XNB_02.PCX        P   ]   +   C         L         P   ]   +                     4XNB_02.PCX        Q      ,   C   `      P      +   Q      ,                     4XNB_02.PCX        M         C          Q   c   ,   M                           4XNB_02.PCX        K     ?   H      ?   I          K     ?                     4XNB_02.PCX        K     ?   I          J   z      K     ?                     4XNB_02.PCX        I   ?       H           D       ?   I   ?                         4XNB_02.PCX        I   ?       D       ?   E   ?   ?   I   ?                         4XNB_02.PCX        H          K         G     ?   H                            4XNB_02.PCX        H          G     ?   D      ?   H                            4XNB_02.PCX        J   z      I          E      ?   J   z                        4XNB_02.PCX        J   z      E      ?   F   z  ?   J   z                        RC02_02.PCX        V      z   T      6   M      6   V      z                     RC02_02.PCX        V      z   M      6   O      z   V      z                     RC02_02.PCX        R      z   P      6   L   5   6   R      z                     RC02_02.PCX        R      z   L   5   6   N   5   z   R      z                     RC02_02.PCX        N   2   z   L   2   6   U      6   N   2   z                     RC02_02.PCX        N   2   z   U      6   W      z   N   2   z                     RC02_02.PCX        O      z   M      6   Q      6   O      z                     RC02_02.PCX        O      z   Q      6   S      z   O      z                     RC02_02.PCX        S      z   Q      6   P       6   S      z                     RC02_02.PCX        S      z   P       6   R       z   S      z                     RC02_02.PCX        W       z   U       6   T      6   W       z                     RC02_02.PCX        W       z   T      6   V      z   W       z                     4XNB_01.PCX        Y          k   5       i   D   D   Y                            4XNB_01.PCX        Y   H       i      D   X   9   C   Y   H                         4XNB_01.PCX        l         k   5   @   Y      @   l                           4XNB_01.PCX        [          Y   6       X   D   C   [                            4XNB_01.PCX        [   H       X      C   Z   :   D   [   H                         4XNB_01.PCX        l         Y   6   @   [      @   l                           4XNB_01.PCX        ]          [   6       Z   D   C   ]                            4XNB_01.PCX        ]   H       Z      C   \   :   D   ]   H                         4XNB_01.PCX        l         [   6   @   ]      @   l                           4XNB_01.PCX        _          ]   6       \   D   C   _                            4XNB_01.PCX        _   H       \      C   ^   :   D   _   H                         4XNB_01.PCX        l         ]   6   @   _      @   l                           4XNB_01.PCX        a          _   5       ^   D   D   a                            4XNB_01.PCX        a   H       ^      D   `   9   C   a   H                         4XNB_01.PCX        l         _   5   @   a      @   l                           4XNB_01.PCX        c          a   5      `   C   D   c                            4XNB_01.PCX        c   G       `      D   b   9   C   c   G                         4XNB_01.PCX        l         a   5   A   c      @   l                           4XNB_01.PCX        e          c   5       b   D   D   e                            4XNB_01.PCX        e   H       b      D   d   9   C   e   H                         4XNB_01.PCX        l         c   5   @   e      @   l                           4XNB_01.PCX        g          e   6       d   D   C   g                            4XNB_01.PCX        g   H       d      C   f   :   D   g   H                         4XNB_01.PCX        l         e   6   @   g      @   l                           4XNB_01.PCX        j          g   5       f   D   D   j                            4XNB_01.PCX        j   H       f      D   h   9   C   j   H                         4XNB_01.PCX        l         g   5   @   j      @   l                           4XNB_01.PCX        k   	       j   7       h   E   C   k   	                         4XNB_01.PCX        k   I       h      C   i   ;   C   k   I                         4XNB_01.PCX        l          j   7   @   k   	   @   l                @ANIMATE-XPLG2,0,-5                     m   (`tٵn          o           p       P   m      |        @ANIMATE-XPLG1,0,-1                     q   (`    r       Яs           t   P   |յq     h         @ANIMATE-XPL5,0,-5                     u   (`    v       w           x   |յ(`u   i          j
       DEFAULT.PAL    MAIN             p   
C  >       [     
C  >  .;    [  .;  7       Cj       7    .;  Cj    .;  uZ     =     uZ  .;  =  .;  #          #  .;    .;  
C  ]     2   
C  ].;    2.;  7  Ca   Cj  n~   7  Ca.;  Cj  n~.;        .;  .;  #e   sb   #e.;  sb.;  κ     _     u_     6     Ϻ  .;  _  .;  u_  .;  6  .;  
 1E.;    .;  
 1E   * u          4p   
 1E.;  * u.;    .;    4p.;  F  Ak      -'      Ʃ1            Ak  P$  -'  P$  Ʃ1  P$    P$  ^c  F  F  ^c        U  1  F  U  %F  U  1     U  %   OF  ǩ1  F  O   ǩ1       G      &>  G  v&    KM  G  /    -  u>  G    &    I    G  ,      H   G  ,  +  ,  fG  ~  P  ZG  f<  G  =G  Vg  P  z   ơ  k  ^      }    U  %    V  2    k  ^P$    }P$  U  %P$  V  2P$  }    M  s  ^3M  ;;=M   M  ~e v  5  [ 5  5  ٟS  5    G Y  qE *BY  ?<Y  ū  Y  w                     4XNB_01.PCX           ?   ?      @                  ?   ?                     4XNB_01.PCX           ?   ?                  ?      ?   ?                     4XNB_02.PCX              ?      	   ?      	            ?                     4XNB_02.PCX              ?      	                     ?                     4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX              ?                            ?                     4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX              ?                           ?                     4XNB_01.PCX           ?   ?      @                  ?   ?                     4XNB_01.PCX           ?   ?            
      ?      ?   ?                     4XNB_02.PCX              ?      	   ?   	   	            ?                     4XNB_02.PCX              ?   	   	                     ?                     4XNB_02.PCX        
      ?         ?   
         
      ?                     4XNB_02.PCX        
      ?   
                  
      ?                     4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX              ?            
               ?                     4XNB_01.PCX           @         ?   ?               @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_01.PCX           @         ?   ?               @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_01.PCX        $   @      '   ?   ?   %         $   @                        4XNB_01.PCX        %         '   ?   ?   &      ?   %                           4XNB_02.PCX        '   	   ?   $      ?   #   	      '   	   ?                     4XNB_02.PCX        #   	      $      ?             #   	                        4XNB_02.PCX        %      ?   &      ?   !         %      ?                     4XNB_02.PCX        !         &      ?   "         !                           4XNB_02.PCX        $      ?   %      ?             $      ?                     4XNB_02.PCX                  %      ?   !                                     4XNB_02.PCX        &      ?   '      ?   "         &      ?                     4XNB_02.PCX        "         '      ?   #         "                           4XNB_01.PCX        (   @      1   ?   ?   /         (   @                        4XNB_01.PCX        /         1   ?   ?   )      ?   /                           4XNB_02.PCX        1   	   ?   .      ?   -   	      1   	   ?                     4XNB_02.PCX        -   	      .      ?   *         -   	                        4XNB_02.PCX        /      ?   0      ?   +         /      ?                     4XNB_02.PCX        +         0      ?   ,         +                           4XNB_02.PCX        .      ?   /      ?   *         .      ?                     4XNB_02.PCX        *         /      ?   +         *                           4XNB_02.PCX        0      ?   1      ?   ,         0      ?                     4XNB_02.PCX        ,         1      ?   -         ,                           4XNB_02.PCX        C   b      2           <          C   b                        4XNB_02.PCX        D         2   `       C         D                           4XNB_02.PCX        ;         2          D   \      ;                           4XNB_02.PCX        ?   ]   +   2         ;         ?   ]   +                     4XNB_02.PCX        @      ,   2   `      ?      +   @      ,                     4XNB_02.PCX        <         2          @   c   ,   <                           4XNB_02.PCX        :     ?   7      ?   8          :     ?                     4XNB_02.PCX        :     ?   8          9   z      :     ?                     4XNB_02.PCX        8   ?       7           3       ?   8   ?                         4XNB_02.PCX        8   ?       3       ?   4   ?   ?   8   ?                         4XNB_02.PCX        7          :         6     ?   7                            4XNB_02.PCX        7          6     ?   3      ?   7                            4XNB_02.PCX        9   z      8          4      ?   9   z                        4XNB_02.PCX        9   z      4      ?   5   z  ?   9   z                        RC02_02.PCX        E      z   C      6   <      6   E      z                     RC02_02.PCX        E      z   <      6   >      z   E      z                     RC02_02.PCX        A      z   ?      6   ;   5   6   A      z                     RC02_02.PCX        A      z   ;   5   6   =   5   z   A      z                     RC02_02.PCX        =   2   z   ;   2   6   D      6   =   2   z                     RC02_02.PCX        =   2   z   D      6   F      z   =   2   z                     RC02_02.PCX        >      z   <      6   @      6   >      z                     RC02_02.PCX        >      z   @      6   B      z   >      z                     RC02_02.PCX        B      z   @      6   ?       6   B      z                     RC02_02.PCX        B      z   ?       6   A       z   B      z                     RC02_02.PCX        F       z   D       6   C      6   F       z                     RC02_02.PCX        F       z   C      6   E      z   F       z                     4XNB_01.PCX        H          Z   5       X   D   D   H                            4XNB_01.PCX        H   H       X      D   G   9   C   H   H                         4XNB_01.PCX        [         Z   5   @   H      @   [                           4XNB_01.PCX        J          H   6       G   D   C   J                            4XNB_01.PCX        J   H       G      C   I   :   D   J   H                         4XNB_01.PCX        [         H   6   @   J      @   [                           4XNB_01.PCX        L          J   6       I   D   C   L                            4XNB_01.PCX        L   H       I      C   K   :   D   L   H                         4XNB_01.PCX        [         J   6   @   L      @   [                           4XNB_01.PCX        N          L   6       K   D   C   N                            4XNB_01.PCX        N   H       K      C   M   :   D   N   H                         4XNB_01.PCX        [         L   6   @   N      @   [                           4XNB_01.PCX        P          N   5       M   D   D   P                            4XNB_01.PCX        P   H       M      D   O   9   C   P   H                         4XNB_01.PCX        [         N   5   @   P      @   [                           4XNB_01.PCX        R          P   5      O   C   D   R                            4XNB_01.PCX        R   G       O      D   Q   9   C   R   G                         4XNB_01.PCX        [         P   5   A   R      @   [                           4XNB_01.PCX        T          R   5       Q   D   D   T                            4XNB_01.PCX        T   H       Q      D   S   9   C   T   H                         4XNB_01.PCX        [         R   5   @   T      @   [                           4XNB_01.PCX        V          T   6       S   D   C   V                            4XNB_01.PCX        V   H       S      C   U   :   D   V   H                         4XNB_01.PCX        [         T   6   @   V      @   [                           4XNB_01.PCX        Y          V   5       U   D   D   Y                            4XNB_01.PCX        Y   H       U      D   W   9   C   Y   H                         4XNB_01.PCX        [         V   5   @   Y      @   [                           4XNB_01.PCX        Z   	       Y   7       W   E   C   Z   	                         4XNB_01.PCX        Z   I       W      C   X   ;   C   Z   I                         4XNB_01.PCX        [          Y   7   @   Z   	   @   [                            4XNB_02.PCX        c     ?   `      ?   a          c     ?                     4XNB_02.PCX        c     ?   a          b   z      c     ?                     4XNB_02.PCX        a   ?       `           \       ?   a   ?                         4XNB_02.PCX        a   ?       \       ?   ]   ?   ?   a   ?                         4XNB_02.PCX        `          c         _     ?   `                            4XNB_02.PCX        `          _     ?   \      ?   `                            4XNB_02.PCX        b   z      a          ]      ?   b   z                        4XNB_02.PCX        b   z      ]      ?   ^   z  ?   b   z            @ANIMATE-XPLG2,0,-5                     d   |յ   e           f   q    g           d   |ɵ,յ      @ANIMATE-XPL5,0,-5                     h   |յ    i   q    j           k   |ɵ,յh   [   6         @ANIMATE-XPLG1,0,-1                     l   |յ    m           n   |ɵ,յo   Z      l   \   :       j
       DEFAULT.PAL    MAIN             X   .( lF  ^( 2  F  ' +F  ^( 2     ' +   | IF  L nF  | I   L n   {  F  |  F  {     |       'G    щ    ZG  n    '   G  '    G  _ X   G  ^   e $<G  E zN   G  }_   6' G  N'   f  <G  ^  <G  .      N  u' %lš    F  Z F   F  Z        !>  F  c0  F  !>     c0     +0  F  +  F  +0     +     *D  G  J|ű    r|O G  |    Z. G  A    *2 G  aM    1j  G  2z    
jd  G  1ov    1  G  !F    G  4    
|1  G  Dd  G  ҞF    2|v      š  {      {      c0      V}p      {  P$  {  P$  c0  P$  V}p  P$     &I  X  U&I  à&I  b" &I  O 3  &I   ,&I  u&I  Q  &I  ;X  m  # _m  ŧw;m  /c m  k                     4XNB_02.PCX        	   b                            	   b                        4XNB_02.PCX        
             `       	         
                           4XNB_02.PCX                            
   \                                 4XNB_02.PCX           ]   +                         ]   +                     4XNB_02.PCX              ,       `            +         ,                     4XNB_02.PCX                               c   ,                              RC02_02.PCX              z   	      6         6         z                     RC02_02.PCX              z         6         z         z                     RC02_02.PCX              z         6      5   6         z                     RC02_02.PCX              z      5   6      5   z         z                     RC02_02.PCX           2   z      2   6   
      6      2   z                     RC02_02.PCX           2   z   
      6         z      2   z                     RC02_02.PCX              z         6         6         z                     RC02_02.PCX              z         6         z         z                     RC02_02.PCX              z         6          6         z                     RC02_02.PCX              z          6          z         z                     RC02_02.PCX               z   
       6   	      6          z                     RC02_02.PCX               z   	      6         z          z                     4XNB_01.PCX                      5          D   D                               4XNB_01.PCX           H             D   
   9   C      H                         4XNB_01.PCX        !             5   @         @   !                           4XNB_01.PCX                     6       
   D   C                               4XNB_01.PCX           H       
      C      :   D      H                         4XNB_01.PCX        !            6   @         @   !                           4XNB_01.PCX                     6          D   C                               4XNB_01.PCX           H             C      :   D      H                         4XNB_01.PCX        !            6   @         @   !                           4XNB_01.PCX                     6          D   C                               4XNB_01.PCX           H             C      :   D      H                         4XNB_01.PCX        !            6   @         @   !                           4XNB_01.PCX                     5          D   D                               4XNB_01.PCX           H             D      9   C      H                         4XNB_01.PCX        !            5   @         @   !                           4XNB_01.PCX                     5         C   D                               4XNB_01.PCX           G             D      9   C      G                         4XNB_01.PCX        !            5   A         @   !                           4XNB_01.PCX                     5          D   D                               4XNB_01.PCX           H             D      9   C      H                         4XNB_01.PCX        !            5   @         @   !                           4XNB_01.PCX                     6          D   C                               4XNB_01.PCX           H             C      :   D      H                         4XNB_01.PCX        !            6   @         @   !                           4XNB_01.PCX                     5          D   D                               4XNB_01.PCX           H             D      9   C      H                         4XNB_01.PCX        !            5   @         @   !                           4XNB_01.PCX            	          7          E   C       	                         4XNB_01.PCX            I             C      ;   C       I                         4XNB_01.PCX        !             7   @       	   @   !                            4XNB_02.PCX        +   b      "           $          +   b                        4XNB_02.PCX        ,         "   `       +         ,                           4XNB_02.PCX        #         "          ,   \      #                           4XNB_02.PCX        '   ]   +   "         #         '   ]   +                     4XNB_02.PCX        (      ,   "   `      '      +   (      ,                     4XNB_02.PCX        $         "          (   c   ,   $                           RC02_02.PCX        -      z   +      6   $      6   -      z                     RC02_02.PCX        -      z   $      6   &      z   -      z                     RC02_02.PCX        )      z   '      6   #   5   6   )      z                     RC02_02.PCX        )      z   #   5   6   %   5   z   )      z                     RC02_02.PCX        %   2   z   #   2   6   ,      6   %   2   z                     RC02_02.PCX        %   2   z   ,      6   .      z   %   2   z                     RC02_02.PCX        &      z   $      6   (      6   &      z                     RC02_02.PCX        &      z   (      6   *      z   &      z                     RC02_02.PCX        *      z   (      6   '       6   *      z                     RC02_02.PCX        *      z   '       6   )       z   *      z                     RC02_02.PCX        .       z   ,       6   +      6   .       z                     RC02_02.PCX        .       z   +      6   -      z   .       z                     4XNB_01.PCX        0          B   5       @   D   D   0                            4XNB_01.PCX        0   H       @      D   /   9   C   0   H                         4XNB_01.PCX        C         B   5   @   0      @   C                           4XNB_01.PCX        2          0   6       /   D   C   2                            4XNB_01.PCX        2   H       /      C   1   :   D   2   H                         4XNB_01.PCX        C         0   6   @   2      @   C                           4XNB_01.PCX        4          2   6       1   D   C   4                            4XNB_01.PCX        4   H       1      C   3   :   D   4   H                         4XNB_01.PCX        C         2   6   @   4      @   C                           4XNB_01.PCX        6          4   6       3   D   C   6                            4XNB_01.PCX        6   H       3      C   5   :   D   6   H                         4XNB_01.PCX        C         4   6   @   6      @   C                           4XNB_01.PCX        8          6   5       5   D   D   8                            4XNB_01.PCX        8   H       5      D   7   9   C   8   H                         4XNB_01.PCX        C         6   5   @   8      @   C                           4XNB_01.PCX        :          8   5      7   C   D   :                            4XNB_01.PCX        :   G       7      D   9   9   C   :   G                         4XNB_01.PCX        C         8   5   A   :      @   C                           4XNB_01.PCX        <          :   5       9   D   D   <                            4XNB_01.PCX        <   H       9      D   ;   9   C   <   H                         4XNB_01.PCX        C         :   5   @   <      @   C                           4XNB_01.PCX        >          <   6       ;   D   C   >                            4XNB_01.PCX        >   H       ;      C   =   :   D   >   H                         4XNB_01.PCX        C         <   6   @   >      @   C                           4XNB_01.PCX        A          >   5       =   D   D   A                            4XNB_01.PCX        A   H       =      D   ?   9   C   A   H                         4XNB_01.PCX        C         >   5   @   A      @   C                           4XNB_01.PCX        B   	       A   7       ?   E   C   B   	                         4XNB_01.PCX        B   I       ?      C   @   ;   C   B   I                         4XNB_01.PCX        C          A   7   @   B   	   @   C                            4XNB_02.PCX        K     ?   H      ?   I          K     ?                     4XNB_02.PCX        K     ?   I          J   z      K     ?                     4XNB_02.PCX        I   ?       H           D       ?   I   ?                         4XNB_02.PCX        I   ?       D       ?   E   ?   ?   I   ?                         4XNB_02.PCX        H          K         G     ?   H                            4XNB_02.PCX        H          G     ?   D      ?   H                            4XNB_02.PCX        J   z      I          E      ?   J   z                        4XNB_02.PCX        J   z      E      ?   F   z  ?   J   z            @ANIMATE-XPLG2,0,-5                     L   µ   M           N   q    O           L   ŵ      @ANIMATE-XPLG1,0,-1                     P   Ƶ   Q           R   q    S           P   ŵ      @ANIMATE-XPL5,0,-5                     T   Ƶ    U   q    V           W   µŵT   V   5       j
       DEFAULT.PAL    MAIN             H   V  ~   r  ~   f  ~   V  ~   V  !  h  !  n  !  V  !  V  8  ~   r  8  ~   f     ~   V     ~   V  8  !  h  r8  !  n     !  V     !  V  ,J      ,J      .   V  .   V  ,J  9   ,J  9   .9  V  .9  Қ  ~   X  ~   X  ~   @  ~   Қ  !  X  !  X  !  @  !  r            X            r  o<    o<  X  o<    o<  0e~   *F~   3R~   2e~   0e!  8P!  3H!  2e!      `"e    \sd    s    o<  `"eo<  \sdo<  so<  $j   $X     J  X     J  j   $j9  $X  9  J  X  9  J  j9       ;G  Mu  B+       Z;  2 "Z;  |Z;  J  Z;  B                  	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8           *  ?      *                     	   NP_03.PCX            *  ?      8          :   ?       *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                  	   NP_01.PCX                    ?      
                                 	   NP_01.PCX        
            ?         ?      
                        	   NP_03.PCX           *      
   8          *  ?      *                     	   NP_03.PCX           *  ?   
   8       	   :   ?      *  ?                  	   NP_03.PCX           ,                 
   .   ?      ,                      	   NP_03.PCX        
   .   ?                   ?   
   .   ?                     RC01_02.PCX                                  >                                RC01_02.PCX           @             >      ?   <      @                         RC01_01.PCX           /                       ?      /                         RC01_01.PCX           /             ?      /   ?      /                         RC01_01.PCX           Z          
          
   ?      Z                         RC01_01.PCX           Z          
   ?      Z   ?      Z                         RC01_01.PCX                                    ?                               RC01_01.PCX                         ?         ?                               RC01_01.PCX           =                       ?      =                         RC01_01.PCX           =             ?      =   ?      =                      	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8          *  ?      *                     	   NP_03.PCX           *  ?      8          :   ?      *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                     RC01_02.PCX        $   @   @   '       ?   %   @      $   @   @                     RC01_02.PCX        %   @      '       ?   &          %   @                        RC01_01.PCX        '   (   !   $   }   !   #   (   @   '   (   !                     RC01_01.PCX        #   (   @   $   }   !       }   @   #   (   @                     RC01_01.PCX        %   }   !   &   '   !   !   }   @   %   }   !                     RC01_01.PCX        !   }   @   &   '   !   "   '   @   !   }   @                     RC01_01.PCX        $   ?   !   %       !       ?   @   $   ?   !                     RC01_01.PCX            ?   @   %       !   !       @       ?   @                     RC01_01.PCX        &       !   '   @   !   "       @   &       !                     RC01_01.PCX        "       @   '   @   !   #   @   @   "       @                  	   NP_01.PCX        /   ?      ,         -         /   ?                     	   NP_01.PCX        /   ?      -         .   ?      /   ?                     	   NP_03.PCX        -   8       ,   *      (   *  ?   -   8                      	   NP_03.PCX        -   8       (   *  ?   )   :   ?   -   8                      	   NP_03.PCX        /          .   ,       *   .   ?   /                         	   NP_03.PCX        /          *   .   ?   +      ?   /                            RC01_02.PCX        7       ?   4   @   @   5   @      7       ?                     RC01_02.PCX        7       ?   5   @      6          7       ?                     RC01_01.PCX        4   }   !   7   (   !   3   (   @   4   }   !                     RC01_01.PCX        4   }   !   3   (   @   0   }   @   4   }   !                     RC01_01.PCX        6   '   !   5   }   !   1   }   @   6   '   !                     RC01_01.PCX        6   '   !   1   }   @   2   '   @   6   '   !                     RC01_01.PCX        5       !   4   ?   !   0   ?   @   5       !                     RC01_01.PCX        5       !   0   ?   @   1       @   5       !                     RC01_01.PCX        7   @   !   6       !   2       @   7   @   !                     RC01_01.PCX        7   @   !   2       @   3   @   @   7   @   !                     RC01_02.PCX        ?           <         =      >   ?                             RC01_02.PCX        ?   @       =      >   >   ?   <   ?   @                         RC01_01.PCX        =   /       <          8      ?   =   /                         RC01_01.PCX        =   /       8      ?   9   /   ?   =   /                         RC01_01.PCX        ?   Z       >   
       :   
   ?   ?   Z                         RC01_01.PCX        ?   Z       :   
   ?   ;   Z   ?   ?   Z                         RC01_01.PCX        <          ?           ;       ?   <                            RC01_01.PCX        <          ;       ?   8      ?   <                            RC01_01.PCX        >   =       =          9      ?   >   =                         RC01_01.PCX        >   =       9      ?   :   =   ?   >   =             @ANIMATE-XPLG1,0,-1                     @   4    A   j       B   4      C   U      @                @ANIMATE-XPL9,0,-2                     D   4   E        F   U      G          D   ة        j
       DEFAULT.PAL    MAIN             X   .( lF  ^( 2  F  ' +F  ^( 2     ' +   | IF  L nF  | I   L n   {  F  |  F  {     |       'G    щ    ZG  n    '   G  '    G  _ X   G  ^   e $<G  E zN   G  }_   6' G  N'   f  <G  ^  <G  .      N  u' %lš    F  Z F   F  Z        !>  F  c0  F  !>     c0     +0  F  +  F  +0     +     *D  G  J|ű    r|O G  |    Z. G  A    *2 G  aM    1j  G  2z    
jd  G  1ov    1  G  !F    G  4    
|1  G  Dd  G  ҞF    2|v      š  {      {      c0      V}p      {  P$  {  P$  c0  P$  V}p  P$     &I  X  U&I  à&I  b" &I  O 3  &I   ,&I  u&I  Q  &I  ;X  m  # _m  ŧw;m  /c m  k                     4XNB_02.PCX        	   b                            	   b                        4XNB_02.PCX        
             `       	         
                           4XNB_02.PCX                            
   \                                 4XNB_02.PCX           ]   +                         ]   +                     4XNB_02.PCX              ,       `            +         ,                     4XNB_02.PCX                               c   ,                              RC02_02.PCX              z   	      6         6         z                     RC02_02.PCX              z         6         z         z                     RC02_02.PCX              z         6      5   6         z                     RC02_02.PCX              z      5   6      5   z         z                     RC02_02.PCX           2   z      2   6   
      6      2   z                     RC02_02.PCX           2   z   
      6         z      2   z                     RC02_02.PCX              z         6         6         z                     RC02_02.PCX              z         6         z         z                     RC02_02.PCX              z         6          6         z                     RC02_02.PCX              z          6          z         z                     RC02_02.PCX               z   
       6   	      6          z                     RC02_02.PCX               z   	      6         z          z                     4XNB_01.PCX                      5          D   D                               4XNB_01.PCX           H             D   
   9   C      H                         4XNB_01.PCX        !             5   @         @   !                           4XNB_01.PCX                     6       
   D   C                               4XNB_01.PCX           H       
      C      :   D      H                         4XNB_01.PCX        !            6   @         @   !                           4XNB_01.PCX                     6          D   C                               4XNB_01.PCX           H             C      :   D      H                         4XNB_01.PCX        !            6   @         @   !                           4XNB_01.PCX                     6          D   C                               4XNB_01.PCX           H             C      :   D      H                         4XNB_01.PCX        !            6   @         @   !                           4XNB_01.PCX                     5          D   D                               4XNB_01.PCX           H             D      9   C      H                         4XNB_01.PCX        !            5   @         @   !                           4XNB_01.PCX                     5         C   D                               4XNB_01.PCX           G             D      9   C      G                         4XNB_01.PCX        !            5   A         @   !                           4XNB_01.PCX                     5          D   D                               4XNB_01.PCX           H             D      9   C      H                         4XNB_01.PCX        !            5   @         @   !                           4XNB_01.PCX                     6          D   C                               4XNB_01.PCX           H             C      :   D      H                         4XNB_01.PCX        !            6   @         @   !                           4XNB_01.PCX                     5          D   D                               4XNB_01.PCX           H             D      9   C      H                         4XNB_01.PCX        !            5   @         @   !                           4XNB_01.PCX            	          7          E   C       	                         4XNB_01.PCX            I             C      ;   C       I                         4XNB_01.PCX        !             7   @       	   @   !                            4XNB_02.PCX        +   b      "           $          +   b                        4XNB_02.PCX        ,         "   `       +         ,                           4XNB_02.PCX        #         "          ,   \      #                           4XNB_02.PCX        '   ]   +   "         #         '   ]   +                     4XNB_02.PCX        (      ,   "   `      '      +   (      ,                     4XNB_02.PCX        $         "          (   c   ,   $                           RC02_02.PCX        -      z   +      6   $      6   -      z                     RC02_02.PCX        -      z   $      6   &      z   -      z                     RC02_02.PCX        )      z   '      6   #   5   6   )      z                     RC02_02.PCX        )      z   #   5   6   %   5   z   )      z                     RC02_02.PCX        %   2   z   #   2   6   ,      6   %   2   z                     RC02_02.PCX        %   2   z   ,      6   .      z   %   2   z                     RC02_02.PCX        &      z   $      6   (      6   &      z                     RC02_02.PCX        &      z   (      6   *      z   &      z                     RC02_02.PCX        *      z   (      6   '       6   *      z                     RC02_02.PCX        *      z   '       6   )       z   *      z                     RC02_02.PCX        .       z   ,       6   +      6   .       z                     RC02_02.PCX        .       z   +      6   -      z   .       z                     4XNB_01.PCX        0          B   5       @   D   D   0                            4XNB_01.PCX        0   H       @      D   /   9   C   0   H                         4XNB_01.PCX        C         B   5   @   0      @   C                           4XNB_01.PCX        2          0   6       /   D   C   2                            4XNB_01.PCX        2   H       /      C   1   :   D   2   H                         4XNB_01.PCX        C         0   6   @   2      @   C                           4XNB_01.PCX        4          2   6       1   D   C   4                            4XNB_01.PCX        4   H       1      C   3   :   D   4   H                         4XNB_01.PCX        C         2   6   @   4      @   C                           4XNB_01.PCX        6          4   6       3   D   C   6                            4XNB_01.PCX        6   H       3      C   5   :   D   6   H                         4XNB_01.PCX        C         4   6   @   6      @   C                           4XNB_01.PCX        8          6   5       5   D   D   8                            4XNB_01.PCX        8   H       5      D   7   9   C   8   H                         4XNB_01.PCX        C         6   5   @   8      @   C                           4XNB_01.PCX        :          8   5      7   C   D   :                            4XNB_01.PCX        :   G       7      D   9   9   C   :   G                         4XNB_01.PCX        C         8   5   A   :      @   C                           4XNB_01.PCX        <          :   5       9   D   D   <                            4XNB_01.PCX        <   H       9      D   ;   9   C   <   H                         4XNB_01.PCX        C         :   5   @   <      @   C                           4XNB_01.PCX        >          <   6       ;   D   C   >                            4XNB_01.PCX        >   H       ;      C   =   :   D   >   H                         4XNB_01.PCX        C         <   6   @   >      @   C                           4XNB_01.PCX        A          >   5       =   D   D   A                            4XNB_01.PCX        A   H       =      D   ?   9   C   A   H                         4XNB_01.PCX        C         >   5   @   A      @   C                           4XNB_01.PCX        B   	       A   7       ?   E   C   B   	                         4XNB_01.PCX        B   I       ?      C   @   ;   C   B   I                         4XNB_01.PCX        C          A   7   @   B   	   @   C                            4XNB_02.PCX        K     ?   H      ?   I          K     ?                     4XNB_02.PCX        K     ?   I          J   z      K     ?                     4XNB_02.PCX        I   ?       H           D       ?   I   ?                         4XNB_02.PCX        I   ?       D       ?   E   ?   ?   I   ?                         4XNB_02.PCX        H          K         G     ?   H                            4XNB_02.PCX        H          G     ?   D      ?   H                            4XNB_02.PCX        J   z      I          E      ?   J   z                        4XNB_02.PCX        J   z      E      ?   F   z  ?   J   z            @ANIMATE-XPLG2,0,-5                     L   µ   M           N   q    O           L   ŵ      @ANIMATE-XPLG1,0,-1                     P   Ƶ   Q           R   q    S           P   ŵ      @ANIMATE-XPL5,0,-5                     T   Ƶ    U   q    V           W   µŵT   V   5       j
       DEFAULT.PAL    MAIN             M   ,w  t    A  ]3  ,U  ˣ73  Q  LH  ]3  gb  ?73  
#   X
#   ;     7~     7~H     y     =z   J=z   J      nW   i     K%     K%  jZ   m  ;     _b        r     J  L%     `  K     `          @  ?  2  E  }L  O  ?  W  ڟL  kl  5m  _N  t  b  t  /     S     (7 h7     t    'c  t  \>  J     >  1T       t  Ō  t            m  -L  }L    wM  ?  Sd  NL  i  {?  l  h5m  eQ  Bw5m  l  uS   j:  l   q  5m    }w5m  l       l   Gl  5m  AQ  5m  )l     (:  ;   h   Xh   (T hT     G  J  G  DVG  ,D  G  Վ ^p G  > pjG  8ºG   G    ; G  #s \G  BG  i  G  N                     BUILD12.PCX        #   x   1   ?   G   1   =   #     #   x   1                     BUILD12.PCX        #   x   1   =   #             #   x   1                     BUILD12.PCX        @      1   $   8   1      \     @      1                     BUILD12.PCX        @   G   1           >   #     @   G   1                     BUILD12.PCX        7      '  5   D      9         7      '                    BUILD12.PCX        7      '  9         ;      '  7      '                    BUILD12.PCX        '   ?     %   y      )         '   ?                       BUILD12.PCX        '   ?     )         +       '   ?                       BUILD13.PCX        )   ;                 *   m   |   )   ;                         BUILD13.PCX        %   m             _   )   ;   `   %   m                        BUILD13.PCX        &             _   _   %   -      &                           BUILD13.PCX              _          _   &   R            _                     BUILD13.PCX            R   |                          R   |                     BUILD13.PCX        *   -   |       _             |   *   -   |                     BUILD13.PCX             3      7         7   3        3                     BUILD13.PCX             3              7           3                     BUILD13.PCX        /           ,   3   -   ,      /                          BUILD13.PCX        /             3      ,   3   /                          BUILD12.PCX        3      )  1   '      6   x      3      )                    BUILD12.PCX        3      )  6   x      8      )  3      )                    BUILD12.PCX        ,   ?     *   g                ,   ?                       BUILD12.PCX        ,   ?               "        ,   ?                       BUILD12.PCX           ,  
         5         	      ,  
                     BUILD12.PCX           ,  
      &  5         5      ,  
                     BUILD12.PCX           &  5   .      	         5      &  5                     BUILD12.PCX           &  5   0   ,  
   .      	      &  5                     BUILD12.PCX        <      )  :   7      2         <      )                    BUILD12.PCX        <      )  2         4      )  <      )                    BUILD12.PCX        $   s   1   #   L   1      /     $   s   1                     BUILD12.PCX        $   s   1      /             $   s   1                     4_FLOOR.PCX           +   (      5   /   
   >   E      +   (                     4_FLOOR.PCX           +   (   
   >   E   	   ,   g      +   (                     4_FLOOR.PCX           +   (   	   ,   g         g      +   (                     4_FLOOR.PCX           +   (         g          G      +   (                     4_FLOOR.PCX           +   (          G         (      +   (                     4_FLOOR.PCX        
   >   E      5   /      E   ?   
   >   E                     4_FLOOR.PCX           E   ?      5   /      M   #      E   ?                     4_FLOOR.PCX           E   ?      M   #      V   9      E   ?                     4_FLOOR.PCX           V   9      M   #      m   9      V   9                     4_FLOOR.PCX           m   9      M   #      v   %      m   9                     4_FLOOR.PCX           v   %      M   #      k         v   %                     4_FLOOR.PCX           k         M   #      S         k                        4_FLOOR.PCX        
   >   E      E   ?      d   b   
   >   E                     4_FLOOR.PCX           d   b      E   ?      n   _      d   b                     4_FLOOR.PCX           d   b      n   _         _      d   b                     4_FLOOR.PCX           d   b         _   
      u      d   b                     4_FLOOR.PCX           d   b   
      u      d   u      d   b                     BUILD12.PCX           3           7               3                       BUILD12.PCX           3        ,  7         7      3                    	   4_PAD.PCX        9                     :      ;   9                         	   4_PAD.PCX        5                    9          5                        	   4_PAD.PCX        6   .                 5         6   .                     	   4_PAD.PCX        1   >                 6   .      1   >                     	   4_PAD.PCX        2   /   ;              1   >      2   /   ;                  	   4_PAD.PCX        :      ;              2   /   ;   :      ;                     BUILD12.PCX        !   -        P      &         !   -                       BUILD12.PCX        !   -     &         (        !   -                       BUILD12.PCX        "   8         q               "   8                       BUILD12.PCX        "   8              !   
    "   8                       BUILD13.PCX        @         ?      %   #      %   @                           BUILD13.PCX        @         #      %   $         @                           BUILD12.PCX        (        &   (      %         (                          BUILD12.PCX        (        %         '        (                          BUILD12.PCX        +   *     )   O      *         +   *                       BUILD12.PCX        +   *     *         ,        +   *                       BUILD12.PCX        0   ,  7   -         .      7   0   ,  7                     BUILD12.PCX        0   ,  7   /   3     -         0   ,  7                     BUILD12.PCX        4      )  2   A      1         4      )                    BUILD12.PCX        4      )  1         3      (  4      )                    BUILD12.PCX        8      *  6   8      5         8      *                    BUILD12.PCX        8      *  5         7      *  8      *                    BUILD12.PCX        ;      (  9   (      :   y      ;      (                    BUILD12.PCX        ;      (  :   y      <      (  ;      (                    BUILD12.PCX        ?      1   @   3   1   >   P     ?      1                     BUILD12.PCX        ?   L   1   >        =   /     ?   L   1         @ANIMATE-XPL9,0,-5                     A   4   B           C   {    D           A   T      @ANIMATE-XPLG2,0,-5                     E   4    F   {    G           H   TE   6             @ANIMATE-XPLG1,0,-1                     I   4    J           K   TL   6       I   X   /       j
       DEFAULT.PAL    MAIN             l   ?  ?  *  *  <:  (R  <:  R  0  R  0  (R  ?  \  ?  
G  *  
G  *  \  u:  V  R  u:  zL  R  H0  zL  R  H0  V  R  ޲޲w(R  wR  KR  K(R  \  
G  
G  \  V  R  zL  R  zL  R  V  R  ]7  _  q    0    X  K#       R    ]7  E        l  =  #  l     R  q  ]7  E  q  ]7  _    5N  m  q  5N  R  q  ]7  E  q     R  q     m  q  ]7  Bz  q  5N  m    5N  R    ]7  E       R       m    ]7  Bz    pn^  u)  P   >)       /          7   B                    w       \    0    &               B̒B5m      i  &  5m  &  ̒    %YY  >Y  HY  Y  j^  nj^  Ho^  o^  pY  n^  n^  pn^  Hn^  Hn^  p\n^  Y  Y  pY  HY  HY  p\Y  -o<  F  `,F  fXF  <F    ߄ F  /C F  iF  _8 F    k3 F  k3 F  SF  S  F                    
   B_POST.PCX           +                        ?      +                      
   B_POST.PCX           +              ?      7   ?      +                      
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?          ?                            
   B_POST.PCX           +                       ?      +                      
   B_POST.PCX           +             ?      7   ?      +                      
   B_POST.PCX           +                              +                      
   B_POST.PCX           +                    +          +                      
   B_POST.PCX        
   +                       ?   
   +                      
   B_POST.PCX        
   +             ?   	   7   ?   
   +                      
   B_POST.PCX                     +       
   7   ?                            
   B_POST.PCX                  
   7   ?         ?                            
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX           +       
          	      ?      +                      
   B_POST.PCX           +       	      ?   
   7   ?      +                      
   B_POST.PCX           +                 
             +                      
   B_POST.PCX           +       
             +          +                      
   B_POST.PCX           +                       ?      +                      
   B_POST.PCX           +             ?      7   ?      +                      
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX           +                       ?      +                      
   B_POST.PCX           +             ?      7   ?      +                      
   B_POST.PCX           +                              +                      
   B_POST.PCX           +                    +          +                      
   B_POST.PCX           +                       ?      +                      
   B_POST.PCX           +             ?      7   ?      +                      
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX                     +          7   ?                            
   B_POST.PCX                     7   ?         ?                            
   B_POST.PCX           +                       ?      +                      
   B_POST.PCX           +             ?      7   ?      +                      
   B_POST.PCX           +                              +                      
   B_POST.PCX           +                    +          +                      
   T2_PAD.PCX        *   /   :               /   >       *   /   :                  
   T2_PAD.PCX        +      :               *   /   :   +      :                  
   T2_PAD.PCX        ,                      +      :   ,                         
   T2_PAD.PCX        -                     ,          -                        
   T2_PAD.PCX        .   /                  -         .   /                     
   T2_PAD.PCX        /   >                   .   /      /   >                         T2_RAMP.PCX        $         #   <      "   <   $   $                           T2_RAMP.PCX        $         "   <   $   !      $   $                           T2_RAMP.PCX        %      $   (         $         %      $                     T2_RAMP.PCX        %      $   $         !      $   %      $                     T2_RAMP.PCX        '   <      &   <   $   "   <   $   '   <                        T2_RAMP.PCX        '   <      "   <   $   #   <      '   <                        T2_RAMP.PCX        (         %      $   &   <   $   (                           T2_RAMP.PCX        (         &   <   $   '   <      (                        
   BUILD9.PCX        5         )         0      7   5                        
   BUILD9.PCX        0      7   )         1   .   7   0      7                  
   BUILD9.PCX        1   .   7   )         2   =      1   .   7                  
   BUILD9.PCX        2   =      )         3   .      2   =                     
   BUILD9.PCX        3   .      )         4         3   .                     
   BUILD9.PCX        4         )         5         4                        
   BUILD9.PCX        0      7   *      7   /         0      7                  
   BUILD9.PCX        0      7   /         5         0      7                  
   BUILD9.PCX        1   .   7   +   .   7   *      7   1   .   7                  
   BUILD9.PCX        1   .   7   *      7   0      7   1   .   7                  
   BUILD9.PCX        2   =      ,   =      +   .   7   2   =                     
   BUILD9.PCX        2   =      +   .   7   1   .   7   2   =                     
   BUILD9.PCX        4         .         -   .      4                        
   BUILD9.PCX        4         -   .      3   .      4                        
   BUILD9.PCX        5         /         .         5                        
   BUILD9.PCX        5         .         4         5                        
   T2_PAD.PCX        T   /   :   6           Y   >       T   /   :                  
   T2_PAD.PCX        U      :   6           T   /   :   U      :                  
   T2_PAD.PCX        V          6           U      :   V                         
   T2_PAD.PCX        W         6           V          W                        
   T2_PAD.PCX        X   /      6           W         X   /                     
   T2_PAD.PCX        Y   >       6           X   /      Y   >                      
   BUILD8.PCX        ;   $   (  B   6      A         ;   $   (                 
   BUILD8.PCX        ;   $   (  A         7      (  ;   $   (                 
   BUILD8.PCX        7   )   )  A   :      @         7   )   )                 
   BUILD8.PCX        7   )   )  @         8      )  7   )   )                 
   BUILD8.PCX        8   -   (  @   ?      ?         8   -   (                 
   BUILD8.PCX        8   -   (  ?         9      (  8   -   (                 
   BUILD8.PCX        9   $   (  ?   6      >         9   $   (                 
   BUILD8.PCX        9   $   (  >         :      (  9   $   (                 
   BUILD8.PCX        :   )   )  >   :      C         :   )   )                 
   BUILD8.PCX        :   )   )  C         <      )  :   )   )                 
   BUILD8.PCX        <   -   (  C   ?      B         <   -   (                 
   BUILD8.PCX        <   -   (  B         ;      (  <   -   (                 
   BUILD9.PCX        >         =   `   /   C         >                        
   BUILD9.PCX        ?      /   =      /   >   ^      ?      /                  
   BUILD9.PCX        @   ]   =   =         ?         @   ]   =                  
   BUILD9.PCX        A      <   =   `      @      =   A      <                  
   BUILD9.PCX        B         =          A   a   <   B                        
   BUILD9.PCX        C   b      =       /   B      .   C   b                        T2_FLOOR.PCX        E   `   w   D   A   A   J   ~   A   E   `   w                     T2_FLOOR.PCX        F   "   w   D   A   A   E   `   w   F   "   w                     T2_FLOOR.PCX        G      A   D   A   A   F   "   w   G      A                     T2_FLOOR.PCX        H   "      D   A   A   G      A   H   "                        T2_FLOOR.PCX        I   `      D   A   A   H   "      I   `                        T2_FLOOR.PCX        J   ~   A   D   A   A   I   `      J   ~   A                     T2_RAMP.PCX        N         M   <      L   <   $   N                           T2_RAMP.PCX        N         L   <   $   K      $   N                           T2_RAMP.PCX        O      $   R         N         O      $                     T2_RAMP.PCX        O      $   N         K      $   O      $                     T2_RAMP.PCX        Q   <      P   <   $   L   <   $   Q   <                        T2_RAMP.PCX        Q   <      L   <   $   M   <      Q   <                        T2_RAMP.PCX        R         O      $   P   <   $   R                           T2_RAMP.PCX        R         P   <   $   Q   <      R                        
   BUILD9.PCX        _         S         Z      7   _                        
   BUILD9.PCX        Z      7   S         [   .   7   Z      7                  
   BUILD9.PCX        [   .   7   S         \   =      [   .   7                  
   BUILD9.PCX        \   =      S         ]   .      \   =                     
   BUILD9.PCX        ]   .      S         ^         ]   .                     
   BUILD9.PCX        ^         S         _         ^                        
   BUILD9.PCX        Z      7   T      7   Y         Z      7                  
   BUILD9.PCX        Z      7   Y         _         Z      7                  
   BUILD9.PCX        [   .   7   U   .   7   T      7   [   .   7                  
   BUILD9.PCX        [   .   7   T      7   Z      7   [   .   7                  
   BUILD9.PCX        \   =      V   =      U   .   7   \   =                     
   BUILD9.PCX        \   =      U   .   7   [   .   7   \   =                     
   BUILD9.PCX        ^         X         W   .      ^                        
   BUILD9.PCX        ^         W   .      ]   .      ^                        
   BUILD9.PCX        _         Y         X         _                        
   BUILD9.PCX        _         X         ^         _               @ANIMATE-XPL5,0,-1                     `   |յP   a      
  b   {      c   {   P˵`      ˵      @ANIMATE-XPLG2,0,-5                     d   |յ|ɵe    
  b   f      c   g   ˵`   d   ˵         @ANIMATE-XPLG1,0,-1                     h   |յ(`i   e   `   j   f   Q   k   d   m   h      |ɵ    j
       DEFAULT.PAL    MAIN             @     B    (        d      .  @d        BJ(  (  J(    d  J(  .  @d  J(  6  8  T    E  8  T   E     T   P     T   6  8    E  r8    E       P       8Қ  T   ^X  T   8X  T     T   8Қ    nX    :X        <r            /  X      8/        <r  J(    J(  /  X  J(  8/    J(  K0eT   KFT   cRT   fceT   K0e  KP  cH  fce  8    9"e    
d        8J(  9"eJ(  
dJ(  J(  (j\   (X  \   D  X  \   D  j\   (j&\  (X  &\  D  X  &\  D  j&\  U   $  w '$  O$  l"+ $    x   -< J7  /  I    <                     RC01_02.PCX               ?      @   @      @             ?                     RC01_02.PCX               ?      @                       ?                     RC01_01.PCX           }   !      (   !      (   @      }   !                     RC01_01.PCX           }   !      (   @       }   @      }   !                     RC01_01.PCX           '   !      }   !      }   @      '   !                     RC01_01.PCX           '   !      }   @      '   @      '   !                     RC01_01.PCX               !      ?   !       ?   @          !                     RC01_01.PCX               !       ?   @          @          !                     RC01_01.PCX           @   !          !          @      @   !                     RC01_01.PCX           @   !          @      @   @      @   !                  	   NP_01.PCX                    ?      
                                 	   NP_01.PCX        
            ?         ?      
                        	   NP_03.PCX           *      
   8          *  ?      *                     	   NP_03.PCX           *  ?   
   8       	   :   ?      *  ?                  	   NP_03.PCX           ,                 
   .   ?      ,                      	   NP_03.PCX        
   .   ?                   ?   
   .   ?                  	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8          *  ?      *                     	   NP_03.PCX           *  ?      8          :   ?      *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                     RC01_02.PCX           @   @          ?      @         @   @                     RC01_02.PCX           @             ?                @                        RC01_01.PCX           (   !      }   !      (   @      (   !                     RC01_01.PCX           (   @      }   !      }   @      (   @                     RC01_01.PCX           }   !      '   !      }   @      }   !                     RC01_01.PCX           }   @      '   !      '   @      }   @                     RC01_01.PCX           ?   !          !      ?   @      ?   !                     RC01_01.PCX           ?   @          !          @      ?   @                     RC01_01.PCX               !      @   !          @          !                     RC01_01.PCX               @      @   !      @   @          @                  	   NP_01.PCX        '   ?      $         %         '   ?                     	   NP_01.PCX        '   ?      %         &   ?      '   ?                     	   NP_03.PCX        %   8       $   *          *  ?   %   8                      	   NP_03.PCX        %   8           *  ?   !   :   ?   %   8                      	   NP_03.PCX        '          &   ,       "   .   ?   '                         	   NP_03.PCX        '          "   .   ?   #      ?   '                            RC01_02.PCX        /       ?   ,   @   @   -   @      /       ?                     RC01_02.PCX        /       ?   -   @      .          /       ?                     RC01_01.PCX        ,   }   !   /   (   !   +   (   @   ,   }   !                     RC01_01.PCX        ,   }   !   +   (   @   (   }   @   ,   }   !                     RC01_01.PCX        .   '   !   -   }   !   )   }   @   .   '   !                     RC01_01.PCX        .   '   !   )   }   @   *   '   @   .   '   !                     RC01_01.PCX        -       !   ,   ?   !   (   ?   @   -       !                     RC01_01.PCX        -       !   (   ?   @   )       @   -       !                     RC01_01.PCX        /   @   !   .       !   *       @   /   @   !                     RC01_01.PCX        /   @   !   *       @   +   @   @   /   @   !                     RC01_02.PCX        7           4         5      >   7                             RC01_02.PCX        7   @       5      >   6   ?   <   7   @                         RC01_01.PCX        5   /       4          0      ?   5   /                         RC01_01.PCX        5   /       0      ?   1   /   ?   5   /                         RC01_01.PCX        7   Z       6   
       2   
   ?   7   Z                         RC01_01.PCX        7   Z       2   
   ?   3   Z   ?   7   Z                         RC01_01.PCX        4          7           3       ?   4                            RC01_01.PCX        4          3       ?   0      ?   4                            RC01_01.PCX        6   =       5          1      ?   6   =                         RC01_01.PCX        6   =       1      ?   2   =   ?   6   =             @ANIMATE-XPLG2,0,-2                     8   4   9           :   t{    ;           8   T      @ANIMATE-XPLG1,0,-1                     <   4    =   t{    >           ?   T<   #          j
       DEFAULT.PAL    MAIN             o   c    _0     
     6=     c B  _0  B  
  B  6=  B        9      B  B  9B  B  
 ƋB  
 Ƌ   *           ȶ   
 ƋB  * B    B    ȶB     S      $  L   =P   B  S   B  $  LB  =PB  F  O  A      -      ƩRx      EX      A  (  -  (  ƩRx  (  EX  (  2>    g&<          b      2>(  g&<(    (  b  (    =N    O                =N(  O(  (    (    O  O          U  'x  O  U    O  U  'x     U         O  ǩQx  O       ǩQx     ^  O  kU  ƙ  &0  O  vFm  ƙ    O  Zv  ƙ  -  
  O    /m  ƙ  I  Y^  O  ,  EU  ƙ  H  .  O  ,  7  ƙ  ,    O  ~    ƙ  ZKO  f  ƙ  !  O  .  O  V  ƙ  7  ƙ  zF     k        P    U        V  4      k  (    P(  U    (  V  4  (  G       p    n   Z8y      [  S  )[  A;[  
x  [  "  %  4 
%  :%  ZXV %  {                     4XNB_01.PCX           @         ?   ?               @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?                	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                   ?                     4XNB_02.PCX                        ?                                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_01.PCX           @         ?   ?   
            @                        4XNB_01.PCX        
            ?   ?         ?   
                           4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX        
      ?         ?   	         
      ?                     4XNB_02.PCX        	               ?   
         	                           4XNB_02.PCX              ?   
      ?                  ?                     4XNB_02.PCX                 
      ?   	                                    4XNB_02.PCX              ?         ?   
               ?                     4XNB_02.PCX        
               ?            
                           4XNB_01.PCX           @         ?   ?               @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_01.PCX           @          ?   ?               @                        4XNB_01.PCX                     ?   ?         ?                              4XNB_02.PCX            	   ?         ?      	          	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?          ?                  ?                     4XNB_02.PCX                        ?                                       4XNB_02.PCX        B   b      !           ;          B   b                        4XNB_02.PCX        C         !   `       B         C                           4XNB_02.PCX        :         !          C   \      :                           4XNB_02.PCX        >   ]   +   !         :         >   ]   +                     4XNB_02.PCX        ?      ,   !   `      >      +   ?      ,                     4XNB_02.PCX        ;         !          ?   c   ,   ;                           4XNB_02.PCX        )     ?   &      ?   '          )     ?                     4XNB_02.PCX        )     ?   '          (   z      )     ?                     4XNB_02.PCX        '   ?       &           "       ?   '   ?                         4XNB_02.PCX        '   ?       "       ?   #   ?   ?   '   ?                         4XNB_02.PCX        &          )         %     ?   &                            4XNB_02.PCX        &          %     ?   "      ?   &                            4XNB_02.PCX        (   z      '          #      ?   (   z                        4XNB_02.PCX        (   z      #      ?   $   z  ?   (   z                        4XNB_02.PCX        1     ?   .      ?   /          1     ?                     4XNB_02.PCX        1     ?   /          0   z      1     ?                     4XNB_02.PCX        /   ?       .           *       ?   /   ?                         4XNB_02.PCX        /   ?       *       ?   +   ?   ?   /   ?                         4XNB_02.PCX        .          1         -     ?   .                            4XNB_02.PCX        .          -     ?   *      ?   .                            4XNB_02.PCX        0   z      /          +      ?   0   z                        4XNB_02.PCX        0   z      +      ?   ,   z  ?   0   z                        4XNB_02.PCX        9     ?   6      ?   7          9     ?                     4XNB_02.PCX        9     ?   7          8   z      9     ?                     4XNB_02.PCX        7   ?       6           2       ?   7   ?                         4XNB_02.PCX        7   ?       2       ?   3   ?   ?   7   ?                         4XNB_02.PCX        6          9         5     ?   6                            4XNB_02.PCX        6          5     ?   2      ?   6                            4XNB_02.PCX        8   z      7          3      ?   8   z                        4XNB_02.PCX        8   z      3      ?   4   z  ?   8   z                        RC02_02.PCX        D      z   B      6   ;      6   D      z                     RC02_02.PCX        D      z   ;      6   =      z   D      z                     RC02_02.PCX        @      z   >      6   :   5   6   @      z                     RC02_02.PCX        @      z   :   5   6   <   5   z   @      z                     RC02_02.PCX        <   2   z   :   2   6   C      6   <   2   z                     RC02_02.PCX        <   2   z   C      6   E      z   <   2   z                     RC02_02.PCX        =      z   ;      6   ?      6   =      z                     RC02_02.PCX        =      z   ?      6   A      z   =      z                     RC02_02.PCX        A      z   ?      6   >       6   A      z                     RC02_02.PCX        A      z   >       6   @       z   A      z                     RC02_02.PCX        E       z   C       6   B      6   E       z                     RC02_02.PCX        E       z   B      6   D      z   E       z                     4XNB_01.PCX        G          Y   5       W   D   D   G                            4XNB_01.PCX        G   H       W      D   F   9   C   G   H                         4XNB_01.PCX        Z         Y   5   @   G      @   Z                           4XNB_01.PCX        I          G   6       F   D   C   I                            4XNB_01.PCX        I   H       F      C   H   :   D   I   H                         4XNB_01.PCX        Z         G   6   @   I      @   Z                           4XNB_01.PCX        K          I   6       H   D   C   K                            4XNB_01.PCX        K   H       H      C   J   :   D   K   H                         4XNB_01.PCX        Z         I   6   @   K      @   Z                           4XNB_01.PCX        M          K   6       J   D   C   M                            4XNB_01.PCX        M   H       J      C   L   :   D   M   H                         4XNB_01.PCX        Z         K   6   @   M      @   Z                           4XNB_01.PCX        O          M   5       L   D   D   O                            4XNB_01.PCX        O   H       L      D   N   9   C   O   H                         4XNB_01.PCX        Z         M   5   @   O      @   Z                           4XNB_01.PCX        Q          O   5      N   C   D   Q                            4XNB_01.PCX        Q   G       N      D   P   9   C   Q   G                         4XNB_01.PCX        Z         O   5   A   Q      @   Z                           4XNB_01.PCX        S          Q   5       P   D   D   S                            4XNB_01.PCX        S   H       P      D   R   9   C   S   H                         4XNB_01.PCX        Z         Q   5   @   S      @   Z                           4XNB_01.PCX        U          S   6       R   D   C   U                            4XNB_01.PCX        U   H       R      C   T   :   D   U   H                         4XNB_01.PCX        Z         S   6   @   U      @   Z                           4XNB_01.PCX        X          U   5       T   D   D   X                            4XNB_01.PCX        X   H       T      D   V   9   C   X   H                         4XNB_01.PCX        Z         U   5   @   X      @   Z                           4XNB_01.PCX        Y   	       X   7       V   E   C   Y   	                         4XNB_01.PCX        Y   I       V      C   W   ;   C   Y   I                         4XNB_01.PCX        Z          X   7   @   Y   	   @   Z                            4XNB_02.PCX        b     ?   _      ?   `          b     ?                     4XNB_02.PCX        b     ?   `          a   z      b     ?                     4XNB_02.PCX        `   ?       _           [       ?   `   ?                         4XNB_02.PCX        `   ?       [       ?   \   ?   ?   `   ?                         4XNB_02.PCX        _          b         ^     ?   _                            4XNB_02.PCX        _          ^     ?   [      ?   _                            4XNB_02.PCX        a   z      `          \      ?   a   z                        4XNB_02.PCX        a   z      \      ?   ]   z  ?   a   z            @ANIMATE-XPLG1,0,-1                     c   |յ   d         e           f           c                 @ANIMATE-XPL5,0,-5                     g   |յ|ɵh         i           j           g                 @ANIMATE-XPLG2,0,-5                     k   |յ(`l   |յ   m           n   @ɵ    k               j
       DEFAULT.PAL    MAIN             y   5        c  p      6m    a    5    x6  c  p  x6  6mx6  ax6  = X  Dw Ds'   = '   4 *'     J'   Dw DsX  = X  4 *X    JX  avj  avj  xa!vj  a   xa!   
  Lvj  
  ,vj  
  L   
  ,   Zvj  ZLvj  Z   ZL    j     Hfj  (D6  0awj  alH   ej  76  kj  ػC  j  8  kj    `NNj  `Z  kj  [j  (    `  "     k Z    
  ,    ,  F    " x6  k Zx6  
  ,x6  ,  Fx6  s '   HV* '   
 '   p8 '   s X  HV* X  
 X  p8 X     vj  (     m     z     *:     ( x6  m x6  z x6  *: x6     vj    'P  vj          'P      J Ez vj  I j  vj   J Ez    I j     c  vj  z vj  c     z    	
  #G j  )B  4   QB  V j  d  d   9   j     v   	  
 j  @  Td   0 F j    4   /    j    v        j           |  j  ќ      A  8  j  	    j  d      B        !   L v  _  f* _  F=_  6 _    k  | Hk  U>  k   k  ? r F   %F  LBHF  o F                       4XNB_02.PCX             ?         ?                  ?                     4XNB_02.PCX             ?                z           ?                     4XNB_02.PCX           ?                          ?      ?                         4XNB_02.PCX           ?               ?      ?   ?      ?                         4XNB_02.PCX                                ?                               4XNB_02.PCX                       ?          ?                               4XNB_02.PCX           z                      ?      z                        4XNB_02.PCX           z            ?      z  ?      z                        4XNB_01.PCX        
   @         ?   ?            
   @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?   
      ?      	         	   ?                     4XNB_02.PCX           	      
      ?   	            	                        4XNB_02.PCX              ?         ?   
               ?                     4XNB_02.PCX        
               ?            
                           4XNB_02.PCX        
      ?         ?   	         
      ?                     4XNB_02.PCX        	               ?   
         	                           4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX           b                              b                        4XNB_02.PCX                    `                                           4XNB_02.PCX                              \                                 4XNB_02.PCX           ]   +                        ]   +                     4XNB_02.PCX              ,      `            +         ,                     4XNB_02.PCX                              c   ,                              RC02_02.PCX              z         6         6         z                     RC02_02.PCX              z         6         z         z                     RC02_02.PCX              z         6      5   6         z                     RC02_02.PCX              z      5   6      5   z         z                     RC02_02.PCX           2   z      2   6         6      2   z                     RC02_02.PCX           2   z         6         z      2   z                     RC02_02.PCX              z         6         6         z                     RC02_02.PCX              z         6         z         z                     RC02_02.PCX              z         6          6         z                     RC02_02.PCX              z          6          z         z                     RC02_02.PCX               z          6         6          z                     RC02_02.PCX               z         6         z          z                     4XNB_01.PCX                  1   5       /   D   D                               4XNB_01.PCX           H       /      D      9   C      H                         4XNB_01.PCX        2         1   5   @         @   2                           4XNB_01.PCX        !             6          D   C   !                            4XNB_01.PCX        !   H             C       :   D   !   H                         4XNB_01.PCX        2            6   @   !      @   2                           4XNB_01.PCX        #          !   6           D   C   #                            4XNB_01.PCX        #   H              C   "   :   D   #   H                         4XNB_01.PCX        2         !   6   @   #      @   2                           4XNB_01.PCX        %          #   6       "   D   C   %                            4XNB_01.PCX        %   H       "      C   $   :   D   %   H                         4XNB_01.PCX        2         #   6   @   %      @   2                           4XNB_01.PCX        '          %   5       $   D   D   '                            4XNB_01.PCX        '   H       $      D   &   9   C   '   H                         4XNB_01.PCX        2         %   5   @   '      @   2                           4XNB_01.PCX        )          '   5      &   C   D   )                            4XNB_01.PCX        )   G       &      D   (   9   C   )   G                         4XNB_01.PCX        2         '   5   A   )      @   2                           4XNB_01.PCX        +          )   5       (   D   D   +                            4XNB_01.PCX        +   H       (      D   *   9   C   +   H                         4XNB_01.PCX        2         )   5   @   +      @   2                           4XNB_01.PCX        -          +   6       *   D   C   -                            4XNB_01.PCX        -   H       *      C   ,   :   D   -   H                         4XNB_01.PCX        2         +   6   @   -      @   2                           4XNB_01.PCX        0          -   5       ,   D   D   0                            4XNB_01.PCX        0   H       ,      D   .   9   C   0   H                         4XNB_01.PCX        2         -   5   @   0      @   2                           4XNB_01.PCX        1   	       0   7       .   E   C   1   	                         4XNB_01.PCX        1   I       .      C   /   ;   C   1   I                         4XNB_01.PCX        2          0   7   @   1   	   @   2                            4XNB_02.PCX        :     ?   7      ?   8          :     ?                     4XNB_02.PCX        :     ?   8          9   z      :     ?                     4XNB_02.PCX        8   ?       7           3       ?   8   ?                         4XNB_02.PCX        8   ?       3       ?   4   ?   ?   8   ?                         4XNB_02.PCX        7          :         6     ?   7                            4XNB_02.PCX        7          6     ?   3      ?   7                            4XNB_02.PCX        9   z      8          4      ?   9   z                        4XNB_02.PCX        9   z      4      ?   5   z  ?   9   z                        4XNB_01.PCX        ?   @      B   ?   ?   @         ?   @                        4XNB_01.PCX        @         B   ?   ?   A      ?   @                           4XNB_02.PCX        B   	   ?   ?      ?   >   	      B   	   ?                     4XNB_02.PCX        >   	      ?      ?   ;         >   	                        4XNB_02.PCX        @      ?   A      ?   <         @      ?                     4XNB_02.PCX        <         A      ?   =         <                           4XNB_02.PCX        ?      ?   @      ?   ;         ?      ?                     4XNB_02.PCX        ;         @      ?   <         ;                           4XNB_02.PCX        A      ?   B      ?   =         A      ?                     4XNB_02.PCX        =         B      ?   >         =                           4XNB_02.PCX        T   b      C           M          T   b                        4XNB_02.PCX        U         C   `       T         U                           4XNB_02.PCX        L         C          U   \      L                           4XNB_02.PCX        P   ]   +   C         L         P   ]   +                     4XNB_02.PCX        Q      ,   C   `      P      +   Q      ,                     4XNB_02.PCX        M         C          Q   c   ,   M                           4XNB_02.PCX        K     ?   H      ?   I          K     ?                     4XNB_02.PCX        K     ?   I          J   z      K     ?                     4XNB_02.PCX        I   ?       H           D       ?   I   ?                         4XNB_02.PCX        I   ?       D       ?   E   ?   ?   I   ?                         4XNB_02.PCX        H          K         G     ?   H                            4XNB_02.PCX        H          G     ?   D      ?   H                            4XNB_02.PCX        J   z      I          E      ?   J   z                        4XNB_02.PCX        J   z      E      ?   F   z  ?   J   z                        RC02_02.PCX        V      z   T      6   M      6   V      z                     RC02_02.PCX        V      z   M      6   O      z   V      z                     RC02_02.PCX        R      z   P      6   L   5   6   R      z                     RC02_02.PCX        R      z   L   5   6   N   5   z   R      z                     RC02_02.PCX        N   2   z   L   2   6   U      6   N   2   z                     RC02_02.PCX        N   2   z   U      6   W      z   N   2   z                     RC02_02.PCX        O      z   M      6   Q      6   O      z                     RC02_02.PCX        O      z   Q      6   S      z   O      z                     RC02_02.PCX        S      z   Q      6   P       6   S      z                     RC02_02.PCX        S      z   P       6   R       z   S      z                     RC02_02.PCX        W       z   U       6   T      6   W       z                     RC02_02.PCX        W       z   T      6   V      z   W       z                     4XNB_01.PCX        Y          k   5       i   D   D   Y                            4XNB_01.PCX        Y   H       i      D   X   9   C   Y   H                         4XNB_01.PCX        l         k   5   @   Y      @   l                           4XNB_01.PCX        [          Y   6       X   D   C   [                            4XNB_01.PCX        [   H       X      C   Z   :   D   [   H                         4XNB_01.PCX        l         Y   6   @   [      @   l                           4XNB_01.PCX        ]          [   6       Z   D   C   ]                            4XNB_01.PCX        ]   H       Z      C   \   :   D   ]   H                         4XNB_01.PCX        l         [   6   @   ]      @   l                           4XNB_01.PCX        _          ]   6       \   D   C   _                            4XNB_01.PCX        _   H       \      C   ^   :   D   _   H                         4XNB_01.PCX        l         ]   6   @   _      @   l                           4XNB_01.PCX        a          _   5       ^   D   D   a                            4XNB_01.PCX        a   H       ^      D   `   9   C   a   H                         4XNB_01.PCX        l         _   5   @   a      @   l                           4XNB_01.PCX        c          a   5      `   C   D   c                            4XNB_01.PCX        c   G       `      D   b   9   C   c   G                         4XNB_01.PCX        l         a   5   A   c      @   l                           4XNB_01.PCX        e          c   5       b   D   D   e                            4XNB_01.PCX        e   H       b      D   d   9   C   e   H                         4XNB_01.PCX        l         c   5   @   e      @   l                           4XNB_01.PCX        g          e   6       d   D   C   g                            4XNB_01.PCX        g   H       d      C   f   :   D   g   H                         4XNB_01.PCX        l         e   6   @   g      @   l                           4XNB_01.PCX        j          g   5       f   D   D   j                            4XNB_01.PCX        j   H       f      D   h   9   C   j   H                         4XNB_01.PCX        l         g   5   @   j      @   l                           4XNB_01.PCX        k   	       j   7       h   E   C   k   	                         4XNB_01.PCX        k   I       h      C   i   ;   C   k   I                         4XNB_01.PCX        l          j   7   @   k   	   @   l                @ANIMATE-XPLG2,0,-5                     m   (`tٵn          o           p       P   m      |        @ANIMATE-XPLG1,0,-1                     q   (`    r       Яs           t   P   |յq     h         @ANIMATE-XPL5,0,-5                     u   (`    v       w           x   |յ(`u   i          j
       DEFAULT.PAL    MAIN             p   
C  >       [     
C  >  .;    [  .;  7       Cj       7    .;  Cj    .;  uZ     =     uZ  .;  =  .;  #          #  .;    .;  
C  ]     2   
C  ].;    2.;  7  Ca   Cj  n~   7  Ca.;  Cj  n~.;        .;  .;  #e   sb   #e.;  sb.;  κ     _     u_     6     Ϻ  .;  _  .;  u_  .;  6  .;  
 1E.;    .;  
 1E   * u          4p   
 1E.;  * u.;    .;    4p.;  F  Ak      -'      Ʃ1            Ak  P$  -'  P$  Ʃ1  P$    P$  ^c  F  F  ^c        U  1  F  U  %F  U  1     U  %   OF  ǩ1  F  O   ǩ1       G      &>  G  v&    KM  G  /    -  u>  G    &    I    G  ,      H   G  ,  +  ,  fG  ~  P  ZG  f<  G  =G  Vg  P  z   ơ  k  ^      }    U  %    V  2    k  ^P$    }P$  U  %P$  V  2P$  }    M  s  ^3M  ;;=M   M  ~e v  5  [ 5  5  ٟS  5    G Y  qE *BY  ?<Y  ū  Y  w                     4XNB_01.PCX           ?   ?      @                  ?   ?                     4XNB_01.PCX           ?   ?                  ?      ?   ?                     4XNB_02.PCX              ?      	   ?      	            ?                     4XNB_02.PCX              ?      	                     ?                     4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX              ?                            ?                     4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX              ?                           ?                     4XNB_01.PCX           ?   ?      @                  ?   ?                     4XNB_01.PCX           ?   ?            
      ?      ?   ?                     4XNB_02.PCX              ?      	   ?   	   	            ?                     4XNB_02.PCX              ?   	   	                     ?                     4XNB_02.PCX        
      ?         ?   
         
      ?                     4XNB_02.PCX        
      ?   
                  
      ?                     4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX              ?            
               ?                     4XNB_01.PCX           @         ?   ?               @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_01.PCX           @         ?   ?               @                        4XNB_01.PCX                    ?   ?         ?                              4XNB_02.PCX           	   ?         ?      	         	   ?                     4XNB_02.PCX           	            ?               	                        4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_02.PCX              ?         ?                  ?                     4XNB_02.PCX                       ?                                       4XNB_01.PCX        $   @      '   ?   ?   %         $   @                        4XNB_01.PCX        %         '   ?   ?   &      ?   %                           4XNB_02.PCX        '   	   ?   $      ?   #   	      '   	   ?                     4XNB_02.PCX        #   	      $      ?             #   	                        4XNB_02.PCX        %      ?   &      ?   !         %      ?                     4XNB_02.PCX        !         &      ?   "         !                           4XNB_02.PCX        $      ?   %      ?             $      ?                     4XNB_02.PCX                  %      ?   !                                     4XNB_02.PCX        &      ?   '      ?   "         &      ?                     4XNB_02.PCX        "         '      ?   #         "                           4XNB_01.PCX        (   @      1   ?   ?   /         (   @                        4XNB_01.PCX        /         1   ?   ?   )      ?   /                           4XNB_02.PCX        1   	   ?   .      ?   -   	      1   	   ?                     4XNB_02.PCX        -   	      .      ?   *         -   	                        4XNB_02.PCX        /      ?   0      ?   +         /      ?                     4XNB_02.PCX        +         0      ?   ,         +                           4XNB_02.PCX        .      ?   /      ?   *         .      ?                     4XNB_02.PCX        *         /      ?   +         *                           4XNB_02.PCX        0      ?   1      ?   ,         0      ?                     4XNB_02.PCX        ,         1      ?   -         ,                           4XNB_02.PCX        C   b      2           <          C   b                        4XNB_02.PCX        D         2   `       C         D                           4XNB_02.PCX        ;         2          D   \      ;                           4XNB_02.PCX        ?   ]   +   2         ;         ?   ]   +                     4XNB_02.PCX        @      ,   2   `      ?      +   @      ,                     4XNB_02.PCX        <         2          @   c   ,   <                           4XNB_02.PCX        :     ?   7      ?   8          :     ?                     4XNB_02.PCX        :     ?   8          9   z      :     ?                     4XNB_02.PCX        8   ?       7           3       ?   8   ?                         4XNB_02.PCX        8   ?       3       ?   4   ?   ?   8   ?                         4XNB_02.PCX        7          :         6     ?   7                            4XNB_02.PCX        7          6     ?   3      ?   7                            4XNB_02.PCX        9   z      8          4      ?   9   z                        4XNB_02.PCX        9   z      4      ?   5   z  ?   9   z                        RC02_02.PCX        E      z   C      6   <      6   E      z                     RC02_02.PCX        E      z   <      6   >      z   E      z                     RC02_02.PCX        A      z   ?      6   ;   5   6   A      z                     RC02_02.PCX        A      z   ;   5   6   =   5   z   A      z                     RC02_02.PCX        =   2   z   ;   2   6   D      6   =   2   z                     RC02_02.PCX        =   2   z   D      6   F      z   =   2   z                     RC02_02.PCX        >      z   <      6   @      6   >      z                     RC02_02.PCX        >      z   @      6   B      z   >      z                     RC02_02.PCX        B      z   @      6   ?       6   B      z                     RC02_02.PCX        B      z   ?       6   A       z   B      z                     RC02_02.PCX        F       z   D       6   C      6   F       z                     RC02_02.PCX        F       z   C      6   E      z   F       z                     4XNB_01.PCX        H          Z   5       X   D   D   H                            4XNB_01.PCX        H   H       X      D   G   9   C   H   H                         4XNB_01.PCX        [         Z   5   @   H      @   [                           4XNB_01.PCX        J          H   6       G   D   C   J                            4XNB_01.PCX        J   H       G      C   I   :   D   J   H                         4XNB_01.PCX        [         H   6   @   J      @   [                           4XNB_01.PCX        L          J   6       I   D   C   L                            4XNB_01.PCX        L   H       I      C   K   :   D   L   H                         4XNB_01.PCX        [         J   6   @   L      @   [                           4XNB_01.PCX        N          L   6       K   D   C   N                            4XNB_01.PCX        N   H       K      C   M   :   D   N   H                         4XNB_01.PCX        [         L   6   @   N      @   [                           4XNB_01.PCX        P          N   5       M   D   D   P                            4XNB_01.PCX        P   H       M      D   O   9   C   P   H                         4XNB_01.PCX        [         N   5   @   P      @   [                           4XNB_01.PCX        R          P   5      O   C   D   R                            4XNB_01.PCX        R   G       O      D   Q   9   C   R   G                         4XNB_01.PCX        [         P   5   A   R      @   [                           4XNB_01.PCX        T          R   5       Q   D   D   T                            4XNB_01.PCX        T   H       Q      D   S   9   C   T   H                         4XNB_01.PCX        [         R   5   @   T      @   [                           4XNB_01.PCX        V          T   6       S   D   C   V                            4XNB_01.PCX        V   H       S      C   U   :   D   V   H                         4XNB_01.PCX        [         T   6   @   V      @   [                           4XNB_01.PCX        Y          V   5       U   D   D   Y                            4XNB_01.PCX        Y   H       U      D   W   9   C   Y   H                         4XNB_01.PCX        [         V   5   @   Y      @   [                           4XNB_01.PCX        Z   	       Y   7       W   E   C   Z   	                         4XNB_01.PCX        Z   I       W      C   X   ;   C   Z   I                         4XNB_01.PCX        [          Y   7   @   Z   	   @   [                            4XNB_02.PCX        c     ?   `      ?   a          c     ?                     4XNB_02.PCX        c     ?   a          b   z      c     ?                     4XNB_02.PCX        a   ?       `           \       ?   a   ?                         4XNB_02.PCX        a   ?       \       ?   ]   ?   ?   a   ?                         4XNB_02.PCX        `          c         _     ?   `                            4XNB_02.PCX        `          _     ?   \      ?   `                            4XNB_02.PCX        b   z      a          ]      ?   b   z                        4XNB_02.PCX        b   z      ]      ?   ^   z  ?   b   z            @ANIMATE-XPLG2,0,-5                     d   |յ   e           f   q    g           d   |ɵ,յ      @ANIMATE-XPL5,0,-5                     h   |յ    i   q    j           k   |ɵ,յh   [   6         @ANIMATE-XPLG1,0,-1                     l   |յ    m           n   |ɵ,յo   Z      l   \   :       j
       DEFAULT.PAL    MAIN             X   .( lF  ^( 2  F  ' +F  ^( 2     ' +   | IF  L nF  | I   L n   {  F  |  F  {     |       'G    щ    ZG  n    '   G  '    G  _ X   G  ^   e $<G  E zN   G  }_   6' G  N'   f  <G  ^  <G  .      N  u' %lš    F  Z F   F  Z        !>  F  c0  F  !>     c0     +0  F  +  F  +0     +     *D  G  J|ű    r|O G  |    Z. G  A    *2 G  aM    1j  G  2z    
jd  G  1ov    1  G  !F    G  4    
|1  G  Dd  G  ҞF    2|v      š  {      {      c0      V}p      {  P$  {  P$  c0  P$  V}p  P$     &I  X  U&I  à&I  b" &I  O 3  &I   ,&I  u&I  Q  &I  ;X  m  # _m  ŧw;m  /c m  k                     4XNB_02.PCX        	   b                            	   b                        4XNB_02.PCX        
             `       	         
                           4XNB_02.PCX                            
   \                                 4XNB_02.PCX           ]   +                         ]   +                     4XNB_02.PCX              ,       `            +         ,                     4XNB_02.PCX                               c   ,                              RC02_02.PCX              z   	      6         6         z                     RC02_02.PCX              z         6         z         z                     RC02_02.PCX              z         6      5   6         z                     RC02_02.PCX              z      5   6      5   z         z                     RC02_02.PCX           2   z      2   6   
      6      2   z                     RC02_02.PCX           2   z   
      6         z      2   z                     RC02_02.PCX              z         6         6         z                     RC02_02.PCX              z         6         z         z                     RC02_02.PCX              z         6          6         z                     RC02_02.PCX              z          6          z         z                     RC02_02.PCX               z   
       6   	      6          z                     RC02_02.PCX               z   	      6         z          z                     4XNB_01.PCX                      5          D   D                               4XNB_01.PCX           H             D   
   9   C      H                         4XNB_01.PCX        !             5   @         @   !                           4XNB_01.PCX                     6       
   D   C                               4XNB_01.PCX           H       
      C      :   D      H                         4XNB_01.PCX        !            6   @         @   !                           4XNB_01.PCX                     6          D   C                               4XNB_01.PCX           H             C      :   D      H                         4XNB_01.PCX        !            6   @         @   !                           4XNB_01.PCX                     6          D   C                               4XNB_01.PCX           H             C      :   D      H                         4XNB_01.PCX        !            6   @         @   !                           4XNB_01.PCX                     5          D   D                               4XNB_01.PCX           H             D      9   C      H                         4XNB_01.PCX        !            5   @         @   !                           4XNB_01.PCX                     5         C   D                               4XNB_01.PCX           G             D      9   C      G                         4XNB_01.PCX        !            5   A         @   !                           4XNB_01.PCX                     5          D   D                               4XNB_01.PCX           H             D      9   C      H                         4XNB_01.PCX        !            5   @         @   !                           4XNB_01.PCX                     6          D   C                               4XNB_01.PCX           H             C      :   D      H                         4XNB_01.PCX        !            6   @         @   !                           4XNB_01.PCX                     5          D   D                               4XNB_01.PCX           H             D      9   C      H                         4XNB_01.PCX        !            5   @         @   !                           4XNB_01.PCX            	          7          E   C       	                         4XNB_01.PCX            I             C      ;   C       I                         4XNB_01.PCX        !             7   @       	   @   !                            4XNB_02.PCX        +   b      "           $          +   b                        4XNB_02.PCX        ,         "   `       +         ,                           4XNB_02.PCX        #         "          ,   \      #                           4XNB_02.PCX        '   ]   +   "         #         '   ]   +                     4XNB_02.PCX        (      ,   "   `      '      +   (      ,                     4XNB_02.PCX        $         "          (   c   ,   $                           RC02_02.PCX        -      z   +      6   $      6   -      z                     RC02_02.PCX        -      z   $      6   &      z   -      z                     RC02_02.PCX        )      z   '      6   #   5   6   )      z                     RC02_02.PCX        )      z   #   5   6   %   5   z   )      z                     RC02_02.PCX        %   2   z   #   2   6   ,      6   %   2   z                     RC02_02.PCX        %   2   z   ,      6   .      z   %   2   z                     RC02_02.PCX        &      z   $      6   (      6   &      z                     RC02_02.PCX        &      z   (      6   *      z   &      z                     RC02_02.PCX        *      z   (      6   '       6   *      z                     RC02_02.PCX        *      z   '       6   )       z   *      z                     RC02_02.PCX        .       z   ,       6   +      6   .       z                     RC02_02.PCX        .       z   +      6   -      z   .       z                     4XNB_01.PCX        0          B   5       @   D   D   0                            4XNB_01.PCX        0   H       @      D   /   9   C   0   H                         4XNB_01.PCX        C         B   5   @   0      @   C                           4XNB_01.PCX        2          0   6       /   D   C   2                            4XNB_01.PCX        2   H       /      C   1   :   D   2   H                         4XNB_01.PCX        C         0   6   @   2      @   C                           4XNB_01.PCX        4          2   6       1   D   C   4                            4XNB_01.PCX        4   H       1      C   3   :   D   4   H                         4XNB_01.PCX        C         2   6   @   4      @   C                           4XNB_01.PCX        6          4   6       3   D   C   6                            4XNB_01.PCX        6   H       3      C   5   :   D   6   H                         4XNB_01.PCX        C         4   6   @   6      @   C                           4XNB_01.PCX        8          6   5       5   D   D   8                            4XNB_01.PCX        8   H       5      D   7   9   C   8   H                         4XNB_01.PCX        C         6   5   @   8      @   C                           4XNB_01.PCX        :          8   5      7   C   D   :                            4XNB_01.PCX        :   G       7      D   9   9   C   :   G                         4XNB_01.PCX        C         8   5   A   :      @   C                           4XNB_01.PCX        <          :   5       9   D   D   <                            4XNB_01.PCX        <   H       9      D   ;   9   C   <   H                         4XNB_01.PCX        C         :   5   @   <      @   C                           4XNB_01.PCX        >          <   6       ;   D   C   >                            4XNB_01.PCX        >   H       ;      C   =   :   D   >   H                         4XNB_01.PCX        C         <   6   @   >      @   C                           4XNB_01.PCX        A          >   5       =   D   D   A                            4XNB_01.PCX        A   H       =      D   ?   9   C   A   H                         4XNB_01.PCX        C         >   5   @   A      @   C                           4XNB_01.PCX        B   	       A   7       ?   E   C   B   	                         4XNB_01.PCX        B   I       ?      C   @   ;   C   B   I                         4XNB_01.PCX        C          A   7   @   B   	   @   C                            4XNB_02.PCX        K     ?   H      ?   I          K     ?                     4XNB_02.PCX        K     ?   I          J   z      K     ?                     4XNB_02.PCX        I   ?       H           D       ?   I   ?                         4XNB_02.PCX        I   ?       D       ?   E   ?   ?   I   ?                         4XNB_02.PCX        H          K         G     ?   H                            4XNB_02.PCX        H          G     ?   D      ?   H                            4XNB_02.PCX        J   z      I          E      ?   J   z                        4XNB_02.PCX        J   z      E      ?   F   z  ?   J   z            @ANIMATE-XPLG2,0,-5                     L   µ   M           N   q    O           L   ŵ      @ANIMATE-XPLG1,0,-1                     P   Ƶ   Q           R   q    S           P   ŵ      @ANIMATE-XPL5,0,-5                     T   Ƶ    U   q    V           W   µŵT   V   5       j
       DEFAULT.PAL    MAIN             H   V  ~   r  ~   f  ~   V  ~   V  !  h  !  n  !  V  !  V  8  ~   r  8  ~   f     ~   V     ~   V  8  !  h  r8  !  n     !  V     !  V  ,J      ,J      .   V  .   V  ,J  9   ,J  9   .9  V  .9  Қ  ~   X  ~   X  ~   @  ~   Қ  !  X  !  X  !  @  !  r            X            r  o<    o<  X  o<    o<  0e~   *F~   3R~   2e~   0e!  8P!  3H!  2e!      `"e    \sd    s    o<  `"eo<  \sdo<  so<  $j   $X     J  X     J  j   $j9  $X  9  J  X  9  J  j9       ;G  Mu  B+       Z;  2 "Z;  |Z;  J  Z;  B                  	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8           *  ?      *                     	   NP_03.PCX            *  ?      8          :   ?       *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                  	   NP_01.PCX                    ?      
                                 	   NP_01.PCX        
            ?         ?      
                        	   NP_03.PCX           *      
   8          *  ?      *                     	   NP_03.PCX           *  ?   
   8       	   :   ?      *  ?                  	   NP_03.PCX           ,                 
   .   ?      ,                      	   NP_03.PCX        
   .   ?                   ?   
   .   ?                     RC01_02.PCX                                  >                                RC01_02.PCX           @             >      ?   <      @                         RC01_01.PCX           /                       ?      /                         RC01_01.PCX           /             ?      /   ?      /                         RC01_01.PCX           Z          
          
   ?      Z                         RC01_01.PCX           Z          
   ?      Z   ?      Z                         RC01_01.PCX                                    ?                               RC01_01.PCX                         ?         ?                               RC01_01.PCX           =                       ?      =                         RC01_01.PCX           =             ?      =   ?      =                      	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8          *  ?      *                     	   NP_03.PCX           *  ?      8          :   ?      *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                     RC01_02.PCX        $   @   @   '       ?   %   @      $   @   @                     RC01_02.PCX        %   @      '       ?   &          %   @                        RC01_01.PCX        '   (   !   $   }   !   #   (   @   '   (   !                     RC01_01.PCX        #   (   @   $   }   !       }   @   #   (   @                     RC01_01.PCX        %   }   !   &   '   !   !   }   @   %   }   !                     RC01_01.PCX        !   }   @   &   '   !   "   '   @   !   }   @                     RC01_01.PCX        $   ?   !   %       !       ?   @   $   ?   !                     RC01_01.PCX            ?   @   %       !   !       @       ?   @                     RC01_01.PCX        &       !   '   @   !   "       @   &       !                     RC01_01.PCX        "       @   '   @   !   #   @   @   "       @                  	   NP_01.PCX        /   ?      ,         -         /   ?                     	   NP_01.PCX        /   ?      -         .   ?      /   ?                     	   NP_03.PCX        -   8       ,   *      (   *  ?   -   8                      	   NP_03.PCX        -   8       (   *  ?   )   :   ?   -   8                      	   NP_03.PCX        /          .   ,       *   .   ?   /                         	   NP_03.PCX        /          *   .   ?   +      ?   /                            RC01_02.PCX        7       ?   4   @   @   5   @      7       ?                     RC01_02.PCX        7       ?   5   @      6          7       ?                     RC01_01.PCX        4   }   !   7   (   !   3   (   @   4   }   !                     RC01_01.PCX        4   }   !   3   (   @   0   }   @   4   }   !                     RC01_01.PCX        6   '   !   5   }   !   1   }   @   6   '   !                     RC01_01.PCX        6   '   !   1   }   @   2   '   @   6   '   !                     RC01_01.PCX        5       !   4   ?   !   0   ?   @   5       !                     RC01_01.PCX        5       !   0   ?   @   1       @   5       !                     RC01_01.PCX        7   @   !   6       !   2       @   7   @   !                     RC01_01.PCX        7   @   !   2       @   3   @   @   7   @   !                     RC01_02.PCX        ?           <         =      >   ?                             RC01_02.PCX        ?   @       =      >   >   ?   <   ?   @                         RC01_01.PCX        =   /       <          8      ?   =   /                         RC01_01.PCX        =   /       8      ?   9   /   ?   =   /                         RC01_01.PCX        ?   Z       >   
       :   
   ?   ?   Z                         RC01_01.PCX        ?   Z       :   
   ?   ;   Z   ?   ?   Z                         RC01_01.PCX        <          ?           ;       ?   <                            RC01_01.PCX        <          ;       ?   8      ?   <                            RC01_01.PCX        >   =       =          9      ?   >   =                         RC01_01.PCX        >   =       9      ?   :   =   ?   >   =             @ANIMATE-XPLG1,0,-1                     @   4    A   j       B   4      C   U      @                @ANIMATE-XPL9,0,-2                     D   4   E        F   U      G          D   ة        j
       DEFAULT.PAL    MAIN             @     B    (        d      .  @d        BJ(  (  J(    d  J(  .  @d  J(  6  8  T    E  8  T   E     T   P     T   6  8    E  r8    E       P       8Қ  T   ^X  T   8X  T     T   8Қ    nX    :X        <r            /  X      8/        <r  J(    J(  /  X  J(  8/    J(  K0eT   KFT   cRT   fceT   K0e  KP  cH  fce  8    9"e    
d        8J(  9"eJ(  
dJ(  J(  (j\   (X  \   D  X  \   D  j\   (j&\  (X  &\  D  X  &\  D  j&\  U   $  w '$  O$  l"+ $    x   -< J7  /  I    <                     RC01_02.PCX               ?      @   @      @             ?                     RC01_02.PCX               ?      @                       ?                     RC01_01.PCX           }   !      (   !      (   @      }   !                     RC01_01.PCX           }   !      (   @       }   @      }   !                     RC01_01.PCX           '   !      }   !      }   @      '   !                     RC01_01.PCX           '   !      }   @      '   @      '   !                     RC01_01.PCX               !      ?   !       ?   @          !                     RC01_01.PCX               !       ?   @          @          !                     RC01_01.PCX           @   !          !          @      @   !                     RC01_01.PCX           @   !          @      @   @      @   !                  	   NP_01.PCX                    ?      
                                 	   NP_01.PCX        
            ?         ?      
                        	   NP_03.PCX           *      
   8          *  ?      *                     	   NP_03.PCX           *  ?   
   8       	   :   ?      *  ?                  	   NP_03.PCX           ,                 
   .   ?      ,                      	   NP_03.PCX        
   .   ?                   ?   
   .   ?                  	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8          *  ?      *                     	   NP_03.PCX           *  ?      8          :   ?      *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                     RC01_02.PCX           @   @          ?      @         @   @                     RC01_02.PCX           @             ?                @                        RC01_01.PCX           (   !      }   !      (   @      (   !                     RC01_01.PCX           (   @      }   !      }   @      (   @                     RC01_01.PCX           }   !      '   !      }   @      }   !                     RC01_01.PCX           }   @      '   !      '   @      }   @                     RC01_01.PCX           ?   !          !      ?   @      ?   !                     RC01_01.PCX           ?   @          !          @      ?   @                     RC01_01.PCX               !      @   !          @          !                     RC01_01.PCX               @      @   !      @   @          @                  	   NP_01.PCX        '   ?      $         %         '   ?                     	   NP_01.PCX        '   ?      %         &   ?      '   ?                     	   NP_03.PCX        %   8       $   *          *  ?   %   8                      	   NP_03.PCX        %   8           *  ?   !   :   ?   %   8                      	   NP_03.PCX        '          &   ,       "   .   ?   '                         	   NP_03.PCX        '          "   .   ?   #      ?   '                            RC01_02.PCX        /       ?   ,   @   @   -   @      /       ?                     RC01_02.PCX        /       ?   -   @      .          /       ?                     RC01_01.PCX        ,   }   !   /   (   !   +   (   @   ,   }   !                     RC01_01.PCX        ,   }   !   +   (   @   (   }   @   ,   }   !                     RC01_01.PCX        .   '   !   -   }   !   )   }   @   .   '   !                     RC01_01.PCX        .   '   !   )   }   @   *   '   @   .   '   !                     RC01_01.PCX        -       !   ,   ?   !   (   ?   @   -       !                     RC01_01.PCX        -       !   (   ?   @   )       @   -       !                     RC01_01.PCX        /   @   !   .       !   *       @   /   @   !                     RC01_01.PCX        /   @   !   *       @   +   @   @   /   @   !                     RC01_02.PCX        7           4         5      >   7                             RC01_02.PCX        7   @       5      >   6   ?   <   7   @                         RC01_01.PCX        5   /       4          0      ?   5   /                         RC01_01.PCX        5   /       0      ?   1   /   ?   5   /                         RC01_01.PCX        7   Z       6   
       2   
   ?   7   Z                         RC01_01.PCX        7   Z       2   
   ?   3   Z   ?   7   Z                         RC01_01.PCX        4          7           3       ?   4                            RC01_01.PCX        4          3       ?   0      ?   4                            RC01_01.PCX        6   =       5          1      ?   6   =                         RC01_01.PCX        6   =       1      ?   2   =   ?   6   =             @ANIMATE-XPLG2,0,-2                     8   4   9           :   t{    ;           8   T      @ANIMATE-XPLG1,0,-1                     <   4    =   t{    >           ?   T<   #          j
       DEFAULT.PAL    MAIN             H   RɄ  i    -2  i   R!2  i     i   RɄ  -  !2  -  M+2  -    -  Y@  Ʉ  i   '@  -2  i   Y"  !2  i   "    i   Y@  Ʉ  -  @  !2  -  V"  +2  -  "    -  >V    s   >V  tb s   wb s     s   >V    0s  >V  tb 0s  wb 0s    0s      i     2  i   ¡  2  i   f  ӄ  i       -    
2  -  š  2  -  f  ӄ  -  V  :      
W  Ƅ        Z      Z        V  :  ]2  
W  Ƅ  ]2    Z  ]2  Z    ]2    i     CTi   <  RTi   X<  i     -    OT-  <  ET-  X<  -    "    j      '               "]2  j  ]2  '   ]2    ]2  ©pTs   ©1  s    1  s    pTs   ©pT0s  ©1  0s   1  0s   pT0s   l   ]{ I  :       <   & :b   <  Y    B                  	   NP_01.PCX           ?                           ?                     	   NP_01.PCX           ?                  ?         ?                     	   NP_03.PCX           8          *          *  ?      8                      	   NP_03.PCX           8           *  ?      :   ?      8                      	   NP_03.PCX                     ,          .   ?                            	   NP_03.PCX                     .   ?         ?                            	   NP_01.PCX           ?               
            ?                     	   NP_01.PCX           ?      
            ?         ?                     	   NP_03.PCX        
   8          *         *  ?   
   8                      	   NP_03.PCX        
   8          *  ?   	   :   ?   
   8                      	   NP_03.PCX                     ,       
   .   ?                            	   NP_03.PCX                  
   .   ?         ?                               RC01_02.PCX                                  >                              RC01_02.PCX              >      @          ?   <         >                     RC01_01.PCX                     /             ?                               RC01_01.PCX              ?      /          /   ?         ?                     RC01_01.PCX           
          Z          
   ?      
                         RC01_01.PCX           
   ?      Z          Z   ?      
   ?                     RC01_01.PCX                                    ?                                RC01_01.PCX               ?                   ?          ?                     RC01_01.PCX                     =             ?                               RC01_01.PCX              ?      =          =   ?         ?                  	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8          *  ?      *                     	   NP_03.PCX           *  ?      8          :   ?      *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                     RC01_02.PCX        $   @   @   '       ?   %   @      $   @   @                     RC01_02.PCX        %   @      '       ?   &          %   @                        RC01_01.PCX        '   (   !   $   }   !   #   (   @   '   (   !                     RC01_01.PCX        #   (   @   $   }   !       }   @   #   (   @                     RC01_01.PCX        %   }   !   &   '   !   !   }   @   %   }   !                     RC01_01.PCX        !   }   @   &   '   !   "   '   @   !   }   @                     RC01_01.PCX        $   ?   !   %       !       ?   @   $   ?   !                     RC01_01.PCX            ?   @   %       !   !       @       ?   @                     RC01_01.PCX        &       !   '   @   !   "       @   &       !                     RC01_01.PCX        "       @   '   @   !   #   @   @   "       @                  	   NP_01.PCX        /   ?      ,         -         /   ?                     	   NP_01.PCX        /   ?      -         .   ?      /   ?                     	   NP_03.PCX        -   8       ,   *      (   *  ?   -   8                      	   NP_03.PCX        -   8       (   *  ?   )   :   ?   -   8                      	   NP_03.PCX        /          .   ,       *   .   ?   /                         	   NP_03.PCX        /          *   .   ?   +      ?   /                            RC01_02.PCX        7       ?   4   @   @   5   @      7       ?                     RC01_02.PCX        7       ?   5   @      6          7       ?                     RC01_01.PCX        4   }   !   7   (   !   3   (   @   4   }   !                     RC01_01.PCX        4   }   !   3   (   @   0   }   @   4   }   !                     RC01_01.PCX        6   '   !   5   }   !   1   }   @   6   '   !                     RC01_01.PCX        6   '   !   1   }   @   2   '   @   6   '   !                     RC01_01.PCX        5       !   4   ?   !   0   ?   @   5       !                     RC01_01.PCX        5       !   0   ?   @   1       @   5       !                     RC01_01.PCX        7   @   !   6       !   2       @   7   @   !                     RC01_01.PCX        7   @   !   2       @   3   @   @   7   @   !                     RC01_02.PCX        ?           <         =      >   ?                             RC01_02.PCX        ?   @       =      >   >   ?   <   ?   @                         RC01_01.PCX        =   /       <          8      ?   =   /                         RC01_01.PCX        =   /       8      ?   9   /   ?   =   /                         RC01_01.PCX        ?   Z       >   
       :   
   ?   ?   Z                         RC01_01.PCX        ?   Z       :   
   ?   ;   Z   ?   ?   Z                         RC01_01.PCX        <          ?           ;       ?   <                            RC01_01.PCX        <          ;       ?   8      ?   <                            RC01_01.PCX        >   =       =          9      ?   >   =                         RC01_01.PCX        >   =       9      ?   :   =   ?   >   =             @ANIMATE-XPL5,0,-5                     @   4   A           B   ,s    C           @   T      @ANIMATE-XPLG2,0,-1                     D   4    E   ,s    F           G   TD   2   A       j
       DEFAULT.PAL    MAIN             `   D    i   D  Gm  i   &  Vm  i   ;'    i   D    -  D  Tm  -  &  Jm  -  ;'    -  \  &    )\        m          \  &]2  )\    ]2  m  ]2  ]2  T  i     i     i   3E  i   T  -    -    -  3E  -  T2 i   2 i    i   3N i   T2 -  2 -   -  3N -  )H s   H s   s   )s   )H 0s  H 0s  0s  )0s  bi   bTi   ci   Xi   b-  ba-  Y-  X-  i   Ti   ci   Qi   -  a-  Y-  Q-  s   
s   @  
s   @  s   0s  
0s  @  
0s  @  0s      i     Gm  i     Vm  i       i       -  *  Tm  -    Jm  -      -  ,  &            W4       3     ,  &]2      ]2  W4   ]2  3 ]2  *tm  s   *J s   ZJ J s   ZJ tm  s   *tm  0s  *J 0s  ZJ J 0s  ZJ tm  0s  'a       AG)2  tܠ        X  *2  phV   X                  	   NP_01.PCX                    ?                                       	   NP_01.PCX                    ?         ?                              	   NP_03.PCX           *         8           *  ?      *                     	   NP_03.PCX            *  ?      8          :   ?       *  ?                  	   NP_03.PCX           ,                    .   ?      ,                      	   NP_03.PCX           .   ?                   ?      .   ?                     RC01_02.PCX           @   @          ?   
   @         @   @                     RC01_02.PCX        
   @             ?             
   @                        RC01_01.PCX           (   !      }   !      (   @      (   !                     RC01_01.PCX           (   @      }   !      }   @      (   @                     RC01_01.PCX        
   }   !      '   !   	   }   @   
   }   !                     RC01_01.PCX        	   }   @      '   !   
   '   @   	   }   @                     RC01_01.PCX           ?   !   
       !      ?   @      ?   !                     RC01_01.PCX           ?   @   
       !   	       @      ?   @                     RC01_01.PCX               !      @   !   
       @          !                     RC01_01.PCX        
       @      @   !      @   @   
       @                  	   NP_01.PCX           ?                           ?                     	   NP_01.PCX           ?                  ?         ?                     	   NP_03.PCX           8          *         *  ?      8                      	   NP_03.PCX           8          *  ?      :   ?      8                      	   NP_03.PCX                     ,          .   ?                            	   NP_03.PCX                     .   ?         ?                            	   NP_01.PCX           ?                           ?                     	   NP_01.PCX           ?                  ?         ?                     	   NP_03.PCX           8          *         *  ?      8                      	   NP_03.PCX           8          *  ?      :   ?      8                      	   NP_03.PCX                     ,          .   ?                            	   NP_03.PCX                     .   ?         ?                               RC01_02.PCX        $         '           %      >   $                           RC01_02.PCX        %      >   '   @       &   ?   <   %      >                     RC01_01.PCX        $          %   /              ?   $                            RC01_01.PCX               ?   %   /       !   /   ?          ?                     RC01_01.PCX        &   
       '   Z       "   
   ?   &   
                         RC01_01.PCX        "   
   ?   '   Z       #   Z   ?   "   
   ?                     RC01_01.PCX        '           $          #       ?   '                             RC01_01.PCX        #       ?   $                 ?   #       ?                     RC01_01.PCX        %          &   =       !      ?   %                            RC01_01.PCX        !      ?   &   =       "   =   ?   !      ?                  	   NP_01.PCX        /   ?      ,         -         /   ?                     	   NP_01.PCX        /   ?      -         .   ?      /   ?                     	   NP_03.PCX        -   8       ,   *      (   *  ?   -   8                      	   NP_03.PCX        -   8       (   *  ?   )   :   ?   -   8                      	   NP_03.PCX        /          .   ,       *   .   ?   /                         	   NP_03.PCX        /          *   .   ?   +      ?   /                         	   NP_01.PCX        7   ?      4         5         7   ?                     	   NP_01.PCX        7   ?      5         6   ?      7   ?                     	   NP_03.PCX        5   8       4   *      0   *  ?   5   8                      	   NP_03.PCX        5   8       0   *  ?   1   :   ?   5   8                      	   NP_03.PCX        7          6   ,       2   .   ?   7                         	   NP_03.PCX        7          2   .   ?   3      ?   7                            RC01_02.PCX        <         ?           =      >   <                           RC01_02.PCX        =      >   ?   @       >   ?   <   =      >                     RC01_01.PCX        <          =   /       8      ?   <                            RC01_01.PCX        8      ?   =   /       9   /   ?   8      ?                     RC01_01.PCX        >   
       ?   Z       :   
   ?   >   
                         RC01_01.PCX        :   
   ?   ?   Z       ;   Z   ?   :   
   ?                     RC01_01.PCX        ?           <          ;       ?   ?                             RC01_01.PCX        ;       ?   <          8      ?   ;       ?                     RC01_01.PCX        =          >   =       9      ?   =                            RC01_01.PCX        9      ?   >   =       :   =   ?   9      ?                  	   NP_01.PCX        G   ?      D         E         G   ?                     	   NP_01.PCX        G   ?      E         F   ?      G   ?                     	   NP_03.PCX        E   8       D   *      @   *  ?   E   8                      	   NP_03.PCX        E   8       @   *  ?   A   :   ?   E   8                      	   NP_03.PCX        G          F   ,       B   .   ?   G                         	   NP_03.PCX        G          B   .   ?   C      ?   G                            RC01_02.PCX        O       ?   L   @   @   M   @      O       ?                     RC01_02.PCX        O       ?   M   @      N          O       ?                     RC01_01.PCX        L   }   !   O   (   !   K   (   @   L   }   !                     RC01_01.PCX        L   }   !   K   (   @   H   }   @   L   }   !                     RC01_01.PCX        N   '   !   M   }   !   I   }   @   N   '   !                     RC01_01.PCX        N   '   !   I   }   @   J   '   @   N   '   !                     RC01_01.PCX        M       !   L   ?   !   H   ?   @   M       !                     RC01_01.PCX        M       !   H   ?   @   I       @   M       !                     RC01_01.PCX        O   @   !   N       !   J       @   O   @   !                     RC01_01.PCX        O   @   !   J       @   K   @   @   O   @   !                     RC01_02.PCX        W           T         U      >   W                             RC01_02.PCX        W   @       U      >   V   ?   <   W   @                         RC01_01.PCX        U   /       T          P      ?   U   /                         RC01_01.PCX        U   /       P      ?   Q   /   ?   U   /                         RC01_01.PCX        W   Z       V   
       R   
   ?   W   Z                         RC01_01.PCX        W   Z       R   
   ?   S   Z   ?   W   Z                         RC01_01.PCX        T          W           S       ?   T                            RC01_01.PCX        T          S       ?   P      ?   T                            RC01_01.PCX        V   =       U          Q      ?   V   =                         RC01_01.PCX        V   =       Q      ?   R   =   ?   V   =             @ANIMATE-XPL5,0,-5                     X   t   Y           Z   (    [           X   Ĳ      @ANIMATE-XPLG1,0,-1                     \   t    ]   (    ^           _   l\   =          j
       E:\PROJECT\SCENERY\DEFAULT.PAL    MAIN             O   X
<
  <
  tV:
  :
  
vX  
  
  
  
    TV  R  
  R  
  
  V>7  
  8  
  >7  B8  B B B:  LB6  r6  x9  rx9  4$  $:  L4$    $:  ,  4  4:  ,  B<  <$    P$  P
  2D       h
  4    ^B2D  J   hB4  |^D       
       /       9  
  L  
  9  BL  B  ,  B49  ,  B  LB49  LBA      z

VOH  A      p  KrACT/  `̚  )  /  dM    `$    dM  |A  $<  Z         *        
   PANEL5.PCX           v                           v           *        
   PANEL5.PCX                                                 *        
   PANEL5.PCX           v        v                  v           *        
   PANEL5.PCX           v                           v           *        
   PANEL5.PCX                             v                    *        
   PANEL5.PCX                    v        v                    *        
   PANEL5.PCX                                                 *        
   PANEL5.PCX                                                *        
   PANEL5.PCX                    v                             *        
   PANEL5.PCX                                               *        
   PANEL5.PCX        
         	   v              
               *        
   PANEL5.PCX        
                         
              *        
   PANEL5.PCX        	   v     
   v              	   v           *        
   PANEL5.PCX                 
   v                             *        
   PANEL5.PCX        
                  	   v     
               *        
   PANEL5.PCX        	   v              
   v     	   v           *        
   PANEL5.PCX                          
                       *        
   PANEL5.PCX        
                         
              *        
   PANEL5.PCX        
   v                       
   v           *        
   PANEL5.PCX                                               *           TOPANEL.PCX        (         -          ,   c      (               *           TOPANEL.PCX        (         )           -          (               *        
   C_SIDE.PCX           i   >   +      R      f   A      i   >         *        
   C_SIDE.PCX           i   >   )   
   .   +      R      i   >         *        
   C_SIDE.PCX           i   >      f   A   /      R      i   >         *        
   C_SIDE.PCX           i   >   /      R   -   
   .      i   >         *        
   PANEL5.PCX           n   &   /               &      n   &         *        
   PANEL5.PCX           n   &   +   J      /            n   &         *        	   C_TOP.PCX           G      )   3   j      8         G            *        	   C_TOP.PCX           G      -   L   j   )   3   j      G            *        	   C_TOP.PCX           8         G         G         8            *        	   C_TOP.PCX           8         8         G         8            *        	   C_TOP.PCX        +   )   b   -   L   j   /   U   b   +   )   b         *        	   C_TOP.PCX        +   )   b   )   3   j   -   L   j   +   )   b         *           I_LTHRUS.PCX        %   w   &   ,   M         w       %   w   &         *           I_LTHRUS.PCX        %   w   &   (   2      ,   M      %   w   &         *           I_LTHRUS.PCX        %   w   &   "          (   2      %   w   &         *           I_LTHRUS.PCX        %   w   &   $      &   "          %   w   &         *           I_LTHRUS.PCX        %   w   &   *   2   4   $      &   %   w   &         *           I_LTHRUS.PCX        %   w   &   .   M   4   *   2   4   %   w   &         *        
   PANEL5.PCX              <                        <         *        
   PANEL5.PCX              <        I               <         *        
   PANEL5.PCX              (        I        <        (         *        
   PANEL5.PCX              (        I        (         (         *        
   PANEL5.PCX              (      &  I       I        (         *        
   PANEL5.PCX                   &    %                      *        
   PANEL5.PCX                          &                  *        
   PANEL5.PCX           &  I              I     &  I        *        
   PANEL5.PCX           &  I     &              &  I        *        
   PANEL5.PCX           &  I        (   '      <     &  I        *        
   PANEL5.PCX           &       &  I  '      <      &          *        
   PANEL5.PCX           &    '      <   %           &          *        
   PANEL5.PCX        '      <        (   /         '      <        *        
   PANEL5.PCX              (   /               (         (         *        
   PANEL5.PCX             6  !      (          <       6        *        
   PANEL5.PCX                    6         <                *        
   PANEL5.PCX                      <   "                     *        
   PANEL5.PCX        !      (        6  #      (   !      (         *        
   PANEL5.PCX        !      (        6       6  !      (         *        
   PANEL5.PCX        $               "        $              *        
   PANEL5.PCX        $                      $              *        
   PANEL5.PCX              6              6        6        *        
   PANEL5.PCX              6                       6        *        
   PANEL5.PCX        &      <          $        &      <         *        
   PANEL5.PCX        &      <        6         &      <         *        
   PANEL5.PCX        #      (        6  &      <  #      (         *        
   PANEL5.PCX            2      (     u   "            2            *        
   PANEL5.PCX        )      D   (     u       2     )      D         *        
   PANEL5.PCX        !         )      D       2     !               *        
   PANEL5.PCX        $        *        &   2      $              *        
   PANEL5.PCX        &   2     *        +         &   2           *        
   PANEL5.PCX        &   2     +         #         &   2           *        
   PANEL5.PCX           2              ,     u      2            *        
   PANEL5.PCX        -      D      2     ,     u   -      D         *        
   PANEL5.PCX        -      D               2     -      D         *        
   PANEL5.PCX        .        %        '   2      .              *        
   PANEL5.PCX        .        '   2     /         .              *        
   PANEL5.PCX        *        /         +         *              *        
   PANEL5.PCX        *        .        /         *              *        
   PANEL5.PCX                 -      D   /                        *        
   PANEL5.PCX        !         +         )      D   !               *        
   PANEL5.PCX        !         #         +         !               /COCKPIT     
                1   x   2                /GUN:LASER2                     3   x9   4                /GUN:LASER2                     5   ȕR   6      R      
   /MISSILE:1                     7   ȕ    8              
   /MISSILE:0                     9   ȕ   :                 @ANIMATE-XPL9,0,-2     
                C   (gпD   2dE   g'ncF   V~C   !7@      @ANIMATE-XPL9,0,-3     
                G   (gпH   2dI   g'ncJ   V~G   !7@      @ANIMATE-XPL11,0,-1     
                K   (j?L   GҰmM   
T߿N    #=@?K   <HGt\ǿ    j
       E:\PROJECT\SCENERY\DEFAULT.PAL    MAIN             t   (                      (  T    T>    O    
    O  >  
    ;  V;  f7  VG   7  G   8  8  8  8  ;  U  
  
  ;  E      7  U  G   7    G   
  8  &  8  
  8  &  8  ?  !~  ?  v	    4      u    B    .    H/  ,/    mv	    v	        T    T        .  H
  o
  oG  G  
  od  odonoooRR~  ?  ~  ?    ?  m  ?  ^  ?  ^ ?  m?  ?  ?  ?      U      =  E  
Q  E  =  VCT  V/    H/D    H0  ,@  ,q  `(    Y*  ^  y`  x        O  [  ~Չ-`      H    0                          00    H      /        ;        0              /      )  $    0`    l               *           I_NE.PCX        M      c   +   l      ,         M      c         *           I_NE.PCX        +   l      M      c   L   {   c   +   l            *           4NE.PCX           #   F      i   S       i   S      #   F         *           4NE.PCX            i   S      i   S      i   k       i   S         *           4NE.PCX            i   S      i   k      i   k       i   S         *           4NE.PCX            i   S      i   k      #   F       i   S         *           4NE.PCX           #   F      i   k      #   y      #   F         *           4NE.PCX           #   F      #   y         F      #   F         *           4NE.PCX              F      #   y         y         F         *           4NE.PCX           &   3      &   >      i   >      &   3         *           4NE.PCX              3   	      >      &   >         3         *           4NE.PCX              3      &   >      &   3         3         *           4NE.PCX           &   3      &   >   
      >      &   3         *           4NE.PCX           &   3   
      >         3      &   3         *           4NE.PCX           i   :      i   >      &   >      i   :         *           4NE.PCX           i   :      &   >      &   3      i   :         *           4NE.PCX                    =      
      .                  *           4NE.PCX        
      .      =         /   .   
      .         *           4NE.PCX           V          V   .      <   -      V             *           4NE.PCX           V          <   -   
   =          V             *           4NE.PCX        
   I         >      	   v      
   I            *           4NE.PCX        
   I      	   v         v      
   I            *           4NE.PCX           u      
   u         >         u            *           4NE.PCX           u         >         I         u            *           1NE.PCX        K   J      ?   G   0   >   "   0   K   J            *           1NE.PCX        K   J      >   "   0   J         K   J            *           3NE.PCX                       '      !                     *           3NE.PCX           !            '         '      !            *           3NE.PCX                       .                           *           3NE.PCX              .                  .         .         *           3NE.PCX              .         .         	         .         *           3NE.PCX              	         .         	         	         *           3NE.PCX           -         3   .      1         -            *           3NE.PCX           3   .      -         *   .      3   .         *           3NE.PCX           3   .      *   .      3   	      3   .         *           3NE.PCX           3   	      *   .      *   
      3   	         *           3NE.PCX           1         *   .      -         1            *           3NE.PCX           *   .      1         3   .      *   .         *           3NE.PCX           *   .      3   .      *   
      *   .         *           3NE.PCX           *   
      3   .      3   	      *   
         *           3NE.PCX                       .                           *           3NE.PCX              .                  .         .         *           3NE.PCX              .         .         
         .         *           3NE.PCX              
         .         
         
         *           3NE.PCX              '   "         #   !            '         *           3NE.PCX              '   #   !            '         '         *           3NE.PCX        !      .                     !      .         *           3NE.PCX                 !      .         .                  *           3NE.PCX              .   !      .          	         .         *           3NE.PCX              .          	         	         .         *           3NE.PCX           3   .   "   -         1         3   .         *           3NE.PCX        "   -         3   .   &   *   .   "   -            *           3NE.PCX        &   *   .      3   .      3   	   &   *   .         *           3NE.PCX        &   *   .      3   	   $   *   
   &   *   .         *           3NE.PCX        '   *   .      1      #   -      '   *   .         *           3NE.PCX           1      '   *   .   !   3   .      1            *           3NE.PCX        !   3   .   '   *   .   %   *   
   !   3   .         *           3NE.PCX        !   3   .   %   *   
       3   	   !   3   .         *           3NE.PCX        &      .   #         "         &      .         *           3NE.PCX        #         &      .   '      .   #               *           3NE.PCX        '      .   &      .   $      
   '      .         *           3NE.PCX        '      .   $      
   %      
   '      .         *           2NE.PCX        (      ;   ,   Q   *   -      *   (      ;         *           2NE.PCX        ,   Q   *   (      ;   M   l   ;   ,   Q   *         *           2NE.PCX        N   a   ;   -      *   7   h   /   N   a   ;         *           2NE.PCX        -      *   N   a   ;   (      ;   -      *         *           2NE.PCX        (      ;   C      L   B   ]   L   (      ;         *           2NE.PCX        (      ;   B   ]   L   M   l   ;   (      ;         *           2NE.PCX        N   a   ;   D   e   Y   C      L   N   a   ;         *           2NE.PCX        N   a   ;   C      L   (      ;   N   a   ;         *           2NE.PCX        L   k   ;   *      *   +   P   *   L   k   ;         *           2NE.PCX        *      *   L   k   ;   )      ;   *      *         *           2NE.PCX        )      ;   6   g   /   *      *   )      ;         *           2NE.PCX        6   g   /   )      ;   K   `   ;   6   g   /         *           2NE.PCX        )      ;   @      L   ?   d   Y   )      ;         *           2NE.PCX        )      ;   ?   d   Y   K   `   ;   )      ;         *           2NE.PCX        L   k   ;   A   ]   L   @      L   L   k   ;         *           2NE.PCX        L   k   ;   @      L   )      ;   L   k   ;         *           2NE.PCX        1   D   7   ;   F   9   G      <   1   D   7         *           2NE.PCX        1   D   7   G      <   Q      -   1   D   7         *           2NE.PCX        H      -   <      <   0   F   9   H      -         *           2NE.PCX        H      -   0   F   9   2   D   7   H      -         *           2NE.PCX        ;   X   o  0   1   o  <      b   ;   X   o        *           1NE.PCX        1         :         .   %      1               *           1NE.PCX        :         1         Q         :               *           1NE.PCX        P         8         9         P               *           1NE.PCX        8         P         O         8               *           1NE.PCX        J         4         5         J               *           1NE.PCX        4         J         I         4               *           1NE.PCX        4         *      V   6      s   4               *           1NE.PCX        4         6      s   5         4               *           1NE.PCX        /         .         3         /               *           1NE.PCX        3         .         4         3               *           1NE.PCX        4         .         :         4               *           1NE.PCX        4         :         9         4               *           1NE.PCX        4         9         -      V   4               *           1NE.PCX        4         -      V   *      V   4               *           1NE.PCX        *      V   -      V   +      (   *      V         *           1NE.PCX        +      (   -      V   ,      (   +      (         *           1NE.PCX        -      V   9         7      s   -      V         *           1NE.PCX        7      s   9         8         7      s         *           1NE.PCX        H         /   %      3         H               *           1NE.PCX        /   %      H         2         /   %            *           1NE.PCX        2         .   T      /   z      2               *           1NE.PCX        .   T      2         1   N      .   T            *           1NE.PCX        2         0   }      ;   Q      2               *           1NE.PCX        2         ;   Q      1   N      2               *           2NE.PCX        I      X   3   #   Z   4   #   T   I      X         *           2NE.PCX        3   #   Z   I      X   H      _   3   #   Z         *           2NE.PCX        Q   w   `   9   l   T   :   l   [   Q   w   `         *           2NE.PCX        9   l   T   Q   w   `   P   w   X   9   l   T         *           2NE.PCX        O      X   7      >   8      T   O      X         *           2NE.PCX        7      >   O      X   N      ;   7      >         *           2NE.PCX        K   v   ;   5      T   6      >   K   v   ;         *           2NE.PCX        5      T   K   v   ;   J   v   X   5      T         *           2NE.PCX        ;   X   o  <      b   =      V   ;   X   o        *           2NE.PCX        ;   X   o  =      V   G   o   c   ;   X   o        *           2NE.PCX        G   o   c   =      V   F   o   V   G   o   c         *           2NE.PCX        F   o   V   =      V   C   o      F   o   V         *           2NE.PCX        C   o      =      V   @         C   o            *           2NE.PCX        C   o      @         A   /   b   C   o            *           2NE.PCX        C   o      A   /   b   B   ]   b   C   o            *           2NE.PCX        F   o   V   C   o      D      =   F   o   V         *           2NE.PCX        F   o   V   D      =   E      V   F   o   V         *           2NE.PCX        @         =      V   ?      =   @               *           2NE.PCX        ?      =   =      V   >      V   ?      =         *           2NE.PCX        I      X   =      V   <      b   I      X         *           2NE.PCX        I      X   <      b   H      _   I      X         *           2NE.PCX        J   v   X   >      V   =      V   J   v   X         *           2NE.PCX        J   v   X   =      V   I      X   J   v   X         *           2NE.PCX        M   b   R   B   ]   b   A   /   b   M   b   R         *           2NE.PCX        M   b   R   A   /   b   L   -   R   M   b   R         *           2NE.PCX        O      X   E      V   D      =   O      X         *           2NE.PCX        O      X   D      =   N      ;   O      X         *           2NE.PCX        P   w   X   F   o   V   E      V   P   w   X         *           2NE.PCX        P   w   X   E      V   O      X   P   w   X         *           2NE.PCX        Q   w   `   G   o   c   F   o   V   Q   w   `         *           2NE.PCX        Q   w   `   F   o   V   P   w   X   Q   w   `         /COCKPIT     
                R   0    S      
   /MISSILE:1                     T   0   U              
   /MISSILE:0                     V   0<W             /GUN:LASER2                     X   0   Y            /GUN:LASER2                     Z   0G  [   F  G        @ANIMATE-XPL5,0,-3     
                d   (dBe   CDf   @FFg   H$Id   JtK      @ANIMATE-XPL5,0,-2     
                h   (dBi   CDj   @FFk   H$Ih   JtK      @ANIMATE-XPL5,0,-4     
                l   (dBm   CDn   @FFo   H$Il   JtK      @ANIMATE-XPL12,0,-1     
                p   q   
  r   E  s   p   7  U      j
       E:\PROJECT\SCENERY\DEFAULT.PAL    MAIN             |   -  ~-  -    Z
    	  /  L  R    fZ
  9	  L  R    x
  D  o    T  N  j  9x
  o  T  j      z8    [6    Q  pS   Q  z8  [6  pS   9     U9  vU)  3'  bu)/  0  )/    '  b.v(  u/  0  /    v(  ~:    N	         t(  ,z(  :    ~:    F        '  c,'  b:    <    D	    <  -  D	  -  ~<  -  
  x
  J      x
  ~  y4H  y  H  ~#    N	  -  N	    -  ~  U
    U
      ~<    3$bu0    5b.uu0  u  ~  N	       ,  ~  F      6c,)b  `
  [   -  "%  [   -  1  /  Q  /  1  Q  w  Q  5,  Q  7     R     w  5,  t  XR  cS  k$c%
c  c/     +  Y?]AT#      $    H                  )  H    x    <      |A              $    T)        /      #  0    H`    x               *           2RAV.PCX        =         @         <         =               *           2RAV.PCX        B         @         C         B               *           2RAV.PCX        @         B                  @               *           2RAV.PCX              8            B               8         *           2RAV.PCX                       8          8                  *           2RAV.PCX                        8        8                 *           2RAV.PCX               8                           8        *           2RAV.PCX        ;      8         8  :         ;      8        *           2RAV.PCX        :                8           :               *           2RAV.PCX        <                  ;      8   <               *           2RAV.PCX        ;      8                   8   ;      8         *           2RAV.PCX        <         @                  <               *        	   I_RAV.PCX        4   z   6                  6   4   z   6         *        	   I_RAV.PCX                 4   z   6   6   z                     *        	   I_RAV.PCX        :                  9   g      :               *        	   I_RAV.PCX        9   g               6   z      9   g            *        	   I_RAV.PCX           M   m         6       2   m      M   m         *        	   I_RAV.PCX              6      M   m   4   z   6         6         *           3RAV.PCX        	   p         S         H      	   p            *           3RAV.PCX        	   p         H         {      	   p            *           3RAV.PCX           Z   -   
   h   -      k   >      Z   -         *           3RAV.PCX           Z   -      k   >      X   >      Z   -         *           3RAV.PCX           Z   -      S      	   p         Z   -         *           3RAV.PCX           Z   -   	   p      
   h   -      Z   -         *           3RAV.PCX           	   *      J   q         |      	   *         *           3RAV.PCX           	   *         |               	   *         *           3RAV.PCX        
   I   p   	   	   )            
   I   p         *           3RAV.PCX        
   I   p                  |   
   I   p         *           3RAV.PCX        
   S         p         H      
   S            *           3RAV.PCX           H         p         {         H            *           3RAV.PCX           h   -      Z   -      k   >      h   -         *           3RAV.PCX           k   >      Z   -      X   >      k   >         *           3RAV.PCX        
   S         Z   -      p      
   S            *           3RAV.PCX           p         Z   -      h   -      p            *           3RAV.PCX           J   q   
   	   *         |      J   q         *           3RAV.PCX              |   
   	   *                  |         *           3RAV.PCX           	   )      I   p               	   )         *           3RAV.PCX                    I   p         |                  *           2RAV.PCX              ?   E   @   
      x   ?         ?         *           2RAV.PCX        E   @   
         ?   B      
   E   @   
         *           2RAV.PCX                 3      k         A                  *           2RAV.PCX        3      k            E      /   3      k         *           2RAV.PCX              A   4                        A         *           2RAV.PCX        4               A   3      k   4               *           2RAV.PCX              ?   B      0                  ?         *           2RAV.PCX        B      0         ?         l   B      0         *           2RAV.PCX                        l         ?                   *           2RAV.PCX              l                            l         *           1RAV.PCX           M         3   ,      3         M            *           1RAV.PCX           3   ,      M         M   ,      3   ,         *           1RAV.PCX           Y   y     Z   Q      k        Y   y        *           1RAV.PCX           Z   Q      Y   y     O         Z   Q         *           1RAV.PCX           k                 z        k           *           1RAV.PCX                    k        Z                     *           1RAV.PCX           i        M         W         i           *           1RAV.PCX           M         i        Y   Q      M            *           1RAV.PCX           z        Y   Q      i        z           *           1RAV.PCX           Y         z                  Y            *           1RAV.PCX                    f   L                         *           1RAV.PCX            f   L              g   L       f   L         *           2RAV.PCX        $         #      0  "      Z   $               *           2RAV.PCX        $         "      Z   !      ]   $               *           2RAV.PCX        &      Z   %      ]   !      ]   &      Z         *           2RAV.PCX        &      Z   !      ]   "      Z   &      Z         *           2RAV.PCX        '      0  &      Z   "      Z   '      0        *           2RAV.PCX        '      0  "      Z   #      0  '      0        *           2RAV.PCX        (         '      0  #      0  (               *           2RAV.PCX        (         #      0  $         (               *           2RAV.PCX        (         %      ]   &      Z   (               *           2RAV.PCX        (         &      Z   '      0  (               *           5RAV.PCX        *      ]   )      /   ,   c   D   *      ]         *           5RAV.PCX        *      ]   ,   c   D   +   c   w   *      ]         *           5RAV.PCX        ,   c   D   )      /   -         ,   c   D         *           5RAV.PCX        +   c   w   0   a   w   *      ]   +   c   w         *           5RAV.PCX        *      ]   0   a   w   /      a   *      ]         *           5RAV.PCX        -         2          ,   c   D   -               *           5RAV.PCX        ,   c   D   2          1   b   D   ,   c   D         *           5RAV.PCX        .       /   /      a   1   b   D   .       /         *           5RAV.PCX        1   b   D   /      a   0   a   w   1   b   D         *           5RAV.PCX        .       /   1   b   D   2          .       /         *           2RAV.PCX        C         A      h   D      i   C               *           2RAV.PCX        A      h   C         @         A      h         *           2RAV.PCX        D         7      r   E   
   r   D               *           2RAV.PCX        7      r   D         A   *      7      r         *           2RAV.PCX        E   
   r   5   "      3         E   
   r         *           2RAV.PCX        5   "      E   
   r   7      r   5   "            *           2RAV.PCX        3        6   3      4         3              *           2RAV.PCX        6   3      3        5   "     6   3            *           2RAV.PCX        8   ?       5   "      ?   C   u   8   ?             *           2RAV.PCX        ?   C   u   5   "      7      r   ?   C   u         *           2RAV.PCX        9   ?      6   3      8   ?      9   ?            *           2RAV.PCX        8   ?      6   3      5   "     8   ?            *           2RAV.PCX        ?   C   u   7      r   >   @      ?   C   u         *           2RAV.PCX        >   @      7      r   A   *      >   @            *           2RAV.PCX        =         <         >   p      =               *           2RAV.PCX        >   p      <         ?   i      >   p            *           2RAV.PCX        ?   i      <         8   `   w   ?   i            *           2RAV.PCX        8   `   w   <         ;      w   8   `   w         *           2RAV.PCX        8   `   w   ;      w   :      '   8   `   w         *           2RAV.PCX        8   `   w   :      '   9   k   '   8   `   w         *           2RAV.PCX        >   p      A   j      =         >   p            *           2RAV.PCX        =         A   j      @         =               *           2RAV.PCX        B         C         D   o      B               *           2RAV.PCX        B         D   o      E   V      B               *           2RAV.PCX        H      0  I         G      Z   H      0        *           2RAV.PCX        G      Z   I         F      ]   G      Z         *           2RAV.PCX        J      ]   K      Z   F      ]   J      ]         *           2RAV.PCX        F      ]   K      Z   G      Z   F      ]         *           2RAV.PCX        K      Z   L      0  G      Z   K      Z         *           2RAV.PCX        G      Z   L      0  H      0  G      Z         *           2RAV.PCX        L      0  M         H      0  L      0        *           2RAV.PCX        H      0  M         I         H      0        *           2RAV.PCX        J      ]   M         K      Z   J      ]         *           2RAV.PCX        K      Z   M         L      0  K      Z         *           5RAV.PCX        N      /   O      ]   Q   c   D   N      /         *           5RAV.PCX        Q   c   D   O      ]   P   c   w   Q   c   D         *           5RAV.PCX        N      /   Q   c   D   R         N      /         *           5RAV.PCX        U   a   w   P   c   w   O      ]   U   a   w         *           5RAV.PCX        U   a   w   O      ]   T      a   U   a   w         *           5RAV.PCX        W          R         Q   c   D   W                *           5RAV.PCX        W          Q   c   D   V   b   D   W                *           5RAV.PCX        T      a   S       /   V   b   D   T      a         *           5RAV.PCX        T      a   V   b   D   U   a   w   T      a         *           5RAV.PCX        V   b   D   S       /   W          V   b   D         /COCKPIT     
                X   H$  Y      L   
   /MISSILE:1                     Z   H   [            
   /MISSILE:0                     \   HP   ]      (      /GUN:LASER2                     ^   HS_                 /GUN:LASER2                     `   H   a                 /GUN:LASER2                     b   Hw   c   (         @ANIMATE-XPL5,0,-3     
                l   \dBm    DDn   pFGo   HTIl   KK      @ANIMATE-XPL5,0,-4     
                p   \dBq    DDr   pFGs   HTIp   KK      @ANIMATE-XPL5,0,-5     
                t   \dBu    DDv   pFGw   HTIt   KK      @ANIMATE-XPL13,0,-1     
                x   (    y   ( Wz   -  {   -  x         j
       E:\PROJECT\SCENERY\DEFAULT.PAL    MAIN             b   
  @
  
  @
  D    
    
  O&
  '
  
  6  \  "
  \  '
  
  O&
  	  "
    6    
  D  
  
  
    \}     \}      Q  \Z\Z   QO
  O
  	  O	  O'
  6y\  "0\  '
  "0  6y  
  ?
  
  ?
  D  R  
  
  #
  D  
  #
      
  D  R    
  U    #    2    2  R  (
   R       U  #  8!  2  $  `  c$  `    8!  2    +  1    +    
    D    1      
  D  8!  8!  $    $  c>  z  8  o  8  >  }9  K   S  K   d  (
   n=  (
   d   n=     
  #    
  
  #  
  ?  V   Y  V   $        H    T`    l    </      $      l        #      )        5        0              /      /  $    $`    `      ~         *           D-3.PCX            v   T      v   x                v   T         *           D-3.PCX                    v   x                           *           D-3.PCX              K                   x         K         *           D-3.PCX              x                   .         x         *           D-3.PCX              x         .                  x         *           D-3.PCX              x                           x         *           D-3.PCX              x         x         K         x         *           D-3.PCX              K         x   	      K         K         *           D-3.PCX                 
               x                  *           D-3.PCX              x   
               x         x         *           D-3.PCX                                                  *           D-3.PCX                          
                        *           D-3.PCX              .         .                  .         *           D-3.PCX                       .                           *           D-3.PCX                 	      K         x                  *           D-3.PCX                       x         .                  *           D-3.PCX              .         x                  .         *           D-3.PCX                       x   
                        *           D-3.PCX           v   x   
   v   T               v   x         *           D-3.PCX           v   x                        v   x         *           D-3.PCX           S         (         E         S            *           D-3.PCX           (         S                  (            *           D-3.PCX                    E         (                     *           D-3.PCX           E                  S         E            *           D-3.PCX           {                           {            *           D-3.PCX           {                  f         {            *           D-3.PCX           f                           f            *           D-3.PCX           f                  {         f            *           D-3.PCX        
               K         x   
               *           D-3.PCX        
               x         .   
               *           D-3.PCX              .         x                  .         *           D-3.PCX                       x                           *           D-3.PCX              x         x         K         x         *           D-3.PCX              x         K         K         x         *           D-3.PCX                                 x                   *           D-3.PCX                        x         x                   *           D-3.PCX        !                           !               *           D-3.PCX        !                            !               *           D-3.PCX              .         .                  .         *           D-3.PCX              .            !               .         *           D-3.PCX              K                  x         K         *           D-3.PCX              x                  .         x         *           D-3.PCX              x         .   !               x         *           D-3.PCX              x   !                         x         *           D-3.PCX              G      ]   G      X   v         G         *           D-3.PCX              G      X   v         v         G         *           D-3.PCX              v      N         (            v         *           D-3.PCX           N            v      X   v      N            *           D-3.PCX           X   y      (         N         X   y         *           D-3.PCX           (         X   y         y      (            *           D-3.PCX           ]   _         _      X         ]   _         *           D-3.PCX           X            _               X            *           D-3.PCX        "   x         y   K         K   "   x            *           D-3.PCX        "   x            K   
         "   x            *           D-3.PCX        #   w      "   w   )   
   0   )   #   w            *           D-3.PCX        #   w      
   0   )      0      #   w            *        
   I_BC-9.PCX           }          }   B         B      }             *        
   I_BC-9.PCX           }             B                }             *           D-2.PCX        $   y   n   %   >   B   &   >   c   $   y   n         *           D-2.PCX        $   y   n   &   >   c   '   d   x   $   y   n         *           D-2.PCX        (   >   B   )   y   n   *   d   x   (   >   B         *           D-2.PCX        (   >   B   *   d   x   +   >   c   (   >   B         *           D-2.PCX        *   6   y   '   6   C   &   
   ?   *   6   y         *           D-2.PCX        *   6   y   &   
   ?   +   
   }   *   6   y         *           D-2.PCX        )   t   A   $   t      '   ^      )   t   A         *           D-2.PCX        )   t   A   '   ^      *   ^   =   )   t   A         *           D-2.PCX        )   O   ?   (      ?   %         )   O   ?         *           D-2.PCX        )   O   ?   %         $   O      )   O   ?         *           D-1.PCX        ,   3   /   -   8   C   .   8   2   ,   3   /         *           D-1.PCX        -   8   C   ,   3   /   /   3   H   -   8   C         *           D-1.PCX        0   3   H   1   8   2   2   8   C   0   3   H         *           D-1.PCX        1   8   2   0   3   H   3   3   /   1   8   2         *           D-1.PCX        4   @   2   5   I   G   6   I   -   4   @   2         *           D-1.PCX        5   I   G   4   @   2   7   @   C   5   I   G         *           D-1.PCX        .   9   2   7   =   C   4   =   2   .   9   2         *           D-1.PCX        7   =   C   .   9   2   -   9   C   7   =   C         *           D-1.PCX        /   0   H   ,   0   /   8      )   /   0   H         *           D-1.PCX        /   0   H   8      )   9      (   /   0   H         *           D-1.PCX        /      H   9      (   :      $   /      H         *           D-1.PCX        3   0   /   0   0   H   ;      )   3   0   /         *           D-1.PCX        ;      )   0   0   H   <      (   ;      )         *           D-1.PCX        <      (   0      H   =      $   <      (         *           D-1.PCX        2   9   C   >   =   2   ?   =   C   2   9   C         *           D-1.PCX        >   =   2   2   9   C   1   9   2   >   =   2         *           D-1.PCX        ?   @   C   @   I   -   A   I   G   ?   @   C         *           D-1.PCX        @   I   -   ?   @   C   >   @   2   @   I   -         *           D-1.PCX        6   ?   F   B      l   C   q   \   6   ?   F         *           D-1.PCX        B      l   6   ?   F   5   ?   `   B      l         *           D-1.PCX        A   ?   `   D   q   \   E      l   A   ?   `         *           D-1.PCX        D   q   \   A   ?   `   @   ?   F   D   q   \         *           D-1.PCX        B   q   3   E   q   B   C   X   4   B   q   3         *           D-1.PCX        C   X   4   E   q   B   D   X   B   C   X   4         *           D-1.PCX        5      |   E   M   f   B   M   r   5      |         *           D-1.PCX        E   M   f   5      |   A      \   E   M   f         *           D-1.PCX        7      U   A      ;   5      [   7      U         *           D-1.PCX        A      ;   7      U   ?      @   A      ;         *           D-1.PCX        -   7   
   ?   <       7   <   
   -   7   
         *           D-1.PCX        ?   <       -   7   
   2   7       ?   <             *           D-1.PCX        /      d   2   
   @   -   
   U   /      d         *           D-1.PCX        2   
   @   /      d   0      1   2   
   @         *           D-1.PCX        3   /   $   .   5   
   1   5       3   /   $         *           D-1.PCX        .   5   
   3   /   $   ,   /      .   5   
         *           D-1.PCX        9      
   <         :   ~      9      
         *           D-1.PCX        :   ~      <         =   ~   $   :   ~            *           D-1.PCX        8      
   ;         9      
   8      
         *           D-1.PCX        9      
   ;         <         9      
         *           D-1.PCX        ,   /      3   /   $   8      
   ,   /            *           D-1.PCX        8      
   3   /   $   ;         8      
         *           D-1.PCX        1   7       4   <   
   >   <       1   7             *           D-1.PCX        4   <   
   1   7       .   7   
   4   <   
         *           D-1.PCX        >   >      6   H      @   H   %   >   >            *           D-1.PCX        6   H      >   >      4   >   
   6   H            *           D-1.PCX        @   I   %   C         D         @   I   %         *           D-1.PCX        C         @   I   %   6   I      C               *           D-3.PCX           y   K   #   x            K      y   K         *           D-3.PCX              K   #   x                     K         /COCKPIT     
                F   (`    G   |յ(`      /GUN:LASER2                     H   (`   I   T             /GUN:LASER2                     J   (`|յK           
   /MISSILE:1                     L   (`    M              
   /MISSILE:0                     N   (`    O                /GUN:LASER2                     P   (`   Q      ޵      @ANIMATE-XPL5,0,-5     
                R   (   S         T         U         R   "   #         @ANIMATE-XPL5,0,-5     
                V   (   W         X         Y         V   "   #         @ANIMATE-XPL5,0,-5     
                Z   (   [         \         ]         Z   "   #         @ANIMATE-XPL10,0,-1     
                ^   t׋_   dًً`   ۋH܋a   ދދ^   PTQ    j
       E:\PROJECT\SCENERY\DEFAULT.PAL    MAIN                |  
  h    [            C    Ho    <|  
  E      
  U  
  37    v^        B  .
  O     
  C  H;  E  <.
  
  U
  3t  vL    1  1      +f/  /      f    H    8    e  H  ;	  e  8;	    3
  3
  9@    9@      A  a&  A  '  A  .   A    /   A  >  (  A      A        ;x	  d    9  9    1
  ;Qd  +1
  [        
[    
    
  b  
j    j      b    4    ,bn  j,b   ;6&    6&  j5:  :  !
  !  ,  5:  D!  :  D!
  G  e9  |  Z  3  |    =  |    =  |  Z  e9  "Z  =  "Z  3  "  =  "  =  .   =  '  =  a&  =    /   =  >  (  =      =    2  8	      /    /    &  28	  &    _    
    
  b  _b    &5&!,  5&D&D!G0    L(  0        E      E  gB    /   b    /   B  d  J`  d  gB     $  b     $  H    $`    x    0    `5      <          #      )        ;        <                /      #  <    T`    x               *        	   I_VAN.PCX            ?   "      6         ,   "       ?   "         *        	   I_VAN.PCX            ?   "      I         6          ?   "         *        	   I_VAN.PCX            ?   "      R   "      I          ?   "         *        	   I_VAN.PCX            ?   "      I   ?      R   "       ?   "         *        	   I_VAN.PCX            ?   "      6   ?      I   ?       ?   "         *        	   I_VAN.PCX            ?   "      ,   "      6   ?       ?   "         *           2VAN.PCX           @         L      	   @   q      @            *           2VAN.PCX           @      	   @   q   
   3   q      @            *           2VAN.PCX           @      
   3   q      3         @            *           2VAN.PCX           @         3         ?         @            *           2VAN.PCX           @         ?      
   L         @            *           2VAN.PCX           @      
   L         L         @            *           2VAN.PCX           @      	   @   q      G        @            *           2VAN.PCX           G     	   @   q      L         G           *           2VAN.PCX           8      
   3   q      @         8            *           2VAN.PCX           @      
   3   q   	   @   q      @            *           2VAN.PCX           8         3         8   t      8            *           2VAN.PCX           8         3      
   3   q      8            *           2VAN.PCX           ?         ?         8         ?            *           2VAN.PCX           8         ?         3         8            *           2VAN.PCX           G      
   L         ?         G            *           2VAN.PCX           ?      
   L         ?         ?            *           2VAN.PCX           G         L         G         G            *           2VAN.PCX           G         L      
   L         G            *        	   I_VAN.PCX           6         ?   "      ,   "      6            *        	   I_VAN.PCX           I         ?   "      6         I            *        	   I_VAN.PCX           R   "      ?   "      I         R   "         *        	   I_VAN.PCX           I   ?      ?   "      R   "      I   ?         *        	   I_VAN.PCX           6   ?      ?   "      I   ?      6   ?         *        	   I_VAN.PCX           ,   "      ?   "      6   ?      ,   "         *           2VAN.PCX           L         @         @   q      L            *           2VAN.PCX           @   q      @         3   q      @   q         *           2VAN.PCX           3   q      @         3         3   q         *           2VAN.PCX           3         @         ?         3            *           2VAN.PCX           ?         @         L         ?            *           2VAN.PCX           L         @         L         L            *           2VAN.PCX           @   q      @         G        @   q         *           2VAN.PCX           @   q      G        L         @   q         *           2VAN.PCX           3   q      8         @         3   q         *           2VAN.PCX           3   q      @         @   q      3   q         *           2VAN.PCX           3         8         8   t      3            *           2VAN.PCX           3         8         3   q      3            *           2VAN.PCX           ?         ?         8         ?            *           2VAN.PCX           ?         8         3         ?            *           2VAN.PCX           L         G         ?         L            *           2VAN.PCX           L         ?         ?         L            *           2VAN.PCX           L         G         G         L            *           2VAN.PCX           L         G         L         L            *        	   I_VAN.PCX           g   D      g   z         z      g   D         *        	   I_VAN.PCX           g   D         z         D      g   D         *           2VAN.PCX               
  !      c   "   =   c          
        *           2VAN.PCX               
  "   =   c   #   P   
         
        *           2VAN.PCX               
      B   u         u          
         *           2VAN.PCX           B   u          
   #   P   
      B   u         *           4VAN.PCX        $      ,   %   N   *   &   N      $      ,         *           4VAN.PCX        $      ,   &   N      '         $      ,         *           4VAN.PCX        &      3   %      T   (   k   W   &      3         *           4VAN.PCX        &      3   (   k   W   )   k   0   &      3         *           4VAN.PCX        %      Z   $   }   d   *      s   %      Z         *           4VAN.PCX        %   5   Z   *      s   (      v   %   5   Z         *           4VAN.PCX        '   }   d   &      Z   )   	  v   '   }   d         *           4VAN.PCX        '   }   d   )   	  v   +      s   '   }   d         *           3VAN.PCX        !   S   C   ,   ,   C   -   ,      !   S   C         *           3VAN.PCX        !   S   C   -   ,      "   S      !   S   C         *           3VAN.PCX        .   $   b   /   A   b   0   3   {   .   $   b         *           3VAN.PCX        0   3   {   /   A   b   1   O   {   0   3   {         *           3VAN.PCX        1   O   {   /   A   b   2   ^   b   1   O   {         *           3VAN.PCX        2   ^   b   /   A   b   3   O   I   2   ^   b         *           3VAN.PCX        3   O   I   /   A   b   4   3   I   3   O   I         *           3VAN.PCX        4   3   I   /   A   b   .   $   b   4   3   I         *           2VAN.PCX        5   W   
   6   ]   L   7   Q      5   W   
         *           2VAN.PCX           (   
   7   Q      8   .         (   
         *           2VAN.PCX        7   Q         (   
   5   W   
   7   Q            *           2VAN.PCX        9   g   y   :   "   L   6   ]   L   9   g   y         *           2VAN.PCX        :   "   L   9   g   y   ;      y   :   "   L         *           2VAN.PCX        6   ]   L   8   .      7   Q      6   ]   L         *           2VAN.PCX        8   .      6   ]   L   :   "   L   8   .            *           2VAN.PCX        <   v   +   =   v   Y   >   6   +   <   v   +         *           2VAN.PCX        >   6   +   =   v   Y   ?   	   R   >   6   +         *           2VAN.PCX        @   	   E   A   6   +   ?   	   R   @   	   E         *           2VAN.PCX        ?   	   R   A   6   +   >   6   +   ?   	   R         *           2VAN.PCX        B   v   +   C   v   L   <   v   +   B   v   +         *           2VAN.PCX        <   v   +   C   v   L   =   v   Y   <   v   +         *           2VAN.PCX        @   	   E   C   v   L   A   6   +   @   	   E         *           2VAN.PCX        A   6   +   C   v   L   B   v   +   A   6   +         *           2VAN.PCX        D   >      E   C   Q   F   ?   :   D   >            *           2VAN.PCX        F   ?   :   G      Q   H   "   :   F   ?   :         *           2VAN.PCX        F   ?   :   E   C   Q   G      Q   F   ?   :         *           2VAN.PCX        F   ?   :   I   "      D   >      F   ?   :         *           2VAN.PCX        F   ?   :   H   "   :   I   "      F   ?   :         *           1VAN.PCX        I         J   +      D   '      I               *           1VAN.PCX        I         K         J   +      I               *           1VAN.PCX        D   H      J         E         D   H            *           1VAN.PCX        H         K         I   H      H               *           1VAN.PCX        H         G         K         H               *           1VAN.PCX        L         M         N   r   j   L               *           1VAN.PCX        L         N   r   j   O   7      L               *           1VAN.PCX        P         L         O   7      P               *           1VAN.PCX        P         O   7      Q   7      P               *           1VAN.PCX        R         M         L         R               *           1VAN.PCX        R         L         P         R               *           1VAN.PCX        S   r   j   N   r   j   M         S   r   j         *           1VAN.PCX        S   r   j   M         R         S   r   j         *           1VAN.PCX        Q   7      O   7      N   r   j   Q   7            *           1VAN.PCX        Q   7      N   r   j   S   r   j   Q   7            *           1VAN.PCX        R         P         S   r   j   R               *           1VAN.PCX        S   r   j   P         Q   7      S   r   j         *           1VAN.PCX        ,         ;   !      9   !   F   ,               *           1VAN.PCX        ,         9   !   F   -      4   ,               *           1VAN.PCX        6         5         9         6               *           1VAN.PCX        #         5         T         #               *           1VAN.PCX        5         #         9         5               *           1VAN.PCX        ;         8         :         ;               *           1VAN.PCX        8         ;                  8               *           1VAN.PCX        ;                           ;               *           1VAN.PCX                 ;                                  *           1VAN.PCX        #   "   s   "      e   -      R   #   "   s         *           1VAN.PCX        #   "   s   -      R   9   "   K   #   "   s         *           1VAN.PCX            "   s   ;   "   K   ,      R       "   s         *           1VAN.PCX            "   s   ,      R   !      e       "   s         *           2VAN.PCX        U      F   V   D   f   W      f   U      F         *           2VAN.PCX        U   )   F   W   u   f   X   u   F   U   )   F         *           2VAN.PCX        Y   )      U   )   F   X   u   F   Y   )            *           2VAN.PCX        Y   )      X   u   F   Z   u      Y   )            *           2VAN.PCX        [   D   9   Y         Z         [   D   9         *           2VAN.PCX        [   D   9   Z         \      9   [   D   9         *           2VAN.PCX        V   D   f   [   D   9   \      9   V   D   f         *           2VAN.PCX        V   D   f   \      9   W      f   V   D   f         *           3VAN.PCX        ]      \   ^      I   _      P   ]      \         *           3VAN.PCX        `      U   ^      I   ]      \   `      U         *           3VAN.PCX        a      B   ^      I   `      U   a      B         *           3VAN.PCX        b      6   ^      I   a      B   b      6         *           3VAN.PCX        c      <   ^      I   b      6   c      <         *           3VAN.PCX        _      P   ^      I   c      <   _      P         *           3VAN.PCX        0      \   ]      \   _      P   0      \         *           3VAN.PCX        0      \   _      P   .      P   0      \         *           3VAN.PCX        1      U   `      U   ]      \   1      U         *           3VAN.PCX        1      U   ]      \   0      \   1      U         *           3VAN.PCX        2      B   a      B   `      U   2      B         *           3VAN.PCX        2      B   `      U   1      U   2      B         *           3VAN.PCX        3      6   b      6   a      B   3      6         *           3VAN.PCX        3      6   a      B   2      B   3      6         *           3VAN.PCX        4      <   c      <   b      6   4      <         *           3VAN.PCX        4      <   b      6   3      6   4      <         *           3VAN.PCX        .      P   _      P   c      <   .      P         *           3VAN.PCX        .      P   c      <   4      <   .      P         *           1VAN.PCX        d         e      r   f      W   d               *           1VAN.PCX        d         f      W   g      W   d               *           1VAN.PCX        h      W   i         d         h      W         *           1VAN.PCX        h      W   d         g      W   h      W         *           1VAN.PCX        j      W   h      W   g      W   j      W         *           1VAN.PCX        j      W   g      W   f      W   j      W         *           1VAN.PCX        k      r   j      W   f      W   k      r         *           1VAN.PCX        k      r   f      W   e      r   k      r         *           1VAN.PCX        i         h      W   j      W   i               *           1VAN.PCX        i         j      W   k      r   i               *           2VAN.PCX        l   v   Y   m   v   +   n   6   +   l   v   Y         *           2VAN.PCX        l   v   Y   n   6   +   o   	   R   l   v   Y         *           2VAN.PCX        p   6   +   q   	   E   o   	   R   p   6   +         *           2VAN.PCX        p   6   +   o   	   R   n   6   +   p   6   +         *           2VAN.PCX        r   v   L   s   v   +   m   v   +   r   v   L         *           2VAN.PCX        r   v   L   m   v   +   l   v   Y   r   v   L         *           2VAN.PCX        r   v   L   q   	   E   p   6   +   r   v   L         *           2VAN.PCX        r   v   L   p   6   +   s   v   +   r   v   L         *           1VAN.PCX        t         u         v   r   j   t               *           1VAN.PCX        v   r   j   u         w   7      v   r   j         *           1VAN.PCX        u         x         w   7      u               *           1VAN.PCX        w   7      x         y   7      w   7            *           1VAN.PCX        t         z         u         t               *           1VAN.PCX        u         z         x         u               *           1VAN.PCX        v   r   j   {   r   j   t         v   r   j         *           1VAN.PCX        t         {   r   j   z         t               *           1VAN.PCX        w   7      y   7      v   r   j   w   7            *           1VAN.PCX        v   r   j   y   7      {   r   j   v   r   j         *           1VAN.PCX        x         z         {   r   j   x               *           1VAN.PCX        x         {   r   j   y   7      x               *                     $   ((   '      >   +      >   $      (         *                     $   ((   +      >   *      (   $      (         /COCKPIT     
                |   (>   }   I         
   /MISSILE:0                     ~   (           P      
   /MISSILE:1                        (                 /GUN:LASER2                        ((               /GUN:LASER2                        (       (   <      /GUN:LASER2                        (         ~         @ANIMATE-XPL5,0,-4     
                                           (   %      /   7         @ANIMATE-XPL5,0,-4     
                                           (   %      /   7         @ANIMATE-XPL5,0,-4     
                                           (   %      /   7         @ANIMATE-XPL10,0,-1     
                   (
     
                   H    j
       E:\PROJECT\SCENERY\DEFAULT.PAL    MAIN                *<  {]:  Jd<  r  v `   Oko@ XtII   m  oH           d  I?    	  	  `
     	   2    2  l	  *  <      ~  ~+  (     D	  <    ]:  0  Jd<    r  vQ    `1    C  `  <    <~  ~+      2s
      s
  B   B     ix  Q
  x                      i  i  Q
    Q
    r  H	  r    b
      b
    q$  qb
  $     
  7  
    `
    `  =2     =  2  d     	  R    	  	    !    s
  -    s
  ;  0  JS  0  J;  JS  J,  (     @  (     b    bPP  J      H  w^    x\9    :                oj  ua    H  0<xTT/      <              #              #  H      `    )  5      5                  )        )      0  TT  x             *        	   BC-C3.PCX           c         [         [   }      c            *        	   BC-C3.PCX           [         c          c         [            *        	   BC-C3.PCX           V         H   Z      H   \      V            *        	   BC-C3.PCX            c         H         [          c            *        	   BC-C3.PCX           H   \       c   `      V         H   \         *        	   BC-C3.PCX           \         [   }      H         \            *        	   BC-C3.PCX           [   }      \         c         [   }         *        	   BC-C3.PCX           H         [         H         H            *        	   BC-C3.PCX           [         H         [   }      [            *        	   BC-C3.PCX           K   E      d   D      b   >      K   E         *        	   BC-10.PCX                
   !                            *        	   BC-10.PCX                          r                   *        	   BC-10.PCX           r            
      
     r           *        	   BC-10.PCX                 
   !     	   P                    *        	   BC-10.PCX                       
      
                 *        	   BC-10.PCX        
      
                   
      
         *        	   BC-10.PCX        	   P        P              	   P           *        	   BC-10.PCX                    P                            *        	   BC-10.PCX        
   !        !     	   P     
   !           *        	   BC-10.PCX        	   P        !        P     	   P           *        	   BC-10.PCX                        
   !                   *        	   BC-10.PCX        
   !                !     
   !           *        	   BC-10.PCX           r         r               r            *        	   BC-10.PCX                   r                            *        	   BC-10.PCX        
      
             r     
      
        *        	   BC-10.PCX           r                r       r           *        	   BC-10.PCX           !                        !           *        	   BC-10.PCX                           r                    *        	   BC-10.PCX                  r                           *        	   BC-10.PCX           !                P        !           *        	   BC-10.PCX           !                         !           *        	   BC-10.PCX                          r                    *        	   BC-10.PCX                  r           
               *        	   BC-10.PCX           !                 P        !           *        	   BC-10.PCX                             
                *        	   BC-10.PCX                     
                         *        	   BC-10.PCX           P        P                 P           *        	   BC-10.PCX           P                         P           *        	   BC-10.PCX           !        !        P        !           *        	   BC-10.PCX           !        P        P        !           *        	   BC-10.PCX                           !                   *        	   BC-10.PCX                   !        !                   *        	   BC-10.PCX           r        r                r           *        	   BC-10.PCX           r                         r            *        	   BC-10.PCX                      
     r                   *        	   BC-10.PCX                   r        r                  *        	   BC-10.PCX                   !                           *        	   BC-10.PCX                           r                    *        	   BC-10.PCX           r                        r           *        	   BC-10.PCX                   !        P                   *        	   BC-C1.PCX        \   :      X   )   8   V      8   \   :            *        	   BC-C1.PCX        \   :      V      8   Z         \   :            *        	   BC-C1.PCX        X   )   8   Y   +   l   W      l   X   )   8         *        	   BC-C1.PCX        X   )   8   W      l   V      8   X   )   8         *        	   BC-10.PCX        !       "       0         !             *        	   BC-10.PCX        0         "       1   W     0               *        	   BC-12.PCX        U   o   3   T     3   <   m      U   o   3         *        	   BC-12.PCX        <   m      T     3   =        <   m            *        	   BC-10.PCX        7      =  9      O      S   
   7      =        *        	   BC-10.PCX        7      =      S   
   '   3   \  7      =        *        	   BC-10.PCX        '   3   \      S   
   &   =   /  '   3   \        *        	   BC-10.PCX            S   
  9      O  A   j   t       S   
        *        	   BC-10.PCX        A   j   t   9      O  @      t   A   j   t         *        	   BC-10.PCX        5   7     7      =  (   7     5   7           *        	   BC-10.PCX        7      =  '   3   \  (   7     7      =        *        	   BC-C3.PCX        +   [      )   c      ,   [   }   +   [            *        	   BC-C3.PCX        )   c      +   [      %   c      )   c            *        	   BC-10.PCX        !         $      D   "         !               *        	   BC-10.PCX        $      D   !         #      D   $      D         *        	   BC-C3.PCX        -   H   Z   .   V      *   H   \   -   H   Z         *        	   BC-C3.PCX        *   H      %   c      +   [      *   H            *        	   BC-C3.PCX        %   c   `   *   H   \   .   V      %   c   `         *        	   BC-10.PCX        5        (        4   I      5              *        	   BC-10.PCX        4   I     '      ~  3      V   4   I           *        	   BC-10.PCX        3      V   '      ~  &      U   3      V         *        	   BC-10.PCX        4   I      (        '      ~   4   I            *        	   BC-C3.PCX        ,   [   }   /   \      -   H      ,   [   }         *        	   BC-C3.PCX        /   \      ,   [   }   )   c      /   \            *        	   BC-C3.PCX        +   [      -   H      *   H      +   [            *        	   BC-C3.PCX        -   H      +   [      ,   [   }   -   H            *        	   BC-C3.PCX        .   d   D   -   K   E   /   b   >   .   d   D         *        	   BC-10.PCX        1   W     U      K   0         1   W           *        	   BC-10.PCX        U      K   1   W     T      I   U      K         *        	   BC-10.PCX        8      N  6      =  2   V      8      N        *        	   BC-10.PCX        2   V      6      =  4   3   \  2   V            *        	   BC-10.PCX        2   V      4   3   \  3   >   /  2   V            *        	   BC-10.PCX        8      N  2   V     ?   l   t   8      N        *        	   BC-10.PCX        8      N  ?   l   t   >      t   8      N        *        	   BC-10.PCX        4   3   \  6      =  5   5     4   3   \        *        	   BC-10.PCX        6   T   1  7      1  5        6   T   1        *        	   BC-10.PCX        8   O   ;   9      :   6   T   1  8   O   ;         *        	   BC-10.PCX        6   T   1  9      :   7      1  6   T   1        *        	   BC-10.PCX        >         @   &     8   C  h  >               *        	   BC-10.PCX        8   C   h  @   &     9      i  8   C   h        *        	   BC-10.PCX        <         ;        :        <               *        	   BC-10.PCX        ;        <         =   $     ;              *        	   BC-10.PCX        @   $  H   B      l   D      k   @   $  H         *        	   BC-10.PCX        B     l   @   $  H   >      J   B     l         *        	   BC-10.PCX        >      J   C        B     l   >      J         *        	   BC-10.PCX        C        >      J   ?         C              *        	   BC-10.PCX        A   $     D      k   E         A   $           *        	   BC-10.PCX        D      k   A   $     @   $  H   D      k         *        	   BC-12.PCX        C   |   1   E     1   B   |      C   |   1         *        	   BC-12.PCX        B   |      E     1   D        B   |            *        	   BC-13.PCX        K      h   I         G   }   j   K      h         *        	   BC-13.PCX        I         K      h   M          I               *        	   BC-13.PCX        L   w       F   ~   j   H   w      L   w             *        	   BC-13.PCX        F   ~   j   L   w       J   w   h   F   ~   j         *        	   BC-13.PCX        R        J   y   T   L         R              *        	   BC-13.PCX        J   y   T   R        N      i   J   y   T         *        	   BC-13.PCX        R   $      U      #   Q      m   R   $            *        	   BC-13.PCX        R         Q      m   N   P   f   R               *        	   BC-13.PCX        T   /  #   S         O   P   f   T   /  #         *        	   BC-13.PCX        T   /  #   O   P   f   P      m   T   /  #         *        	   BC-13.PCX        O      i   M         K   y   T   O      i         *        	   BC-13.PCX        M   0      O   0   i   S         M   0            *        	   BC-13.PCX        J   w   h   G      j   F   ~   j   J   w   h         *        	   BC-13.PCX        G      j   J   w   h   K     h   G      j         *        	   BC-13.PCX        M         H   w      I        M               *        	   BC-13.PCX        H   w      M         L   w       H   w            *        
   I_BC-9.PCX        I        H   w      F   ~   ?   I              *        
   I_BC-9.PCX        I        F   ~   ?   G      ?   I              *        	   BC-13.PCX        N   @  #   K   M   \   J   /  \   N   @  #         *        	   BC-13.PCX        K   M   \   N   @  #   O   >   #   K   M   \         *        	   BC-13.PCX        S   *      L   0  g   M   O   g   S   *            *        	   BC-13.PCX        L   0  g   S   *      R   T     L   0  g         *        	   BC-13.PCX        U   P     T   .      P   .   l   U   P           *        	   BC-13.PCX        U   P     P   .   l   Q   Q  k   U   P           *        	   BC-13.PCX        Q   Q  g   P   .   h   O   C     Q   Q  g         *        	   BC-13.PCX        Q   Q  g   O   C     N   E    Q   Q  g         *        	   BC-13.PCX        U   M  y   R   U    S   +     U   M  y         *        	   BC-13.PCX        U   M  y   S   +     T   +   z   U   M  y         *        	   BC-C2.PCX        W      '   [   w   '   Z   i      W      '         *        	   BC-C2.PCX        W      '   Z   i      V   A      W      '         *        	   BC-C2.PCX        Y      '   X   A      \   i      Y      '         *        	   BC-C2.PCX        Y      '   \   i      ]   w   '   Y      '         *        	   BC-C1.PCX        ]   )   J   \   (   5   Z      5   ]   )   J         *        	   BC-C1.PCX        ]   )   J   Z      5   [      J   ]   )   J         /COCKPIT     
                ^   dP   _   Q   2        /GUN:LASER2                     `   d|ya                 /GUN:LASER2                     b   d   c                 /GUN:LASER2                     d   de          
   /MISSILE:0                     f   de   g   E g      
   /MISSILE:1                     h   d i   e            @ANIMATE-XPL5,0,-4     
                r   tBs   D0Et   FGu   <IIr   K L      @ANIMATE-XPL5,0,-2     
                v   tBw   D0Ex   FGy   <IIv   K L      @ANIMATE-XPL5,0,-3     
                z   tB{   D0E|   FG}   <IIz   K L      @ANIMATE-XPL5,0,-4     
                ~   tB   D0E   FG   <II~   K L      @ANIMATE-XPL10,0,-1     
                   (     Q     `   C         j
       E:\PROJECT\SCENERY\DEFAULT.PAL    MAIN             `   ^:  r:    N2^"  :  rp  :    	  2&*    6  86  
  8&b  B  x    *    b     
  8  	  8nh  >     8  p8n>  *     \^*      ,
  
  \^X  8  &8  0(  8  &0(  8  0(  bXx  *  X&*  X&0(  &&bXBx  x  xxx`B  B  B`xB`x    x    x      x    x  x`  B    B    B      B    B`  B`  J   :  #  J   :   -    D     -  B    X    XX  XS  `#  c9  Tc-cY  c  /X  S  .MN  0        T    H    x<    0;                H        x#              /        <            )      #  $    0T    `      s         *           PANEL14.PCX                     R                              *           PANEL14.PCX                     R         R                     *           PANEL14.PCX                    R         s                     *           PANEL14.PCX                    s                              *           PANEL14.PCX                    s         s   8                  *           PANEL14.PCX                   s   8                         *           PANEL14.PCX           R                           R            *           PANEL14.PCX           R                  R         R            *           PANEL14.PCX           R                  s         R            *           PANEL14.PCX           s                           s            *           PANEL14.PCX           s                  s   8      s            *           PANEL14.PCX           s   8                      s   8        *           PANEL15.PCX        8   m   ^   3      y   2      ^   8   m   ^         *           PANEL15.PCX        9   m   |   3      y   8   m   ^   9   m   |         *           PANEL14.PCX        9                  3         9               *           PANEL14.PCX        9               /            9               *           PANEL14.PCX                       /   9                        *           PANEL14.PCX           0   K        K              0   K        *           PANEL14.PCX           0   K              >        0   K        *           PANEL14.PCX                                K                 *           PANEL14.PCX                       K     0   K                 *           PANEL14.PCX           
   .         .               
   .         *           PANEL14.PCX           
   .                        
   .         *           ST_THRUS.PCX        ;      Z   <      &   
      %   ;      Z         *           ST_THRUS.PCX        ;      Z   
      %   	   y   7   ;      Z         *           ST_THRUS.PCX        ;      Z   	   y   7      o   E   ;      Z         *           ST_THRUS.PCX        9      %   :      Z      y   7   9      %         *           ST_THRUS.PCX           y   7   :      Z      o   E      y   7         *           PANEL15.PCX                                                    *           PANEL15.PCX                                                     *           PANEL15.PCX        	          
                  	                *           PANEL15.PCX        	                             	                *           PANEL14.PCX           R                     Q     R            *           PANEL14.PCX           R            Q     ,   Q     R            *           PANEL15.PCX        <   m   y   7      ^   6      |   <   m   y         *           PANEL15.PCX        =   m   ^   7      ^   <   m   y   =   m   ^         *           PANEL14.PCX        	         6         
      /   	               *           PANEL14.PCX        
         6         	         
               *           PANEL14.PCX        <         6         
         <               *           PANEL15.PCX        4   	   Y   3      (         &   4   	   Y         *           PANEL15.PCX        4   	   Y         &      v   7   4   	   Y         *           PANEL15.PCX        4   	   Y      v   7      l   D   4   	   Y         *           PANEL15.PCX        6      &   5      Y      k   E   6      &         *           PANEL15.PCX        6      &      k   E   
   t   7   6      &         *           ST_CTOP.PCX                    e         &   m                  *           ST_CTOP.PCX           &   m      e         Y   m      &   m         *        
   ST_CAN.PCX              3      *   K      w   K         3         *        
   ST_CAN.PCX           *   K         3      w   K      *   K         *           PANEL14.PCX                            Q                 *           PANEL14.PCX                     Q      B  Q                 *           PANEL14.PCX              3        3               3        *           PANEL14.PCX             3                      3        *           PANEL14.PCX           *   P        P        3     *   P        *           PANEL14.PCX           *   P        3        3     *   P        *           PANEL15.PCX              b      c   b   5   t            b         *           PANEL15.PCX              b   5   t      ;               b         *           PANEL15.PCX        :         4   t         c   b   :               *           PANEL15.PCX        :            c   b         b   :               *           PANEL15.PCX        8         2   y      7   y      8               *           PANEL15.PCX        8         7   y      =         8               *           PANEL15.PCX        !   c   b   '      b   5   t      !   c   b         *           PANEL15.PCX        5   t      '      b   ;         5   t            *           PANEL15.PCX        4   t      :             c   b   4   t            *           PANEL15.PCX            c   b   :         &      b       c   b         *           PANEL15.PCX        +      y   .   m   ^   *      ^   +      y         *           PANEL15.PCX        +      y   /   m   |   .   m   ^   +      y         *           PANEL15.PCX        -      ^   0   m   y   ,      |   -      ^         *           PANEL15.PCX        -      ^   1   m   ^   0   m   y   -      ^         *           PANEL15.PCX        +      (   4   	   Y   #      &   +      (         *           PANEL15.PCX        #      &   4   	   Y   $   v   7   #      &         *           PANEL15.PCX        $   v   7   4   	   Y       l   D   $   v   7         *           PANEL15.PCX        5      Y   ,      &   !   k   E   5      Y         *           PANEL15.PCX        !   k   E   ,      &   "   t   7   !   k   E         *           PANEL15.PCX                  &          $                         *           PANEL15.PCX        $         &          %          $               *           PANEL15.PCX        "         (          !         "               *           PANEL15.PCX        !         (          '          !               *           PANEL14.PCX        ,         (         "      /   ,               *           PANEL14.PCX        ,         )         (         ,               *           PANEL14.PCX        ,         0         )         ,               *           PANEL14.PCX        #         /         +         #               *           PANEL14.PCX        $      /   /         #         $      /         *           PANEL14.PCX        $      /   %         /         $      /         *           PANEL15.PCX        *   y      .         -   y      *   y            *           PANEL15.PCX        -   y      .         1         -   y            *           ST_THRUS.PCX        :      Z   /      %   %   y   7   :      Z         *           ST_THRUS.PCX        :      Z   %   y   7   &   o   E   :      Z         *           ST_THRUS.PCX        0      &   ;      Z   )      %   0      &         *           ST_THRUS.PCX        )      %   ;      Z   (   y   7   )      %         *           ST_THRUS.PCX        (   y   7   ;      Z   '   o   E   (   y   7         *           PANEL14.PCX        -   f      5   Q   j   *         -   f            *           PANEL14.PCX        *         5   Q   j   4      j   *               *           PANEL14.PCX        *         4      j   +         *               *           PANEL14.PCX        5   Q   j   -   f      ,   E      5   Q   j         *           PANEL14.PCX        0   H      1   f      ;   Q   j   0   H            *           PANEL14.PCX        ;   Q   j   1   f      .         ;   Q   j         *           PANEL14.PCX        ;   Q   j   .         :      j   ;   Q   j         *           PANEL14.PCX        :      j   .         /         :      j         *           PANEL14.PCX        5   Q   j   7   f      2         5   Q   j         *           PANEL14.PCX        5   Q   j   2         4      j   5   Q   j         *           PANEL14.PCX        4      j   2         3         4      j         *           PANEL14.PCX        7   f      5   Q   j   6   E      7   f            *           PANEL14.PCX        =   f      <   H      ;   Q   j   =   f            *           PANEL14.PCX        =   f      ;   Q   j   8         =   f            *           PANEL14.PCX        8         ;   Q   j   :      j   8               *           PANEL14.PCX        8         :      j   9         8               /COCKPIT     
                >   H   ?            /GUN:LASER2                     @   H   A   Q   o         /GUN:LASER2                     B   H    C   4b      
   /MISSILE:1                     D   H    E              
   /MISSILE:0                     F   H   G   L          @ANIMATE-XPL5,0,-2     
                P   (AQ   B0CR   D\ES   GGP   hII      @ANIMATE-XPL5,0,-4     
                T   (AU   B0CV   D\EW   GGT   hII      @ANIMATE-XPL5,0,-3     
                X   (AY   B0CZ   D\E[   GGX   hII      @ANIMATE-XPL10,0,-1     
                \   &]   0(  ^   0(  8  _   \   b    j
       E:\PROJECT\SCENERY\DEFAULT.PAL    MAIN             M   rbbrl0R0  `     
r/  r2  b05  R02    N    D  `       j         )  N	    )  f  b      j   )  
  )  b  22       2    2  b     (b     d2    &  2  h     &   h  &&@  h  h  V  &6~   646d  ~   6^  44  	    l      2  vl  4	    22    %     tbd%        l  %  \
     t  d
  %  r  ee   	    e   	  +  f  b<  f  b+  b<  b  D  `   !  D  `     `   !  `           `    `        pG              `    /        ;      5  0    <x          h         *        	   INF_T.PCX               p         w         u          p         *        	   INF_T.PCX              u         w         |         u         *        	   INF_T.PCX           y   d      |   q          p      y   d         *        	   INF_T.PCX               p      |   q         w          p         *        	   INF_T.PCX              w         p         v         w         *        	   INF_T.PCX              w         v   	      |         w         *        	   INF_T.PCX        
   ~   n      z   b         p   
   ~   n         *        	   INF_T.PCX        
   ~   n         p         w   
   ~   n         *        	   INF_T.PCX           h      
   ~                  h            *        	   INF_T.PCX           h                     $      h            *        	   INF_T.PCX           ~         h                  ~            *        	   INF_T.PCX                    h            $                  *        
   PANEL7.PCX                                                 *        
   PANEL7.PCX                                                  *        
   PANEL7.PCX                                                  *        
   PANEL7.PCX                                                  *        
   PANEL7.PCX           z               
   8         z            *        
   PANEL7.PCX                             z                     *           I_STHRUS.PCX           k         ;   5      <         k            *           I_STHRUS.PCX           k         l   5      ;   5      k            *           I_STHRUS.PCX           J   5                J         J   5         *           I_STHRUS.PCX        !      5               J   5   !      5         *           I_INTHRU.PCX           u   F      l   M   "      2      u   F         *           I_INTHRU.PCX        "      2      l   M   #   
   D   "      2         *           I_INTHRU.PCX        	   l   M      u   F   $      2   	   l   M         *           I_INTHRU.PCX        	   l   M   $      2   %   
   D   	   l   M         *        
   M_CTOP.PCX        &   X   3   '   u   =   (   
   L   &   X   3         *        
   M_CTOP.PCX        )   u   =   *   X   3   +   
   L   )   u   =         *           M_CTOP2.PCX        '   4   j   )   K   j   (   /      '   4   j         *           M_CTOP2.PCX        (   /      )   K   j   +   P      (   /            *           M_CTOP2.PCX        &   5   S   *   J   S   '   4   j   &   5   S         *           M_CTOP2.PCX        '   4   j   *   J   S   )   K   j   '   4   j         *           M_CTOP2.PCX        (   /      +   P      &   5   S   (   /            *           M_CTOP2.PCX        &   5   S   +   P      *   J   S   &   5   S         *        
   PANEL7.PCX                                                *        
   PANEL7.PCX                       "                      *        
   PANEL7.PCX               "         ,                      *        
   PANEL7.PCX               ,         )                      *        
   PANEL7.PCX               )                              *        
   PANEL7.PCX                                           *        
   PANEL7.PCX                                            *        
   PANEL7.PCX                          -   b                    *        
   PANEL7.PCX        -   b                 y     -   b           *        
   PANEL7.PCX        "                         "              *        
   PANEL7.PCX        "                           "              *        
   PANEL7.PCX        )                         )               *        
   PANEL7.PCX        )         .                 )               *        
   PANEL7.PCX        ,         /         )         ,               *        
   PANEL7.PCX        )         /         .         )               *        
   PANEL7.PCX        "         /         ,         "               *        
   PANEL7.PCX        "         #         /         "               *        
   PANEL7.PCX        -   b     0   b              -   b           *        
   PANEL7.PCX                 0   b                             *        
   PANEL7.PCX           y        y     -   b        y           *        
   PANEL7.PCX        -   b        y     0   b     -   b           *        
   PANEL7.PCX                       #                       *        
   PANEL7.PCX        #                /         #               *        
   PANEL7.PCX        /                .         /               *        
   PANEL7.PCX        .                        .               *        
   PANEL7.PCX                                             *        
   PANEL7.PCX                                             *        
   PANEL7.PCX                         0   b                   *        
   PANEL7.PCX                0   b        y                   *        
   PANEL7.PCX               #                              *        
   PANEL7.PCX                 #                                *        
   PANEL7.PCX        
                          
               *        
   PANEL7.PCX                       $                       *        
   PANEL7.PCX        $                1         $               *        
   PANEL7.PCX        1                2         1               *        
   PANEL7.PCX        2                        2               *        
   PANEL7.PCX                                            *        
   PANEL7.PCX                                              *        
   PANEL7.PCX        
                  3   b     
               *        
   PANEL7.PCX        
         3   b        y     
               *        
   PANEL7.PCX               $                              *        
   PANEL7.PCX                 $                                *        
   PANEL7.PCX        !        2                 !              *        
   PANEL7.PCX        4         2         !        4               *        
   PANEL7.PCX        5         1         2         5               *        
   PANEL7.PCX        5         2         4         5               *        
   PANEL7.PCX        5         $         1         5               *        
   PANEL7.PCX        %         $         5         %               *        
   PANEL7.PCX        6   b     3   b              6   b           *        
   PANEL7.PCX        6   b              
         6   b           *        
   PANEL7.PCX           y        y     3   b        y           *        
   PANEL7.PCX           y     3   b     6   b        y           *        
   PANEL7.PCX               
        %                      *        
   PANEL7.PCX               %         5                      *        
   PANEL7.PCX               5         4                      *        
   PANEL7.PCX               4         !                     *        
   PANEL7.PCX               !                             *        
   PANEL7.PCX                                            *        
   PANEL7.PCX        
                 6   b     
               *        
   PANEL7.PCX        6   b                y     6   b           *        
   PANEL7.PCX        %        
                %              *        
   PANEL7.PCX        %                 	         %              /COCKPIT     
                7   ؙ8      *       /GUN:LASER2                     9      :               /GUN:LASER2                     ;       <              
   /MISSILE:0                     =      >              
   /MISSILE:1                     ?   ؜* @   *       @ANIMATE-XPL5,0,-1     
                A   \pBB   ,DDC   |FGD   H`IA   KK      @ANIMATE-XPL5,0,-1     
                E   \pBF   ,DDG   |FGH   H`IE   KK      @ANIMATE-XPL12,0,-1     
                I   ȂpBJ   ,DDK   |FGL   H`II   KK    j
       E:\PROJECT\SCENERY\DEFAULT.PAL    MAIN             j   &                &          -  J  -  '        k    ,  -  J    %  >  T  |  n  3  '    -     >  |  3'f  *    ]    O    .    f*  "   ]      .    	      [      r    3  "  .  z   '          .z   3    C  7@  7  @        !  w     !      !      !  w             hj(  er  B    B:        hjerB  B:  U   z  z        Ue
  .[3    C  r  3  "  .  [  ]      ]  -  J  >  J  -  >  k4  "  @  "  4  A    4  r:  {rr  r0      T    A|  ~~.    H)          xT          /  /      dM        H            ;      5      $x          ~         *        	   I_COR.PCX        )         F      (   K   {   (   )               *        	   I_COR.PCX        )         K   {   (   %   {      )               *           2COR.PCX           4   3          m      `   m      4   3         *           2COR.PCX           4   3      `   m      J   3      4   3         *           2COR.PCX           %   H      W   H      W   S      %   H         *           2COR.PCX           %   H      W   S      %   S      %   H         *           2COR.PCX               P   	      P         F          P         *           2COR.PCX               P         F          F          P         *           2COR.PCX        E   A   D   J     D   K   ;   A   E   A   D         *           2COR.PCX        %   ;   6   K   ;   A   J     D   %   ;   6         *           2COR.PCX        %   ;   6   J     D   $     ?   %   ;   6         *           2COR.PCX           G   X   
   G   .   	      )      G   X         *           2COR.PCX           G   X   	      )         \      G   X         *           2COR.PCX           (   W      (   /   
   G   .      (   W         *           2COR.PCX           (   W   
   G   .      G   X      (   W         *           2COR.PCX           b   M      b   9         /      b   M         *           2COR.PCX           b   M         /         W      b   M         *           4COR.PCX           '   [      V   [      U   y      '   [         *           4COR.PCX           '   [      U   y      (   y      '   [         *           4COR.PCX           
   V      
   )       q   5      
   V         *           4COR.PCX           
   V       q   5      q   K      
   V         *           4COR.PCX        4         9      !            4               *           4COR.PCX                 9      !                           *           4COR.PCX                 9      !       ~   +                  *           4COR.PCX        ?      !   :                  ?      !         *           4COR.PCX        ?      !                     ?      !         *           4COR.PCX        ?      !               ~   +   ?      !         *           2COR.PCX              D         H         7         D         *           2COR.PCX              D         7         =         D         *           2COR.PCX        #   q   B   I   q   c   H      c   #   q   B         *           2COR.PCX        #   q   B   H      c   +      B   #   q   B         *           2COR.PCX              G         G   
   +   M         G         *           2COR.PCX              ;         ;      +   4         ;         *           2COR.PCX           +   4   
   +   M         G      +   4         *           2COR.PCX           +   4         G         ;      +   4         *           2COR.PCX           9   4      9   N   
   +   M      9   4         *           2COR.PCX           9   4   
   +   M      +   4      9   4         *           2COR.PCX           B   4      B   N      9   N      B   4         *           2COR.PCX           B   4      9   N      9   4      B   4         *           2COR.PCX              1         Q      B   N         1         *           2COR.PCX              1      B   N      B   4         1         *           2COR.PCX        #      R   (   Y   *   !      *   #      R         *           2COR.PCX        (   Y   *   #      R   +   O   S   (   Y   *         *           2COR.PCX        %   g      "      )      w   %   %   g            *           2COR.PCX        )   g   b      w   %   &   w   X   )   g   b         *           2COR.PCX           w   %   )   g   b   %   g         w   %         *           2COR.PCX        (      L   '      U   !      0   (      L         *           2COR.PCX        !      0   '      U   "      )   !      0         *           2COR.PCX        "      )   '     U      w   %   "      )         *           2COR.PCX           w   %   '     U   &   w   X      w   %         *           2COR.PCX        *     ?   G     C   F   \   B   *     ?         *           2COR.PCX        *     ?   F   \   B   )   \   6   *     ?         *           2COR.PCX        $     Z   J     e   I   5   c   $     Z         *           2COR.PCX        $     Z   I   5   c   #   4   A   $     Z         *           2COR.PCX        +     A   H     d   G       ]   +     A         *           2COR.PCX        +     A   G       ]   *       U   +     A         *           1COR.PCX              6   
      ,         =         6         *           1COR.PCX              =   
      ,         *         =         *           1COR.PCX              =         *         2         =         *           1COR.PCX              =         2   
      =         =         *           1COR.PCX        
      =         2   	      5   
      =         *           1COR.PCX        	      5         2         1   	      5         *           1COR.PCX              ,         6         =         ,         *           1COR.PCX              ,         =         *         ,         *           1COR.PCX              *         =         2         *         *           1COR.PCX              2         =         =         2         *           1COR.PCX              2         =         5         2         *           1COR.PCX              2         5         1         2         *           1COR.PCX                       j         j                  *           1COR.PCX                       j                           *           1COR.PCX           F   b         `         N      F   b         *           1COR.PCX           F   b         N         ^      F   b         *           1COR.PCX            F   b         ^         N       F   b         *           1COR.PCX            F   b         N         `       F   b         *           1COR.PCX        $         !         "   {      $               *           1COR.PCX        !         $         #         !               *           1COR.PCX        "   {      %         $         "   {            *           1COR.PCX        +         '   }      (         +               *           1COR.PCX        '   }      +         *         '   }            *           1COR.PCX        *         &         '   }      *               *           1COR.PCX        &         *         )         &               *           3COR.PCX        /      9   .      9   -   "      /      9         *           3COR.PCX        /      9   -   "      ,         /      9         *           3COR.PCX        0         3         /      9   0               *           3COR.PCX        0         /      9   ,         0               *           3COR.PCX        1         0         ,         1               *           3COR.PCX        1         ,         -   "      1               *           3COR.PCX        2         1         -   "      2               *           3COR.PCX        2         -   "      .      9   2               *           3COR.PCX        3         2         .      9   3               *           3COR.PCX        3         .      9   /      9   3               *           3COR.PCX        3         0         1         3               *           3COR.PCX        3         1         2         3               *           2COR.PCX        4      #   5      +   8      :   4      #         *           2COR.PCX        4      #   8      :   9     *   4      #         *           2COR.PCX        8   }  :   5   p  +   7   !   :   8   }  :         *           2COR.PCX        7      :   5     +   6   w   2   7      :         *           2COR.PCX        =      :   7      :   6   w   2   =      :         *           2COR.PCX        =      :   6   w   2   <   w   2   =      :         *           2COR.PCX        ;      +   :      #   >      :   ;      +         *           2COR.PCX        >      :   :      #   ?     *   >      :         *           2COR.PCX        ;   p  +   >   }  :   =   !   :   ;   p  +         *           2COR.PCX        ;     +   =      :   <   w   2   ;     +         *           2COR.PCX        G   X      B      _   A      d   G   X            *           2COR.PCX        B      _   G   X      H      `   B      _         *           2COR.PCX        H      `   C      N   B      _   H      `         *           2COR.PCX        C      N   H      `   I      M   C      N         *           2COR.PCX        I      M   D   '   J   C      N   I      M         *           2COR.PCX        D      J   I      M   J   X      D      J         *           2COR.PCX        J   X      E      G   D      J   J   X            *           2COR.PCX        K   w   E   @   s   g   E   s   G   K   w   E         *           2COR.PCX        @   s   g   K   w   E   F   w   i   @   s   g         *           2COR.PCX        F   w   i   A   &   d   @   s   g   F   w   i         *           2COR.PCX        A      d   F      i   G   X      A      d         *           2COR.PCX        A   &   d   B      _   C      N   A   &   d         *           2COR.PCX        A   &   d   C      N   D   '   J   A   &   d         *           2COR.PCX        A   &   d   D   '   J   E   s   G   A   &   d         *           2COR.PCX        A   &   d   E   s   G   @   s   g   A   &   d         /COCKPIT     
                L   ȕM                /GUN:LASER2                     N   ȕ܍O            /GUN:LASER2                     P   ȕ   Q     =     
   /MISSILE:1                     R   ȕ( S            
   /MISSILE:0                     T   <   U                 @ANIMATE-XPL5,0,-2     
                ^   A_   tCC`   E@Fa   GH^   LJJ      @ANIMATE-XPL5,0,-3     
                b   Ac   tCCd   E@Fe   GHb   LJJ      @ANIMATE-XPL12,0,-1     
                f   ^g   DЌЌh   pҌӌi   ԌpՌf    ׌׌    j
       E:\PROJECT\SCENERY\DEFAULT.PAL    MAIN             d   J0  J  fF  J0  J  fF  n0  
  3  
  ^	  b  L	  b  n0    3    ^	  t  L	  t  J0  <J0  <   I}       }     I     I{    {  I      ]E]	  ]E  ]	    D  D,	    	  ,	  S  	    S          0  0  -0  q-      %  0        %  q  7
  7
  n  6  6  ,  1    1  I  A           K_     _M  K_M    _   K}       }    A}  M  K}      }  M    }  n&
  S
  ^Fb  b  n&  S  ^Ft  t  K(    G    /1  J  F  J  /1  <F  <7  ,  7F  ,  7  7F    \     ?W  Jn   h   P       i  L    L  1oL  a  L    JE\    ~&  E  N>  -  Z8  -  22Z8  x         *        
   BC-6-3.PCX                                                 *        
   BC-6-3.PCX                                                   *        
   BC-6-3.PCX                                                   *        
   BC-6-3.PCX                                               *        
   BC-6-3.PCX                                                *        
   BC-6-3.PCX                                                   *        
   BC-6-3.PCX                 	                                 *        
   BC-6-3.PCX                 	                                 *        
   BC-6-3.PCX        	                          	               *        
   BC-6-3.PCX        	                          	               *        
   BC-6-3.PCX                                                  *        
   BC-6-3.PCX                                                  *        
   BC-6-3.PCX                                                  *        
   BC-6-3.PCX                                                  *        
   BC-6-3.PCX                 
                                 *        
   BC-6-3.PCX                 
         	                        *        
   BC-6-3.PCX                                                  *        
   BC-6-3.PCX                          
                        *        
   BC-6-3.PCX        
                           
               *        
   BC-6-3.PCX        
                  	         
               *        
   BC-6-3.PCX        ?         >                 ?               *        
   BC-6-3.PCX        ?                  
        ?               *        
   BC-6-3.PCX                          >                       *        
   BC-6-3.PCX                 >        B                       *        
   BC-6-3.PCX                
                               *        
   BC-6-3.PCX                                                *        
   BC-6-3.PCX        C         ?         
         C               *        
   BC-6-3.PCX        C         
                  C               *        
   BC-6-3.PCX        B        C                  B              *        
   BC-6-3.PCX                 C                                *        
   BC-6-2.PCX           ;   p      3   ]      7   u      ;   p         *        
   BC-6-2.PCX           3   ]      ;   p      ;   a      3   ]         *        
   BC-6-2.PCX           ;   a      7   u      3   ]      ;   a         *        
   BC-6-2.PCX           7   u      ;   a      ;   p      7   u         *        
   BC-6-2.PCX           y   a      u   Z      y   n      y   a         *        
   BC-6-2.PCX           y   n      u   Z      R   U      y   n         *        
   BC-6-2.PCX           y   n      R   U      H   a      y   n         *        
   BC-6-2.PCX           y   n      H   a      H   o      y   n         *        
   BC-6-2.PCX           u   Z      y   a      y   n      u   Z         *        
   BC-6-2.PCX           u   Z      y   n      R   U      u   Z         *        
   BC-6-2.PCX           R   U      y   n      H   a      R   U         *        
   BC-6-2.PCX           H   a      y   n      H   o      H   a         *        
   BC-6-2.PCX           t         t         y         t            *        
   BC-6-2.PCX           y         t         y         y            *        
   BC-6-2.PCX              J         ,      8   K         J         *        
   BC-6-2.PCX           8   K         ,      8   *      8   K         *        
   BC-6-2.PCX           F         F         m         F            *        
   BC-6-2.PCX           m         F         m         m            *        
   BC-6-2.PCX           /         /         :         /            *        
   BC-6-2.PCX           :         /   !      :         :            *        
   BC-6-2.PCX           @   K      D          D   W      @   K         *        
   BC-6-2.PCX           D          @   K      @   *      D             *        
   BC-6-2.PCX           &   !                        &   !         *        
   BC-6-2.PCX                    &         &                     *        
   BC-6-2.PCX           (   u   "      \   #      }      (   u         *        
   BC-6-2.PCX        "      \      (   u      $   \   "      \         *        
   BC-6-2.PCX           $   \   !      }          \      $   \         *        
   BC-6-2.PCX        !      }      $   \      (   u   !      }         *        
   BC-6-2.PCX           N   V   #   q   !   !   q   V      N   V         *        
   BC-6-2.PCX        #   q   !      N   V      N   !   #   q   !         *        
   BC-6-2.PCX                           "                        *        
   BC-6-2.PCX                                                    *        
   I_BC-8.PCX        !     l   #   s   l             !     l         *        
   I_BC-8.PCX                  #   s   l   "                         *        
   BC-6-1.PCX        $   P   .   &   }   =   )   l   /   $   P   .         *        
   BC-6-1.PCX        $   P   .   )   l   /   (   H   %   $   P   .         *        
   BC-6-1.PCX        %   P   .   *   H   %   +   l   /   %   P   .         *        
   BC-6-1.PCX        %   P   .   +   l   /   '   }   =   %   P   .         *        
   BC-6-1.PCX        '   n   
   +   }   
   )   }      '   n   
         *        
   BC-6-1.PCX        '   n   
   )   }      &   n      '   n   
         *        
   BC-6-1.PCX        +   k      *   E      (   E      +   k            *        
   BC-6-1.PCX        +   k      (   E      )   k   
   +   k            *        
   BC-6-1.PCX        0   Q   I   -      L   /   X   S   0   Q   I         *        
   BC-6-1.PCX        7      >   9      0   5      >   7      >         *        
   BC-6-1.PCX        9      0   7      >   =      0   9      0         *        
   BC-6-1.PCX        <      0   =      0   7      >   <      0         *        
   BC-6-1.PCX        <      0   7      >   3   "   9   <      0         *        
   BC-6-1.PCX        3   "   9   7      >   -      L   3   "   9         *        
   BC-6-1.PCX        3   "   9   -      L   0   Q   I   3   "   9         *        
   BC-6-1.PCX        ,      L   1   Q   I   .   X   S   ,      L         *        
   BC-6-1.PCX        ;      0   4      >   8      0   ;      0         *        
   BC-6-1.PCX        4      >   ;      0   6      >   4      >         *        
   BC-6-1.PCX        ;      0   :      0   6      >   ;      0         *        
   BC-6-1.PCX        6      >   :      0   2   "   9   6      >         *        
   BC-6-1.PCX        6      >   2   "   9   ,      L   6      >         *        
   BC-6-1.PCX        ,      L   2   "   9   1   Q   I   ,      L         *        
   BC-6-1.PCX        ,      |   -      K   6      q   ,      |         *        
   BC-6-1.PCX        6      q   -      K   7      U   6      q         *        
   BC-6-1.PCX        .   W   g   /   W   `   ,      }   .   W   g         *        
   BC-6-1.PCX        ,      }   /   W   `   -      J   ,      }         *        
   BC-6-1.PCX        1   T   M   0   T   S   .   M   N   1   T   M         *        
   BC-6-1.PCX        .   M   N   0   T   S   /   M   R   .   M   N         *        
   BC-6-1.PCX        1   '      3   =   ~   0   /      1   '            *        
   BC-6-1.PCX        2      ~   3   =   ~   1   '      2      ~         *        
   BC-6-1.PCX        :   h   z   <   h   U   2   q   z   :   h   z         *        
   BC-6-1.PCX        2   q   z   <   h   U   3   q   U   2   q   z         *        
   BC-6-1.PCX        6      #   5         4      #   6      #         *        
   BC-6-1.PCX        5         6      #   7         5               *        
   BC-6-1.PCX        =         8      $   9         =               *        
   BC-6-1.PCX        8      $   =         ;      $   8      $         *        
   BC-6-1.PCX        ;      $   =         :      (   ;      $         *        
   BC-6-1.PCX        :      (   =         <         :      (         *        
   BC-6-3.PCX        @         A         >         @               *        
   BC-6-3.PCX        @         >         ?         @               *        
   BC-6-3.PCX        B         >         A         B               *        
   BC-6-3.PCX        B         A         E         B               *        
   BC-6-3.PCX        D         @         ?         D               *        
   BC-6-3.PCX        D         ?         C         D               *        
   BC-6-3.PCX        E         A         @         E               *        
   BC-6-3.PCX        E         @         D         E               *        
   BC-6-3.PCX        E         D         B         E               *        
   BC-6-3.PCX        B         D         C         B               /COCKPIT     
                F   0N   G   S         
   /MISSILE:0                     H   0    I   D      
   /MISSILE:1                     J   0    K                 /GUN:LASER1                     L   0   M             /GUN:LASER1                     N   0   O   D      @ANIMATE-XPL7,0,-3     
                X   TAY   CCZ   TEE[   G8HX   IJ      @ANIMATE-XPL7,0,-3     
                \   TA]   CC^   TEE_   G8H\   IJ      @ANIMATE-XPL10,0,-1     
                `   ]a   x_PЌb   ҌҌc   lԌ Ռ`   ֌P׌    j
       E:\PROJECT\SCENERY\DEFAULT.PAL    MAIN             w     l  "  (
  "      S    i  4      S        "  $  
  "  V      n  S    V  i  4         g  S  g  g  gj    ajw    w        j          x  j6    (!  6  l
    (!    +       +    1  +      1    F      k      V  F  7I  \    M  I    F    s  W  "  +      \                        "             W  M  1  c        k  +    +         
    W  ]    Z        g          G  U  "  m  E        ;        '         j    W      W      W  O  W     W  TW  W  )  W    XW  y  YW       W  -  C    D  C    3    A    3  A  x  j[x  j&j[&j?~  /    4    [  xx    h  z  Z_  Z2|Z;  Z]   {  -{  {    {  -     {  E  {    {    {    f2  {  3  {  9>{    {           *        
   BC-9-3.PCX              B   
      B         9         B         *        
   BC-9-3.PCX              9   
      B   	      9         9         *        
   BC-9-4.PCX           )   I      ,   H      +   P      )   I         *        
   BC-9-4.PCX           +   P      ,   H       ,   W      +   P         *        
   BC-9-4.PCX           +   P       ,   W      +   j      +   P         *        
   BC-9-4.PCX           +   P      +   j      )   t      +   P         *        
   BC-9-4.PCX           )   t      +   j      (         )   t         *        
   BC-9-4.PCX            ,   W      "   W      +   j       ,   W         *        
   BC-9-4.PCX           +   j      "   W   
   #   j      +   j         *        
   BC-9-4.PCX           ,   H      "   H       ,   W      ,   H         *        
   BC-9-4.PCX            ,   W      "   H      "   W       ,   W         *        
   BC-9-4.PCX           )   I   	   %   I      ,   H      )   I         *        
   BC-9-4.PCX           ,   H   	   %   I      "   H      ,   H         *        
   BC-9-4.PCX           )   t      %   t      +   P      )   t         *        
   BC-9-4.PCX           +   P      %   t   
   #   P      +   P         *        
   BC-9-4.PCX           (         &         )   t      (            *        
   BC-9-4.PCX           )   t      &         %   t      )   t         *        
   BC-9-4.PCX           +   j   
   #   j      (         +   j         *        
   BC-9-4.PCX           (      
   #   j      &         (            *        
   BC-9-4.PCX           "   H   	   %   I   
   #   P      "   H         *        
   BC-9-4.PCX           "   H   
   #   P      "   W      "   H         *        
   BC-9-4.PCX           "   W   
   #   P   
   #   j      "   W         *        
   BC-9-4.PCX        
   #   j   
   #   P      %   t   
   #   j         *        
   BC-9-4.PCX        
   #   j      %   t      &      
   #   j         *        
   BC-9-5.PCX        /         '   
   !   -   l   !   /               *        
   BC-9-4.PCX        R   J      S   B     .   _   x   R   J            *        
   BC-9-4.PCX        .   _   x   S   B     ,   /  y   .   _   x         *        
   BC-9-5.PCX              7      }   f         
         7         *        
   BC-9-5.PCX           Z   7      1   
      |   
      Z   7         *        
   BC-9-5.PCX           |   
      Z   7      Z   7      |   
         *        
   BC-9-5.PCX           |   
      Z   7      |   
      |   
         *        
   BC-9-5.PCX           1   
      |   
      |   
      1   
         *        
   BC-9-5.PCX           1   
      |   
      1   
      1   
         *        
   BC-9-5.PCX           }   f         
         
      }   f         *        
   BC-9-5.PCX           }   f         
      }   f      }   f         *        
   BC-9-5.PCX              7      }   f      }   f         7         *        
   BC-9-5.PCX              7      }   f         7         7         *        
   BC-9-5.PCX           Z   7      |   
      1   
      Z   7         *        
   BC-9-5.PCX              7         
      }   f         7         *        
   BC-9-5.PCX              7      }   f         
         7         *        
   BC-9-5.PCX           Z   7      1   
      |   
      Z   7         *        
   BC-9-5.PCX           |   
      Z   7      Z   7      |   
         *        
   BC-9-5.PCX           |   
      Z   7      |   
      |   
         *        
   BC-9-5.PCX           1   
      |   
      |   
      1   
         *        
   BC-9-5.PCX           1   
      |   
      1   
      1   
         *        
   BC-9-5.PCX           }   f         
         
      }   f         *        
   BC-9-5.PCX           }   f         
      }   f      }   f         *        
   BC-9-5.PCX              7      }   f      }   f         7         *        
   BC-9-5.PCX              7      }   f         7         7         *        
   BC-9-5.PCX           Z   7      |   
      1   
      Z   7         *        
   BC-9-5.PCX              7         
      }   f         7         *        
   I_BC-9.PCX        +         *         '   d      +               *        
   I_BC-9.PCX        +         '   d      /   d      +               *        
   I_BC-9.PCX        *         9      >   8   d   >   *               *        
   I_BC-9.PCX        *         8   d   >   '   d      *               *        
   BC-9-3.PCX        !   x   O       )   c      )   #   !   x   O         *        
   BC-9-3.PCX        !   x   O      )   #      x   8   !   x   O         *        
   BC-9-3.PCX        &   E   a   !   r   a      r   z   &   E   a         *        
   BC-9-3.PCX        &   E   a      r   z   $   E   z   &   E   a         *        
   BC-9-3.PCX        $      "      /   "            $      "         *        
   BC-9-3.PCX        $      "            #         $      "         *        
   BC-9-3.PCX        &      "   %                   &      "         *        
   BC-9-3.PCX        &      "             !   /   "   &      "         *        
   BC-9-3.PCX        #      $   "      $   %   $   $   #      $         *        
   BC-9-3.PCX        %   $   $   &   "   C   $      C   %   $   $         *        
   BC-9-3.PCX        %   $   $   $      C   #      $   %   $   $         *        
   BC-9-2.PCX        X      3   W   \   .   N      .   X      3         *        
   BC-9-2.PCX        N      .   W   \   .   V   0   "   N      .         *        
   BC-9-2.PCX        N      .   V   0   "   O      !   N      .         *        
   BC-9-2.PCX        O      !   V   0   "   U         O      !         *        
   BC-9-2.PCX        O     !  U       T         O     !        *        
   BC-9-2.PCX        O     !  T         P     
  O     !        *        
   BC-9-2.PCX        P     
  T         Q   #     P     
        *        
   BC-9-2.PCX        Q   #     T         S         Q   #           *        
   BC-9-2.PCX        Q   #     S         R   )     Q   #           *        
   BC-9-2.PCX        F   Y   %  :        9         F   Y   %        *        
   BC-9-2.PCX        F   Y   %  9         *   Y      F   Y   %        *        
   BC-9-2.PCX        '   Y      8         7      H  '   Y            *        
   BC-9-2.PCX        '   Y      7      H  -   Y   P  '   Y            *        
   BC-9-5.PCX        .   I   	   -   l   !   E   y   !   .   I   	         *        
   BC-9-5.PCX        .   I   	   E   y   !   R   `      .   I   	         *        
   BC-9-2.PCX        (   D      )     -   ?   D     (   D            *        
   BC-9-2.PCX        B   Y      3         2        B   Y            *        
   BC-9-2.PCX        G        ;        :         G              *        
   BC-9-2.PCX        G        :         F         G              *        
   BC-9-2.PCX        H      5   <      ,   ;         H      5         *        
   BC-9-2.PCX        H      5   ;         G         H      5         *        
   BC-9-2.PCX        I      P   <      ,   H      5   I      P         *        
   BC-9-2.PCX        I      P   =      |   <      ,   I      P         *        
   BC-9-2.PCX        J         =      |   I      P   J               *        
   BC-9-2.PCX        K         >         =      |   K               *        
   BC-9-2.PCX        K         =      |   J         K               *        
   BC-9-2.PCX        C         4      y   3         C               *        
   BC-9-2.PCX        C         3         B         C               *        
   BC-9-2.PCX        D      M   5      M   4      y   D      M         *        
   BC-9-2.PCX        D      M   4      y   C         D      M         *        
   BC-9-2.PCX        D      M   6         5      M   D      M         *        
   BC-9-2.PCX        E         6         D      M   E               *        
   BC-9-2.PCX        -         7         6        -               *        
   BC-9-2.PCX        -         6        E        -               *        
   BC-9-5.PCX        ,   L   	   F   n   !   *      !   ,   L   	         *        
   BC-9-5.PCX        ,   L   	   *      !   +         ,   L   	         *        
   BC-9-5.PCX        S   c      F   n   !   ,   L   	   S   c            *        
   BC-9-4.PCX        .   _   q   ,   /  p   /         .   _   q         *        
   BC-9-4.PCX        /   !      ,      p   +   l      /   !            *        
   BC-9-5.PCX        /         -   l   !   .   I   	   /               *        
   BC-9-2.PCX        ;        7   8     :         ;              *        
   BC-9-2.PCX        ?   _   <  1   .      0   ]      ?   _   <        *        
   BC-9-2.PCX        ?   _   <  2      <  >   0      ?   _   <        *        
   BC-9-2.PCX        >   0      2      <  3         >   0            *        
   BC-9-2.PCX        >   0      3         =   	   |   >   0            *        
   BC-9-2.PCX        =   	  |   3        <      ,   =   	  |         *        
   BC-9-2.PCX        <      ,   3        4     y   <      ,         *        
   BC-9-2.PCX        <      ,   4     y   5     M   <      ,         *        
   BC-9-2.PCX        <      ,   5     M   6   5     <      ,         *        
   BC-9-2.PCX        <      ,  6   5    7   8     <      ,        *        
   BC-9-2.PCX        <      ,  7   8     ;        <      ,        *        
   BC-9-2.PCX        :        7   8    8        :              *        
   BC-9-2.PCX        :        8        9   S     :              *        
   BC-9-2.PCX        A         2      <  @      <  A               *        
   BC-9-2.PCX        A         @      <  M         A               *        
   BC-9-2.PCX        B         2      <  A         B               *        
   BC-9-2.PCX        L   Z      >   0      K   ,      L   Z            *        
   BC-9-2.PCX        M         @      <  ?   _   <  M               *        
   BC-9-2.PCX        M         ?   _   <  L   Z      M               *        
   BC-9-2.PCX        N      .   A         M         N      .         *        
   BC-9-2.PCX        N      .   M         X      3   N      .         *        
   BC-9-2.PCX        O      !   B         A         O      !         *        
   BC-9-2.PCX        O      !   A         N      .   O      !         *        
   BC-9-2.PCX        P     
   C   
     B         P     
         *        
   BC-9-2.PCX        P     
   B         O      !   P     
         *        
   BC-9-2.PCX        Q   #     D   +  M  C   
    Q   #           *        
   BC-9-2.PCX        Q   #     C   
    P     
  Q   #           *        
   BC-9-2.PCX        R   )     E   >    D   +  M  R   )           *        
   BC-9-2.PCX        R   )     D   +  M  Q   #     R   )           *        
   BC-9-2.PCX        S         G        F         S               *        
   BC-9-2.PCX        S         H      5  G        S               *        
   BC-9-2.PCX        T         I      P  H      5  T               *        
   BC-9-2.PCX        T         H      5  S         T               *        
   BC-9-2.PCX        U        J        I      P   U              *        
   BC-9-2.PCX        U       I      P  T         U             *        
   BC-9-2.PCX        V   0   "   K   ,      J         V   0   "         *        
   BC-9-2.PCX        V   0   "   J         U         V   0   "         *        
   BC-9-2.PCX        W   \   .   L   Z      K   ,      W   \   .         *        
   BC-9-2.PCX        W   \   .   K   ,      V   0   "   W   \   .         *        
   BC-9-2.PCX        X      3   M         L   Z      X      3         *        
   BC-9-2.PCX        X      3   L   Z      W   \   .   X      3         /COCKPIT     
                Y       Z   D   0      /GUN:LASER2                     [   ,   \   [           /GUN:LASER2                     ]   (^          
   /MISSILE:1                     _   (   `         
   /MISSILE:0                     a   (  b   c           @ANIMATE-XPL7,0,-2     
                k   (Bl   dDDm   FHGn   IIk   TKK      @ANIMATE-XPL7,0,-2     
                o   (Bp   dDDq   FHGr   IIo   TKK      @ANIMATE-XPL11,0,-1     
                s   jt     u   av   js         j
       E:\PROJECT\SCENERY\DEFAULT.PAL    MAIN             x   B"    B"  B    '    '  2p     F  g    G     j{    4  C6  Yz     x  R4  P6    ^                                  4  Y  _  ff  Ww  VL            Y  _  ff  ^   w  V  L  aCgA      ,  C      H  +  C  \   F  j      T0  @     f      G        ,    0E  3    ,    H  +  \       t      5    $    <    ni    u
    FI  u
    &  I      3s    5  "  (Z      F
  FF  
  &  j  aC+Y   xuPgs#    7        F%    F  1F,&  1F-  I  >  I  -  '>  'Sa  =  <  ۣy?b  J  Ke    h      TH    ]   9  -     ?    	    	  ~&  !  E&u           *        	   I_IN2.PCX           w      1   w   '   7      '      w            *        	   I_IN2.PCX           w      7      '               w            *           3IN2.PCX           4   4          4   )   ?         4   4         *           3IN2.PCX        )   ?             4   ;         )   ?            *           3IN2.PCX        ,   D   |          6      5   6   ,   D   |         *           3IN2.PCX               6   ,   D   |   ?      |          6         *           3IN2.PCX        ?   j      ;   L          L      ?   j            *           3IN2.PCX        ;   L      ?   j      >   k      ;   L            *           3IN2.PCX        +   l         K      )   L      +   l            *           3IN2.PCX           K   5   +   l      ,   k   |      K   5         *           2IN2.PCX        *         .   ~   o         3   *               *           2IN2.PCX        =   ^            3      `   3   =   ^            *           2IN2.PCX              3   =   ^      *               3         *           2IN2.PCX           `   3         3   .   ~   o      `   3         *           2IN2.PCX           `   3   .   ~   o   /   d   o      `   3         *           2IN2.PCX           /   M   <   V   K   =      H      /   M         *           2IN2.PCX        <   V   K      /   M   /   j   [   <   V   K         *           2IN2.PCX        .   j   [   *      H   6   V   K   .   j   [         *           1IN2.PCX        ,      G   *      Q   =      Q   ,      G         *           1IN2.PCX        ,      G   =      Q   ?      G   ,      G         *           1IN2.PCX        )      X   ;      $   I   U   $   )      X         *           1IN2.PCX        )      X   I   U   $   @   U   X   )      X         *           2IN2.PCX           f   v         S      a   S      f   v         *           2IN2.PCX              S      f   v         w         S         *           2IN2.PCX        D         L   a         a   S   D               *           2IN2.PCX        D            a   S         S   D               *           2IN2.PCX           !   ;      U   :   L   	   3      !   ;         *           2IN2.PCX           U   :      !   ;      w   A      U   :         *           2IN2.PCX           !   ;   -   !   L   1   w   K      !   ;         *           2IN2.PCX           !   ;   1   w   K      w   A      !   ;         *           2IN2.PCX           w   A   D      3      T   :      w   A         *           2IN2.PCX        D      3      w   A   H      ;   D      3         *           2IN2.PCX           w   A   7   w   K   F      L      w   A         *           2IN2.PCX           w   A   F      L   H      ;      w   A         *           1IN2.PCX        	      :            
         	      :         *           1IN2.PCX        
                           
               *           1IN2.PCX                 
      ;                           *           1IN2.PCX                                                  *           2IN2.PCX           4   w      J   w      O         4   w         *           2IN2.PCX           4   w      O         /         4   w         *           2IN2.PCX           R   ~      J         4         R   ~         *           2IN2.PCX           R   ~      4         ,   ~      R   ~         *           1IN2.PCX              d      K   X      -   g         d         *           1IN2.PCX              d      -   g        i         d         *           1IN2.PCX           K   X         d        h      K   X         *           1IN2.PCX           K   X        h      -   g      K   X         *           1IN2.PCX              7         7         X         7         *           1IN2.PCX              7         X         W         7         *           2IN2.PCX        @   S      I   2      C   c   @   @   S            *           2IN2.PCX        C   c   @   I   2      M      ?   C   c   @         *           2IN2.PCX        C   c   @   M      ?   D   [      C   c   @         *           2IN2.PCX        D   [      M      ?   L   )      D   [            *           2IN2.PCX        #   @   Z      =   Z      =   g   #   @   Z         *           2IN2.PCX        #   @   Z      =   g   "   @   g   #   @   Z         *           2IN2.PCX        $   @   M      =   M      =   Z   $   @   M         *           2IN2.PCX        $   @   M      =   Z   #   @   Z   $   @   M         *           2IN2.PCX        %   C   (      <   (      >      %   C   (         *           2IN2.PCX        %   C   (      >      $   A      %   C   (         *           2IN2.PCX        &   M         2         <   (   &   M            *           2IN2.PCX        &   M         <   (   %   C   (   &   M            *           4IN2.PCX                                ;                  *           4IN2.PCX              ;                           ;         *           4IN2.PCX              ;                  5         ;         *           4IN2.PCX              5                  0         5         *           4IN2.PCX              0               	   !         0         *           4IN2.PCX        $         #         "      ;   $               *           4IN2.PCX        $         "      ;   %         $               *           4IN2.PCX        %         "      ;   !      5   %               *           4IN2.PCX        %         !      5          0   %               *           4IN2.PCX        %                0   &   	   !   %               *           1IN2.PCX        Y        U        T      {   Y              *           1IN2.PCX        Y        T      {   (         Y              *           2IN2.PCX        W   T   ?   '   S   <   R      <   W   T   ?         *           2IN2.PCX        W   T   ?   R      <   V      C   W   T   ?         *           2IN2.PCX        (   E   @   T   E   =   '   S   <   (   E   @         *           2IN2.PCX        (   E   @   '   S   <   W   T   ?   (   E   @         *           1IN2.PCX        B      g   )   _   Z   @      W   B      g         *           1IN2.PCX        )   _   Z   B      g   +   {   n   )   _   Z         *           1IN2.PCX        +   {   n   6   |      *      {   +   {   n         *           1IN2.PCX        +   {   n   *      {   ,      p   +   {   n         *           1IN2.PCX        B      g   A         6   |      B      g         *           1IN2.PCX        B      g   6   |      +   {   n   B      g         *           2IN2.PCX        1         3      :   2      "   1               *           2IN2.PCX        J   >       /      6   0   -   C   J   >             *           2IN2.PCX        /      6