#include <pc.h>
#include <dos.h>
#include <time.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>

#include "parser.h"

#define USERS 50
#define MINUSERS 20

#define MINDELAY 1
#define MAXDELAY 3
#define ACTIONS 10

#define SPEED 800
#define RESOLUTION 50

FILE *debug;

char odds[ACTIONS] = { 0, 0, 0, 0, 0, 0, 0, 1, 2, 3 };

char users[USERS][40] = {
"Kalle Eskonen",
"Asko Kavalahti",
"Erno Kumpulainen",
"Anni Kuusela",
"Jukka Hakakangas",
"Arno Uutilainen",
"Gruuve X Komppi",
"Antti Grn",
"Juha Penttil",
"Esko Savilainen",

"Jaakko Kuivala",
"Jukka Leppilampi",
"Aaro Kivel",
"Minna Aulainen",
"Tiina Sarasvuo",
"Pekka Holopainen",
"Jari Erkkil",
"Juho Pekkala",
"Usko Toivonen",
"Gunnar Hgnabba",

"Anni Kuusela",
"Daniel Saarilahti",
"Sami X Kumpulainen",
"Erkki Kontti",
"Heikki Lampela",
"Heidi Kivel",
"Ari Huojakangas",
"Timo Brandt",
"Riikka Koivisto",
"Jarkko Parkainen",

"Esko Samelainen",
"Anni Uusilahti",
"Keijo Kukkaro",
"Mertsi Auvalainen",
"Jukka Pkknen",
"Sami Korpela",
"Sami Pistemaa",
"Juha Hgnabba",
"Maija Huhtala",
"Tiina Sorvoja",

"Joonas Pihlajamaa",
"Jari Karppanen",
"Jyri Pieniniemi",
"Sami Kuronen",
"Teemu Keinonen",
"Tomi Jutila",
"Ilja Brysy",
"Erik J Seesjrvi",
"Tommi Kemppainen",
"Ilkka Pelkonen"
};

char aliases[USERS][10] = {
"Kale",
"Akke",
"Convex",
"Annie",
"Jukka",
"Arnie",
"Grovie",
"Ana",
"JuPPi",
"EkE",

"Jake",
"Juke",
"Arttu",
"Stilette",
"Babe",
"Petie",
"Gram",
"Aural/M",
"Gunnar",
"EkE",

"Annie",
"Murhaaja",
"Sex",
"Ekke",
"Fast",
"Heidi",
"Ural",
"Timppa",
"Riikkis",
"Flame/NS",

"Quazar",
"HMPP",
"Erzy",
"Mal",
"JUMALA",
"perkele",
"Samstorm",
"Stimpy",
"Mudler",
"Tiina",

"Jokke^BK",
"Pappa",
"Organic",
"Spook/BK",
"Brainles",
"Lobotomy",
"Ilja",
"Drake",
"Umbater",
"Ica/2"
};

char orglevels[USERS] = {
 4, 3, 5, 3, 6, 8, 2, 4, 2, 1,
 0, 6, 5, 2, 4, 3, 6, 2, 0, 9,
 0, 3, 5, 4, 4, 7, 8, 5, 3, 7,
 4, 5, 2, 3, 4, 7, 2, 2, 1, 0,
 8, 8, 7, 7, 6, 4, 3, 6, 7, 8
};

char levels[USERS] = {
 4, 3, 5, 3, 6, 8, 2, 4, 2, 1,
 0, 6, 5, 2, 4, 3, 6, 2, 0, 9,
 0, 3, 5, 4, 4, 7, 8, 5, 3, 7,
 4, 5, 2, 3, 4, 7, 2, 2, 1, 0,
 8, 8, 7, 7, 6, 4, 3, 6, 7, 8
};

char userlist[USERS+1], usernum;

void AddUser() {
    int user=-1;

    while(memchr(userlist, user, usernum)!=NULL || user==-1)
        user=rand()%USERS;
    userlist[(int)usernum]=user;
    usernum++;
}

void RemoveUser(int user) {
    int loop;
    int alku=(int)(memchr(userlist, user, usernum))-(int)(userlist);

    if(alku<0) {
        printf("This shouldn't happen! User %d", user);
        exit(EXIT_FAILURE);
    }

    usernum--;
    for(loop=alku; loop<usernum; loop++)
        userlist[loop]=userlist[loop+1];
}

void PrintNode(int user, char *dest) {
    if(user+1<10) sprintf(dest, "( %d) ", user+1);
    else if(user+1<100) sprintf(dest, "(%d) ", user+1);
    else if(user+1<1000) sprintf(dest, "(%d)", user+1);
}

void PrintUser(int user, char *dest) {
    int loop;

    sprintf(dest, "%s", aliases[user]);
    for(loop=8-strlen(aliases[user]); loop>0; loop--) strcat(dest, " ");
}

void PrintTarget(int fuser, char *dest) {
    int user=rand()%(usernum+1)-1;

    while(user==fuser)
        user=rand()%(usernum+1)-1;
    user++;

    if(user==0) sprintf(dest, "   : ");
    else if(user<10) sprintf(dest, "  %d: ", user);
    else if(user<100) sprintf(dest, " %d: ", user);
    else if(user<1000) sprintf(dest, "%d: ", user);
}

void PrintPrivateTarget(int user, char *dest) {
    if(user<10) sprintf(dest, "  %d> ", user);
    else if(user<100) sprintf(dest, " %d> ", user);
    else if(user<1000) sprintf(dest, "%d> ", user);
}

void PrintSentence(int user, char *dest) {
    NewSentence(levels[user], dest);
}

void NewLine(int user) {
    char string[512]="";

    PrintNode(user, string+strlen(string));
    PrintUser(user, string+strlen(string));
    PrintTarget(user, string+strlen(string));
    PrintSentence(user, string+strlen(string));
    cprintf("%s\r\n", string);
}

void PrintOwn(int node, char *alias, char *to, char *line) {
    char string[512]="";
    int loop;

    PrintNode(node, string+strlen(string));
    sprintf(string+strlen(string), "%s", alias);
    for(loop=8-strlen(alias); loop>0; loop--) strcat(string, " ");
    sprintf(string+strlen(string), "%s", to);
    if(strlen(line)>61)
        sprintf(string+strlen(string), "%s", line+strlen(line)-61);
    else
        sprintf(string+strlen(string), "%s", line);
    cprintf("\r%s", string);
    if(strlen(string)<80) {
        for(loop=strlen(string); loop<79; loop++) putch(' ');
        gotoxy(strlen(string)+1, wherey());
    }
    fflush(stdout);
}

void PrintOwnLine(int node, char *alias, char *to, char *line) {
    char string[512]="";
    int loop;

    PrintNode(node, string+strlen(string));
    sprintf(string+strlen(string), "%s", alias);
    for(loop=8-strlen(alias); loop>0; loop--) strcat(string, " ");
    sprintf(string+strlen(string), "%s", to);
    FormatString(line);
    sprintf(string+strlen(string), "%s", line);
    cprintf("%s\r\n", string);
}

void NewPrivate(int user) {
    char string[512]="";

    sound(1100);
    delay(40);
    nosound();

    PrintNode(user, string+strlen(string));
    PrintUser(user, string+strlen(string));
    PrintPrivateTarget(99, string+strlen(string));
    PrintSentence(user, string+strlen(string));
    cprintf("%s\r\n", string);
}

void ComeLine(int user) {
    char string[512]="";

    PrintNode(user, string+strlen(string));
    PrintUser(user, string+strlen(string));
    sprintf(string+strlen(string), "   ! ");
    sprintf(string+strlen(string), "%s - TULI KESKUSTELUUN KLO 6:66",
            users[user]);
    cprintf("%s\r\n", string);
}

void ExitLine(int user) {
    char string[512]="";

    PrintNode(user, string+strlen(string));
    PrintUser(user, string+strlen(string));
    sprintf(string+strlen(string), "   ! ");
    sprintf(string+strlen(string), "%s - LHTI KESKUSTELUSTA KLO 6:66",
            users[user]);
    cprintf("%s\r\n", string);
}

int ParseLine(char *string, char *alias, char *to) {
    char temp[512], newto[20];
    int loop, newnode=0, number, priv=-1;

    if(stricmp(string, "lopeta")==0 || stricmp(string, "q")==0
       || stricmp(string, "quit")==0 || stricmp(string, "exit")==0)
        return 1;
    if(string[0]=='@' || string[0]=='=') {
        for(loop=1; loop<9; loop++)
            if(string[loop]==' ' || string[loop]==0)
                break;
            else
                alias[loop-1]=string[loop];
        alias[loop-1]=0;
        return 0;
    }

    for(loop=0; loop<10; loop++) {
        number=string[loop]-'0';
        if(number<10 && number>=0) {
            newnode*=10;
            newnode+=number;
        } else if(string[loop]=='>') {
            priv=1;
            break;
        } else if(string[loop]==':') {
            priv=0;
            break;
        }
    }

    if(newnode || priv==0) {
        strcpy(temp, string+loop+1);
        strcpy(string, temp);
        if(newnode) {
            if(newnode<10)
                strcpy(newto, "  ");
            else if(newnode<100)
                strcpy(newto, " ");
            itoa(newnode, temp, 10);
            strcat(newto, temp);
        } else strcpy(newto, "   ");
        if(priv)
            strcat(newto, "> ");
        else
            strcat(newto, ": ");
    } else strcpy(newto, to);
    for(loop=strlen(string)-1; loop>=0; loop--)
        if(string[loop]==32) string[loop]=0;
        else break;

    if(strlen(string)==0) {
        strcpy(to, newto);
    } else {
        textattr(11);
        cprintf("                                                                                ");
        gotoxy(1, wherey()-1);
        PrintOwnLine(100, alias, newto, string);
    }
    return 0;
}

void SetLevel(int virtlevel) {
    int loop;

    for(loop=0; loop<USERS; loop++) {
        if(orglevels[loop]+virtlevel<0)
            levels[loop]=0;
        else if(orglevels[loop]+virtlevel>=LEVELS)
            levels[loop]=LEVELS-1;
        else
            levels[loop]=orglevels[loop]+virtlevel;
    }
}

int main(int arguments, char **argument) {
    int loop, help, ch, quit=0, wait=100, virtlevel=0;
    char alias[10]="", name[40]="",
         line[512]="", to[10]="   : ";
    char dataname[80]="CHATSIM.DAT";

    if(arguments>1) {
        if(strcmp(argument[1], "/?")==0 ||
           strcmp(argument[1], "-?")==0 ||
           stricmp(argument[1], "/h")==0 ||
           stricmp(argument[1], "-h")==0 ||
           stricmp(argument[1], "--help")==0) {
            puts("CHATSIM [-f<datafile>] [-n<name>] [-a<alias>] [-v<chatlevel>]");
            return EXIT_SUCCESS;
        }
        for(loop=1; loop<arguments;) {
            switch(argument[loop][1]) {
                case 'f': strcpy(dataname, &argument[loop][2]);
                          loop++;
                          break;
                case 'n': strcpy(name, &argument[loop][2]);
                          loop++;
                          while(loop<arguments) {
                              if(argument[loop][0]=='-')
                                  break;
                              strcat(name, " ");
                              strcat(name, argument[loop]);
                              loop++;
                          }
                          break;
                case 'a': strcpy(alias, &argument[loop][2]);
                          loop++;
                          break;
                case 'v': strcpy(line, &argument[loop][2]);
                          virtlevel=atoi(line);
                          SetLevel(virtlevel);
                          strcpy(line, "");
                          loop++;
                          break;
                default:  loop++; break;
            }
        }
    }

    clrscr();
    textattr(12);
    if(strcmp(name, "")==0) {
        cprintf("Anna nimesi: ");
        fflush(stdout);
        gets(name);
    }
    if(strcmp(alias, "")==0) {
        cprintf("Anna aliaksesi: ");
        fflush(stdout);
        gets(alias);
    }

    LoadData(dataname);
    srand(time(NULL));
    help=rand()%(USERS-MINUSERS)+MINUSERS;
    for(usernum=0; usernum<help;)
        AddUser();
    puts("");
    while(!quit) {
        if(wait==0) {
          switch(odds[rand()%ACTIONS]) {
            case 0: textattr(10);
                    if(usernum>0) {
                        cprintf("                                                                                ");
                        gotoxy(1, wherey()-1);
                        NewLine(userlist[rand()%usernum]);
                    }
                    break;
            case 1: textattr(12);
                    if(usernum>0) {
                        cprintf("                                                                                ");
                        gotoxy(1, wherey()-1);
                        help=userlist[rand()%usernum];
                        ExitLine(help);
                        RemoveUser(help);
                    }
                    break;
            case 2: textattr(12);
                    if(usernum<USERS) {
                        cprintf("                                                                                ");
                        gotoxy(1, wherey()-1);
                        AddUser();
                        ComeLine(userlist[usernum-1]);
                    }
                    break;
            case 3: textattr(15);
                    if(usernum>0) {
                        cprintf("                                                                                ");
                        gotoxy(1, wherey()-1);
                        NewPrivate(userlist[rand()%usernum]);
                    }
                    break;
          }
          wait=RESOLUTION;
        }
        wait--;
        while(kbhit()) {
            switch((ch=getch())) {
                case 13: if(ParseLine(line, alias, to))
                             quit=1;
                         strcpy(line, "");
                         break;
                case  8: line[strlen(line)-1]=0;
                         break;
                case  9: break;
                case 27: break;
                case  0: switch(getch()) {
                             case 72: if(virtlevel>=10) break;
                                      virtlevel++;
                                      textattr(12);
                                      SetLevel(virtlevel);
                                      cprintf("\r\nINCREASED VIRTUAL CHAR LEVEL TO %d\r\n", virtlevel);
                                      break;
                             case 80: if(virtlevel<=-10) break;
                                      virtlevel--;
                                      textattr(12);
                                      SetLevel(virtlevel);
                                      cprintf("\r\nDECREASED VIRTUAL CHAR LEVEL to %d\r\n", virtlevel);
                                      break;
                         }
                         break;
                default: line[strlen(line)+1]=0;
                         line[strlen(line)]=ch;
                         break;
            }
        }
        textattr(11);
        PrintOwn(100, alias, to, line);
        _setcursortype(_NORMALCURSOR);
         delay((rand()%(MAXDELAY-MINDELAY)+MINDELAY)*SPEED/RESOLUTION);
        _setcursortype(_NOCURSOR);
        gotoxy(1, wherey());
    }
    return EXIT_SUCCESS;
}
