#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "parser.h"

DATA data;

void FormatString(char *string) {
    int loop, last;
    char temp[512];

    for(loop=0, last=62; loop<62 && loop<strlen(string); loop++)
        if(string[loop]==32)
            last=loop;
    if(loop<strlen(string)) {
        strcpy(temp, &string[last]);
        strcpy(&string[last+19], temp);
        string[last]='\r';
        string[last+1]='\n';
        for(loop=last+2; loop<last+19; loop++)
            string[loop]=32;
        FormatString(&string[last+19]);
    }
}

void FillString(char *dest, char *src) {
    int loop, sl;
    char id[80];

    strcpy(dest, "");

    for(loop=0; loop<strlen(src); loop++) {
        if(src[loop]=='@') {
            for(loop+=1, sl=0; src[loop]!='@'; loop++, sl++) {
                id[sl]=src[loop];
                id[sl+1]=0;
            }
            for(sl=0; sl<data.categories; sl++) {
                if(stricmp(data.category[sl].identifier, id)==0) {
                    FillString(&dest[strlen(dest)],
                               data.category[sl].string[
                                   rand()%data.category[sl].number]);
                    break;
                }
            }
        } else {
            dest[strlen(dest)+1]=0;
            dest[strlen(dest)]=src[loop];
        }
    }
}

void NewSentence(int level, char *dest) {
    FillString(dest, data.category[0].string[level]);
    FormatString(dest);
}

void GetNextLine(char *string, int max, FILE *handle) {
    do {
        fgets(string, max, handle);
        strcpy(strchr(string, '\n'), "");
    } while(strlen(string)==0 || string[0]==';');
}

void LoadData(char *filename) {
    FILE *handle=fopen(filename, "rt");
    char temp[255];
    int loop;

    GetNextLine(temp, 255, handle);
    data.categories=atoi(strchr(temp, '=')+1);
    data.category=(CATEGORY *)malloc(sizeof(CATEGORY)*data.categories);
    for(loop=0; loop<data.categories; loop++) {
        LoadCategory(handle, &data.category[loop]);
    }
    fclose(handle);
}

void LoadCategory(FILE *handle, CATEGORY *category) {
    char temp[256];
    int loop;

    GetNextLine(temp, 256, handle);
    category->number=atoi(strchr(temp, '=')+1);
    strcpy(strchr(temp, '='), "");
    strcpy(category->identifier, temp);
    printf("Ladataan kategoria %s...\n", category->identifier);
    category->string=(char **)malloc(sizeof(char *)*category->number);
    for(loop=0; loop<category->number; loop++) {
        category->string[loop]=(char *)malloc(255);
        GetNextLine(category->string[loop], 255, handle);
    }
}
