#ifndef __WHARF_H
#define __WHARF_H

#include "../litestep/wharfdata.h"

#define WHARF_UP                0
#define WHARF_DOWN              1
#define WHARF_LEFT              2
#define WHARF_RIGHT             3

typedef struct {
        HINSTANCE hInst;
        HWND hWnd;
		HWND taskWnd;
        HBITMAP backImage;
		HBITMAP frontImage;
		BOOL showbg;
//		BOOL bPressed;
		char szName[256];
        char szCommand[MAX_PATH];
		char szParameters[256];
		int (FAR *initWharfModule)(HWND, HINSTANCE, wharfDataType*);
		int (FAR *quitWharfModule)(HINSTANCE);
		HRGN (FAR *GetLSRegion)(int, int);
        } subwharfType;

typedef struct {
        HINSTANCE hInst;
        HWND hWnd;
        HWND hsubwharfWnd;
        HBITMAP backImage;
		HBITMAP frontImage;
		char szName[256];
        char szCommand[MAX_PATH];
		char szParameters[256];
        int numSubwharfs;
        int subwharfX;
        int subwharfY;
        BOOL subwharfOpen;
		BOOL closing;
		BOOL showbg;
		BOOL bPressed;
		BOOL bTogglePressed;
		int closingPos;
		int (FAR *initWharfModule)(HWND, HINSTANCE, wharfDataType*);
		int (FAR *quitWharfModule)(HINSTANCE);
		HRGN (FAR *GetLSRegion)(int, int);
		HRGN subRgn;
        subwharfType *subwharfs;
        } wharfType;

#ifdef __cplusplus
extern "C" {
#endif

__declspec( dllexport ) int initModule(HWND parent, HINSTANCE dll, wharfDataType* wd);
__declspec( dllexport ) int initModuleEx(HWND parent, HINSTANCE dll, LPCSTR szPath);
__declspec( dllexport ) void quitModule(HINSTANCE dllInst);

#ifdef __cplusplus
}
#endif


#endif

