 /*

  This is a part of the LiteStep Shell Source code.

  Copyright (C) 1997-98 The LiteStep Development Team

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/****************************************************************************

 [11/09/98] - B. Webb

 This file includes the source for LSTime, a LiteStep Module.

****************************************************************************/


//Typedefs
typedef struct {
	int sX;
	int sY;
	int dX;
	int dY;
	int w;
	int h;
} _6PointPos;
typedef struct {
	int sX;
	int sY;
	int w;
	int h;
} _4PointPos;
typedef struct {
	int dX;
	int dY;
	int w;
	int h;
} _4PointPosA;
typedef struct {
	int dX;
	int dY;
} _2PointPos;
typedef struct {
	HBITMAP usePic;
	HBITMAP oldPic;
	HDC picDC;
} LSTimeImage;

typedef struct {
	_4PointPos sDateFontPos;
	_4PointPos sDigiFontPos;
	_4PointPos sAnaDayFontPos;
	_4PointPos sAnaMonthFontPos;
	_2PointPos sDigiClockPos;
	BOOL bDigiClock;
	_2PointPos sDigiDayPos;
	BOOL bDigiDay;	
	_2PointPos sDigiMonthPos;
	BOOL bDigiMonth;
	_2PointPos sDigiYearPos;
	BOOL bDigiYear;
	_2PointPos sDigi2dYearPos;
	BOOL bDigi2dYear;
	_2PointPos sAnaDayPos;
	BOOL bAnaDay;
	_2PointPos sAnaMonthPos;
	BOOL bAnaMonth;
	_4PointPosA sAnaClockPos;
	BOOL bAnaClock;
	_6PointPos sBackground;
	BOOL bBackground;
	unsigned long cHourHandColor;
	BOOL bHourHandColor;
	unsigned long cHourHandShade;
	BOOL bHourHandShade;
	unsigned long cMinHandColor;
	BOOL bMinHandColor;
	unsigned long cMinHandShade;
	BOOL bMinHandShade;
	unsigned long cSecHandColor;
	BOOL bSecHandColor;
} timeThemeType;

//Function Prototypes

void themeParse(FILE *themeFile);
void redrawClock();
void drawAnaClock();
__declspec( dllexport ) int initWharfModule(HWND parent, HINSTANCE dll, wharfDataType *wd);
__declspec( dllexport ) void quitWharfModule(HINSTANCE dll);
__declspec( dllexport ) HRGN GetLSRegion(int xoffset, int yoffset);

//LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);