 /*

  This is a part of the LiteStep Shell Source code.

  Copyright (C) 1997-98 The LiteStep Development Team

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#define __WIN32_LEAN_AND_MEAN__
#define MAX_LINE		260
//increase or decrease for faster/slower refresh.. maybe optional?
#define ONE_SEC_IN_MS	1000
#define M_PI			3.14159265359

/****************************************************************************


  [04/10/98] - B. Webb

  Added Analog clock, Background, and 2 Digit year

  [27/09/98] - B. Webb

  Added Analog Day/Month, Added BOOLs for all Pos entries, adding sanity for X 
  pos' of 0. Made error messages a little bit better, moved blt call and analog
  clock draw function to prevent any ugliness there.

  TODO: Orientation of fonts, Analog clock (latter more urgent than the former)

  [11/09/98] - B. Webb

  This file includes the source for LSTime, a LiteStep Module.

****************************************************************************/

#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include "..\\lsapi\\lsapi.h"
#include "lstime.h"
#include <math.h>

char szAppName[] = "LSTime";

int FirstTime = 1;

LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
void MakeBuffer(HWND hWnd);

LSTimeImage themePic;
timeThemeType curTimeTheme;
int wndSize;
char ThemePicName[256];

struct LSTimeGlobals {
	HWND parentWin;
	HDC dblBuf;
	HBITMAP dblBufBMP;
//	HBITMAP dblBufOldBMP;
	LSTimeImage bkGrnd;
	BOOL backInit;
	wharfDataType wharfData;
	int wndSize;
	HINSTANCE instance;
} lsTimeGlob;

int globCounter = 0;

HWND hMainWin;

HRGN GetLSRegion(int xoffset, int yoffset)
{
	HRGN t = NULL;
	HDC thdc = CreateCompatibleDC(themePic.picDC);
	HBITMAP nnn;
	HBITMAP Reference;
	RECT r;
	HBRUSH hb2;

	if (curTimeTheme.bBackground && themePic.usePic)
	{
		Reference = LoadLSImage(ThemePicName, NULL);
		SelectObject(thdc, Reference);
	
		nnn = CreateCompatibleBitmap(thdc, 64, 64);
		SelectObject(thdc, nnn);

		hb2= CreateSolidBrush(RGB(255,0,255));
		r.top=0;
		r.left=0;
		r.bottom = 64;
		r.right = 64;
		FillRect(thdc, &r, hb2);
		DeleteObject(hb2);


		TransparentBltLS(thdc, 
			curTimeTheme.sBackground.dX, 
			curTimeTheme.sBackground.dY, 
			curTimeTheme.sBackground.w, 
			curTimeTheme.sBackground.h, 
			themePic.picDC, 
			curTimeTheme.sBackground.sX, 
			curTimeTheme.sBackground.sY, 
		RGB(255,0,255));
		DeleteDC(thdc);
		t = BitmapToRegion(nnn, RGB(255,0,255), 0x101010, xoffset, yoffset);

		DeleteObject(nnn);
		DeleteObject(Reference);
	}

	return t;


}

int initWharfModule(HWND parent, HINSTANCE dll, wharfDataType *wd)
{
	HDC parentDC;
	HBITMAP tempBMP;
	FILE *tmpTheme = NULL;
	char tmpThemeFName[MAX_LINE+1];
	
	lsTimeGlob.parentWin = parent;
	lsTimeGlob.instance = dll;
	lsTimeGlob.backInit = FALSE;
	strcpy(ThemePicName, "");

	memcpy(&lsTimeGlob.wharfData, wd, sizeof(wharfDataType));

	{
		WNDCLASS wc;

		memset(&wc, 0, sizeof(wc));
		wc.lpfnWndProc = WndProc;
		wc.hInstance = dll;
		wc.lpszClassName = szAppName;
		wc.style = CS_DBLCLKS;

		if (!RegisterClass(&wc))
		{
			MessageBox(lsTimeGlob.parentWin, "Error registering Window Class.", szAppName, MB_OK);
			return 1;
		}
	}
	wndSize = 64-lsTimeGlob.wharfData.borderSize*2;
	hMainWin = CreateWindowEx(
		WS_EX_TRANSPARENT,
		szAppName,
		"",
		WS_CHILD,
		lsTimeGlob.wharfData.borderSize, lsTimeGlob.wharfData.borderSize,
		wndSize,wndSize,
		parent,
		NULL,
		dll,
		0);
	if (!hMainWin)
	{
		MessageBox(lsTimeGlob.parentWin, "Window Creation Error.", szAppName, MB_OK);
		return 1;
	}

	parentDC = GetDC(lsTimeGlob.parentWin);
	lsTimeGlob.bkGrnd.picDC = CreateCompatibleDC(parentDC);
	lsTimeGlob.bkGrnd.usePic = CreateCompatibleBitmap(parentDC, 64, 64);
	SelectObject(lsTimeGlob.bkGrnd.picDC, lsTimeGlob.bkGrnd.usePic);
	
	ReleaseDC( lsTimeGlob.parentWin, parentDC );

	lsTimeGlob.dblBuf = CreateCompatibleDC(lsTimeGlob.bkGrnd.picDC);
	lsTimeGlob.dblBufBMP = CreateCompatibleBitmap(lsTimeGlob.bkGrnd.picDC, 64, 64);
	SelectObject(lsTimeGlob.dblBuf, lsTimeGlob.dblBufBMP);
	
	SetCursor(LoadCursor(NULL,MAKEINTRESOURCE(IDC_ARROW)));

	SetWindowLong(hMainWin, GWL_USERDATA, magicDWord);

	if (GetRCString("LSTimeThemeFile", tmpThemeFName, "nofile.thm", MAX_LINE+1))
	{
		if (!(tmpTheme = fopen (tmpThemeFName, "r")))
		{
			MessageBox(lsTimeGlob.parentWin, "Invalid Theme File specified.", szAppName, MB_OK);
			return 1;
		}
		else
			themeParse(tmpTheme);
	}
	else
	{
		MessageBox(lsTimeGlob.parentWin, "No Theme File specified.", szAppName, MB_OK);
		return 1;
	}
	redrawClock();
	SetTimer(hMainWin, 1, ONE_SEC_IN_MS, NULL);
	ShowWindow(hMainWin, SW_SHOWNORMAL);
	return 0;
}

void MakeBuffer(HWND hWnd)
{
	RECT r;
	HDC hdc = GetDC(hWnd);
	HBRUSH hb2;
	GetClientRect(hWnd,&r);
	hb2 = CreateSolidBrush(RGB(255,0,255));

	FillRect(lsTimeGlob.bkGrnd.picDC, &r, hb2);
	BitBlt(lsTimeGlob.bkGrnd.picDC, 0, 0, r.right, r.bottom, hdc, 0, 0, SRCCOPY);
	ReleaseDC(hWnd, hdc);
	DeleteObject(hb2);

	if (curTimeTheme.bBackground && !themePic.usePic)
	{
		MessageBox(lsTimeGlob.parentWin, "Bitmap not present.", szAppName, MB_OK);
		quitWharfModule(lsTimeGlob.instance);
	}
	//SelectObject(lsTimeGlob.bkGrnd.picDC, themePic.picDC);
	TransparentBltLS(lsTimeGlob.bkGrnd.picDC, 
		curTimeTheme.sBackground.dX, 
		curTimeTheme.sBackground.dY, 
		curTimeTheme.sBackground.w, 
		curTimeTheme.sBackground.h, 
		themePic.picDC, 
		curTimeTheme.sBackground.sX, 
		curTimeTheme.sBackground.sY, 
	RGB(255,0,255));
}


void themeParse(FILE *themeFile)
{
	char tmpParse[MAX_LINE+1], *opt, *val;

	memset(&curTimeTheme, 0, sizeof(curTimeTheme));
	while (!feof(themeFile))
	{
		if (fgets(tmpParse, sizeof(tmpParse), themeFile))
		{
			tmpParse[lstrlen(tmpParse)-1] = '\0';
			if (lstrlen(tmpParse))
			{
				opt = strtok(tmpParse, " ");
				val = strtok(NULL, "");
				if (!strcmpi(opt, "BitmapFile"))
				{
					themePic.usePic = LoadLSImage(val, NULL);
					strcpy(ThemePicName, val);
					themePic.picDC = CreateCompatibleDC(NULL);//lsTimeGlob.bkGrnd.picDC);
					SelectObject(themePic.picDC, themePic.usePic);
				}
				else if (!strcmpi(opt, "DateFont"))
					sscanf(val, "%d %d %d %d",
						&curTimeTheme.sDateFontPos.sX,
						&curTimeTheme.sDateFontPos.sY,
						&curTimeTheme.sDateFontPos.w,
						&curTimeTheme.sDateFontPos.h);
				else if (!strcmpi(opt, "DigiClockFont"))
					sscanf(val, "%d %d %d %d",
						&curTimeTheme.sDigiFontPos.sX,
						&curTimeTheme.sDigiFontPos.sY,
						&curTimeTheme.sDigiFontPos.w,
						&curTimeTheme.sDigiFontPos.h);
				else if (!strcmpi(opt, "AnaDayFont"))
					sscanf(val, "%d %d %d %d",
						&curTimeTheme.sAnaDayFontPos.sX,
						&curTimeTheme.sAnaDayFontPos.sY,
						&curTimeTheme.sAnaDayFontPos.w,
						&curTimeTheme.sAnaDayFontPos.h);
				else if (!strcmpi(opt, "AnaMonthFont"))
					sscanf(val, "%d %d %d %d",
						&curTimeTheme.sAnaMonthFontPos.sX,
						&curTimeTheme.sAnaMonthFontPos.sY,
						&curTimeTheme.sAnaMonthFontPos.w,
						&curTimeTheme.sAnaMonthFontPos.h);
				else if (!strcmpi(opt, "DigiClock"))
				{
					sscanf(val, "%d %d",
						&curTimeTheme.sDigiClockPos.dX,
						&curTimeTheme.sDigiClockPos.dY);
					curTimeTheme.bDigiClock = TRUE;
				}
				else if (!strcmpi(opt, "DigiDay"))
				{
					sscanf(val, "%d %d",
						&curTimeTheme.sDigiDayPos.dX,
						&curTimeTheme.sDigiDayPos.dY);
					curTimeTheme.bDigiDay = TRUE;
				}
				else if (!strcmpi(opt, "DigiMonth"))
				{
					sscanf(val, "%d %d",
						&curTimeTheme.sDigiMonthPos.dX,
						&curTimeTheme.sDigiMonthPos.dY);
					curTimeTheme.bDigiMonth = TRUE;
				}
				else if (!strcmpi(opt, "AnaDay"))
				{
					sscanf(val, "%d %d",
						&curTimeTheme.sAnaDayPos.dX,
						&curTimeTheme.sAnaDayPos.dY);
					curTimeTheme.bAnaDay = TRUE;
				}
				else if (!strcmpi(opt, "AnaMonth"))
				{
					sscanf(val, "%d %d",
						&curTimeTheme.sAnaMonthPos.dX,
						&curTimeTheme.sAnaMonthPos.dY);
					curTimeTheme.bAnaMonth = TRUE;
				}
				else if (!strcmpi(opt, "DigiYear"))
				{
					sscanf(val, "%d %d",
						&curTimeTheme.sDigiYearPos.dX,
						&curTimeTheme.sDigiYearPos.dY);
					curTimeTheme.bDigiYear = TRUE;
				}
				else if (!strcmpi(opt, "Digi2dYear"))
				{
					sscanf(val, "%d %d",
						&curTimeTheme.sDigi2dYearPos.dX,
						&curTimeTheme.sDigi2dYearPos.dY);
					curTimeTheme.bDigi2dYear = TRUE;
				}
				else if (!strcmpi(opt, "AnaClock"))
				{
					sscanf(val, "%d %d %d %d",
						&curTimeTheme.sAnaClockPos.dX,
						&curTimeTheme.sAnaClockPos.dY,
						&curTimeTheme.sAnaClockPos.w,
						&curTimeTheme.sAnaClockPos.h);
					curTimeTheme.bAnaClock = TRUE;
				/* Heh.. it wasn't working, go figure. - webba

					MessageBox(lsTimeGlob.parentWin, "DRAWING THE FUCKING CLOCK", szAppName, MB_OK);

				*/
				}
				else if (!strcmpi(opt, "Background"))
				{
					sscanf(val, "%d %d %d %d %d %d",
						&curTimeTheme.sBackground.sX,
						&curTimeTheme.sBackground.sY,
						&curTimeTheme.sBackground.dX,
						&curTimeTheme.sBackground.dY,
						&curTimeTheme.sBackground.w,
						&curTimeTheme.sBackground.h);
					curTimeTheme.bBackground = TRUE;
				}
				else if (!strcmpi(opt, "HourHandColor"))
				{
					sscanf(val, "%x", &curTimeTheme.cHourHandColor);
					curTimeTheme.bHourHandColor = TRUE;
				}
				else if (!strcmpi(opt, "HourHandShade"))
				{
					sscanf(val, "%x", &curTimeTheme.cHourHandShade);
					curTimeTheme.bHourHandShade = TRUE;
				}
				else if (!strcmpi(opt, "MinHandColor"))
				{
					sscanf(val, "%x", &curTimeTheme.cMinHandColor);
					curTimeTheme.bMinHandColor = TRUE;
				}
				else if (!strcmpi(opt, "MinHandShade"))
				{
					sscanf(val, "%x", &curTimeTheme.cMinHandShade);
					curTimeTheme.bMinHandShade = TRUE;
				}
				else if (!strcmpi(opt, "SecHandColor"))
				{
					sscanf(val, "%x", &curTimeTheme.cSecHandColor);
					curTimeTheme.bSecHandColor = TRUE;
				}
			}
		}
	}
	fclose(themeFile);
}

void quitWharfModule(HINSTANCE dll)
{
	if (lsTimeGlob.bkGrnd.picDC)
		DeleteDC(lsTimeGlob.bkGrnd.picDC);
	if (lsTimeGlob.bkGrnd.usePic)
		DeleteObject(lsTimeGlob.bkGrnd.usePic);
	if (lsTimeGlob.dblBuf)
		DeleteDC(lsTimeGlob.dblBuf);
	if (lsTimeGlob.dblBufBMP)
		DeleteObject(lsTimeGlob.dblBufBMP);
	if (themePic.picDC)
		DeleteDC(themePic.picDC);
	if (themePic.usePic)
		DeleteObject(themePic.usePic);
	if (themePic.oldPic)
		DeleteObject(themePic.oldPic);
	DestroyWindow(hMainWin);
	UnregisterClass(szAppName, lsTimeGlob.instance);
}

void redrawClock()
{
	time_t tVal;
	struct tm *stVal;
	char tmp[10], tmp2[10], rClockVal[10], rDayVal[10], rMonthVal[10], rYearVal[10];
	int iTmp, x;

	BitBlt(lsTimeGlob.dblBuf, 0, 0, 64, 64, lsTimeGlob.bkGrnd.picDC, 0, 0, SRCCOPY);

	/*	First, before doing anything with our bitmap, let's run a 
		lUser sanity check.. 
	*/

	if ((curTimeTheme.bDigiClock || curTimeTheme.bDigiDay || curTimeTheme.bDigiMonth 
		|| curTimeTheme.bDigiYear) && !themePic.usePic)
	{
		MessageBox(lsTimeGlob.parentWin, "Bitmap not present.", szAppName, MB_OK);
		quitWharfModule(lsTimeGlob.instance);
	}
	if (curTimeTheme.bDigiClock && !curTimeTheme.sDigiFontPos.w)
	{
		MessageBox(lsTimeGlob.parentWin, "DigiClockFont not defined, or Width is 0!", szAppName, MB_OK);
		quitWharfModule(lsTimeGlob.instance);
	}
	if (curTimeTheme.bAnaDay && !curTimeTheme.sAnaDayFontPos.w)
	{
		MessageBox(lsTimeGlob.parentWin, "AnaDayFont not defined, or Width is 0!", szAppName, MB_OK);
		quitWharfModule(lsTimeGlob.instance);
	}
	if (curTimeTheme.bAnaMonth && !curTimeTheme.sAnaMonthFontPos.w)
	{
		MessageBox(lsTimeGlob.parentWin, "AnaMonthFont not defined, or Width is 0!", szAppName, MB_OK);
		quitWharfModule(lsTimeGlob.instance);
	}

	if ((curTimeTheme.bDigiDay || curTimeTheme.bDigiMonth || 
		curTimeTheme.bDigiYear) && !curTimeTheme.sDateFontPos.w)
	{
		MessageBox(lsTimeGlob.parentWin, "DigiDateFont not defined, or Width is 0!", szAppName, MB_OK);
		quitWharfModule(lsTimeGlob.instance);
	}

	if (curTimeTheme.bDigiClock)
	{

		time(&tVal);
		stVal = localtime(&tVal);
		if (lsTimeGlob.wharfData.usClock)
			strftime(tmp, sizeof(tmp), "%I", stVal);
		else
			strftime(tmp, sizeof(tmp), "%H", stVal);
		iTmp = atoi(tmp);
		itoa(iTmp, rClockVal, 10);
		if (strlen(rClockVal) == 1)
		{
			strcpy(tmp, "0");
			strcat(tmp, rClockVal);
			strcpy(rClockVal, tmp);
		}
		strcat(rClockVal, ":");
		strftime(tmp, sizeof(tmp), "%M", stVal);
		iTmp = atoi(tmp);
		itoa(iTmp, tmp, 10);
		if (strlen(tmp) == 1)
		{
			strcpy(tmp2, "0");
			strcat(tmp2, tmp);
			strcpy(tmp, tmp2);
		}
		strcat(rClockVal, tmp);
		for (x=0;x<lstrlen(rClockVal);x++)
		{
			if (rClockVal[x] != ':')
			{
				TransparentBltLS(
					lsTimeGlob.dblBuf, 
					curTimeTheme.sDigiClockPos.dX + (x * curTimeTheme.sDigiFontPos.w), 
					curTimeTheme.sDigiClockPos.dY, 
					curTimeTheme.sDigiFontPos.w, 
					curTimeTheme.sDigiFontPos.h, 
					themePic.picDC, 
					curTimeTheme.sDigiFontPos.sX + ((rClockVal[x] - '0') * curTimeTheme.sDigiFontPos.w),
					curTimeTheme.sDigiFontPos.sY,
				RGB(255,0,255));
			}
			else
			{
				if (globCounter)
				{
					TransparentBltLS(
						lsTimeGlob.dblBuf, 
						curTimeTheme.sDigiClockPos.dX + (x * curTimeTheme.sDigiFontPos.w),
						curTimeTheme.sDigiClockPos.dY, 
						curTimeTheme.sDigiFontPos.w, 
						curTimeTheme.sDigiFontPos.h, 
						themePic.picDC, 
						curTimeTheme.sDigiFontPos.sX + (10 * curTimeTheme.sDigiFontPos.w),
						curTimeTheme.sDigiFontPos.sY,
					RGB(255,0,255));
					globCounter=0;
				}
				else
				{
					TransparentBltLS(
						lsTimeGlob.dblBuf, 
						curTimeTheme.sDigiClockPos.dX + (x * curTimeTheme.sDigiFontPos.w),
						curTimeTheme.sDigiClockPos.dY, 
						curTimeTheme.sDigiFontPos.w, 
						curTimeTheme.sDigiFontPos.h, 
						themePic.picDC, 
						curTimeTheme.sDigiFontPos.sX + (11 * curTimeTheme.sDigiFontPos.w),
						curTimeTheme.sDigiFontPos.sY,
					RGB(255,0,255));
					globCounter=1;
				}
			}
		}
	}
	if (curTimeTheme.bDigiDay || curTimeTheme.bDigiMonth || 
		curTimeTheme.bDigiYear || curTimeTheme.bDigi2dYear) 
	{ 
		time(&tVal);
		stVal = localtime(&tVal);

		if (curTimeTheme.bDigiDay)
		{
			strftime(rDayVal, sizeof(rDayVal), "%d", stVal);
			for (x=0;x<lstrlen(rDayVal);x++)
			{

				if (x == 0 && rDayVal[x] == '0')
				{
					TransparentBltLS(
						lsTimeGlob.dblBuf,
						curTimeTheme.sDigiDayPos.dX + (x * curTimeTheme.sDateFontPos.w),
						curTimeTheme.sDigiDayPos.dY, 
						curTimeTheme.sDateFontPos.w, 
						curTimeTheme.sDateFontPos.h, 
						themePic.picDC, 
						curTimeTheme.sDateFontPos.sX + (10 * curTimeTheme.sDateFontPos.w),
						curTimeTheme.sDateFontPos.sY,
					RGB(255,0,255));
				}
				else
				{
					TransparentBltLS(
						lsTimeGlob.dblBuf, 
						curTimeTheme.sDigiDayPos.dX + (x * curTimeTheme.sDateFontPos.w),
						curTimeTheme.sDigiDayPos.dY, 
						curTimeTheme.sDateFontPos.w, 
						curTimeTheme.sDateFontPos.h, 
						themePic.picDC, 
						curTimeTheme.sDateFontPos.sX + ((rDayVal[x] - '0') * curTimeTheme.sDateFontPos.w),
						curTimeTheme.sDateFontPos.sY,
					RGB(255,0,255));
				}
			}
		}
		if (curTimeTheme.bDigiMonth)
		{
			strftime(rMonthVal, sizeof(rMonthVal), "%m", stVal);
			for (x=0;x<lstrlen(rMonthVal);x++)
			{
				if (x == 0 && rMonthVal[0] == '0')
				{
					TransparentBltLS(
						lsTimeGlob.dblBuf,
						curTimeTheme.sDigiMonthPos.dX + (x * curTimeTheme.sDateFontPos.w),
						curTimeTheme.sDigiMonthPos.dY, 
						curTimeTheme.sDateFontPos.w, 
						curTimeTheme.sDateFontPos.h, 
						themePic.picDC,
						curTimeTheme.sDateFontPos.sX + (10 * curTimeTheme.sDateFontPos.w),
						curTimeTheme.sDateFontPos.sY,
					RGB(255,0,255));
				}
				else
				{
					TransparentBltLS(
						lsTimeGlob.dblBuf,
						curTimeTheme.sDigiMonthPos.dX + (x * curTimeTheme.sDateFontPos.w),
						curTimeTheme.sDigiMonthPos.dY, 
						curTimeTheme.sDateFontPos.w, 
						curTimeTheme.sDateFontPos.h, 
						themePic.picDC,
						curTimeTheme.sDateFontPos.sX + ((rMonthVal[x] - '0') * curTimeTheme.sDateFontPos.w),
						curTimeTheme.sDateFontPos.sY,
					RGB(255,0,255));
				}
			}
		}
		if (curTimeTheme.bDigiYear)
		{
			/* Use %Y for y2k compliancy.. weee */
			strftime(rYearVal, sizeof(rYearVal), "%Y", stVal);
			for (x=0;x<lstrlen(rYearVal);x++)
			{
				TransparentBltLS(
					lsTimeGlob.dblBuf, 
					curTimeTheme.sDigiYearPos.dX + (x * curTimeTheme.sDateFontPos.w),
					curTimeTheme.sDigiYearPos.dY, 
					curTimeTheme.sDateFontPos.w, 
					curTimeTheme.sDateFontPos.h, 
					themePic.picDC, 
					curTimeTheme.sDateFontPos.sX + ((rYearVal[x] - '0') * curTimeTheme.sDateFontPos.w),
					curTimeTheme.sDateFontPos.sY,
				RGB(255,0,255));
			}
		}
		if (curTimeTheme.bDigi2dYear)
		{
			/* Bad Cop! No Y2K! */
			strftime(rYearVal, sizeof(rYearVal), "%y", stVal);
			for (x=0;x<lstrlen(rYearVal);x++)
			{
				TransparentBltLS(
					lsTimeGlob.dblBuf, 
					curTimeTheme.sDigi2dYearPos.dX + (x * curTimeTheme.sDateFontPos.w),
					curTimeTheme.sDigi2dYearPos.dY, 
					curTimeTheme.sDateFontPos.w, 
					curTimeTheme.sDateFontPos.h, 
					themePic.picDC, 
					curTimeTheme.sDateFontPos.sX + ((rYearVal[x] - '0') * curTimeTheme.sDateFontPos.w),
					curTimeTheme.sDateFontPos.sY,
				RGB(255,0,255));
			}
		}
	}
	if (curTimeTheme.bAnaDay)
	{ 
		time(&tVal);
		stVal = localtime(&tVal);

		strftime(rDayVal, sizeof(rDayVal), "%w", stVal);
		TransparentBltLS(
			lsTimeGlob.dblBuf, 
			curTimeTheme.sAnaDayPos.dX,
			curTimeTheme.sAnaDayPos.dY, 
			curTimeTheme.sAnaDayFontPos.w, 
			curTimeTheme.sAnaDayFontPos.h, 
			themePic.picDC,
			curTimeTheme.sAnaDayFontPos.sX + ((rDayVal[0] - '0') * curTimeTheme.sAnaDayFontPos.w),
			curTimeTheme.sAnaDayFontPos.sY,
		RGB(255,0,255));
	}
	if (curTimeTheme.bAnaMonth)
	{ 
		time(&tVal);
		stVal = localtime(&tVal);
		/*
		if (!anamonthfirsttime)
		{

			anamonthfirsttime=1;
		}
		*/
		strftime(rMonthVal, sizeof(rMonthVal), "%m", stVal);
		if (rMonthVal[0] == '0')
			TransparentBltLS(
				lsTimeGlob.dblBuf, 
				curTimeTheme.sAnaMonthPos.dX,
				curTimeTheme.sAnaMonthPos.dY, 
				curTimeTheme.sAnaMonthFontPos.w, 
				curTimeTheme.sAnaMonthFontPos.h, 
				themePic.picDC,
				curTimeTheme.sAnaMonthFontPos.sX + ((rMonthVal[1] - '1') * curTimeTheme.sAnaMonthFontPos.w),
				curTimeTheme.sAnaMonthFontPos.sY,
			RGB(255,0,255));
		else
		{
			iTmp = atoi(rMonthVal);
			TransparentBltLS(
				lsTimeGlob.dblBuf, 
				curTimeTheme.sAnaMonthPos.dX,
				curTimeTheme.sAnaMonthPos.dY, 
				curTimeTheme.sAnaMonthFontPos.w, 
				curTimeTheme.sAnaMonthFontPos.h, 
				themePic.picDC,
				curTimeTheme.sAnaMonthFontPos.sX + ((iTmp - 1) * curTimeTheme.sAnaMonthFontPos.w),
				curTimeTheme.sAnaMonthFontPos.sY,
			RGB(255,0,255));
		}
	}
	if (curTimeTheme.bAnaClock)
		drawAnaClock();

}

void drawAnaClock()
{
	/* Heavily based off of Whodini's aLSClock module. (Cos my circle math blows :>) */

	SYSTEMTIME tm;
	HPEN anaClockPen, anaOldPen;
	double angle;
	int hx, hy, mx, my, sx, sy;

	GetLocalTime(&tm);

	/* lUser sanity checks, also make a shade value if there isn't one. We'll
	   use the color supplied by the user for this. */

	if (!curTimeTheme.bHourHandColor)
	{
		MessageBox(lsTimeGlob.parentWin, "HourHandColor not defined!", szAppName, MB_OK);
		quitWharfModule(lsTimeGlob.instance);
	}
	if (!curTimeTheme.bMinHandColor)
	{
		MessageBox(lsTimeGlob.parentWin, "MinHandColor not defined!", szAppName, MB_OK);
		quitWharfModule(lsTimeGlob.instance);
	}
	if (!curTimeTheme.bSecHandColor)
	{
		MessageBox(lsTimeGlob.parentWin, "SecHandColor not defined!", szAppName, MB_OK);
		quitWharfModule(lsTimeGlob.instance);
	}
	if (!curTimeTheme.bHourHandShade)
	{
		curTimeTheme.cHourHandShade = curTimeTheme.cHourHandColor;
		curTimeTheme.bHourHandShade = TRUE;
	}
	if (!curTimeTheme.bMinHandShade)
	{
		curTimeTheme.cMinHandShade = curTimeTheme.cMinHandColor;
		curTimeTheme.bMinHandShade = TRUE;
	}


	
	angle = (M_PI / 6.0) * (double) tm.wHour + (M_PI / 360.0) * (double) tm.wMinute;
	hx = ((curTimeTheme.sAnaClockPos.dX + (curTimeTheme.sAnaClockPos.w / 2))) + 
		(int) (((curTimeTheme.sAnaClockPos.w / 2) / 1.88)
		* sin(angle));

	hy = ((curTimeTheme.sAnaClockPos.dY + (curTimeTheme.sAnaClockPos.h / 2))) - 
		(int) (((curTimeTheme.sAnaClockPos.h / 2) / 1.88) 
		* cos(angle));

	angle = (M_PI / 30.0) * (double) tm.wMinute;
	mx = ((curTimeTheme.sAnaClockPos.dX + (curTimeTheme.sAnaClockPos.w / 2))) + 
		(int) (((curTimeTheme.sAnaClockPos.w / 2) / 1.35)
		* sin(angle));
	my = ((curTimeTheme.sAnaClockPos.dY + (curTimeTheme.sAnaClockPos.h / 2))) - 
		(int) (((curTimeTheme.sAnaClockPos.h / 2) / 1.35) 
		* cos(angle));

	angle = (M_PI / 30.0) * (double) tm.wSecond;
	sx = ((curTimeTheme.sAnaClockPos.dX + (curTimeTheme.sAnaClockPos.w / 2))) + 
		(int) (((curTimeTheme.sAnaClockPos.w / 2) / 1.05)
		* sin(angle));
    sy = ((curTimeTheme.sAnaClockPos.dY + (curTimeTheme.sAnaClockPos.h / 2))) - 
		(int) (((curTimeTheme.sAnaClockPos.h / 2) / 1.05) 
		* cos(angle));


	anaClockPen = CreatePen(PS_SOLID, 2, curTimeTheme.cMinHandColor);
	anaOldPen = SelectObject(lsTimeGlob.dblBuf, anaClockPen);
	MoveToEx(lsTimeGlob.dblBuf, 
		(curTimeTheme.sAnaClockPos.dX + curTimeTheme.sAnaClockPos.w / 2) - 1,
		(curTimeTheme.sAnaClockPos.dY + curTimeTheme.sAnaClockPos.h / 2) - 1,
		NULL);
	LineTo(lsTimeGlob.dblBuf,
		mx - 1,
		my - 1);
	SelectObject(lsTimeGlob.dblBuf, anaOldPen);
	DeleteObject(anaClockPen);

	anaClockPen = CreatePen(PS_SOLID, 1, curTimeTheme.cMinHandShade);
	anaOldPen = SelectObject(lsTimeGlob.dblBuf, anaClockPen);
	MoveToEx(lsTimeGlob.dblBuf, 
		curTimeTheme.sAnaClockPos.dX + curTimeTheme.sAnaClockPos.w / 2,
		curTimeTheme.sAnaClockPos.dY + curTimeTheme.sAnaClockPos.h / 2,
		NULL);
	LineTo(lsTimeGlob.dblBuf,
		mx,
		my);
	SelectObject(lsTimeGlob.dblBuf, anaOldPen);
	DeleteObject(anaClockPen);


	anaClockPen = CreatePen(PS_SOLID, 2, curTimeTheme.cHourHandColor);
	anaOldPen = SelectObject(lsTimeGlob.dblBuf, anaClockPen);
	MoveToEx(lsTimeGlob.dblBuf, 
		(curTimeTheme.sAnaClockPos.dX + curTimeTheme.sAnaClockPos.w / 2) - 1,
		(curTimeTheme.sAnaClockPos.dY + curTimeTheme.sAnaClockPos.h / 2) - 1,
		NULL);
	LineTo(lsTimeGlob.dblBuf,
		hx - 1,
		hy - 1);
	SelectObject(lsTimeGlob.dblBuf, anaOldPen);
	DeleteObject(anaClockPen);

	anaClockPen = CreatePen(PS_SOLID, 1, curTimeTheme.cHourHandShade);
	anaOldPen = SelectObject(lsTimeGlob.dblBuf, anaClockPen);
	MoveToEx(lsTimeGlob.dblBuf, 
		curTimeTheme.sAnaClockPos.dX + curTimeTheme.sAnaClockPos.w / 2,
		curTimeTheme.sAnaClockPos.dY + curTimeTheme.sAnaClockPos.h / 2,
		NULL);
	LineTo(lsTimeGlob.dblBuf,
		hx,
		hy);
	SelectObject(lsTimeGlob.dblBuf, anaOldPen);
	DeleteObject(anaClockPen);

	anaClockPen = CreatePen(PS_SOLID, 1, curTimeTheme.cSecHandColor);
	anaOldPen = SelectObject(lsTimeGlob.dblBuf, anaClockPen);
	MoveToEx(lsTimeGlob.dblBuf, 
		curTimeTheme.sAnaClockPos.dX + curTimeTheme.sAnaClockPos.w / 2,
		curTimeTheme.sAnaClockPos.dY + curTimeTheme.sAnaClockPos.h / 2,
		NULL);
	LineTo(lsTimeGlob.dblBuf,
		sx,
		sy);
	SelectObject(lsTimeGlob.dblBuf, anaOldPen);
	DeleteObject(anaClockPen);

}

LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_CREATE:
		case WM_ERASEBKGND:
			return 0;
		case WM_PAINT:
		{
			if (FirstTime)
			{
				MakeBuffer(lsTimeGlob.parentWin);
				FirstTime = 0;
			}
			else
			{
				PAINTSTRUCT ps;
				HDC screenDC = BeginPaint(hwnd, &ps);
				RECT r;
				GetClientRect(hwnd, &r);
				redrawClock();
				BitBlt(screenDC, 0, 0, r.right, r.bottom, lsTimeGlob.dblBuf, 
					0, 0, SRCCOPY);
				EndPaint(hwnd, &ps);
			}
		/*	MessageBox(lsTimeGlob.parentWin, "PAINT MOTHER FUCKER!", szAppName, MB_OK); 
			This Comment ^ brought to you by Toasty, Coca-Cola, and the letter C. */
		}
		return 0;
		case WM_MBUTTONUP:
		{
			MessageBox(lsTimeGlob.parentWin, "LiteStep 0wnez yer m0m!#\nFEAR C0DE.\nThis pointless kludge has been brought to you by webba, hoho!\nMy girlfriend is elite.\n\nBye now.\n\n\t - webba", "Welcome to the Easter Egg..", 
				MB_OK|MB_ICONASTERISK|MB_TOPMOST);
		}
		case WM_KEYUP:
		case WM_LBUTTONDOWN:
		case WM_MBUTTONDOWN:
		case WM_LBUTTONUP:
			return 0;
		case WM_RBUTTONDOWN:
		case WM_RBUTTONUP:
		{
			RECT r;
			GetWindowRect(hwnd, &r);
			PostMessage(GetParent(GetParent(lsTimeGlob.parentWin)), 9182, 
				r.top+(int)HIWORD(lParam), r.left+(int)LOWORD(lParam));
			return 0;
		}
		case WM_LBUTTONDBLCLK:
		{ /* Taken from aLSClock -- Hi Whod! */
			char winDir[MAX_LINE+1];
			GetSystemDirectory(winDir, MAX_LINE);
			ShellExecute(hwnd, "open", "rundll32.exe", 
				"shell32.dll,Control_RunDLL timedate.cpl",
				winDir, SW_SHOWNORMAL);
			return 0;
		}
		case WM_TIMER:
		{
			RECT r;
			GetClientRect(hMainWin, &r);
			InvalidateRect(hMainWin, &r, FALSE);
			return 0;
		}
	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}
