/*

  This is a part of the LiteStep Shell Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/*********************************************************************/
/*                                                                   */
/* LiteSTEP Wharf CPU Module 1.0                                     */
/*                                                                   */
/* Copyright (c)1998 Francis Gastellu aka Lone Runner/Aegis          */
/*                                                                   */
/*********************************************************************/
/*                                                                   */
/* This very simple module monitors CPU activity.                    */
/*                                                                   */
/* You may use it as a base for another module or to customize it    */
/* to your own needs.                                                */
/*                                                                   */
/* THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF */
/* ANY KIND, EITHER EXPRESSED OR IMPLIED.							 */
/*                                                                   */
/*********************************************************************/

#include <windows.h>
#include <stdio.h>
#include "LsSDK.h"

/* ----------------------------------------------------------------- */
char szAppName[] = "LsCPU"; // Name of Application, Window class...

// window procedure
LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);

HWND hMainWnd;                    // main window handle
HWND parent;                      // parent window
wharfDataType wharfData;          // Setup data passed to the DLL
int wndSize;                      // Size of the wharf client

DWORD Reserved,dataType,dataLen=8192;
char data[8192]; // Buffer to communicate with registry. (way bigger than neeeded)

HKEY perfKey;		// Registry key to get cpu usage
HKEY startPerfKey;	// Registry key to start cpu usage moinitoring

char history[64];	// history of last n seconds
BOOL init=FALSE;	// Monitor started ?
int width=0;		// Width of monitor (= size of history)

int pointer=0;		// pointer on the rotating history

/*********************************************************************/
/* DLL Entry point                                                   */
/*********************************************************************/
int initWharfModule(HWND ParentWnd, HINSTANCE dllInst, wharfDataType *wd)
{
    parent = ParentWnd; // Save parent window
    // Duplicate wharfData since the one we get will be destroyed
    memcpy(&wharfData, wd, sizeof(wharfDataType));
    wndSize = 64-wharfData.borderSize*2;

	memset(history, 0, 64); // initialize history to 0

    {    // Register the Window class
        WNDCLASS wc;

        memset(&wc,0,sizeof(wc));
        wc.lpfnWndProc = WndProc;       // our window procedure
        wc.hInstance = dllInst;         // hInstance of DLL
        wc.lpszClassName = szAppName;   // our window class name

        if (!RegisterClass(&wc)) 
        {
            MessageBox(parent,"Error registering window class",szAppName, MB_OK);
            return 1;
        }
    }


    hMainWnd = CreateWindowEx(
        WS_EX_TRANSPARENT,                          // exstyles 
        szAppName,                                  // our window class name
        szAppName,                                  // use description for a window title
        WS_CHILD,                                   // window style
        wharfData.borderSize, wharfData.borderSize, // position 
        wndSize,wndSize,                            // width & height of window
        parent,                                     // parent window (litestep wharf window)
        NULL,                                       // no menu
        dllInst,                                    // hInstance of DLL
        0);                                         // no window creation data

    if (!hMainWnd) 
    {						   
        MessageBox(parent,"Error creating window",szAppName,MB_OK);
        return 1;
    }

	SetTimer(hMainWnd, 0, 1000, NULL); // Set a timer for cpu monitor
	
	// Open the cpu usage registry key
	RegOpenKey(HKEY_DYN_DATA, "PerfStats\\StatData", &perfKey);

	// Start monitoring
	RegOpenKey(HKEY_DYN_DATA, "PerfStats\\StartStat", &startPerfKey);
	RegQueryValueEx(startPerfKey, "KERNEL\\CPUUsage", &Reserved, &dataType, data, &dataLen);

    // Set normal cursor
    SetCursor(LoadCursor(NULL,MAKEINTRESOURCE(IDC_ARROW)));
	
    // DO NOT REMOVE ! Set magicDWord - required!
    // Used by some modules & litestep internals
    SetWindowLong(hMainWnd,GWL_USERDATA,magicDWord); 

    // show the window
    ShowWindow(hMainWnd,SW_SHOWNORMAL);

    return 0;
}

/*********************************************************************/
/* Dll closeup request                                               */
/*********************************************************************/
void quitWharfModule(HINSTANCE dllInst)
{
	KillTimer(hMainWnd, 0);
	RegCloseKey(startPerfKey);
	RegCloseKey(perfKey);
    DestroyWindow(hMainWnd);                // delete our window
    UnregisterClass(szAppName, dllInst);    // unregister window class
}


/*********************************************************************/
/* Window procedure for our window                                   */
/*********************************************************************/
LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message)
    {
        case WM_CREATE:		return 0;
        case WM_ERASEBKGND: return 0;
        case WM_PAINT:
			{ 
                PAINTSTRUCT ps;
                RECT r;
                HDC hdc = BeginPaint(hwnd,&ps);
				HBRUSH brush;
				HPEN pen, oldpen;
				int i, j;
                
                //  ********* CPU module drawing ********


                // Get client rect of our window
				GetClientRect(hwnd,&r);
				r.left++; // adjustment

				
				// contract rect used by 4 pixels
				r.top += 4;
				r.bottom -= 4;
				r.left += 4;
				r.right -= 4;

				width = (r.right - r.left)-3; // Width of monitor

				// Draw border
				pen = CreatePen(PS_SOLID, 1, 0);
				oldpen = SelectObject(hdc, pen);

                MoveToEx(hdc, r.left, r.bottom-1, NULL);
                LineTo(hdc, r.left, r.top);
                LineTo(hdc, r.right-1, r.top);

				SelectObject(hdc, oldpen);
				DeleteObject(pen);
				
				pen = CreatePen(PS_SOLID, 1, 0xFFFFFF);
				oldpen = SelectObject(hdc, pen);

                LineTo(hdc, r.right-1, r.bottom-1);
                LineTo(hdc, r.left, r.bottom-1);

				SelectObject(hdc, oldpen);
				DeleteObject(pen);

				// Contract rect by another pixel
				r.top++;
				r.bottom--;
				r.left++;
				r.right--;

				// Paint monitor background
				brush = CreateSolidBrush(0x005000);
				FillRect(hdc, &r, brush);
				DeleteObject(brush);

				// Draw grid
				pen = CreatePen(PS_SOLID, 1, 0x007000);
				oldpen = SelectObject(hdc, pen);

				for (i=1;i<4;i++)
					{
					MoveToEx(hdc, r.left, r.top + ((r.bottom-r.top)/4)*i, NULL);
					LineTo(hdc, r.right-1, r.top + ((r.bottom-r.top)/4)*i);
					}
				for (i=1;i<4;i++)
					{
					MoveToEx(hdc, r.left+ ((r.right-r.left)/4)*i, r.top, NULL);
					LineTo(hdc, r.left+ ((r.right-r.left)/4)*i, r.bottom-1);
					}

				SelectObject(hdc, oldpen);
				DeleteObject(pen);

                // ---------------------------------------------

				// Draw CPU monitor history curve

				pen = CreatePen(PS_SOLID, 1, 0x00FF00);
				oldpen = SelectObject(hdc, pen);

				j = (pointer + width) % width;
				MoveToEx(hdc, r.left+1, r.bottom-1- (width * history[j]/100), NULL);
				for (i=1;i<width;i++)
					{
					j++;
					j %= width;
					LineTo(hdc, r.left+1+i, r.bottom-1- (width * history[j]/100));
					}

				SelectObject(hdc, oldpen);
				DeleteObject(pen);

				init=TRUE;

                EndPaint(hwnd,&ps);
			}
            return 0;
        case WM_KEYDOWN:    // forward keyboard messages to parent window 
        case WM_KEYUP:
            PostMessage(parent,message,wParam,lParam);
            return 0;
	// Mouse messages are here to ensure we have a good popup menu behaviour. You may insert
        // your own custom actions
        case WM_RBUTTONUP:
                {
                RECT r;
                GetWindowRect(hwnd, &r);
                PostMessage(GetParent(GetParent(parent)), 9182, r.top+(int)HIWORD(lParam), r.left+(int)LOWORD(lParam));
                }
            return 0;
        case WM_RBUTTONDOWN:
        case WM_LBUTTONDOWN:
        case WM_MBUTTONDOWN:
            PostMessage(GetParent(GetParent(parent)), 9183, 0, 0);
            return 0;
		case WM_TIMER: // Update cpu monitor
			{
			RECT r;
			if (!init) return 0;
			// Get last cpu usage value
			RegQueryValueEx(perfKey, "KERNEL\\CPUUsage", &Reserved, &dataType, data, &dataLen);
			// Insert it in the rotating buffer
			history[pointer] = *data;
			pointer++;
			pointer %= width;

			// Invalidate client. This causes a WM_PAINT message to be sent to our window
			GetClientRect(hMainWnd, &r);
			InvalidateRect(hMainWnd, &r, TRUE);
			}
			return 0;
    }
    return DefWindowProc(hwnd,message,wParam,lParam);
}


