#ifndef __POPUP_H
#define __POPUP_H
#include "../litestep/wharfdata.h"

//pre-delc 
class subMenu;

//simple bitmap struct
typedef struct {
	HBITMAP bitmap;
	int x;
	int y;
} BitMP;

//for keeping track of which submenu to reference with each open subwindow HWND
typedef struct {
	HWND subMenuHwnd;
	subMenu * subMenu;
} subMenuHWND;






//temp container for data retreved from file
class fileItem
{
public:	
	fileItem();
	~fileItem();
	char itemName[256];
	char bmpName[256];
	int itemHeight;
	char popupCommand[256];
	char commandParam[256];
	fileItem *next;
};




class menuItem 
{
public:
	char bmp[256];
	char name[256];
	char command[256];
	char params[256];
	int height;
	int itemLevel;
	menuItem()
	{	
		itemLevel = 0;
		height = 0;
		next= NULL;
		strcpy(params, "\0");
		SMenu = NULL;
	}
		
	~menuItem();
	menuItem *next; //next menu item in the list
	subMenu *SMenu; //if this item isn't a submenu accessor, this will be NULL

};

class subMenu 
{
public:
	subMenu()
	{
		root = NULL;
		current = NULL;
		subMenuWin = NULL;
		totalHeight = 200;
		isSubOpen = FALSE;
		isSelected = NULL;
	}

	~subMenu()
	{
		if(root != NULL)
			delete root;
		DestroyWindow(subMenuWin);
	}
	BOOL newMenuItem();
	BOOL isSubOpen;
	menuItem *root;
	menuItem *current;
	menuItem *isSelected;
	int totalHeight;
	HWND subMenuWin;
};

//the main popup list container
class popupMenu 
{ 
public:	
	popupMenu()
	{
		root = NULL;
		current = root;
		isSelected = NULL;
		menuWidth = 100;
		subMenuDelay = 0;
	}

	~popupMenu()
	{
		if(root != NULL)
			delete root;
	}

	BOOL newMenuItem();
	int returnMenuWidth();
	int subMenuDelay;
	menuItem *root; //the root list for the popupmenu
	menuItem *current; //the last item in this list
	menuItem *isSelected;
	BitMP backBMP;
	BitMP titleBMP;
	BitMP selectBMP;

	char selectedBMP[256]; //the mouse over bmp
	char menuName[256]; //name of the list
	char backgroundBMP[256]; //background name of the BMP
	char titleBarBMP[256];
	int menuWidth; //the minimum width of the popupmenu
	int totalHeight;
	

};





#ifdef	__cplusplus
extern "C" {
#endif	/* __cplusplus */
__declspec( dllexport ) int initModule(HWND ParentWnd, HINSTANCE dllInst, wharfDataType* wd);
__declspec( dllexport ) int initModuleEx(HWND parent, HINSTANCE dll, LPCSTR szPath);
__declspec( dllexport ) int quitModule(HINSTANCE dllInst);

#ifdef	__cplusplus
};
#endif	/* __cplusplus */

#endif  /* __LSAPI_H */
