/*

  This is a part of the LiteStep Shell Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

// Standard system module header

#ifndef __HOTKEY_H
#define __HOTKEY_H

#include <windows.h>
#include "..\litestep\wharfData.h"

typedef struct {
	char* key;
	int vkey;
} tVKTable;

typedef struct {
    HWND hWnd;
    HICON icon;
    int txtSum;
	HWND tooltipWnd;
	BOOL needTooltip;
    } btnType;

typedef struct {
    char szCommand[256];
	char szParameters[256];
    int sub;
    char ch;
    } hotkeyType;

#ifdef __cplusplus
extern "C" {
#endif

__declspec( dllexport ) int initModule(HWND parent, HINSTANCE dll, wharfDataType* wd);
__declspec( dllexport ) int initModuleEx(HWND parent, HINSTANCE dll, LPCSTR szPath);
__declspec( dllexport ) void quitModule(HINSTANCE dllInst);

#ifdef __cplusplus
}
#endif

#endif
