/*

  This is a part of the LiteStep Shell Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/****************************************************************************

 07/20/98 - MholmesIV
			Removed the erroneous need for a BgBMP value in modules.ini,
			now using the standard method for getting the background BMP.
 07/18/98 - j_edge
			Moved the Hotkey stuff to after LoadStickySettings() since it
			uses inipath which is initialized in that function.
 07/15/98 - j_edge
			Added the BgBMP entry in MODULES.INI to allow user to specify a 
			different bmp than the default bmp. 
			Added the Hotkey entry in MODULES.INI to allow user to choose
			which key is pressed with arrow keys to switch virtual windows.
 06/17/98 - Sehnsucht
			Cleaned up some of the warnings
			Added window 'class' stickies
 06/16/98 - [Drizzt]
			Added transparency to the default bmp
 06/14/98 - Sehnsucht
			Changed the alt-cursors to mskey-cursors.
			Able to use alt-cursors in programs again (Netscape, IE, etc).
 06/02/98 - F. Gastellu
            This file contains the source code for the virtual window
            manager

****************************************************************************/

#include <windows.h>
#include <time.h>
#include <stdio.h>
#include <commctrl.h>

#include "lsvwm.h"
#include "match.h"

char szAppName[] = "lsvwm"; // Our window class, etc

// our window procedure
LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
void (__stdcall *SwitchToThisWindow)(HWND, int);
BOOL CALLBACK searchLSVWMproc(HWND hWnd, LPARAM lParam );
void MoveCursor(int o, int n);
void prefixWinFix(int s);
void postfixWinFix(int s);
void removeWinFix(HWND hwnd);
void addWinFix(HWND hwnd, int s);
int inFix(HWND hwnd);
void CreateImageMasks(HWND hwnd);

HWND hMainWnd=NULL; // main window handle
HWND parent;

// Double buffering data
HDC memDC;		// memory device context
HBITMAP	memBM,  // memory bitmap (for memDC)
		oldBM,  // old bitmap (from memDC)
		bBGBitmap;

wharfDataType wharfData;

UINT Timer=0;
UINT TimerAct=1;

BOOL backInit=FALSE;

int wndSize;
UINT nOffset;
int currentScreen=0;
windowType *winList;
int ratioX, ratioY;

int ScreenWidth = 800;//1152;
int ScreenHeight = 600;//864;

HWND refToplevel;

void createView(void);
void createRecordedView(void);
void switchToDesktop(int desk);
void gatherAll();
int getDesktop(HWND h);
int outsideAnyScreen(RECT r);
int getDesktopByRect(RECT r);
void DoEvents(int n);
void MakeBuffer(HWND hWnd);
int First = 1;

RECT deskRect[4];

HIMAGELIST hBGList;

winDataType winRect[500];
winFixType winFix[500];

int nWinRect=0;
int movingWin=-1;

int ticksNewW=0;
HWND newW=(HWND)-1;

HWND lastActive=NULL;
RECT oldWinPos;
POINTS lastPoint;
BOOL taskMgrSwitch=FALSE;

volatile int lock=0;

int inchk=0;
int mpos=0;
UINT mTimer=2;
UINT mcTimer=3;
int mTimeout=50;

int searched=0;
HINSTANCE inst;
HWND photoshop;
HWND eudora;

BOOL autoswitch=TRUE;
int VWMDistance=2;
HWND tapp, desk, winswitch;

BOOL NoAuto, NoGather;

char inipath[80];

int backColor;
int foreColor;
int selBackColor;
int borderColor;

//////////// Sticky Window Config Types etc
typedef struct {
	char match[80]; //this is the matching text
	int type; //0 (default) for titlematch, 1 (must be specified) for classmatch
} StickyConfigInfoT;
StickyConfigInfoT StickyConfig[256];
////////////////////////////////
// Loads Sticky Window settings
////////////////////////////////
void LoadStickySettings()
{
	char tmpbuf[80];
	char tmpbuf2[80];
	int x;
	strcpy((char *)&inipath,wharfData.lsPath);
	strcat((char *)&inipath,"modules.ini");
	StickyConfig[0].type = GetPrivateProfileInt("lsvwm","stickies",0,inipath);
	for (x=StickyConfig[0].type;x>0;x--)
	{
		_itoa(x,(char *)&tmpbuf,10);
		strcpy((char *)&tmpbuf2,"sticky");
		strcat((char *)&tmpbuf2,(char *)&tmpbuf);
		GetPrivateProfileString("lsvwm",(char *)&tmpbuf2,"",(char *)&StickyConfig[x].match,79,inipath);
		strcpy((char *)&tmpbuf2,"stype");
		strcat((char *)&tmpbuf2,(char *)&tmpbuf);
		StickyConfig[x].type = GetPrivateProfileInt("lsvwm",(char *)&tmpbuf2,0,inipath);
	}
};

//-------------------------------------------------------------------------------------------------
// Init
//-------------------------------------------------------------------------------------------------
int initWharfModule(HWND ParentWnd, HINSTANCE dllInst, wharfDataType *wd)
{
	RECT r;
	HDC pDC;
	char data[1024];
	char bgBMP[112];
	int iHotkey;

    memset(winFix, 0, sizeof(winFixType)*500);

	GetClientRect(GetDesktopWindow(),&r);
	ScreenWidth = r.right;
	ScreenHeight = r.bottom;

	backColor = wd->vwmBackColor;
	foreColor = wd->vwmForeColor;
	selBackColor = wd->vwmSelBackColor;
	borderColor = wd->vwmBorderColor;

	deskRect[0].top = 0;
	deskRect[0].left = 0;
	deskRect[0].right = ScreenWidth;
	deskRect[0].bottom = ScreenHeight;
	deskRect[1].top = 0;
	deskRect[1].left = ScreenWidth+10;
	deskRect[1].right = ScreenWidth*2+10;
	deskRect[1].bottom = ScreenHeight;
	deskRect[2].top = ScreenHeight+10;
	deskRect[2].left = 0;
	deskRect[2].right = ScreenWidth;
	deskRect[2].bottom = ScreenHeight*2+10;
	deskRect[3].top = ScreenHeight+10;
	deskRect[3].left = ScreenWidth+10;
	deskRect[3].right = ScreenWidth*2+10;
	deskRect[3].bottom = ScreenHeight*2+10;

	parent = ParentWnd;
	memcpy(&wharfData, wd, sizeof(wharfDataType));
	wndSize = (64 - wharfData.borderSize*2) / 2;
	nOffset = ((wndSize*2) - 64)+wharfData.borderSize;
	ratioX = ScreenWidth/wndSize;
	ratioY = ScreenHeight/wndSize;
    mTimeout = wharfData.vwmVelocity;
    inst = dllInst;
    NoAuto = wharfData.VWMNoAuto;
    NoGather = wharfData.VWMNoGathering;

    if (NoAuto) autoswitch = FALSE;

	winList = wharfData.winList;
    tapp = FindWindow("TApplication", "LiteStep");
    desk = FindWindow("DesktopBackgroundClass", NULL);
    winswitch = FindWindow("#32771", NULL);
    (long)SwitchToThisWindow = (long)GetProcAddress(GetModuleHandle("USER32.DLL"), "SwitchToThisWindow");

	{	// Register our window class
		WNDCLASS wc;

		memset(&wc,0,sizeof(wc));
		wc.lpfnWndProc = WndProc;				// our window procedure
		wc.hInstance = dllInst;					// hInstance of DLL
		wc.lpszClassName = szAppName;			// our window class name
		wc.style = CS_DBLCLKS;
	
		if (!RegisterClass(&wc)) 
		{
			MessageBox(parent,"Error registering window class",szAppName,MB_OK);
			return 1;
		}
	}


	hMainWnd = CreateWindowEx(
                WS_EX_TRANSPARENT,                                                      // exstyles 
		szAppName,								// our window class name
		szAppName,								// use description for a window title
                WS_CHILD,
                wharfData.borderSize, wharfData.borderSize,                             // position
                64-wharfData.borderSize*2,64-wharfData.borderSize*2,                    // width & height of window
                parent,                                                                 // parent window
		NULL,									// no menu
		dllInst,								// hInstance of DLL
                0);                                                                     // no window creation data

	if (!hMainWnd) 
	{						   
		MessageBox(parent,"Error creating window",szAppName,MB_OK);
		return 1;
	}

	//load sticky windows settings
	LoadStickySettings();

	// Determine which modifier key is being used for the hotkey & register it

	iHotkey = GetPrivateProfileInt(szAppName, "Hotkey", WIN_KEY, inipath);
	switch(iHotkey) {
	case ALT_KEY:
		RegisterHotKey(hMainWnd, 0,	MOD_ALT, VK_LEFT);
		RegisterHotKey(hMainWnd, 1,	MOD_ALT, VK_UP);
		RegisterHotKey(hMainWnd, 2,	MOD_ALT, VK_RIGHT);
		RegisterHotKey(hMainWnd, 3,	MOD_ALT, VK_DOWN);
		break;
	case CTRL_KEY:
		RegisterHotKey(hMainWnd, 0,	MOD_CONTROL, VK_LEFT);
		RegisterHotKey(hMainWnd, 1,	MOD_CONTROL, VK_UP);
		RegisterHotKey(hMainWnd, 2,	MOD_CONTROL, VK_RIGHT);
		RegisterHotKey(hMainWnd, 3,	MOD_CONTROL, VK_DOWN);
		break;
	case WIN_KEY:
	default:
		RegisterHotKey(hMainWnd, 0,	MOD_WIN, VK_LEFT);
		RegisterHotKey(hMainWnd, 1,	MOD_WIN, VK_UP);
		RegisterHotKey(hMainWnd, 2,	MOD_WIN, VK_RIGHT);
		RegisterHotKey(hMainWnd, 3,	MOD_WIN, VK_DOWN);
		break;
	}
		

	SetCursor(LoadCursor(NULL,MAKEINTRESOURCE(IDC_ARROW)));
	SetWindowLong(hMainWnd,GWL_USERDATA,magicDWord); 

	// create our doublebuffer

	pDC = GetDC(parent);
	memDC = CreateCompatibleDC(pDC);
	memBM = CreateCompatibleBitmap(pDC, wndSize*2+2,wndSize*2+2);
	ReleaseDC(parent, pDC);
	oldBM = SelectObject(memDC,memBM);

//	strcpy(data, wharfData.pixmapDir);
//	GetPrivateProfileString(szAppName, "BgBMP", wharfData.defaultBmp, bgBMP, 32, inipath);
	
//	strcat(data, bgBMP);
//	bBGBitmap = LoadImage(dllInst, data, IMAGE_BITMAP, 0, 0, LR_DEFAULTSIZE | LR_LOADFROMFILE);
//	if (bBGBitmap == NULL)
//		MessageBox(hMainWnd, "Bitmap Load Failed", "Error", MB_OK);

//	CreateImageMasks(parent);

	// show the window
	ShowWindow(hMainWnd,SW_SHOWNORMAL);

	SetTimer(hMainWnd, Timer, 500, NULL);
	SetTimer(hMainWnd, TimerAct, 250, NULL);
    SetTimer(hMainWnd, mcTimer, 50, NULL);
	return 0;

}

//-------------------------------------------------------------------------------------------------
// cleanup
//-------------------------------------------------------------------------------------------------
__declspec( dllexport ) void quitWharfModule(HINSTANCE dllInst)
{
	//config_write(this_mod);		// write configuration

	UnregisterHotKey(hMainWnd, 0);
	UnregisterHotKey(hMainWnd, 1);
	UnregisterHotKey(hMainWnd, 2);
	UnregisterHotKey(hMainWnd, 3);

    if (mpos)
        {
        mpos = 0;
        KillTimer(hMainWnd, mTimer);
        }
	
	KillTimer(hMainWnd, mcTimer);
	KillTimer(hMainWnd, Timer);
	KillTimer(hMainWnd, TimerAct);

	gatherAll();

	SelectObject(memDC,oldBM);	// delete our doublebuffer
	DeleteObject(memDC);
	DeleteObject(memBM);

	DestroyWindow(hMainWnd); // delete our window
	UnregisterClass(szAppName,dllInst/*this_mod->hDllInstance*/); // unregister window class
}


////////////////////////////////////////////////////////////////
// Checks to see if given window is supposed to be left alone
////////////////////////////////////////////////////////////////
int StickyCheck1(HWND targetWin, char* matchval)
{
	char tmpbuf[80];
	GetClassName(targetWin, (char *)&tmpbuf, 79);
	if (match(matchval,(char *)&tmpbuf)) {return 1;}
	return 0;
}

int StickyCheck0(HWND targetWin, char* matchval)
{
	char tmpbuf[80];
	GetWindowText(targetWin, (char *)&tmpbuf, 79);
	if (match(matchval,(char *)&tmpbuf)) {return 1;}
	return 0;
}

int topWindowAlways(HWND targetWin)
{
	int x;
	int issticky;
	issticky = 0;
	x = StickyConfig[0].type;
	//while we havent finished checking against windows to ignore
	while ((x > 0) && (!issticky)) {
		if (StickyConfig[x].type == 1) {issticky = StickyCheck1(targetWin,StickyConfig[x].match);}
		else {issticky = StickyCheck0(targetWin,StickyConfig[x].match);}
		x--;
	}
	return issticky;
}

//-------------------------------------------------------------------------------------------------
// window procedure for our window
//-------------------------------------------------------------------------------------------------
LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
//HDC dp;

	switch (message)
	{
		case WM_CREATE:		
            return 0;
		case WM_ERASEBKGND: return 0;
		case WM_PAINT:
			{ // update from doublebuffer
				PAINTSTRUCT ps;
				RECT r;
				HDC hdc = BeginPaint(hwnd,&ps);

				if (First) 
				{
					MakeBuffer(parent);
					CreateImageMasks(parent);
					First = 0;
				}

				GetClientRect(hwnd,&r);
				if (!backInit)
				{
					createView();
					backInit = TRUE;
				}
				BitBlt(hdc,0,0,r.right,r.bottom,memDC,0,0,SRCCOPY);
				EndPaint(hwnd,&ps);
			}
		return 0;
                case WM_KEYDOWN: 
		case WM_KEYUP:
                        {       
                        PostMessage(parent,message,wParam,lParam);
			}
		return 0;
		case WM_RBUTTONDOWN:
                        if (lock) 
                                { // Try later
				PostMessage(hwnd, message, wParam, lParam);
				return 0;
				}
			lock = 1;
                        { // Change desktop
			POINTS pts;
			int s=0;
			
                        PostMessage(GetParent(GetParent(parent)), 9183, 0, 0);

			pts = MAKEPOINTS(lParam);
			if (pts.x > wndSize) s++;
			if (pts.y > wndSize) s+=2;
			if (s != currentScreen) 
				{
				RECT r;
				switchToDesktop(s);
				GetClientRect(hwnd,&r);
				createView();
				InvalidateRect(hwnd, &r, FALSE);
				}
			}
			lock=0;
		return 0;
		case WM_LBUTTONDOWN:
                        { // Move a window from its miniview
			POINTS pts;
			int i;
			
            PostMessage(GetParent(GetParent(parent)), 9183, 0, 0);

			pts = MAKEPOINTS(lParam);
			for (i=0;winRect[i].valid;i++);
			for (i--; i>=0;i--)
				{
				if (pts.x - wndSize * (currentScreen & 1) >= winRect[i].r.left/ratioX && pts.x - wndSize * (currentScreen & 1) <= winRect[i].r.right/ratioX && pts.y-wndSize * (currentScreen & 2 ? 1 : 0) >= winRect[i].r.top/ratioY && pts.y -wndSize * (currentScreen & 2 ? 1 : 0)<= winRect[i].r.bottom/ratioY)
					{
                                        GetWindowRect(winRect[i].hwnd, &oldWinPos);
                                        movingWin = i;
                                        lastPoint = pts;
                                        SetCapture(hMainWnd); // Capture mouse
					break;
					}
				}
			}
		return 0;
		case WM_LBUTTONUP:
                        { // End moving
			POINTS pts;
			RECT r;

            PostMessage(GetParent(GetParent(parent)), 9183, 0, 0);

			pts = MAKEPOINTS(lParam);
			ReleaseCapture();
                        // If we are outside the virtual space, cancel move
			if (pts.x < 0 || pts.y < 0 || pts.x > 64-wharfData.borderSize*2 || pts.y > 64-wharfData.borderSize*2)
				MoveWindow(winRect[movingWin].hwnd, oldWinPos.left, oldWinPos.top, oldWinPos.right-oldWinPos.left, oldWinPos.bottom-oldWinPos.top, TRUE);
			else if (GetWindowLong(winRect[movingWin].hwnd, GWL_STYLE) & WS_MAXIMIZE)
                                { // If window is maximized, make it jump to same coordinates on another desktop
				RECT newRect;
				int oldDesk = getDesktopByRect(oldWinPos);
				int newDesk = 0;
				if (pts.x > (64-wharfData.borderSize*2) / 2) newDesk++;
				if (pts.y > (64-wharfData.borderSize*2) / 2) newDesk+=2;
				newRect.top = oldWinPos.top + deskRect[newDesk].top - deskRect[oldDesk].top;
				newRect.left = oldWinPos.left + deskRect[newDesk].left - deskRect[oldDesk].left;
				newRect.bottom = oldWinPos.bottom + deskRect[newDesk].top - deskRect[oldDesk].top;
				newRect.right = oldWinPos.right + deskRect[newDesk].left - deskRect[oldDesk].left;
				MoveWindow(winRect[movingWin].hwnd, newRect.left, newRect.top, newRect.right-newRect.left, newRect.bottom-newRect.top, TRUE);
				GetWindowRect(winRect[movingWin].hwnd, &winRect[movingWin].r);
				}
			GetClientRect(hwnd,&r);
			createRecordedView();
			InvalidateRect(hwnd, &r, FALSE);
			movingWin=-1;
			}
		return 0;
        case WM_MBUTTONDOWN:
            PostMessage(GetParent(GetParent(parent)), 9183, 0, 0);
            return 0;
		case WM_MOUSEMOVE:
                        { 
			POINTS pts;
			POINTS thisPt;
			RECT r;

			if (movingWin == -1) return 0;
                        // We are moving a window with its miniview
			pts = MAKEPOINTS(lParam);
			thisPt = pts;
			pts.x -= lastPoint.x;
			pts.y -= lastPoint.y;
			GetWindowRect(winRect[movingWin].hwnd, &winRect[movingWin].r);
			MoveWindow(winRect[movingWin].hwnd, winRect[movingWin].r.left + pts.x*ratioX, winRect[movingWin].r.top + pts.y * ratioY, winRect[movingWin].r.right + pts.x * ratioX - (winRect[movingWin].r.left + pts.x*ratioX), winRect[movingWin].r.bottom + pts.y * ratioY-(winRect[movingWin].r.top + pts.y*ratioY), TRUE);
			GetWindowRect(winRect[movingWin].hwnd, &winRect[movingWin].r);
			lastPoint = thisPt;

			GetClientRect(hwnd,&r);
			createRecordedView();
			InvalidateRect(hwnd, &r, FALSE);
			}
		return 0;
        case WM_LBUTTONDBLCLK:
            { // toggle autoswitch
            char txt[50];
            autoswitch = !autoswitch;
            sprintf(txt, "VWM AutoSwitch is now %s", autoswitch ? "ON" : "OFF");
            MessageBox(parent, txt, "LiteStep VWM", 0);
            }

		case WM_HOTKEY:
                        { // Change desktop via hotkeys
			RECT r;
			if (lock)
				{
				PostMessage(hwnd, message, wParam, lParam);
				return 0;
				}
			lock = 1;
			switch (wParam)
				{
				case 0:
					if (currentScreen == 1 || currentScreen == 3)
						switchToDesktop(currentScreen-1);
					break;
				case 1:
					if (currentScreen == 2 || currentScreen == 3)
						switchToDesktop(currentScreen-2);
					break;
				case 2:
					if (currentScreen == 0 || currentScreen == 2)
						switchToDesktop(currentScreen+1);
					break;
				case 3:
					if (currentScreen == 0 || currentScreen == 1)
						switchToDesktop(currentScreen+2);
					break;
				}
			GetClientRect(hMainWnd, &r);
			createView();
			InvalidateRect(hMainWnd, &r, FALSE);
			}
			lock=0;
		return 0;
		case 8891: // Change window focus via message (change desktop if needed)
			//taskMgrSwitch = TRUE;
			if (lock)
                                { // Try later
				PostMessage(hwnd, message, wParam, lParam);
				return 0;
				}
			lock = 1;
				{
				int n = getDesktop((HWND)lParam);
				if (n != currentScreen) switchToDesktop(n);
	            //SetForegroundWindow((HWND)lParam);
                SwitchToThisWindow((HWND)lParam, 1);
				}
			lock=0;
		return 0;
		case WM_DISPLAYCHANGE:
            { // Intercept dynamic resolution changes
            int cxScreen = LOWORD(lParam); 
            int cyScreen = HIWORD(lParam);
            int i,d,s;
            RECT r;
            for (i=0;winRect[i].valid;i++)
	            {
                s = GetWindowLong(winRect[i].hwnd, GWL_STYLE) & WS_MAXIMIZE; 
                d = getDesktop(winRect[i].hwnd);
	            GetWindowRect(winRect[i].hwnd, &r);
                if (d & 1)
                    {
   	                r.left-=(ScreenWidth-cxScreen);
                    r.right-=(ScreenWidth-cxScreen);
                    if (s) 
                        r.right-=(ScreenWidth-cxScreen);
                    }
                if (d & 2)
                    {
                    r.top-=(ScreenHeight-cyScreen);
       	            r.bottom-=(ScreenHeight-cyScreen);
    	            if (s)
   	                    r.bottom-=(ScreenHeight-cyScreen);
                    }
                MoveWindow(winRect[i].hwnd, r.left, r.top, r.right-r.left, r.bottom-r.top, TRUE);
                ScreenWidth = cxScreen;
                ScreenHeight = cyScreen;
            	deskRect[0].top = 0;
	            deskRect[0].left = 0;
	            deskRect[0].right = ScreenWidth;
	            deskRect[0].bottom = ScreenHeight;
	            deskRect[1].top = 0;
	            deskRect[1].left = ScreenWidth+10;
	            deskRect[1].right = ScreenWidth*2+10;
	            deskRect[1].bottom = ScreenHeight;
	            deskRect[2].top = ScreenHeight+10;
	            deskRect[2].left = 0;
	            deskRect[2].right = ScreenWidth;
	            deskRect[2].bottom = ScreenHeight*2+10;
	            deskRect[3].top = ScreenHeight+10;
	            deskRect[3].left = ScreenWidth+10;
	            deskRect[3].right = ScreenWidth*2+10;
	            deskRect[3].bottom = ScreenHeight*2+10;
                }
            }
        return 0;
		case WM_TIMER:
                        { 
                        if (lock) // cancel
				return 0;
            if (wParam == mTimer)
                {
                if (autoswitch)
                    { // We need to autoswitch (mouse stayed longer than timeout onb a border of the screen)
                    int nmpos=0;
                    int newScreen = currentScreen;
                    DWORD a = GetMessagePos();
                    POINTS pts;
                    pts = MAKEPOINTS(a);

                    if (pts.x == 0) nmpos |= 1;
                    if (pts.y == 0) nmpos |= 2;
                    if (pts.x == ScreenWidth-1) nmpos |= 4;
                    if (pts.y == ScreenHeight-1) nmpos |= 8;

                    if (nmpos)
                        {
                        if (nmpos & 1)
                            if (currentScreen == 1 || currentScreen == 3)
	                            newScreen--;
                        if (nmpos & 2)
                            if (currentScreen == 2 || currentScreen == 3)
		                        newScreen -=2;
                        if (nmpos & 4)
                            if (currentScreen == 0 || currentScreen == 2)
                                newScreen++;
                        if (nmpos & 8)
                            if (currentScreen == 0 || currentScreen == 1)
                                newScreen +=2;
                    
                        if (currentScreen != newScreen)
                            {
                            RECT r;
                            MoveCursor(currentScreen, newScreen);
                            switchToDesktop(newScreen);
    
	                        GetClientRect(hMainWnd,&r);
                        	createView();
	                        InvalidateRect(hMainWnd, &r, FALSE);
                            mpos = 0;
                            }
                        }
                    }
                KillTimer(hMainWnd, mTimer);
                return 0;
                }
            else
                if (wParam == mcTimer)
                    {
                    POINTS pts;
                    DWORD a = GetMessagePos();
                    int nmpos = 0;
                    pts = MAKEPOINTS(a);

                    if (pts.x == 0) nmpos |= 1;
                    if (pts.y == 0) nmpos |= 2;
                    if (pts.x == ScreenWidth-1) nmpos |= 4;
                    if (pts.y == ScreenHeight-1) nmpos |= 8;

                    if (!nmpos)
                        {
                        if (mpos)
                            {
                            KillTimer(hMainWnd, mTimer);
                            mpos = 0;
                            }
                        }
                    else
                        {
                        if (!mpos)
                            {
                            mpos = nmpos;
                            SetTimer(hMainWnd, mTimer, mTimeout, NULL);
                            }
                        }
                    return 0;
                    }

           	lock = 1;

            if (!wParam) // main timer, update view, check focus change
                {
    		    RECT r;
			    GetClientRect(hwnd,&r);
			    createView();
			    InvalidateRect(hwnd, &r, FALSE);
			    }
            else
   				{
   				int style=0;
    			int a=0;
	    		RECT r;
		    	HWND newFGWin = GetForegroundWindow();

   				if (newFGWin)
    				{
	    			style = GetWindowLong(newFGWin, GWL_STYLE);
		    		a = GetWindowLong(newFGWin, GWL_USERDATA);
			    	}
				
    			if (newFGWin != lastActive)
	    			{
// This causes a timeout to be applied against focus change, obsolete?
//		   			if (newFGWin == newW)
//		    			{
//			    		ticksNewW++;
//				    	if (ticksNewW > 0)
//					    	{
						    GetWindowRect(newFGWin, &r);
						    if (!outsideAnyScreen(r) && 
						        !(a == magicDWord || !newFGWin || IsIconic(newFGWin) || 
    							  !(style & WS_VISIBLE) || (style & WS_DISABLED) || 
	    						  IsIconic(lastActive) || (lastActive && !IsWindow(lastActive))
		   						  || (!taskMgrSwitch && lastActive && GetWindowLong(lastActive, GWL_USERDATA) == magicDWord))
		    					 )
			    				{
				    			int newScr = getDesktop(newFGWin);
					    		if (newScr != currentScreen)
						    		switchToDesktop(newScr);
							    taskMgrSwitch=FALSE;
    							}   
	    					lastActive = newFGWin;
// End timeout
//		   					newW = (HWND)-1;
//		    				}
//			    		}
//				    else
//  					{
//	    				newW = newFGWin;
//		   				ticksNewW = 0;
//		    			}
			    	}
                }
			}
			lock = 0;
		return 0;
	}

return DefWindowProc(hwnd,message,wParam,lParam);
}

//----------------------------------------------------------------------------
// Get Background bitmap
//----------------------------------------------------------------------------
void MakeBuffer(HWND hWnd)
{
	RECT r;
	HDC hdc = GetDC(hWnd), tempDC;
	HBITMAP bOld;
	GetClientRect(hWnd,&r);
	bBGBitmap = CreateCompatibleBitmap(hdc, 64, 64);
	tempDC = CreateCompatibleDC(NULL);
	bOld = (HBITMAP)SelectObject(tempDC, bBGBitmap);
	BitBlt(tempDC, 0, 0, r.right, r.bottom, hdc, 0, 0, SRCCOPY);
	DeleteDC(tempDC);
	ReleaseDC(hWnd, hdc);
}




//----------------------------------------------------------------------------
// Get shifting value from a desktop to another
//----------------------------------------------------------------------------
void getShifts(int old, int desk, int *addH, int *addV)
{
switch (old)
	{
	case 0:
		switch (desk)
			{
			case 1:
				*addH = (ScreenWidth+10);
				*addV = 0;
				break;
			case 2:
				*addH = 0;
				*addV = (ScreenHeight+10);
				break;
			case 3:
				*addH = (ScreenWidth+10);
				*addV = (ScreenHeight+10);
				break;
			}
		break;
	case 1:
		switch (desk)
			{
			case 0:
				*addH = -(ScreenWidth+10);
				*addV = 0;
				break;
			case 2:
				*addH = -(ScreenWidth+10);
				*addV = (ScreenHeight+10);
				break;
			case 3:
				*addH = 0;
				*addV = (ScreenHeight+10);
				break;
			}
		break;
	case 2:
		switch (desk)
			{
			case 0:
				*addH = 0;
				*addV = -(ScreenHeight+10);
				break;
			case 1:
				*addH = (ScreenWidth+10);
				*addV = -(ScreenHeight+10);
				break;
			case 3:
				*addH = (ScreenWidth+10);
				*addV = 0;
				break;
			}
		break;
	case 3:
		switch (desk)
			{
			case 0:
				*addH = -(ScreenWidth+10);
				*addV = -(ScreenHeight+10);
				break;
			case 1:
				*addH = 0;
				*addV = -(ScreenHeight+10);
				break;
			case 2:
				*addH = -(ScreenWidth+10);
				*addV = 0;
				break;
			}
		break;
	}
}

//-------------------------------------------------------------------------------------------------
// Callback function. Windows enumeration
//-------------------------------------------------------------------------------------------------
BOOL CALLBACK EnumWindowsProc(HWND hwnd, LPARAM lParam)
{

/*if (!refTopmost && (GetWindowLong(hwnd, GWL_EXSTYLE) & WS_EX_TOPMOST))
	{
	refTopmost = hwnd;
	return !refToplevel;
	}*/

if (!refToplevel && !(GetWindowLong(hwnd, GWL_EXSTYLE) & WS_EX_TOPMOST))
	{
	refToplevel = hwnd;
	return FALSE;//!refTopmost;
	}

return TRUE;
}

//-------------------------------------------------------------------------------------------------
// Callback functions, check for eudora
//-------------------------------------------------------------------------------------------------
BOOL CALLBACK EudoraEnumChildProc(HWND hwnd, LPARAM lParam)
{
HWND owner = GetWindow(hwnd, GW_OWNER);

if (owner != eudora) return TRUE;
    {
    int style = GetWindowLong(hwnd, GWL_STYLE);

    if (style & WS_VISIBLE && style & WS_POPUP)
        {
        char txt[25];
        GetWindowText(hwnd, txt, 23);
        if (!strcmp(txt, "Progress") || !strcmp(txt, "No New Mail") || !strcmp(txt, "New Mail!") || !strcmp(txt, "Eudora Network Timeout"))
            {
            RECT r;
            RECT r2;
            RECT r3;
            GetWindowRect(eudora, &r);
            GetWindowRect(hwnd, &r2);
            r3.left = ((r.right-r.left-(r2.right-r2.left)) / 2) + r.left;
            r3.top = ((r.bottom-r.top-(r2.bottom-r2.top)) / 2) + r.top;
            r3.right = r3.left + (r2.right-r2.left);
            r3.bottom = r3.top + (r2.bottom-r2.top);
            MoveWindow(hwnd, r3.left, r3.top, r3.right-r3.left, r3.bottom-r3.top, TRUE);
            }
        }
    }

return TRUE;
}

//-------------------------------------------------------------------------------------------------
// Create the wharf view
//-------------------------------------------------------------------------------------------------
void createView(void)
{
	//int i;
	HWND prev, p;
	RECT r;
	int H=0, V=0;
	static int oldnRects=0;
	int nRects=0;
	HBRUSH hWhiteBrush,
		hGreyBrush,
		hBlueBrush,
		oldBrush;
	HPEN pen,oldpen;
	// If we are moving a window from the miniview, cancel drawing
	if (movingWin > -1) return;
	
	hBlueBrush = CreateSolidBrush(backColor);
	hWhiteBrush = CreateSolidBrush(foreColor);
	hGreyBrush = CreateSolidBrush(selBackColor);

	
	// draw main bg
	pen = CreatePen(PS_SOLID, 1, borderColor);
	oldBrush = SelectObject(memDC, hBlueBrush);
	oldpen = SelectObject(memDC, pen);
//	Rectangle(memDC, 0, 0, wndSize*2, wndSize*2);
	ImageList_Draw(hBGList, 0, memDC, nOffset, nOffset, ILD_NORMAL);
	ImageList_Draw(hBGList, 1, memDC, wndSize, nOffset, ILD_NORMAL);
	ImageList_Draw(hBGList, 2, memDC, nOffset, wndSize, ILD_NORMAL);
	ImageList_Draw(hBGList, 3, memDC, wndSize, wndSize, ILD_NORMAL);

	// draw some other stuff
	MoveToEx(memDC, wndSize, 0, NULL);
	LineTo(memDC, wndSize, wndSize*2);
	MoveToEx(memDC, 0, wndSize, NULL);
	LineTo(memDC, wndSize*2, wndSize);
	

	// calc and draw selected bg
	r.left = wndSize*(currentScreen & 1);
	r.top = wndSize*(currentScreen & 2 ? 1 : 0);
	r.right = r.left+wndSize+1-(currentScreen & 1);
	r.bottom = r.top+wndSize+1-(currentScreen & 2 ? 1 : 0);
	SelectObject(memDC, hGreyBrush);

	Rectangle(memDC, r.left, r.top, r.right, r.bottom);
	ImageList_DrawEx(hBGList, currentScreen, memDC, r.left, r.top, 32, 32, 0, selBackColor, ILD_BLEND50);
	
	SelectObject(memDC, hWhiteBrush);
	
	getShifts(0, currentScreen, &H, &V);
	
	refToplevel = NULL;
	nWinRect=0;
	//refTopmost = NULL;
	// Get a topmost window
	EnumWindows(EnumWindowsProc, 0);
	
	prev = GetWindow(refToplevel, GW_HWNDLAST);
	goto inside;
	while (1)
	{ 
		prev = GetWindow(prev, GW_HWNDPREV);
		inside:
			if (prev == NULL) break;
		
			//added the part at the end to check if its an always on top window
			if ((!(GetWindowLong(prev, GWL_STYLE) & WS_VISIBLE)) && (!topWindowAlways(prev)))
				continue;
			p = GetParent(prev);
			if (GetWindowLong(prev, GWL_USERDATA) == magicDWord)
				continue;
			GetWindowRect(prev, &winRect[nWinRect].r);
			nRects+=(int)prev;
			Rectangle(memDC, (winRect[nWinRect].r.left + H) / ratioX,
				(winRect[nWinRect].r.top + V) / ratioY,
				(winRect[nWinRect].r.right + H) / ratioX,
				(winRect[nWinRect].r.bottom + V) / ratioY);
			winRect[nWinRect].hwnd=prev;
			winRect[nWinRect++].valid=1;
	}
	
	if (nRects != oldnRects)
    {
		if (! (GetWindowLong(winswitch, GWL_STYLE) & WS_VISIBLE) )
        {
			HWND last = GetWindow(desk, GW_HWNDLAST);
			while (last && last != desk)
			{
				if (GetWindowLong(last, GWL_STYLE) & WS_VISIBLE)
				{
					SetWindowPos(last, GetWindow(desk, GW_HWNDPREV), 0, 0, 0, 0, SWP_NOSIZE|SWP_NOMOVE);
					last = GetWindow(desk, GW_HWNDLAST);
					continue;
				}
				last = GetWindow(last, GW_HWNDPREV);
			}
			
			
        }
		oldnRects = nRects;
		eudora = FindWindow("EudoraMainWindow", NULL);
		if (eudora)
			EnumWindows(EudoraEnumChildProc, 0);
    }
	
	memset(&winRect[nWinRect], 0, sizeof(winDataType));
	SelectObject(memDC, oldpen);
	SelectObject(memDC, oldBrush);
	DeleteObject(hWhiteBrush);
	DeleteObject(hGreyBrush);
	DeleteObject(hBlueBrush);
	DeleteObject(pen);
}

//-------------------------------------------------------------------------------------------------
// Callback functions. Enumerates windows to be fixed (hidden when not in active desktop)
//-------------------------------------------------------------------------------------------------
BOOL CALLBACK FixEnumChildProc(HWND hwnd, LPARAM lParam)
{
HWND owner = GetWindow(hwnd, GW_OWNER);

if (owner != photoshop) return TRUE;
    {
    int style = GetWindowLong(hwnd, GWL_STYLE);

    if (style & WS_VISIBLE && style & WS_POPUP)
        if (!inFix(hwnd))
            {
            ShowWindow(hwnd, SW_HIDE);
            addWinFix(hwnd, currentScreen);
            }
    }

return TRUE;
}

//-------------------------------------------------------------------------------------------------
// Does the desktop switching
//-------------------------------------------------------------------------------------------------
void switchToDesktop(int _desk)
{
//int i;
RECT r;
HWND prev, p;
HDWP dwp;

int addH=0, addV=0;

if (movingWin > -1) return;

getShifts(currentScreen, _desk, &addH, &addV);

// Fix photoshop
photoshop = FindWindow("Photoshop", NULL);
if (photoshop)
    EnumWindows(FixEnumChildProc, 0);

refToplevel = NULL;
EnumWindows(EnumWindowsProc, 0);

prev = GetWindow(refToplevel, GW_HWNDLAST);

DoEvents(2);

dwp = BeginDeferWindowPos(nWinRect+16);

goto inside;
while (1)
	{
	prev = GetWindow(prev, GW_HWNDPREV);
	inside:
	if (prev == NULL) break;

	if (!(GetWindowLong(prev, GWL_STYLE) & WS_VISIBLE))
		continue;
	p = GetParent(prev);
	if (GetWindowLong(prev, GWL_USERDATA) == magicDWord /*|| prev == 0xE44*/)
		continue;
	if (SendMessage(desk, 9212, 0, (long)prev))
		continue;
//inserted code here to check if the window has been set to be ignored
	if (!topWindowAlways(prev)) {
		GetWindowRect(prev, &r);
		r.left-=addH;
		r.right-=addH;
		r.top -=addV;
		r.bottom-=addV;

		//MoveWindow(prev, r.left, r.top, r.right-r.left, r.bottom-r.top, TRUE);
		dwp = DeferWindowPos(dwp, prev, NULL, r.left, r.top, r.right-r.left, r.bottom-r.top, SWP_NOZORDER | SWP_NOACTIVATE);
		}
	}

currentScreen = _desk;
EndDeferWindowPos(dwp);

postfixWinFix(currentScreen);
}

//-------------------------------------------------------------------------------------------------
// Gather all windows in one desktop
//-------------------------------------------------------------------------------------------------
void gatherAll()
{
//int i;
RECT r;
HWND prev, p;

if (NoGather) 
    {
    if (currentScreen != 0)
        switchToDesktop(0);
    return;
    }

refToplevel = NULL;
EnumWindows(EnumWindowsProc, 0);

prev = GetWindow(refToplevel, GW_HWNDLAST);
goto inside;
while (1)
	{
	prev = GetWindow(prev, GW_HWNDPREV);
	inside:
	if (prev == NULL) break;

	if (!(GetWindowLong(prev, GWL_STYLE) & WS_VISIBLE))
		continue;
	p = GetParent(prev);
	if (GetWindowLong(prev, GWL_USERDATA) == magicDWord/* || prev == 0x57C*/)
		continue;
	GetWindowRect(prev, &r);
	if (r.left > ScreenWidth)
		{
		r.left -= (ScreenWidth+10);
		r.right -= (ScreenWidth+10);
		}
	if (r.top > ScreenHeight)
		{
		r.top -= (ScreenHeight+10);
		r.bottom -= (ScreenHeight+10);
		}
	if (r.left < -10)
		{
		r.right += (ScreenWidth+10);
		r.left += (ScreenWidth+10);
		}
	if (r.top < -10)
		{
		r.bottom += (ScreenHeight+10);
		r.top += (ScreenHeight+10);
		}
	MoveWindow(prev, r.left, r.top, r.right-r.left, r.bottom-r.top, TRUE);
	}
currentScreen = 0;
}

//-------------------------------------------------------------------------------------------------
// Creates the view from known window positions
//-------------------------------------------------------------------------------------------------
void createRecordedView(void)
{
//int i;
RECT r;
int H=0, V=0;
int i;
HBRUSH hWhiteBrush,
	   hGreyBrush,
	   hBlueBrush,
	   oldBrush;
HPEN pen,oldpen;
///HDC tempDC; ///this is unreferrenced???
///char data[1024]; ///this is unreferenced???

hBlueBrush = CreateSolidBrush(backColor);
hWhiteBrush = CreateSolidBrush(foreColor);
hGreyBrush = CreateSolidBrush(selBackColor);
pen = CreatePen(PS_SOLID, 1, borderColor);
oldBrush = SelectObject(memDC, hBlueBrush);
oldpen = SelectObject(memDC, pen);

//Rectangle(memDC, 0, 0, wndSize*2, wndSize*2);
	ImageList_Draw(hBGList, 0, memDC, 0, 0, ILD_NORMAL);
	ImageList_Draw(hBGList, 1, memDC, 32, 0, ILD_NORMAL);
	ImageList_Draw(hBGList, 2, memDC, 0, 32, ILD_NORMAL);
	ImageList_Draw(hBGList, 3, memDC, 32, 32, ILD_NORMAL);
/*
	tempDC = CreateCompatibleDC(NULL);
	SelectObject(tempDC, bBGBitmap);
	if (!BitBlt(memDC, 0, 0, 64, 64, tempDC, 0, 0, SRCCOPY)) {
		Rectangle(memDC, 0, 0, wndSize*2, wndSize*2);
		MessageBox(hMainWnd, "Failed", "Error", MB_OK);
	}
	DeleteDC(tempDC);
*/

MoveToEx(memDC, wndSize, 0, NULL);
LineTo(memDC, wndSize, wndSize*2);
MoveToEx(memDC, 0, wndSize, NULL);
LineTo(memDC, wndSize*2, wndSize);

r.left = wndSize*(currentScreen & 1);
r.top = wndSize*(currentScreen & 2 ? 1 : 0);
r.right = r.left+wndSize+1-(currentScreen & 1);;
r.bottom = r.top+wndSize+1-(currentScreen & 2 ? 1 : 0);;
SelectObject(memDC, hGreyBrush);

	Rectangle(memDC, r.left, r.top, r.right, r.bottom);
	ImageList_DrawEx(hBGList, currentScreen, memDC, r.left, r.top, 32, 32, 0, selBackColor, ILD_BLEND50);

SelectObject(memDC, hWhiteBrush);

getShifts(0, currentScreen, &H, &V);

for (i=0;winRect[i].valid;i++)
	{
	GetWindowRect(winRect[i].hwnd, &winRect[i].r);
	Rectangle(memDC, (winRect[i].r.left + H) / ratioX ,
					 (winRect[i].r.top + V) / ratioY,
					 (winRect[i].r.right + H) / ratioX,
					 (winRect[i].r.bottom + V) / ratioY);
	}

SelectObject(memDC, oldpen);
SelectObject(memDC, oldBrush);
DeleteObject(hWhiteBrush);
DeleteObject(hGreyBrush);
DeleteObject(hBlueBrush);
DeleteObject(pen);
}

//-------------------------------------------------------------------------------------------------
// Returns the desktop associated with a window
//-------------------------------------------------------------------------------------------------
int getDesktop(HWND h)
{
RECT r;
int desk=0;

	GetWindowRect(h, &r);

	if (r.left > ScreenWidth)
		desk += 1;
	if (r.left < -10)
		desk -= 1;

	if (r.top > ScreenHeight)
		desk += 2;
	if (r.top < -10)
		desk -= 2;

desk += currentScreen;
if (desk < 0 || desk > 3) desk = 0;
return desk;
}

//-------------------------------------------------------------------------------------------------
// Get a desktop associated with a RECT
//-------------------------------------------------------------------------------------------------
int getDesktopByRect(RECT r)
{
int desk=0;

	if (r.left > ScreenWidth)
		desk += 1;
	if (r.left < -10)
		desk -= 1;

	if (r.top > ScreenHeight)
		desk += 2;
	if (r.top < -10)
		desk -= 2;

desk += currentScreen;
if (desk < 0 || desk > 3) desk = 0;
return desk;
}

//-------------------------------------------------------------------------------------------------
// Check if a RECT is outside of the virtual space
//-------------------------------------------------------------------------------------------------
int outsideAnyScreen(RECT r)
{
return (r.left > ScreenWidth*2 +10 || r.top > ScreenHeight*2 +10);
}

//-------------------------------------------------------------------------------------------------
// Changes cursor position 
//-------------------------------------------------------------------------------------------------
void MoveCursor(int o, int n)
{
int h, v;
POINT ps;

getShifts(o, n, &h, &v);

GetCursorPos(&ps);
if (h) h -= (h > 0) ? (10 + wharfData.VWMDistance) : -(10 + wharfData.VWMDistance);
if (v) v -= (v > 0) ? (10 + wharfData.VWMDistance) : -(10 + wharfData.VWMDistance);
ps.x -= h;
ps.y -= v;
SetCursorPos(ps.x, ps.y);
}

//-------------------------------------------------------------------------------------------------
// Add a photoshop tool-like window to be fixed
//-------------------------------------------------------------------------------------------------
void addWinFix(HWND hwnd, int s)
{
int i;
for (i=0;i<500 && winFix[i].hwnd;i++);

if (i >= 500) return;
winFix[i].hwnd = hwnd;
winFix[i].screen = s;
}

//-------------------------------------------------------------------------------------------------
// Remove a photoshop tool-like window to be fixed
//-------------------------------------------------------------------------------------------------
void removeWinFix(HWND hwnd)
{
int i;
for (i=0;i<500 && winFix[i].hwnd != hwnd;i++);

if (i >= 500) return;
winFix[i].hwnd = NULL;
winFix[i].screen = 0;
}

//-------------------------------------------------------------------------------------------------
// Fixes the window (part2)
//-------------------------------------------------------------------------------------------------
void postfixWinFix(int s)
{
int i;
for (i=0;i<500;i++)
    {
    if (winFix[i].hwnd && winFix[i].screen == s)
        {
        ShowWindow(winFix[i].hwnd, SW_SHOWNA);
        winFix[i].hwnd = NULL;
        winFix[i].screen = 0;
        }
    }
}

//-------------------------------------------------------------------------------------------------
// Fixes the window (part 1)
//-------------------------------------------------------------------------------------------------
void prefixWinFix(int s)
{
int i;
for (i=0;i<500;i++)
    {
    if (winFix[i].hwnd && winFix[i].screen == s)
        ShowWindow(winFix[i].hwnd, SW_HIDE);
    }
}

//-------------------------------------------------------------------------------------------------
// Checks if a window is in fixed windows list
//-------------------------------------------------------------------------------------------------
int inFix(HWND hwnd)
{
int i;

for (i=0;i<500 && winFix[i].hwnd != hwnd;i++);
if (i>=500) return 0;
return 1;    
}
 
//-------------------------------------------------------------------------------------------------
// Non blocking wait
// -------------------------------------------------------------------------------------------------------
void DoEvents(int n)
{
int i;
BOOL b=TRUE;
MSG msg;

for (i=0;i<n && b;i++)
    {
    b = GetMessage( &msg, NULL, 0, 0 );
    if (b) 
        {
	    TranslateMessage( &msg );
	    DispatchMessage( &msg ); 
        }
    }
}

/*********************************************************************/
/* Create Masked Images                                               */
/*********************************************************************/
void CreateImageMasks(HWND hwnd)
{
	HBITMAP bPane, bOld;
	HDC	hdc = GetDC(hwnd), TempDC, bgDC;

	bgDC = CreateCompatibleDC(hdc);
	SelectObject(bgDC, bBGBitmap);

	hBGList = ImageList_Create(32, 32, ILC_COLOR32, 0, 4);

	TempDC = CreateCompatibleDC(hdc);
	bPane = CreateCompatibleBitmap(hdc, 32, 32);

	// Pane 1
	bOld = (HBITMAP)SelectObject(TempDC, bPane);
	if (!BitBlt(TempDC, 0, 0, 32, 32, bgDC, 0, 0, SRCCOPY))
		MessageBox(hMainWnd, "BitBlt failed", "Error", MB_OK);
	SelectObject(TempDC, bOld);

	if (ImageList_Add(hBGList, bPane, NULL) == -1)
		MessageBox(hMainWnd, "Could not add image...", "Error", MB_OK);

	// Pane 2
	bOld = (HBITMAP)SelectObject(TempDC, bPane);
	if (!BitBlt(TempDC, 0, 0, 32, 32, bgDC, 32, 0, SRCCOPY))
		MessageBox(hMainWnd, "BitBlt failed", "Error", MB_OK);
	SelectObject(TempDC, bOld);

	if (ImageList_Add(hBGList, bPane, NULL) == -1)
		MessageBox(hMainWnd, "Could not add image...", "Error", MB_OK);

	// Pane 3
	bOld = (HBITMAP)SelectObject(TempDC, bPane);
	if (!BitBlt(TempDC, 0, 0, 32, 32, bgDC, 0, 32, SRCCOPY))
		MessageBox(hMainWnd, "BitBlt failed", "Error", MB_OK);
	SelectObject(TempDC, bOld);

	if (ImageList_Add(hBGList, bPane, NULL) == -1)
		MessageBox(hMainWnd, "Could not add image...", "Error", MB_OK);
	
	// Pane 4
	bOld = (HBITMAP)SelectObject(TempDC, bPane);
	if (!BitBlt(TempDC, 0, 0, 32, 32, bgDC, 32, 32, SRCCOPY))
		MessageBox(hMainWnd, "BitBlt failed", "Error", MB_OK);
	SelectObject(TempDC, bOld);

	if (ImageList_Add(hBGList, bPane, NULL) == -1)
		MessageBox(hMainWnd, "Could not add image...", "Error", MB_OK);

	ReleaseDC(hwnd, hdc);
	DeleteDC(TempDC);
	DeleteObject(bPane);
	DeleteObject(bOld);
}
