/*

  This is a part of the LiteStep Shell Source code.

  Copyright (C) 1997-98 The LiteStep Development Team

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/****************************************************************************
 19/09/98 - C. Boyda
                Fixed it so shortcuts can now overlay each other, and not
                overdraw each other, problem is ppl have to put the one
                they want to overlay the one in the background before it in
                step.rc unless we reverse the config file read for them.

 09/09/98 - C. Boyda
                Added transparent regions, removing double buffer bitmaps and
                fixed regions so overlapping shortcuts will work now.

 11/08/98 - D. Hodgkiss
                Added drag & drop support.  The filename is appeneded to the
                command line found in step.rc and then run

 01/08/98 - D. Hodgkiss
                Added ShortcutMouseOverSound and ShortcutClickSound commands

 31/07/98 - D. Hodgkiss
                This file contains the source for desktop shortcuts

****************************************************************************/

#include <windows.h>
#include <mmsystem.h>
#include <time.h>
#include <stdio.h>
#include <malloc.h>
#include <commctrl.h>
#include <dbt.h>

#include "shortcut.h"
#include "lsapi.h"

// -------------------------------------------------------------------------------------------------------

const char szAppName[] = "ShortcutClass"; // Our window class, etc

// our window procedures
LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);

// -------------------------------------------------------------------------------------------------------

void ReadConfig(void);

int GetShortcutByWnd(HWND hwnd);
BOOL CreateShortcut(int i);

char szLitestepPath[256];
char szImagePath[256];
HINSTANCE dll;
HWND parent;
HWND desktop = NULL;
HWND refToplevel;
int cnt = 0;
BOOL windowsHidden = TRUE;
int ScreenWidth = 1152, ScreenHeight = 864;
int numShortcuts = 0;
shortcutType *shortcuts = NULL;
char szMouseOverSound[256], szClickSound[256];

// -------------------------------------------------------------------------------------------------------
int initModule(HWND ParentWnd, HINSTANCE dllInst, wharfDataType* wd)
{
	return initModuleEx (ParentWnd, dllInst, wd->lsPath);
}

int initModuleEx(HWND ParentWnd, HINSTANCE dllInst, LPCSTR szPath)
{
	RECT r;
	
	dll = dllInst;
	parent = ParentWnd;
	
	strcpy(szLitestepPath, szPath);
	ReadConfig();
	
	GetClientRect(GetDesktopWindow(),&r);
	ScreenWidth = r.right;
	ScreenHeight = r.bottom;
	
	desktop = FindWindow("DesktopBackgroundClass", NULL);
	if (!desktop)
	{
/*		MessageBox(ParentWnd, "Unable to find desktop", "Shortcuts", 0);
		return 1; */
		desktop = GetDesktopWindow();
	}
	
	{	// Register our window class
		WNDCLASS wc;
		
		memset(&wc,0,sizeof(wc));
		wc.lpfnWndProc = WndProc;				  // our window procedure
		wc.hInstance = dllInst; 				// hInstance of DLL
		wc.lpszClassName = szAppName;			   // our window class name
		wc.style = CS_DBLCLKS;
		
		if (!RegisterClass(&wc)) 
		{
			// Quick&dirty fix for nt
			MessageBox(parent,"Error registering window class","Shell_TickerClass",MB_OK);
			return 1;
		}
	}
	
	{
		FILE *f;
		
		f = LCOpen(NULL);
		if (f)
		{
			char	buffer[4096];
			char	token1[4096], token2[4096], token3[4096], token4[4096], token5[4096], token6[4096], token7[4096], token8[4096], extra_text[4096];
			char*	tokens[8];

			tokens[0] = token1;
			tokens[1] = token2;
			tokens[2] = token3;
			tokens[3] = token4;
			tokens[4] = token5;
			tokens[5] = token6;
			tokens[6] = token7;
			tokens[7] = token8;

			buffer[0] = 0;

			while (LCReadNextConfig (f, "*Shortcut", buffer, sizeof (buffer)))
			{
				int count;

				token1[0] = token2[0] = token3[0] = token4[0] = token5[0] = token6[0] = token7[0] = token8[0] = extra_text[0] = '\0';

				count = LCTokenize (buffer, tokens, 8, extra_text);

				switch(count)
				{
				case 8:
					{
						BITMAP bmInfo;

						if (!shortcuts)
							shortcuts = (shortcutType *)malloc(sizeof(shortcutType));
						else
							shortcuts = realloc(shortcuts, (numShortcuts+1)*sizeof(shortcutType));

						strcpy(shortcuts[numShortcuts].szName, token2);
						shortcuts[numShortcuts].x = atoi(token3);
						shortcuts[numShortcuts].y = atoi(token4);
						if (shortcuts[numShortcuts].x < 0) shortcuts[numShortcuts].x += ScreenWidth;
						if (shortcuts[numShortcuts].y < 0) shortcuts[numShortcuts].y += ScreenHeight;
						shortcuts[numShortcuts].bmpOff = LoadLSImage(token5, NULL);
						shortcuts[numShortcuts].bmpOn = LoadLSImage(token6, NULL);
						shortcuts[numShortcuts].bmpClick = LoadLSImage(token7, NULL);
						strcpy(shortcuts[numShortcuts].szCommand, token8);
						strcpy(shortcuts[numShortcuts].szParameters, extra_text);

						if (shortcuts[numShortcuts].bmpOff)
						{
							int res = GetObject(shortcuts[numShortcuts].bmpOff, sizeof(bmInfo), &bmInfo);
							if (res > 0)
							{
								shortcuts[numShortcuts].offSize.cx = bmInfo.bmWidth;
								shortcuts[numShortcuts].offSize.cy = bmInfo.bmHeight;
							} else {
								shortcuts[numShortcuts].offSize.cx = 64;
								shortcuts[numShortcuts].offSize.cy = 64;
							}
						}
						if (shortcuts[numShortcuts].bmpOn)
						{
							int res = GetObject(shortcuts[numShortcuts].bmpOn, sizeof(bmInfo), &bmInfo);
							if (res > 0)
							{
								shortcuts[numShortcuts].onSize.cx = bmInfo.bmWidth;
								shortcuts[numShortcuts].onSize.cy = bmInfo.bmHeight;
							} else {
								shortcuts[numShortcuts].onSize.cx = 64;
								shortcuts[numShortcuts].onSize.cy = 64;
							}
						}
						if (shortcuts[numShortcuts].bmpClick)
						{
							int res = GetObject(shortcuts[numShortcuts].bmpClick, sizeof(bmInfo), &bmInfo);
							if (res > 0)
							{
								shortcuts[numShortcuts].clickSize.cx = bmInfo.bmWidth;
								shortcuts[numShortcuts].clickSize.cy = bmInfo.bmHeight;
							} else {
								shortcuts[numShortcuts].clickSize.cx = 64;
								shortcuts[numShortcuts].clickSize.cy = 64;
							}
						}

						shortcuts[numShortcuts].uTimer = 0;

						CreateShortcut(numShortcuts);
						numShortcuts++;
					}
					break;
				}
			}
			LCClose(f);
		}
	}
		
	return 0;
}

// -------------------------------------------------------------------------------------------------------

LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
	case WM_MOUSEMOVE:
		{
			int i = GetShortcutByWnd(hwnd);
			
			if (i == -1) return 0;
			if (!strcmpi(shortcuts[i].szCommand, ".none")) return 0;
			if (!shortcuts[i].state)
			{
				if (szMouseOverSound && szMouseOverSound[0])
				{
					sndPlaySound(NULL, 0);
					sndPlaySound(szMouseOverSound, SND_ASYNC|SND_NODEFAULT);
				}
				if (shortcuts[i].bmpOn)
				{
					RECT r;
					HRGN h;

					h = CreateRectRgn(0, 0, 0, 0);
					
					CombineRgn(h, shortcuts[i].transOnRgn, NULL, RGN_COPY);
					SetWindowRgn(shortcuts[i].hwnd, h, TRUE);

					shortcuts[i].state = 1;
					GetClientRect(hwnd, &r);
					InvalidateRect(hwnd, &r, TRUE);

					if (!shortcuts[i].uTimer)
					{
						shortcuts[i].uTimer = i;
						SetTimer (shortcuts[i].hwnd, i, 5, NULL);
					}
				}
			}
		}
		return 0;
		
	case WM_ENDSESSION:
	case WM_QUERYENDSESSION:
		return SendMessage(parent,message,wParam,lParam);
	case WM_CREATE:
		return 0;
	case WM_ERASEBKGND: return 1;
		
	case WM_TIMER:
		{
			int i = GetShortcutByWnd(hwnd);
		
			if (i == -1) return 0;
			if (!strcmpi(shortcuts[i].szCommand, ".none")) return 0;
			if (shortcuts[i].state)
			{
				POINT pos;
				RECT r;
				HRGN h = CreateRectRgn(0, 0, 0, 0);
				
				GetCursorPos(&pos);
				GetWindowRgn(hwnd, h);
				/* let's not do this if it's in state 3 (clicked), this way mouse over sounds won't play twice
				and we can actually view the clicked image till we move the mouse off - C. Boyda */
				if ((!PtInRegion(h, pos.x-shortcuts[i].x, pos.y-shortcuts[i].y))/* || (shortcuts[i].state == 3)*/)
				{
					if (shortcuts[i].bmpOff)
					{
						CombineRgn(h, shortcuts[i].transOffRgn, NULL, RGN_COPY);
						SetWindowRgn(shortcuts[i].hwnd, h, TRUE);
					}

					shortcuts[i].state = 0;
					GetClientRect(hwnd, &r);
					InvalidateRect(hwnd, &r, TRUE);

					if (shortcuts[i].uTimer)
					{
						KillTimer (shortcuts[i].hwnd, i);
						shortcuts[i].uTimer = 0;
					}
				}
				else
					DeleteObject(h);
			}
		}
		return 0;
		
	case WM_PAINT:
		{
			PAINTSTRUCT ps;
			int i = GetShortcutByWnd(hwnd);
			HDC hdc = BeginPaint(hwnd,&ps);
			HDC src = CreateCompatibleDC(NULL);
			
			if (i != -1)
			{
				if (shortcuts[i].state == 0 && shortcuts[i].bmpOff)
				{
					SelectObject(src, shortcuts[i].bmpOff);
					BitBlt(hdc, 0, 0, shortcuts[i].offSize.cx, shortcuts[i].offSize.cy, src, 0, 0, SRCCOPY);
				}
				if (shortcuts[i].state == 1 && shortcuts[i].bmpOn)
				{
					SelectObject(src, shortcuts[i].bmpOn);
					BitBlt(hdc, 0, 0, shortcuts[i].onSize.cx, shortcuts[i].onSize.cy, src, 0, 0, SRCCOPY);
				}
				if (shortcuts[i].state == 3 && shortcuts[i].bmpClick)
				{
					SelectObject(src, shortcuts[i].bmpClick);
					BitBlt(hdc, 0, 0, shortcuts[i].clickSize.cx, shortcuts[i].clickSize.cy, src, 0, 0, SRCCOPY);
				}
			}
			EndPaint(hwnd,&ps);
			DeleteDC(src);
		}
		return 0;
		
		
	case WM_LBUTTONUP:
		{
			int i = GetShortcutByWnd(hwnd);
			
			if (i == -1) return 0;
			if (shortcuts[i].szCommand[0] == '!')
			{
				ParseBangCommand(hwnd, shortcuts[i].szCommand, shortcuts[i].szParameters);
				return 0;
			}
			if (!strcmpi(shortcuts[i].szCommand, ".none")) return 0;
			{
				RECT r;
				SHELLEXECUTEINFO si;
				
				if (shortcuts[i].bmpClick)
				{
					HRGN h;

					h = CreateRectRgn(0, 0, 0, 0);
					
					CombineRgn(h, shortcuts[i].transClickRgn, NULL, RGN_COPY);
					SetWindowRgn(shortcuts[i].hwnd, h, TRUE);
				}
				
				shortcuts[i].state = 3;
				GetClientRect(hwnd, &r);
				InvalidateRect(hwnd, &r, TRUE);
				
				if (!shortcuts[i].uTimer)
				{
					shortcuts[i].uTimer =  i;
					SetTimer (shortcuts[i].hwnd, i, 5, NULL);
				}

				if (szClickSound && szClickSound[0])
				{
					sndPlaySound(NULL, 0);
					sndPlaySound(szClickSound, SND_ASYNC|SND_NODEFAULT);
				}

				if (shortcuts[i].szCommand[0] == '!')
				{
					ParseBangCommand(shortcuts[i].hwnd, shortcuts[i].szCommand, shortcuts[i].szParameters);
				} else {
					memset(&si, 0, sizeof(si));
					si.cbSize = sizeof(SHELLEXECUTEINFO);
					si.lpDirectory = NULL;
					si.lpVerb = NULL;
					si.nShow = 1;
					si.fMask = SEE_MASK_DOENVSUBST;
					si.lpFile = shortcuts[i].szCommand;
					si.lpParameters = shortcuts[i].szParameters;
					ShellExecuteEx(&si);
				}
			}
		}
		return 0;
	
	case WM_WINDOWPOSCHANGING:
		{
			WINDOWPOS *lpwp = (WINDOWPOS*)lParam;
			lpwp->flags |= SWP_NOZORDER;
		}
		return 0;
		
	case WM_MOUSEACTIVATE:
		PostMessage(parent, 9185, 0, 0); // Tells litestep it has been selected
		SendMessage(parent, 9183, (int)HIWORD(lParam), (int)LOWORD(lParam)); // Close any popup open
		return MA_ACTIVATE;
	case WM_ACTIVATE:
		SendMessage(parent, 9185, 0, 0); // Tells litestep it has been selected
		if (LOWORD(wParam)) SetActiveWindow(parent);
		return 0;
	case WM_RBUTTONUP: // Open popup menu
		SendMessage(parent, 9182, (int)HIWORD(lParam), (int)LOWORD(lParam));
		return 0;
	case WM_LBUTTONDOWN:
	case WM_RBUTTONDOWN: // Close popup menu
	case WM_MBUTTONDOWN:
		SendMessage(parent, 9183, (int)HIWORD(lParam), (int)LOWORD(lParam));
		return 0;
	case WM_KEYDOWN: 
	case WM_KEYUP:
		{	
			PostMessage(parent,message,wParam,lParam);
		}
		return 0;
		
	case WM_SYSCOMMAND:
		{
			switch (wParam)
			{
			case SC_CLOSE:
				PostMessage(parent,WM_KEYDOWN,8889,0);
				return 0;
			default:
				break;
			}
		}
		break;;
		
	case WM_DROPFILES:
		{
			int numDropped, i;
			int numShort = GetShortcutByWnd(hwnd);
			char szFname[256], szArgs[256];
			SHELLEXECUTEINFO si;
			
			if (numShort == -1)
				return 0;
			numDropped = DragQueryFile((HDROP) wParam, 0xFFFFFFFF, NULL, 0);
			for (i = 0; i < numDropped; i++)
			{
				DragQueryFile((HDROP) wParam, i, (char *)&szFname, sizeof(szFname));
				if (szFname && szFname[0])
				{
					memset(&si, 0, sizeof(si));
					si.cbSize = sizeof(SHELLEXECUTEINFO);
					si.lpDirectory = NULL;
					si.lpVerb = NULL;
					si.nShow = 1;
					si.fMask = SEE_MASK_DOENVSUBST;
					si.lpFile = shortcuts[numShort].szCommand;
					strcpy(szArgs, shortcuts[numShort].szParameters);
					strcat(szArgs, " ");
					strcat(szArgs, szFname);
					si.lpParameters = szArgs;
					ShellExecuteEx(&si);
				}
			}
			DragFinish((HDROP) wParam);
		}
		return 0;
	}
	
	return DefWindowProc(hwnd,message,wParam,lParam);
}

int GetShortcutByWnd(HWND hwnd)
{
	int i;
	
	for (i=0;i<numShortcuts;i++)
		if (shortcuts[i].hwnd == hwnd)
			return i;
		return -1;
}

// -------------------------------------------------------------------------------------------------------
BOOL CreateShortcut(int i)
{
	HWND hWnd = NULL;
	RECT r;
	HRGN h;

	h = CreateRectRgn(0, 0, 0, 0);
	
	hWnd = CreateWindowEx(
		WS_EX_TOOLWINDOW,					// exstyles 
		szAppName,							// our window class name
		"",									// use description for a window title
		WS_CHILD|WS_CLIPSIBLINGS,
		0, 0,								// position 
		shortcuts[i].offSize.cx, shortcuts[i].offSize.cy,
		desktop,							// parent window
		NULL,								// no menu
		dll,								// hInstance of DLL
		NULL);								// no window creation data
	
	if (!hWnd) 
	{						   
		MessageBox(parent,"Error creating window","Shortcuts",MB_OK);
		return FALSE;
	}
	
	shortcuts[i].hwnd = hWnd;
	
	shortcuts[i].transOnRgn = BitmapToRegion(shortcuts[i].bmpOn, RGB(255,0,255), 0x101010, 0, 0);
	shortcuts[i].transOffRgn = BitmapToRegion(shortcuts[i].bmpOff, RGB(255,0,255), 0x101010, 0, 0);
	shortcuts[i].transClickRgn = BitmapToRegion(shortcuts[i].bmpClick, RGB(255,0,255), 0x101010, 0, 0);

	if (shortcuts[i].bmpOff)
	{
		CombineRgn(h, shortcuts[i].transOffRgn, NULL, RGN_COPY);
		SetWindowRgn(shortcuts[i].hwnd, h, FALSE);
	} else
	if (shortcuts[i].bmpOn)
	{
		CombineRgn(h, shortcuts[i].transOnRgn, NULL, RGN_COPY);
		SetWindowRgn(shortcuts[i].hwnd, h, FALSE);
	} else
	if (shortcuts[i].bmpClick)
	{
		CombineRgn(h, shortcuts[i].transClickRgn, NULL, RGN_COPY);
		SetWindowRgn(shortcuts[i].hwnd, h, FALSE);
	} else
		DeleteObject(h);

	SetWindowLong(shortcuts[i].hwnd, GWL_USERDATA, magicDWord);
	SetWindowPos(shortcuts[i].hwnd, 0, shortcuts[i].x, shortcuts[i].y, 0, 0, SWP_NOZORDER|SWP_NOSIZE);
	DragAcceptFiles(shortcuts[i].hwnd, TRUE);
	shortcuts[i].state = 0;
//	SetTimer(shortcuts[i].hwnd, i, 1, NULL);
	ShowWindow(shortcuts[i].hwnd, SW_SHOWNORMAL);
	GetClientRect (shortcuts[i].hwnd, &r);
	InvalidateRect(shortcuts[i].hwnd, &r, TRUE);
	
	return TRUE;
}

// -------------------------------------------------------------------------------------------------------
// cleanup (opposite of init()). Destroys the window, unregisters the window class
void quitModule(HINSTANCE dllInst)
{
	int i;
	
	if (shortcuts)
	{
		for (i = 0; i < numShortcuts; i++)
		{
			DragAcceptFiles(shortcuts[i].hwnd, FALSE);
			if (shortcuts[i].uTimer)
			{
				KillTimer (shortcuts[i].hwnd, i);
				shortcuts[i].uTimer = 0;
			}
			if (shortcuts[i].hwnd)
				DestroyWindow(shortcuts[i].hwnd);
			if (shortcuts[i].bmpOff)
				DeleteObject(shortcuts[i].bmpOff);
			if (shortcuts[i].bmpOn)
				DeleteObject(shortcuts[i].bmpOn);
			if (shortcuts[i].bmpClick)
				DeleteObject(shortcuts[i].bmpClick);
			if (shortcuts[i].transOnRgn)
				DeleteObject(shortcuts[i].transOnRgn);
			if (shortcuts[i].transOffRgn)
				DeleteObject(shortcuts[i].transOffRgn);
			if (shortcuts[i].transClickRgn)
				DeleteObject(shortcuts[i].transClickRgn);
		}
		free(shortcuts);
	}
	
	UnregisterClass(szAppName,dllInst); // unregister window class
}


BOOL CALLBACK EnumWindowsProc(HWND hwnd, LPARAM lParam)
{
	if (!refToplevel && !(GetWindowLong(hwnd, GWL_EXSTYLE) & WS_EX_TOPMOST))
	{
		refToplevel = hwnd;
		return FALSE; // !refTopmost;
	}
	return TRUE;
}

void ReadConfig (void)
{
	GetRCString("PixmapPath", szImagePath, "c:\\litestep\\images\\", 256);
	GetRCString("ShortcutMouseOverSound", szMouseOverSound, "", 256);
	GetRCString("ShortcutClickSound", szClickSound, "", 256);
}
