/*

  This is a part of the LiteStep Shell Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/****************************************************************************
 15/10/98 - B. Kilian
			Added the warning for Litestep running under Explorer and the
			neutering necessary if someone decides that's what they want to do.

 11/10/98 - W. Konkel
			Added support for NT All Users\Program Files\Startup
			Changed the way it executes so it gets window state correctly.

 07/20/98 - MholmesIV
			Screwing around with stuff.

 07/20/98 - Azerov
			Everything else.
 
****************************************************************************/
#include <windows.h>
#include <shlobj.h>
#include <tchar.h>
#include <stdio.h>
#include <io.h>

#include "litestep.h"
#include "lsapi.h"
#include "wharfdata.h"
//#include "../desktop/desktop.h"

TCHAR			szAppPath[256], szRcPath[256];
const LPCTSTR	szMainWindowClass = _T("TApplication");
const LPCTSTR	szMainWindowTitle = _T("LiteStep");
HWND			hMainWindow = NULL;
HINSTANCE		hDLLInstance;

ModuleData		*gModules = NULL;
BOOL			UnderExplorer = FALSE;
int 			gNumModules = 0;
BOOL			gRecycle = FALSE;
BOOL			gNoSplashScreen = FALSE;
BOOL			ShowWarning = TRUE;

BOOL			gEndSession = FALSE;
BOOL			skipEvents = FALSE;
BOOL			gNoAltTab = FALSE;
//BOOL			gNoTaskBar;
static HWND 	desktopWnd = NULL;
static HWND		systrayWnd = NULL;
static trayType *trayData = NULL;

// -- MHolmesIV --
// Windowlist Datatype
static windowType winList[MAXWIN];

// mini IPC stuff, only what litestep.exe used to have to deal with.

static UINT Messages[MSGNUM];
static msgWinType MSGCallbacks[MSGNUM*10];  

BOOL HandlerExists(UINT uMsg);
// sends a message to everyone who has requested it.
HRESULT passOnMessage(UINT Msg, WPARAM wParam, LPARAM lParam, BOOL wait);
// Adds a list of messages to the handler.
void addMessages(HWND hwnd, UINT* Msg);
// Adds a single message to the handler.
void addWndMessage(HWND hwnd, UINT Message);
// Removes a list of messages from the handler.
void removeMessages(HWND hwnd, UINT* Msg);
// Removes a single message from the handler.
void removeWndMessage(HWND hwnd, UINT Message);
void clearMessages();



static LRESULT CALLBACK MainWndProc (HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

// Functions for loading / unloading modules.
static void LoadModules (void);
static void QuitModules (void);
static void AddModule (LPCSTR path);

// Functions for handling startup items.  TODO: Things in the startup folder.
static void RunStartupStuff (void);
static void RunEntriesIn (HKEY key, LPCTSTR path);
static void DeleteEntriesIn (HKEY key, LPCTSTR path);

static void RunStartupMenu (void);
static void ShutDown(void);

// Use this for setting up data structures.

static void initData (void);
static void ReadConfig (void);

void execute(char *prog, char *param, char *dir);

int WINAPI WinMain
(
	HINSTANCE	hInstance,
	HINSTANCE	hPrevInstance,
	LPSTR		lpCmdLine,
	int 		nCmdShow
	)
{
	ATOM		aClass;
	WNDCLASS	wc;
	char			*ptr;
	
	hDLLInstance = hInstance;
	
	szAppPath[0] = 0;

	if (GetModuleFileName (hDLLInstance, szAppPath, sizeof (szAppPath)) > 0)
	{
		int len = lstrlen (szAppPath);
		while (len && szAppPath[len-1] != _T('\\'))
		{
			szAppPath[--len] = _T('\0');
		}
		
		if (len)
		{
			szAppPath[--len] = _T('\0');
		}
	}
	

	ptr = lpCmdLine;
	if (*ptr != '\0')
	{
		BOOL isFullPath = FALSE;
		int i;

		for (i = 0; i < lstrlen(ptr); i++)
			if (ptr[i] == '\\')
				isFullPath = TRUE;

		if (!isFullPath)
			wsprintf(szRcPath, "%s\\%s", szAppPath, ptr);
		else
			wsprintf(szRcPath, ptr);
	} else
			wsprintf(szRcPath, "%s\\STEP.RC", szAppPath);
		

	
	if (SetupRC(szRcPath))
	{
		ShowWarning = GetRCBool("ExplorerNoWarn", FALSE);
		gNoAltTab = GetRCBool("HideApplication", TRUE);
		CloseRC();
	}

	if (FindWindow("Shell_TrayWnd", NULL))
	{
		// User is running under Exploder

		if (ShowWarning)
		{
			if (MessageBox(0, "You are currently running another shell, while Litestep b24 allows you\012to run under Explorer, we don't advise it for inexperienced users, and we\012will not support it, so do so at your own risk.\012\012 If you continue, some of the advanced features of Litestep will be disabled\012 such as the desktop. The wharf, hotkeys, and shortcuts will still work.\012\012 To get rid of this message next time, put ExplorerNoWarn in your step.rc\012\012 Continue?", "WARNING", MB_YESNO|MB_ICONEXCLAMATION) == IDNO)
			{
				exit(0);
			}
		}
		UnderExplorer = TRUE;
	}

	memset (&wc, 0, sizeof (wc));
	
	wc.lpfnWndProc = MainWndProc;
	wc.hInstance = hDLLInstance;
	wc.lpszClassName = szMainWindowClass;
	
	aClass = RegisterClass
		(
		&wc
		);
	
	if (aClass)
	{
		hMainWindow = CreateWindowEx
			(
			gNoAltTab ? WS_EX_TOOLWINDOW : 0,
			szMainWindowClass,
			szMainWindowTitle,
			0,
			0, 0,
			0, 0,
			NULL,
			NULL,
			hDLLInstance,
			NULL
			);
		
		if (hMainWindow)
		{
			BOOL bStartupStuffDone = FALSE;
			MSG message;
			
			SetWindowLong (hMainWindow, GWL_USERDATA, magicDWord); 
			
			initData ();

			do
			{

				ReadConfig ();
				
				if (gNoAltTab)
					SetWindowLong(hMainWindow, GWL_EXSTYLE, GetWindowLong(hMainWindow, GWL_EXSTYLE) | WS_EX_TOOLWINDOW);
				else
					SetWindowLong(hMainWindow, GWL_EXSTYLE, GetWindowLong(hMainWindow, GWL_EXSTYLE) & ~WS_EX_TOOLWINDOW);

//				SystemParametersInfo(SPI_SETWORKAREA, 1, NULL, SPIF_SENDCHANGE);
				LoadModules ();
				
				
				if (gRecycle && HandlerExists(9211) && trayData)
				{
					SendMessage(hMainWindow, 9211, 0, (LONG)trayData);
					if (trayData)
						free(trayData);
				}
				
				gRecycle = FALSE;
				
				if (!bStartupStuffDone)
				{
					// Don't run startup items if the SHIFT key is down
					SHORT keyState;
					keyState = GetKeyState (VK_SHIFT);
					
					if (!(keyState & 0x8000))
					{
						bStartupStuffDone = TRUE;
						RunStartupStuff ();
					}
				}

				// Undocumented call to tell windows we finished loading up the shell.
				SendMessage(GetDesktopWindow(), 0x400, 0, 0);
				
				while (GetMessage (&message, 0, 0, 0))
				{
					TranslateMessage(&message);
					DispatchMessage (&message);
					
					if (gRecycle || gEndSession)
					{
						break;
					}
				}
				
//				if (gRecycle)
//				{
//					if (MessageBox (0, "Would you like to recycle?", "Recycle or Exit", MB_YESNO | MB_TOPMOST) != IDYES)
//					{
//						gRecycle = FALSE;
//					}
//				}
				
				
				if (gRecycle && HandlerExists(9210))
				{
					trayData = (trayType *)calloc(50, sizeof(trayType));
					SendMessage(hMainWindow, 9210, 0, (LONG)trayData);
				}
				
				QuitModules ();
				clearMessages();
				CloseRC();
			} while (gRecycle && !gEndSession);
			

			if (!skipEvents)
			{
//				SetTimer(hMainWindow, 1, 1000, NULL);

				while (GetMessage (&message, 0, 0, 0))
				{
					TranslateMessage(&message);
					DispatchMessage (&message);
				}
			}

			DestroyWindow(hMainWindow);
//			SendMessage(hMainWindow, WM_QUIT, 0, 0);
			hMainWindow = NULL;
		}
		
		UnregisterClass (szMainWindowClass, hDLLInstance);
	}

	return 0;
}

LRESULT CALLBACK MainWndProc (HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
	case WM_KEYDOWN:
		{
//			MessageBox(0, "Got here", "Got Here", MB_OK|MB_TOPMOST);
			if (wParam == 8889) 
			{
				ParseBangCommand(hwnd, "!ShutDown", NULL);
			}
			return 0;
		}

	case WM_SYSCOMMAND:
		{
		switch (wParam)
			{
			case SC_CLOSE:
				ParseBangCommand(hwnd, "!ShutDown", NULL);
				return 0;
			default:
				return DefWindowProc(hwnd,uMsg,wParam,lParam);
			}
		}

	case WM_QUERYENDSESSION:
		{
//			MessageBox (0, "Windows is shutting down!", "Hey!", MB_OK);
			return TRUE;
			break;
		}
	case WM_ENDSESSION:
		{
			gEndSession = TRUE;
			break;
		}
	case 9263: // This is our "RegisterMessage" message.
		{
		  //MessageBox (hMainWindow, "Got SetThingieMessage", "", MB_OK);
			addMessages((HWND)wParam, (UINT*)lParam);
			break;
		}
	case 9264: // This is our "UnregisterMessage" message
		{
			removeMessages((HWND)wParam, (UINT*)lParam);
			break;
		}
	case 9400:
		{
			switch (wParam)
			{
			case 0:
				return (LRESULT) &winList[0];
				break;
			case 1:
				return (LRESULT) MAXWIN;
				break;
			}
		}
/*    case 9210: // Sent when the desktop needs to redraw
	case 9211: // This is the focus message. It gets sent by desktop.c
	case 9182: // Open Popup Menu, Sent by a bunch of DLL's
	case 9183: // Close Popup Menu, Sent by a bunch of DLL's
	case 9300: // Wharf shade/unshade
	case 9301: // wharf move
		{
			return passOnMessage(uMsg, wParam, lParam, TRUE);
			break;
                }*/
	case 9260: /* Recycle */
		{
			if (wParam == 0)
			{
				gRecycle = TRUE;
			}
			else if (wParam == 1)
			{
				ExitWindowsEx (EWX_LOGOFF, 0);
				gEndSession = TRUE;
			}
			else if (wParam == 2)
			{
				gEndSession = TRUE;
				skipEvents = TRUE;
			}
			else
			{
				ShutDown();
			}

			break;
		}

	default:
                if (HandlerExists(uMsg))
                        return passOnMessage(uMsg, wParam, lParam, TRUE);
                else
                        return DefWindowProc (hwnd, uMsg, wParam, lParam);
	}

	return 0;
}

void ShutDown(void)
{
    FARPROC (__stdcall *MSWinShutdown)(HWND) = NULL;

    MSWinShutdown = (FARPROC (__stdcall *)(HWND))GetProcAddress(GetModuleHandle("SHELL32.DLL"), (char*)((long)0x3C));
    MSWinShutdown(hMainWindow);
    return;
}

void LoadModules (void)
{
	char buffer[4096], path[256];
	FILE *f;
	sprintf (path, "%s\\step.rc", szAppPath);
	f = LCOpen (path);

	if (f)
	{
		while (LCReadNextCommand (f, buffer, sizeof (buffer)))
		{
			char *lpszBuffers[2];
			char token1[4096];
			char token2[4096];

			lpszBuffers[0] = token1;
			lpszBuffers[1] = token2;

//			token1[0] = token2[0] = '\0';
			if (LCTokenize (buffer, lpszBuffers, 2, NULL) == 2)
			{
				if (!stricmp (token1, "LoadModule"))
				{
					BOOL Add = TRUE;

					if (UnderExplorer)
					{
						if (match("*desktop*", token2)/* || match("*shortcut*", token2)*/)
						{ Add = FALSE;}
					}

					if (Add)
					{
						AddModule (token2);
						DoEvents(hMainWindow, 5);
					}
				}
			}
		}
		LCClose (f);
	}
}

void AddModule (LPCSTR modulePath)
{
	wharfDataType wharfData;
	ModuleData data;

	memset (&wharfData, 0, sizeof (wharfData));
	wharfData.trayIconSize = 16;
	wharfData.taskBarFore = 0;
	wharfData.taskBarBack = 0x7f7f7f;
	wharfData.taskBarText = 0xffffff;
	wharfData.showBeta = 1;
	wharfData.usClock = 1;
	wharfData.vwmVelocity = 300;
	wharfData.VWMDistance = 5;
	wharfData.VWMNoAuto = 1;
	wharfData.pixmapDir = NULL;//szImagePath;
	wharfData.defaultBmp = NULL;//szDefaultBitmap;
	wharfData.vwmBackColor = 0;
	wharfData.vwmSelBackColor = 0x3f3f3f;
	wharfData.vwmForeColor = 0x906090;
	wharfData.vwmBorderColor = 0xffffff;
	wharfData.taskBarFore2 = 0x3f3f3f3f;
	wharfData.taskBar = 0;//!gNoTaskBar;
	wharfData.lsPath = szAppPath;
	wharfData.winList = &winList[0];
	wharfData.winListSize = MAXWIN;

	memset (&data, 0, sizeof (data));

	strcpy (data.szName, modulePath);

	data.hInstance = LoadLibrary (data.szName);

	if (data.hInstance)
	{
//	    MessageBox (hMainWindow, modulePath, "Litestep", MB_OK);
		data.pInit = (ModuleInitFunc) GetProcAddress (data.hInstance, "initModule");
// We only want to load non-wharf modules.
		
//		data.pWharfInit = (ModuleInitFunc) GetProcAddress (data.hInstance, "initWharfModule");
		data.pNewInit = (NewModuleInitFunc) GetProcAddress (data.hInstance, "initModuleEx");
//		if (!data.pNewInit)
//		{
//			data.pNewInit = (NewModuleInitFunc) GetProcAddress (data.hInstance, "initWharfModuleEx");
//		}
//		data.pNewInit = (NewModuleInitFunc) GetProcAddress (data.hInstance, "initModule");
		data.pQuit = (ModuleQuitFunc) GetProcAddress (data.hInstance, "quitModule");
//		data.pWharfQuit = (ModuleQuitFunc) GetProcAddress (data.hInstance, "quitWharfModule");
		if (data.pInit || data.pNewInit /*|| data.pWharfInit*/)
		{
			int res;

			if (data.pNewInit)
			{
				res = data.pNewInit (hMainWindow, hDLLInstance, szAppPath);
			}
			else if (data.pInit)
			{
				res = data.pInit (hMainWindow, hDLLInstance, &wharfData);
			}
//			else if (data.pWharfInit)
//			{
//				res = data.pWharfInit (hMainWindow, hDLLInstance, &wharfData);
//			}
		}
		else	// Assume module is self-initializing
		{
		}
		if (!gModules)
		{
			gModules = malloc (sizeof (ModuleData));
		}
		else
		{
			gModules = realloc (gModules, (gNumModules + 1) * sizeof (ModuleData));
		}

		memcpy (gModules + gNumModules, &data, sizeof (data));

		gNumModules++;
	}
}

void QuitModules (void)
{
	while (gNumModules > 0)
	{
		if (gModules[gNumModules-1].pQuit)
		{
			gModules[gNumModules-1].pQuit (hDLLInstance);
		}
//		else if (gModules[gNumModules-1].pWharfQuit)
//		{
//			gModules[gNumModules-1].pWharfQuit (hDLLInstance);
//		}

		FreeLibrary (gModules[gNumModules-1].hInstance);
//		DoEvents(3);

		gNumModules--;
	}

	if (gModules)
	{
		free (gModules);

		gModules = NULL;
	}
}

void RunStartupStuff (void)
{
	const LPCTSTR szRunPath = _T("Software\\Microsoft\\Windows\\CurrentVersion\\Run");
	const LPCTSTR szRunOncePath = _T("Software\\Microsoft\\Windows\\CurrentVersion\\RunOnce");
//	const LPCTSTR szRunServicesPath = _T("Software\\Microsoft\\Windows\\CurrentVersion\\RunServices");
//	const LPCTSTR szRunServicesOncePath = _T("Software\\Microsoft\\Windows\\CurrentVersion\\RunServicesOnce");

	// First, once-only services, usually installer stuff
	// Disabling the services, as apparently these things are started before the shell
	/*
	RunEntriesIn (HKEY_LOCAL_MACHINE, szRunServicesOncePath);
	DeleteEntriesIn (HKEY_LOCAL_MACHINE, szRunServicesOncePath);
	RunEntriesIn (HKEY_CURRENT_USER, szRunServicesOncePath);
	DeleteEntriesIn (HKEY_CURRENT_USER, szRunServicesOncePath);

	// Next, permanent services
	RunEntriesIn (HKEY_LOCAL_MACHINE, szRunServicesPath);
	RunEntriesIn (HKEY_CURRENT_USER, szRunServicesPath);
	*/

	// Next, once-only regular applications
	if (!UnderExplorer)
	{
		RunEntriesIn (HKEY_LOCAL_MACHINE, szRunOncePath);
		DeleteEntriesIn (HKEY_LOCAL_MACHINE, szRunOncePath);
		RunEntriesIn (HKEY_CURRENT_USER, szRunOncePath);
		DeleteEntriesIn (HKEY_CURRENT_USER, szRunOncePath);

		// Almost done, now run permanent regular applications
		RunEntriesIn (HKEY_LOCAL_MACHINE, szRunPath);
		RunEntriesIn (HKEY_CURRENT_USER, szRunPath);

		// And now, run the things in the startup folder of the start menu.
		RunStartupMenu ();
	}
}

void RunEntriesIn (HKEY key, LPCTSTR path)
{
	HKEY	hKey = NULL;
	LONG	lResult;
	
	lResult = RegOpenKeyEx
		(
		key,
		path,
		0,
		KEY_READ,
		&hKey
		);

	if (lResult == ERROR_SUCCESS)
	{
		TCHAR szNameBuffer[1024], szValueBuffer[1024];
		DWORD dwLoop, dwNameSize, dwValueSize;

		for (dwLoop = 0; ; ++dwLoop)
		{
			dwNameSize = sizeof (szNameBuffer);
			dwValueSize = sizeof (szValueBuffer);

			lResult = RegEnumValue
				(
				hKey,
				dwLoop,
				szNameBuffer,
				&dwNameSize,
				NULL,
				NULL,
				(LPBYTE) szValueBuffer,
				&dwValueSize
				);

			if (lResult == ERROR_NO_MORE_ITEMS)
			{
				break;
			}

			if (lResult == ERROR_SUCCESS)
			{
				WinExec (szValueBuffer, SW_SHOW);
			}
		}

		RegCloseKey (hKey);
	}
}

void DeleteEntriesIn (HKEY key, LPCTSTR path)
{
	HKEY	hKey = NULL;
	LONG	lResult;
	
	lResult = RegOpenKeyEx
		(
		key,
		path,
		0,
		KEY_READ,
		&hKey
		);

	if (lResult == ERROR_SUCCESS)
	{
		TCHAR szNameBuffer[1024], szValueBuffer[1024];
		DWORD dwLoop, dwNameSize, dwValueSize;

		for (dwLoop = 0; ;)
		{
			dwNameSize = sizeof (szNameBuffer);
			dwValueSize = sizeof (szValueBuffer);

			lResult = RegEnumValue
				(
				hKey,
				dwLoop,
				szNameBuffer,
				&dwNameSize,
				NULL,
				NULL,
				(LPBYTE) szValueBuffer,
				&dwValueSize
				);

			if (lResult == ERROR_NO_MORE_ITEMS)
			{
				break;
			}

			if (lResult == ERROR_SUCCESS)
			{
				lResult = RegDeleteValue
					(
					hKey,
					szNameBuffer
					);

				if (lResult != ERROR_SUCCESS)
				{
					break;
				}
			}
		}

		RegCloseKey (hKey);
	}
}

void RunStartupMenu (void)
{
	char szDir[256];
	char szPath[256];

	struct _finddata_t finddata;
	long search_handle;
	LPITEMIDLIST item;

		SHGetSpecialFolderLocation
		(
		NULL,
		CSIDL_COMMON_STARTUP,
		&item
		);

	SHGetPathFromIDList(item, szPath);
	
	strcpy (szDir, szPath);
	if (szPath[strlen(szPath)-1] != '\\')
	{
		strcat(szPath, "\\");
	}
	strcat(szPath, "*.*");


	if (strcmp(szPath,"\\*.*")!=0) {
		search_handle = _findfirst(szPath, &finddata);
		while (search_handle != -1)
		{
			if (strcmp (finddata.name, ".") && strcmp (finddata.name, ".."))
			{
//				execute (finddata.name, 0, szDir);


				SHELLEXECUTEINFO si;
				memset(&si, 0, sizeof(si));
				si.cbSize = sizeof(SHELLEXECUTEINFO);
				si.lpDirectory = szDir;
				si.lpVerb = NULL;
				si.nShow = 1;
				si.fMask = SEE_MASK_DOENVSUBST;
				si.lpFile = finddata.name;
				si.lpParameters = NULL;
				ShellExecuteEx(&si);

			}

			if (_findnext(search_handle, &finddata) == -1)
			{
			  _findclose(search_handle);
			  search_handle = -1;
			}
		}
	}


	
	SHGetSpecialFolderLocation
		(
		NULL,
		CSIDL_STARTUP,
		&item
		);

	SHGetPathFromIDList(item, szPath);

	strcpy (szDir, szPath);
	if (szPath[strlen(szPath)-1] != '\\')
	{
		strcat(szPath, "\\");
	}
	strcat(szPath, "*.*");

	search_handle = _findfirst(szPath, &finddata);
	while (search_handle != -1)
	{
		if (strcmp (finddata.name, ".") && strcmp (finddata.name, ".."))
		{
//			execute (finddata.name, 0, szDir);
			SHELLEXECUTEINFO si;
			memset(&si, 0, sizeof(si));
			si.cbSize = sizeof(SHELLEXECUTEINFO);
			si.lpDirectory = szDir;
			si.lpVerb = NULL;
			si.nShow = 1;
			si.fMask = SEE_MASK_DOENVSUBST;
			si.lpFile = finddata.name;
			si.lpParameters = NULL;
			ShellExecuteEx(&si);
		}

		if (_findnext(search_handle, &finddata) == -1)
		{
	      _findclose(search_handle);
		  search_handle = -1;
		}
	}

}

void initData (void)
{
	int x = 0;
	for (x=0;x<MAXWIN;x++)
	{
		winList[x].Handle = NULL;
		winList[x].Visible = FALSE;
		winList[x].Desk = 0;
	}

}

void ReadConfig (void)
{
	gNoAltTab = FALSE;

	if (SetupRC(szRcPath))
	{
		gNoAltTab = GetRCBool("HideApplication", TRUE);
		gNoSplashScreen = GetRCBool("NoSplashScreen", TRUE);
	}
}

// ----------------------------------------------------------------------------
// Executes a program
// ----------------------------------------------------------------------------
void execute(char *prog, char *param, char *dir)
{
	SHELLEXECUTEINFO si;
	char d[261];
	char *dd;
	memset(&si, 0, sizeof(SHELLEXECUTEINFO));

	si.cbSize = sizeof(SHELLEXECUTEINFO);
	si.fMask = SEE_MASK_DOENVSUBST;
	si.hwnd = hMainWindow;
	si.lpVerb = NULL;
	si.lpFile = prog;
	si.lpParameters = param;

	if (dir == NULL)
	{
		char *p;
		strcpy(d, prog);
		p = d + strlen(d);
		for (;p>d;p--)
		{
			if (*p == '\\')
				break;
		}

		if (p == d)
		{
			dd = dir;
		}
		else
		{
			*p = 0;
			dd = d;
		}
	}
	else
	{
		dd = dir;
	}

	si.lpDirectory = dd;
	si.nShow = 0;

	ShellExecuteEx(&si);
}



BOOL HandlerExists(UINT uMsg)
{
	int i=0;
	BOOL found = FALSE;
	while (i < (MSGNUM))
	{
		if ((MSGCallbacks[i].Message == uMsg) && (MSGCallbacks[i].Message))
		{
			found = TRUE;
			break;
		}
		i++;
	}
	if (found)
		return TRUE;
	else
		return FALSE;
}

HRESULT passOnMessage(UINT Msg, WPARAM wParam, LPARAM lParam, BOOL wait)
{
	int i=0, j;
	BOOL found = FALSE;
	HRESULT returnVal = 0;

	while ((MSGCallbacks[i].Message) && (i < (MSGNUM)))
	{
		if (MSGCallbacks[i].Message == Msg)
		{
			found = TRUE;
			break;
		}
		i++;
	}
	if (found)
	{
		for (j=0; j<HWNDNUM; j++)
		{
			if (MSGCallbacks[i].hwnd[j] != NULL)
			{
				if (wait)
				{
//					if (Msg == 9211) MessageBox(0, "Sending Message To a window!!", "Blah", MB_OK);
					returnVal |= SendMessage(MSGCallbacks[i].hwnd[j], Msg, wParam, lParam);
				} else
				{
					PostMessage(MSGCallbacks[i].hwnd[j], Msg, wParam, lParam);
				}
			}
		}
	}
	return returnVal;
}

void addWndMessage(HWND hwnd, UINT Message)
{
	int i=0;
	while (i<MSGNUM)
	{
		if (MSGCallbacks[i].Message == Message)
			break;
		i++;
	}
	if (i == MSGNUM) {
		i = 0;
		while ((MSGCallbacks[i].Message)&&(i<MSGNUM))
		{
			i++;
		}
		if (i<MSGNUM) {
			MSGCallbacks[i].Message = Message;
		}
		else {
			return;
		}
	}
	{
		int j=0;
		while ((MSGCallbacks[i].hwnd[j] != NULL) && (j<(HWNDNUM)))
		{
			j++;
		}
		if (j < HWNDNUM) {
			MSGCallbacks[i].hwnd[j] = hwnd;
		}
	}
}

void addMessages(HWND hwnd, UINT* Msg)
{
	int i = 0;
	while ((Msg[i]) && (i < MSGNUM))
	{
		addWndMessage(hwnd, Msg[i]);
		i++;
	}
}

void removeWndMessage(HWND hwnd, UINT Message)
{
	int i=0;
	while ((MSGCallbacks[i].Message != 0) && (i<(MSGNUM)))
	{
		if (MSGCallbacks[i].Message == Message)
			break;
		i++;
	}
	if (i < (MSGNUM))
	{
		int j=0;
		while ((MSGCallbacks[i].hwnd[j] != hwnd) && (j<(HWNDNUM)))
		{
			j++;
		}
		if (j < HWNDNUM) {
			MSGCallbacks[i].hwnd[j] = NULL;
		}
		j=0;
		while (j<HWNDNUM)
		{
			if (MSGCallbacks[i].hwnd) {
				break;
			}
		}
		if (j == HWNDNUM)
		{
			MSGCallbacks[i].Message = 0;
		}
	}
}

void removeMessages(HWND hwnd, UINT* Msg)
{
	int i = 0;
	while ((Msg[i]) && (i < MSGNUM))
	{
		removeWndMessage(hwnd, Msg[i]);
		i++;
	}
}

void clearMessages()
{
	memset(MSGCallbacks, 0, sizeof(MSGCallbacks));
}

void DoEvents(HWND hwnd, int n)
{
int i;
unsigned int b=1;
MSG msg;

for (i=0;i<n && b;i++)
    {
    b = PeekMessage( &msg, hwnd, 0, 0, PM_REMOVE);
    if (b)
        {
            TranslateMessage( &msg );
            DispatchMessage( &msg );
        }
    }
}

/*
BEGIN_MESSAGE_MAP
// Things we need to know at these points...
 
		MESSAGE_HANDLER(9180, TMessage, CMQueryClosePopup)
		  - need to know popup hwnd
		  - send a "9180" to popup.
		  - Send a "9186" to desktop.
		
        MESSAGE_HANDLER(9181, TMessage, CMQueryExecPopup)
		  - send a 9181 to popup to dispay itself.

        MESSAGE_HANDLER(9182, TMessage, CMQueryPopup)
        MESSAGE_HANDLER(9183, TMessage, CMNotifyClick)
        MESSAGE_HANDLER(WM_ERASEBKGND, TMessage, CMEraseBkGnd)
        MESSAGE_HANDLER(9184, TMessage, CMNotifyTrayReady)
        MESSAGE_HANDLER(9185, TMessage, CMNotifyLooseFocus)
        MESSAGE_HANDLER(9250, TMessage, CMNotifyLeave)
        MESSAGE_HANDLER(9251, TMessage, CMNotifyEnter)
        MESSAGE_HANDLER(WM_DISPLAYCHANGE, TMessage, CMNotifyDisplayChanged)
        MESSAGE_HANDLER(9260, TMessage, CMRecycleQuery)
        MESSAGE_HANDLER(9261, TMessage, CMDoRecycleQuery)
        MESSAGE_HANDLER(9262, TMessage, CMTaskManager);
GetMessage
END_MESSAGE_MAP(TForm)
*/
