/*

  This is a part of the LiteStep Shell Source code.

  Copyright (C) 1997-98 Francis Gastellu
                    aka Lone Runner/Aegis

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/****************************************************************************

 07/18/98 - Azerov
            Removed [Drizzt]'s hotkey patch, as this functionality has been
			added to HotKeys.dll.
 07/16/98 - j_edge
			Added autorun handling for AudioCD's, along with an entry in 
			MODULES.INI to allow user to disable autorun for audio for 
			cases like module cd players which cannot be executed
 07/15/98 - Azerov
            Integrated [Drizzt]'s hotkey patch, which scans the start
			menu and desktop for shortcuts (*.lnk files), and looks to see if
			they have any hotkeys registered. (get properties on a shortcut
			to set the hotkeys).
 07/14/98 - Azerov
            Fixed tooltips for systray/taskbar on NT.
			Fixed some window cleanup errors which only manifested themselves
			as problems on NT. (If appBar was false, window classes were not
			getting unregistered.
 07/14/98 - j_edge
            Added handling code for autorun().
 07/12/98 - Azerov
            Consolidated all the tooltip windows for the app bar and systray into
			one window.
			Cleaned up tooltips alot, and made them save/restore during recycles.
 07/11/98 - Azerov
            Added support for systray configuration through Modules.ini.
			Expanded userAppBar from 16 to 50 items - having more than 16 windows
			open was overwriting memory somewhere. :)
			Got rid of hardcoded values throughout the file which assumed
			that trayWnds[] and userAppBar[] had 50 and 16 members respectively.
			Handle WM_MOUSEACTIVATE message in WndProcIcon, so that clicks and
			doubleclicks are passed to the system tray icons.
			Made window class strings const.
			Commented out the packScreenTray call in the NIM_MODIFY message, as this
			should not be necessary. (The number of systray icons will not change
			during a call to NIM_MODIFY).  packScreenTray was causing the taskbar
			to flicker every time a systray icon changed [eg. dial-up-networking icon].
			Got rid of the remaining flicker problems with the systray and taskbar.
 06/03/98 - F. Gastellu
            This file contains the source code for the desktop system
            module

****************************************************************************/


#include <windows.h>
#include <time.h>
#include <stdio.h>
#include <malloc.h>
#include <commctrl.h>
#include <dbt.h>

#include "desktop.h"
#include "lsapi.h"

// -------------------------------------------------------------------------------------------------------

const char szAppName[] = "DesktopBackgroundClass"; // Our window class, etc
const char szBar[] = "Shell_TrayWnd";
const char szTray[] = "TrayNotifyWnd";
const char szTasks[] = "MSTaskSwWClass"; 
const char szTrayIcon[] = "TrayIconClass"; // Our window class, etc
const char szAppBtn[] = "AppBtnClass"; // Our window class, etc


// our window procedures
LRESULT CALLBACK WndProcIcon(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK WndProcBar(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK WndProcTray(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK WndProcTasks(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK WndProcAppBtn(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam);
HWND hMainWnd; // main window handle
HWND hContWnd; // main window handle
HWND hBarWnd;
HWND hTrayWnd;
HWND hTasksWnd;
HWND parent;

HWND hToolTips = NULL;

// -------------------------------------------------------------------------------------------------------
void LSTransparentBlt( HDC dc, int nXDest, int nYDest, int nWidth, int nHeight, HDC tempDC, int nXSrc, int nYSrc, COLORREF colorTransparent );

BOOL backInit=FALSE;
UINT htimer;
int trayIconSize=32;

int ScreenWidth=1152, ScreenHeight=864;

BOOL appBar = TRUE;//FALSE;
int oldWidth, oldHeight;

btnType *taskBtn;
BOOL blockAppBarRepos=FALSE;

// -------------------------------------------------------------------------------------------------------

void initManager();
void resetManager();
void integrateWindow(HWND hwnd);
void packList(HWND forced);
void managerTimerProc();
int addToTray(HWND trayWnd, HWND hWnd, int message, HICON hIcon, UINT uID, char *tip);
void removeFromTray(HWND hWnd);
int getTrayByIcon(HWND trayIcon);
int getTrayByWnd(HWND trayIcon);
void removeAllTrays(void);
int packScreenTray(int i);
int rectOk(HWND hwnd);
int nTrayIcons(void);
void adjustWndSizes(void);
void setMinMax(void);
void resetMinMax(void);
void updateTasksView(int force);
HICON GetWindowIcon(HWND Hwnd);
void destroyAppWnd(int i);
int getWinByHandle(HWND h);
void drawPushed(HDC hdc, RECT r, HWND hwnd, HWND user);
void drawPoped(HDC hdc, RECT r, HWND hwnd, HWND user);
void DoEvents(int n);
void fillButton(HDC hdc, HWND hwnd, int shift, RECT r, HWND user);
void (__stdcall *SwitchToThisWindow)(HWND, int);
void HideBar(void);
void ShowBar(void);
void GetWinRect(HWND wnd, RECT *r);
int getTxtSum(HWND wnd);
int inWinList(HWND hwnd);
void CreateTooltips(HWND hWnd, char *txt, RECT *r);
void UpdateTooltips(HWND hWnd, char *txt, RECT *r);
void RemoveTooltips(HWND hWnd);
void addAppBar(APPBARDATA data, RECT *r);
void removeAppBar(HWND hwnd);
void checkAppBars(void);
void organizeAppBars(void);
int IsAppBar(HWND hWnd);
void appBarQueryPos(APPBARDATA *data, RECT *rm, int force);
int reorderWindows(void);
void autorun(int drive);
void GetAppsRect(RECT *r, HWND exclude);
unsigned char *getAutorunDrives(void);
char lsPath[256];

// -------------------------------------------------------------------------------------------------------

HINSTANCE dll;
HWND desktopWnd;
HWND currentWindow;

BOOL btnDrag=FALSE;
RECT dragRect;
BOOL lastStatePushed=FALSE;
HDC dragDC;
HWND dragUser;

BOOL newStyle=TRUE;
BOOL startButton = FALSE;
BOOL barLeft = 0;

int TRISIZE;

int fore, fore2, back, text;

HBITMAP bufferBmp, oldbBmp;
HDC bufferDC;

int np=0;

BOOL autoHide=FALSE, autoHideWharf=FALSE;
BOOL barHiden=FALSE;
BOOL hideTimerActive=FALSE;

BOOL dontReleaseIcons = FALSE;

int autoHideDelay=500;

APPBARDATA userAppBar[50];

RECT taskBarRect;
int stripBar=0;

RECT origWorkArea;

windowType *winList;
trayType trayWnds[50];
int nWin = 0, maxWin = 0;

int sysTrayRight = 0, sysTrayBottom = 1, sysTrayVertical = 0, sysTrayWrap = 1000;

OSVERSIONINFO os_info;

BOOL bAudioAutoplay;

void DebugMessages(HWND caller ,char* args)
{
	int MsgNums[2] = { 0x574F4853, 0x00000059 };


	if (!strnicmp(args, (char *) MsgNums, 5))
	{
		MessageBox(0, "Test", "Showy Stuff", MB_OK | MB_TOPMOST);
	}
	else
	{
		int MsgNums[] = { 0x6e616854, 0x6f79206b, 0x6f662075, 0x68632072, 0x69736f6f, 0x4c20676e, 0x73657469, 0x2e706574,
		                   0x6568540a, 0x76656420, 0x61657420, 0x7261206d, 0x46203a65, 0x63616f6c, 0x41202c68, 0x6f72657a,
		                   0x54202c76, 0x7473616f, 0x4d0a2c79, 0x6d6c6f48, 0x56497365, 0x696d202c, 0x202c6e61, 0x6e686573,
						   0x68637573, 0x57202c74, 0x61626265, 0x0000002e};
		MessageBox(0, (char *) MsgNums, "AboutBox", MB_OK | MB_TOPMOST);
	}
	return;
}

int SetupDesktop (void)
{
	char tmpbuf[200];	
	int test[3] = { 0x53414521, 0x45524554, 0x00004747 };

	AddBangCommand((char *) test, DebugMessages);	
	trayIconSize = GetRCInt("SysTrayIconSize", 16);
	autoHideDelay = GetRCInt("AutoHideDelay", 500);
	
	appBar = GetRCBool("NoTaskBar", FALSE);
	newStyle = GetRCBool("MSTaskBar", FALSE);	
	autoHide = GetRCBool("AutoHideTaskBar", TRUE);
	autoHideWharf = GetRCBool("AutoHideWharf", TRUE);
	stripBar = GetRCBool("StripTaskBar", TRUE);
	startButton = GetRCBool("TaskbarStartButton", TRUE);

	fore = GetRCColor("LSTaskBarFore", 0x000000);
	fore2 = GetRCColor("LSTaskBarFore2", 0x3f3f3f);
	back = GetRCColor("LSTaskBarBack", 0x7f7f7f);
	text = GetRCColor("LSTaskBarText", 0xffffff);
	
	maxWin = (int) SendMessage(parent, 9400, 1, 0);
	winList = (windowType *) SendMessage(parent, 9400, 0, 0);
	
	GetRCString("SystrayOrientation",(LPSTR)&tmpbuf,"bottomleft",128);
	if ((!stricmp((char*)&tmpbuf,"bottomleft"))||
		(!stricmp((char*)&tmpbuf,"bottom left"))||
		(!stricmp((char*)&tmpbuf,"bottomlefthorizontal"))||
		(!stricmp((char*)&tmpbuf,"bottom left horizontal")))
	{
		sysTrayRight = 0;
		sysTrayBottom = 1;
		sysTrayVertical = 0;
	}
	if ((!stricmp((char*)&tmpbuf,"bottomright"))||
		(!stricmp((char*)&tmpbuf,"bottom right"))||
		(!stricmp((char*)&tmpbuf,"bottomrighthorizontal"))||
		(!stricmp((char*)&tmpbuf,"bottom right horizontal")))
	{
		sysTrayRight = 1;
		sysTrayBottom = 1;
		sysTrayVertical = 0;
	}
	if ((!stricmp((char*)&tmpbuf,"topleft"))||
		(!stricmp((char*)&tmpbuf,"top left"))||
		(!stricmp((char*)&tmpbuf,"toplefthorizontal"))||
		(!stricmp((char*)&tmpbuf,"top left horizontal")))
	{
		sysTrayRight = 0;
		sysTrayBottom = 0;
		sysTrayVertical = 0;
	}
	if ((!stricmp((char*)&tmpbuf,"topright"))||
		(!stricmp((char*)&tmpbuf,"top right"))||
		(!stricmp((char*)&tmpbuf,"toprighthorizontal"))||
		(!stricmp((char*)&tmpbuf,"top righthorizontal")))
	{
		sysTrayRight = 1;
		sysTrayBottom = 0;
		sysTrayVertical = 0;
	}
	if ((!stricmp((char*)&tmpbuf,"bottomleftvertical"))||
		(!stricmp((char*)&tmpbuf,"bottom left vertical")))
	{
		sysTrayRight = 0;
		sysTrayBottom = 1;
		sysTrayVertical = 1;
	}
	if ((!stricmp((char*)&tmpbuf,"bottomrightvertical"))||
		(!stricmp((char*)&tmpbuf,"bottom right vertical"))) 
	{
		sysTrayRight = 1;
		sysTrayBottom = 1;
		sysTrayVertical = 1;
	}
	if ((!stricmp((char*)&tmpbuf,"topleftvertical"))||
		(!stricmp((char*)&tmpbuf,"top left vertical")))
	{
		sysTrayRight = 0;
		sysTrayBottom = 0;
		sysTrayVertical = 1;
	}
	if ((!stricmp((char*)&tmpbuf,"toprightvertical"))||
		(!stricmp((char*)&tmpbuf,"top right vertical")))
	{
		sysTrayRight = 1;
		sysTrayBottom = 0;
		sysTrayVertical = 1;
	}
	
	sysTrayWrap = GetRCInt("SystrayWrapCount", 1000);
		if (sysTrayWrap <= 0)
			sysTrayWrap = 1000;	// Don't wrap.

	{	// modules.ini section.
		char ini_path[256];
		char temp_string[32];

		wsprintf(ini_path, "%s\\modules.ini", lsPath);

		bAudioAutoplay = GetPrivateProfileInt
			( "DESKTOP", "AudioAutoplay", 1, ini_path );

		itoa( (int)bAudioAutoplay, temp_string, 10);
		WritePrivateProfileString
			( "DESKTOP", "AudioAutoplay", temp_string, ini_path );
	}
	return 0;

}


// -------------------------------------------------------------------------------------------------------
// Initialization of the module
// -------------------------------------------------------------------------------------------------------
int initModuleEx(HWND ParentWnd, HINSTANCE dllInst, LPCSTR szPath)
{
	RECT r;
	UINT Msgs[10];

	memset (&os_info, 0, sizeof (os_info));
	os_info.dwOSVersionInfoSize = sizeof (os_info);
	GetVersionEx (&os_info);
	
	dll = dllInst;
	parent = ParentWnd;
	strcpy (lsPath, szPath);

	desktopWnd = GetDesktopWindow();
	SetupDesktop();

	if (startButton) barLeft = 32 + trayIconSize;

	GetClientRect(GetDesktopWindow(),&r);
//	ScreenWidth = r.right;
//	ScreenHeight = r.bottom;
	ScreenWidth = GetSystemMetrics(SM_CXSCREEN);
	ScreenHeight = GetSystemMetrics(SM_CYSCREEN);

    TRISIZE = trayIconSize/2;

	memset(trayWnds, 0, sizeof (trayWnds));
	memset(userAppBar, 0, sizeof (userAppBar));


    taskBtn = (btnType *)calloc(maxWin, sizeof(btnType));


    // To do: check if this is a Dec Alpha processor. Under NT Alpha, the
    //        SwitchToThisWindow function does not exists

    SwitchToThisWindow = (void (__stdcall *)(HWND, int))GetProcAddress(GetModuleHandle("USER32.DLL"), "SwitchToThisWindow");

	{	// Register our window class
		WNDCLASS wc;

		memset(&wc,0,sizeof(wc));
		wc.lpfnWndProc = WndProc;				// our window procedure
		wc.hInstance = dllInst;					// hInstance of DLL
		wc.lpszClassName = szAppName;			// our window class name
		wc.style = 0;

		if (!RegisterClass(&wc)) 
		{
			MessageBox(parent,"Error registering window class","lsdesktop",MB_OK);
			return 1;
		}
	}

	{	// Register our window class
		WNDCLASS wc;

		memset(&wc,0,sizeof(wc));
		wc.lpfnWndProc = WndProcIcon;			// our window procedure
		wc.hInstance = dllInst;					// hInstance of DLL
		wc.lpszClassName = szTrayIcon;			// our window class name
		wc.style = CS_DBLCLKS;
	
		if (!RegisterClass(&wc)) 
		{
// Quick&dirty fix for nt
/*			MessageBox(parent,"Error registering window class","Shell_IconClass",MB_OK);
			return 1;*/
		}
	}


	{	// Register our window class
		WNDCLASS wc;

		memset(&wc,0,sizeof(wc));
		wc.lpfnWndProc = WndProcBar;			// our window procedure
		wc.hInstance = dllInst;					// hInstance of DLL
		wc.lpszClassName = szBar;			// our window class name
		wc.style = CS_DBLCLKS;
	
		if (!RegisterClass(&wc)) 
		{
			MessageBox(parent,"Error registering window class, must be already registered",szBar,MB_OK);
			return 1;
		}
		
	}

	{	// Register our window class
		WNDCLASS wc;

		memset(&wc,0,sizeof(wc));
		wc.lpfnWndProc = WndProcTray;			// our window procedure
		wc.hInstance = dllInst;					// hInstance of DLL
		wc.lpszClassName = szTray;			// our window class name
		wc.style = CS_DBLCLKS;
	
		if (!RegisterClass(&wc)) 
		{
			MessageBox(parent,"Error registering window class",szTray,MB_OK);
			return 1;
		}
	}

	{	// Register our window class
		WNDCLASS wc;

		memset(&wc,0,sizeof(wc));
		wc.lpfnWndProc = WndProcTasks;			// our window procedure
		wc.hInstance = dllInst;					// hInstance of DLL
		wc.lpszClassName = szTasks;			// our window class name
		wc.style = CS_DBLCLKS;
	
		if (!RegisterClass(&wc)) 
		{
			MessageBox(parent,"Error registering window class",szTasks,MB_OK);
			return 1;
		}
	}

	{	// Register our window class
		WNDCLASS wc;

		memset(&wc,0,sizeof(wc));
		wc.lpfnWndProc = WndProcAppBtn;			// our window procedure
		wc.hInstance = dllInst;					// hInstance of DLL
		wc.lpszClassName = szAppBtn;			// our window class name
		wc.style = CS_DBLCLKS;
	
		if (!RegisterClass(&wc)) 
		{
			MessageBox(parent,"Error registering window class",szAppBtn,MB_OK);
			return 1;
		}
	}

    // Find the litestep main window
    hContWnd = GetLitestepWnd();
	
    // Set the maximized size for applications
    setMinMax();

	hToolTips = CreateWindow
		(
		TOOLTIPS_CLASS,
		(LPSTR) NULL,
		TTS_ALWAYSTIP,
        CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		NULL,
		(HMENU) NULL,
		dll,
		NULL
		);
    
	if (!hToolTips)
	{
		MessageBox(parent, "Error creating tooltip window", "Desktop ToolTips Error", MB_OK);
		return 1;
	}

	SetWindowPos(hToolTips, HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_NOACTIVATE);

    if (appBar) // If user wants a taskbar
        {

        // Desktop

	    hMainWnd = CreateWindowEx(
                    WS_EX_TOOLWINDOW,                                                                  // exstyles 
		    szAppName,								// our window class name
		    "",										// use description for a window title
                    WS_POPUP|WS_CLIPSIBLINGS|WS_CLIPCHILDREN,                    
		    0, 0,									// position 
		    ScreenWidth,ScreenHeight,				// width & height of window
		    hContWnd,								// parent window 
		    NULL,									// no menu
		    dllInst,								// hInstance of DLL
		    NULL);									// no window creation data

    	if (!hMainWnd) 
    	{						   
		    MessageBox(parent,"Error creating window","lsdesktop",MB_OK);
		    return 1;
	    }

        // Bar

	    hBarWnd = CreateWindowEx(
		    WS_EX_TOPMOST|WS_EX_TOOLWINDOW,										// exstyles 
		    szBar,								// our window class name
		    "",										// use description for a window title
		    WS_POPUP|WS_CLIPSIBLINGS|WS_CLIPCHILDREN,
		    0, ScreenHeight-trayIconSize-10,									// position 
		    stripBar ? ScreenWidth - 64 : ScreenWidth, trayIconSize+10,				// width & height of window
		    NULL,								// parent window 
		    NULL,									// no menu
		    dllInst,								// hInstance of DLL
		    NULL);									// no window creation data

	    if (!hBarWnd) 
	        {						   
    		MessageBox(parent,"Error creating window",szBar,MB_OK);
		    return 1;
    	    }
		{

		}
		// System Tray

	    hTrayWnd = CreateWindowEx(
		    0,						                // exstyles 
		    szTray,							        // our window class name
		    "",										// use description for a window title
		    WS_CHILD|WS_CLIPSIBLINGS/*|WS_CLIPCHILDREN*/,				
		    barLeft + 2, 3,									// position 
		    6,trayIconSize+6,				        // width & height of window
		    hBarWnd,								// parent window 
		    NULL,									// no menu
		    dllInst,								// hInstance of DLL
		    NULL);									// no window creation data

	    if (!hTrayWnd) 
	        {						   
    		MessageBox(parent,"Error creating window",szTray,MB_OK);
		    return 1;
    	    }

        // Task Bar

	    hTasksWnd = CreateWindowEx(
		    0,		                				// exstyles 
		    szTasks,							        // our window class name
		    "",										// use description for a window title
		    WS_CHILD|WS_CLIPSIBLINGS|WS_CLIPCHILDREN,				
		    barLeft + 8, 3,									// position 
		    stripBar ? ScreenWidth - 73 : ScreenWidth-10 - barLeft,trayIconSize+6,				// width & height of window
		    hBarWnd,								// parent window 
		    NULL,									// no menu
		    dllInst,								// hInstance of DLL
		    NULL);									// no window creation data

	    if (!hTasksWnd) 
	        {						   
    		MessageBox(parent,"Error creating window",szTasks,MB_OK);
		    return 1;
    	    }
        }

    else // If user does not want a taskbar
        {
        // Background

    	 hMainWnd = CreateWindowEx(
		    WS_EX_TOOLWINDOW,										// exstyles 
	    	szAppName,								// our window class name
		    "",										// use description for a window title
		    WS_POPUP|WS_CLIPSIBLINGS/*|WS_CLIPCHILDREN*/,				
		    0, 0,									// position 
		    ScreenWidth,ScreenHeight,				// width & height of window
		    hContWnd,								// parent window 
		    NULL,									// no menu
		    dllInst,								// hInstance of DLL
		    NULL);									// no window creation data

    	if (!hMainWnd) 
    	{						   
		    MessageBox(parent,"Error creating window","lsdesktop",MB_OK);
		    return 1;
	    }

        // Bar

	    hBarWnd = CreateWindowEx(
		    WS_EX_TOOLWINDOW,										// exstyles 
		    szBar,								    // our window class name
		    "",										// use description for a window title
		    WS_POPUP|WS_CLIPSIBLINGS|WS_CLIPCHILDREN,				
		    0, ScreenHeight-trayIconSize-10,									// position 
		    ScreenWidth,trayIconSize+10,				// width & height of window
		    hMainWnd,								// parent window 
		    NULL,									// no menu
		    dllInst,								// hInstance of DLL
		    NULL);									// no window creation data

	    if (!hBarWnd) 
	        {						   
    		MessageBox(parent,"Error creating window",szBar,MB_OK);
		    return 1;
    	    }

        // System Tray

	    hTrayWnd = CreateWindowEx(
		    0,						                // exstyles 
		    szTray,							        // our window class name
		    "",										// use description for a window title
		    WS_CHILD|WS_CLIPSIBLINGS|WS_CLIPCHILDREN,				
		    2, 3,									// position 
		    6,trayIconSize+6,				        // width & height of window
		    hBarWnd,								// parent window 
		    NULL,									// no menu
		    dllInst,								// hInstance of DLL
		    NULL);									// no window creation data

	    if (!hTrayWnd) 
	        {						   
    		MessageBox(parent,"Error creating window",szTray,MB_OK);
		    return 1;
    	    }

        // Task Bar

	    hTasksWnd = CreateWindowEx(
		    0,		                				// exstyles 
		    szTasks,							        // our window class name
		    "",										// use description for a window title
		    WS_CHILD|WS_CLIPSIBLINGS|WS_CLIPCHILDREN,				
		    8, 3,									// position 
		    ScreenWidth-6,trayIconSize+6,				// width & height of window
		    hBarWnd,								// parent window 
		    NULL,									// no menu
		    dllInst,								// hInstance of DLL
		    NULL);									// no window creation data
        }

	Msgs[0] = 9212;
	Msgs[1] = 8890;
	Msgs[2] = 9210;
	Msgs[3] = 9211;
	Msgs[4] = 0;

	SendMessage(parent, 9263, (WPARAM) hMainWnd, (LPARAM) Msgs);

	
	{

    // Create our double buffer for icons drawing

    HDC dc = GetDC(parent);
    bufferDC = CreateCompatibleDC(dc);
    bufferBmp = CreateCompatibleBitmap(dc, 32, 32);
    oldbBmp = SelectObject(bufferDC, bufferBmp);
    ReleaseDC(parent, dc);
    }


		// Init the windowmanager
        initManager();

        // Slow things takes place here. This function is not so
        // quick to execute and it occurs every 250ms.
        // After extensive testing it appears 250ms is a good value, between
        // slower (too slow litestep reaction) and faster (too much cpu
        // time consumed)
	htimer = SetTimer( hMainWnd, 0, 250, NULL);
	
	SetWindowLong(hMainWnd, GWL_USERDATA, magicDWord);
	SetWindowLong(hBarWnd, GWL_USERDATA, magicDWord);
 	
	// show the window
	SetCursor(LoadCursor(NULL,IDC_ARROW));
	SetWindowPos(hMainWnd, HWND_BOTTOM, 0, 0, 0, 0, SWP_NOSIZE|SWP_NOMOVE);
	ShowWindow(hMainWnd,SW_SHOWNORMAL);

    if (appBar)
        {
    	//SetWindowPos(hBarWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE|SWP_NOMOVE);
    	ShowWindow(hBarWnd,SW_SHOWNORMAL);
		GetWindowRect(hBarWnd, &taskBarRect);
	    ShowWindow(hTrayWnd,SW_SHOWNORMAL);
	    ShowWindow(hTasksWnd,SW_SHOWNORMAL);

        if (autoHide) HideBar();
        }
    else
        {
    	ShowWindow(hBarWnd,SW_HIDE);
	    ShowWindow(hTrayWnd,SW_HIDE);
	    ShowWindow(hTasksWnd,SW_HIDE);
        }

        SetActiveWindow(hMainWnd);

        // This function is quick. a 50ms timer is not a problem 
        if (autoHide) SetTimer( hBarWnd, 0, 50, NULL);

	return 0;
}


// -------------------------------------------------------------------------------------------------------
// cleanup (opposite of init()). Destroys the window, unregisters the window class
void quitModule(HINSTANCE dllInst)
{ 
	int i;	
	KillTimer(hMainWnd, htimer);
	if (autoHide) KillTimer(hBarWnd, 0);
	if (hideTimerActive) { KillTimer(hBarWnd, 1); hideTimerActive=FALSE; }
	resetManager();
	removeAllTrays();
    
    if (appBar)
        {
		for (i=0;i<nWin;i++)
            destroyAppWnd(i);
		}
	    DestroyWindow(hTasksWnd); // delete our window
    	UnregisterClass(szTasks,dllInst/*this_mod->hDllInstance*/); // unregister window class
	    DestroyWindow(hTrayWnd); // delete our window
    	UnregisterClass(szTray,dllInst/*this_mod->hDllInstance*/); // unregister window class
    	DestroyWindow(hBarWnd); // delete our window
	    UnregisterClass(szBar,dllInst/*this_mod->hDllInstance*/); // unregister window class
	    UnregisterClass(szAppBtn,dllInst/*this_mod->hDllInstance*/); // unregister window class
		
//        if (autoHide) KillTimer(hBarWnd, 1);

    resetMinMax();

    free(taskBtn);

    SelectObject(bufferDC, oldbBmp);
    DeleteObject(bufferBmp);
    DeleteDC(bufferDC);

	DestroyWindow(hMainWnd); // delete our window
	if (hToolTips)
	{
		DestroyWindow (hToolTips);
		hToolTips = NULL;
	}

	UnregisterClass(szAppName,dllInst/*this_mod->hDllInstance*/); // unregister window class
	UnregisterClass(szTrayIcon,dllInst/*this_mod->hDllInstance*/); // unregister window class
}

// -------------------------------------------------------------------------------------------------------
// window procedure for our window
LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
        case WM_DISPLAYCHANGE:
            {

            // Screen resolution has changed. Change things accordingly

            int cxScreen = LOWORD(lParam); 
            int cyScreen = HIWORD(lParam);
            if (appBar)
                {
                RECT r;
				if (barHiden) ShowBar();
                r = taskBarRect;
                r.right -= (ScreenWidth - cxScreen);
                r.top -= (ScreenHeight - cyScreen);
                r.bottom -= (ScreenHeight - cyScreen);
				SetWindowPos(hBarWnd, 0, r.left, r.top, r.right-r.left, r.bottom-r.top, SWP_NOZORDER);
                //MoveWindow(hBarWnd, r.left, r.top, r.right-r.left, r.bottom-r.top, TRUE);
				GetWindowRect(hBarWnd, &taskBarRect);
                r.left = 6+barLeft;
                r.top = 3;
                r.right = cxScreen - 6 - barLeft;
                r.bottom = trayIconSize+8;
                MoveWindow(hTasksWnd, r.left, r.top, r.right-r.left, r.bottom-r.top, TRUE);
                }
            ScreenWidth = cxScreen;
            ScreenHeight = cyScreen;
/*            if (!appBar) */
                {
                int i;
                packScreenTray(0);
                for (i=0;i<sizeof(trayWnds)/sizeof(trayType);i++)
                    if (trayWnds[i].trayWnd)
                        SetWindowPos(trayWnds[i].trayWnd, 0, trayWnds[i].x, trayWnds[i].y, 0, 0, SWP_NOZORDER|SWP_NOSIZE);
                }
            }
        return 0;

		case WM_DEVICECHANGE:
			{

                        // A device has changed in the system

			PDEV_BROADCAST_HDR pdbch;
			PDEV_BROADCAST_VOLUME pdbcv;
			if (wParam != DBT_DEVICEARRIVAL) return TRUE;
			pdbch = (PDEV_BROADCAST_HDR) lParam;
			switch (pdbch->dbch_devicetype)
				{
				case DBT_DEVTYP_VOLUME:
					pdbcv = (PDEV_BROADCAST_VOLUME) pdbch;
					if (pdbcv->dbcv_flags == DBTF_MEDIA) 
					{
						int i;
						for (i =0; i< 26;i++)
						{
							if (pdbcv->dbcv_unitmask & (1 << i))
                            autorun(i); // Call autorun on a specific drive
						}
					}
					return TRUE;
				default:
					return TRUE;
				}
			}
        case WM_MOUSEACTIVATE:
            PostMessage(parent, 9185, 0, 0); // Tells litestep it has been selected
            SendMessage(parent, 9183, (int)HIWORD(lParam), (int)LOWORD(lParam)); // Close any popup open
            return MA_ACTIVATE;
        case WM_ACTIVATE:
            SendMessage(parent, 9185, 0, 0); // Tells litestep it has been selected
            if (LOWORD(wParam)) SetActiveWindow(parent);
            return 0;
		case WM_ENDSESSION:
		case WM_QUERYENDSESSION:
			return SendMessage(parent,message,wParam,lParam);
		case WM_CREATE:		return 0;
		case WM_ERASEBKGND: return 0;
                case 8890: // Manually ask for a paint (stupid)
		case WM_PAINT:
			{ // update from doublebuffer
				PAINTSTRUCT ps;
                HDC hdc = BeginPaint(hwnd,&ps);
                HDC src = CreateCompatibleDC(NULL);

                PaintDesktop(hdc);
                if (!appBar && np++ == 0) // If this is the first time we paint, tell it to litestep
                    PostMessage(parent, 9184, 0, 0);
    			EndPaint(hwnd,&ps);
                DeleteDC(src);
			}
		return 0;
		case WM_SYSCOMMAND:
			{
			switch (wParam)
				{
                case SC_CLOSE: // stupid but works
					PostMessage(parent,WM_KEYDOWN,8889,0);
					return 0;
				default:
					break;
				}

			break;
			}
		case WM_KEYDOWN: 
		case WM_KEYUP:
                        { // forward
				PostMessage(parent,message,wParam,lParam);
			}
		return 0;
		case WM_WINDOWPOSCHANGING:
			{
                        // Trap windowposchanging messages
			WINDOWPOS *c = (WINDOWPOS*)lParam;
		        c->hwndInsertAfter = HWND_BOTTOM;
//                      c->flags |= SWP_NOZORDER;
                        c->flags |= SWP_NOMOVE | SWP_NOSIZE;
			}
		return 0;
        case WM_NCPAINT: // one more security
            if (!wParam)
                SetWindowPos(hwnd, HWND_BOTTOM, 0, 0, 0, 0, SWP_NOSIZE|SWP_NOMOVE);
            return 0;
        case WM_RBUTTONUP: // Open popup menu
            SendMessage(parent, 9182, (int)HIWORD(lParam), (int)LOWORD(lParam));
            return 0;
        case WM_LBUTTONUP:
            SendMessage(parent, 9183, (int)HIWORD(lParam), (int)LOWORD(lParam));
            return 0;
        case WM_RBUTTONDOWN: // Close popup menu
        case WM_LBUTTONDOWN:
        case WM_MBUTTONDOWN:
            SendMessage(parent, 9183, (int)HIWORD(lParam), (int)LOWORD(lParam));
            return 0;
		case WM_TIMER:
			{
                        if (!appBar || (appBar && !btnDrag))
                            managerTimerProc();
			}
		return 0;
        case 9186: // obsolete
//        	SetWindowPos(hBarWnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE|SWP_NOMOVE);
            return 0;
        case 9210: // Litestep is asking us for a bunch of data about the
                   // System Tray contents (save/restore systray upon recycle
            {
            memcpy((void*)lParam, trayWnds, sizeof (trayWnds));
            dontReleaseIcons=TRUE;
            return 0;
            }
        case 9211: // Litestep restores the previously saved system tray
            {
            int i;
            HWND iconWnd;
            HWND p;
            RECT r;

            if (appBar) p = hTrayWnd; else p = hMainWnd;
            memcpy(trayWnds, (void*)lParam, sizeof (trayWnds));

            for (i=0;i<sizeof(trayWnds)/sizeof(trayType);i++)
                if (trayWnds[i].trayWnd)
                    {
        		    iconWnd = CreateWindowEx(
		    	        WS_EX_TRANSPARENT,										// exstyles 
				        szTrayIcon,							// our window class name
				        "",										// use description for a window title
				        WS_CHILD,				
				        4, 3,									// position 
				        trayIconSize, trayIconSize,									// width & height of window
				        p,								// parent window (winamp main window)
				        NULL,									// no menu
				        dll,								// hInstance of DLL
				        NULL);									// no window creation data

    					if (!iconWnd) 
	    					{						   
		    				MessageBox(parent,"Error creating window",szTrayIcon,MB_OK);
			    			return 1;
				    		}
                    trayWnds[i].trayWnd = iconWnd;

					if (iconWnd)
						{
						RECT r;
						GetClientRect (iconWnd, &r);
						CreateTooltips (iconWnd, trayWnds[i].szTip, &r);
						}
                    }

            packScreenTray(0);

            for (i=0;i<sizeof(trayWnds)/sizeof(trayType);i++)
                if (trayWnds[i].trayWnd)
                    {
    				SetWindowLong(trayWnds[i].trayWnd, GWL_USERDATA, (LONG)trayWnds[i].hIcon);
                    SetWindowPos(trayWnds[i].trayWnd, 0, trayWnds[i].x, trayWnds[i].y, 0, 0, SWP_NOZORDER|SWP_NOSIZE);
					ShowWindow(trayWnds[i].trayWnd,SW_SHOWNORMAL);
					r.top = 0; r.bottom = trayIconSize; r.left = 0; r.right = trayIconSize;
					InvalidateRect(trayWnds[i].trayWnd, &r, TRUE);
                    }
            return 0;
            }
                case 9212: // Returns if lParam is an app bar window
			return IsAppBar((HWND)lParam);
	}

return DefWindowProc(hwnd,message,wParam,lParam);
}

// -------------------------------------------------------------------------------------------------------
// Add a window in the list
// -------------------------------------------------------------------------------------------------------
void integrateWindow(HWND hwnd)
{
RECT r;
int style = GetWindowLong(hwnd, GWL_STYLE);
int exstyle = GetWindowLong(hwnd, GWL_EXSTYLE);

if (nWin < maxWin-1 /*&& (style & WS_MINIMIZEBOX) */&& !(style & WS_CHILD) && IsWindowVisible(hwnd) &&
	(!GetParent(hwnd) || GetParent(hwnd) == GetDesktopWindow()) && 
    GetWindowLong(hwnd, GWL_USERDATA) != magicDWord /*&& rectOk(hwnd)*/ && !(exstyle & WS_EX_TOOLWINDOW) &&
    !GetWindow(hwnd, GW_OWNER))
		{
		winList[nWin].Handle = hwnd;
		winList[nWin].Visible = TRUE;
        taskBtn[nWin].hWnd = NULL;
        taskBtn[nWin].icon = NULL;
        taskBtn[nWin].txtSum = getTxtSum(hwnd);
		if (IsIconic(hwnd))
			{
			GetWindowRect(winList[nWin].Handle, &r);
			MoveWindow(winList[nWin].Handle, ScreenWidth*3+r.left, ScreenHeight*3+r.top, r.right-r.left, r.bottom-r.top, TRUE);
			winList[nWin].Visible = FALSE;
			}
		GetWindowRect(hwnd, &winList[nWin].Position);
		nWin++;
        if (appBar) updateTasksView(1);
		}
}

// -------------------------------------------------------------------------------------------------------
// Callback function. Integrates all enumerated windows
// -------------------------------------------------------------------------------------------------------
BOOL CALLBACK EnumWindowsProc(HWND hwnd, LPARAM lParam)
{
	int i = inWinList(hwnd);

	if (!i)
		integrateWindow(hwnd);
	return TRUE;
}

// -------------------------------------------------------------------------------------------------------
// Manager init
// -------------------------------------------------------------------------------------------------------
void initManager()
{
EnumWindows(EnumWindowsProc, 0);
}

// -------------------------------------------------------------------------------------------------------
// Manager reset
// -------------------------------------------------------------------------------------------------------
void resetManager()
{
int i;
RECT r;
for (i=0;i<nWin;i++)
	{
	//ShowWindow(winList[i].Handle, SW_SHOW);
	//winList[i].Visible = TRUE;
	if (!winList[i].Visible)
		{
		GetWindowRect(winList[i].Handle, &r);
		MoveWindow(winList[i].Handle, r.left-ScreenWidth*3, r.top-ScreenHeight*3, r.right-r.left, r.bottom-r.top, TRUE);
		}
	}
// Rearrange minimized windows
ArrangeIconicWindows(GetDesktopWindow());
}

// -------------------------------------------------------------------------------------------------------
// Compact the window list
// -------------------------------------------------------------------------------------------------------
void packList(HWND forced)
{
int i=0,j,modif=0;
RECT r;
int style, exstyle;

for (i=0;i< nWin;i++)
	{
    style = GetWindowLong(winList[i].Handle, GWL_STYLE);
    exstyle = GetWindowLong(winList[i].Handle, GWL_EXSTYLE);

    if ((forced && winList[i].Handle == forced) || (!IsWindow(winList[i].Handle) || (style & WS_CHILD) || (winList[i].Visible && !IsWindowVisible(winList[i].Handle)) ||
	(GetParent(winList[i].Handle) && GetParent(winList[i].Handle) != GetDesktopWindow()) || 
    GetWindowLong(winList[i].Handle, GWL_USERDATA) == magicDWord || (exstyle & WS_EX_TOOLWINDOW) ))
        {
        if (appBar) destroyAppWnd(i);
		for (j=i;j<nWin-1;j++)
            {
			memcpy(&winList[j], &winList[j+1], sizeof(windowType));
			memcpy(&taskBtn[j], &taskBtn[j+1], sizeof(btnType));
            }
		memset(&winList[nWin-1], 0, sizeof(windowType));
		memset(&taskBtn[nWin-1], 0, sizeof(btnType));
		nWin--;
        modif = 1;
		continue;
		}
	if (IsIconic(winList[i].Handle))
		{
		if (winList[i].Visible)
			{
			//ShowWindow(winList[i].Handle, SW_HIDE);
			GetWindowRect(winList[i].Handle, &r);
			MoveWindow(winList[i].Handle, ScreenWidth*3+r.left, ScreenHeight*3+r.top, r.right-r.left, r.bottom-r.top, TRUE);
			winList[i].Visible = FALSE;
			}
		}
	else
		{
		if (!winList[i].Visible)
			{
			winList[i].Visible = TRUE;
			}
		}
	}
if (modif && appBar) updateTasksView(1);
}

// -------------------------------------------------------------------------------------------------------
// Returns true if a window is in the list
// -------------------------------------------------------------------------------------------------------
int inWinList(HWND hwnd)
{
int i;
if (!hwnd) return 0;

for (i=0;i<nWin;i++)
	if (winList[i].Handle == hwnd) return i+1;

return 0;
}

// -------------------------------------------------------------------------------------------------------
// Updates the RECT values of a window in the list
// -------------------------------------------------------------------------------------------------------
void updateRect(int i)
{
GetWindowRect(winList[i].Handle, &winList[i].Position);
}

// -------------------------------------------------------------------------------------------------------
// Callback function. Check if a window is still valid
// -------------------------------------------------------------------------------------------------------
BOOL CALLBACK checkWindowsEnumProc(HWND hwnd, LPARAM lParam)
{
int i;
long style = GetWindowLong(hwnd, GWL_STYLE);
long exstyle = GetWindowLong(hwnd, GWL_EXSTYLE);

if ((style & WS_MINIMIZEBOX) && !(style & WS_CHILD) && IsWindowVisible(hwnd) &&
	(!GetParent(hwnd) || GetParent(hwnd) == GetDesktopWindow()) && 
    GetWindowLong(hwnd, GWL_USERDATA) != magicDWord /*&& rectOk(hwnd)*/ && !(exstyle & WS_EX_TOOLWINDOW) &&
    !GetWindow(hwnd, GW_OWNER))
	{
	i = inWinList(hwnd);
	if (!i)
		{
		integrateWindow(hwnd);
		}
	else
		updateRect(i-1);
	}

return TRUE;
}

// -------------------------------------------------------------------------------------------------------
// Thios happens every 250ms
// -------------------------------------------------------------------------------------------------------
void managerTimerProc()
{
HWND c, d, w;
static HWND oldFore=NULL;
HWND prevCur;
int i,j;
RECT r;

prevCur = currentWindow;
c = GetForegroundWindow();
if (c != oldFore)
    {
    oldFore = c;
    w = NULL;
    d = c;
    if (inWinList(d)) w = d;
    while (d)
        {
        c = d;
        d = (HWND)GetWindowLong(c, GWL_HWNDPARENT);
        if (inWinList(d)) w = d;
        }
    currentWindow = w;
    }

packList(0);
EnumWindows(checkWindowsEnumProc, 0);

if (appBar && currentWindow != prevCur)
    {
    for (i=0;i<nWin;i++)
        {
        if (prevCur == winList[i].Handle || currentWindow == winList[i].Handle)
            {
            GetClientRect(taskBtn[i].hWnd, &r);
            InvalidateRect(taskBtn[i].hWnd, &r, TRUE);
            }
        }
    }

if (appBar)
	for (i=0;i<nWin;i++)
	    {
	    if ((j = getTxtSum(winList[i].Handle)) != taskBtn[i].txtSum)
			{
			char tooltip[256];
			GetClientRect(taskBtn[i].hWnd, &r);
			InvalidateRect(taskBtn[i].hWnd, &r, TRUE);
			taskBtn[i].txtSum = j;

			GetWindowText(winList[i].Handle, tooltip, 255);

			UpdateTooltips (taskBtn[i].hWnd, tooltip, &r);
			}
		}

}

// -------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------


// -------------------------------------------------------------------------------------------------------
// Add a new icon to system tray
// -------------------------------------------------------------------------------------------------------
int addToTray(HWND trayWnd, HWND hWnd, int message, HICON hIcon, UINT uID, char *tip)
{
int i;
RECT r;
for (i=0;i<sizeof(trayWnds)/sizeof(trayType);i++)
	if (!trayWnds[i].hWnd) break;
if (i == sizeof(trayWnds)/sizeof(trayType)) return 1;
trayWnds[i].trayWnd = trayWnd;
trayWnds[i].hWnd = hWnd;
trayWnds[i].message = message;
trayWnds[i].hIcon = hIcon;
trayWnds[i].uID = uID;
if (tip) strcpy(trayWnds[i].szTip, tip);
i = packScreenTray(i);

GetClientRect(trayWnds[i].trayWnd, &r);
CreateTooltips(trayWnds[i].trayWnd, tip, &r);

return i;
}

// -------------------------------------------------------------------------------------------------------
// Removes an icon from the system tray
// -------------------------------------------------------------------------------------------------------
void removeFromTray(HWND hWnd)
{
int i;
for (i=0;i<sizeof(trayWnds)/sizeof(trayType);i++)	
	{
	if (!trayWnds[i].hWnd) return;
	if (trayWnds[i].hWnd == hWnd) break;
	}
if (i == sizeof(trayWnds)/sizeof(trayType)) return;


RemoveTooltips(trayWnds[i].trayWnd);
DestroyWindow(trayWnds[i].trayWnd); // delete our window
trayWnds[i].trayWnd = NULL;
trayWnds[i].hWnd = NULL;
trayWnds[i].message = -1;
DestroyIcon(trayWnds[i].hIcon); // delete our icon
trayWnds[i].hIcon = NULL;
trayWnds[i].uID = 0;
if (trayWnds[i].szTip) memset(&(trayWnds[i].szTip), 0, 64);

for (;i<sizeof(trayWnds)/sizeof(trayType)-1;i++)
	memcpy(&trayWnds[i], &trayWnds[i+1], sizeof(trayType));

memset(&trayWnds[sizeof(trayWnds)/sizeof(trayType)-1], 0, sizeof(trayType));

packScreenTray(0);
}

// -------------------------------------------------------------------------------------------------------
// Get a systray entry from the HWND of its icon
// -------------------------------------------------------------------------------------------------------
int getTrayByIcon(HWND trayIcon)
{
int i;
for (i=0;i<sizeof(trayWnds)/sizeof(trayType);i++)	
	{
	if (!trayWnds[i].hWnd) return -1;
	if (trayWnds[i].trayWnd == trayIcon) return i;
	}
return -1;
}

// -------------------------------------------------------------------------------------------------------
// Get a systray entry from the HWND of its application
// -------------------------------------------------------------------------------------------------------
int getTrayByWnd(HWND hWnd)
{
int i;
for (i=0;i<sizeof(trayWnds)/sizeof(trayType);i++)	
	{
	if (!trayWnds[i].hWnd) return -1;
	if (trayWnds[i].hWnd == hWnd) return i;
	}
return -1;
}

// -------------------------------------------------------------------------------------------------------
// Reset system tray
// -------------------------------------------------------------------------------------------------------
void removeAllTrays(void)
{
int i;
for (i=0;i<sizeof(trayWnds)/sizeof(trayType);i++)	
	{
	if (trayWnds[i].hWnd)
		{
		DestroyWindow(trayWnds[i].trayWnd); // delete our window
		trayWnds[i].trayWnd = NULL;
		trayWnds[i].hWnd = NULL;
		trayWnds[i].message = -1;
        if (!dontReleaseIcons)
		    DestroyIcon(trayWnds[i].hIcon); // delete our icon
		trayWnds[i].hIcon = NULL;
		trayWnds[i].uID = 0;
		if (trayWnds[i].szTip) memset(&(trayWnds[i].szTip), 0, 64);
		}
	}
}

// -------------------------------------------------------------------------------------------------------
// COmpact system tray list (removes unused entries)
// -------------------------------------------------------------------------------------------------------
int packScreenTray(int thisIdx)
{
int		i, j=-1;

for (i=0;i<sizeof(trayWnds)/sizeof(trayType);i++)	   
	{
	if (!trayWnds[i].hWnd) break;
	if (!IsWindow(trayWnds[i].hWnd))
		{
		removeFromTray(trayWnds[i].hWnd);
		if (thisIdx > i) thisIdx--;
		}
	}

for (i=0;i<sizeof(trayWnds)/sizeof(trayType);i++)
	{
	RECT r;
	if (trayWnds[i].hIcon)
		j++;
	if (!trayWnds[i].hWnd)
		break;

	if (!GetClientRect (trayWnds[i].hWnd, &r))
	{
		r.left = r.top = 0;
	}

	if (!appBar)
	{
		if (sysTrayRight)
		{
			if (sysTrayVertical)
			{
				trayWnds[i].x = ScreenWidth -  ((j / sysTrayWrap) + 1) * (trayIconSize + 3);
			}
			else
			{
				trayWnds[i].x = ScreenWidth - ((j % sysTrayWrap) + 1) * (trayIconSize + 3);
			}
//			if (!sysTrayBottom)
//			{
//				trayWnds[i].x -= 64;
//			}
		}
		else
		{
			if (sysTrayVertical)
			{
				trayWnds[i].x = 3 + (j / sysTrayWrap) * (trayIconSize + 3);
			}
			else
			{
				trayWnds[i].x = 3 + (j % sysTrayWrap) * (trayIconSize + 3);
			}
		}

		if (sysTrayBottom)
		{
			if (sysTrayVertical)
			{
				trayWnds[i].y = ScreenHeight - ((j % sysTrayWrap) + 1) * (trayIconSize + 3);
			}
			else
			{
				trayWnds[i].y = ScreenHeight - ((j / sysTrayWrap) + 1) * (trayIconSize + 3);
			}
		}
		else
		{
			if (sysTrayVertical)
			{
				trayWnds[i].y = 3 + (j % sysTrayWrap) * (trayIconSize + 3);
			}
			else
			{
				trayWnds[i].y = 3 + (j / sysTrayWrap) * (trayIconSize + 3);
			}
		}
	}
	else
	{
		trayWnds[i].x = j*(trayIconSize+2)+4;
		trayWnds[i].y = 3;
	}

	if (r.left != trayWnds[i].x || r.top != trayWnds[i].y)
		{
		SetWindowPos(trayWnds[i].trayWnd, 0, trayWnds[i].x, trayWnds[i].y, 0, 0, SWP_NOZORDER|SWP_NOSIZE);
		}
	}

if (thisIdx != -1)
	{
	adjustWndSizes();
	}

return thisIdx;
}

// -------------------------------------------------------------------------------------------------------
// Window procedure for system tray icons
// -------------------------------------------------------------------------------------------------------
LRESULT CALLBACK WndProcIcon(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_ENDSESSION:
		case WM_QUERYENDSESSION:
			return SendMessage(parent,message,wParam,lParam);
		case WM_CREATE:		return 0;
		case WM_ERASEBKGND: return 1;
		case WM_PAINT:
			{ // update from doublebuffer
				HICON ico;
				PAINTSTRUCT ps;
				HDC hdc = BeginPaint(hwnd,&ps);

                StretchBlt(bufferDC, 0, 0, 32, 32, hdc, 0, 0, trayIconSize, trayIconSize, SRCCOPY);
				ico = (HICON)GetWindowLong(hwnd, GWL_USERDATA);
				DrawIconEx(bufferDC, 0, 0, ico, 32, 32, 0, NULL, DI_NORMAL);
                StretchBlt(hdc, 0, 0, trayIconSize, trayIconSize, bufferDC, 0, 0, 32, 32, SRCCOPY);
    
				EndPaint(hwnd,&ps);
			}
		return 0;
		case WM_MOUSEACTIVATE:
			return MA_NOACTIVATE;
        case WM_LBUTTONDBLCLK: // Forward messages to the application
		case WM_LBUTTONDOWN:
		case WM_LBUTTONUP:
		case WM_MBUTTONDBLCLK:
		case WM_MBUTTONDOWN:
		case WM_MBUTTONUP:
		case WM_RBUTTONDBLCLK:
		case WM_RBUTTONDOWN:
		case WM_RBUTTONUP:
		case WM_MOUSEMOVE:
            {
                        // To do: see why some rare application opens their
                        // context menu on top of the screen instead of
                        // where the mouse is

				int i = getTrayByIcon(hwnd);
				MSG TooltipMessage;

				packScreenTray(-1);
				i = getTrayByIcon(hwnd);
				if (i >= 0)
				{
					SendMessage(trayWnds[i].hWnd, trayWnds[i].message, trayWnds[i].uID, message);

					TooltipMessage.hwnd=trayWnds[i].trayWnd;
					TooltipMessage.message=message;
					TooltipMessage.wParam=wParam;
					TooltipMessage.lParam=lParam;
					SendMessage(hToolTips,TTM_RELAYEVENT,0,(LPARAM)&TooltipMessage);
					SetWindowPos(hToolTips, HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_NOACTIVATE);
				}
			}
		return 0;

		case WM_KEYDOWN: 
		case WM_KEYUP:
			{	
				PostMessage(parent,message,wParam,lParam);
			}
		return 0;

		case WM_SYSCOMMAND:
			{
			switch (wParam)
				{
				case SC_CLOSE:
					PostMessage(parent,WM_KEYDOWN,8889,0);
					return 0;
				default:
					return DefWindowProc(hwnd,message,wParam,lParam);
				}
			}
	}

return DefWindowProc(hwnd,message,wParam,lParam);
}

// -------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------

// -------------------------------------------------------------------------------------------------------
// Check a RECT
// -------------------------------------------------------------------------------------------------------
int rectOk(HWND hwnd)
{
RECT r;

GetWindowRect(hwnd, &r);
return (!(r.bottom == r.top || r.right == r.left));
}

// -------------------------------------------------------------------------------------------------------
// Window procedure for the taskbar
// -------------------------------------------------------------------------------------------------------
LRESULT CALLBACK WndProcBar(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
        case WM_ENDSESSION:
        case WM_QUERYENDSESSION:
                return SendMessage(parent,message,wParam,lParam);
        case WM_MOUSEMOVE:
            if (!autoHide) return 0;
            {
            if (barHiden) 
                ShowBar();
            else
				{
                KillTimer(hBarWnd, 1);
				hideTimerActive=FALSE;
				}
            }
        return 0;
		case WM_LBUTTONDOWN:
			{
				ParseBangCommand(hwnd, "!popup", NULL);
			}
			break;
        case WM_TIMER:
            {
			if (wParam == 1)
				{
				if (autoHide) HideBar();
				KillTimer(hBarWnd, 1);
				hideTimerActive=FALSE;
				}
			else
				{
				if (autoHide && !barHiden && !hideTimerActive)
					{
					POINT pt;
					RECT r;
					GetCursorPos(&pt);
					GetWindowRect(hBarWnd, &r);
					if (pt.x < r.left || pt.x > r.right || pt.y < r.top || pt.y > r.bottom)
						{
						SetTimer(hBarWnd, 1, autoHideDelay, NULL);
						hideTimerActive=TRUE;
						}
					}
				}
		    }
        return 0;
		case WM_PAINT:
			{
			PAINTSTRUCT ps;
			HDC hdc = BeginPaint(hwnd,&ps);
            RECT r;
			int clr1, clr2, clr3;
			HPEN oldPen, pen;
			HBRUSH brush;

            if (appBar)
                {
                GetClientRect(hwnd, &r);
                if (!newStyle)
					{
					clr1 = GetSysColor(COLOR_3DHILIGHT);
					clr2 = GetSysColor(COLOR_3DDKSHADOW);
					clr3 = GetSysColor(COLOR_3DFACE);
					}
                else
                    {
					clr1 = fore;
					clr2 = fore2;
					clr3 = back;
                    }

				pen = CreatePen(PS_SOLID, 1, clr1);
				oldPen = SelectObject(hdc, pen);

				MoveToEx(hdc, 0, 0, NULL);
				LineTo(hdc, r.right, 0);
				SelectObject(hdc, oldPen);
				DeleteObject(pen);

				if (stripBar)
					{
					pen = CreatePen(PS_SOLID, 1, clr2);
					oldPen = SelectObject(hdc, pen);

					MoveToEx(hdc, r.right-1, 0, NULL);
					LineTo(hdc, r.right-1, r.bottom-1);
					SelectObject(hdc, oldPen);
					DeleteObject(pen);
					}

				r.top++;
				r.right--;
				brush = CreateSolidBrush(clr3);
				FillRect(hdc, &r, brush);
				if (startButton)
				{
					HPEN old, pen;
					char txt[256];
					HFONT oldFont, hf;
					HICON hIcon1;
					RECT r2;

					pen = CreatePen(PS_SOLID, 1, clr1);
					old = SelectObject(hdc, pen);

					MoveToEx(hdc, barLeft - 2, 3, NULL);
					LineTo(hdc, 2, 3);
					LineTo(hdc, 2, r.bottom-2);
					SelectObject(hdc, old);
					DeleteObject(pen);
					pen = CreatePen(PS_SOLID, 1, clr2);
					old = SelectObject(hdc, pen);
					LineTo(hdc, barLeft - 2, r.bottom - 2);
					LineTo(hdc, barLeft - 2, 3);
					SelectObject(hdc, old);
					DeleteObject(pen);


					strcpy(txt, "Start");
					hIcon1 = LoadIcon(NULL, IDI_WINLOGO);

					StretchBlt(bufferDC, 0, 0, 32, 32, hdc, 3, 4, trayIconSize, trayIconSize, SRCCOPY);
					DrawIconEx(bufferDC, 0, 0, hIcon1, 32, 32, 0, NULL, DI_NORMAL);
					StretchBlt(hdc, 3, 4, trayIconSize, trayIconSize, bufferDC, 0, 0, 32, 32, SRCCOPY);

					hf = GetStockObject(ANSI_VAR_FONT); 
					oldFont = SelectObject(hdc, hf); 
					SetBkMode(hdc, TRANSPARENT);

					r2.left = 4 + trayIconSize;
					r2.right = barLeft - 4;
					r2.top = 3;
					r2.bottom = r.bottom - 2;

					if (newStyle)
						SetTextColor(hdc, text);
					else
						SetTextColor(hdc, GetSysColor(COLOR_BTNTEXT));
        
					DrawText(hdc, txt, strlen(txt), &r2, DT_LEFT | DT_END_ELLIPSIS | DT_VCENTER | DT_SINGLELINE);

					SelectObject(hdc, oldFont);

				}
				
				DeleteObject(brush);
                }
			EndPaint(hwnd,&ps);
            }
		return 0;
		case WM_COPYDATA:
                // Undocumented: This is how we can make our own system tray
                // and eventually handle app bar windows. Once a window in
                // the system has the "Shell_TrayWnd" class name, it receives
                // this message! 
			{
			int i;
			RECT r;
			HWND iconWnd;
			int targetMsg=-1;
			NOTIFYICONDATA *data;
			COPYDATASTRUCT *d;
			HICON targetIcon=NULL;
			char targetTip[256]="";
			
			d = (COPYDATASTRUCT *)lParam;

			switch (d->dwData)
				{
				case 1: // Forward System Tray

					data = (NOTIFYICONDATA *)(((char*)d->lpData)+8);

					switch (*(int *)(((char*)d->lpData)+4))
						{
			
						case NIM_ADD:
						    {
							HWND p;

						    if (appBar) p = hTrayWnd; else p = hMainWnd;
					
							i = getTrayByWnd(data->hWnd);
							if (i >= 0 && data->uID == trayWnds[i].uID) goto _modifySecurity;

							if (data->uFlags & NIF_MESSAGE)
								targetMsg = data->uCallbackMessage;
							if (data->uFlags & NIF_TIP && data->szTip)
							{
								memset(targetTip, 0, sizeof(targetTip));
								if (os_info.dwPlatformId == VER_PLATFORM_WIN32_NT)
								{
									WideCharToMultiByte
										(
										CP_ACP,
										0,
										(wchar_t *) data->szTip,
										wcslen ((wchar_t *) data->szTip),
										targetTip,
										sizeof (targetTip),
										NULL,
										NULL
										);
								}
								else
								{
									strcpy(targetTip, data->szTip);
								}
							}

						    iconWnd = CreateWindowEx(
						    WS_EX_TRANSPARENT,										// exstyles 
						    szTrayIcon,							// our window class name
						    "",										// use description for a window title
						    WS_CHILD,				
							4, 3,									// position 
							trayIconSize, trayIconSize,									// width & height of window
						    p,								// parent window (winamp main window)
						    NULL,									// no menu
						    dll,								// hInstance of DLL
						    NULL);									// no window creation data

							if (!iconWnd) 
								{						   
								MessageBox(parent,"Error creating window",szTrayIcon,MB_OK);
								return 1;
								}
						
							if (data->uFlags & NIF_ICON)
								targetIcon = CopyIcon(data->hIcon);
				
							SetWindowLong(iconWnd, GWL_USERDATA, (long)targetIcon);
							i = addToTray(iconWnd, data->hWnd, targetMsg, targetIcon, data->uID, targetTip);
							SetWindowPos(iconWnd, 0, trayWnds[i].x, trayWnds[i].y, 0, 0, SWP_NOZORDER|SWP_NOSIZE);
							ShowWindow(iconWnd,SW_SHOWNORMAL);

							break;
			                }
			
						case NIM_DELETE:
							removeFromTray(data->hWnd);
							break;

						case NIM_MODIFY:
							{
							BOOL need_to_pack_tray;
							i = getTrayByWnd(data->hWnd);
							if (i < 0) break;
				
							_modifySecurity:
							
							need_to_pack_tray = FALSE;

							targetMsg = trayWnds[i].message;
							targetIcon = trayWnds[i].hIcon;
							if (data->uFlags & NIF_TIP && trayWnds[i].szTip)
								strcpy(targetTip, trayWnds[i].szTip);
							if (data->uFlags & NIF_MESSAGE && data->uCallbackMessage)
								targetMsg = data->uCallbackMessage;
							if (targetIcon != NULL && data->hIcon && data->uFlags & NIF_ICON)
								DestroyIcon(targetIcon);
							if (data->uFlags & NIF_ICON)
							{
								if ((targetIcon && !data->hIcon) || (!targetIcon && data->hIcon))
								{
									// If the icon has been hidden or shown
									need_to_pack_tray = TRUE;
								}
							}
							if (data->uFlags & NIF_ICON && data->hIcon)
								targetIcon = CopyIcon(data->hIcon);
							if (data->uFlags & NIF_TIP && data->szTip)
							{
								memset(targetTip, 0, sizeof(targetTip));
								if (os_info.dwPlatformId == VER_PLATFORM_WIN32_NT)
								{
									WideCharToMultiByte
										(
										CP_ACP,
										0,
										(wchar_t *) data->szTip,
										wcslen ((wchar_t *) data->szTip),
										targetTip,
										sizeof (targetTip),
										NULL,
										NULL
										);
								}
								else
								{
									strcpy(targetTip, data->szTip);
								}
							}
			
							trayWnds[i].message = targetMsg;
							trayWnds[i].hIcon = targetIcon;
							trayWnds[i].uID = data->uID;
							if (targetTip) strcpy(trayWnds[i].szTip, targetTip);
							SetWindowLong(trayWnds[i].trayWnd, GWL_USERDATA, (long)targetIcon);

							if (need_to_pack_tray)
							{
								i = packScreenTray(i);
							}
							if (appBar)
								{
							    r.top = trayWnds[i].y; r.bottom = trayWnds[i].y+trayIconSize; r.left = trayWnds[i].x; r.right = trayWnds[i].x+trayIconSize;
								InvalidateRect(hTrayWnd, &r, TRUE);
			                    }
				            else
				                {
					            r.top = trayWnds[i].y; r.bottom = trayWnds[i].y+trayIconSize; r.left = trayWnds[i].x; r.right = trayWnds[i].x+trayIconSize;
							    InvalidateRect(hMainWnd, &r, TRUE);
							    }
							r.top = 0; r.bottom = trayIconSize; r.left = 0; r.right = trayIconSize;
							if (data->uFlags & NIF_TIP)
							{
								UpdateTooltips (trayWnds[i].trayWnd, trayWnds[i].szTip, &r);
							}
							InvalidateRect(trayWnds[i].trayWnd, &r, TRUE);
							break;
							}
						}
					return TRUE;
// This part is commented out until we find why it conflicts with ICQ
/*				case 0: // Forward AppBar
					{
					APPBARDATA *bDATA = (APPBARDATA *)d->lpData;
					int action = *(int*)(((char*)(d->lpData)) + 0x24);
					RECT *rm = (RECT *)*(int*)(((char *)d->lpData) + 0x28);
					switch (action)
						{
						case ABM_ACTIVATE:
							return TRUE;
							break;
						case ABM_GETAUTOHIDEBAR:
							return -1;
							break;
						case ABM_GETSTATE:
							return ABS_ALWAYSONTOP | autoHide ? ABS_AUTOHIDE : 0;
							break;
						case ABM_GETTASKBARPOS:
							if (!appBar)
								return FALSE;
							else
								{
								RECT r;
								GetWindowRect(hBarWnd, &r);
								rm->left = 0;
								rm->top = r.top;
								rm->right = ScreenWidth;
								rm->bottom = ScreenHeight;
								return TRUE;
								}
							break;
						case ABM_NEW:
							if (userAppBar[sizeof (userAppBar)/sizeof(APPBARDATA)-1].hWnd || IsAppBar(bDATA->hWnd))
								return FALSE;
							else
								{
								addAppBar(*bDATA, NULL);
								return TRUE;
								}
							break;
						case ABM_QUERYPOS:
							appBarQueryPos(bDATA, rm, 1);
							return TRUE;
							break;
						case ABM_REMOVE:
							removeAppBar(bDATA->hWnd);
							organizeAppBars();
							return TRUE;
							break;
						case ABM_SETAUTOHIDEBAR:
							return TRUE;
							break;
						case ABM_SETPOS:
							appBarQueryPos(bDATA, rm, 0);
							addAppBar(*bDATA, rm);
							organizeAppBars();
							return TRUE;
							break;
						case ABM_WINDOWPOSCHANGED:
							if (!blockAppBarRepos)
								{
								blockAppBarRepos=TRUE;
								if (reorderWindows())
									DoEvents(2);
								blockAppBarRepos=FALSE;
								}
							organizeAppBars();
							return TRUE;
							break;
						}
					}
					return TRUE;*/
				}
			}
		return 0;
		case WM_KEYDOWN: 
		case WM_KEYUP:
			{	
				PostMessage(parent,message,wParam,lParam);
			}
		return 0;
		case WM_SYSCOMMAND:
			{
			switch (wParam)
				{
				case SC_CLOSE:
					PostMessage(parent,WM_KEYDOWN,8889,0);
					return 0;
				default:
					return DefWindowProc(hwnd,message,wParam,lParam);
				}
			}
	}

return DefWindowProc(hwnd,message,wParam,lParam);
}

// -------------------------------------------------------------------------------------------------------
// Window procedure for the system tray window
// -------------------------------------------------------------------------------------------------------
LRESULT CALLBACK WndProcTray(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_ENDSESSION:
		case WM_QUERYENDSESSION:
			return SendMessage(parent,message,wParam,lParam);
		case WM_CREATE:		return 0;
		case WM_ERASEBKGND: return 0;
        case WM_PAINT:
			{
			PAINTSTRUCT ps;
			HDC hdc = BeginPaint(hwnd,&ps);
            RECT r;
            if (np++ == 0) 
                {
                int i;
                SendMessage(hBarWnd, WM_PAINT, 0, 0);
                SendMessage(hTrayWnd, WM_PAINT, 0, 0);
                SendMessage(hTasksWnd, WM_PAINT, 0, 0);
                if (appBar)
                    for (i=0;i<nWin;i++)
                        SendMessage((HWND)(taskBtn[i].hWnd), WM_PAINT, 0, 0);
                PostMessage(parent, 9184, 0, 0);
                }
            if (appBar)
                {
                GetClientRect(hwnd, &r);
                //DrawEdge(hdc, &r, EDGE_SUNKEN, BF_RECT | BF_MIDDLE);
                if (newStyle)
                    {
                    HBRUSH brush = CreateSolidBrush(back);
                    FillRect(hdc, &r, brush);
                    DeleteObject(brush);
                    }
                else
                    FillRect(hdc, &r, GetStockObject(LTGRAY_BRUSH));

                    {
                    HPEN old, pen;
                    int clr1,clr2;

                    if (newStyle) clr1 = fore; else clr1 = GetSysColor(COLOR_3DHILIGHT);
                    if (newStyle) clr2 = fore2; else clr2 = GetSysColor(COLOR_3DDKSHADOW);

                    pen = CreatePen(PS_SOLID, 1, clr1);
                    old = SelectObject(hdc, pen);
                    MoveToEx(hdc, r.right-2, 0, NULL);
                    LineTo(hdc, r.right-2, r.bottom-1);
                    LineTo(hdc, 0, r.bottom-1);
                    SelectObject(hdc, old);
                    DeleteObject(pen);
                    pen = CreatePen(PS_SOLID, 1, clr2);
                    old = SelectObject(hdc, pen);
                    LineTo(hdc, 0, 0);
                    LineTo(hdc, r.right-2, 0);
                    SelectObject(hdc, old);
                    DeleteObject(pen);
                    }
                }
			EndPaint(hwnd,&ps);
            }
        return 0;
		case WM_KEYDOWN: 
		case WM_KEYUP:
			{	
				PostMessage(parent,message,wParam,lParam);
			}
		return 0;
		case WM_SYSCOMMAND:
			{
			switch (wParam)
				{
				case SC_CLOSE:
					PostMessage(parent,WM_KEYDOWN,8889,0);
					return 0;
				default:
					return DefWindowProc(hwnd,message,wParam,lParam);
				}
			}
	}

return DefWindowProc(hwnd,message,wParam,lParam);
}

// -------------------------------------------------------------------------------------------------------
// Window procedure for task buttons container windows
// -------------------------------------------------------------------------------------------------------
LRESULT CALLBACK WndProcTasks(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_ENDSESSION:
		case WM_QUERYENDSESSION:
			return SendMessage(parent,message,wParam,lParam);
		case WM_CREATE:		return 0;
		case WM_ERASEBKGND: return 0;
		case WM_PAINT:
			{
			PAINTSTRUCT ps;
			HDC hdc = BeginPaint(hwnd,&ps);
            RECT r;
            GetClientRect(hwnd, &r);
                {
                HBRUSH old, br;
                int clr;

                if (newStyle) clr = back; else clr = GetSysColor(COLOR_BTNFACE);
                br = CreateSolidBrush(clr);
                old = SelectObject(hdc, br);
                FillRect(hdc, &r, br);
                SelectObject(hdc, old);
                DeleteObject(br);
                }
			EndPaint(hwnd,&ps);
            }
		return 0;
		case WM_KEYDOWN: 
		case WM_KEYUP:
			{	
				PostMessage(parent,message,wParam,lParam);
			}
		return 0;
		case WM_SYSCOMMAND:
			{
			switch (wParam)
				{
				case SC_CLOSE:
					PostMessage(parent,WM_KEYDOWN,8889,0);
					return 0;
				default:
					return DefWindowProc(hwnd,message,wParam,lParam);
				}
			}
	}

return DefWindowProc(hwnd,message,wParam,lParam);
}

// -------------------------------------------------------------------------------------------------------
// Returns how many icons are in the system tray
// -------------------------------------------------------------------------------------------------------
int nTrayIcons(void)
{
int i;
for (i=0;i<sizeof(trayWnds)/sizeof(trayType);i++)
	if (!trayWnds[i].hWnd) break;
return i;
}


// -------------------------------------------------------------------------------------------------------
// Computes window sizes
// -------------------------------------------------------------------------------------------------------
void adjustWndSizes(void)
{
RECT	r,r2;
int		i = nTrayIcons();
RECT	trayRect, tasksRect;
BOOL	need_to_invalidate = FALSE;

GetClientRect(hTrayWnd, &r);
GetClientRect(hTasksWnd, &r2);

if (!sysTrayRight)
{
	trayRect.left = r.left;
	trayRect.top = r.top;
	trayRect.right = trayRect.left + 6+(trayIconSize+2)*i;
	trayRect.bottom = trayRect.top + trayIconSize+6;

	tasksRect.left = 8+barLeft+(trayIconSize+2)*i;
	tasksRect.top = 3;
	tasksRect.right = tasksRect.left + (stripBar ? ScreenWidth - 73 : ScreenWidth-10 - barLeft)-(trayIconSize+2)*i;
	tasksRect.bottom = tasksRect.top + trayIconSize+6;

	if (memcmp (&trayRect, &r, sizeof (trayRect)))
	{
		need_to_invalidate = TRUE;
		SetWindowPos(hTrayWnd, NULL, 0, 0, trayRect.right-trayRect.left,trayRect.bottom-trayRect.top, SWP_NOMOVE|SWP_NOOWNERZORDER|SWP_NOZORDER);
	}

	if (memcmp (&tasksRect, &r2, sizeof (tasksRect)))
	{
		need_to_invalidate = TRUE;
		SetWindowPos(hTasksWnd, NULL, tasksRect.left, tasksRect.top, tasksRect.right - tasksRect.left, tasksRect.bottom - tasksRect.top, SWP_NOOWNERZORDER|SWP_NOZORDER);
	}
//	SetWindowPos(hTrayWnd, NULL, 0, 0, 6+(trayIconSize+2)*i,trayIconSize+6, SWP_NOMOVE|SWP_NOOWNERZORDER|SWP_NOZORDER);
//	SetWindowPos(hTasksWnd, NULL, 8+(trayIconSize+2)*i, 3, (stripBar ? ScreenWidth - 73 : ScreenWidth-10)-(trayIconSize+2)*i, trayIconSize+6, SWP_NOOWNERZORDER|SWP_NOZORDER);
}
else
{
	trayRect.left = ScreenWidth-((6+(trayIconSize+2)*i)+(stripBar?64:0));
	trayRect.top = 3;
	trayRect.right = trayRect.left + 6+(trayIconSize+2)*i;
	trayRect.bottom = trayRect.top + trayIconSize+6;

	tasksRect.left = 6+barLeft;
	tasksRect.top = 3;
	tasksRect.right = ScreenWidth-((12+(trayIconSize+2)*i)+(stripBar?64:0));
	tasksRect.bottom = tasksRect.top + trayIconSize+6;

	if (memcmp (&trayRect, &r, sizeof (trayRect)))
	{
		need_to_invalidate = TRUE;
		SetWindowPos (hTrayWnd, NULL, trayRect.left, trayRect.top, trayRect.right-trayRect.left, trayRect.bottom-trayRect.top, SWP_NOOWNERZORDER|SWP_NOZORDER);
	}

	if (memcmp (&tasksRect, &r2, sizeof (tasksRect)))
	{
		need_to_invalidate = TRUE;
		SetWindowPos(hTasksWnd, NULL, tasksRect.left, tasksRect.top, tasksRect.right - tasksRect.left, tasksRect.bottom - tasksRect.top, SWP_NOOWNERZORDER|SWP_NOZORDER);
	}
//	SetWindowPos (hTrayWnd, NULL, ScreenWidth-((6+(trayIconSize+2)*i)+(stripBar?64:0)), 3, 6+(trayIconSize+2)*i, trayIconSize+6, SWP_NOOWNERZORDER|SWP_NOZORDER);
//	SetWindowPos (hTasksWnd, NULL, 0, 0, ScreenWidth-((12+(trayIconSize+2)*i)+(stripBar?64:0)), trayIconSize+6, SWP_NOMOVE|SWP_NOOWNERZORDER|SWP_NOZORDER);
}

//GetClientRect(hTrayWnd, &r2);
//if (appBar && memcmp(&r, &r2, sizeof(RECT)))
if (need_to_invalidate)
    {
    InvalidateRect(hTrayWnd, &r, TRUE);
    }
updateTasksView(need_to_invalidate?1:0);
}

// -------------------------------------------------------------------------------------------------------
// Sets maximized windows size
// -------------------------------------------------------------------------------------------------------
void setMinMax(void)
{
RECT r;

if (!appBar)
{
	return;
}
SystemParametersInfo(SPI_GETWORKAREA,0,(PVOID)&r,SPIF_SENDCHANGE);
origWorkArea = r;
r.bottom = ScreenHeight - ((autoHide) ? 1 : (trayIconSize+10));
SystemParametersInfo(SPI_SETWORKAREA,0,(PVOID)&r,SPIF_SENDCHANGE);

SystemParametersInfo(SPI_GETWORKAREA,0,(PVOID)&r,SPIF_SENDCHANGE);

}

// -------------------------------------------------------------------------------------------------------
// Reset to old maximized windows size
// -------------------------------------------------------------------------------------------------------
void resetMinMax(void)
{
RECT rc;	

if (!appBar)
{
	return;
}
	SystemParametersInfo(SPI_GETWORKAREA,0,(PVOID)&rc,SPIF_SENDCHANGE);
	rc.bottom += ((autoHide) ? 1 : (trayIconSize+10));
	SystemParametersInfo(SPI_SETWORKAREA,0,(PVOID)&rc,SPIF_SENDCHANGE);
}

// -------------------------------------------------------------------------------------------------------
// Updates task buttons
// To do: remove flicker
// -------------------------------------------------------------------------------------------------------
void updateTasksView(int force)
{
int i;
int y, h;
float x,w;
RECT r;

if (!appBar) return;

GetClientRect(hTasksWnd, &r);

h = r.bottom;
if (nWin != 0)
    w = (r.right-6) / (float)nWin;
else 
    {
    if (!newStyle)
        w = (float)165;
    else
        w = (float)(r.right-6);
    }
if (!newStyle && (w > 165)) w = (float)165;
x = (float)0;
y = 0;

for (i=0;i<nWin;i++,x=x+w)
    {
    if (!taskBtn[i].hWnd)
        {
		char tooltip[256];
		taskBtn[i].hWnd = CreateWindowEx(
		WS_EX_ACCEPTFILES,										// exstyles 
		szAppBtn,		    					// our window class name
		"",					    				// use description for a window title
		WS_CHILD,	
		0, 0,									// position 
		4, 2,									// width & height of window
		hTasksWnd,								// parent window (winamp main window)
		NULL,									// no menu
		dll,						    		// hInstance of DLL
		NULL);									// no window creation data

		if (!taskBtn[i].hWnd) 
			MessageBox(parent,"Error creating window",szAppBtn,MB_OK);
        else
            {
            taskBtn[i].icon = CopyIcon(GetWindowIcon(winList[i].Handle));
            SetWindowPos(taskBtn[i].hWnd, NULL, (int)(x+4), y, (int)(w-2), h, SWP_NOZORDER);
            ShowWindow(taskBtn[i].hWnd,SW_SHOWNORMAL);
            SetWindowLong(taskBtn[i].hWnd, GWL_USERDATA, (long)winList[i].Handle);
            }
		GetClientRect(taskBtn[i].hWnd, &r);
        InvalidateRect(taskBtn[i].hWnd, &r, TRUE);
		GetWindowText(winList[i].Handle, tooltip, 255);
		CreateTooltips(taskBtn[i].hWnd, tooltip, &r);
        }
    else
        {
        RECT r2;
        GetWinRect(taskBtn[i].hWnd, &r2);
		GetClientRect(taskBtn[i].hWnd, &r2);
        if (force || r2.left != x+4 || r2.top != y || (r2.right-r2.left) != w-2 || (r2.bottom-r2.top) != h)
            {
			char tooltip[256];
            SetWindowPos(taskBtn[i].hWnd, NULL, (int)(x+4), y, (int)(w-2), h, SWP_NOZORDER);
            InvalidateRect(taskBtn[i].hWnd, &r, TRUE);
			GetWindowText(winList[i].Handle, tooltip, 255);
			GetClientRect(taskBtn[i].hWnd, &r);
			UpdateTooltips (taskBtn[i].hWnd, tooltip, &r);
            }
        }
    } 
}

// -------------------------------------------------------------------------------------------------------
// Gets a windows icon
// -------------------------------------------------------------------------------------------------------
HICON GetWindowIcon(HWND Hwnd)
{
HICON a;

if (trayIconSize <= 24) // we prefer to resize from the small icon (if available)
    {
    SendMessageTimeout(Hwnd, WM_GETICON, 0, 0, 0, 1000, (unsigned long*)&a);
    if (!a) a = (void *)GetClassLong(Hwnd, GCL_HICONSM);
    if (!a) SendMessageTimeout(Hwnd, WM_GETICON, 1, 0, 0, 1000, (unsigned long*)&a);
    if (!a) a = (void *)GetClassLong(Hwnd, GCL_HICON);
    if (!a) SendMessageTimeout(Hwnd, WM_QUERYDRAGICON, 0, 0, 0, 1000, (unsigned long*)&a);
    }
else // we prefer to resize from the 32x32 icon
    {
    SendMessageTimeout(Hwnd, WM_GETICON, 1, 0, 0, 1000, (unsigned long*)&a);
    if (!a) a = (void *)GetClassLong(Hwnd, GCL_HICON);
    if (!a) SendMessageTimeout(Hwnd, WM_QUERYDRAGICON, 0, 0, 0, 1000, (unsigned long*)&a);
    if (!a) SendMessageTimeout(Hwnd, WM_GETICON, 0, 0, 0, 1000, (unsigned long*)&a);
    if (!a) a = (void *)GetClassLong(Hwnd, GCL_HICONSM);
    }

return a;
}

// -------------------------------------------------------------------------------------------------------
// Removes a task button from the taskbar
// -------------------------------------------------------------------------------------------------------
void destroyAppWnd(int i)
{
RemoveTooltips(taskBtn[i].hWnd);
if (IsWindow(taskBtn[i].hWnd))
    DestroyWindow(taskBtn[i].hWnd); // delete our window
taskBtn[i].hWnd = NULL;
DestroyIcon(taskBtn[i].icon);
taskBtn[i].icon = NULL;
}

// ----------------------------------------------------------------------------
// Search for the VWM
// ----------------------------------------------------------------------------
// -------------------------------------------------------------------------------------------------------
// Window procedure for task buttons windows
// -------------------------------------------------------------------------------------------------------
LRESULT CALLBACK WndProcAppBtn(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_ENDSESSION:
		case WM_QUERYENDSESSION:
			return SendMessage(parent,message,wParam,lParam);
		case WM_CREATE:		return 0;
		case WM_ERASEBKGND: return 0;
        case WM_MOUSEMOVE:
            {
			MSG TooltipMessage;
//			char tooltip[256];
			int i;

			for (i=0;i<maxWin;i++)
				if (taskBtn[i].hWnd == hwnd && taskBtn[i].needTooltip)
					{
//
//					GetWindowText(winList[i].Handle, tooltip, 255);
//					UpdateTooltips (winList[i].Handle, tooltip, &r);

					TooltipMessage.hwnd=taskBtn[i].hWnd;
					TooltipMessage.message=WM_MOUSEMOVE;
					TooltipMessage.wParam=wParam;
					TooltipMessage.lParam=lParam;
					SendMessage(hToolTips,TTM_RELAYEVENT,0,(LPARAM)&TooltipMessage);
					SetWindowPos(hToolTips, HWND_TOPMOST,0,0,0,0,SWP_NOMOVE|SWP_NOSIZE|SWP_NOACTIVATE);
					break;
					}
            if (btnDrag)
                {
                POINTS pts;
    			pts = MAKEPOINTS(lParam);
                if (pts.x >= dragRect.left && pts.x <= dragRect.right && pts.y >= dragRect.top && pts.y <= dragRect.bottom)
                    {
                    if (!lastStatePushed) 
                        {
                        drawPushed(dragDC, dragRect, hwnd, dragUser);
                        lastStatePushed = TRUE;
                        }
                    }
                else
                    {
                    if (lastStatePushed && dragUser != currentWindow)
                        {
                        drawPoped(dragDC, dragRect, hwnd, dragUser);
                        lastStatePushed = FALSE;
                        }
                    }
                }
            }
        return 0;
        case WM_LBUTTONUP:
            {
            POINTS pts;
            int i = getWinByHandle((HWND)GetWindowLong(hwnd, GWL_USERDATA));
			pts = MAKEPOINTS(lParam);

            ReleaseCapture();
            if (dragUser == currentWindow || pts.x >= dragRect.left && pts.x <= dragRect.right && pts.y >= dragRect.top && pts.y <= dragRect.bottom)
                {
               	if (IsIconic(winList[i].Handle)) 
                    {
                    //ShowWindow(winList[i].Handle, SW_RESTORE);
                    SwitchToThisWindow(winList[i].Handle, 1);
                    }
                else
                    {
                    if (!SendMessage(parent, 8891, 0, (long)winList[i].Handle))
                        SwitchToThisWindow(winList[i].Handle, 1);
//                        SetForegroundWindow(winList[i].Handle);
                    }
                DoEvents(5);
                }
            btnDrag = FALSE;
            ReleaseDC(hwnd, dragDC);
            managerTimerProc();
            }
        return 0;
        case WM_LBUTTONDOWN:
            {
            HDC hdc;
            RECT r;
            SetCapture(hwnd);

            hdc = GetDC(hwnd);
            GetClientRect(hwnd, &r);
            dragUser = (HWND)GetWindowLong(hwnd, GWL_USERDATA);
            drawPushed(hdc, r, hwnd, dragUser);
            btnDrag=TRUE;
            dragRect = r;
            lastStatePushed = TRUE;
            dragDC = hdc;
            }
        return 0;
        case WM_RBUTTONDOWN:
            SendMessage((HWND)GetWindowLong(hwnd, GWL_USERDATA), 0x313, 0, GetMessagePos());
            return 0;
		case WM_PAINT:
			{
			PAINTSTRUCT ps;
            HWND user;
            int shift=0;
			HDC hdc = BeginPaint(hwnd,&ps);
            RECT r;
            GetClientRect(hwnd, &r);
            
            user = (HWND)GetWindowLong(hwnd, GWL_USERDATA);
            if (currentWindow == user) shift = 1;

            if (currentWindow == user)
                drawPushed(hdc, r, hwnd, user);
            else
                drawPoped(hdc, r, hwnd, user);

			EndPaint(hwnd,&ps);
            }
		return 0;
		case WM_KEYDOWN: 
		case WM_KEYUP:
			{	
				PostMessage(parent,message,wParam,lParam);
			}
		return 0;
		case WM_SYSCOMMAND:
			{
			switch (wParam)
				{
				case SC_CLOSE:
					PostMessage(parent,WM_KEYDOWN,8889,0);
					return 0;
				default:
					break;
				}

			break;
			}
	}

return DefWindowProc(hwnd,message,wParam,lParam);
}

// -------------------------------------------------------------------------------------------------------
// Draws a pushed button
// -------------------------------------------------------------------------------------------------------
void drawPushed(HDC hdc, RECT r, HWND hwnd, HWND user)
{
HPEN old, pen;
int clr1, clr2;

if (newStyle) clr1 = fore; else clr1 = GetSysColor(COLOR_3DHILIGHT);
if (newStyle) clr2 = fore2; else clr2 = GetSysColor(COLOR_3DDKSHADOW);

pen = CreatePen(PS_SOLID, 1, clr1);
fillButton(hdc, hwnd, 1, r, user);
old = SelectObject(hdc, pen);

if (newStyle) 
    {
    int i;
    for (i=TRISIZE;i>0;i--)
        {
        MoveToEx(hdc, r.right-1, TRISIZE-i, NULL);
        LineTo(hdc, r.right - (1 + TRISIZE - (TRISIZE-i)), TRISIZE-i);
        }
    }
MoveToEx(hdc, r.right-1, 0, NULL);

LineTo(hdc, r.right-1, r.bottom-1);
LineTo(hdc, 0, r.bottom-1);
SelectObject(hdc, old);
DeleteObject(pen);
pen = CreatePen(PS_SOLID, 1, clr2);
old = SelectObject(hdc, pen);
LineTo(hdc, 0, 0);
LineTo(hdc, r.right-1, 0);
SelectObject(hdc, old);
DeleteObject(pen);
}

// -------------------------------------------------------------------------------------------------------
// Draws a normal button
// -------------------------------------------------------------------------------------------------------
void drawPoped(HDC hdc, RECT r, HWND hwnd, HWND user)
{
HPEN old, pen;
int clr1, clr2;

if (newStyle) clr1 = fore2; else clr1 = GetSysColor(COLOR_3DDKSHADOW);
if (newStyle) clr2 = fore; else clr2 = GetSysColor(COLOR_3DHILIGHT);

pen = CreatePen(PS_SOLID, 1, clr1);
fillButton(hdc, hwnd, 0, r, user);
old = SelectObject(hdc, pen);
MoveToEx(hdc, r.right-1, 0, NULL);
LineTo(hdc, r.right-1, r.bottom-1);
LineTo(hdc, 0, r.bottom-1);
SelectObject(hdc, old);
DeleteObject(pen);
pen = CreatePen(PS_SOLID, 1, clr2);
old = SelectObject(hdc, pen);
LineTo(hdc, 0, 0);
LineTo(hdc, r.right-1, 0);
SelectObject(hdc, old);
DeleteObject(pen);
}

// -------------------------------------------------------------------------------------------------------
// Gets a window index from its HWND
// -------------------------------------------------------------------------------------------------------
int getWinByHandle(HWND h)
{
int i;
for (i=0;i<nWin;i++)
    if (winList[i].Handle == h)
        return i;
return -1;
}

// -------------------------------------------------------------------------------------------------------
// Fills the inside of a button with its icon & title
// -------------------------------------------------------------------------------------------------------
void fillButton(HDC hdc, HWND hwnd, int shift, RECT r, HWND user)
{
int i;
i = getWinByHandle(user);

if (!newStyle)
    FillRect(hdc, &r, GetStockObject(LTGRAY_BRUSH));
else
    {
    HBRUSH brush = CreateSolidBrush(back);
    r.left++;
    r.right--;
    r.top++;
    r.bottom--;
    FillRect(hdc, &r, brush);
    DeleteObject(brush);
    }

if (i >= 0)
    {
    char txt[256];
    HFONT oldFont, hf;
    RECT r2;
	SIZE s;

//    DrawIconEx(hdc, 4+shift, 4+shift, taskBtn[i].icon, trayIconSize, trayIconSize, 0, NULL, DI_NORMAL);

    StretchBlt(bufferDC, 0, 0, 32, 32, hdc, 4+shift, 4+shift, trayIconSize, trayIconSize, SRCCOPY);
    DrawIconEx(bufferDC, 0, 0, taskBtn[i].icon, 32, 32, 0, NULL, DI_NORMAL);
    StretchBlt(hdc, 4+shift, 3+shift, trayIconSize, trayIconSize, bufferDC, 0, 0, 32, 32, SRCCOPY);

    r2 = r;
    hf = GetStockObject(ANSI_VAR_FONT); 
    oldFont = SelectObject(hdc, hf); 
    SetBkMode(hdc, TRANSPARENT);

    GetWindowText(user, txt, 255);

    r2.left += 8+trayIconSize+shift;
    r2.top += shift;
    if (newStyle)
        SetTextColor(hdc, text);
    else
        SetTextColor(hdc, GetSysColor(COLOR_BTNTEXT));
        
    DrawText(hdc, txt, strlen(txt), &r2, DT_LEFT | DT_END_ELLIPSIS | DT_VCENTER | DT_SINGLELINE);

	GetTextExtentPoint32(hdc, txt, strlen(txt), &s);
	if (s.cx > r.right - (trayIconSize+8+shift+1))
		taskBtn[i].needTooltip = TRUE;
	else
		taskBtn[i].needTooltip = FALSE;

    SelectObject(hdc, oldFont);
    }
}


// -------------------------------------------------------------------------------------------------------
// Non blocking wait
// -------------------------------------------------------------------------------------------------------
void DoEvents(int n)
{
int i;
BOOL b=TRUE;
MSG msg;

for (i=0;i<n && b;i++)
    {
    b = GetMessage( &msg, NULL, 0, 0 );
    if (b) 
        {
	    TranslateMessage( &msg );
	    DispatchMessage( &msg ); 
        }
    }
}

// -------------------------------------------------------------------------------------------------------
// Hide the taskbar
// -------------------------------------------------------------------------------------------------------
void HideBar(void)
{
RECT r;
int w;
if (barHiden) return;
//GetWindowRect(hBarWnd, &r);
r = taskBarRect;
w = r.bottom-r.top;
r.top+= trayIconSize+9;
r.bottom = r.top + w;
MoveWindow(hBarWnd, r.left, r.top, r.right-r.left, r.bottom-r.top, TRUE);
barHiden = TRUE;
}

// -------------------------------------------------------------------------------------------------------
// Show the taskbar
// -------------------------------------------------------------------------------------------------------
void ShowBar(void)
{
RECT r;
//int w;

if (!barHiden) return;
//GetWindowRect(hBarWnd, &r);
/*w = r.bottom-r.top;
r.top -= trayIconSize+10;
r.bottom = r.top + w;*/
r = taskBarRect;
MoveWindow(hBarWnd, r.left, r.top, r.right-r.left, r.bottom-r.top, TRUE);
barHiden = FALSE;
}

// -------------------------------------------------------------------------------------------------------
// Gets a RECT for a task button
// -------------------------------------------------------------------------------------------------------
void GetWinRect(HWND wnd, RECT *r)
{
RECT r1;
RECT r2;

GetWindowRect(wnd, &r1);
GetWindowRect(GetParent(wnd), &r2);
r->left = r1.left-r2.left;
r->right = r1.right - r2.left;
r->top = r1.top - r2.top;
r->bottom = r1.bottom - r2.top;
}

// -------------------------------------------------------------------------------------------------------
// Get window title checksum
// -------------------------------------------------------------------------------------------------------
int getTxtSum(HWND wnd)
{
char txt[256];
int c=0;
char *p = txt;
GetWindowText(wnd, txt, 255);
while (*p) c += *p++;
return c;
}

// -------------------------------------------------------------------------------------------------------
// Create task button tooltip
// -------------------------------------------------------------------------------------------------------
void CreateTooltips(HWND hWnd, char *txt, RECT *r)
{
    TOOLINFO ti;    // tool information

	if (!hToolTips)
	{
		return;
	}

	ti.cbSize = sizeof(TOOLINFO);
	ti.uFlags = TTF_SUBCLASS;
	ti.hwnd = hWnd;
	ti.hinst = dll;
	ti.uId = 0;
	ti.lpszText = txt;
	ti.rect = *r;

	SendMessage(hToolTips, TTM_ADDTOOL, 0, (LPARAM) (LPTOOLINFO) &ti);
}

void UpdateTooltips(HWND hWnd, char *txt, RECT *r)
{
    TOOLINFO ti;    // tool information
	char cleartext[256];

	if (!hToolTips)
	{
		return;
	}
	memset(cleartext, 0, sizeof(cleartext));
	strcpy(cleartext, txt);

	ti.cbSize = sizeof(TOOLINFO);
	ti.uFlags = TTF_SUBCLASS;
	ti.hwnd = hWnd;
	ti.hinst = dll;
	ti.uId = 0;
	ti.lpszText = cleartext;
	ti.rect = *r;

	SendMessage(hToolTips, TTM_UPDATETIPTEXT, 0, (LPARAM) (LPTOOLINFO) &ti);
}
// -------------------------------------------------------------------------------------------------------
// Remove task button's tooltip
// -------------------------------------------------------------------------------------------------------
void RemoveTooltips(HWND hWnd/*, HWND hwndTT*/)
{
    TOOLINFO ti;    // tool information
	RECT r={0,0,0,0};

	ti.cbSize = sizeof(TOOLINFO);
	ti.uFlags = 0;
	ti.hwnd = hWnd;
	ti.hinst = dll;
	ti.uId = 0;
	ti.lpszText = NULL;
	ti.rect = r;

	SendMessage(hToolTips, TTM_DELTOOL, 0, (LPARAM) (LPTOOLINFO) &ti);
}

// -----------------------------------------------------------------------------------------------
// Adds a appbar
// -----------------------------------------------------------------------------------------------
void addAppBar(APPBARDATA data, RECT *r)
{
int i;

if (IsAppBar(data.hWnd))
	{
	for (i=0;i<sizeof (userAppBar)/sizeof(APPBARDATA);i++)
		{
		if (userAppBar[i].hWnd && userAppBar[i].hWnd == data.hWnd)
			{
			userAppBar[i] = data;
			userAppBar[i].rc = *r;
			return;
			}
		}
	return;
	}
else
	for (i=0;i<sizeof (userAppBar)/sizeof(APPBARDATA);i++)
		{
		if (userAppBar[i].hWnd == NULL)
			{
			userAppBar[i] = data;
			if (r != NULL && !(r->top == 0 && r->left == 0 && r->right == 0 && r->bottom == 0))
				userAppBar[i].rc = *r;
			break;
			}
		}
}

// -----------------------------------------------------------------------------------------------
// Removes an appbar
// -----------------------------------------------------------------------------------------------
void removeAppBar(HWND hwnd)
{
int i;

for (i=0;i<sizeof (userAppBar)/sizeof(APPBARDATA);i++)
	{
	if (userAppBar[i].hWnd == hwnd)
		{
		for (;i<(sizeof (userAppBar)/sizeof(APPBARDATA)-1);i++)
			userAppBar[i] = userAppBar[i+1];
		memset(&userAppBar[sizeof (userAppBar)/sizeof(APPBARDATA)-1], 0, sizeof(APPBARDATA));
		break;
		}
	}
}

// -----------------------------------------------------------------------------------------------
// Check appbars validity
// -----------------------------------------------------------------------------------------------
void checkAppBars(void)
{
int i;
for (i=0;i<sizeof (userAppBar)/sizeof(APPBARDATA);i++)
	{
	if (userAppBar[i].hWnd && !IsWindow(userAppBar[i].hWnd))
		{
		removeAppBar(userAppBar[i].hWnd);
		i--;
		}
	}
}

// -----------------------------------------------------------------------------------------------
// Returns true if argument is an appbar
// -----------------------------------------------------------------------------------------------
int IsAppBar(HWND hWnd)
{
int i;
for (i=0;i<sizeof (userAppBar)/sizeof(APPBARDATA);i++)
	{
	if (userAppBar[i].hWnd && userAppBar[i].hWnd == hWnd)
		return TRUE;
	}
return FALSE;
}

// -----------------------------------------------------------------------------------------------
// Compute appbar ideal position
// -----------------------------------------------------------------------------------------------
void appBarQueryPos(APPBARDATA *data, RECT *rm, int force)
{
RECT r;
int width, height;

if (rm == NULL || ( (data->rc.top == 0 && data->rc.left == 0 && data->rc.right == 0 && data->rc.bottom == 0) && !force)) return;

/*if (IsAppBar(data->hWnd) && !force)
	{
	int i;
	for (i=0;i<sizeof (userAppBar)/sizeof(APPBARDATA);i++)
		{
		if (userAppBar[i].hWnd && userAppBar[i].hWnd == data->hWnd)
			*rm = userAppBar[i].rc;
		}
	return;
	}*/

width = data->rc.right-data->rc.left;
height = data->rc.bottom-data->rc.top;

GetAppsRect(&r, data->hWnd);
switch (data->uEdge)
	{
	case ABE_LEFT:
		rm->left = r.left;
		rm->right = data->rc.left + width;
		rm->top = r.top;
		rm->bottom = r.bottom;
		break;
	case ABE_RIGHT:
		rm->right = r.right;
		rm->left = data->rc.right - width;
		rm->top = r.top;
		rm->bottom = r.bottom;
		break;
	case ABE_TOP:
		rm->top = r.top;
		rm->bottom = data->rc.top + height;
		rm->left = r.left;
		rm->right = r.right;
		break;
	case ABE_BOTTOM:
		rm->bottom = r.bottom;
		rm->top = data->rc.bottom - height;
		rm->left = r.left;
		rm->right = r.right;
		break;
	}
}

// -----------------------------------------------------------------------------------------------
// Gets an appbar rect
// -----------------------------------------------------------------------------------------------
void GetAppsRect(RECT *r, HWND exclude)
{
int i;
*r=origWorkArea;
for (i=0;i<sizeof (userAppBar)/sizeof(APPBARDATA);i++)
	{
	if (userAppBar[i].hWnd && ! (userAppBar[i].rc.top == 0 && userAppBar[i].rc.left == 0 && userAppBar[i].rc.right == 0 && userAppBar[i].rc.bottom == 0) && userAppBar[i].hWnd != exclude && IsWindowVisible(userAppBar[i].hWnd))
		{
		switch (userAppBar[i].uEdge)
			{
			case ABE_LEFT:
				if (userAppBar[i].rc.right > r->left) r->left = userAppBar[i].rc.right;
				break;
			case ABE_RIGHT:
				if (userAppBar[i].rc.left < r->right) r->right = userAppBar[i].rc.left;
				break;
			case ABE_TOP:
				if (userAppBar[i].rc.bottom > r->top) r->top = userAppBar[i].rc.bottom;
				break;
			case ABE_BOTTOM:
				if (userAppBar[i].rc.top < r->bottom) r->bottom = userAppBar[i].rc.top;
				break;
			}
		}
	}
}

// -----------------------------------------------------------------------------------------------
// Reorganize appbars
// -----------------------------------------------------------------------------------------------
void organizeAppBars(void)
{
int i;
RECT r=origWorkArea;
for (i=0;i<sizeof (userAppBar)/sizeof(APPBARDATA);i++)
	{
	if (userAppBar[i].hWnd && ! (userAppBar[i].rc.top == 0 && userAppBar[i].rc.left == 0 && userAppBar[i].rc.right == 0 && userAppBar[i].rc.bottom == 0) && IsWindowVisible(userAppBar[i].hWnd))
		{
		switch (userAppBar[i].uEdge)
			{
			case ABE_LEFT:
				if (userAppBar[i].rc.right > r.left) r.left = userAppBar[i].rc.right;
				break;
			case ABE_RIGHT:
				if (userAppBar[i].rc.left < r.right) r.right = userAppBar[i].rc.left;
				break;
			case ABE_TOP:
				if (userAppBar[i].rc.bottom > r.top) r.top = userAppBar[i].rc.bottom;
				break;
			case ABE_BOTTOM:
				if (userAppBar[i].rc.top < r.bottom) r.bottom = userAppBar[i].rc.top;
				break;
			}
		}
	}
SystemParametersInfo(SPI_SETWORKAREA, 1, &r, SPIF_SENDWININICHANGE);
}

// -----------------------------------------------------------------------------------------------
// Reorders windows
// -----------------------------------------------------------------------------------------------
int reorderWindows(void)
{
int a=0;
HWND last = GetWindow(hMainWnd, GW_HWNDLAST);
while (last && last != hMainWnd)
	{
	if (GetWindowLong(last, GWL_STYLE) & WS_VISIBLE)
		{
		a=1;
		SetWindowPos(last, GetWindow(hMainWnd, GW_HWNDPREV), 0, 0, 0, 0, SWP_NOSIZE|SWP_NOMOVE);
		last = GetWindow(hMainWnd, GW_HWNDLAST);
		continue;
		}
	last = GetWindow(last, GW_HWNDPREV);
	}
return a;
}


// -----------------------------------------------------------------------------------------------
//  Compares drive type to drives that have autorun enabled set in registry 
//		(using getAutorunDrives()) and if enabled launches open= entry in autorun.inf
// -----------------------------------------------------------------------------------------------
void autorun(int drive)
{
	unsigned char *pDriveData;
	UINT uDriveType;
	char szDrive[4] = " :\\";
	BOOL floppyNoAutorun = TRUE;
	BOOL fixedNoAutorun = TRUE;
	BOOL netNoAutorun = TRUE;
	BOOL cdNoAutorun = TRUE;
	BOOL ramNoAutorun = TRUE;
	char szInfFilename[15];
	char szOpenEntry[_MAX_PATH];
	char szCommandline[_MAX_PATH];
	STARTUPINFO sInfo;
	PROCESS_INFORMATION pInfo;
	BOOL bResult;

	// get info for drive that media has been inserted in
	*szDrive = (char) (drive+(int)'A');
	uDriveType = GetDriveType(szDrive);

	// figure out which drives have autorun disabled in registry
	pDriveData = getAutorunDrives();
	floppyNoAutorun = ( 0x04 & *pDriveData );
	fixedNoAutorun = ( 0x08 & *pDriveData );
	netNoAutorun = ( 0x10 & *pDriveData );
	cdNoAutorun = ( 0x20 & *pDriveData );
	ramNoAutorun = ( 0x40 & *pDriveData );

	free(pDriveData);

	// return if drive has autorun disabled
	switch(uDriveType) {
	case DRIVE_REMOVABLE:
		if( floppyNoAutorun )
			return;
		break;
	case DRIVE_FIXED:
		if( fixedNoAutorun )
			free(pDriveData);
			return;
		break;
	case DRIVE_REMOTE:
		if( netNoAutorun )
			return;
		break;
	case DRIVE_CDROM:
		if( cdNoAutorun )
			return;
		else { 
			// handle AudioCD's here since they should be the only media type
			// this pertains to (can you play an audio cd over a network?)
			char szVolumeName[12];
			DWORD dwVolSerNum;
			DWORD dwMaxCompLength;
			DWORD dwFileSystemFlags;
			char szFileSysName[10];
			HINSTANCE hResult;

			GetVolumeInformation( szDrive, szVolumeName, sizeof(szVolumeName), 
				&dwVolSerNum, &dwMaxCompLength, &dwFileSystemFlags, szFileSysName,
				sizeof(szFileSysName) );

			// only do this if it's an audio cd & AudioAutoplay is enabled
			if( (strcmp( szVolumeName, "Audio CD" ) == 0) && bAudioAutoplay ) {	
				hResult = ShellExecute(GetDesktopWindow(), "play", "track01.cda", 
					NULL, szDrive, SW_SHOW );
				return;
			} else if( strcmp( szVolumeName, "Audio CD" ) == 0 )
				return;			// AudioAutoplay is disabled in MODULES.INI
		}		
		break;
	case DRIVE_RAMDISK:
		if( ramNoAutorun )
			return;
		break;
	default:
		return;
		break;
	}
	
	// if we've made it this far, it's a data cd so check if there's an autorun.inf
	// and if so get the "open" entry from it & execute it
	_makepath( szInfFilename, szDrive, NULL, "Autorun", ".inf" );

	GetPrivateProfileString( "autorun", "open", "", szOpenEntry, 
		sizeof(szOpenEntry), szInfFilename );

	if( !*szOpenEntry )
		return;

	strcpy( szCommandline, szDrive );
	strcat( szCommandline, szOpenEntry );

	memset( &sInfo, 0, sizeof(sInfo) );
	sInfo.cb=sizeof(sInfo);
	sInfo.wShowWindow=SW_SHOWNORMAL;

			
	bResult = CreateProcess( NULL, szCommandline, NULL, NULL, FALSE,
		CREATE_NEW_PROCESS_GROUP, NULL, szDrive, &sInfo, &pInfo );
	
	if(!bResult)
	{
		LPVOID lpMsgBuf;
		
		FormatMessage( 
			FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
			NULL, GetLastError(),
			MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
			(LPTSTR) &lpMsgBuf, 0, NULL );

		MessageBox( NULL, lpMsgBuf, "ERROR:CreateProcess() failed", 
			MB_OK|MB_ICONINFORMATION );

		LocalFree( lpMsgBuf );
		return;
	}

	if(pInfo.hProcess)
		CloseHandle( pInfo.hProcess );
	if(pInfo.hThread)
		CloseHandle( pInfo.hThread );
}

// -----------------------------------------------------------------------------------------------
// used by autorun()
// -----------------------------------------------------------------------------------------------
unsigned char *getAutorunDrives( void ) 
{
	HKEY hKey = NULL;
	DWORD dwType, dwSize = 0;
	unsigned char *pDriveData = NULL;
	char *lpzRegistryString =
		"Software\\Microsoft\\Windows\\CurrentVersion\\Policies\\Explorer";
	LONG result;

	result = RegOpenKeyEx( HKEY_CURRENT_USER, lpzRegistryString, 
		(unsigned long)NULL, KEY_READ, &hKey );

	if (result == ERROR_SUCCESS)
	{
		result = RegQueryValueEx( hKey, "NoDriveTypeAutorun", NULL, &dwType, NULL, &dwSize );

		if (result == ERROR_SUCCESS)
		{
			pDriveData = (unsigned char *)malloc(dwSize);
			RegQueryValueEx( hKey, "NoDriveTypeAutorun", NULL, &dwType, pDriveData, &dwSize );
		}
		RegCloseKey( hKey );
	}

	if (!pDriveData)
	{
		pDriveData = (unsigned char *) malloc (1);

		*pDriveData = '\0';
	}
	return pDriveData;
}

/*
void LSTransparentBlt( HDC dc, int nXDest, int nYDest, int nWidth, 
	int nHeight, HDC tempDC, int nXSrc, int nYSrc,
	COLORREF colorTransparent ) {

	HDC locMemDC, maskDC;

	HBITMAP maskBitmap;
	HBITMAP bmpImage;

	//add these to store return of SelectObject() calls
	HBITMAP hOldMemBmp = NULL;
	HBITMAP hOldMaskBmp = NULL;

	maskDC = CreateCompatibleDC(dc);

	locMemDC = CreateCompatibleDC(dc);

	bmpImage = CreateCompatibleBitmap( dc, nWidth, nHeight );
	hOldMemBmp = SelectObject( locMemDC, bmpImage );


	BitBlt( locMemDC, 0,0,nWidth, nHeight, tempDC, nXSrc, nYSrc, SRCCOPY );

	// Create monochrome bitmap for the mask
	maskBitmap = CreateBitmap( nWidth, nHeight, 1, 1, NULL );
	hOldMaskBmp = SelectObject( maskDC, maskBitmap );
	SetBkColor( locMemDC, colorTransparent );

	// Create the mask from the memory DC
	BitBlt( maskDC, 0, 0, nWidth, nHeight, locMemDC, 0, 0, SRCCOPY );

	// Set the background in locMemDC to black. Using SRCPAINT with black 
	// and any other color results in the other color, thus making 
	// black the transparent color
	SetBkColor( locMemDC, RGB(0,0,0) );
	SetTextColor( locMemDC, RGB(255,255,255) );
	BitBlt( locMemDC, 0, 0, nWidth, nHeight, maskDC, 0, 0, SRCAND );

	// Set the foreground to black. See comment above.
	SetBkColor( dc, RGB(255,255,255) );
	SetTextColor( dc, RGB(0,0,0) );
	BitBlt( dc, nXDest, nYDest, nWidth, nHeight, maskDC, 0, 0, SRCAND );

	// Combine the foreground with the background
	BitBlt( dc, nXDest, nYDest, nWidth, nHeight, locMemDC, 0, 0, SRCPAINT);


	if (hOldMaskBmp)
		SelectObject( maskDC, hOldMaskBmp );
	if (hOldMemBmp)
		SelectObject( locMemDC, hOldMemBmp );

	DeleteDC(maskDC);
	DeleteDC(locMemDC);
	DeleteObject(maskBitmap);
	DeleteObject(bmpImage);
	DeleteObject(hOldMemBmp);
	DeleteObject(hOldMaskBmp);
}
*/
