
{************************************************}
{                                                }
{   Turbo Pascal for Windows                     }
{   WINEDT 95 Settings                           }
{   Copyright (c) 1995 by Alex                   }
{                                                }
{************************************************}

program WINEDT95_Selections;

{$R-}

uses Strings, WObjects, WinTypes, WinProcs;

type

  TRGB = array [0..3] of byte;

  PaletteApplication = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

  PTestWindow = ^TestWindow;
  TestWindow = object(TWindow)
    TheFont: HFont;
    CW,CH: integer;
    xRGB: byte;
    TextColor: TRGB;
    constructor Init(AParent: PWindowsObject; ATitle: PChar);
    destructor Done; virtual;
    procedure Paint(PaintDC: HDC; var PInfo: TPaintStruct); virtual;
    procedure WMLButtonDown(var Msg: TMessage);
      virtual wm_First + wm_LButtonDown;
    procedure WMRButtonDown(var Msg: TMessage);
      virtual wm_First + wm_RButtonDown;
  end;

{--------------------------------------------------}
{ TestWindow method implementations:               }
{--------------------------------------------------}

constructor TestWindow.Init(AParent: PWindowsObject; ATitle: PChar);
var WrDC: HDC;
    ATextMetric: TTextMetric;
begin
  TWindow.Init(AParent, ATitle);
  TheFont:=GetStockObject(OEM_Fixed_Font);
  WrDC:=GetDC(0);
  SelectObject(WrDC, TheFont);
  GetTextMetrics(WrDC, ATextMetric);
  CW:=ATextMetric.tmMaxCharWidth;
  CH:=ATextMetric.tmHeight;
  ReleaseDC(0, WrDC);
  LongInt(TextColor):=0;
  xRGB:=0;
end;

destructor TestWindow.Done;
begin
  TWindow.Done;
end;

procedure TestWindow.Paint(PaintDC: HDC; var PInfo: TPaintStruct);
var stc: array [0..15] of char;
    xMsg: array [0..255] of char;
    tc,OTC: LongInt;
    otf: HFont;
  procedure StrHEX( s: PChar; c: byte );
    procedure xCon( s: PChar; b: byte );
    begin
      case b of
        0: StrCat(s, '0');
        1: StrCat(s, '1');
        2: StrCat(s, '2');
        3: StrCat(s, '3');
        4: StrCat(s, '4');
        5: StrCat(s, '5');
        6: StrCat(s, '6');
        7: StrCat(s, '7');
        8: StrCat(s, '8');
        9: StrCat(s, '9');
        10: StrCat(s, 'A');
        11: StrCat(s, 'B');
        12: StrCat(s, 'C');
        13: StrCat(s, 'D');
        14: StrCat(s, 'E');
        15: StrCat(s, 'F');
        else StrCat(s, '?');
      end;
    end;
  begin
    xCon(s, c div 16);
    xCon(s, c mod 16);
  end;
  function GetHEX( str: PChar ): LongInt;
  type XColor = record
         dd,cc,bb,aa: byte;
       end;
  var i,j: integer;
      XC: XColor;
      s: array [0..15] of char;
  begin
    StrCopy(s, @Str[1]);
    StrUpper(s);
    j:=0;
    if StrLen(s) >= 8 then begin
      for i:=0 to 7 do begin
        if not (s[i] in ['0'..'9','A'..'F']) then begin
          s[i]:='0';
          Inc(j);
        end;
        if s[i] > '9' then  begin
           s[i]:=chr(ord(s[i]) - ord('A') + ord('9') + 1);
        end;
      end;
      with XC do begin
        i:=0; aa:=16*(ord(s[i])-ord('0'))+ord(s[i+1])-ord('0');
        i:=2; bb:=16*(ord(s[i])-ord('0'))+ord(s[i+1])-ord('0');
        i:=4; cc:=16*(ord(s[i])-ord('0'))+ord(s[i+1])-ord('0');
        i:=6; dd:=16*(ord(s[i])-ord('0'))+ord(s[i+1])-ord('0');
      end;
    end else begin
      LongInt(XC):=0;
    end;
    GetHEX:=LongInt(XC);
  end;
  procedure PaintLine(Index: integer; Col: PChar );
  var BrushColor: LongInt;
      TheOldBK: LongInt;
      TheOldBrush,Brush: HBrush;
      X,Y,DX,DY: LongInt;
  begin
    DX:=100;
    DY:=CH;
    Y:=(CH+2)*(Index div 2) + 80;
    X:=(Index Mod 2)*round(DX*2.5) + 6;
    BrushColor:=GetHEX(Col);
    if BrushColor <> 0 then begin
      Brush:=CreateSolidBrush(BrushColor);
      TheOldBrush:=SelectObject(PaintDC, Brush);
      TheOldBK:=SetBKMode(PaintDC, Transparent);
      PatBlt(PaintDC, X,Y,DX,DY, PatCopy);
    end;
    TextOut(PaintDC, X,Y, Col, StrLen(Col));
    if BrushColor <> 0 then begin
      TheOldBK:=SetBKMode(PaintDC, TheOldBK);
    end;
    x:=x + round(1.1*DX);
    TextOut(PaintDC, X,Y, Col, StrLen(Col));
    PatBlt(PaintDC, X,Y,DX,DY, PatInvert);
    if BrushColor <> 0 then begin
      SelectObject(PaintDC, TheOldBrush);
      DeleteObject(Brush);
    end;
  end;
  procedure xPaintLine(Index: integer; Col: PChar );
  var TextColor,OldTextColor: LongInt;
      X,Y,DX,DY: LongInt;
  begin
    DX:=50;
    DY:=CH;
    Y:=(CH+2)*(Index div 4) + 210;
    X:=(Index Mod 4)*round(DX*2.5) + 6;
    TextColor:=GetHEX(Col);
    OldTextColor:=SetTextColor(PaintDC, TextColor);
    TextOut(PaintDC, X,Y, Col, StrLen(Col));
    TextColor:=SetTextColor(PaintDC, OldTextColor);
  end;
begin
  otf:=SelectObject(PaintDC, TheFont);
  tc:=0;
  StrCopy(stc,'$00');
  StrHex(@stc[StrLen(stc)], TextColor[2]);
  StrHex(@stc[StrLen(stc)], TextColor[1]);
  StrHex(@stc[StrLen(stc)], TextColor[0]);
  tc:=GetHex(stc);
  StrCopy(xMsg, 'Text Color RGB (');
  if xRGB = 0 then StrCat(xMsg,'R') else
  if xRGB = 1 then StrCat(xMsg,'G') else
  if xRGB = 2 then StrCat(xMsg,'B') else
                   StrCat(xMsg,'*');
  StrCat(xMsg,'): ');
  StrCat(xMsg, stc);
  TextOut(PaintDC, 4,05, xMsg, StrLen(xMsg));
  StrCopy(xMsg, 'Use Left and Right Mouse Buttons');
  TextOut(PaintDC, 25,30, xMsg, StrLen(xMsg));
  StrCopy(xMsg, 'to Change the Color of the Text.');
  TextOut(PaintDC, 25,42, xMsg, StrLen(xMsg));
  if tc <> 0 then OTC:=SetTextColor(PaintDC, tc);
  PaintLine(00, '$00000000');
  PaintLine(01, '$01000000');
  PaintLine(02, '$01000001');
  PaintLine(03, '$01000002');
  PaintLine(04, '$01000003');
  PaintLine(05, '$01000004');
  PaintLine(06, '$01000005');
  PaintLine(07, '$01000006');
  PaintLine(08, '$01000007');
  PaintLine(09, '$0100000C');
  PaintLine(10, '$0100000D');
  PaintLine(11, '$0100000E');
  PaintLine(12, '$0100000F');
  PaintLine(13, '$01000010');
  PaintLine(14, '$01000011');
  PaintLine(15, '$01000012');
  if tc <> 0 then SetTextColor(PaintDC, otc);
  SelectObject(PaintDC, otf);
  xPaintLine(00, '$00000000');
  xPaintLine(01, '$00808080');
  xPaintLine(02, '$00000080');
  xPaintLine(03, '$000000FF');
  xPaintLine(04, '$00800000');
  xPaintLine(05, '$00FF0000');
  xPaintLine(06, '$00008000');
  xPaintLine(07, '$0000FF00');
  xPaintLine(08, '$00008080');
  xPaintLine(09, '$00800080');
  xPaintLine(10, '$00808000');
  xPaintLine(11, '$008000FF');
  xPaintLine(12, '$0000FFFF');
  xPaintLine(13, '$00FFFF00');
  xPaintLine(14, '$00FF00FF');
  xPaintLine(15, '$00FFFFFF');
end;

procedure TestWindow.WMLButtonDown(var Msg: TMessage);
begin
  if TextColor[xRGB] =   0 then TextColor[xRGB]:=128 else
  if TextColor[xRGB] = 128 then TextColor[xRGB]:=255 else
                                TextColor[xRGB]:=0;
  InvalidateRect(HWIndow, nil, true);
end;

procedure TestWindow.WMRButtonDown(var Msg: TMessage);
begin
  xRGB:=(xRGB + 1) mod 3;
  InvalidateRect(HWIndow, nil, true);
end;

{--------------------------------------------------}
{ Application:                                     }
{--------------------------------------------------}

procedure PaletteApplication.InitMainWindow;
begin
  MainWindow := New(PTestWindow,Init(nil, 'WINEDT 95:  Text Selections'));
end;

{--------------------------------------------------}
{ Main program:                                    }
{--------------------------------------------------}

var PalApp: PaletteApplication;

begin
  PalApp.Init('PaletteApp');
  PalApp.Run;
  PalApp.Done;
end.

