{Graphic button component for Borland Delphi
Public Domain
Last modified: 5/99}

unit GraphicBtn;

interface

uses
  Windows, Classes, Graphics, Controls;

type
  TGraphicBtn = class(TGraphicControl)
    constructor Create(aOwner: TComponent); override;
    destructor Destroy; override;
    procedure Paint; override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState;
      X, Y: integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: integer); override;
  private
    FPressed: boolean;
    FPressedLook: TBitMap;
    FOnClick: TNotifyEvent;
    procedure SetPressedLook(X: TBitMap);
  published
    property Enabled;
    property Hint;
    property ShowHint;
    property Pressed: boolean Read FPressed;
    property PressedLook: TBitMap Read FPressedLook Write SetPressedLook;
    property OnClick: TNotifyEvent Read FOnClick Write FOnClick;
  end;

procedure Register;

implementation

procedure Register;
begin
RegisterComponents('Samples',[TGraphicBtn]);
end;

constructor TGraphicBtn.Create;
begin
inherited Create(aOwner);
FPressedLook:=TBitMap.Create;
FPressed:=false;
FOnClick:=nil;
SetBounds(0,0,16,16);
end;

destructor TGraphicBtn.Destroy;
begin
FPressedLook.Free;
inherited Destroy
end;

procedure TGraphicBtn.SetPressedLook;
begin
FPressedLook.Assign(X);
Width:=FPressedLook.Width;
Height:=FPressedLook.Height;
Paint
end;

procedure TGraphicBtn.Paint;
begin
if FPressed or (csDesigning in ComponentState) then Canvas.Draw(0,0,FPressedLook)
end;

procedure TGraphicBtn.MouseDown;
begin MouseMove(Shift,X,Y) end;

procedure TGraphicBtn.MouseUp;
begin
if(Button=mbLeft) and FPressed then
  begin
  FPressed:=false;
  Invalidate;
  if @FOnClick<>nil then FOnClick(self)
  end;
end;

procedure TGraphicBtn.MouseMove;
begin
if ssLeft in Shift then
   if(X>=0) and (X<FPressedLook.Width) and (Y<FPressedLook.Height) and (Y>=0) then
     if not FPressed then begin FPressed:=true; Canvas.Draw(0,0,FPressedLook) end
   else else
     if FPressed then begin FPressed:=false; Invalidate end
end;

end.

