{Lady in Black CD Player
Main window source
Compiler: Borland Delphi 3(or later)

This file is PD
Note your changes, include credits
Last modified: 5/99

Homepage: www.steffengerlach.de/freeware
}

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Forms, Display, MPlayer, Menus, GraphicBtn, Registry, Dialogs,
  ExtCtrls, Controls;

type
TState=record
  Mode: TMPModes;
  Pos: integer;
  Meta:(Total,Play,Track,Pause,Error,Init);
  end;

  TForm1 = class(TForm)
    Display1: TDisplay;
    Display2: TDisplay;
    Display3: TDisplay;
    Timer1: TTimer;
    CD: TMediaPlayer;
    PopupMenu1: TPopupMenu;
    TextColor1: TMenuItem;
    DigitColor1: TMenuItem;
    Close1: TMenuItem;
    ColorDialog1: TColorDialog;
    GraphicBtn2: TGraphicBtn;
    GraphicBtn3: TGraphicBtn;
    GraphicBtn4: TGraphicBtn;
    GraphicBtn1: TGraphicBtn;
    CDlist1: TMenuItem;
    ArchiveBackground1: TMenuItem;
    ArchiveTextColor1: TMenuItem;
    SetColors1: TMenuItem;
    SetDrive1: TMenuItem;
    Frame1: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    Version101: TMenuItem;
    PublicDomain1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: char);
    procedure PlayBtnClick(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure BwdBtnClick(Sender: TObject);
    procedure FwdBtnClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure DigitColor1Click(Sender: TObject);
    procedure TextColor1Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure CDlist1Click(Sender: TObject);
    procedure ArchiveTextColor1Click(Sender: TObject);
    procedure ArchiveBackground1Click(Sender: TObject);
    procedure TextMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: integer);
    procedure DriveClick(Sender: TObject);
    procedure PopupMenu1Popup(Sender: TObject);
    procedure Frame1Click(Sender: TObject);
  private
    CursorCnt,IDLine,CDTracks,CDLength,Count: integer;
    Edit: TDisplay;
    f,f0,l,l0,Panel,p0,lo0,Logo,ba,bb,bc,bd: TBitMap;
    Dig: array[0..5] of byte;
    ID,Drive: string;
    State, LastState: TState;
    procedure DispDig(i,v: integer);
    procedure SetTColor;
    procedure setdcolor;
    procedure SetPColor(Src,Dst: TBitMap);
    procedure RemoveCursor;
  public
    CDig, CText, CArchiveText, CArchiveBack, CPanel: TColor;
    Data: TStringList;
    procedure HitTest(var Msg: TMessage); Message WM_NCHITTEST;
    procedure RButtonDown(var Msg: TMessage); Message WM_NCRBUTTONDOWN;
    procedure CreateParams(var p: TCreateParams); override;
    procedure OnEraseBkgnd(var m: TMessage); Message WM_ERASEBKGND;
  end;

var
  Form1: TForm1;

implementation

uses Unit2;

{$R *.DFM}
{$R CDP1.res}

const
Dark=90;{dark text segments in 1/256 of the lit}
Blink=2;
Red0=85; Blue0=122;

xTrack=24;
xTime=80;
xdig: array[0..5] of byte=
 (xTrack,xTrack+14,xTime,xTime+14,xTime+34,xTime+48);

procedure TForm1.CreateParams(var p: TCreateParams);
var
Reg: TRegistry;
begin
inherited CreateParams(p);
Reg:=TRegistry.Create;
if Reg.KeyExists('SOFTWARE\Steffen Gerlach\Lady in Black') then
  begin
  Reg.OpenKey('SOFTWARE\Steffen Gerlach\Lady in Black',false);
  p.X:=Reg.ReadInteger('x');
  p.Y:=Reg.ReadInteger('y');
  CPanel:=Reg.ReadInteger('Frame Color');
  CDig:=Reg.ReadInteger('Digit Color');
  CText:=Reg.ReadInteger('Text Color');
  CArchiveText:=Reg.ReadInteger('Archive Text Color');
  CArchiveBack:=Reg.ReadInteger('Archive Background');
  Drive:=Reg.ReadString('Drive');
  Reg.CloseKey;
  end
else
  begin
  CPanel:=$7A6755;
  CDig:=$FF8000;
  CText:=$00E0FF;
  CArchiveBack:=$402000;
  CArchiveText:=$FFAA55;
  Drive:='';
  end;
Reg.Free;
end;

procedure TForm1.FormCreate(Sender: TObject);

  function bmp2(var Src: TBitMap; rname: string): TBitMap;
  begin
  Src:=TBitMap.Create;
  Src.LoadFromResourceName(HInstance,rname);
  Result:=TBitMap.Create;
  Result.Width:=Src.Width; Result.Height:=Src.Height;
  end;

var
i: integer;
mi: TMenuItem;
begin
Count:=0;
Edit:=nil;
CursorCnt:=0;
Panel:=bmp2(p0,'p');
Logo:=bmp2(lo0,'x');
f:=bmp2(f0,'f');
l:=bmp2(l0,'l');
GraphicBtn1.PressedLook:=bmp2(ba,'ba');
GraphicBtn2.PressedLook:=bmp2(bb,'bb');
GraphicBtn3.PressedLook:=bmp2(bc,'bc');
GraphicBtn4.PressedLook:=bmp2(bd,'bd');

setdcolor;
SetTColor;
SetPColor(p0,Panel); SetPColor(lo0,Logo);
SetPColor(ba,GraphicBtn1.PressedLook);
SetPColor(bb,GraphicBtn2.PressedLook);
SetPColor(bc,GraphicBtn3.PressedLook);
SetPColor(bd,GraphicBtn4.PressedLook);
CD.TimeFormat:=tfTMSF;
FillChar(Dig,SizeOf(Dig),0);
Data:=TStringList.Create;
if FileExists(ExtractFilePath(ParamStr(0))+'CDData.txt') then
  Data.LoadFromFile(ExtractFilePath(ParamStr(0))+'CDData.txt');
for i:=0 to 25 do
  if GetDriveType(PChar(Chr(i+65)+':\'))=Drive_CDRom then
    begin
    mi:=TMenuItem.Create(PopupMenu1);
    mi.Caption:=Chr(i+65)+':';
    mi.OnClick:=DriveClick;
    SetDrive1.Add(mi);
    if Drive='' then Drive:=Chr(i+65)+':';
    end;

LastState.Meta:=Init;
State.Meta:=Error;
CD.FileName:=Drive;
CD.Open
end;

procedure TForm1.FormDestroy(Sender: TObject);
var Reg: TRegistry;
begin
Reg:=TRegistry.Create;
Reg.OpenKey('SOFTWARE\Steffen Gerlach\Lady in Black',true);
Reg.WriteInteger('x',Left);
Reg.WriteInteger('y',Top);
Reg.WriteInteger('Frame Color',CPanel);
Reg.WriteInteger('Digit Color',CDig);
Reg.WriteInteger('Text Color',CText);
Reg.WriteInteger('Archive Text Color',CArchiveText);
Reg.WriteInteger('Archive Background',CArchiveBack);
Reg.WriteString('Drive',CD.FileName);
Reg.CloseKey;
Reg.Free;

RemoveCursor;
Data.SaveToFile(ExtractFilePath(ParamStr(0))+'CDData.txt');
Data.Free;
f.Free; f0.Free;
l.Free; l0.Free;
Panel.Free; p0.Free;
Logo.Free; lo0.Free
end;

procedure TForm1.DispDig(i,v: integer);
begin
if v<>Dig[i] then
  begin
  BitBlt(Canvas.Handle,xdig[i],120,14,20,f.Canvas.Handle,v*14,0,SRCCOPY);
  Dig[i]:=v
  end
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
i,j: integer;
DTrack,DTime: integer;
Str,sar,sal: string;
begin
Inc(Count);

if Edit<>nil then
  if Active then
    begin
    CursorCnt:=(CursorCnt+1) mod(Blink*2);
    if CursorCnt=Blink then Edit.Text:=Edit.Text+'#'
    else if CursorCnt=0 then
      Edit.Text:=Copy(Edit.Text,1,Length(Edit.Text)-1)
    end
  else begin RemoveCursor; Edit:=nil end;

if(State.Meta<>Play) and (Count mod 8<>0) then Exit;
State.Mode:=CD.Mode;
if State.Mode=mpPlaying then State.Pos:=CD.Position;

if(State.Mode<>mpStopped) and (State.Mode<>mpPlaying) then
  State.Meta:=Error
else if(State.Meta=Error)
  and ((State.Mode=mpStopped) or(State.Mode=mpPlaying)) then
  begin
  ID:='~';
  CD.TimeFormat:=tfMSF;
  CDTracks:=CD.Tracks;
  CDLength:=CD.Length;
  for i:=1 to CDTracks do
    begin
    j:=CD.TrackLength[i];
    ID:=ID+char(48+j and $FF)
      +char(48+j shr 8 and $FF)+char(48+j shr 16 and $FF);
    end;
  CD.TimeFormat:=tfTMSF;
  IDLine:=0;
  while(IDLine<Data.Count) and (Data[IDLine]<>ID) do Inc(IDLine);
  if IDLine=Data.Count then
    begin
    Data.Add(ID);
    for i:=1 to CD.Tracks+1 do Data.Add('');
    end;
  if State.Mode=mpStopped then CD.Rewind;
  State.Meta:=Total
  end;

if(State.Mode<>LastState.Mode)
  or(State.Pos and $FFFFFF<>LastState.Pos and $FFFFFF)
  or(State.Meta<>LastState.Meta) then
  begin

  if State.Mode=mpPlaying then State.Meta:=Play
  else if(State.Mode=mpStopped) and (State.Meta=Play) then
    State.Meta:=Total;
  if(State.Meta<>LastState.Meta)
    or(State.Pos and $FF<>LastState.Pos and $FF) then
    begin {refresh track number und text lines}
    if State.Meta=Error then
      begin DTrack:=0; DTime:=0 end
    else if State.Meta=Total then
      begin DTrack:=CDTracks; DTime:=CDLength end
    else if(State.Meta=Pause) or(State.Meta=Play) then
      begin DTrack:=State.Pos and $FF; DTime:=State.Pos shr 8 end
    else
      begin
      DTrack:=State.Pos and $FF;
      DTime:=CD.TrackLength[DTrack]
      end;
    if State.Meta<Error then
      begin
      DispDig(0,DTrack div $A mod 10);
      DispDig(1,DTrack mod 10);
      end;
    if(State.Meta<Error)<>(LastState.Meta<Error) then Invalidate
    else if State.Meta<Error then BitBlt(Canvas.Handle,(xTrack+xTime) div 2+9,
      125,10,10,l.Canvas.Handle,Ord(State.Meta) mod 3*10,
      Ord(State.Meta) div 3*10,SRCCOPY);

    RemoveCursor;
    Edit:=nil;
    if State.Meta=Error then
      begin
      Application.Title:='Lady in Black';
      Form1.Caption:='Lady in Black';
      Display1.Visible:=false;
      Display2.Visible:=false;
      Display3.Visible:=false;
      GraphicBtn1.Enabled:=false;
      GraphicBtn2.Enabled:=false;
      GraphicBtn3.Enabled:=false;
      GraphicBtn4.Enabled:=false;
      end
    else
      begin
      sar:='';
      sal:=Data[IDLine+1];
      for i:=1 to Length(sal) do
        if(i=1) or not(sal[i-1] in['A'..'Z','a'..'z','0'..'9','''']) then
          if sal[i] in['a'..'z'] then Dec(sal[i],32);
      i:=Pos('|',sal);
      if i>0 then
        begin sar:=Copy(sal,i+1,MaxInt); Delete(sal,i,MaxInt) end;
      if State.Meta=Total then Str:=''
      else Str:=Data[IDLine+1+State.Pos and $FF];
      i:=Pos('|',Str);
      if i>0 then
        begin sar:=Copy(Str,i+1,MaxInt); Delete(Str,i,MaxInt) end;
      if sal='' then
        begin
        Application.Title:='Unknown CD';
        Form1.Caption:='Unknown CD';
        end
      else
        begin
        Application.Title:=sal;
        Form1.Caption:=sal;
        end;
      Display1.Text:=sar; Display1.Visible:=true;
      Display2.Text:=sal; Display2.Visible:=true;
      Display3.Text:=Str; Display3.Visible:=true;
      GraphicBtn1.Enabled:=true;
      GraphicBtn2.Enabled:=true;
      GraphicBtn3.Enabled:=true;
      GraphicBtn4.Enabled:=true;
      end
    end
  else DTime:=State.Pos shr 8;
  DispDig(2,DTime and $FF div $A mod 10);
  DispDig(3,DTime and $FF mod 10);
  DispDig(4,DTime and $FF00 div $A00 mod 10);
  DispDig(5,DTime and $FF00 div $100 mod 10);
  LastState:=State;
  end;
end;

procedure TForm1.RemoveCursor;
var
s,aa: string;
begin
if Edit<>nil then
  begin
  if CursorCnt>=Blink then
    begin
    Edit.Text:=Copy(Edit.Text,1,Length(Edit.Text)-1);
    CursorCnt:=0
    end;
  if Edit=Display1 {artist} then
    if LastState.Meta=Total then
      begin
      s:=Data[IDLine+1];
      if Pos('|',s)>0 then Delete(s,Pos('|',s),MaxInt);
      if Edit.Text<>'' then s:=s+'|'+Edit.Text;
      Data[IDLine+1]:=s
      end
    else
      begin
      aa:=Data[IDLine+1];
      if Pos('|',aa)=0 then aa:=''
      else Delete(aa,1,Pos('|',aa));
      s:=Data[IDLine+1+LastState.Pos and $FF];
      if Pos('|',s)>0 then Delete(s,Pos('|',s),MaxInt);
      if(Edit.Text<>aa) and (Edit.Text<>'') then s:=s+'|'+Edit.Text;
      Data[IDLine+1+LastState.Pos and $FF]:=s;
      end
  else {album/track}
    begin
    if Edit=Display2 then s:=Data[IDLine+1]
    else s:=Data[IDLine+1+LastState.Pos and $FF];
    if Pos('|',s)>0 then
      begin
      Delete(s,1,Pos('|',s)-1);
      Insert(Edit.Text,s,1);
      end
    else s:=Edit.Text;
    if Edit=Display2 then Data[IDLine+1]:=s
    else Data[IDLine+1+LastState.Pos and $FF]:=s;
    end
  end
end;

procedure TForm1.FormKeyPress(Sender: TObject; var Key: char);
var
s: string;
begin
if Edit<>nil then
  begin
  s:=Edit.Text;
  if CursorCnt>=Blink then
    if Key=#8 then
      if(Length(s)>1) then Delete(s,Length(s)-1,1)
    else else Insert(Key,s,Length(s))
  else if(Key=#8) then
    if(s<>'') then Delete(s,Length(s),1)
  else else s:=s+Key;
  Edit.Text:=s
  end
end;

procedure TForm1.PlayBtnClick(Sender: TObject);
begin
if State.Meta=Play then begin State.Meta:=Pause; CD.Stop end
else if State.Meta=Total then begin CD.StartPos:=1; CD.Play end
else begin CD.StartPos:=State.Pos; CD.Play end;
Count:=-1;
end;

procedure TForm1.StopBtnClick(Sender: TObject);
begin
CD.Stop;
State.Pos:=1;
State.Meta:=Total;
Count:=-1;
end;

procedure TForm1.BwdBtnClick(Sender: TObject);
begin
if State.Meta=Play then CD.Previous
else if State.Meta=Pause then
  begin State.Meta:=Track; State.Pos:=State.Pos and $FF end
else if(State.Meta=Track) and (State.Pos and $FF>1) then
  State.Pos:=State.Pos and $FF-1;
Count:=-1;
end;

procedure TForm1.FwdBtnClick(Sender: TObject);
begin
if State.Meta=Total then
  begin State.Meta:=Track; State.Pos:=1 end
else if State.Meta=Play then CD.Next
else if(State.Meta=Pause) and (State.Pos and $FF<CDTracks) then
  begin State.Meta:=Track; State.Pos:=State.Pos and $FF+1 end
else if(State.Meta=Track) and (State.Pos and $FF<CDTracks) then
  State.Pos:=State.Pos and $FF+1;
Count:=-1;
end;

procedure TForm1.SetTColor;
var
ctlo: TColor;
begin
ctlo:=(CText shr 16 and $FF *Dark) and $FF00 shl 8
  +(CText shr 8 and $FF *Dark) and $FF00+(CText and $FF *Dark) shr 8;
Display1.SegOnColor:=CText;
Display1.SegOffColor:=ctlo;
Display2.SegOnColor:=CText;
Display2.SegOffColor:=ctlo;
Display3.SegOnColor:=CText;
Display3.SegOffColor:=ctlo;
end;

procedure TForm1.setdcolor;

  procedure Put(Pic0,Pic: TBitMap; X,Y: integer);
  var
  r,g,b,iSeg: integer;
  begin
  iSeg:=Pic0.Canvas.Pixels[X,Y] and $FF;
  r:=(CDig and $FF *iSeg) shr 8;
  g:=(CDig shr 8 and $FF *iSeg) shr 8;
  b:=(CDig shr 16 *iSeg) shr 8;
  Pic.Canvas.Pixels[X,Y]:=r+g shl 8+b shl 16
  end;

var
X,Y: integer;
begin
for X:=0 to 34 do for Y:=0 to 43 do Put(l0,l,X,Y);
for X:=14*8 to 14*9-1 do for Y:=0 to 19 do Put(f0,f,X,Y);
for X:=140 to 145 do for Y:=0 to 19 do Put(f0,f,X,Y);
for X:=0 to 9 do if X<>8 then
  BitBlt(f.Canvas.Handle,X*14,0,14,20,f.Canvas.Handle,14*8,0,SRCCOPY);

for X:=0 to 139 do
  if(X<14*8) or(X>=14*9) then for Y:=0 to 19 do
    if f0.Canvas.Pixels[X,Y]<>f0.Canvas.Pixels[X mod 14+14*8,Y] then
      Put(f0,f,X,Y);

Invalidate
end;

procedure TForm1.SetPColor;
var
X,Y,p,Red,Green,Blue,pRed,pGreen,pBlue,Bias,sat: integer;
begin
pRed:=CPanel and $FF;
pGreen:=CPanel shr 8 and $FF;
pBlue:=CPanel shr 16 and $FF;
for X:=0 to Src.Width-1 do for Y:=0 to Src.Height-1 do
  begin
  p:=Src.Canvas.Pixels[X,Y];
  sat:=(p shr 16 and $FF-p and $FF);
  Bias:=p and $FF-sat*Red0 div(Blue0-Red0); if Bias<0 then Bias:=0;
  Red:=Bias+sat*pRed div(Blue0-Red0); if Red>$FF then Red:=$FF;
  Green:=Bias+sat*pGreen div(Blue0-Red0); if Green>$FF then Green:=$FF;
  Blue:=Bias+sat*pBlue div(Blue0-Red0); if Blue>$FF then Blue:=$FF;
  Dst.Canvas.Pixels[X,Y]:=Red+Green shl 8+Blue shl 16
  end;
Invalidate
end;

procedure TForm1.FormPaint(Sender: TObject);
var
i: integer;
begin
if State.Meta<Error then Canvas.Brush.Color:=$000000
else Canvas.Brush.Color:=CPanel;
Canvas.FillRect(Rect(0,0,ClientWidth,ClientHeight));
with Canvas do for i:=0 to 4 do
  begin
  MoveTo(383-i,i);
  Pen.Color:=Panel.Canvas.Pixels[55,39-i];
  LineTo(383-i,158-i); LineTo(i,158-i);
  Pen.Color:=Panel.Canvas.Pixels[55,4+i];
  LineTo(i,i); LineTo(383-i,i);
  end;
if State.Meta<Error then with Canvas do
  begin
  MoveTo(383-5,5);
  Pen.Color:=Panel.Canvas.Pixels[55,4+2];
  LineTo(383-5,158-5); LineTo(5,158-5);
  Pen.Color:=Panel.Canvas.Pixels[55,39-2];
  LineTo(5,5); LineTo(383-5,5);
  end;

if State.Meta<Error then
  begin
  for i:=0 to 5 do
    BitBlt(Canvas.Handle,xdig[i],120,14,20,f.Canvas.Handle,Dig[i]*14,0,
      SRCCOPY);
  BitBlt(Canvas.Handle,xTime+28,120,14,20,f.Canvas.Handle,140,0,
    SRCCOPY);
  BitBlt(Canvas.Handle,24,19,35,8,l.Canvas.Handle,0,20,SRCCOPY);
  BitBlt(Canvas.Handle,24,51,35,8,l.Canvas.Handle,0,28,SRCCOPY);
  BitBlt(Canvas.Handle,24,83,35,8,l.Canvas.Handle,0,36,SRCCOPY);
  BitBlt(Canvas.Handle,(xTrack+xTime) div 2+9,125,10,10,l.Canvas.Handle,
    Ord(State.Meta) mod 3*10, Ord(State.Meta) div 3*10,SRCCOPY);
  BitBlt(Canvas.Handle,159,119,202,40,Panel.Canvas.Handle,0,0,SRCCOPY);
  end
else BitBlt(Canvas.Handle,130,104,Logo.Width,Logo.Height,Logo.Canvas.Handle,
  0,0,SRCCOPY);
end;

procedure TForm1.HitTest(var Msg: TMessage);

  function ReClicked(x0,y0,x1,y1: integer): boolean;
  begin
  ReClicked:=(Msg.LParamLo>=Left+x0) and (Msg.LParamLo<=Left+x1)
    and (Msg.LParamHi>=Top+y0) and (Msg.LParamHi<=Top+y1)
  end;

  function CirClicked(X,Y,r2: integer): boolean;
  begin
  CirClicked:=Sqr(Msg.LParamLo-X-Left)+Sqr(Msg.LParamHi-Y-Top)<=r2
  end;

begin
if(State.Meta<Error) and (ReClicked(23,30,359,46) or ReClicked(23,62,359,78)
  or ReClicked(23,94,359,110) or CirClicked(194,139,256)
  or CirClicked(238,139,256) or CirClicked(282,139,256)
  or CirClicked(326,139,256)) then Msg.Result:=HTCLIENT
else Msg.Result:=HTCAPTION
end;

procedure TForm1.RButtonDown(var Msg: TMessage);
begin
PopupMenu1.Popup(Msg.LParamLo,Msg.LParamHi);
end;

procedure TForm1.DigitColor1Click(Sender: TObject);
begin
ColorDialog1.Color:=CDig;
if ColorDialog1.Execute then
  begin CDig:=ColorDialog1.Color; setdcolor end;
end;

procedure TForm1.TextColor1Click(Sender: TObject);
begin
ColorDialog1.Color:=CText;
if ColorDialog1.Execute then
  begin CText:=ColorDialog1.Color; SetTColor end;
end;

procedure TForm1.Close1Click(Sender: TObject);
begin
Close
end;

procedure TForm1.CDlist1Click(Sender: TObject);
begin
Form2.Show
end;

procedure TForm1.ArchiveTextColor1Click(Sender: TObject);
begin
ColorDialog1.Color:=Form2.List.Font.Color;
if ColorDialog1.Execute then Form2.List.Font.Color:=ColorDialog1.Color;
end;

procedure TForm1.ArchiveBackground1Click(Sender: TObject);
begin
ColorDialog1.Color:=Form2.List.Color;
if ColorDialog1.Execute then Form2.List.Color:=ColorDialog1.Color;
end;

procedure TForm1.OnEraseBkgnd(var m: TMessage);
begin
end;

procedure TForm1.TextMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: integer);
begin
if TDisplay(Sender).Visible then
  if Button=mbLeft then
    begin RemoveCursor; Edit:=TDisplay(Sender) end
  else if Button=mbRight then
    PopupMenu1.Popup(Left+TDisplay(Sender).Left+X,
      Top+TDisplay(Sender).Top+Y);
end;

procedure TForm1.DriveClick(Sender: TObject);
begin
State.Meta:=Error;
CD.FileName:=TMenuItem(Sender).Caption;
CD.Open;
end;

procedure TForm1.PopupMenu1Popup(Sender: TObject);
var
i: integer;
begin
for i:=0 to SetDrive1.Count-1 do
  SetDrive1[i].Checked:= SetDrive1[i].Caption=CD.FileName
end;

procedure TForm1.Frame1Click(Sender: TObject);
begin
ColorDialog1.Color:=CPanel;
if ColorDialog1.Execute then
  begin
  CPanel:=ColorDialog1.Color;
  SetPColor(p0,Panel);
  SetPColor(lo0,Logo);
  SetPColor(ba,GraphicBtn1.PressedLook);
  SetPColor(bb,GraphicBtn2.PressedLook);
  SetPColor(bc,GraphicBtn3.PressedLook);
  SetPColor(bd,GraphicBtn4.PressedLook);
  end;
end;

end.

