{12-Segment display component for Borland Delphi
Public Domain
Last modified: 5/99}

unit Display;

interface

uses
  Messages, Windows, Classes, Graphics, Controls;

type
  TDisplay = class(TGraphicControl)
    constructor Create(aOwner: TComponent); override;
    destructor Destroy; override;
    procedure Paint; override;
  private
    FLength: integer;
    FColor,FSegOnColor,FSegOffColor: TColor;
    f,f0: TBitMap;
    FText: string;
    FOnClick: TNotifyEvent;
    procedure SetText(X: string);
    procedure SetLength(X: integer);
    procedure SetColor(X: TColor);
    procedure SetSegOnColor(X: TColor);
    procedure SetSegOffColor(X: TColor);
    procedure SetF;
  published
    property Visible;
    property Length: integer Read FLength Write SetLength;
    property Text: string Read FText Write SetText;
    property Color Read FColor Write SetColor;
    property SegOnColor: TColor Read FSegOnColor Write SetSegOnColor;
    property SegOffColor: TColor Read FSegOffColor Write SetSegOffColor;
    property OnClick;
    property OnDblClick;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
end;

procedure Register;

implementation

procedure Register;
begin
RegisterComponents('Samples',[TDisplay]);
end;

{$R Display.res}

const
Mat: array[32..90,0..4] of byte=
 ((0,0,0,0,0),(2,2,2,0,2),(10,10,0,0,0),(15,15,15,15,15),(0,0,0,15,15),
 (3,11,6,13,12),(2,5,2,13,10),(2,2,0,0,0),(4,2,2,2,4),(2,4,4,4,2),
 (0,10,4,10,0),(0,4,14,4,0),(0,0,6,4,2),(0,0,14,0,0),(0,0,0,0,2),
 (0,8,4,2,1),(6,9,9,9,6),(4,6,4,4,4),(7,8,6,1,15),(7,8,6,8,7),
 (4,6,5,15,4),(15,1,7,8,7),(6,1,7,9,6),(15,9,4,2,2),(6,9,6,9,6),
 (6,9,14,8,6),(0,2,0,2,0),(0,4,0,4,2),(4,2,1,2,4),(0,14,0,14,0),
 (2,4,8,4,2),(3,4,2,0,2),(6,13,13,1,6),(6,9,9,15,9),(7,9,7,9,7),
 (14,1,1,1,14),(7,9,9,9,7),(15,1,7,1,15),(15,1,7,1,1),(14,1,13,9,6),
 (9,9,15,9,9),(14,4,4,4,14),(15,8,8,9,6),(9,5,3,5,9),(1,1,1,1,15),
 (9,15,9,9,9),(9,11,13,9,9),(6,9,9,9,6),(7,9,9,7,1),(6,9,9,6,12),
 (7,9,7,5,9),(14,1,6,8,7),(14,4,4,4,4),(9,9,9,9,14),(9,9,9,6,2),
 (9,9,9,15,9),(9,9,6,9,9),(9,9,14,8,6),(15,8,6,1,15));

constructor TDisplay.Create;
begin
inherited Create(aOwner);
FOnClick:=nil;
f0:=TBitMap.Create;
f0.LoadFromResourceName(HInstance,'m');
f:=TBitMap.Create;
f.Width:=224; f.Height:=16;
FColor:=clBlack;
FSegOnColor:=clLime;
FSegOffColor:=clGreen;
SetF;
FLength:=10;
FText:='';
SetBounds(0,0,140,16);
end;

destructor TDisplay.Destroy;
begin
f.Free;
f0.Free;
inherited Destroy
end;

procedure TDisplay.Paint;
var
i,ch,Y: integer;
begin
for i:=1 to FLength do
  if i<=System.Length(FText) then
    begin
    ch:=byte(FText[i]);
    while ch>=91 do Dec(ch,32);
    if ch<32 then ch:=32;
    for Y:=0 to 4 do
      BitBlt(Canvas.Handle,(i-1)*14,1+Y*3,14,2,f.Canvas.Handle,
        Mat[ch,Y]*14,1+Y*3,SRCCOPY)
    end
  else BitBlt(Canvas.Handle,(i-1)*14,0,14,16,f.Canvas.Handle,0,0,SRCCOPY);
end;

procedure TDisplay.SetText(X: string);
var
i,ch,Y: integer;
begin
for i:=1 to FLength do
  if i<=System.Length(X) then
    if(i>System.Length(FText)) or(X[i]<>FText[i]) then
      begin
      ch:=byte(X[i]);
      while ch>=91 do Dec(ch,32);
      if ch<32 then ch:=32;
      for Y:=0 to 4 do
        BitBlt(Canvas.Handle,(i-1)*14,1+Y*3,14,2,f.Canvas.Handle,
          Mat[ch,Y]*14,1+Y*3,SRCCOPY)
      end
  else else if i<=System.Length(FText) then
    BitBlt(Canvas.Handle,(i-1)*14,0,14,16,f.Canvas.Handle,0,0,SRCCOPY);
FText:=X
end;

procedure TDisplay.SetLength(X: integer);
begin
FLength:=X;
Width:=14*FLength;
Invalidate
end;

procedure TDisplay.SetColor(X: TColor);
begin
FColor:=X;
SetF;
Invalidate
end;

procedure TDisplay.SetSegOnColor(X: TColor);
begin
FSegOnColor:=X;
SetF;
Invalidate
end;

procedure TDisplay.SetSegOffColor(X: TColor);
begin
FSegOffColor:=X;
SetF;
Invalidate
end;

procedure TDisplay.SetF;
const
PixOffs: array[0..4] of byte=(2,1,1,1,0);
var
i,FLength,iSeg,iback,m,xp,yp,X,Y,r,g,b: integer;
begin
for X:=0 to 13 do for Y:=0 to 15 do
  begin
  m:=f0.Canvas.Pixels[X,Y];
  iSeg:=m and $FF; iback:=255-iSeg;
  r:=(FSegOffColor and $FF *iSeg +FColor and $FF *iback) shr 8;
  g:=(FSegOffColor shr 8 and $FF *iSeg +FColor shr 8 and $FF *iback) shr 8;
  b:=(FSegOffColor shr 16 *iSeg +FColor shr 16 *iback) shr 8;
  f.Canvas.Pixels[X,Y]:=r+g shl 8+b shl 16
  end;
BitBlt(f.Canvas.Handle,14,0,14,16,f.Canvas.Handle,0,0,SRCCOPY);
for Y:=0 to 4 do for xp:=0 to 2 do for yp:=1 to 2 do
  begin
  m:=f0.Canvas.Pixels[PixOffs[Y]+xp,3*Y+yp];
  iSeg:=m and $FF; iback:=255-iSeg;
  r:=(FSegOnColor and $FF *iSeg +FColor and $FF *iback) shr 8;
  g:=(FSegOnColor shr 8 and $FF *iSeg +FColor shr 8 and $FF *iback) shr 8;
  b:=(FSegOnColor shr 16 *iSeg +FColor shr 16 *iback) shr 8;
  f.Canvas.Pixels[14 +PixOffs[Y]+xp,3*Y+yp]:=r+g shl 8+b shl 16
  end;

for i:=1 to 3 do
  begin
  BitBlt(f.Canvas.Handle,1 shl i *14,0,1 shl i*14,16,f.Canvas.Handle,0,0,
    SRCCOPY);
  for FLength:=0 to 1 shl i-1 do for Y:=0 to 4 do
    BitBlt(f.Canvas.Handle,1 shl i *14 +FLength*14 +3*i+PixOffs[Y],3*Y+1,
      3,2,f.Canvas.Handle,14+PixOffs[Y],3*Y+1,SRCCOPY)
  end
end;

end.

