@Echo off

REM Installation for Intelligent 3D Icons v1.1
REM by Albert Kan
REM Email: syk108@email.psu.edu
REM Homepage: http://www.personal.psu.edu/syk108
REM October 1, 1996

REM ------------------------------------------------------------
REM Copy Section Start.
REM ------------------------------------------------------------

if not exist %WinDir%\Command\Attrib.exe goto Err
if exist %WinDir%\Command\Xcopy.exe set XCOPY=TRUE
if exist %WinDir%\Command\Choice.com set CHOICE=TRUE

:StartCopy
Echo Copying Files...

if not %XCOPY%==TRUE goto NoInstall

%WinDir%\Command\Xcopy *.* "C:\Program Files\Shell Icons\" > nul

Goto CheckCopy

:NoInstall

Md "C:\Program Files\Shell Icons\"

Copy *.* "C:\Program Files\Shell Icons" > nul
Goto CheckCopy

:CheckCopy
If exist "C:\Program Files\Shell Icons\!Readme.txt" goto OK
Echo Files Copy Failed.
Pause
Goto End

:OK
Echo Files Copy Completed.
Echo .

REM ------------------------------------------------------------
REM Copy Section Ends.
REM ------------------------------------------------------------


REM ------------------------------------------------------------
REM Update Section Starts.
REM ------------------------------------------------------------

:Questions
if not %CHOICE%==TRUE goto NoChoice
Goto OKQuestion

:OKQuestion
Echo Backup existing Registry Configuration? [y/n]
Echo Note: Extra space for the Registry file is needed.
Echo If you don't backup, you will have to uninstall manually.
%WinDir%\Command\Choice /n /c:yn
if errorlevel 2 goto NoBackup

Echo .
Echo Backing up existing Registry file...

:startBackup
%WinDir%\Command\Attrib.exe -r -s -h "%WinDir%\System.dat"
%WinDir%\Command\Attrib.exe -r -s -h "%WinDir%\User.dat"

if not %XCOPY%==TRUE goto NoXCOPY

%WinDir%\Command\Xcopy %WinDir%\System.dat "C:\Program Files\Shell Icons\Registry Backup -- System.dat.bak" /y /i > nul
%WinDir%\Command\Xcopy %WinDir%\User.dat "C:\Program Files\Shell Icons\Registry Backup -- User.dat.bak" /y /i > nul

:contback
%WinDir%\Command\Attrib.exe +r +s +h "%WinDir%\System.dat"
%WinDir%\Command\Attrib.exe +r +s +h "%WinDir%\User.dat"

if exist "C:\Program Files\Shell Icons\Registry Backup -- System.dat.bak" goto Next
Goto BackupError
:Next
if exist "C:\Program Files\Shell Icons\Registry Backup -- User.dat.bak" goto ContinueSetup
Goto BackupError

:NoXCOPY
copy %WinDir%\System.dat "C:\Program Files\Shell Icons\Registry Backup -- System.dat.bak" /y > nul
copy %WinDir%\User.dat "C:\Program Files\Shell Icons\Registry Backup -- User.dat.bak" /y > nul
goto contback

:BackupError
Echo .
Echo Cannot backup System Registry.
Goto ErrCommon

:ContinueSetup
Echo .
Echo .
Echo Backup completed.
Echo .
Echo .

Echo Do you have TWEAKUI? [y/n]
%WinDir%\Command\Choice /n /c:ny
if errorlevel 2 goto TWEAKUI

Echo .
Echo Do you want me to update your icon cache? [y/N]
%WinDir%\Command\Choice /n /c:yn
if errorlevel 2 goto NoUpdate
goto Update

:Update
Echo .
Echo Delete "ShellIconCache"? (Icon cache file used in Windows 95)
Echo Note: If you don't delete the file, new icons may not display properly.
Echo Continue? [y/n]
%WinDir%\Command\Choice /n /c:ny
if errorlevel 2 goto delete
goto NoUpdate

:Delete
if exist "%WinDir%\ShellIconCache" %WinDir%\Command\Attrib.exe -r -s -h "%WinDir%\ShellIconCache"
if exist "%WinDir%\ShellIconCache" del "%WinDir%\ShellIconCache"

if exist "%WinDir%\ShellIconCache" goto delError
Echo .
Echo Icons Cache is deleted.
goto Remove

:Remove
Echo.
Echo Remove the temporary directory you create and restart windows.

Echo .
Echo .

Pause
Goto End

:TWEAKUI
Echo .
Echo You indicate that you have TWEAKUI. Use TWEAKUI in Control Panel to rebuild icons.
Echo (Control Panel/TWEAKUI/Repair)
goto Remove

:delError
Echo .
Echo .
Echo Cannot delete "ShellIconsCache"
Goto ErrCommon

:Err
:Err
Echo .
Echo Cannot find Attrib.exe, uninstall cannot continue.
Goto ErrCommon

:ErrCommon
Echo .
Echo Please contact me at syk108@email.psu.edu
Echo .
pause
goto End

:NoChoice
Echo .
Echo Cannot Choice.exe in Windows Directory.
goto ErrCommon

:NoUpdate
Echo .
Echo "ShellIconCache" is not updated, new icons may not be displayed correctly.
goto Remove

REM ------------------------------------------------------------
REM Update Section End.
REM ------------------------------------------------------------

:End
set XCOPY=
set CHOICE=

REM [End of Program] (EOF)