unit restfmu;

// Copyright  1999 by Ziff-Davis, Inc.
// Written by Neil J. Rubenking

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, in4Share;

type
  TRtRebootForm = class(TForm)
    imgIco   : TImage;
    Label1   : TLabel;
    rbDisk   : TRadioButton;
    rbTime   : TRadioButton;
    rbNone   : TRadioButton;
    btnhelp  : TButton;
    btnOK    : TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure rbShareClick(Sender: TObject);
    procedure btnHelpClick(Sender: TObject);
  private
    { Private declarations }
    Opt : String;
  public
    { Public declarations }
    RtTrackMode : TTrackMode;
  end;

var
  RtRebootForm: TRtRebootForm;

implementation
uses IniFiles;

{$R *.DFM}

procedure TRtRebootForm.FormCreate(Sender: TObject);
begin
  RtTrackMode := tmDisk;
  imgIco.Picture.Icon.Handle := LoadIcon(0, IDI_EXCLAMATION);
  Opt := Name+ ' Settings';
  WITH TIniFile.Create(iniName) DO
  try
    Left   := ReadInteger(Opt, 'Left', (Screen.Width - Width) DIV 2);
    IF Left + Width > Screen.Width THEN
      Left := Screen.Width - Width;
    Top    := ReadInteger(Opt, 'Top', (Screen.Height -Height) DIV 2);
    IF Top + Height > Screen.Height THEN
      Top := Screen.Height - Height;
  finally
    Free;
  end;
  MessageBeep(MB_ICONSTOP);
end;

procedure TRtRebootForm.FormDestroy(Sender: TObject);
begin
  WITH TIniFile.Create(iniName) DO
  try
    WriteInteger(Opt, 'Left',   Left);
    WriteInteger(Opt, 'Top',    Top);
  finally
    Free;
  end;
end;

procedure TRtRebootForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  // ONLY close via OK button
  CanClose := Modalresult = mrOK;
  IF NOT CanClose THEN MessageBeep(0);
end;

procedure TRtRebootForm.rbShareClick(Sender: TObject);
begin
  RtTrackMode := TTrackMode((Sender AS TRadioButton).Tag);
end;

procedure TRtRebootForm.btnHelpClick(Sender: TObject);
begin
  Application.HelpContext(69);
end;

end.

