unit mainu;

// Copyright  1999 by Ziff-Davis, Inc.
// Written by Neil J. Rubenking

//TODO: Look into making it work with DOS-based and 16-bit programs.
//TODO: Make sure real-time reporting NOT enabled in NT4

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ActnList, Buttons, in4share, pdthdu,
  ComCtrls;

type
  TTrackStat = (tsSetup, tsPreInst, tsInstall, tsPostInst,
    tsAllDone);
  TMainForm = class(TForm)
    bvlMain            : TBevel;
    imgMain            : TImage;
    btnHelp            : TButton;
    btnAbout           : TButton;
    OpenDialog1        : TOpenDialog;
    SaveDialog1        : TSaveDialog;
    tmr5Min            : TTimer;
    tmrReadyRest       : TTimer;
    tmrRestart         : TTimer;
    ActionList1        : TActionList;
      aPrepare         : TAction;
    nbMain             : TNotebook;
      // Setup page
      Label1           : TLabel;
      btnBrowse        : TButton;
      ebInstallProg    : TEdit;
      lbExeType        : TStaticText;
      ebParams         : TEdit;
      ebName           : TEdit;
      btnSelect        : TButton;
      ebReportName     : TEdit;
      gbTrackMode      : TGroupBox;
        rbTmReal       : TRadioButton;
        rbTmTime       : TRadioButton;
        rbTmDisk       : TRadioButton;
      gbTrackOpt       : TGroupBox;
        btnDisk        : TButton;
        btnINI         : TButton;
        btnReg         : TButton;
      btnPath          : TButton;
      btnInstall       : TBitBtn;
      btnCancel        : TButton;
      // Tracking page
      pnlStatEye      : TPanel;
        imStatEye     : TImage;
      lbStat0         : TStaticText;
      lbStat1         : TStaticText;
      lbStat2         : TStaticText;
      lbStat3         : TStaticText;
      btnInstDone     : TButton;
      lbStat4         : TStaticText;
      lbStat5         : TStaticText;
      lbStat6         : TStaticText;
      lbStat7         : TStaticText;
      lbStat8         : TStaticText;
      lbStat9         : TStaticText;
      lbStat10        : TStaticText;
      lbStat11        : TStaticText;
      lbStatus        : TStaticText;
      btnCancel2      : TButton;
      lbReportName    : TStaticText;
      btnLaunch       : TButton;
      btnDone         : TButton;
    meRept: TRichEdit;
    stPlease: TStaticText;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure aPrepareUpdate(Sender: TObject);
    procedure aPrepareClick(Sender: TObject);
    procedure tmr5MinTimer(Sender: TObject);
    procedure btnHelpClick(Sender: TObject);
    procedure btnAboutClick(Sender: TObject);
    procedure btnBrowseClick(Sender: TObject);
    procedure ebInstallProgChange(Sender: TObject);
    procedure ebParamsChange(Sender: TObject);
    procedure btnSelectClick(Sender: TObject);
    procedure ebReportNameChange(Sender: TObject);
    procedure rbTmClick(Sender: TObject);
    procedure btnPathClick(Sender: TObject);
    procedure btnDiskClick(Sender: TObject);
    procedure btnINIClick(Sender: TObject);
    procedure btnRegClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure btnInstDoneClick(Sender: TObject);
    procedure btnLaunchClick(Sender: TObject);
    procedure tmrRestartTimer(Sender: TObject);
    procedure tmrReadyRestTimer(Sender: TObject);
  private
    { Private declarations }
    lbStat         : ARRAY[0..11] OF TStaticText;
    Opt            : String;
    OPath          : String;
    InstPath       : String;
    ReptPath       : String;
    TempPath       : String;
    LastRept       : Integer; // 1=txt, 2=csv
    Obsfucator     : DWORD;
    InstallExeType : Integer;
    TrackMode      : TTrackMode;
    ReTrackMode    : TTrackMode;
    DirList        : TStringList;
    IniList        : TStringList;
    RegList        : TStringList;
    StatMask       : Integer;
    StartTime      : TFileTime;
    TrackStatus    : TTrackStat;
    NeedRestart    : Integer;
    TwoPhase       : Integer; //1=two-phase, 2=restart, 3=supp
    OKDelete       : Boolean;
    TextReport     : Boolean;
    LPT            : TLaunchProgThread;
    procedure WMQueryEndSession(VAR Msg: TWMQueryEndSession);
      message WM_QUERYENDSESSION;
    function GetObsfucator(VAR U : DWORD) : Boolean;
    function DefaultReportName : String;
    procedure AdjustTrackModes;
    procedure ExecInstall;
    procedure PlaceEye(idx : Integer);
    procedure LaunchDone(Sender: TObject);
    procedure UpdateStatus(const S : String);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

uses ctrltrap, shlobj, ActiveX, Registry,
  IniFiles, FileCtrl, diskoptu, inioptu, regoptu, in32INIu,
  in32Regu, in32dsku, AboutBox, pathsu, ShellApi, restfmu;

{$R *.DFM}
{$R ICONS.RES}

const
  // StatMask constants - they determine which of the pre-
  // and post-install activities occur
  smPre_RecINI = $001; //000000000001
  smPre_RecREG = $002; //000000000010
  smPre_RecDSK = $004; //000000000100
  smDo_Install = $008; //000000001000
  smPostRecINI = $010; //000000010000
  smPostCmpINI = $020; //000000100000
  smPostRecREG = $040; //000001000000
  smPostCmpREG = $080; //000010000000
  smPostRecDSK = $100; //000100000000
  smPostCmpDSK = $200; //001000000000
  smPostDoTime = $400; //010000000000
  smPostAnalyz = $800; //100000000000

  StatMaskReal = smPre_RecINI OR smDo_Install OR smPostRecINI OR
    smPostCmpINI OR smPostAnalyz;
  StatMaskTime = smPre_RecINI OR smPre_RecREG OR smDo_Install OR
    smPostRecINI OR smPostCmpINI OR smPostRecREG OR smPostCmpREG OR
    smPostDoTime;
  StatMaskDisk = smPre_RecINI OR smPre_RecREG OR smPre_RecDSK OR
    smDo_Install OR smPostRecINI OR smPostCmpINI OR smPostRecREG OR
    smPostCmpREG OR smPostRecDSK OR smPostCmpDSK;
  StatMaskXDOS = smPre_RecDSK OR smDo_Install OR smPostRecDSK OR
    smPostCmpDSK OR smPostDoTime OR smPostAnalyz;
  StatMaskXRet = smPre_RecINI OR smPre_RecREG OR smPre_RecDSK;
  StatMaskXAft = smPostRecINI OR smPostCmpINI OR smPostRecREG OR
    smPostCmpREG OR smPostRecDSK OR smPostCmpDSK OR smPostDoTime;

const
  // Constants for notebook pageindex
  nb_InstallAProg = 0;
  nb_ReadyInstall = 1;
  nb_ProgComplete = 2;
  TPStr : ARRAY[0..2] OF String = ('', 'Two-phase',
    'Windows Restart');

procedure TMainForm.FormCreate(Sender: TObject);
VAR
  buffer : ARRAY[0..MAX_PATH] OF Char;
  P      : PChar;
  S      : String;
  SM, N  : Integer;
  temps  : TStringList;
begin
  LPT := nil;
  OPath := FinSlash(lowercase(ExtractFileDir(Application.ExeName)));
  Application.HelpFile := ChangeFileExt(Application.ExeName,
    '.HLP');
  // Initialize the lbStat array to point at components
  // lbStat0 thru lbStat11
  FOR N := 0 TO 11 DO lbStat[N] := FindComponent('lbStat'+
    IntToStr(N)) AS TStaticText;
  DirList            := TStringList.Create;
  IniList            := TStringList.Create;
  RegList            := TStringList.Create;
  TrackMode          := tmReal;
  ReTrackMode        := tmNone;
  IF (ParamCount > 0) AND (lowercase(ParamStr(1))='debug') THEN
    OKDelete         := False
  ELSE OKDelete      := True;
  TrackStatus        := tsSetup;
  TwoPhase           := 0;
  NeedRestart        := 0;
  TextReport         := True;
  InstallExeType     := ET_BLANK;
  nbMain.PageIndex   := 0;
  Opt                := 'Settings';
  AdjustTrackModes;
  IF NOT GetObsfucator(Obsfucator) THEN
    begin
      MessageBox(Handle, 'Windows refused InCtrl4 access to '+
        'a value required for real-time reporting. Real-time '+
        'reporting will be disabled.', 'InCtrl4',
        MB_OK OR MB_ICONINFORMATION);
      rbTmReal.Enabled := False;
      IF rbTmReal.Checked THEN
        begin
          rbTmReal.Checked := False;
          rbTmDisk.Checked := True;
          TrackMode        := tmDisk;
        end;
    end;
  temps := TStringList.Create;
  WITH TIniFile.Create(IniName) DO
  try
    LastRept := ReadInteger(Opt, 'LastRept', 1);
    TextReport := LastRept = 1; 
    InstPath := FinSlash(ReadString(Opt, 'InstPath', 'c:\'));
    ReptPath := FinSlash(ReadString(Opt, 'ReptPath', OPath));
    ebReportName.Text := DefaultReportName;
    TempPath := FinSlash(ReadString(Opt, 'TempPath', OPath));
    Left := ReadInteger(Opt, 'Left', (Screen.Width - Width) DIV 2);
    IF Left + Width > Screen.Width THEN
      Left := Screen.Width - Width;
    Top := ReadInteger(Opt, 'Top', (Screen.Height - Height) DIV 2);
    IF Top + Height > Screen.Height THEN
      Top := Screen.Height - Height;
    //!!0.1 Read preferred tracking mode from .INI file
    TrackMode := TTrackMode(ReadInteger(Opt, //!!0.1
      'TrackMode', Integer(tmReal)));        //!!0.1
    CASE TrackMode OF                        //!!0.1
      tmReal : rbTmReal.Checked := True;     //!!0.1
      tmTime : rbTmTime.Checked := True;     //!!0.1
      tmDisk : rbTmDisk.Checked := True;     //!!0.1
    END;                                     //!!0.1
    // Read drive-tracking info from .INI file, or use default
    IF ReadBool(Opt, 'DrivesInitialized', False) THEN
      begin
        ReadSection('Drives', temps);
        FOR N := 0 TO temps.count-1 DO
          begin
            S := ReadString('Drives', temps[N], '');
            IF (S <> '') AND DirectoryExists(S) THEN
              AddToHierList(DirList, S);
          end;
      end
    ELSE
      begin
        GetLogicalDriveStrings(MAX_PATH, buffer);
        P := buffer;
        WHILE P[0] <> #0 DO
          begin
            IF GetDriveType(P) = DRIVE_FIXED THEN
              DirList.Add(lowercase(StrPas(P)));
            P := StrEnd(P)+1;
          end;
      end;
    // Read INI file list from .INI file, or use default
    IF ReadBool(Opt, 'INIsInitialized', False) THEN
      begin
        ReadSection('INIs', temps);
        FOR N := 0 TO temps.count-1 DO
          begin
            S := ReadString('INIs', temps[N], '');
            IF (S <> '') AND FileExists(S) AND ValidINI(S) THEN
              IniList.Add(S);
          end;
      end
    ELSE
      begin
        IniList.Add(windir+'win.ini');
        IniList.Add(windir+'system.ini');
        IniList.Add(windir+'control.ini');
      end;
    // Read Keys to ignore, or use default
//!!0.1    IF ReadBool(Opt, 'KeysInitialized', False) THEN
    IF ReadBool(Opt, 'RegInitialized', False) THEN
      begin
//!!0.1        ReadSection('Keys', temps);
        ReadSection('Regs', temps);
        FOR N := 0 TO temps.count-1 DO
          begin
//!!0.1            S := ReadString('Keys', temps[N], '');
            S := UpperCase(ReadString('Regs', temps[N], ''));
            IF (S <> '') AND ValidReg(S) THEN
              AddToHierList(RegList, S);
          end;
      end;
    // Are we restarting in two-phase mode? If so, read
    // and delete data about the restart.
    TwoPhase := ReadInteger('TwoPhase', 'TwoPhase', 0);
    IF TwoPhase = 0 THEN Exit;
    IF TwoPhase = 1 THEN
      begin
        MessageBeep(MB_ICONQUESTION);
        IF MessageDlg('InCtrl4 performed its pre-install data '+
          'recording the last time it was executed. It is now '+
          'ready to perform post-install data recording, and '+
          'produce a report. Should it do so? If you answer No, '+
          'the pre-install data will be discarded.', mtConfirmation,
          [mbYes, mbNo], 0) <> idYes THEN
          begin
            EraseSection('TwoPhase');
            Exit;
          end;
      end;
    ebName.Text := ReadString('TwoPhase', 'ReportDesc', ebName.Text);
    ebReportName.Text := ReadString('TwoPhase', 'ReportName',
      ebReportName.Text);
    ebInstallProg.Text := ReadString('TwoPhase', 'InstallProg',
      ebInstallProg.Text);
    WITH StartTime DO
      begin
        dwLowDateTime := DWORD(ReadInteger('TwoPhase',
          'TimeLo', -1));
        dwHighDateTime := DWORD(ReadInteger('TwoPhase',
          'TimeHi', -1));
      end;
    TrackMode := TTrackMode(ReadInteger('TwoPhase',
      'TrackMode', Integer(tmDisk)));
    IF TrackMode = tmTime THEN StatMask := StatMaskTime
    ELSE StatMask := StatMaskDisk;
    StatMask := ReadInteger('TwoPhase', 'StatMask',StatMask);
    SM := StatMask;
    FOR N := 0 TO 11 DO
      begin
        lbStat[N].Enabled := Odd(SM);
        SM := SM DIV 2;
      end;
    nbMain.PageIndex := nb_ReadyInstall;
    Show;
    Application.ProcessMessages;
    EraseSection('TwoPhase');
    LaunchDone(Self);
  finally
    Free;
    temps.Free;
  end;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  WITH TIniFile.Create(IniName) DO
  try
    WriteInteger(Opt, 'LastRept', LastRept);
    WriteString(Opt, 'InstPath', InstPath);
    WriteInteger(Opt, 'Left', Left);
    WriteInteger(Opt, 'Top', Top);
    WriteInteger(Opt, 'TrackMode', Integer(TrackMode)); //!!0.1
  finally
    Free;
  end;
end;

procedure TMainForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
VAR
  N : Integer;
  S : String;
begin
  IF IsWatching THEN StopWatching;
  IF (TwoPhase = 0) AND OKDelete THEN
    begin
      DeleteFile(TempPath + TempName + TempExt1);
      DeleteFile(TempPath + TempName + TempExt2);
      DeleteFile(TempPath + RegName  + TempExt1);
      DeleteFile(TempPath + RegName  + TempExt2);
      DeleteFile(TempPath + DevName  + TempExt1);
      DeleteFile(TempPath + DevName  + TempExt2);
      FOR N := 0 TO IniList.Count-1 DO
        BEGIN
          S := ChangeFileExt(TempPath + SafeName(IniList[N]),
            TempExt1);
          DeleteFile(S);
          S := ChangeFileExt(S, TempExt2);
          DeleteFile(S);
        END;
    end;
  CASE NeedRestart OF
    1 : ExitWindowsEx(EWX_REBOOT, 0);
    2 : ExitWindowsEx(EWX_LOGOFF, 0);
  end;
end;

procedure TMainForm.FormCloseQuery(Sender: TObject; var CanClose:
  Boolean);
begin
  IF TrackStatus IN [tsSetup, tsAllDone] THEN CanClose := True
  ELSE
    begin
      MessageBeep(MB_ICONQUESTION);
      IF (LPT <> nil) AND LPT.UsingDebug THEN
        CanClose := MessageDlg('InCtrl4 is tracking an install '+
          'program at this time, with the ability to detect '+
          'secondary install programs. Because this ability is '+
          'enabled, closing InCtrl4 will *HALT* the install '+
          'program. This is not recommended. Do you really want '+
          'to close InCtrl4?', mtWarning,
          [mbyes, mbNo], 0) = idYes
      ELSE
        CanClose := MessageDlg('InCtrl4 is tracking '+
          'an install program at this time. If you close InCtrl4, '+
          'you will not get a report on this installation. Do you '+
          'really want to close InCtrl4?', mtConfirmation,
          [mbyes, mbNo], 0) = idYes;
    end;
end;

procedure TMainForm.aPrepareUpdate(Sender: TObject);
begin
  IF NOT (rbTmReal.Checked OR rbTmTime.Checked OR
    rbTmDisk.Checked) THEN
      (Sender AS TAction).Enabled := False
  ELSE
    (Sender AS TAction).Enabled := (InstallExeType > ET_BLANK) OR
      (ebParams.Text = '');
end;

procedure TMainForm.aPrepareClick(Sender: TObject);
VAR
  SM, N : Integer;
  TST   : TSystemTime;
begin
  TrackStatus := tsPreInst;
  CASE TrackMode OF
    tmReal : StatMask := StatMaskReal;
    tmTime : StatMask := StatMaskTime;
    ELSE     StatMask := StatMaskDisk;
  END;
  IF InstallExeType IN [ET_DOSEXE, ET_COM, ET_BAT] THEN
    StatMask := StatMask AND StatMaskXDOS;
  // Enable/disable tracking labels based on Statmask
  SM := StatMask;
  FOR N := 0 TO 11 DO
    begin
      lbStat[N].Enabled := Odd(SM);
      SM := SM DIV 2;
    end;
  nbMain.PageIndex := nb_ReadyInstall;
  IF StatMask AND smPre_RecINI > 0 THEN
    begin
      PlaceEye(0);
      FOR N := 0 TO IniList.Count-1 DO
        BEGIN
          UpdateStatus(IniList[N]);
          RememberINI(IniList[N], TempPath, TempExt1);
          IF Pos('system.ini', IniList[N]) > 0 THEN
            BEGIN
              UpdateStatus('SYSTEM.INI devices');
              DoDevices(IniList[N], TempPath + DevName + TempExt1);
            END;
          IF Application.Tag=-1 THEN Exit;
        END;
      IF Application.Tag=-1 THEN Exit;
    END;
  IF StatMask AND smPre_RecREG > 0 THEN
    begin
      PlaceEye(1);
      RememberRegistry(TempPath + RegName, TempExt1, RegList,
        UpdateStatus);
    end;
  IF Application.Tag=-1 THEN Exit;
  IF StatMask AND smPre_RecDSK > 0 THEN
    begin
      PlaceEye(2);
      RememberDisk(TempPath+TempName+TempExt1, DirList,
        UpdateStatus);
    end;
  IF Application.Tag=-1 THEN Exit;
  PlaceEye(3);
  UpdateStatus('Installation in progress');
  TrackStatus := tsInstall;
  // Note: Bounds Checker says GetSystemTimeAsFileTime is for
  // NT only, though it *seemed* to work under Win95
  GetSystemTime(TST);
  SystemTimeToFileTime(TST, StartTime);
  IF InstallExeType <> ET_BLANK THEN
    begin
      ExecInstall;
      Application.Minimize;
      btnInstDone.Enabled := True; //!!0.1
    end
  ELSE IF TrackMode = tmReal THEN
    begin
      StartWatching;
      btnInstDone.Enabled := True;
      stPlease.Caption := 'Click the Install Complete button when '+
        'you are ready to stop tracking.';
      stPlease.Visible := True;
      tmr5Min.Enabled := True;
    end
  ELSE
    begin
      MessageBeep(MB_ICONINFORMATION);
      MessageDlg('InCtrl4 has completed its pre-installation '+
        'data recording, and will now terminate. When the '+
        'installation or other tracked activity is complete, '+
        'launch InCtrl4 again to receive a report.', mtInformation,
        [mbOK], 0);
      TrackStatus := tsAllDone;
      TwoPhase    := 1;
      WITH TIniFile.Create(IniName) DO
      try
        WriteInteger('TwoPhase', 'TwoPhase', 1);
        WriteString('TwoPhase', 'ReportDesc', ebName.Text);
        WriteString('TwoPhase', 'ReportName', ebReportName.Text);
        WriteString('TwoPhase', 'InstallProg', ebInstallProg.Text);
        WITH StartTime DO
          begin
            WriteInteger('TwoPhase', 'TimeLo', dwLowDateTime);
            WriteInteger('TwoPhase', 'TimeHi', dwHighDateTime);
          end;
        WriteInteger('TwoPhase', 'StatMask', StatMask);
        WriteInteger('TwoPhase', 'TrackMode', Integer(TrackMode));
      finally
        Free;
      end;
      Close;
    end;
end;

procedure TMainForm.tmr5MinTimer(Sender: TObject);
begin
  btnInstDone.Enabled := False;
  stPlease.Visible := False;
  StopWatching;
  LaunchDone(Self);
end;

procedure TMainForm.tmrReadyRestTimer(Sender: TObject);
// This timer is a one-shot, activated when the program receives a
//   WM_QUERYENDSESSION *during* an install. It's necessary to
//   respond to the message right away, telling it we *aren't*
//   going to allow restart. Then 1/4 second later we deal with
//   the restart request in this routine.
begin
  (Sender AS TTimer).Enabled := False;
  IF InstallExeType <> ET_BLANK THEN
    StopThePresses   // Stop all running TProcDoneThreads
  ELSE StopWatching; // Or just stop watching
  IF LPT <> nil THEN // It *should* always be non-nil
    LPT.WaitFor;     // Wait until the TLaunchProgThread finishes
  IF TrackMode = tmReal THEN
    begin
      IF InstallExeType = ET_BLANK THEN
        ReTrackMode := tmIgno
      ELSE
        WITH TRtRebootForm.Create(Self) DO
        try
          ShowModal;
          ReTrackMode := RtTrackMode;
        finally
          Free;
        end;
      LaunchDone(Self);
    end
  ELSE
    begin
      TrackStatus := tsAllDone;
      TwoPhase    := 2;
      WITH TRegIniFile.Create(CurVerKey) DO
      try
        WriteString('RunOnce', 'INCTRL4', Application.ExeName);
      finally
        Free;
      end;
      WITH TIniFile.Create(IniName) DO
      try
        WriteInteger('TwoPhase', 'TwoPhase', 2);
        WriteString('TwoPhase', 'ReportDesc', ebName.Text);
        WriteString('TwoPhase', 'ReportName', ebReportName.Text);
        WriteString('TwoPhase', 'InstallProg', ebInstallProg.Text);
        WITH StartTime DO
          begin
            WriteInteger('TwoPhase', 'TimeLo', dwLowDateTime);
            WriteInteger('TwoPhase', 'TimeHi', dwHighDateTime);
          end;
        WriteInteger('TwoPhase', 'StatMask', StatMask);
        WriteInteger('TwoPhase', 'TrackMode', Integer(TrackMode));
      finally
        Free;
      end;
    end;
  tmrRestart.Enabled := True;
end;

procedure TMainForm.tmrRestartTimer(Sender: TObject);
begin
  (Sender AS TTimer).Enabled := False;
  Close;
end;

procedure TMainForm.btnHelpClick(Sender: TObject);
begin
  Application.HelpCommand(HELP_FINDER, 0);
end;

procedure TMainForm.btnAboutClick(Sender: TObject);
begin
  WITH TAboutForm.Create(Self) DO
  try
    ShowModal;
  finally
    Free;
  end;
end;

procedure TMainForm.btnBrowseClick(Sender: TObject);
begin
  WITH OpenDialog1 DO
    BEGIN
      InitialDir := ExtractFilePath(ebInstallProg.Text);
      IF (InitialDir = '') OR (NOT DirectoryExists(InitialDir)) THEN
        InitialDir := InstPath;
      IF Execute THEN
        begin
          ebInstallProg.Text := Filename;
          InstPath := ExtractFilePath(Filename);
        end;
    END;
end;

procedure TMainForm.ebInstallProgChange(Sender: TObject);
VAR
  WasET, P : Integer;
  S        : String;
begin
  WasET          := InstallExeType;
  InstallExeType := ExeType(ebInstallProg.Text, Platform);
  IF InstallExeType <> WasET THEN
    begin
      AdjustTrackModes;
      S := ebInstallProg.Text;
      IF (S = '') OR (InstallExeType < ET_BLANK) THEN
        S := '(no program)'
      ELSE
        begin
          S := ExtractFileName(S);
          P := LastDelimiter('.', S);
          IF P > 0 THEN SetLength(S, P-1);
        end;
      ebName.Text := S;  
    end;
  lbExeType.Caption := ExeTypeName(InstallExeType);
  IF (InstallExeType = ET_BLANK) AND (ebParams.Text = '') THEN
    lbExeType.Caption := '(no program)';
end;

procedure TMainForm.ebParamsChange(Sender: TObject);
begin
  IF (InstallExeType = ET_BLANK) AND (ebParams.Text = '') THEN
    lbExeType.Caption := '(no program)';
end;

procedure TMainForm.btnSelectClick(Sender: TObject);
VAR Ext : String;
begin
  WITH SaveDialog1 DO
    begin
      Filename   := '';
      InitialDir := ReptPath;
      FilterIndex := LastRept;
      IF Execute THEN
        begin
          Ext := UpperCase(ExtractFileExt(Filename));
          IF Ext = '.TXT' THEN
            begin
              TextReport := True;
              LastRept   := 1;
              ebReportName.Text := ExpandFilename(Filename);
            end
          ELSE IF Ext = '.CSV' THEN
            begin
              TextReport := False;
              LastRept   := 2;
              ebReportName.Text := ExpandFilename(Filename);
            end
          ELSE MessageBox(Handle, 'Your report filename must have '+
            'an extension of .TXT (for a text report) or .CSV (for '+
            'a comma-separated values report).', 'InCtrl4',
            MB_OK OR MB_ICONHAND);
        end;
    end;
end;

procedure TMainForm.ebReportNameChange(Sender: TObject);
begin
  lbReportName.Caption := ebReportName.Text;
end;

procedure TMainForm.rbTmClick(Sender: TObject);
begin
  TrackMode := TTrackMode((Sender AS TRadioButton).Tag);
end;

procedure TMainForm.btnPathClick(Sender: TObject);
VAR WasDef : Boolean;
begin
  WasDef := AnsiCompareText(ebReportName.Text, DefaultReportName)=0;
  WITH TPathsForm.Create(Self) DO
  try
    ebReportPath.Text := ReptPath;
    ebTempPath.Text   := TempPath;
    IF ShowModal = mrOK THEN
      begin
        ReptPath := FinSlash(ebReportPath.Text);
        TempPath := FinSlash(ebTempPath.Text);
        IF WasDef THEN
          ebReportName.Text := DefaultReportName;
        WITH TIniFile.Create(ininame) DO
        try
          WriteString(Opt, 'ReptPath', ReptPath);
          WriteString(Opt, 'TempPath', TempPath);
        finally
          Free;
        end;
      end;
  finally
    free;
  end;
end;

procedure TMainForm.btnDiskClick(Sender: TObject);
VAR N : Integer;
begin
  WITH TTrackDirForm.Create(Self) DO
  try
    lbMain.Items := DirList;
    IF ShowModal = mrOK THEN
      begin
        DirList.Assign(lbMain.Items);
        WITH TIniFile.Create(IniName) DO
        try
          WriteBool(Opt, 'DrivesInitialized', True);
          EraseSection('Drives');
          FOR N := 0 TO DirList.Count-1 DO
            WriteString('Drives', IntToStr(N), DirList[N]);
        finally
          Free;
        end;
      end;
  finally
    Free;
  end;
end;

procedure TMainForm.btnINIClick(Sender: TObject);
VAR N : Integer;
begin
  WITH TTrackIniForm.Create(Self) DO
  try
    lbMain.Items.Assign(IniList);
    IF ShowModal = mrOK THEN
      begin
        IniList.Assign(lbMain.Items);
        WITH TIniFile.Create(IniName) DO
        try
          WriteBool(Opt, 'INIsInitialized', True);
          FOR N := 0 TO IniList.Count-1 DO
            WriteString('INIs', IntToStr(N), IniList[N]);
        finally
          Free;
        end;
      end;
  finally
    Free;
  end;
end;

procedure TMainForm.btnRegClick(Sender: TObject);
VAR N : Integer;
begin
  WITH TTrackRegForm.Create(Self) DO
  try
    lbMain.Items := RegList;
    IF ShowModal = mrOK THEN
      begin
        RegList.Assign(lbMain.Items);
        WITH TIniFile.Create(IniName) DO
        try
          WriteBool(Opt, 'RegInitialized', True);
          EraseSection('Regs'); //!!0.3
          FOR N := 0 TO RegList.Count-1 DO
            WriteString('Regs', IntToStr(N), RegList[N]);
        finally
          Free;
        end;
      end;
  finally
    Free;
  end;
end;

procedure TMainForm.btnCancelClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.btnInstDoneClick(Sender: TObject);
begin
//!!0.1 - begin new code to let button be enabled all the time
  IF NOT (TrackStatus IN [tsSetup, tsAllDone]) THEN
    begin
      IF (LPT <> nil) AND (LPT.getNumThds > 0) THEN
        begin
          MessageBeep(MB_ICONQUESTION);
          IF MessageDlg('InCtrl4 is tracking an install program tha'+
            't seems to be running still. If you close InCtrl4 too '+
            'soon, you will not get a complete report. Are you quit'+
            'e sure the install is complete?', mtConfirmation,
            [mbyes, mbNo], 0) <> idYes THEN Exit;
        end;
    end;
//!!0.1 - end new code to let button be enabled all the time
  btnInstDone.Enabled := False;
  stPlease.Visible := False;
  tmr5Min.Enabled := False;
  IF TrackMode = tmReal THEN StopWatching;
  LaunchDone(Self);
end;

procedure TMainForm.btnLaunchClick(Sender: TObject);
begin
  ShellExecute(Handle, 'open', PChar(ebReportName.Text), nil,
    PChar(ExtractFileDir(ebReportName.Text)), SW_SHOWNORMAL);
end;

procedure TMainForm.WMQueryEndSession(VAR Msg: TWMQueryEndSession);
begin
  IF NeedRestart > 0 THEN
    begin
      Msg.Result := -1;
      exit;
    end;
  IF DWORD(Msg.Unused) = ENDSESSION_LOGOFF THEN
    NeedRestart := 2
  ELSE NeedRestart := 1;
  Msg.Result := 0;
  // Return that good result, *then* do any more processing
  IF TrackStatus = tsInstall THEN tmrReadyRest.Enabled := True;
end;

function TMainForm.DefaultReportName : String;
VAR N : Integer;
begin
  N := 0;
  REPEAT
    Result := Format('%sRPT_%.4d.', [ReptPath, N]);
    IF LastRept = 1 THEN
      Result := Result + 'TXT'
    ELSE Result := Result + 'CSV';
    Inc(N);
  UNTIL NOT FileExists(Result);
end;

function TMainForm.GetObsfucator(VAR U : DWORD) : Boolean;
// Process and Thread IDs supplied by Win95 are based on
// pointers into internal data structures. To avoid giving
// programmers easy access to these structures, Win95 XORs
// the pointer with an "obfuscator" value before giving it
// to a program. This value changes in each Windows session,
// but is consistent during a session. (The misspelled name
// "Obsfucator" is found in the Win95 source).

TYPE
  GCPIType = function : DWORD; stdcall;
  PPByte   = ^PByte;
  PPointer = ^Pointer;
  PPDWORD  = ^PDWORD;
  PPPDWORD = ^PPDWORD;
VAR
  GCPI : GCPIType;
  ID   : Dword;
  pB   : PByte;
  pppD : PPPDWORD;
begin
  // If not running under Win95/Win98, we can't use the VxD
  // and the obsfucator is irrelevant.
  IF NOT (PlatVer IN [WV_95, WV_98]) THEN
    begin
      U      := 0;
      Result := True;
      Exit;
    end;
  // Try to get the obsfucator via the VxD; it should not fail
  U := CtrlTrap.GetObsfucator;
  IF U <> 0 THEN
    begin
      Result := True;
      Exit;
    end;
  // This function is conceptually based on C code supplied by
  // Andrew Schulman as a followup to his book "Unauthorized
  // Windows". This code *should* never need to be called,
  // because the VxD's method is reliable. I have left it in
  // place simply as a curiosity
  Result := False;
  try
    GCPI := GetProcAddress(GetModuleHandle('Kernel32'),
      'GetCurrentProcessId');
  except
    ON Exception DO Exit;
  end;
  IF @GCPI = nil THEN Exit;
  ID := GCPI; // actually get the process ID
  pB  := PPByte(Integer(@GCPI)+1)^;
  CASE pB^ OF
    // 6A = PUSH - this is the debug kernel
    $6A : pppD := Pointer(Integer(pB)+8);
    // A1 = MOV - this is the retail kernel
    $A1 : pppD := Pointer(Integer(pB)+1);
    // otherwise something is very wrong
    ELSE Exit;
  end;
  U := Id XOR pppD^^^;
  Result := True;
end;

procedure TMainForm.AdjustTrackModes;
begin
  CASE InstallExeType OF
    ET_UNKNOWN,
    ET_NOTEXE,
    ET_NOEXIST : begin
      rbTmReal.Enabled := False; rbTmReal.Checked := False;
      rbTmTime.Enabled := False; rbTmTime.Checked := False;
      rbTmDisk.Enabled := False; rbTmDisk.Checked := False;
    end;
    ET_DOSEXE,
    ET_COM,
    ET_BAT,
    ET_WINEXE,(* : begin
      rbTmReal.Enabled := False;
      IF rbTmReal.Checked THEN
        begin
          rbTmReal.Checked := False;
          rbTmDisk.Checked := True;
          TrackMode        := tmDisk;
        end;
      rbTmTime.Enabled := True;
      rbTmDisk.Enabled := True;

    end;*)  //!!0.1 real-time OK regardless of executable type
    ET_PEXE,
    ET_INFFILE,
    ET_BLANK : begin
      rbTmReal.Enabled := True;
      rbTmReal.Checked := True;
      rbTmTime.Enabled := True;
      rbTmDisk.Enabled := True;
      TrackMode        := tmReal;
    end;
  END;
  CASE PlatVer OF
    WV_95 : ;
    WV_98 : ;
    WV_NT4 : begin
       rbTmReal.Enabled := False;
       IF rbTmReal.Checked THEN
         begin
           rbTmReal.Checked := False;
           rbTmDisk.Checked := True;
           TrackMode        := tmDisk;
         end;
    end;
    WV_NT5,
    WV_NT3,
    WV_9x,
    WV_NTx,
    WV_UNK : begin
      rbTmReal.Enabled := False; rbTmReal.Checked := False;
      rbTmTime.Enabled := False; rbTmTime.Checked := False;
      rbTmDisk.Enabled := False; rbTmDisk.Checked := False;
    end;
  END;
end;

procedure TMainForm.ExecInstall;
VAR
  fName, fDir : String;
BEGIN
  fName := ebInstallProg.Text;
  fDir := ExtractFilePath(fName);
  IF ebParams.Text <> '' THEN
    fName := fName + ' ' + ebParams.Text;
  LPT := TLaunchProgThread.Create(fName, fDir, TrackMode = tmReal,
    Obsfucator, LaunchDone);
end;

procedure TMainForm.LaunchDone(Sender: TObject);
VAR
  TAdd, TDel, TCha,
  TAddS, TDelS, TProc : TStringList;
  OutFTxt, OutFCsv    : TextFile;
  N                   : Integer;

  procedure ClearAll;
  begin
    TAdd.Clear; TDel.Clear; TCha.Clear;
    TAddS.Clear; TDelS.Clear;
  end;

  function ProcStr(P : Pointer) : String;
  VAR Idx : Integer;
  begin
    Idx := TProc.IndexOfObject(P);
    IF Idx = -1 THEN Result := ''
    ELSE Result := TProc[Idx];
  end;

  function ProcStrReg(P : Pointer) : String;
  begin
    WITH RegObject(P) DO
      Result := ProcStr(Pointer(fProcId));
  end;

  procedure WriteOutTxt(L : TStringList; const S : String;
    Special : Integer);
  // Special - 0 = no proc-ids, 1= proc-ids registry style,
  // 2 = proc-ids file-style
  VAR
    N, ID, ThisID : Integer;
  BEGIN
    ID := 0;
    IF L.Count > 0 THEN
      BEGIN
        WriteLn(OutFTxt, Format(S+'(%d)', [L.Count]));
        FOR N := 0 TO L.Count-1 DO
          begin
            CASE Special OF
              1 : ThisID := RegObject(L.Objects[N]).fProcId;
              2 : ThisID := Integer(L.Objects[N]);
              ELSE ThisID := 0;
            end;
            IF (ThisID <> 0) AND (ThisID <> ID) THEN
              begin
                ID := ThisID;
                WriteLn(OutFTxt, '---by process ',
                  ProcStr(Pointer(ID)));
              end;
            WriteLn(OutFTxt, L[N])
          end;
        WriteLn(OutFTxt);
      END;
  END;

  function CsvLine(S : ARRAY of String) : String;
  VAR N : Integer;
  begin
    Result := '';
    FOR N := 0 TO High(S)-1 DO
//!!0.1      Result := Result + AnsiQuotedStr(S[N],'"') + ',';
      Result := Result + AnsiQuotedStr(S[N],'"') + ListSeparator;
    Result := Result + AnsiQuotedStr(S[High(S)], '"');
  end;

  function ModeName : String;
  begin
    CASE TrackMode OF
      tmReal : Result := 'Real-time reporting';
      tmTime : Result := 'File-time comparison';
      tmDisk : Result := 'Disk contents comparison';
    END;
  end;

  procedure WriteSuppHeader;
  VAR N : Integer;
  begin
    WriteLn(OutFTxt);
    WriteLn(OutFTxt, 'Supplementary report on changes '+
      'during Windows restart');
    WriteLn(OutFTxt, 'Notification by ', ModeName);
    WriteLn(OutFTxt, 'Tracking these drives/folders: ');
    FOR N := 0 TO DirList.Count-1 DO
      WriteLn(OutFTxt, '    ', DirList[N]);
    CloseFile(OutFTxt);
    Append(OutFTxt);
    WriteLn(OutFCsv, CsvLine(['Header', 'Supplement after Windows '+
      'restart', ModeName]));
    IF DirList.Count > 0 THEN
      begin
//!!0.1        Write(OutFCsv, '"Drives",');
        Write(OutFCsv, '"Drives"', ListSeparator);
        FOR N := 0 TO DirList.Count-2 DO
//!!0.1          Write(OutFCsv, AnsiQuotedStr(DirList[N], '"'), ',');
          Write(OutFCsv, AnsiQuotedStr(DirList[N], '"'), ListSeparator);
        WriteLn(OutFCsv, AnsiQuotedStr(DirList[DirList.Count-1],
          '"'));
      end;
    CloseFile(OutFCsv);
    Append(OutFCsv);
  end;

  procedure WriteHeader;
  VAR N : Integer;
  BEGIN
    WriteLn(OutFTxt, 'Installation report: '+ebName.Text);
    WriteLn(OutFTxt, '    (generated by INCTRL 4, version '+
      GetFileVersion+')');
    WriteLn(OutFTxt, 'Install program: '+ebInstallProg.Text);
    WriteLn(OutFTxt, FormatDateTime('dddd, mmmm d, yyyy  '+
      'hh:mm AM/PM', Now));
    WriteLn(OutFTxt, PlatVerStr);
    WriteLn(OutFTxt, 'Notification by ', ModeName);
    CASE TwoPhase OF
      0 : ;
      1 : WriteLn(OutFTxt, 'Two-phase tracking');
      2 : WriteLn(OutFTxt, 'Windows was restarted');
    END;
    IF TrackMode <> tmReal THEN
      begin
        WriteLn(OutFTxt, 'Tracking these drives/folders: ');
        FOR N := 0 TO DirList.Count-1 DO
          WriteLn(OutFTxt, '    ', DirList[N]);
      end;
    IF InstallExeType IN [ET_DOSEXE, ET_COM, ET_BAT] THEN
      begin
        WriteLn(OutFTxt,'DOS-based install - INI files not tracked');
        WriteLn(OutFTxt,'DOS-based install - Registry not tracked');
      end;
    WriteLn(OutFTxt);
    CloseFile(OutFTxt);
    Append(OutFTxt);
    // CSV report
    IF TrackMode = tmReal THEN
      WriteLn(OutFCsv, CsvLine(['Type', 'SubType', 'Filename',
        'INI Section', 'Registry Key', 'INI key', 'Registry value',
        'Data', 'Previous Data', 'Process']))
    ELSE
      WriteLn(OutFCsv, CsvLine(['Type', 'SubType', 'Filename',
        'INI Section', 'Registry Key', 'INI key', 'Registry value',
        'Data', 'Previous Data']));
    WriteLn(OutFCsv, CsvLine(['Header', ebName.Text, 'InCtrl4',
      GetFileVersion, FormatDateTime('mm/dd/yyyy', Now),
      FormatDateTime('hh:mm AM/PM', Now), PlatVerStr,
      ModeName, TPStr[TwoPhase]]));
    WriteLn(OutFCsv, CsvLine(['Header', 'Install program',
      ebInstallProg.Text]));
    IF (TrackMode <> tmReal) AND (DirList.Count > 0) THEN
      begin
//!!0.1        Write(OutFCsv, '"Drives",');
        Write(OutFCsv, '"Drives"', ListSeparator);
        FOR N := 0 TO DirList.Count-2 DO
//!!0.1          Write(OutFCsv,AnsiQuotedStr(DirList[N], '"'), ',');
          Write(OutFCsv,AnsiQuotedStr(DirList[N], '"'), ListSeparator);
        WriteLn(OutFCsv,AnsiQuotedStr(DirList[DirList.Count-1],'"'));
      end;
    CloseFile(OutFCsv);
    Append(OutFCsv);
  END;

  procedure ReportINI(const RealN : String);
  VAR
    N, P : Integer;
    S1, S2, S3, S4 : String;
  BEGIN
    PlaceEye(5);
    UpdateStatus(RealN);
    CompareIni(
      ChangeFileExt(TempPath+SafeName(RealN), TempExt1),
      ChangeFileExt(TempPath+SafeName(RealN), TempExt2),
      TAdd, TDel, TCha, TAddS, TDelS);
    IF Pos('SYSTEM.INI', UpperCase(RealN)) > 0 THEN
      BEGIN
        UpdateStatus('SYSTEM.INI devices');
        CompareDev(TempPath + DevName + TempExt1,
          TempPath + DevName + TempExt2,
          TAdd, TDel, TCha);
      END;
    IF TAddS.Count + TDelS.Count + TAdd.Count + TDel.Count
       + TCha.Count = 0 THEN
      BEGIN
        WriteLn(OutFTxt, 'NO CHANGES MADE TO '+RealN+'...');
        WriteLn(OutFTxt);
      END
    ELSE
      BEGIN
        WriteLn(OutFTxt, 'CHANGES MADE TO '+RealN+'...');
        WriteOutTxt(TAddS,'SECTIONS ADDED TO '+RealN+': ', 0);
        WriteOutTxt(TDelS,'SECTIONS DELETED FROM '+RealN+': ', 0);
        WriteOutTxt(TAdd,'KEYS ADDED TO '+RealN+': ', 0);
        WriteOutTxt(TDel,'KEYS DELETED FROM '+RealN+': ', 0);
        WriteOutTxt(TCha,'KEYS CHANGED IN '+RealN+': ', 0);
      END;
    CloseFile(OutFTxt);
    Append(OutFTxt);
    FOR N := 0 TO TAddS.Count-1 DO
      WriteLn(OutFCsv, CsvLine(['INI', 'Add Section', RealN,
        TAddS[N]]));
    FOR N := 0 TO TDelS.Count-1 DO
      WriteLn(OutFCsv, CsvLine(['INI', 'Del Section', RealN,
        TDelS[N]]));
    FOR N := 0 TO TAdd.Count-1 DO
      begin
        S3 := TAdd[N];
        P := Pos(']', S3);
        S1 := Copy(S3, 1, P);
        Delete(S3, 1, P);
        P := Pos('=', S3);
//!!0.1        S1 := Copy(S3, 1, P-1);
        S2 := Copy(S3, 1, P-1); //!!0.1
        Delete(S3, 1, P);
        WriteLn(OutFCsv, CsvLine(['INI', 'Add Key', RealN,
          S1, '', S2, '', S3]));
      end;
    FOR N := 0 TO TDel.Count-1 DO
      begin
        S3 := TDel[N];
        P := Pos(']', S3);
        S1 := Copy(S3, 1, P);
        Delete(S3, 1, P);
        P := Pos('=', S3);
        S2 := Copy(S3, 1, P-1);
        Delete(S3, 1, P);
        WriteLn(OutFCsv, CsvLine(['INI', 'Del Key', RealN,
          S1, '', S2, '', S3]));
      end;
    FOR N := 0 TO TCha.Count-1 DO
      begin
        S4 := TCha[N];
        P := Pos(']', S4);
        S1 := Copy(S4, 1, P);
        Delete(S4, 1, P);
        P := Pos('=', S4);
        S2 := Copy(S4, 1, P-1);
        Delete(S4, 1, P);
        P := Pos('=to=', S4);
        S3 := Copy(S4, 1, P-4);
        Delete(S4, 1, P+3);
        WriteLn(OutFCsv, CsvLine(['INI', 'Change Key', RealN,
          S1, '', S2, '', S3, S4]));
      end;
    CloseFile(OutFCsv);
    Append(OutFCsv);
    ClearAll;
  END;

  procedure StripSysFiles(L : TStringList);
  {Don't count changes to any swap file}
  VAR
    N : Integer;
    S : String;
  BEGIN
    IF L.Count = 0 THEN Exit;
    FOR N := L.Count-1 DOWNTO 0 DO
      BEGIN
        S := ExtractFileName(L[N]);
        IF S = '386SPART.PAR' THEN L.Delete(N);
        IF S = 'WIN386.SWP' THEN L.Delete(N);
        IF S = 'PAGEFILE.SYS' THEN L.Delete(N);
        IF S = 'USER.DAT' THEN L.Delete(N);
        IF S = 'USER.DA0' THEN L.Delete(N);
        IF S = 'SYSTEM.DAT' THEN L.Delete(N);
        IF S = 'SYSTEM.DA0' THEN L.Delete(N);
      END;
  END;

  procedure StripOurOwn(L : TStringList);
  VAR
    N, M : Integer;
    S    : String;
  begin
    FOR N := L.Count-1 DOWNTO 0 DO
      begin
        IF Pos(OPath, lowercase(L[N])) <> 0 THEN
          L.Delete(N)
        ELSE IF AnsiCompareText(L[N], ebReportName.Text)=0 THEN
          L.Delete(N)
        ELSE IF AnsiCompareText(L[N], ReptPath+'EXTRARPT.CSV')=0 THEN
          L.Delete(N)
        ELSE IF AnsiCompareText(L[N], ReptPath+'EXTRARPT.TXT')=0 THEN
          L.Delete(N)
        ELSE IF (Pos(lowercase(TempPath), lowercase(L[N])) <> 0) THEN
          begin
            S := ExtractFileExt(L[N]);
            IF (S <> TempExt1) AND (S <> TempExt2) THEN Continue;
            S := ExtractFileName(L[N]);
            SetLength(S, Length(S)-4);
            IF S = TempName THEN
              L.Delete(N)
            ELSE IF S = RegName THEN
              L.Delete(N)
            ELSE IF S = DevName THEN
              L.Delete(N)
            ELSE
              begin
                S := S + '.INI';
                FOR M := 0 TO IniList.Count-1 DO
                  IF AnsiCompareText(S,SafeName(IniList[M])) = 0 THEN
                    begin
                      L.Delete(N);
                      Break;
                    end;
              end;
          end;
      end;
  end;

  procedure FixVxdFilTCha;
  // Go through the list of opened files and eliminate any that
  // haven't changed.
  VAR
    N  : Integer;
    FD : TWin32FindData;
    H  : THandle;
    O  : FilOpeObject;
  begin
    FOR N := TCha.Count-1 DOWNTO 0 DO
      begin
        IF (TCha.Objects[N] <> nil) AND
           (TCha.Objects[N] IS FilOpeObject) THEN
          WITH FilOpeObject(TCha.Objects[N]) DO
            begin
              H := FindFirstFile(PChar(TCha[N]), FD);
              IF H <> INVALID_HANDLE_VALUE THEN
                WITH FD, ftLastWriteTime DO
                  begin
                    IF (nFileSizeHigh = fSizeH) AND
                       (nFileSizeLow = fSizeL) AND
                       (dwLowDateTime = fDateL) AND
                       (dwHighDateTime = fDateH) THEN
                      TCha.Delete(N); // Delete if file not changed
                    CloseHandle(H);
                  end
              ELSE TCha.Delete(N); // Delete if file doesn't exist
            end
        ELSE TCha.Delete(N); // Delete if size/date info lacking
      end;
    FOR N := 0 TO TCha.Count-1 DO
      begin
        O := TCha.Objects[N] AS FilOpeObject;
        TCha.Objects[N] := Pointer(O.fProcID);
        O.Free;
      end;
  end;

  procedure FixVxdFilTAdd;
  // Go through the list of added files and eliminate any that
  // now don't exist
  VAR N  : Integer;
  begin
    FOR N := TAdd.Count-1 DOWNTO 0 DO
      IF NOT FileExists(TAdd[N]) THEN
        TAdd.Delete(N);
  end;

  procedure FixVxdFilTDel;
  // Go through the list of deleted files and eliminate any that
  // now do exist
  VAR N  : Integer;
  begin
    FOR N := TDel.Count-1 DOWNTO 0 DO
      IF FileExists(TDel[N]) THEN
        TDel.Delete(N);
  end;

  procedure FixVxdRegTAddS;
  // Go thru list of added values and incorporate into string,
  // with data
  VAR N  : Integer;
  begin
    FOR N := TAddS.Count-1 DOWNTO 0 DO
      begin
        IF (TAddS.Objects[N] <> nil) AND
           (TAddS.Objects[N] IS RegObject) THEN
          WITH RegObject(TAddS.Objects[N]) DO
            TAddS[N] := Format('%s %s=%s', [TAddS[N], fVal, fDat])
        ELSE TAddS.Delete(N);
      end;
  end;

  procedure FixVxdRegTCha;
  // Go thru list of added values and incorporate into string,
  // with data and previous data
  VAR N  : Integer;
  begin
    FOR N := TCha.Count-1 DOWNTO 0 DO
      begin
        IF (TCha.Objects[N] <> nil) AND
           (TCha.Objects[N] IS RegObject) THEN
          WITH RegObject(TCha.Objects[N]) DO
            IF fPrv = '' THEN
              TCha[N] := Format('%s %s=%s (was <null>)', [TCha[N],
                fVal, fDat])
            ELSE IF fDat = '' THEN
              TCha[N] := Format('%s %s=<null> (was %s)', [TCha[N],
                fVal, fPrv])
            ELSE
              TCha[N] := Format('%s %s=%s (was %s)', [TCha[N], fVal,
                fDat, fPrv])
        ELSE TCha.Delete(N);
      end;
  end;

  procedure FixVxdRegTDelS;
  // Go thru list of deleted values and incorporate into string,
  VAR N  : Integer;
  begin
    FOR N := TDelS.Count-1 DOWNTO 0 DO
      begin
        IF (TDelS.Objects[N] <> nil) AND
           (TDelS.Objects[N] IS RegObject) THEN
          WITH RegObject(TDelS.Objects[N]) DO
//!!0.3            TDelS[N] := Format('%s %s', [TDelS[N], fVal])
            TDelS[N] := Format('%s %s=%s', [TDelS[N], fVal, fDat])//!!0.3
        ELSE TDelS.Delete(N);
      end;
  end;

  procedure DoRetrack;
  VAR
    SM, N : Integer;
    TST   : TSystemTime;
  begin
    IF ReTrackMode = tmIgno THEN
      begin
        Append(OutFTxt);
        WriteLn(OutFTxt, 'Changes during '+
          'Windows restart ignored.');
        CloseFile(OutFTxt);
        Append(OutFCsv);
//!!0.1        WriteLn(OutFCsv, '"Header","Changes during '+
        WriteLn(OutFCsv, '"Header"'+ListSeparator+'"Changes during '+
          'Windows restart ignored."');
        CloseFile(OutFCsv);
      end
    ELSE
      begin
        TrackStatus := tsPreInst;
        Trackmode := reTrackMode;
        CASE TrackMode OF
          tmDisk : StatMask := StatMaskDisk;
          tmTime : StatMask := StatMaskTime;
        END;
        IF InstallExeType IN [ET_DOSEXE, ET_COM, ET_BAT] THEN
          StatMask := StatMask AND StatMaskXDOS;
        StatMask := StatMask AND StatMaskXRet;
        // Enable/disable tracking labels based on Statmask
        SM := StatMask;
        FOR N := 0 TO 11 DO
          begin
            lbStat[N].Enabled := Odd(SM);
            SM := SM DIV 2;
          end;
        nbMain.PageIndex := nb_ReadyInstall;
        IF StatMask AND smPre_RecREG > 0 THEN
          begin
            PlaceEye(1);
            RememberRegistry(TempPath + RegName, TempExt1, RegList,
              UpdateStatus);
          end;
        IF Application.Tag=-1 THEN Exit;
        IF StatMask AND smPre_RecDSK > 0 THEN
          begin
            PlaceEye(2);
            RememberDisk(TempPath+TempName+TempExt1, DirList,
              UpdateStatus);
          end;
        IF Application.Tag=-1 THEN Exit; 
      end;
    PlaceEye(3);
    UpdateStatus('Restarting...');
    GetSystemTime(TST);
    SystemTimeToFileTime(TST, StartTime);
    TrackStatus := tsAllDone;
    TwoPhase    := 3;
    WITH TRegIniFile.Create(CurVerKey) DO
    try
      WriteString('RunOnce', 'INCTRL4', Application.ExeName);
    finally
      Free;
    end;
    WITH TIniFile.Create(IniName) DO
    try
      WriteInteger('TwoPhase', 'TwoPhase', 3);
      WriteString('TwoPhase', 'ReportDesc', ebName.Text);
      WriteString('TwoPhase', 'ReportName', ebReportName.Text);
      WriteString('TwoPhase', 'InstallProg', ebInstallProg.Text);
      WITH StartTime DO
        begin
          WriteInteger('TwoPhase', 'TimeLo', dwLowDateTime);
          WriteInteger('TwoPhase', 'TimeHi', dwHighDateTime);
        end;
      CASE TrackMode OF
        tmDisk : StatMask := StatMaskDisk;
        tmTime : StatMask := StatMaskTime;
      END;
      IF InstallExeType IN [ET_DOSEXE, ET_COM, ET_BAT] THEN
        StatMask := StatMask AND StatMaskXDOS;
      StatMask := StatMask AND StatMaskXAft;
      IF ReTrackMode = tmIgno THEN StatMask := 0;
      WriteInteger('TwoPhase', 'StatMask', StatMask);
      WriteInteger('TwoPhase', 'TrackMode', Integer(TrackMode));
    finally
      Free;
    end;
    tmrRestart.Enabled := True;
  end;

begin
  // If we've specified a need to restart, we probably should
  //   not do the final processing. When trackmode is tmReal,
  //   though, we can get called twice, once because the
  //   program ended and once because WE requested it after
  //   setting ReTrackmode. Only process the report in the
  //   *second* case.
  IF NeedRestart > 0 THEN
    IF TrackMode = tmReal THEN
      begin
        IF ReTrackMode = tmNone THEN Exit;
      end
    ELSE Exit;
  Application.Restore;
  // If this is a restart with NO supplemental tracking, just show!
  IF StatMask = 0 THEN
    begin
      meRept.Lines.LoadFromFile(ebReportName.Text);
      nbMain.PageIndex := nb_ProgComplete;
      TrackStatus := tsAllDone;
      Exit;
    end;
  IF (Sender IS TLaunchProgThread) THEN
    begin
      btnInstDone.Enabled := True;
      stPlease.Visible := True;
      MessageBeep(MB_ICONEXCLAMATION);
      Exit;
    end;
  TrackStatus := tsPostInst;
  IF StatMask AND smPostRecINI > 0 THEN
    begin
      PlaceEye(4);
      FOR N := 0 TO IniList.Count-1 DO
        BEGIN
          UpdateStatus(IniList[N]);
          RememberINI(IniList[N], TempPath, TempExt2);
          IF Pos('system.ini', IniList[N]) > 0 THEN
            BEGIN
              UpdateStatus('SYSTEM.INI devices');
              DoDevices(IniList[N], TempPath + DevName + TempExt2);
            END;
          IF Application.Tag=-1 THEN Exit;
        END;
      IF Application.Tag=-1 THEN Exit;
    END;
  TAdd := TStringList.Create;
  TDel := TStringList.Create;
  TCha := TStringList.Create;
  TAddS := TStringList.Create;
  TDelS := TStringList.Create;
  try
    IF TextReport THEN
      begin
        AssignFile(OutFTxt, ebReportName.Text);
        AssignFile(OutFCsv, ReptPath+'EXTRARPT.CSV');
      end
    ELSE
      begin
        AssignFile(OutFCsv, ebReportName.Text);
        AssignFile(OutFTxt, ReptPath+'EXTRARPT.TXT');
      end;
    IF TwoPhase = 3 THEN
      begin
        Append(OutFTxt);
        Append(OutFCsv);
        WriteSuppHeader;
      end
    ELSE
      begin
        Rewrite(OutFTxt);
        Rewrite(OutFCsv);
        WriteHeader;
      end;
    IF StatMask AND smPostCmpINI > 0 THEN
      begin
        PlaceEye(5);
        FOR N := 0 TO IniList.Count-1 DO
          ReportINI(IniList[N]);
      end;
    IF StatMask AND smPostRecREG > 0 THEN
      begin
        PlaceEye(6);
        RememberRegistry(TempPath + RegName, TempExt2, RegList,
          UpdateStatus);
      end;
    IF StatMask AND smPostCmpREG > 0 THEN
      begin
        PlaceEye(7);
        CompareRegistry(TempPath+RegName+TempExt1,
          TempPath+RegName+TempExt2,
          TAdd, TDel, TCha, TAddS, TDelS, UpdateStatus);
        // Write to CSV report
        FOR N := 0 TO TAdd.Count-1 DO
          WriteLn(OutFCsv, CsvLine(['Registry', 'Add Key', '',
            '', TAdd[N]]));
        FOR N := 0 TO TDel.Count-1 DO
          WriteLn(OutFCsv, CsvLine(['Registry', 'Del Key', '',
            '', TDel[N]]));
        FOR N := 0 TO TAddS.Count-1 DO
          WITH RegObject(TAddS.Objects[N]) DO
            WriteLn(OutFCsv, CsvLine(['Registry', 'Add Value', '',
              '', TAddS[N], '', fVal, fDat]));
        FOR N := 0 TO TCha.Count-1 DO
          WITH RegObject(TCha.Objects[N]) DO
            WriteLn(OutFCsv, CsvLine(['Registry', 'Change Value', '',
              '', TCha[N], '', fVal, fDat, fPrv]));
        FOR N := 0 TO TDelS.Count-1 DO
          WITH RegObject(TDelS.Objects[N]) DO
            WriteLn(OutFCsv, CsvLine(['Registry', 'Del Value', '',
//!!0.3              '', TDelS[N], '', fVal]));
              '', TDelS[N], '', fVal, fDat]));//!!0.3
        // Write to TXT report
        FixVxdRegTAddS;
        FixVxdRegTCha;
        FixVxdRegTDelS;
        IF TAdd.Count + TDel.Count + TCha.Count + TAddS.Count +
          TDelS.Count = 0 THEN
          BEGIN
            WriteLn(OutFTxt, 'NO CHANGES IN Registry');
            WriteLn(OutFTxt);
          END
        ELSE
          BEGIN
            WriteOutTxt(TAdd,'REGISTRY KEYS ADDED: ', 0);
            WriteOutTxt(TDel,'REGISTRY KEYS DELETED: ', 0);
            WriteOutTxt(TAddS,'REGISTRY KEY VALUES ADDED: ', 0);
            WriteOutTxt(TCha,'REGISTRY KEY VALUES CHANGED: ', 0);
            WriteOutTxt(TDelS,'REGISTRY KEY VALUES DELETED: ', 0);
          END;
        ClearAll;
      end;
    IF StatMask AND smPostRecDSK > 0 THEN
      begin
        PlaceEye(8);
        RememberDisk(TempPath+TempName+TempExt2, DirList,
         UpdateStatus);
      end;
    IF StatMask AND smPostCmpDSK > 0 THEN
      begin
        PlaceEye(9);
        CompareDisk(TempPath+TempName+TempExt1,
          TempPath+TempName+TempExt2,
          TAdd, TDel, TCha, UpdateStatus);
        StripSysFiles(TCha);
        StripSysFiles(TAdd);
        StripSysFiles(TDel);
        StripOurOwn(TAdd);
        StripOurOwn(TCha);
        StripOurOwn(TDel);
        IF TAdd.Count+TDel.Count+TCha.Count = 0 THEN
          begin
            WriteLn(OutFTxt, 'NO CHANGES IN TRACKED DISKS');
            WriteLn(OutFTxt);
          end
        ELSE
          begin
            WriteOutTxt(TAdd,'FILES AND DIRECTORIES ADDED: ', 0);
            WriteOutTxt(TDel,'FILES AND DIRECTORIES DELETED: ', 0);
            WriteOutTxt(TCha,'FILES CHANGED: ', 0);
          end;
        CloseFile(OutFTxt);
        Append(OutFTxt);
        FOR N := 0 TO TAdd.Count-1 DO
          WriteLn(OutFCsv, CsvLine(['File', 'Add File/Dir',
            TAdd[N]]));
        FOR N := 0 TO TDel.Count-1 DO
          WriteLn(OutFCsv, CsvLine(['File', 'Del File/Dir',
            TDel[N]]));
        FOR N := 0 TO TCha.Count-1 DO
          WriteLn(OutFCsv, CsvLine(['File', 'Change File',
            TCha[N]]));
        CloseFile(OutFCsv);
        Append(OutFCsv);
        ClearAll;
      end;
    IF StatMask AND smPostDoTime > 0 THEN
      begin
        PlaceEye(10);
        FindNewFiles(TAdd, StartTime, DirList, UpdateStatus);
        StripSysFiles(TAdd);
        StripOurOwn(TAdd);
        IF TAdd.Count=0 THEN
          begin
            WriteLn(OutFTxt, 'NO CHANGES IN TRACKED DISKS');
            WriteLn(OutFTxt);
          end
        ELSE
          WriteOutTxt(TAdd,'FILES AND DIRECTORIES ADDED OR '+
            'CHANGED: ', 0);
        CloseFile(OutFTxt);
        Append(OutFTxt);
        FOR N := 0 TO TAdd.Count-1 DO
          WriteLn(OutFCsv, CsvLine(['File', 'Newer', TAdd[N]]));
        CloseFile(OutFCsv);
        Append(OutFCsv);
        ClearAll;
      end;
    IF StatMask AND smPostAnalyz > 0 THEN
      begin
        PlaceEye(11);
        TAdd  := GetAList(L_KeyCre);
        TDel  := GetAList(L_KeyDel);
        TAddS := GetAList(L_ValCre);
        TCha  := GetAList(L_ValCha);
        TDelS := GetAList(L_ValDel);
        TProc := GetAList(L_ProcID);
        FOR N := 0 TO TAdd.Count-1 DO
          WriteLn(OutFCsv, CsvLine(['Registry', 'Add Key', '',
            '', TAdd[N], '', '', '', '',
            ProcStrReg(TAdd.Objects[N])]));
        FOR N := 0 TO TDel.Count-1 DO
          WriteLn(OutFCsv, CsvLine(['Registry', 'Del Key', '',
            '', TDel[N], '', '', '', '',
            ProcStrReg(TDel.Objects[N])]));
        FOR N := 0 TO TAddS.Count-1 DO
          WITH RegObject(TAddS.Objects[N]) DO
            WriteLn(OutFCsv, CsvLine(['Registry', 'Add Value', '',
              '', TAddS[N], '', fVal, fDat, '',
              ProcStrReg(TAddS.Objects[N])]));
        FOR N := 0 TO TCha.Count-1 DO
          WITH RegObject(TCha.Objects[N]) DO
            WriteLn(OutFCsv, CsvLine(['Registry', 'Change Value', '',
              '', TCha[N], '', fVal, fDat, fPrv,
              ProcStrReg(TCha.Objects[N])]));
        FOR N := 0 TO TDelS.Count-1 DO
          WITH RegObject(TDelS.Objects[N]) DO
            WriteLn(OutFCsv, CsvLine(['Registry', 'Del Value', '',
//!!0.3              '', TDelS[N], '', fVal, '', '',
              '', TDelS[N], '', fVal, fDat, '',//!!0.3
              ProcStrReg(TDelS.Objects[N])]));
        CloseFile(OutFCsv);
        Append(OutFCsv);
        FixVxdRegTAddS;
        FixVxdRegTCha;
        FixVxdRegTDelS;
        IF TAdd.Count + TDel.Count + TCha.Count + TAddS.Count +
          TDelS.Count = 0 THEN
          begin
            WriteLn(OutFTxt, 'NO CHANGES IN Registry');
            WriteLn(OutFTxt);
          end
        ELSE
          begin
            WriteOutTxt(TAdd,'REGISTRY KEYS ADDED: ', 1);
            WriteOutTxt(TDel,'REGISTRY KEYS DELETED: ', 1);
            WriteOutTxt(TAddS,'REGISTRY KEY VALUES ADDED: ', 1);
            WriteOutTxt(TCha,'REGISTRY KEY VALUES CHANGED: ', 1);
            WriteOutTxt(TDelS,'REGISTRY KEY VALUES DELETED: ', 1);
          end;
        CloseFile(OutFTxt);
        Append(OutFTxt);
        ClearAll;
        TCha := GetAList(L_FilOpe);
        TAdd := GetAList(L_FilCre);
        TDel := GetAList(L_FilDel);
        TAddS := GetAList(L_DirCre);
        TDelS := GetAList(L_DirDel);
        FixVxdFilTCha;

        FixVxdFilTAdd;
        FixVxdFilTDel;

        StripSysFiles(TCha);
        StripSysFiles(TDel);
        StripSysFiles(TAdd);
        StripOurOwn(TAdd);
        StripOurOwn(TDel);
        StripOurOwn(TCha);
        IF TAdd.Count+TDel.Count+TCha.Count+TAddS.Count+
          TDelS.Count=0 THEN
          begin
            WriteLn(OutFTxt, 'NO CHANGES IN file system');
            WriteLn(OutFTxt);
          end
        ELSE
          begin
            WriteOutTxt(TAdd,'FILES ADDED: ', 2);
            WriteOutTxt(TDel,'FILES DELETED: ', 2);
            WriteOutTxt(TCha,'FILES CHANGED: ', 2);
            WriteOutTxt(TAddS,'DIRECTORIES ADDED: ', 2);
            WriteOutTxt(TDelS,'DIRECTORIES DELETED: ', 2);
          end;
        FOR N := 0 TO TAdd.Count-1 DO
          WriteLn(OutFCsv, CsvLine(['File', 'Add File',
            TAdd[N], '', '', '', '', '', '',
            ProcStr(TAdd.Objects[N])]));
        FOR N := 0 TO TDel.Count-1 DO
          WriteLn(OutFCsv, CsvLine(['File', 'Del File',
            TDel[N], '', '', '', '', '', '',
            ProcStr(TDel.Objects[N])]));
        FOR N := 0 TO TCha.Count-1 DO
          WriteLn(OutFCsv, CsvLine(['File', 'Change File',
            TCha[N], '', '', '', '', '', '',
            ProcStr(TCha.Objects[N])]));
        FOR N := 0 TO TAddS.Count-1 DO
          WriteLn(OutFCsv, CsvLine(['File', 'Add Dir',
            TAddS[N], '', '', '', '', '', '',
            ProcStr(TAddS.Objects[N])]));
        FOR N := 0 TO TDelS.Count-1 DO
          WriteLn(OutFCsv, CsvLine(['File', 'Del Dir',
            TDelS[N], '', '', '', '', '', '',
            ProcStr(TDelS.Objects[N])]));
        ClearAll;
      end;
  finally
    TAdd.Free;  TDel.Free;  TCha.Free;
    TAddS.Free; TDelS.Free;
    CloseFile(OutFTxt);
    CloseFile(OutFCsv);
    IF ReTrackMode = tmNone THEN
      begin
        meRept.Lines.LoadFromFile(ebReportName.Text);
        nbMain.PageIndex := nb_ProgComplete;
        TrackStatus := tsAllDone;
        TwoPhase := 0; // added so files will get deleted!
      end
    ELSE DoRetrack;
  end;
end; // end of LaunchDone
// twophase

procedure TMainForm.UpdateStatus(const S : String);
begin
  IF lbStatus.Caption <> S THEN
    begin
      lbStatus.Caption := S;
      lbStatus.Refresh;
    end;
end;

procedure TMainForm.PlaceEye(idx : Integer);
begin
  pnlStatEye.Top := lbStat[idx].Top;
end;

end.


  