unit pdthdu;

// Copyright  1999 by Ziff-Davis, Inc.
// Written by Neil J. Rubenking

// Version 4.1 - As it turns out, we cannot truly track all
// secondary install programs. Some techniques, such as a CD-based
// install that triggers auto-play, do an "end run" around InCtrl4's
// ability to track secondary install programs. AND the DEBUG_PROCESS
// tracking seems to interfere with certain installs. So, we
// simply remove the feature.


interface
uses Windows, Classes;
type
  // Thread to launch a program and watch until it *and*
  //   any secondary programs it launches have ended.
  //   If using VxD, each process is added to the internal
  //   list of tracked processes.
  TLaunchProgThread = class(TThread)
  protected
    fUseVxd         : Boolean;
    fObsfucator     : DWORD;
    fNumThds        : Integer;
    fCmdLine, fDir  : String;
    fUsingDebug     : Boolean;
    fCanTrackSub    : Boolean;
  public
    constructor Create(const vCmdLine, vDir: String;
      vUseVxd : Boolean; vObsfucator : DWORD; OnTerm : TNotifyEvent);
    procedure Execute; override;
    procedure ThdDone(Sender: TObject);
    function CanTrackSubInstall : Boolean;
    function UsingDebug : Boolean;
    function GetNumThds : Integer; //!!0.1
  end;

procedure StopThePresses;

implementation

uses CtrlTrap, sysUtils;


VAR
  AllStopEvent : THandle;

procedure StopThePresses;
begin
  SetEvent(AllStopEvent);
end;

const
  DBG_CONTINUE= $00010002;
type
  //  Simple thread to wait for process's termination
  TProcDoneThread = class(TThread)
  private
    fUseVxd     : Boolean;
    fProcHandle : THandle;
    fProcID     : DWORD;
  public
    Constructor Create(vProcHandle: THandle;
      vUseVxd : Boolean; vProcID : DWORD; OnTerm: TNotifyEvent);
    procedure Execute; override;
  end;

constructor TLaunchProgThread.Create(const vCmdLine, vDir :
  String; vUseVxd : Boolean; vObsfucator : DWORD;
  OnTerm : TNotifyEvent);
BEGIN
  Inherited Create(False);
  fObsfucator     := vObsfucator;
  fCmdLine        := vCmdLine;
  fDir            := vDir;
  fUseVxd         := vUseVxd;
  OnTerminate     := OnTerm;
  FreeOnTerminate := True;
  fNumThds        := 0;
  fUsingDebug     := False;
  fCanTrackSub    := False;
end;

procedure TLaunchProgThread.Execute;
VAR
  TSI        : TStartupInfo;
  TPI        : TProcessInformation;
  Rslt       : Boolean;
  TDB        : TDebugEvent;
  ThHan      : THandle;
  DupHan     : THandle;
begin
  ResetEvent(AllStopEvent);
  ThHan := 0;
  FillChar(TSI, SizeOf(TSI), 0);
  TSI.CB := SizeOf(TSI);
(*  Rslt := CreateProcess(NIL, PChar(fCmdLine), NIL, NIL, False,
    DEBUG_PROCESS OR DETACHED_PROCESS OR NORMAL_PRIORITY_CLASS,
    NIL, PChar(fDir), TSI, TPI);*) //!!0.1
  Rslt := False;
  IF Rslt THEN
    BEGIN
      fUsingDebug  := True;
      fCanTrackSub := True;
      CloseHandle(TPI.hThread);
      Inc(fNumThds);
      TProcDoneThread.Create(TPI.hProcess, fUseVxd,
        TPI.dwProcessID XOR fObsfucator, ThdDone);
    END
  ELSE
    begin
      // If CreateProcess failes, try without DEBUG_PROCESS
      Rslt := CreateProcess(NIL, PChar(fCmdLine), NIL, NIL, False,
        DETACHED_PROCESS OR NORMAL_PRIORITY_CLASS, NIL, PChar(fDir),
        TSI, TPI);
      IF Rslt THEN
        begin
          fUsingDebug  := false;
          fCanTrackSub := false;
          CloseHandle(TPI.hThread);
          Inc(fNumThds);
          WITH TProcDoneThread.Create(TPI.hProcess, fUseVxd,
            TPI.dwProcessID XOR fObsfucator, ThdDone) DO
            Thhan := Handle;
        end;
    end;
  IF fUseVxd THEN StartWatching;
  IF fUsingDebug THEN
    REPEAT
      // We receive notification of every "debug event", and
      // must call ContinueDebugEvent for each. If the event
      // is of the CREATE_PROCESS_EVENT type, we'll start
      // watching the new process.
      IF WaitForDebugEvent(TDB, 0) THEN
        begin
          IF TDB.dwDebugEventCode = CREATE_PROCESS_DEBUG_EVENT THEN
            begin
              Inc(fNumThds);
              // It's necessary under NT to create a duplicate handle
              // for our process-done-thread; the handle in the TDB
              // gets closed right away.
              IF NOT DuplicateHandle(GetCurrentProcess,
                TDB.CreateProcessInfo.hProcess, GetCurrentProcess,
                @DupHan, PROCESS_ALL_ACCESS, False, 0) THEN
                begin
                  fCanTrackSub := False;
                  DupHan       := TDB.CreateProcessInfo.hProcess;
                end;
              TProcDoneThread.Create(DupHan, fUseVxd,
                TDB.dwProcessID XOR fObsfucator, ThdDone);
            end;
          ContinueDebugEvent(TDB.dwProcessId, TDB.dwThreadId,
            DBG_CONTINUE);
        end
    UNTIL Terminated
  ELSE // Just wait until the single TProcDoneThread terminates
    WaitForSingleObject(ThHan, INFINITE);
end;

function TLaunchProgThread.CanTrackSubInstall : Boolean;
begin
  Result := fCanTrackSub;
end;

function TLaunchProgThread.UsingDebug : Boolean;
begin
  Result := fUsingDebug;
end;

function TLaunchProgThread.GetNumThds : Integer; //!!0.1
begin
  Result := fNumThds;
end;

procedure TLaunchProgThread.ThdDone(Sender: TObject);
begin
  Dec(fNumThds);
  IF fNumThds = 0 THEN
    Terminate;
end;

constructor TProcDoneThread.Create(vProcHandle: THandle;
  vUseVxd : Boolean; vProcID : DWORD; OnTerm: TNotifyEvent);
begin
  Inherited Create(False);
  fProcHandle      := vProcHandle;
  fProcID          := vProcID;
  fUseVxd          := vUseVxd;
  IF fUseVxd THEN
    AddAProcess(fProcID);
  OnTerminate     := OnTerm;
  FreeOnTerminate := True;
end;

procedure TProcDoneThread.execute;
VAR Waits : ARRAY[0..1] OF THandle;
begin
  Waits[0] := fProcHandle;
  Waits[1] := AllStopEvent;
  WaitForMultipleObjects(2, @Waits, False, INFINITE);
  CloseHandle(fProcHandle);
end;

initialization
  AllStopEvent := CreateEvent(nil, True, False, 'PC Magazine '+
    'INCTRL4 AllStop Event');
  ResetEvent(AllStopEvent);
finalization
  ResetEvent(AllStopEvent);
  CloseHandle(AllStopEvent);
end.
