unit pikigkey;

// Copyright  1999 by Ziff-Davis, Inc.
// Written by Neil J. Rubenking

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;

type
  TRegIgForm = class(TForm)
    btnRegEdit  : TButton;
    btnGetKey   : TButton;
    ebKey       : TEdit;
    lbValid     : TStaticText;
    btnValidate : TButton;
    btnHelp     : TButton;
    btnOK       : TButton;
    btnCancel   : TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnRegEditClick(Sender: TObject);
    procedure btnGetKeyClick(Sender: TObject);
    procedure ebKeyChange(Sender: TObject);
    procedure btnValidateClick(Sender: TObject);
    procedure btnHelpClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
    Opt : String;
  public
    { Public declarations }
    Key : String;
  end;

var
  RegIgForm: TRegIgForm;

implementation
USES IniFiles, Registry, in4Share, ShellApi;

{$R *.DFM}

procedure TRegIgForm.FormCreate(Sender: TObject);
begin
  Opt := Name+ ' Settings';
  WITH TIniFile.Create(iniName) DO
  try
    Width  := ReadInteger(Opt, 'Width', Constraints.MinWidth);
    Height := ReadInteger(Opt, 'Height', Constraints.MinHeight);
    Left   := ReadInteger(Opt, 'Left', (Screen.Width - Width) DIV 2);
    IF Left + Width > Screen.Width THEN
      Left := Screen.Width - Width;
    Top    := ReadInteger(Opt, 'Top', (Screen.Height -Height) DIV 2);
    IF Top + Height > Screen.Height THEN
      Top := Screen.Height - Height;
  finally
    Free;
  end;
end;

procedure TRegIgForm.FormDestroy(Sender: TObject);
begin
  WITH TIniFile.Create(iniName) DO
  try
    WriteInteger(Opt, 'Width',  Width);
    WriteInteger(Opt, 'Height', Height);
    WriteInteger(Opt, 'Left',   Left);
    WriteInteger(Opt, 'Top',    Top);
  finally
    Free;
  end;
end;

procedure TRegIgForm.btnRegEditClick(Sender: TObject);
VAR
  Buffer : ARRAY[0..MAX_PATH] OF Char;
  REH    : HWnd;
begin
  REH := FindWindow('RegEdit_RegEdit', nil);
  IF REH <> 0 THEN
    BringWindowToTop(REH)
  ELSE
    begin
      IF (FindExecutable('REGEDIT.EXE', nil, Buffer) <= 32) OR
        (WinExec(Buffer, SW_SHOWNORMAL) <= 32) THEN
        MessageBox(Handle, 'Please launch REGEDIT manually.',
          'InCtrl4', MB_OK OR MB_ICONINFORMATION);
    end;
end;

procedure TRegIgForm.btnGetKeyClick(Sender: TObject);
VAR
  REH    : HWnd;
  SBH    : HWnd;
  Buffer : ARRAY[0..2*MAX_PATH] OF Char;
  S      : String;
  P      : Integer;
begin
  REH := FindWindow('RegEdit_RegEdit', nil);
  IF REH > 0 THEN
    begin
      SBH := FindWindowEx(REH, 0, 'msctls_statusbar32', nil);
      IF SBH <> 0 THEN
        begin
          GetWindowText(SBH, Buffer, 2*MAX_PATH);
          SendMessage(SBH, WM_GETTEXT, 2*MAX_PATH, Integer(@Buffer));
          S := Strpas(Buffer);
          P := Pos('\', S);
          Delete(S, 1, P);
          ebKey.Text := S;
        end
      ELSE MessageBox(Handle, 'Unable to extract the key. Please '+
        'copy the key manually.', 'InCtrl4',
        MB_OK OR MB_ICONSTOP);
    end
  ELSE MessageBox(Handle, 'Unable to locate REGEDIT. Please be '+
    'sure REGEDIT is running, or copy the key manually.',
    'InCtrl4', MB_OK OR MB_ICONSTOP);
end;

procedure TRegIgForm.ebKeyChange(Sender: TObject);
begin
  lbValid.Caption := '';
  btnOK.Enabled := False;
end;

procedure TRegIgForm.btnValidateClick(Sender: TObject);
VAR
  hRoot : DWORD;
  S     : String;
  P     : Integer;
begin
  S := trim(ebKey.Text);
  Key := S;
  IF Pos('HKEY_USERS', S) > 0 THEN
    hRoot := HKEY_USERS
  ELSE IF Pos('HKEY_LOCAL_MACHINE', S) > 0 THEN
    hRoot := HKEY_LOCAL_MACHINE
  ELSE
    begin
      lbValid.Caption := 'Key must be in HKEY_USERS or HKEY_LOCAL'+
        '_MACHINE. Click Help.';
      Exit;
    end;
  P := Pos('\', S);
  IF (P = 0) OR (P=Length(S)) THEN
    begin
      lbValid.Caption := 'Enter a non-empty subkey.';
      Exit;
    end;
  Delete(S, 1, P);
  WITH TRegistry.Create DO
  try
    RootKey := hRoot;
    IF OpenKey(S, False) THEN
      begin
        lbValid.Caption := 'Valid key';
        btnOK.Enabled := True;
      end
    ELSE
      lbValid.Caption := 'Non-existent key, or access denied';
  finally
    Free;
  end;
end;

procedure TRegIgForm.btnHelpClick(Sender: TObject);
begin
  Application.HelpContext(65);
end;

procedure TRegIgForm.FormResize(Sender: TObject);
begin
  ebKey.Width     := ClientWidth - 7;
  lbValid.Width   := ClientWidth - 7;
  btnOK.Left      := ClientWidth - 3 - btnOK.Width;
  btnCancel.Left  := btnOK.Left - 10 - btnCancel.Width;
  btnHelp.Left    := btnCancel.Left - 10 - btnHelp.Width;
end;

end.

