unit inioptu;

// Copyright  1999 by Ziff-Davis, Inc.
// Written by Neil J. Rubenking

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  optbaseu, Dialogs, StdCtrls, ExtCtrls;

type
  TTrackIniForm = class(TOptForm)
    OpenDialog1: TOpenDialog;
    procedure btnAddClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TrackIniForm: TTrackIniForm;

implementation
USES In4Share;

{$R *.DFM}

procedure TTrackIniForm.btnAddClick(Sender: TObject);
begin
  inherited;
  WITH OpenDialog1 DO
    begin
      InitialDir := windir;
      Options := Options - [ofExtensionDifferent];
      IF NOT Execute THEN Exit;
      IF ofExtensionDifferent IN Options THEN
        begin
          MessageBeep(MB_ICONSTOP);
          MessageDlg(Format('"%s" is not an .INI file.',[Filename]),
            mtWarning, [mbok], 0);
          Exit;
        end;
      IF lbMain.Items.IndexOf(lowercase(Filename)) >= 0 THEN
        begin
          MessageBeep(MB_ICONSTOP);
          MessageDlg(Format('"%s" is already present on the list.',
            [Filename]), mtWarning, [mbok], 0);
          Exit;
        end;
      IF NOT ValidINI(Filename) THEN
        begin
          MessageBeep(MB_ICONSTOP);
          MessageDlg(Format('Although "%s" has the .INI extension, '+
            'it does not appear to be an .INI file.', [Filename]),
            mtWarning, [mbok], 0);
          Exit;
        end;
      lbMain.Items.Add(lowercase(Filename));
    end;
end;

end.
  