unit diskoptu;

// Copyright  1999 by Ziff-Davis, Inc.
// Written by Neil J. Rubenking

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  optbaseu, Dialogs, StdCtrls, ExtCtrls;

type
  TTrackDirForm = class(TOptForm)
    procedure btnAddClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  TrackDirForm: TTrackDirForm;

implementation
uses shlobj, activeX, in4Share;

{$R *.DFM}

procedure BrowseCallBackProc(hWindow : HWND; uMsg : Integer;
  lParam : LPARAM; lpData : Integer); stdCall;
VAR buffer : ARRAY[0..MAX_PATH] OF Char;
  Drv : ARRAY[0..4] OF Char;
begin
  IF uMsg = BFFM_SELCHANGED THEN
    begin
      SHGetPathFromIDList(PItemIDList(lParam), buffer);
      // Display the current selection
      SendMessage(hWindow, BFFM_SETSTATUSTEXT, 0, Integer(@buffer));
      StrLCopy(Drv, Buffer, 3);
      // Enable the OK button only if this is a local or remote
      // hard disk
      CASE GetDriveType(Drv) OF
        DRIVE_FIXED,
        DRIVE_REMOTE : SendMessage(hWindow, BFFM_ENABLEOK, 0, 1);
        ELSE SendMessage(hWindow, BFFM_ENABLEOK, 0, 0);
      END;
    end;
end;

procedure TTrackDirForm.btnAddClick(Sender: TObject);
VAR
  TB     : TBrowseInfo;
  IDL    : PItemIdList;
  buffer : ARRAY[0..MAX_PATH] OF Char;
begin
  inherited;
  FillChar(TB, SizeOf(TB), 0);
  WITH TB DO
    begin
      SHGetSpecialFolderLocation(Handle, CSIDL_DRIVES, pIdlRoot);
      lpszTitle := 'Select a drive or folder for tracking';
      ulFlags := BIF_RETURNONLYFSDIRS OR BIF_DONTGOBELOWDOMAIN OR
        BIF_STATUSTEXT;
      lpfn := @BrowseCallBackProc;
    end;
  IDL := SHBrowseForFolder(TB);
  try
    IF IDL <> nil THEN
      begin
        SHGetPathFromIDList(IDL, Buffer);
        CASE AddToHierList(lbMain.Items, StrPas(Buffer)) OF
          ADL_OK    :;
          ADL_BELOW : begin
            MessageBeep(MB_ICONSTOP);
            MessageDlg(Format('The folder "%s" was not '+
              'added, because it is a subfolder of another folder '+
              'that is already present in the list.', [Buffer]),
              mtInformation, [mbok], 0);
          end;
          ADL_ABOVE : begin
            MessageBeep(MB_ICONSTOP);
            MessageDlg(Format('The folder "%s" was added, replacing'+
              ' one or more of its own subfolders in the list.',
              [Buffer]), mtInformation, [mbok], 0);
          end;
          ADL_DUPE  : begin
            MessageBeep(MB_ICONSTOP);
            MessageDlg(Format('The folder "%s" is '+
              'already present in the list.', [Buffer]),
              mtInformation, [mbok], 0);
          end;
        END;
      end;
  finally
    CoTaskMemFree(TB.pIdlRoot);
    CoTaskMemFree(IDL);
  end;
end;

end.
 