unit pdthdu;
interface
uses Windows, Classes;
type
  TProcDoneThread = class(TThread)
    ProcHandle : THandle;
    Constructor Create(vProcHandle: THandle; OnTerm: TNotifyEvent);
    procedure Execute; override;
  end;

implementation

constructor TProcDoneThread.Create(vProcHandle: THandle;
  OnTerm: TNotifyEvent);
begin
  Inherited Create(False);
  ProcHandle      := vProcHandle;
  OnTerminate     := OnTerm;
  FreeOnTerminate := True;
end;

procedure TProcDoneThread.execute;
begin
  WaitForSingleObject(ProcHandle, INFINITE);
  CloseHandle(ProcHandle);
end;

end.
