/******************************************************************\
*                                                                  *
*		   w       w                oooo                           *
*		   w       w  iii  n   n   o    o   n   n  eeee            *
*		   w       w   i   nn  n  o      o  nn  n  e               *
*		   w   w   w   i   n n n  o      o  n n n  eee             *
*	  	    w w w w    i   n  nn   o    o   n  nn  e               *
*	 	     w   w    iii  n   n    oooo    n   n  eeee            *
*								   								   *
*     C o m m a n d   L a n g u a g e   I n t e r p r e t e r      *
*								   								   *
*								   								   *
*	Written by Lucien Cinc                                         *
*	Copyright (c) 1992, 1993                                       *
*																   *
*																   *
*	For a complete description of all the functions in this file   *
*	see the  WOIO.HLP help file. WOIO.HLP is located in the sub-   *
*	directory WOIO, for example :-                                 *
*                                                                  *
*					C:\WIN_ONE\WOIO\WOIO.HLP                       *
*                                                                  *
*	Note: To view this  file from  WinOne use the  /4 switch for   *
*		  command  TYPE,  since  I use  only  4 spaces  for  tab   *
*		  characters, for example :-                               *
*                                                                  *
*					TYPE WOIO.H /4                                 *
*																   *
\******************************************************************/

#ifndef __WOIO_H
#define __WOIO_H

#include <windows.h>

/*
	include stdio.h here so that the macros putchar
	and getchar	can be removed!
*/

#include <stdio.h>

#ifndef _FFBLK_DEF
#define _FFBLK_DEF
struct  ffblk   {
    long            ff_reserved;
	long            ff_fsize;
    unsigned long   ff_attrib;
    unsigned short  ff_ftime;
    unsigned short  ff_fdate;
	char            ff_name[256];
};
#endif

#ifdef putchar
#undef putchar
#endif	/* putchar */

#ifdef getchar
#undef getchar
#endif	/* getchar */

#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */

/*
    The system colours below should always be
    used instead of the fix colours. The system
    colours allow the user to change to 
    different colour schemes.
*/

#define COL_FILENAME	(char )144	/* system text colours */
#define COL_HIGHFNAME	(char )145
#define COL_NUMBER		(char )146
#define COL_TEXT		(char )147
#define COL_HIGHTEXT	(char )148
#define COL_BOLDTEXT	(char )149
#define COL_ENVNAME		(char )150
#define COL_ENVSTR		(char )151
#define COL_ERROR		(char )152
#define COL_LHS			(char )153
#define COL_HIGHLHS		(char )154
#define COL_RHS			(char )155
#define COL_FILEDATE	(char )156
#define COL_FILETIME	(char )157
#define COL_FILEATTRIB	(char )158
#define COL_FILEDESC	(char )159

#define BLACK			(char )128   /* fixed text colours */
#define	RED     		(char )129
#define GREEN			(char )130
#define BLUE			(char )131
#define YELLOW 			(char )132
#define MAGENTA			(char )133
#define CYAN			(char )134
#define WHITE			(char )135
#define LIGHTGRAY		(char )136
#define LIGHTRED		(char )137
#define LIGHTGREEN		(char )138
#define LIGHTBLUE		(char )139
#define BROWN			(char )140
#define LIGHTMAGENTA	(char )141
#define LIGHTCYAN		(char )142
#define DARKGRAY		(char )143

/*******************************\
*								*
*	    Control Functions		*
*								*
\*******************************/

#define BUFFERED	1		/* screen output */
#define UNBUFFERED	0

void screen(int flag);					/* buffered screen output */
void yield(void);						/* alow other tasks to multitask */

/*******************************\
*								*
*	 Screen Output Functions	*
*								*
\*******************************/

int  printf(const char *fmt, ...);  	/* printf formated output */
int  puts(const char *s);				/* string output + CR-LF */
int  putchar(const int c);				/* character output	*/
int  putch(int c);						/* character output	*/
void perror(const char *msg);			/* display an error message	*/
void textcolor(int col);				/* set the text colour */

void clrscr(void);						/* clear the screen */
void clreol(void);						/* clear till end of line */
void gotoxy(int x, int y);				/* position cursor on screen */
int  wherex(void);						/* location of caret (horizontal) */
int  wherey(void);						/* location of caret (vertical) */

int scrwidth(void);						/* screen width in characters */
int scrheight(void);					/* screen height in character */

void scrflush(void);					/* update the screen */
void insline(int line);					/* insert a line on the screen */
void delline(int line);					/* delete a line on the screen */
void scroll(int start, int end, int num);	/* scroll area of screen */


char *atoc(char *number);				/* insert comma's into a number */

/*******************************\
*								*
*	     Input Functions		*
*								*
\*******************************/

int  scanf(const char *fmt, ...);		/* scanf formated input	*/
char *gets(char *s);					/* get a string	*/
int  getchar(void);						/* get a character */
int  getch(void);						/* get a character no echo */

/*******************************\
*								*
*	 Command Line Functions		*
*								*
\*******************************/

int  argc(void);						/* number of arguments */
char *argv(int index);				 	/* get an argument */
int  argn(void);						/* number of switches */
char *args(void);						/* get all switches */

char *argpath(int index);				/* get path argument */
char *argabs(int index);				/* get absolute path argument */
char *argtail(void);					/* get command line tail */

/*******************************\
*								*
*	   Status Bar Functions		*
*								*
\*******************************/

void limit(unsigned long upper);		/* status bar upper limit */
void inc(unsigned long value);			/* status bar increment by value */
void empty(void);						/* empty status bar */

/*******************************\
*								*
*  File manipulation Functions	*
*								*
\*******************************/

#define INC_BYTE	0	// u_flag's for status bar updating
#define INC_ONE		1
#define INC_NONE	2

#define O_OPEN		0	// o_flag's for opening dest file
#define O_CREATE    1
#define O_CREATNEW  2

long filesize(char *path);
long filecpy(char *dst, char *src, int o_flag, int u_flag);
long filecat(char *dst, char *src, int u_flag);

long filencpy(char *dst, char *src, long num, long offset, int o_flag, int u_flag);
long filencat(char *dst, char *src, long num, long offset, int u_flag);

/*******************************\
*								*
*	   File Name Functions		*
*								*
\*******************************/

#define ATT_RHSDA 	(unsigned int )(FA_RDONLY|FA_HIDDEN|FA_SYSTEM|FA_DIREC|FA_ARCH)
#define ATT_RHSA 	(unsigned int )(FA_RDONLY|FA_HIDDEN|FA_SYSTEM|FA_ARCH)

int fillfile(char *path, unsigned int attr);	/* block file fill */
BOOL getfile(int index, struct ffblk *pff);		/* get file ffblk */
char *getfilepath(int index);     				/* get file path, may not be a fully qualified path */
char *getfilename(int index);					/* get file name */
char *padfilename(char *path);                  /* pad a filename for displaying */

int istextfile(char *path);						/* TRUE when path is a text file */

/*******************************\
*								*
*	 	 Path Functions			*
*								*
\*******************************/

int fillpath(char *path);				/* block path fill */
int fillpathall(void);					/* block path fill for all drives */
void freepaths(void);					/* free paths */
char *getpath(int index);				/* get a path */

/*******************************\
*								*
*   Unix conversion functions   *
*								*
\*******************************/

int isunix(void);						/* unix mode flag */
char *tounix(char *cmd);				/* convert dos command to unix */
char *todos(char *cmd);					/* convert unix command to dos */

/*******************************\
*								*
*  File Description Functions	*
*								*
\*******************************/

char *getdesc(char *path);				/* get a file description */
int setdesc(char *path, char *str);		/* set a file description */
int deldesc(char *path);				/* delete a file description */

/*******************************\
*								*
*    Environment Functions		*
*								*
\*******************************/

char *getenvironment(char *name);		/* get WinOne environment variable */
int putenvironment(char *name);			/* set WinOne environment variable */

/*******************************\
*								*
*       Global Variables	    *
*								*
\*******************************/

HINSTANCE gethinst(void);

extern char *arg_v[];			/* argv */
extern int arg_c;				/* argc */
extern int errcnt;				/* perror counter */

extern int main(void);	/* program entry point */

#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif	/* __WOIO_H */
