/******************************************************************\
*                                                                  *
*          w       w                oooo                           *
*          w       w  iii  n   n   o    o   n   n  eeee            *
*          w       w   i   nn  n  o      o  nn  n  e               *
*          w   w   w   i   n n n  o      o  n n n  eee             *
*           w w w w    i   n  nn   o    o   n  nn  e               *
*            w   w    iii  n   n    oooo    n   n  eeee            *
*                                                                  *
*     C o m m a n d   L a n g u a g e   I n t e r p r e t e r      *
*                                                                  *
*                                                                  *
*   External Command ARGS                                          *
*   Written by Lucien Cinc                                         *
*   Copyright (c) 1993                                             *
*                                                                  *
\******************************************************************/

#include "args.h"

//	table colours

#define COLTAB	DARKGRAY	// colour of table
#define COLHEAD	COL_HIGHTEXT		// colour of headings
#define COLFN	COL_TEXT	// colour of function names
#define COLVAR	COLFN		// colour of global variables
#define COLARG	COL_HIGHTEXT		// colour of command line args
#define COLNUM	COL_NUMBER		// colour of numbers

int main(void)
{
    char *sp;
	int i, n;

    screen(BUFFERED);

	// command line argument functions

	textcolor(COLTAB);
	printf("                  %cCommand line argument functions%c\n", COLHEAD, COLTAB);
    printf(" ---+---------------------------------------------------------------\n");
	printf("  %cn %c|                         %cargv(n)%c\n",
				COLFN, COLTAB, COLFN, COLTAB);
	printf(" ---+---------------------------------------------------------------\n");
	n = argc();
	for (i = 0;i <= n;i++) {

		printf(" %c%2d %c| %c%-s%c\n",
				COLNUM, i, COLTAB, COLARG, argv(i), COLTAB);

    }
	printf(" ---+---------------------------------------------------------------\n");
	printf("  %cargc()    %c= %c%2d%c\n", COLFN, COLTAB, COLNUM, n, COLTAB);
	printf("  %cargn()    %c= %c%2d%c, %cargs() %c= %c%s%c\n",
				COLFN, COLTAB, COLNUM, argn(), COLTAB, COLFN, COLTAB, COLARG, args(), COLTAB);
	printf("  %cargtail() %c= %c%s%c\n", COLFN, COLTAB, COLARG, argtail(), COLTAB);

	// command line argument path functions

	printf(" ---+-------------------------------+-------------------------------\n");
	printf("  %cn %c|          %cargpath(n)           %c|            %cargabs(n)          %c\n",
				COLFN, COLTAB, COLFN, COLTAB, COLFN, COLTAB);
	printf(" ---+-------------------------------+-------------------------------\n");
	for (i = 0;i <= n;i++)
		printf(" %c%2d %c| %c%-29s %c| %c%-29s%c\n",
					COLNUM, i, COLTAB, COL_FILENAME, argpath(i), COLTAB, COL_FILENAME, argabs(i), COLTAB);
	printf(" ---+-------------------------------+-------------------------------\n\n\n\n");

	// Command line argument global variables

	printf("              %cCommand line argument global variables%c\n", COLHEAD, COLTAB);
	printf(" ---+---------------------------------------------------------------\n");
	printf("  %cn %c|                         %carg_v[n]%c\n",
				COLVAR, COLTAB, COLVAR, COLTAB);
	printf(" ---+---------------------------------------------------------------\n");
	for (i = 0;i <= arg_c;i++)
		printf(" %c%2d %c| %c%s%c\n", COLNUM, i, COLTAB, COLARG, arg_v[i], COLTAB);
	printf(" ---+---------------------------------------------------------------\n");
	printf("  %carg_c %c= %c%d%c\n", COLVAR, COLTAB, COLNUM, arg_c, COLTAB);
	printf(" -------------------------------------------------------------------\n");

    screen(UNBUFFERED);

	return 0;     // all ok
}





