{Just a note about my source code.  It ain't pretty, but does the job (usually) I am making it available not
so much for people to remake the binary clock (which you can) but rather to utuilize the smaller examples
within to do things like make tranparent backgrounds, etc.}

unit BBinaryClock1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Math, Registry;

type
  TForm1 = class(TForm)
    Image1: TImage;
    Panel1: TPanel;
    Timer1: TTimer;
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure DrawRoundRectRegion(wnd : HWND; wrect : TRect);
    procedure Panel1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Panel1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Panel1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Image1DblClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SwitchLights(SL1,SL2 : integer);
    procedure SwitchPM;
    procedure MapBackGround;
    procedure RepaintForm;
  private
    { Private declarations }
     rgn  : HRGN;              {These are needed for the DrawRectRegion stuff}
     wrect : TRect;
     LbDown : boolean;
  public
    { Public declarations }
  end;

var
  Form1                                  : TForm1;
  IntMe,PadY,IWide,IHigh,CHigh,CWide     : longint;
  Blink,Moveable                         : boolean;
  Seconds,PmLite,FTime,LeastTop,HideIt   : boolean;
  NewStr,OldStr,DiffStr,S1,S2,PicStr     : string;
  OldBStr,BStr,OldPM,TempStr5            : string;
  TempStr1,TempStr2,TempStr3,TempStr4    : string;
  Int1,FH,Pad,K,LedSize                  : integer;
  ImageOn                                : array [0..2,0..5] of Boolean;  {LED Lights array}
  DC                                     : HDc;
  Canv                                   : TCanvas;
  LedOnIn, LedOnOut, LedOffIn, LedOffOut : TColor;
  HighLightOn,HighLightOff,Backgrnd      : TColor;
  PMWide,Back,FirstTime,MaxHeight,MaxWidth : integer;
  DriveStr,DirectoryStr,TopPos           : string;
  Military,OnTop                         : integer;
  OldP, OldQ                             : TPoint;

implementation

uses BBinaryClock4,BBinaryClock3;

{$R *.DFM}

procedure TForm1.MapBackGround;   {Copy the desktop background onto the TImage canvas...}
begin
   Form1.Visible:=false;
   DC          := GetWindowDC( GetDeskTopWindow );
   Canv        := TCanvas.Create;
   Canv.Handle := DC;
   BitBlt(Form1.Image1.Canvas.handle,0,0,Form1.Image1.Width,Form1.Image1.Height,DC,Form1.Left,Form1.Top+PadY,SRCCOPY);
   ReleaseDC( GetDeskTopWindow, DC );
   Form1.Visible:=true;
   Form1.Refresh;
end;

function LoadStringFromRegistry(sKey, sItem, sDefVal : string): string;  {Read from the registry}
var
  reg : TRegIniFile;
begin
  reg := TRegIniFile.Create( sKey );
  Result := reg.ReadString('', sItem, sDefVal);
  reg.Free;
end;

procedure SaveStringToRegistry(sKey, sItem, sVal : string );      {Write to the registry}
var
  reg : TRegIniFile;
begin
  reg := TRegIniFile.Create( sKey );
  reg.WriteString('', sItem, sVal + #0);
  reg.Free;
end;

procedure TForm1.DrawRoundRectRegion(wnd : HWND; wrect : TRect);  {Draw the form as a rounded rectangle}
begin
  rgn := CreateRoundRectRgn(wrect.left, wrect.top, wrect.right, wrect.bottom, (LEDSize), (LEDSize));
  SetWindowRgn(wnd, rgn, TRUE);
end;

procedure TForm1.RepaintForm;  {Repaint all the various items in the form (image, leds, etc.)}
var
   NewRect: TRect;
   I,J : integer;
begin
   if (Back=2) then MapBackground;
   if (Back=0) then
      begin
         Form1.Image1.Canvas.Brush.Color:=Backgrnd;
         NewRect := Rect(0, 0, Form1.Image1.Width, Form1.Image1.Height);
         Form1.Image1.Canvas.FillRect(NewRect);
      end;
   If ((Back=1)and (PicStr<>'')) then
      begin
         try Image1.Picture.LoadFromFile(PicStr);
         except
            on EInvalidGraphic do
               begin
                  ShowMessage('Invalid graphic name.');
               end;
            on EFOpenError do
               begin
                  ShowMessage('Could not open the graphic file requested.');
               end;
         end;
      end;
   ClientHeight:=Round((LEDSize*6.2));
   ClientWidth :=Round((LEDSize*4.2));
   if (not(Seconds) and not(PMLite)) then
      begin
         ClientWidth:=Round(LEDSize*2.2);
         Image1.Width:=ClientWidth;
      end
   else
   if (not(Seconds) and (PMLite)) then
      begin
         ClientWidth:=Round(LEDSize*3.3);
         Image1.Width:=ClientWidth;
      end
   else
   if ((Seconds) and Not(PMLite)) then
      begin
         ClientWidth:=Round(LEDSize*3.3);
         Image1.Width:=ClientWidth;
      end;
   SetWindowPos(Form1.Handle,HWND_BOTTOM,Form1.Left,Form1.Top,Form1.Width,Form1.Height,SWP_NOMOVE);
   DrawRoundRectRegion(Form1.Handle, Form1.ClientRect);
   Image1.Height:=ClientHeight;
   Image1.Width:=ClientWidth;
   OldBStr:='0000000000000000000000000';

    if not(LeastTop) then
       begin
          For I := 0 to 2 do
             For J := 0 to 5 do
                begin
                   ImageOn[I,J]:=True;
                   SwitchLights(I,J);
                end;
       end
    else
       begin
          For I := 0 to 2 do
             For J :=  5 downto 0 do
                begin
                   ImageOn[I,J]:=True;
                   SwitchLights(I,J);
                end;
       end;

   SwitchPM;
   SwitchPM;

   if (PMLite) then
      begin
         Image1.Canvas.Font.Color:=$0000FF80;
         Image1.Canvas.Font.Name:='Unknown';
         Image1.Canvas.Font.Size:=LEDSize div 3;
         Image1.Canvas.Brush.Color := clBlack;
         PMWide:=Image1.Canvas.TextWidth('PM');
         if (Seconds) then Image1.Canvas.TextOut((((2*LEDSize)+1+LEDSize)+trunc((LEDSize-PMWide) div 2))-1,2*LEDSize+1,'PM')
         else Image1.Canvas.TextOut((((round(1*LEDSize))+1+LEDSize)+trunc((LEDSize-PMWide) div 2))-1,2*LEDSize+1,'PM');
      end;

end;

procedure TForm1.SwitchLights(SL1,SL2 : integer);   {This routine switches the LEDS on or off. It is a     }
                                                    {major pain since I opted not to use matrix multiplying}
                                                    {but did trial and error using the LED size to determine}
                                                    {the location of the leds.}
begin
   If (ImageOn[Sl1,SL2]=false) then
       begin
          case SL1 of
             0  : Pad:=0;
             1  : Pad:=0;
             2  : Pad:=0;
          end;
          ImageOn[SL1,SL2]:=true;
          Form1.Image1.Canvas.Pen.Color:=LedOnOut;
          Form1.Image1.Canvas.Brush.Color:=LedOnOut;
          Form1.Image1.Canvas.Brush.Style:=bsSolid;
          if ((SL1<2) or ((SL1>1) and (Seconds))) then Form1.Image1.Canvas.Ellipse((SL1*LEDSize)+1+Pad,SL2*LEDSize+1,(SL1*LEDSize)+LEDSize+Pad,(SL2*LEDSize)+LEDSize);
          Form1.Image1.Canvas.Pen.Color:=LedOnIn;
          Form1.Image1.Canvas.Brush.Color:=LedOnIn;
          Form1.Image1.Canvas.Brush.Style:=bsSolid;
          if ((SL1<2) or ((SL1>1) and (Seconds))) then Form1.Image1.Canvas.Ellipse((SL1*LEDSize)+((LEDSize div 8)+1)+Pad,SL2*LEDSize+((LEDSize div 8)+1),(SL1*LEDSize)+(LEDSize-(LEDSize div 8))+Pad,(SL2*LEDSize)+(LEDSize-(LEDSize div 8)));
          Form1.Image1.Canvas.Pen.Color:=HighLightOn;
          Form1.Image1.Canvas.Brush.Color:=HighLightOn;
          Form1.Image1.Canvas.Brush.Style:=bsSolid;
          if ((SL1<2) or ((SL1>1) and (Seconds))) then Form1.Image1.Canvas.Ellipse((SL1*LEDSize)+((LEDSize div 3))+Pad,SL2*LEDSize+((LEDSize div 3)),(SL1*LEDSize)+((LEDSize div 3))+Pad+(LEDSize div 5),(SL2*LEDSize)+((LEDSize div 3))+(LEDSize div 5));
          if ((SL1<2) or ((SL1>1) and (Seconds))) then Form1.Image1.Repaint;
       end
   else
       begin
          case SL1 of
             0  : Pad:=0;
             1  : Pad:=0;
             2  : Pad:=0;
          end;
          ImageOn[SL1,SL2]:=false;
          Form1.Image1.Canvas.Pen.Color:=LedOffOut;
          Form1.Image1.Canvas.Brush.Color:=LedOffOut;
          Form1.Image1.Canvas.Brush.Style:=bsSolid;
          if ((SL1<2) or ((SL1>1) and (Seconds))) then Form1.Image1.Canvas.Ellipse((SL1*LEDSize)+1+Pad,SL2*LEDSize+1,(SL1*LEDSize)+LEDSize+Pad,(SL2*LEDSize)+LEDSize);
          Form1.Image1.Canvas.Pen.Color:=LedOffIn;
          Form1.Image1.Canvas.Brush.Color:=LedOffIn;
          Form1.Image1.Canvas.Brush.Style:=bsSolid;
          if ((SL1<2) or ((SL1>1) and (Seconds))) then Form1.Image1.Canvas.Ellipse((SL1*LEDSize)+((LEDSize div 8)+1)+Pad,SL2*LEDSize+((LEDSize div 8)+1),(SL1*LEDSize)+(LEDSize-(LEDSize div 8))+Pad,(SL2*LEDSize)+(LEDSize-(LEDSize div 8)));
          Form1.Image1.Canvas.Pen.Color:=HighLightOff;
          Form1.Image1.Canvas.Brush.Color:=HighLightOff;
          Form1.Image1.Canvas.Brush.Style:=bsSolid;
          if ((SL1<2) or ((SL1>1) and (Seconds))) then Form1.Image1.Canvas.Ellipse((SL1*LEDSize)+((LEDSize div 3))+Pad,SL2*LEDSize+((LEDSize div 3)),(SL1*LEDSize)+((LEDSize div 3))+Pad+(LEDSize div 5),(SL2*LEDSize)+((LEDSize div 3))+(LEDSize div 5));
          if ((SL1<2) or ((SL1>1) and (Seconds))) then Form1.Image1.Repaint;
       end;

    {If the form is off the screen for some reason, put it back...}

     MaxHeight:=GetSystemMetrics(SM_CYMAXIMIZED);
     MaxWidth:=GetSystemMetrics(SM_CXMAXIMIZED);
     If (MaxHeight-Form1.Height<Form1.Top) then Form1.Top:=MaxHeight-Form1.Height;
     If (MaxWidth-Form1.Width<Form1.Left) then Form1.Left:=MaxWidth-Form1.Width;
     if (Form1.Top<1) then Form1.Top:=1;
     if (Form1.Left<1) then Form1.Left:=1;
end;

procedure TForm1.SwitchPM;  {Seperate routine for the PM led}
var
   YPad  : integer;
   XPad  : real;
begin
   If (Seconds) then XPad:=2
   else XPad:=1;
   YPad:=1;
   Pad:=(LEDSize);
   If ((PMLite) and (OldPM='AM')) then
       begin
          OldPM:='PM';
          Form1.Image1.Canvas.Pen.Color:=LEDOnOut;
          Form1.Image1.Canvas.Brush.Color:=LEDOnOut;
          Form1.Image1.Canvas.Brush.Style:=bsSolid;
          Form1.Image1.Canvas.Ellipse((round(XPad*LEDSize))+1+Pad,YPad*LEDSize+1,(round(XPad*LEDSize))+LEDSize+Pad,(YPad*LEDSize)+LEDSize);
          Form1.Image1.Canvas.Pen.Color:=LEDOnIn;
          Form1.Image1.Canvas.Brush.Color:=LEDOnIn;
          Form1.Image1.Canvas.Brush.Style:=bsSolid;
          Form1.Image1.Canvas.Ellipse((round(XPad*LEDSize))+((LEDSize div 8)+1)+Pad,YPad*LEDSize+((LEDSize div 8)+1),(round(XPad*LEDSize))+(LEDSize-(LEDSize div 8))+Pad,(YPad*LEDSize)+(LEDSize-(LEDSize div 8)));
          Form1.Image1.Canvas.Pen.Color:=HighLightOn;
          Form1.Image1.Canvas.Brush.Color:=HighLightOn;
          Form1.Image1.Canvas.Brush.Style:=bsSolid;
          Form1.Image1.Canvas.Ellipse((round(XPad*LEDSize))+((LEDSize div 3))+Pad,YPad*LEDSize+((LEDSize div 3)),(round(XPad*LEDSize))+((LEDSize div 3))+Pad+(LEDSize div 5),(YPad*LEDSize)+((LEDSize div 3))+(LEDSize div 5));
          Form1.Image1.Repaint;
       end
   else
   if (PMLite) then
       begin
          OldPM:='AM';
          Form1.Image1.Canvas.Pen.Color:=LEDOffOut;
          Form1.Image1.Canvas.Brush.Color:=LEDOffOut;
          Form1.Image1.Canvas.Brush.Style:=bsSolid;
          Form1.Image1.Canvas.Ellipse((round(XPad*LEDSize))+1+Pad,YPad*LEDSize+1,(round(XPad*LEDSize))+LEDSize+Pad,(YPad*LEDSize)+LEDSize);
          Form1.Image1.Canvas.Pen.Color:=LEDOffIn;
          Form1.Image1.Canvas.Brush.Color:=LEDOffIn;
          Form1.Image1.Canvas.Brush.Style:=bsSolid;
          Form1.Image1.Canvas.Ellipse((round(XPad*LEDSize))+((LEDSize div 8)+1)+Pad,YPad*LEDSize+((LEDSize div 8)+1),(round(XPad*LEDSize))+(LEDSize-(LEDSize div 8))+Pad,(YPad*LEDSize)+(LEDSize-(LEDSize div 8)));
          Form1.Image1.Canvas.Pen.Color:=HighLightOff;
          Form1.Image1.Canvas.Brush.Color:=HighLightOff;
          Form1.Image1.Canvas.Brush.Style:=bsSolid;
          Form1.Image1.Canvas.Ellipse((round(XPad*LEDSize))+((LEDSize div 3))+Pad,YPad*LEDSize+((LEDSize div 3)),(round(XPad*LEDSize))+((LEDSize div 3))+Pad+(LEDSize div 5),(YPad*LEDSize)+((LEDSize div 3))+(LEDSize div 5));
          Form1.Image1.Repaint;
       end;
end;


function BinStr(value : LongInt) : string;  {This function converts an integer into a binary string}
var
   T1,T2 : extended;
   Str1  : string;
   I : integer;
begin
   Str1:='';
   T2:=value;
   For I:= 31 downto 0 do
      begin
         T1:=power(2,I);
         if ((T2/T1)<1) then Str1:=Str1+'0'
         else
            begin
              Str1:=Str1+'1';
              T2:=T2-T1;
            end;
      end;
   BinStr:=Str1;
end;

procedure TForm1.FormCreate(Sender: TObject);  {Here is where it starts, read the registry and set everything up}
var
   FTop,FLeft,TempS1 : string;
   NewRect: TRect;
   I,J : integer;
begin
   OnTop        :=StrToInt(LoadStringFromRegistry('Software\PatrickDugan\Lights','OnTop','1'));
   Backgrnd     :=StringToColor(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','Backgrnd','clBlack'));
   LedOnIn      :=StringToColor(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','LedOnIn','clRed'));
   LedOnOut     :=StringToColor(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','LedOnOut','clMaroon'));
   LedOffIn     :=StringToColor(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','LedOffIn','$00000055'));
   LedOffOut    :=StringToColor(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','LedOffOut','$11111122'));
   HighLightOn  :=StringToColor(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','HighLightOn','clWhite'));
   HighLightOff :=StringToColor(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','HighLightOff','clSilver'));
   FTop     :=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','Top','135');
   FLeft    :=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','Left','280');
   LEDSize  :=StrToInt(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','LEDSize','16'));
   IWide    :=StrToInt(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','IWide','136'));
   IHigh    :=StrToInt(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','IHigh','72'));
   CWide    :=StrToInt(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','CWide','136'));
   CHigh    :=StrToInt(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','CHigh','72'));
   TempStr1  :=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','Moveable','true');
   TempStr4  :=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','Seconds','true');
   TempStr5  :=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','PMLite','true');
   Back      :=StrToInt(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','Back','0'));
   PicStr    :=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','Picture','');
   DriveStr    :=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','DriveStr','');
   DirectoryStr:=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','DirectoryStr','');
   Military    :=StrToInt(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','Military','3'));

   TempS1  :=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','LeastTop','false');
   if (TempS1='true') then LeastTop:=true else LeastTop:=false;
   TempS1  :=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock2','Hide','false');
   if (TempS1='true') then HideIt:=true else HideIt:=false;

   ClientHeight:=CHigh;
   ClientWidth:=CWide;
   Image1.Height:=IHigh;
   Image1.Width:=IWide;

   Form1.Top:=StrToInt(FTop);
   Form1.Left:=StrToInt(FLeft);

   If (TempStr2='true') then
      begin
         Panel1.Visible:=true;
         Image1.Top:=16;
         PadY:=17;
      end
   else
      begin
         Panel1.Visible:=false;
         Image1.Top:=0;
         PadY:=0;
      end;

   DrawRoundRectRegion(Form1.Handle, Form1.ClientRect);

   if (Back=0) then
      begin
         Form1.Image1.Canvas.Brush.Color:=Backgrnd;
         NewRect := Rect(0, 0, Form1.Image1.Width, Form1.Image1.Height);
         Form1.Image1.Canvas.FillRect(NewRect);
      end;

   If (Back=2) then
      begin
         MapBackGround;
      end;

   If ((Back=1)and (PicStr<>'')) then
      begin
         try Image1.Picture.LoadFromFile(PicStr);
         except
            on EInvalidGraphic do
               begin
                  ShowMessage('Invalid graphic name.');
               end;
            on EFOpenError do
               begin
                  ShowMessage('Could not open the graphic file requested.');
               end;
         end;
      end;

   DrawRoundRectRegion(Form1.Handle, Form1.ClientRect);

   Blink:=False;
   OldBStr:='0000000000000000000000000';

    if not(LeastTop) then
       begin
          For I := 0 to 2 do
             For J := 0 to 5 do
                begin
                   ImageOn[I,J]:=True;
                   SwitchLights(I,J);
                end;
       end
    else
       begin
          For I := 0 to 2 do
             For J :=  5 downto 0 do
                begin
                   ImageOn[I,J]:=True;
                   SwitchLights(I,J);
                end;
       end;

   OldPM:='AM';
   SwitchPM;
   FTime:=true;
   Timer1.Enabled:=true;

   if (OnTop=0) then
      begin
         SetWindowPos(Form1.Handle,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
      end;
   if (OnTop=1) then
      begin
         SetWindowPos(Form1.Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
      end;
   if (OnTop=2) then
      begin
         SetWindowPos(Form1.Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
         SetWindowPos(Form1.Handle,HWND_BOTTOM,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
      end;


end;

procedure TForm1.Timer1Timer(Sender: TObject);  {This is the primary timer to get the time and translate to the leds}
var
   I,J : integer;
   H2,M2,PM,S2,TStr,Comp1,Comp2 : string;
   MilStr,MH2,MM2,MS2         : string;
begin
    LongTimeFormat:='h:nn:ss AM/PM';
    TStr:=TimeToStr(Time);
    PM:=Copy(TStr,Length(TStr)-1,2);
    if (Military=4) then
       begin
          LongTimeFormat:='hh:nn:ss';
          MilStr:=TimeToStr(Time);
          MH2:=Copy(BinStr(StrToInt(Copy(MilStr,1,2))),27,6);
          MM2:=Copy(BinStr(StrToInt(Copy(MilStr,4,2))),27,6);
          MS2:=Copy(BinStr(StrToInt(Copy(MilStr,7,2))),27,6);
          Panel1.Caption:=MilStr;
       end
    else Panel1.Caption:=TStr;
    If ((Military=3) and (length(TStr)=10)) then
       begin
          H2:=Copy(BinStr(StrToInt(Copy(TStr,1,1))),27,6);
          M2:=Copy(BinStr(StrToInt(Copy(TStr,3,2))),27,6);
          S2:=Copy(BinStr(StrToInt(Copy(TStr,6,2))),27,6);
       end
    else
    If ((Military=3) and (length(TStr)<>10)) then
       begin
          H2:=Copy(BinStr(StrToInt(Copy(TStr,1,2))),27,6);
          M2:=Copy(BinStr(StrToInt(Copy(TStr,4,2))),27,6);
          S2:=Copy(BinStr(StrToInt(Copy(TStr,7,2))),27,6);
       end;

    if (Military=3) then BStr:=H2+M2+S2
    else BStr:=MH2+MM2+MS2;
    K:=0;

    if not(LeastTop) then
       begin
          For I := 0 to 2 do
             For J := 0 to 5 do
                begin
                   K:=K+1;
                   Comp1:=Copy(OldBStr,K,1);
                   Comp2:=Copy(BStr,K,1);
                   If (Comp1<>Comp2) then SwitchLights(I,J);
                end;
       end
    else
       begin
          For I := 0 to 2 do
             For J := 5 downto 0 do
                begin
                   K:=K+1;
                   Comp1:=Copy(OldBStr,K,1);
                   Comp2:=Copy(BStr,K,1);
                   If (Comp1<>Comp2) then SwitchLights(I,J);
                end;
       end;

    OldBStr:=BStr;
    if (OldPM<>PM) then
       begin
          SwitchPM;
       end;
    if (FTime) then
       begin
         RepaintForm;
         FTime:=false;
       end;

end;

procedure TForm1.Panel1MouseDown(Sender: TObject; Button: TMouseButton; {check for mouse buttons}
  Shift: TShiftState; X, Y: Integer);
begin
  if (Button=mbLeft) then LBDown:=true;
  if (Button=mbRight) then Form3.visible:=true;
  if (LBDown) then
     begin
        OldP.X:=X;
        OldP.Y:=Y;
        OldP := ClientToScreen(OldP);            { Q is the TPoint for the screen }
        OldQ:=OldP;
     end;
end;

procedure TForm1.Panel1MouseMove(Sender: TObject; Shift: TShiftState; X, {If left mouse down on upper display panel then move form}
  Y: Integer);
var
  P, Q : TPoint;
begin
   if ((LBDown) and (Moveable)) then
      begin
        P.X := X;                          { P is the TPoint record for the form}
        P.Y := Y;
        Q := ClientToScreen(P);            { Q is the TPoint for the screen }
        if ((Q.X<>OldQ.X) or (Q.Y<>OldQ.Y)) then
           begin
              Form1.Left:=Form1.Left+(Q.X-OldQ.X);
              Form1.Top:= Form1.Top +(Q.Y-OldQ.Y);
           end;
        OldQ:=Q;
      end;
end;

procedure TForm1.Panel1MouseUp(Sender: TObject; Button: TMouseButton;  {If right mouse button is raised then repaint form}
  Shift: TShiftState; X, Y: Integer);
begin
  if (Button=mbLeft) then  LBDown:=false;
  if (Button=mbRight) then Form3.Visible:=true;
  if ((Back=2) and (Button=mbLeft)) then
     begin
        RepaintForm;
     end;
end;

procedure TForm1.Image1DblClick(Sender: TObject);  {Toggle the upper time display on & off}
begin
   Panel1.Visible:=false;
   PadY:=0;
   Form1.Height:=Form1.Height-17;
   DrawRoundRectRegion(Form1.Handle, Form1.ClientRect);
end;


procedure TForm1.FormDestroy(Sender: TObject);  {write values to registry and exit}
begin

   ClientHeight:=Round((LEDSize*6.2));
   ClientWidth :=Round((LEDSize*4.2));
   if (not(Seconds) and not(PMLite)) then
      begin
         ClientWidth:=Round(LEDSize*2.2);
         Image1.Width:=ClientWidth;
      end
   else
   if (not(Seconds) and (PMLite)) then
      begin
         ClientWidth:=Round(LEDSize*3.3);
         Image1.Width:=ClientWidth;
      end
   else
   if ((Seconds) and Not(PMLite)) then
      begin
         ClientWidth:=Round(LEDSize*3.3);
         Image1.Width:=ClientWidth;
      end;
   Image1.Height:=ClientHeight;
   Image1.Width:=ClientWidth;

   SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','OnTop',IntToStr(OnTop));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','Backgrnd',ColorToString(Backgrnd));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','LEDOnIn',ColorToString(LEDOnIn));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','LEDOnOut',ColorToString(LEDOnOut));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','LEDOffIn',ColorToString(LEDOffIn));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','LEDOffOut',ColorToString(LEDOffOut));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','HighLightOn',ColorToString(HighLightOn));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','HighLightOff',ColorToString(HighLightOff));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','Top',IntToStr(Form1.Top));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','Left',IntToStr(Form1.Left));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','LEDSize',IntToStr(LEDSize));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','IWide',IntToStr(Form1.Image1.Width));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','IHigh',IntToStr(Form1.Image1.Height+17));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','CWide',IntToStr(ClientWidth));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','CHigh',IntToStr(ClientHeight+17));
   if (Moveable) then SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','Moveable','true')
   else SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','Moveable','false');
   if (Seconds) then SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','Seconds','true')
   else SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','Seconds','false');
   if (PMLite) then SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','PMLite','true')
   else SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','PMLite','false');
   if (LeastTop) then SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','LeastTop','true')
   else SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','LeastTop','false');
   if (HideIt) then SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','Hide','true')
   else SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','Hide','false');
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','Back',IntToStr(Back));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','Picture',PicStr);
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','DriveStr',DriveStr);
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','DirectoryStr',DirectoryStr);
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock2','Military',IntToStr(Military));
end;

end.
