#include <stdlib.h>;
#include <stdio.h>;
#include <dos.h>;
#include <stdarg.h>
#include "mcgalib.h";

#define ulong unsigned long
#define uchar unsigned char
#define VGA256 19
#define TEXTMODE 3

FILE *FP;
int *AUTOMATON;              /* Pointer on buffer for automaton */
char *BLOCKSAVE;             /* Pointer on buffer for screen block */
int AUTMAX;                  /* Number of entries in automaton */
int SPRMAX;                  /* Number of sprites in table */

void changext(char *name,char *ext);
void outtextf(int x,int y,char *fmt, ... );
int bload(char *fname,char *adr,int siz);
int getcode(int n);
void putpic(int num,int x,int y);
void putscenery(int num,int x,int y);
int autload(char *name);
int sprload(char *name);
int spralloc();

/* Function to add or replace extension of filenames */

void changext(char *name,char *ext)
{
int l;

l=min( strcspn(name,".") , 8);
*(name+l)=0;
strcat(name,ext);
}

/* Displays a formatted text string */

void outtextf(int x,int y,char *fmt, ... )
{
 char STRBUF19[160];

 va_list  argptr;
 va_start( argptr, format );
 vsprintf(STRBUF19, fmt, argptr );
 outtext(x,y,STRBUF19);
 va_end( argptr );
}

/* Function to read automaton */

int autread(int i)
{
return ( *(AUTOMATON+i));
}

/* Function to get sprite type code */

int getcode(int n)
{
char *adr=getspadr(n);  return((int)*(adr+4));
}

/* Puts a sprite on screen with OVERWRITING mode */

void overpic(int num,int x,int y)
{
if(num)
 if(num <= SPRMAX)
   sprite256(x,y,getspadr(num));
}

/* Puts a sprite on screen with COPY mode */

void putscenery(int num,int x,int y)
{
if(num)
 if(num <= SPRMAX)
   csprite256(x,y,getspadr(num));
}

/* Error message for loading function */

int puterr(char *name)
{
outtextf(5,5,">>> Disk error #:%d, File %s",ferror(FP),name);
return(0);
}

/* Function for loading any binary file */

int bload(char *fname,char *adr,int siz)
{
 if((FP=fopen(fname,"rb"))==0L) return( puterr(fname)) ;
 fread((char *)adr,siz,1,FP);
 fclose(FP);
 return(1);
}

/* Function for loading an automaton */

int autload(char *aname)
{
int ret;
char name[80];

strcpy(name,aname);changext(name,".AUT");
ret=bload(name,(char *) AUTOMATON,2048);
AUTMAX=*AUTOMATON;

return(ret);
}


/* Function for loading a file of sprites into memory.
   This unregistered version allows only 64Kb data!     */

int sprload(char *spname)
{
int i,res;
ulong lvar;
char name[80];

strcpy(name,spname);changext(name,".spr");

res=bload(name,(char *) SPVECTOR,65520);
if(!res) return(0);

SPRMAX=(int) *SPVECTOR;

lvar =  (ulong) SPVECTOR + SPRMAX * 4 + 8;
SPCODE = (char *) lvar;

/* Convert relative addresses to absolute ones */

for(i = 1; i <= SPRMAX; i++)
{
 lvar=  *(SPVECTOR+i) + (ulong) SPCODE;
 *(SPVECTOR+i)= lvar;
}

fclose(FP);
return(1);
}

/* Allocate memory for all buffers */

int spralloc()
{
AUTOMATON = (int *)   malloc(2048);
BLOCKSAVE = (char *)  malloc(6406);
SPVECTOR  = (ulong *) malloc(65520);
if(!SPVECTOR) { printf("Alloc error..."); exit(0);}
}

void main()
{
int i,j,num,x,y,y2,yold;

/* First, allocation of memory buffer */

spralloc();

/* Loading sprites  */

printf("Loading sprites...");
sprload("demo2");

/* loading automaton */

printf("Loading automaton...");
autload("demo2");

 /* Setting VGA 256 colors screen */

selectscreen(VGA256);

/* Setting a full screen window */

window19(0,0,319,199);

/* Drawing the scenery */

for(y=0;y<2;y++)
 for(x=0;x<4;x++)
  putscenery(9,x*80,y*80+20);

/* Now, setting window's limits left, top, right, bottom */

 window19(40,20,280,180);

/* Animation example */

i=1;
x=140;
y=5; yold = y;
getblock(x,yold,x+31,y+49,BLOCKSAVE);    /* Saving background */

while(y < 180)
{
 num=autread(i);
 i++;
 if(i > AUTMAX) i=1;

 putblock(x,yold,BLOCKSAVE);          /* Restoring background */
 getblock(x,y,x+31,y+49,BLOCKSAVE);   /* Saving new area */
 sprite256(x,y,getspadr(num));        /* Sprite display */

 delay(40);        /* to slow down and set all computers same speed */
 yold = y;
 y++;
}

/* Restores DOS text screen and exits */

selectscreen(TEXTMODE);
exit(0);
}
