; A program to turn the heater on and off.
; The system is allowed to cool.
; The heater is then turned on until about 22 degrees is reached.
; This temperature is maintained for a period.
; The above is then repeated.

	ORG	0			; Main program loop at address zero
back11:	
	CALL	90			; Let system cool
	MOV     	AL,30			; Number of iterations
back4:	
	CALL    	70			; Heat until 21 degrees
	DEC     	AL			; Count down
	JNZ     	back4			; to zero

	CALL	50			; Overheat
	MOV     	AL,30			; Number of iterations
back4z:	
	CALL    	70			; Heat until 21 degrees
	DEC     	AL			; Count down
	JNZ     	back4z			; to zero
	JMP     	back11			; repeat whole loop
	
	ORG	20		
	DB	"Heater Control"
	ORG	30
	DB	"Example Program"
	
	ORG	70			; Bang Bang Heater Controller
	PUSH    	AL			; Save AL on the stack
back12:	
	IN      	03			; Find out thermostat info
	AND     	AL,01			; Is bit 1 set ?
	JZ      	FOR9			; NO so jump forwards 9
	MOV     	AL,00			; Yes so set all bits to 0
	OUT     	03			; Send data to heater (OFF)
	JMP     	back12			; Repeat
FOR9:	
	MOV     	AL,80			; Put 10000000 into AL
	OUT     	03			; Send data to heater (ON)
	POP     	AL			; Restore AL from the stack
	Ret
	
	ORG	90			; Turn off heater for a period.
	PUSH    	AL
	PUSH    	BL
	MOV     	AL,00
	MOV     	BL,40
back4a:
	OUT     	03
	DEC     	BL
	JNZ     	back4a
	POP     	BL
	POP     	AL
	RET	

	ORG	50		; Turn heater on for a period
	PUSH    	AL
	PUSH    	BL
	MOV     	AL,80
	MOV     	BL,40
back4b:
	OUT     	03
	DEC     	BL
	JNZ     	back4b
	POP     	BL
	POP     	AL
	RET	

	END
