; Hello World using interrupts.

	jmp	start			; Jump to the main program
	db	30			; Interrupt vector for INT 02
	
	org	70			; DATA DEFINITIONS
	db	"Hello World!"
	org	80
	db	"Don't Panic!"
	org	90
	db	"            "
	org	A0
	db	"Example Program"
	
	org	10			; THE MAIN PROGRAM
start:	
	mov	cl,70			; The address of a text string
	int	2			; Interrupt to print the string
	mov	cl,90			; The address of a text string
	int	2			; Etc
	mov	cl,80
	int	2
	mov	cl,90
	int	2
	jmp	start			; Repeat the main program
	
; Code for INT 02 -----------------------------------------------------------
	org 	30			; Interrupt code to print a string
	push	al			; Save registers
	push	bl
	push	cl
	push	dl
	mov	bl,c0			; Screen address.
again:	
	mov	al,[cl]			; Data at String Address.
	cmp	al,0			; End of string ???
	jz	end			; End of interrupt.
	mov	[bl],al			; Data to screen.
	inc	bl			; Pointer to string
	inc	cl			; Pointer to screen
	jmp	again			; Next character.
end:	
	pop	dl			; Restore registers
	pop	cl
	pop	bl
	pop	al
	iret				; Interrupt return
	
	end
	