#include <stdlib.h>

#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <arpa/inet.h>

#include <stdio.h>
#include <netdb.h>
#include <errno.h>
#include <string.h>
#include <sys/uio.h>
#include <unistd.h>

extern	errno;
 char	*index();
int	rexecoptions;
char	*getpass(), *getlogin();
int debug = 0;

rexec(char *ahost, int rport, char  *name, char *pass, char *cmd, int *fd2p)
{
	struct sockaddr_in sin, sin2, from;
	struct hostent *hp;
	u_short port;
        unsigned char buff[90];
	int s, timo = 1, s3;
	int nrec;

 	hp = gethostbyname(ahost);
	if (hp == 0)
          {
		fprintf(stderr, "%s: unknown host\n", ahost);
		return (-1);
          }
          
	ahost = hp->h_name;
//	ruserpass(hp->h_name, &name, &pass);
retry:
	s = socket(AF_INET, SOCK_STREAM, 0);
	if (s < 0)
         {
		perror("rexec: socket");
		return (-1);
	}
	sin.sin_family = AF_INET;
	sin.sin_port = htons(512);
//	sin.sin_family = hp->h_addrtype;
//	sin.sin_port = rport;
 	memcpy((char *)&sin.sin_addr, hp->h_addr, hp->h_length);
//	bcopy(hp->h_addr, (caddr_t)&sin.sin_addr, hp->h_length);

        printf("connecting to %s ...\n\n",inet_ntoa(sin.sin_addr));
	if (connect(s, (struct sockaddr *)&sin, sizeof(sin)) < 0)
          {
		if (errno == ECONNREFUSED && timo <= 16)
                  {
			(void) close(s);
	//		Sleep(timo);
			timo *= 2;
			goto retry;
		  }
		perror(hp->h_name);
		return (-1);
	  }
//	if (fd2p == 0)
  //        {
//	   	(void) write(s, "", 1);
//		port = 0;
//	  }
  //         else

        {
  
	    char num[8];
	    int  sin2len;
	    int s2;

   if (debug)
      {
       printf("connected \n");
       fflush(stdout);
      }
 
      sin2.sin_port=htons(0);
      sin2.sin_family=AF_INET;
      sin2.sin_addr.s_addr=0;
    
  	s2 = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
		if (s2 < 0) {
			close(s);
			printf("socket error = %d \n",errno);
			return (-1);
		}
   if (debug)
      {
       printf("socket s2 opened \n");
       fflush(stdout);
      }
      
		sin2len = sizeof (sin2);
       if ( bind(s2,(struct sockaddr *)&sin2,sin2len) == -1)
         {
         printf("bind error = %d",errno);
         close(s2);
	 return(-1);
         }

   if (debug)
      {
    printf("bound to socket \n");
    fflush(stdout);
      }
      
    // get the port name that we got for later transmission in PORT cmd
		if (getsockname(s2, (struct sockaddr *)&sin2, &sin2len) < 0 ||
		  sin2len != sizeof (sin2)) {
			printf("getsock name error = %d \n",errno);
			close(s2);
			goto bad;
		}

   if (debug)
      {

		printf("got sock name \n");
		fflush(stdout);
      }
		
		if (listen(s2, 1) != 0)
		  {
		   printf("error in listen call code = %d \n",errno);
		   return(-1);
		   }

   if (debug)
      {

		   printf("listen succeeded \n");
		   fflush(stdout);
      }
		   
	        port = ntohs((u_short)sin2.sin_port);
		sprintf(num, "%u", port);
		send(s, (char *)num, strlen(num)+1,0);
		{ 
		  int len = sizeof (from);
    if (debug)
      {

	  printf("trying accept s3 \n");
	  fflush(stdout);
      }
		  s3 = accept(s2, (struct sockaddr *)&from, &len);
		  close(s2);
    if (debug)
      {

		  printf("accept returned \n");
		  fflush(stdout);
      }		  
		  if (s3 < 0) {
			printf("accept error = %d\n",errno);
			port = 0;
			goto bad;
		  }
		}
//		*fd2p = s3;
	}

if (debug)
  {		  
        printf("starting main sends \n");
        fflush(stdout);
  }
  
	send(s, (char *)name, strlen(name) + 1,0);
	/* should public key encypt the password here */
	send(s, (char *)pass, strlen(pass) + 1,0);
	send(s, (char *)cmd, strlen(cmd) + 1,0);

if (debug)
  {		  
	printf("trying first rec \n");
	fflush(stdout);
  }	
	if (recv(s, (char *)buff, 80,0) == -1)
          {
		perror("\nerror receiving\n");
		goto bad;
	  }
	nrec = 1;
	if (nrec > 0)
          {
		while ((nrec != -1) && (nrec == 1))
                    {

                
		nrec =  recv(s, (char *)buff, 1,0);

if (debug)
  {		  
                printf("recd %d chars \n",nrec);
                fflush(stdout);
  }                
		printf("%c",buff[0]);
			if (nrec == 0)
			  break;
		    }

		    printf("\n");
		    fflush(stdout);
		goto bad;
	  }
	return (s);
bad:
//	if (port)
//		(void) close(*fd2p);
	close(s);
	return (-1);
}


 void disp_help()

  {

   printf("\nrexec client program V 1.0 by L. Kahn (C) 1994\n");
   printf("___________________________________________________\n\n");
   printf("This program implements an rexec client on thesun.\n");

   printf("Syntax: rexec hostname username password command\n\n");

  }


 main(int argc,char **argv)
  
  {


 char command[200];
 int rv = 0;
  int timeout = 0;
  int current_arg = 0;
   
   if (argc < 5)
     disp_help();

   else
   {

// if there are args pas arg 4 than it is part of the command and concat it.
 strcpy(command,argv[4]);

 current_arg = 5;

 while (current_arg < argc)
      {
	    strcat(command," \0");
	    strcat(command,argv[current_arg]);
		++current_arg;
      }

   printf("hostname is %s \n",argv[1]);
   printf("username is %s \n",argv[2]);
   printf("password is %s \n",argv[3]);
   printf("command  is %s \n",command);
   
   rexec(argv[1],512,argv[2],argv[3],command,0);

   }
   
  } /* end of main */          


