' ***************************************************************
'
'
'
'    FTP4W.DLL % lib "FTP4W.DLL" (Version 1.2)
'
'
'                                   By Ph. Jounin (SNCF 71-26-12)
'                                        Internet ark@ifh.sncf.fr
'                                        Thanks to Santanu Lahiri
' Header written by Bram Buitendijk <Bram.Buitendijk@library.KNAW.NL>
' ***************************************************************


' -----------------------------------------------------------
' ASCII or binary tranfser
Global Const TYPE_A = 65 ' "A", ascii
Global Const TYPE_I = 73 ' "I", binary

' -----------------------------------------------------------
'              Return codes of FTP functions
' -----------------------------------------------------------

' success
Global Const FTPERR_OK = 0             ' succesful function
Global Const FTPERR_ENTERPASSWORD = 1  ' userid need a password
Global Const FTPERR_ACCOUNTNEEDED = 2  ' user/pass OK but account required
Global Const FTPERR_CANCELBYUSER = -1  ' Transfer aborted by user FtpAbort

' user's or programmer's Errors
Global Const FTPERR_INVALIDPARAMETER = 1000  ' Error in parameters
Global Const FTPERR_SESSIONUSED = 1001       ' User has already a FTP session
Global Const FTPERR_NOTINITIALIZED = 1002    ' FtpInit has not been callED
Global Const FTPERR_NOTCONNECTED = 1003      ' User is not connected to a server
Global Const FTPERR_CANTOPENFILE = 1004      ' can not open specified file
Global Const FTPERR_CANTWRITE = 1005         ' can't write to file (disk full?)
Global Const FTPERR_NOACTIVESESSION = 1006   ' FtpRelease without FtpInit
Global Const FTPERR_STILLCONNECTED = 1007    ' FtpRelease without any Close
Global Const FTPERR_SERVERCANTEXECUTE = 1008 ' file action not taken
Global Const FTPERR_LOGINREFUSED = 1009      ' Server rejects usrid/passwd
Global Const FTPERR_NOREMOTEFILE = 1010      ' server can not open file
Global Const FTPERR_TRANSFERREFUSED = 1011   ' Host refused the transfer
Global Const FTPERR_WINSOCKNOTUSABLE = 1012  ' A winsock.DLL ver 1.1 is required
Global Const FTPERR_CANTCLOSE = 1013         ' Close failed (cmd is in progress) 

' TCP errors
Global Const FTPERR_UNKNOWNHOST = 2001     ' can not resolve host adress
Global Const FTPERR_NOREPLY = 2002         ' host does not send an answer
Global Const FTPERR_CANTCONNECT = 2003     ' Error during connection
Global Const FTPERR_CONNECTREJECTED = 2004 ' host has no FTP server
Global Const FTPERR_SENDREFUSED = 2005     ' can't send data(network down)
Global Const FTPERR_DATACONNECTION = 2006  ' connection on data-port failed
Global Const FTPERR_TIMEOUT = 2007         ' timeout occured

' FTP errors
Global Const FTPERR_UNEXPECTEDANSWER = 3001 ' answer was not expected
Global Const FTPERR_CANNOTCHANGETYPE = 3002 ' host rejects the TYPE command

' Resource errors
Global Const FTPERR_CANTCREATEWINDOW = 5002 ' Insufficent free resources
Global Const FTPERR_INSMEMORY = 5003        ' Insuffisent Heap memory
Global Const FTPERR_CANTCREATESOCKET = 5004 ' no more socket
Global Const FTPERR_CANTBINDSOCKET = 5005   ' bind is not succesful

' ****************************************************************
'
'                    P R O T O T Y P E S
'
' ****************************************************************

' Utility functions

' Change default parameters
Declare Function FtpSetVerboseMode% Lib "FTP4W.DLL" (ByVal bVerboseMode As Integer, ByVal hVerboseWnd As Integer, ByVal wMsg As Integer)
Declare Function FtpBytesTransfered Lib "FTP4W.DLL" () As Long
Declare Function FtpBytesToBeTransfered Lib "FTP4W.DLL" () As Long
Declare Sub FtpSetDefaultTimeOut Lib "FTP4W.DLL" (ByVal nTo_in_sec As Integer)
Declare Sub FtpSetDefaultPort Lib "FTP4W.DLL" (ByVal nDefPort As Integer)
Declare Sub FtpSetAsynchronousMode Lib "FTP4W.DLL" ()
Declare Sub FtpSetSynchronousMode Lib "FTP4W.DLL" ()
Declare Function FtpIsAsynchronousMode Lib "FTP4W.DLL" () As Integer
Declare Sub FtpSetNewDelay Lib "FTP4W.DLL" (ByVal x As Integer)
Declare Sub FtpSetNewSlices Lib "FTP4W.DLL" (ByVal x As Integer, ByVal y As Integer)

' Init functions
Declare Function FtpRelease% Lib "FTP4W.DLL" ()
Declare Function FtpInit% Lib "FTP4W.DLL" (ByVal hParentWnd As Integer)

' Connection
Declare Function FtpLogin% Lib "FTP4W.DLL" (ByVal szHost As String, ByVal szUser As String, ByVal szPasswd As String, ByVal hParentWnd As Integer, ByVal wMsg As Integer)
Declare Function FtpOpenConnection% Lib "FTP4W.DLL" (ByVal szHost As String)
Declare Function FtpCloseConnection% Lib "FTP4W.DLL" ()
Declare Function FtpLocalClose% Lib "FTP4W.DLL" ()

' authentification
Declare Function FtpSendUserName% Lib "FTP4W.DLL" (ByVal szUserName As String)
Declare Function FtpSendPasswd% Lib "FTP4W.DLL" (ByVal szPasswd As String)

' commands
Declare Function FtpHelp% Lib "FTP4W.DLL" (ByVal szArg As String, ByVal szBuf As String, ByVal uBufSize As Integer)
Declare Function FtpCWD% Lib "FTP4W.DLL" (ByVal szPath As String)
Declare Function FtpQuote% Lib "FTP4W.DLL" (ByVal szCmd As String, ByVal szReplyBuf As String, ByVal uBufSize As Integer)
Declare Function FtpSetType% Lib "FTP4W.DLL" (ByVal cType As Integer)

' file transfer
Declare Function FtpAbort% Lib "FTP4W.DLL" ()
Declare Function FtpSendFile% Lib "FTP4W.DLL" (ByVal szLocal As String, ByVal szRemote As String, ByVal cType As Integer, ByVal bNotify As Integer, ByVal hParentWnd As Integer, ByVal wMsg As Integer)
Declare Function FtpRecvFile% Lib "FTP4W.DLL" (ByVal szRemote As String, ByVal szLocal As String, ByVal cType As Integer, ByVal bNotify As Integer, ByVal hParentWnd As Integer, ByVal wMsg As Integer)
Declare Function FtpGetFileSize Lib "FTP4W.DLL" () As Long

' Directory
Declare Function FtpDir% Lib "FTP4W.DLL" (ByVal szDef As String, ByVal szLocalFile As String, ByVal bLongDir As Integer, ByVal hParentWnd As Integer, ByVal wMsg As Integer)


