'declarations for FTP module to use with FTP4W
'and retrieved from FTP4W.h
'origin : Ph. Jounin (SNCF 71-26-12)
'         Internet ark@ifh.sncf.fr
'
'coded    : 30/12/94
'by       : C. de Rooij
'version  : 1.1
'changed  : 16/01/95 some parameters called By value
'
Global Const FTP_DATABUFFER = 4096 'a good value for X25/Ethernet/Token Ring
'-----------------------------------------------------------
'ASCII or binary tranfser
Global Const TYPE_A = "A"    'should be used with Asc(TYPE_A)
Global Const TYPE_I = "I"    'or Asc(TYPE_I)
'
'-----------------------------------------------------------
'              Return codes of FTP functions
'-----------------------------------------------------------
Global Const FTPERR_OK = 0                  'succesful function
Global Const FTPERR_ENTERPASSWORD = 1       'userid need a password
Global Const FTPERR_ACCOUNTNEEDED = 2       'user/pass OK but account required
Global Const FTPERR_CANCELBYUSER = -1       'Transfer aborted by user FtpAbort
'user's or programmer's Errors
Global Const FTPERR_INVALIDPARAMETER = 1000 'Error in parameters
Global Const FTPERR_SESSIONUSED = 1001      'User has already a FTP session
Global Const FTPERR_NOTINITIALIZED = 1002   'FtpInit has not been call
Global Const FTPERR_NOTCONNECTED = 1003     'User is not connected to a server
Global Const FTPERR_CANTOPENFILE = 1004     'can not open specified file
Global Const FTPERR_CANTWRITE = 1005        'can't write into file (disk full?)
Global Const FTPERR_NOACTIVESESSION = 1006  'FtpRelease without FtpInit
Global Const FTPERR_STILLCONNECTED = 1007   'FtpRelease without any Close
Global Const FTPERR_SERVERCANTEXECUTE = 1008'file action not taken
Global Const FTPERR_LOGINREFUSED = 1009     'Server rejects usrid/passwd
Global Const FTPERR_NOREMOTEFILE = 1010     'server can not open file
Global Const FTPERR_TRANSFERREFUSED = 1011  'Host refused the transfer
Global Const FTPERR_WINSOCKNOTUSABLE = 1012 'A winsock.DLL ver 1.1 is required
Global Const FTPERR_CANTCLOSE = 1013         'close failed (cmd is in progress)
'* TCP errors
Global Const FTPERR_UNKNOWNHOST = 2001      'can not resolve host adress
Global Const FTPERR_NOREPLY = 2002          'host does not send an answer
Global Const FTPERR_CANTCONNECT = 2003      'Error during connection
Global Const FTPERR_CONNECTREJECTED = 2004  'host has no FTP server
Global Const FTPERR_SENDREFUSED = 2005      'can't send data (network down)
Global Const FTPERR_DATACONNECTION = 2006   'connection on data-port failed
Global Const FTPERR_TIMEOUT = 2007          'timeout occurred
'* FTP errors
Global Const FTPERR_UNEXPECTEDANSWER = 3001 'answer was not expected
Global Const FTPERR_CANNOTCHANGETYPE = 3002 'host rejects the TYPE command
'* Resource errors
Global Const FTPERR_CANTCREATEWINDOW = 5002 'Insufficent free resources
Global Const FTPERR_INSMEMORY = 5003        'Insufficient Heap memory
Global Const FTPERR_CANTCREATESOCKET = 5004 'no more socket
Global Const FTPERR_CANTBINDSOCKET = 5005   'bind is not succesful
'
'* ****************************************************************
'*
'*                    P R O T O T Y P E S
'*
'* ****************************************************************
'* Init functions
'
Declare Function FtpInit Lib "FTP4W.DLL" (ByVal HWND As Integer) As Integer
Declare Function FtpRelease Lib "FTP4W.DLL" () As Integer
'
'* Connection
'
Declare Function FtpLogin Lib "FTP4W.DLL" (ByVal Host As String, ByVal User As String, ByVal Password As String, ByVal HWND As Integer, ByVal msge As Integer) As Integer
Declare Function FtpOpenConnection Lib "FTP4W.DLL" (ByVal Host As String) As Integer
Declare Function FtpCloseConnection Lib "FTP4W.DLL" () As Integer
Declare Function FtpLocalClose Lib "FTP4W.DLL" () As Integer
'
'* authentification
'
Declare Function FtpSendUserName Lib "FTP4W.DLL" (ByVal UserName As String) As Integer
Declare Function FtpSendPasswd Lib "FTP4W.DLL" (ByVal Passwd As String) As Integer
'
'* commands
'
Declare Function FtpHelp Lib "FTP4W.DLL" (ByVal Arg As String, ByVal Buf As String, ByVal BufSize As Integer) As Integer
Declare Function FtpCWD Lib "FTP4W.DLL" (ByVal Path As String) As Integer
Declare Function FtpQuote Lib "FTP4W.DLL" (ByVal Cmd As String, ByVal ReplyBuf As String, ByVal BufSize As Integer) As Integer
Declare Function FtpSetType Lib "FTP4W.DLL" (ByVal Typ As Integer) As Integer  '
'
'* file transfer
'
Declare Function FtpAbort Lib "FTP4W.DLL" () As Integer
'how to handle 3rd parameter see also FtpSetType
Declare Function FtpSendFile Lib "FTP4W.DLL" (ByVal Lcl As String, ByVal Remote As String, ByVal Typ As Integer, ByVal Notify As Integer, ByVal HWND As Integer, ByVal msge As Integer) As Integer
Declare Function FtpRecvFile Lib "FTP4W.DLL" (ByVal Remote As String, ByVal Lcl As String, ByVal Typ As Integer, ByVal Notify As Integer, ByVal HWND As Integer, ByVal msge As Integer) As Integer
'
Declare Function FtpGetFileSize Lib "FTP4W.DLL" () As Long
'
'* Directory
'
Declare Function FtpDir Lib "FTP4W.DLL" (ByVal Def As String, ByVal LocalFile As String, ByVal LongDir As Integer, ByVal HWND As Integer, ByVal msge As Integer) As Integer
'
'* specials
'
Declare Function FtpBytesTransfered Lib "FTP4W.DLL" () As Long
Declare Function FtpBytesToBeTransfered Lib "FTP4W.DLL" () As Long
Declare Sub FtpSetDefaultTimeOut Lib "FTP4W.DLL" (ByVal nTo_in_sec As Integer)
Declare Sub FtpSetDefaultPort Lib "FTP4W.DLL" (ByVal nDefPort As Integer)
Declare Sub FtpSetAsynchronousMode Lib "FTP4W.DLL" ()
Declare Sub FtpSetSynchronousMode Lib "FTP4W.DLL" ()
Declare Function FtpIsAsynchronousMode Lib "FTP4W.DLL" () As Integer
Declare Sub FtpSetNewDelay Lib "FTP4W.DLL" (ByVal X As Integer)
Declare Sub FtpSetNewSlices Lib "FTP4W.DLL" (ByVal X As Integer, ByVal Y As Integer)
'
'* Utilities functions
'
Declare Function WEP Lib "FTP4W.DLL" (ByVal nType As Integer) As Integer
Declare Function FtpSetVerboseMode Lib "FTP4W.DLL" (ByVal bVerBoseMode As Integer, ByVal HWND As Integer, ByVal wMsg As Integer) As Integer
'

Function FTP4W_Error (ErrorValue As Integer) As String
  'return a string related to the ErrorValue given
  'as a parameter
  '
  Dim Msg$
  '
  Select Case ErrorValue
   Case FTPERR_ENTERPASSWORD
     Msg$ = "Userid need a password"
   Case FTPERR_ACCOUNTNEEDED
     Msg$ = "User/pass OK but account required"
   Case FTPERR_CANCELBYUSER
     Msg$ = "Transfer aborted by user FtpAbort"
   Case FTPERR_INVALIDPARAMETER
     Msg$ = "Error in parameters"
   Case FTPERR_SESSIONUSED
     Msg$ = "User has already a FTP session"
   Case FTPERR_NOTINITIALIZED
     Msg$ = "FtpInit has not been called"
   Case FTPERR_NOTCONNECTED
     Msg$ = "User is not connected to a server"
   Case FTPERR_CANTOPENFILE
     Msg$ = "Can not open specified file"
   Case FTPERR_CANTWRITE
     Msg$ = "Can't write into file (disk full?)"
   Case FTPERR_NOACTIVESESSION
     Msg$ = "FtpRelease without FtpInit"
   Case FTPERR_STILLCONNECTED
     Msg$ = "FtpRelease without any Close"
   Case FTPERR_SERVERCANTEXECUTE
     Msg$ = "File action not taken"
   Case FTPERR_LOGINREFUSED
     Msg$ = "Server rejects Userid/Passwd"
   Case FTPERR_NOREMOTEFILE
     Msg$ = "Server can not open file"
   Case FTPERR_TRANSFERREFUSED
     Msg$ = "Host refused the transfer"
   Case FTPERR_WINSOCKNOTUSABLE
     Msg$ = "A winsock.DLL version 1.1 is required"
   Case FTPERR_UNKNOWNHOST
     Msg$ = "Can not resolve host address"
   Case FTPERR_NOREPLY
     Msg$ = "Host does not send an answer"
   Case FTPERR_CANTCONNECT
     Msg$ = "Error during connection"
   Case FTPERR_CONNECTREJECTED
     Msg$ = "Host has no FTP server"
   Case FTPERR_SENDREFUSED
     Msg$ = "Can't send data (network down)"
   Case FTPERR_DATACONNECTION
     Msg$ = "Connection on data-port failed"
   Case FTPERR_TIMEOUT
     Msg$ = "Timeout occurred"
   Case FTPERR_UNEXPECTEDANSWER
     Msg$ = "Answer was not expected"
   Case FTPERR_CANNOTCHANGETYPE
     Msg$ = "Host rejects the TYPE command"
   Case FTPERR_CANTCREATEWINDOW
     Msg$ = "Insufficent free resources"
   Case FTPERR_INSMEMORY
     Msg$ = "Insufficient Heap memory"
   Case FTPERR_CANTCREATESOCKET
     Msg$ = "No more socket"
   Case FTPERR_CANTBINDSOCKET
     Msg$ = "Bind is not succesful"
  End Select
  '
  FTP4W_Error = Msg$
  '
End Function

