
/*--------------------------------------------
    TASK.C -- Displays task list
 ----------------------------------------------*/

#pragma warning( disable : 4100 )

#include <windows.h>
#include <toolhelp.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <direct.h>
#include <process.h>

#include "resource.h"
#include "ctl3d.h"
int PASCAL FAR SwitchToThisWindow (HWND);


#define  MAXREAD        2048
#define  MAXPATH        256
#define  MAX_TASK       256
#define  INVALID_TASK   NULL

HINSTANCE hInst;
HWND      hMainWnd;
HTASK     hThisTask;

long FAR PASCAL WndProc (HWND, WORD, WORD, LONG);
long FAR PASCAL ListProc (HWND, WORD, WORD, LONG);
int  TaskList (void);


/*--------------------------------------------
   NotifyRegisterCallBack : Send a Redraw to the window
 ----------------------------------------------*/
BOOL CALLBACK _loadds NotifyRegisterCallBack (WORD wID, DWORD d)
{
  if (    GetCurrentTask() != hThisTask
      &&  (wID==NFY_EXITTASK  || wID==NFY_STARTTASK) )
        PostMessage (hMainWnd, WM_PAINT, 0, 0l);
return 0;
} /* NotifyRegisterCallBack */


/*--------------------------------------------
   Displays opened windows for a given task
 ----------------------------------------------*/

BOOL CALLBACK _export EnumProcFunction (HWND hTaskWnd, LPARAM Ark)
{
char   Line [64], szTitle[50];

   if (hTaskWnd==NULL)  return FALSE;
   szTitle[0]=0;
   GetWindowText (hTaskWnd, szTitle, sizeof szTitle);
   wsprintf (Line, "%5d  %s %s", 
             hTaskWnd, 
             GetWindowWord (hTaskWnd, GWW_HWNDPARENT)==NULL ? (LPSTR) ">>" : (LPSTR) "->",
             (LPSTR) szTitle);
   SendDlgItemMessage (hMainWnd, IDC_LISTWINDOWS, LB_ADDSTRING, 0, (LPARAM)(LPSTR) Line);
   if (szTitle[0]!=0)   SetDlgItemText (hMainWnd, IDC_MAINWND, (LPSTR) szTitle);
return TRUE;
} /* EnumProcWindow */

 

/*--------------------------------------------
   WindowList : Initiate list of all windows
 ----------------------------------------------*/
int WindowList (HTASK hTask)
{
WNDENUMPROC  EnumProcInstance;

   SendDlgItemMessage (hMainWnd, IDC_LISTWINDOWS, LB_RESETCONTENT, 0, 0l);
   SetDlgItemText (hMainWnd, IDC_MAINWND, (LPSTR) "");
   EnumProcInstance = MakeProcInstance ( (FARPROC) EnumProcFunction, hInst);
   if (EnumProcInstance==NULL)  return -1;
   EnumTaskWindows (hTask, EnumProcInstance, 0l);
   FreeProcInstance (EnumProcInstance);
return 0;
} /* WindowList */


/*--------------------------------------------
   Lists all tasks
 ----------------------------------------------*/
int  TaskList (void)
{
static int             Cur;
static char            Line [80];
static TASKENTRY       TaskEntry;
static BOOL            New ;
static HTASK    AllTask [MAX_TASK];
static unsigned NbTask;
static BOOL     Switch;

   if (NbTask == GetNumTasks ())  /* Le nombre de taches n'a pas change */
     {
       TaskEntry.dwSize = sizeof TaskEntry;
       for ( TaskFirst (& TaskEntry ), New=FALSE, Cur=0 ;
         ! New   &&  TaskEntry.hTask!=AllTask[Cur++]  && TaskNext (& TaskEntry) ;
         New = TaskEntry.hTask!=AllTask[Cur++] )  ;
       if (! New)  return 0;
     } /* nombre de taches identique */

   NbTask = GetNumTasks ();
   SendDlgItemMessage (hMainWnd, IDC_LISTTASK, LB_RESETCONTENT, 0, 0);
   wsprintf (Line, "%d tches actives %s", NbTask, Switch ?  (LPSTR) "..." : (LPSTR) "---");
   Switch = ! Switch;
   SetDlgItemText (hMainWnd, IDC_SUMWND, Line);
   TaskEntry.dwSize = sizeof TaskEntry;
   TaskFirst (& TaskEntry );
   Cur=0;
   do
     { 
         wsprintf (Line, "%5d -> hInst %5d Module %9.9s",
                TaskEntry.hTask, TaskEntry.hInst, (LPSTR) TaskEntry.szModule);
         SendDlgItemMessage (hMainWnd, IDC_LISTTASK, LB_ADDSTRING, 0, (LPARAM) (LPSTR) Line);
         AllTask [Cur++] = TaskEntry.hTask;
     }
   while (TaskNext (& TaskEntry) );
return Cur;
} /* TaskList */



int ChangeStatus (HTASK hTask, UINT wMsg)
{
char Line [50];
  wsprintf (Line, "%s Task %d ?", wMsg==WM_QUIT ? (LPSTR) "Kill" : (LPSTR) "End", hTask);
  if (MessageBox (hMainWnd, Line, "Task Viewer", MB_YESNO)==IDYES)
         PostAppMessage (hTask, wMsg, 0, 0);
  hTask = INVALID_TASK;
return 0;
} /* ChangeStatus */


HTASK ReadSelectedTask (void)
{
int i;
char   szBuffer [MAXPATH + 1];
    i = (WORD) SendDlgItemMessage (hMainWnd, IDC_LISTTASK, LB_GETCURSEL, 0, 0L);
    if (i==LB_ERR)    return NULL;
    SendDlgItemMessage (hMainWnd, IDC_LISTTASK, LB_GETTEXT, i, (LONG) (LPSTR) szBuffer);
return (HTASK) atoi (szBuffer);
}

HWND ReadSelectedWnd (void)
{
int i;
char   szBuffer [MAXPATH + 1];
  i = (WORD) SendDlgItemMessage (hMainWnd, IDC_LISTWINDOWS, LB_GETCURSEL, 0, 0L);
  if (i==LB_ERR)    return NULL;
  SendDlgItemMessage (hMainWnd, IDC_LISTWINDOWS, LB_GETTEXT, i, (LONG) (LPSTR) szBuffer);
return (HWND) atoi (szBuffer);
}


/* -------------------------------- */
/* boucle de reception des messages */
/* -------------------------------- */
long FAR PASCAL WndProc (HWND hWnd, WORD message, WORD wParam, LONG lParam)
{
HTASK  hTask;
HWND   hCurWnd;
  switch (message)
    {
             
       case WM_INITDIALOG :
             hMainWnd = hWnd;
            break;

       case WM_COMMAND :
            hTask = ReadSelectedTask ();
            switch (wParam)
              {
                 case IDC_LISTTASK :
                    if (HIWORD(lParam) == LBN_SELCHANGE)  WindowList (hTask);
                    if (HIWORD(lParam) == LBN_DBLCLK)  /* Double Click */
                       ChangeStatus (hTask, WM_QUIT);
                    break;

                 case IDOK :
                    EndDialog (hWnd, 0);
                    break;

                 case ID_SWITCHTO :
                    hCurWnd = ReadSelectedWnd();
                    PostMessage (hCurWnd, WM_ACTIVATE, WA_ACTIVE, 0l);
                    if (IsIconic (hCurWnd)) 
                       ShowWindow (hCurWnd, SW_RESTORE);
                    break;
                    
                 case ID_KILL :
                    ChangeStatus (hTask, WM_QUIT);
                    break;

                 case ID_END : 
                    hCurWnd = ReadSelectedWnd ();
                    PostMessage (hCurWnd, WM_CLOSE, 0, 0l);
                    break;                    
                    
                 
                 case ID_ONTOP :
                 case ID_NOTONTOP :
                    SetWindowPos (hWnd, wParam==ID_ONTOP ? HWND_TOPMOST : HWND_NOTOPMOST,
                                  0, 0, 0, 0, 
                                  SWP_NOMOVE | SWP_NOREDRAW | SWP_NOSIZE );
                    break;  
              } /* switch WM_COMMAND */
            break; 
               
       case WM_PAINT:
            hTask = ReadSelectedTask ();
            TaskList ();               
            if (hTask!=INVALID_TASK)   WindowList (hTask);
            break;

       case WM_CLOSE :
       case WM_DESTROY :
            EndDialog (hWnd, 0);
            break;
   }
// return DefWindowProc(hWnd,message,wParam,lParam);
return FALSE;
} /* MAIN Callback */




/* ----------------------------- */
/* WinMain                       */
/* ----------------------------- */
int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
                    LPSTR lpszCmdLine, int nCmdShow)
{
FARPROC lpfnNotifyProc;

     hInst = hInstance;
     hThisTask=GetCurrentTask ();
     Ctl3dRegister (hInstance);
     Ctl3dAutoSubclass (hInstance);
    
     lpfnNotifyProc = MakeProcInstance (NotifyRegisterCallBack, hInstance);
     NotifyRegister (0, (LPFNNOTIFYCALLBACK) lpfnNotifyProc, NF_NORMAL);
     DialogBox (hInstance,(LPSTR) "TASKVIEWER", 0, (DLGPROC) WndProc);
     NotifyUnRegister (0);
     FreeProcInstance (lpfnNotifyProc);

     Ctl3dUnregister (hInstance);
return 0;
}
