/***************************************************************************************
**
**	nullsock		loader for 'nullsock' (dummy winsock dll)
**
**	Jean-Michel MERCIER	Version 1.0, 18 nov. 1995
**
**	100101.1152@compuserve.com
**
****************************************************************************************
**
**	file : nullsock.c
**
***************************************************************************************/


#define	WINSOCKDLL	"WINSOCK.DLL"
#define	INISECTION	"NullSock"
#define	INIENTRY	"NullSock"

#define STRICT

#include <windows.h>
#include <string.h>

#include "wspawn.h"

/*====================================================================
	globals
====================================================================*/

#define	DIRSIZE		256

char		szAppName[] = "NullSock";
char		szTitle[] = "NullSock 1.0";
char		szWinsockDir[DIRSIZE];

/*====================================================================
	MainWindProc
====================================================================*/

LRESULT CALLBACK MainWindowProc(
HWND		hWnd,
UINT		message,
WPARAM		wParam,
LPARAM		lParam
)
{
	/* --------------------------------------
	 *	 Get on with the message
	 */
	switch (message)
	{
		/* ------------------------------
		 *	I don't want to open the window...
		 */
		case WM_QUERYOPEN:

			return 0L;

		/* ------------------------------
		 *	It's the end my friend
		 */
		case WM_DESTROY:	
		
			PostQuitMessage(0);

			return 0L;
	}

	return DefWindowProc(hWnd, message, wParam, lParam);
}

/*====================================================================
	RegisterLocalClasses
====================================================================*/

int		RegisterLocalClasses(
HINSTANCE	hInstance
)
{
	WNDCLASS	wndclass ;

	/*
	 *	MainWindow class
	 */

	wndclass.style          = 0;
	wndclass.lpfnWndProc    = MainWindowProc;
	wndclass.cbClsExtra     = 0;
	wndclass.cbWndExtra     = 0;
	wndclass.hInstance      = hInstance;
	wndclass.hIcon          = LoadIcon (hInstance, szAppName);
	wndclass.hCursor        = LoadCursor (NULL, IDC_ARROW);
	wndclass.hbrBackground  = (HBRUSH)(COLOR_APPWORKSPACE+1);
	wndclass.lpszMenuName   = NULL;
	wndclass.lpszClassName  = szAppName ;

	return RegisterClass (&wndclass) ;
}

/*====================================================================
	WinMain
====================================================================*/

#pragma argsused

int PASCAL	WinMain(
HINSTANCE	hInstance,
HINSTANCE	hPrevInstance,
LPSTR		lpszCmdLine,
int		nCmdShow
)
{
	HWND        	hWnd ;
	MSG		msg;
	HANDLE		hLibrary;

	/*
	 *	Start of the application for the 1st instance
	 *
	 *	the 1st instance have to register the window's class and
	 *	load the nullsock WINSOCK.DLL
	 */

	if (!hPrevInstance)
	{
		if ( RegisterLocalClasses( hInstance ) == 0 )
		{
			MessageBox
			(
				NULL,
				"Can't register window's class",
				"FATAL",
				MB_ICONSTOP| MB_OK
			);

                        return 0;
		}

		/*
		 *	Window creation and displaying
		 */

		hWnd = CreateWindow(
			  szAppName,			// window class name
	                  szTitle,			// window title
	                  WS_OVERLAPPEDWINDOW,		// type of window
			  CW_USEDEFAULT,		// x  window location
	                  0,				// y
	                  CW_USEDEFAULT,		// cx and size
	                  0,				// cy
	                  NULL,				// no parent for this window
	                  NULL,				// use the class menu
	                  hInstance,			// who created this window
	                  NULL				// no parms to pass on
			  );
	
		ShowWindow( hWnd, SW_MINIMIZE );

		/*
		 *	Get the nullsock dll directory
		 */

		GetProfileString( INISECTION, INIENTRY, "*", szWinsockDir, DIRSIZE );

		if ( szWinsockDir[0] == '*' )
		{
			MessageBox(
				hWnd,
				"NullSock entry not defined",
				"NullSock : WIN.INI error",
				MB_ICONEXCLAMATION | MB_OK
				);

			WriteProfileString( INISECTION, INIENTRY,
				"* Write here the path to your nullsock WINSOCK.DLL"
				);

                        return -1;
		}

		strcat( szWinsockDir, "\\" WINSOCKDLL );

		/*
		 *	load the dll
		 */

		hLibrary = LoadLibrary(szWinsockDir);

		if ((UINT)hLibrary <= 32)
		{
			MessageBox(
				hWnd,
				szWinsockDir,
				"NullSock : Can't load WINSOCK.DLL", 
				MB_ICONEXCLAMATION | MB_OK
				);

			return -1;
		}

		/*
		 *	Spawn the required application and wait
		 */

		if ( (lpszCmdLine != NULL) && (*lpszCmdLine != '\0') )
                {
			if ( wspawn( hInstance, WP_WAIT, lpszCmdLine, nCmdShow ) )
			{
				MessageBox(
					hWnd,
					lpszCmdLine,
					"NullSock : Can't launch", 
					MB_ICONEXCLAMATION | MB_OK
					);
			}
		}
		else
		{
			/*
			 *	If no application to run, just wait
			 */

			while (GetMessage (&msg, NULL, 0, 0))
			{
				TranslateMessage (&msg);
				DispatchMessage (&msg);
			}
		}

		/*
		 *	free winsock
	         */

		if (!hPrevInstance)
		{
			FreeLibrary(hLibrary);
			hLibrary = NULL;
	        }
	}
	else
        {
		/*
		 *	Spawn the application without waiting
		 */

		if ( (lpszCmdLine != NULL) && (*lpszCmdLine != '\0') )
                {
			if ( wspawn( hInstance, WP_WAIT, lpszCmdLine, nCmdShow ) )
			{
				MessageBox(
					hWnd,
					lpszCmdLine,
					"NullSock : Can't launch", 
					MB_ICONEXCLAMATION | MB_OK
					);
			}
                }
	}

	return msg.wParam ;
}

/*==== end of nullsock.c ===========================================*/
