#metachar.awk: Trivial awk script to protect HTML/SGML "&<>" meta-characters.
#
# Typical use:
#
#   awk -f htmlchek.awk infile.text > outfile.htmltext
#
#   This program protects the HTML/SGML metacharacters `&', `<' and `>' by
# replacing them with the appropriate entity references; it is useful for
# importing plain text into an HTML file.
#
#    On some systems, non-archaic awk may actually be named ``nawk''.  The
# ``gawk'' interpreter freely-available from the FSF GNU project is more robust
# than some vendor-supplied awk/nawk interpreters.
#
/[><&]/{gsub(/&/,"\\&amp;");gsub(/>/,"\\&gt;");gsub(/</,"\\&lt;")}
{print}
##EOF
