#!/bin/sh
#
# Shell script to run makemenu.awk under the best available awk interpreter,
# and avoid problems of invoking old awk, if possible.  Also does options
# checking.
#
case `type gawk` in *gawk ) awkntrp='gawk';;
                        * ) case `type nawk` in *nawk ) awkntrp='nawk';;
                                                    * ) awkntrp='awk';;
                            esac;;
esac
#
nonvar='NO'
title='NO'
for px
do
 case $px
 in -?* ) echo "You are passing flags to the $awkntrp interpreter in argument $px" >&2
          echo "(This may not be what you intended)" >&2 ;;
    *=* ) if   test $nonvar = 'YES'
          then echo "Error: An option=value argument $px followed" >&2
               echo "a filename argument on the command line." >&2
               exit 1
          else
            case $px
            in title=* ) title='YES';;
                 toc=* ) ;;
           dirprefix=* ) case $px
                          in */ ) ;;
                              * ) echo "Warning! dirprefix= does not end with \`/'" >&2;;
                         esac;;
             * ) echo "Error: In the option=value argument $px, the part" >&2
                 echo "before the equals sign \`=' is not a recognized option." >&2
                 exit 1;;
            esac
          fi;;
      * ) nonvar='YES';;
 esac
done
if test $title = 'NO'
then echo "No title= was specified; \"Menu for HTML files\" will be used as default" >&2
fi
#
case ${HTMLCHEK:-"/"}
    in */ ) ;;
       * ) HTMLCHEK="$HTMLCHEK/";;
esac
if test -s ${HTMLCHEK}makemenu.awk
then
    echo "Making menu now... (using $awkntrp)" >&2
    $awkntrp -f ${HTMLCHEK}makemenu.awk $@
    if test $? -ne 0
    then echo "Note: there was apparently an error in running $awkntrp" >&2
         exit 1
    fi
else
    echo "makemenu.awk is not found.  Either copy it to the current directory, or
set the environment variable HTMLCHEK to the pathname where it is located.
Do \`setenv HTMLCHEK /somedir/' in csh and tcsh, \`HTMLCHEK=/somedir/;
export HTMLCHEK' in sh and its offspring." >&2
    exit 1
fi
exit 0
