#!/usr/local/bin/perl
#entify.pl: Change Latin-1 high alphabetics to HTML entities for 7-bit safety.
#
# Typical use:
#
#   perl entify.pl infile.8bit > outfile.html
#
#   If you have Latin 1 characters in a URL, they should actually be escaped
# using the %-hex-digits convention; the program ignores this consideration.
#
# Copyright H. Churchyard 1995 -- freely redistributable.
# Version 1.0 12/30/94 -- Converted to perl.  Included in htmlchek 4.0 release.
# Version 1.1 2/17/95 -- Eliminated warning, may not have been appropriate in
# all circumstances.
#
eval "exec /usr/local/bin/perl -S $0 $*"
    if $running_under_some_shell; # this emulates #! processing on NIH machines.
$, = ' ';               # set output field separator
$\ = "\n";              # set output record separator
$enty{"\300"} = "&Agrave;"; $enty{"\301"} = "&Aacute;";
$enty{"\302"} = "&Acirc;"; $enty{"\303"} = "&Atilde;"; $enty{"\304"} = "&Auml;";
$enty{"\305"} = "&Aring;"; $enty{"\306"} = "&AElig;";
$enty{"\307"} = "&Ccedil;"; $enty{"\310"} = "&Egrave;";
$enty{"\311"} = "&Eacute;"; $enty{"\312"} = "&Ecirc;"; $enty{"\313"} = "&Euml;";
$enty{"\314"} = "&Igrave;"; $enty{"\315"} = "&Iacute;";
$enty{"\316"} = "&Icirc;"; $enty{"\317"} = "&Iuml;"; $enty{"\320"} = "&ETH;";
$enty{"\321"} = "&Ntilde;"; $enty{"\322"} = "&Ograve;";
$enty{"\323"} = "&Oacute;"; $enty{"\324"} = "&Ocirc;";
$enty{"\325"} = "&Otilde;"; $enty{"\326"} = "&Ouml;";
$enty{"\330"} = "&Oslash;"; $enty{"\331"} = "&Ugrave;";
$enty{"\332"} = "&Uacute;"; $enty{"\333"} = "&Ucirc;"; $enty{"\334"} = "&Uuml;";
$enty{"\335"} = "&Yacute;"; $enty{"\336"} = "&THORN;";
$enty{"\337"} = "&szlig;"; $enty{"\340"} = "&agrave;";
$enty{"\341"} = "&aacute;"; $enty{"\342"} = "&acirc;";
$enty{"\343"} = "&atilde;"; $enty{"\344"} = "&auml;"; $enty{"\345"} = "&aring;";
$enty{"\346"} = "&aelig;"; $enty{"\347"} = "&ccedil;";
$enty{"\350"} = "&egrave;"; $enty{"\351"} = "&eacute;";
$enty{"\352"} = "&ecirc;"; $enty{"\353"} = "&euml;"; $enty{"\354"} = "&igrave;";
$enty{"\355"} = "&iacute;"; $enty{"\356"} = "&icirc;"; $enty{"\357"} = "&iuml;";
$enty{"\360"} = "&eth;"; $enty{"\361"} = "&ntilde;"; $enty{"\362"} = "&ograve;";
$enty{"\363"} = "&oacute;"; $enty{"\364"} = "&ocirc;";
$enty{"\365"} = "&otilde;"; $enty{"\366"} = "&ouml;";
$enty{"\370"} = "&oslash;"; $enty{"\371"} = "&ugrave;";
$enty{"\372"} = "&uacute;"; $enty{"\373"} = "&ucirc;"; $enty{"\374"} = "&uuml;";
$enty{"\375"} = "&yacute;"; $enty{"\376"} = "&thorn;"; $enty{"\377"} = "&yuml;";
$enty{"\256"} = "&reg;"; $enty{"\251"} = "&copy;";
#
# Main
#
$stuperlRS = $/;
while (<>) {
    if ($_ =~ /$stuperlRS$/o) { # strip record separator, allow for last line to
        chop;}                  # be unterminated.
    if ($_ =~ /[\300-\377]/) {
        foreach $X (keys %enty) {
            if ($_ =~ $X) {
                $s_ = $enty{$X}; $_ =~ s/$X/$s_/g;}}}
    print $_;}
##EOF
