/****************************************************************************

    Module  : Main.c

*****************************************************************************/

#include <windows.h>
#include <stdio.h>		// for sprintf()
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "freedock.h"

/**********************************************************
	Global Data for the various system metrics we need
**********************************************************/
GLOBAL_METRICS gMetrics;
GLOBAL_OPTIONS gOptions;

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
    MSG       msg;
    WNDCLASS  wcDockClass;
	HWND	  hwndDock;

    /*****************************************************************************
        Test to make sure this is the only copy of this application running
        on this machine, if not activate previous instance and exit.
		<<<< THIS DOES NOT WORK UNDER WIN32 : NEED TO FIND ALTERNATIVE >>>>
    *****************************************************************************/
    if (hPrevInstance) {
        ShowWindow( hPrevInstance, SW_SHOW );
        exit (-1);
    }

	/**************************************************************************
	 * Set the name of the application                                        *
 	**************************************************************************/
	sprintf( gOptions.szAppName, "FreeDock %s %s", VersionText, OS_Bits );

    /*************************************************************
         Determine the size of the screen, used to size and
         position the window.
    *************************************************************/
    gMetrics.ScreenWidth    = GetSystemMetrics(SM_CXSCREEN);
    gMetrics.ScreenHeight   = GetSystemMetrics(SM_CYSCREEN);
    gMetrics.IconWidth      = GetSystemMetrics(SM_CXICON);
    gMetrics.IconHeight     = GetSystemMetrics(SM_CYICON);
	gMetrics.DlgTitleHeight = GetSystemMetrics(SM_CYCAPTION);
	gMetrics.DlgFrameWidth  = GetSystemMetrics(SM_CXDLGFRAME);
	gMetrics.DlgFrameHeight = GetSystemMetrics(SM_CYDLGFRAME);
	ReadGlobalOptions();

    /*********************************************
      * define and register the dock window class *
     *********************************************/

    wcDockClass.style = CS_DBLCLKS;
    wcDockClass.lpfnWndProc = (WNDPROC) DockWinProc;
    wcDockClass.cbClsExtra = 0;
    wcDockClass.cbWndExtra = 0;
    wcDockClass.hInstance = hInstance;
    wcDockClass.hCursor = LoadCursor(NULL, IDC_ARROW);
    wcDockClass.hbrBackground = GetStockObject(LTGRAY_BRUSH);
    wcDockClass.lpszMenuName = NULL;
    wcDockClass.lpszClassName = gOptions.szAppName;

#ifdef WIN32
    wcDockClass.hIcon = LoadIcon(hInstance, "FREEDOCK32");
#else
    wcDockClass.hIcon = LoadIcon(hInstance, "FREEDOCK16");
#endif

    if(!RegisterClass(&wcDockClass)) return FALSE;

    gOptions.hAppInst = hInstance;

    /********************************************
      create and position the root dock window
    ********************************************/

    hwndDock = CreateWindow(
        gOptions.szAppName,                 /* window class name    */
        gOptions.szAppName,                /* window caption       */
        WS_VISIBLE | WS_POPUP | WS_BORDER,  /* window style         */
        0,          						/* initial x position   */
        0,          						/* initial y position   */
        20,                   				/* initial x size       */
        20,                   				/* initial y size       */
        NULL,                       		/* parent window handle */
        NULL,                       		/* window menu handle   */
        hInstance,                  		/* program instance handle */
        NULL		                    	/* creation parameters NULL = RootDock */
        );

    if(!hwndDock) return FALSE;

    ShowWindow(hwndDock, SW_SHOW);
    UpdateWindow(hwndDock);

    /************************************************
         enter message processing loop
    ************************************************/

    while (GetMessage(&msg, NULL, 0, 0)) {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }

    return msg.wParam;      /* exit application */
}
