unit Packfil;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
     StdCtrls, ExtCtrls,Dialogs,SysUtils;

type
  TPackDialog = class(TForm)
    OKBtn: TBitBtn;
    CreateBtn: TBitBtn;
    DeleteBtn: TBitBtn;
    Bevel1: TBevel;
    PackList: TListBox;
    Label1: TLabel;
    Label2: TLabel;
    PackEdit: TEdit;
    procedure Initialise(Sender: TObject);
    procedure Modification(Sender: TObject);
    procedure CreateBtnClick(Sender: TObject);
    procedure DeleteBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
  private
    { Private declarations }
    modif : boolean;
  public
    { Public declarations }
  end;

var PackDialog: TPackDialog;

implementation

uses Decla;

{$R *.DFM}

(* init dialog *)
procedure TPackDialog.Initialise(Sender: TObject);
var Bcl : integer;
begin
 PackList.Clear;
 if Number_Pack > 0 then
 begin
  For Bcl := 1 to Number_Pack do
  begin
   With VPack [Bcl] do
    PackList.Items.Add (Libelle);
  end;
 end;
 PackList.ItemIndex := -1;
 PackEdit.Text := '';
 Modif := false;
 ActiveControl := PackEdit;
end;

(* modification *)
procedure TPackDialog.Modification(Sender: TObject);
begin
 Modif := true;
 PackEdit.Text := PackList.Items [PackList.ItemIndex];
 PackList.Enabled := false;
 OkBtn.Enabled := false;
 CreateBtn.Caption := '&Modif.';
 ActiveControl := PackEdit;
end;

(* create button *)
procedure TPackDialog.CreateBtnClick(Sender: TObject);
begin
 if Modif = true then
 (* modification *)
 begin
  VPack [PackList.ItemIndex + 1].Libelle := PackEdit.Text;
  PackList.Items [PackList.ItemIndex] := PackEdit.Text;
  PackEdit.Text := '';
 end
 else
 (* creation *)
 begin
  if (Number_Pack + 1) < Max_Pack then
  begin
   Inc (Number_Pack);
   With VPack [Number_Pack] do
   begin
    Libelle := PackEdit.Text;
    PackList.Items.Add (PackEdit.Text);
    PackEdit.Text := '';
   end;
  end
  else
   MessageDlg ('Maximum of pack file reached',mtInformation,[mbok],0);
 end;
 Modif := false;
 CreateBtn.Caption := '&Create';
 OkBtn.Enabled := true;
 PackList.Enabled := true;
 PackList.ItemIndex := -1;
 ActiveControl := PackList;
end;

(* delete button *)
procedure TPackDialog.DeleteBtnClick(Sender: TObject);
var Bcl : integer;
    Tmp : integer;
begin
 if PackList.ItemIndex <> -1 then
 begin
  Tmp := PackList.ItemIndex + 1;
  if Tmp <> Number_Pack then
  begin
   for Bcl := Tmp to (Number_Pack - 1) do
    VPack [Bcl] := VPack [Bcl + 1];
  end;
  VPack [Number_Pack].libelle := '';
  Dec (Number_Pack);
  PackList.Items.Delete (PackList.ItemIndex);
 end;
 PackList.ItemIndex := -1;
end;

(* ok button *)
procedure TPackDialog.OKBtnClick(Sender: TObject);
begin
 ModalResult := mrOk;
 Close;
end;

end.
