unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus,Decla,Disque, StdCtrls, ExtCtrls, Buttons, Verinfo,
  LZExpand;

const Typ_Fil = 1;
      Typ_Ico = 2;
      Typ_App = 3;

type
  TMainDialog = class(TForm)
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    (* menu *)
    MainMenu: TMainMenu;
    (* project *)
    MProject: TMenuItem;
    Pro_New: TMenuItem;
    Pro_Ope: TMenuItem;
    Pro_Sav: TMenuItem;
    N1: TMenuItem;
    Pro_Gen: TMenuItem;
    Pro_Mak: TMenuItem;
    N2: TMenuItem;
    Pro_Qui: TMenuItem;
    (* files *)
    MFile: TMenuItem;
    Fil_Add: TMenuItem;
    Fil_Del: TMenuItem;
    Fil_Mod: TMenuItem;
    (* icons *)
    MIcons: TMenuItem;
    Ico_Add: TMenuItem;
    Ico_Del: TMenuItem;
    Ico_Mod: TMenuItem;
    (* applications *)
    MAppli: TMenuItem;
    App_Add: TMenuItem;
    App_Del: TMenuItem;
    App_Mod: TMenuItem;
    (* INI Files *)
    MIni: TMenuItem;
    Ini_Add: TMenuItem;
    Ini_Del: TMenuItem;
    Ini_Mod: TMenuItem;
    (* Option *)
    MOption: TMenuItem;
    Opt_Pro: TMenuItem;
    Opt_Grp: TMenuItem;
    Opt_Trg: TMenuItem;
    Opt_Src: TMenuItem;
    N3: TMenuItem;
    Opt_Pck: TMenuItem;
    Opt_Pack: TMenuItem;
    (* help *)
    MHelp: TMenuItem;
    Hlp_Idx: TMenuItem;
    N4: TMenuItem;
    Hlp_Abt: TMenuItem;
    (* other components *)
    Add_Files: TOpenDialog;
    Add_Icons: TOpenDialog;
    (* screen components *)

    (* files *)
    ListFiles: TListBox;
    btFilAdd: TBitBtn;
    btFilDel: TBitBtn;
    btFilMod: TBitBtn;
    PNbrF: TLabel;
    (* icons *)
    ListIcons: TListBox;
    btIcoMod: TBitBtn;
    btIcoDel: TBitBtn;
    btIcoAdd: TBitBtn;
    PNbrI: TLabel;
    (* documents *)
    ListApp: TListBox;
    btAppMod: TBitBtn;
    btAppDel: TBitBtn;
    btAppAdd: TBitBtn;
    PNbrA: TLabel;
    (* ini files *)
    ListIni: TListBox;
    btIniAdd: TBitBtn;
    btIniDel: TBitBtn;
    btIniMod: TBitBtn;
    PNbrN: TLabel;
    (* project *)
    PFlop: TLabel;
    PTitle: TEdit;
    PSubTitle: TEdit;
    PVersion: TEdit;
    PCopyRight: TEdit;
    PAuthor: TEdit;
    (* info *)
    PSrcSize: TLabel;
    PTrgSize: TLabel;
    (* buttons *)
    btQuit: TBitBtn;
    btOpen: TBitBtn;
    btSave: TBitBtn;
    btGene: TBitBtn;
    btSrce: TBitBtn;
    btTarg: TBitBtn;
    btGrpe: TBitBtn;
    (* other *)
    History: TMemo;
    HistClearbt: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label19: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Bevel4: TBevel;
    Bevel5: TBevel;
    Bevel6: TBevel;
    Bevel7: TBevel;
    Bevel8: TBevel;
    Bevel9: TBevel;
    Bevel10: TBevel;
    VersionInfo: TVersionInfo;
    btPacF: TBitBtn;
    Label18: TLabel;
    btMake: TBitBtn;

    (* project menu *)
    procedure Pro_NewClick(Sender: TObject);
    procedure Pro_OpeClick(Sender: TObject);
    procedure Pro_SavClick(Sender: TObject);
    procedure Pro_GenClick(Sender: TObject);
    procedure Pro_QuiClick(Sender: TObject);
    (* files menu *)
    procedure Fil_AddClick(Sender: TObject);
    procedure Fil_DelClick(Sender: TObject);
    procedure Fil_ModClick(Sender: TObject);
    (* icons menu *)
    procedure Ico_AddClick(Sender: TObject);
    procedure Ico_DelClick(Sender: TObject);
    procedure Ico_ModClick(Sender: TObject);
    (* application menu *)
    procedure App_AddClick(Sender: TObject);
    procedure App_DelClick(Sender: TObject);
    procedure App_ModClick(Sender: TObject);
    (* ini files menu *)
    procedure Ini_AddClick(Sender: TObject);
    procedure Ini_ModClick(Sender: TObject);
    procedure Ini_DelClick(Sender: TObject);
    (* options menu *)
    procedure Opt_ProClick(Sender: TObject);
    procedure Opt_GrpClick(Sender: TObject);
    procedure Opt_SrcClick(Sender: TObject);
    procedure Opt_TrgClick(Sender: TObject);
    procedure Opt_PackClick(Sender: TObject);
    (* help menu *)
    procedure Hlp_AbtClick(Sender: TObject);
    (* other things about screen *)
    procedure HistClearbtClick(Sender: TObject);
    procedure CheckMenu (Sender : TObject);
    procedure FormResize(Sender: TObject);
    procedure ChangeModif(Sender: TObject);
    procedure Initialisation(Sender: TObject);
    procedure Opt_PckClick(Sender: TObject);
    procedure Hlp_IdxClick(Sender: TObject);
    procedure Pro_MakClick(Sender: TObject);
  private
    { Private-dclarations }
    procedure MainInit;
    procedure UpdateScreen;
    procedure InitAll;
    procedure StoreFile (Name : string;Number : integer;Tipe : byte);
    function  LookDir (Path : string) : string;
    procedure MakeHistory (Line : string);
    procedure GetScreenInfo;
    procedure SaveProject;
    procedure LoadProject;
    procedure GenerateProject;
    procedure PackingLstFile;
    function  MakeNewDisk (Number : byte) : integer;
    function  MakeFloppies : integer;
    function  IsCompressed (sFile : string) : boolean;
  public
    { Public-dclarations }
  end;

var
  MainDialog: TMainDialog;

implementation

{$R *.DFM}
{$R INFO.RES}

uses About,Delete,Choose,FilMod,IcoMod,AppAdd,AppMod,Project,Group,
     Source,Target,JIniFile,PackFil;

(***********)
(* project *)
(***********)

(* new project *)
procedure TMainDialog.Pro_NewClick(Sender: TObject);
var Tmp : integer;
begin
 if Modification then
 begin
  Tmp := MessageDlg ('Would you want to save current project',
                     mtConfirmation,[mbYes,mbNo,mbCancel],0);
  if Tmp = mrYes then SaveProject;
 end;
 if Tmp = mrCancel then exit;
 InitAll;
 MainInit;
 Modification := False;
 CheckMenu (Sender);
 Caption := Prg_Title + ' v' + Prg_Versi + ' (Untitled)';
 MakeHistory ('New project starting');
end;

(* open project *)
procedure TMainDialog.Pro_OpeClick(Sender: TObject);
var Tmp : integer;
begin
 if Modification then
 begin
  Tmp := MessageDlg ('Would you want to save current project',
                     mtConfirmation,[mbYes,mbNo,mbCancel],0);
  if Tmp = mrYes then SaveProject;
 end;
 if Tmp = mrCancel then exit;
 if OpenDialog.Execute then
 begin
  InitAll;
  MainInit;
  Modification := False;
  ProjectName := OpenDialog.FileName;
  LoadProject;
  Caption := Prg_Title + ' v' + Prg_Versi + ' (' + OpenDialog.FileName + ')';
  MakeHistory ('Loading project ' + Title);
 end;
 CheckMenu (Sender);
end;

(* saving project *)
procedure TMainDialog.Pro_SavClick(Sender: TObject);
begin
 if ProjectName <> '' then SaveDialog.FileName := ProjectName;
 if SaveDialog.Execute then
 begin
  ProjectName := SaveDialog.FileName;
  Caption := Prg_Title + ' v' + Prg_Versi + ' (' + ProjectName + ')';
  MakeHistory ('Saving ' + Title);
  SaveProject;
  Modification := false;
  CheckMenu (Sender);
 end;
end;

(* generate INS Files *)
procedure TMainDialog.Pro_GenClick(Sender: TObject);
begin
 if Modification then
  if MessageDlg ('Would you want to save before generating',
                 mtConfirmation,[mbYes,mbNo],0) = mrYes then
  begin
  end;
 if MessageDlg ('Ready to generate setup.ins file',
                mtConfirmation,[mbYes,mbNo],0) = mrYes then
 begin
  MakeHistory ('Generating SETUP.INS file');
  GenerateProject;
 end;
 CheckMenu (Sender);
end;

(* make floppies *)
procedure TMainDialog.Pro_MakClick(Sender: TObject);
var Err : integer;
    Tmp : string;
begin
 Err := 0;
 if Modification then
  if MessageDlg ('Would you want to save before making floppies',
                 mtConfirmation,[mbYes,mbNo],0) = mrYes then
  begin
  end;
 if MessageDlg ('Ready to making floppies',
                mtConfirmation,[mbYes,mbNo],0) = mrYes then
 begin
  MakeHistory ('Making floppies');
  Err := MakeFloppies;
 end;
 Tmp := '';
 Case Err of
  0 : Tmp := '';
  1 : Tmp := 'File already exist on floppie';
  2 : Tmp := 'Unable to open source file';
  3 : Tmp := 'Unable to open target file';
  4 : Tmp := 'Unable to read into source file';
  5 : Tmp := 'Unable to write into target file';
  6 : Tmp := 'Unable to create identification for floppy';
  7 : Tmp := 'User cancelling at identification creation';
  8 : Tmp := 'Error on original source path';
  else
   Tmp := 'Unknown error';
 end;
 if Tmp <> '' then MessageDlg (Tmp,mtError,[mbok],0);
 CheckMenu (Sender);
end;

(* quit create *)
procedure TMainDialog.Pro_QuiClick(Sender: TObject);
var Tmp : integer;
begin
 if Modification then
  Tmp :=  MessageDlg ('Would you want to save your project',
                      mtConfirmation,[mbYes,mbNo,mbCancel],0);
 if Tmp = mrCancel then exit;
 if Tmp = mrYes then
 begin
 end;
 Close;
end;


(*********)
(* files *)
(*********)

(* adding *)
procedure TMainDialog.Fil_AddClick(Sender: TObject);
var iCtr : integer;
begin
 if (Number_Files + 1) < Max_Files then
 begin
  MakeHistory ('Adding a file');
  if Add_Files.Execute then
  begin
   for Ictr := 0 to (Add_Files.Files.count - 1) do
   begin
    if (Number_Files  + 1) <= Max_Files then
    begin
     Modification := True;
     Inc (Number_Files);
     StoreFile (Add_Files.Files[iCtr],Number_Files,Typ_Fil);
     With VFiles [Number_Files] do
     begin
{     MessageDlg ('File ' + inttostr (Number_Files) + #13 +
                  FileDriv + '|' + FilePath + '|'+
                  FileName + #13 +
                  'Size ' + inttostr (SizeNorm) + #13 +
                  'Compress ' + inttostr (Compress) + '|' + IntTostr (SizeComp),
                  mtinformation,[mbok],0);}
      Disk_Current := Disk_Current + SizeNorm;
      if CopyFile = 1 then
      begin
       if Compress = 1 then
        Disk_Space := Disk_Space + SizeComp
       else
        Disk_Space := Disk_Space + SizeNorm;
      end;
     end;
    end
    else
    begin
     MessageDlg ('Maximum of files reached',mtInformation,[mbok],0);
     CheckMenu (Sender);
     Exit;
    end;
   end;
  end;
 end
 else
  MessageDlg ('Maximum of files reached',mtInformation,[mbok],0);
 CheckMenu (Sender);
end;

(* delete *)
procedure TMainDialog.Fil_DelClick(Sender: TObject);
var Bcl : integer;
    Tmp : integer;
begin
 if Number_Files > 0 then
 begin
  MakeHistory ('Deleting a file');
  (* prepare dialog *)
  VTrans.Title := 'Delete a file';
  VTrans.Number := Number_Files;
  if ListFiles.ItemIndex <> -1 then
   VTrans.Positi := ListFiles.ItemIndex + 1
  else
   VTrans.Positi := -1;
  for Bcl := 1 to Number_Files do
  begin
   VLibel [Bcl].Libelle := VFiles [Bcl].FileName;
   VLibel [Bcl].Exists := True;
  end;
  if DeleteDialog.ShowModal = mrOk then
  begin
   (* looking delete *)
   Tmp := 0;
   for Bcl := 1 to Number_Files do
    if VLibel [Bcl].Exists = False then Tmp := Bcl;
   if Tmp <> 0 then
   begin
    Disk_Current := Disk_Current - VFiles [Tmp].SizeNorm;
    if VFiles [Tmp].CopyFile = 1 then
     if VFiles [Tmp].Compress = 1 then
      Disk_Space := Disk_Space - VFiles [Tmp].SizeComp
     else
      Disk_Space := Disk_Space - VFiles [Tmp].SizeNorm;
   end;
   if Tmp < Number_Files then
   begin
    for Bcl := Tmp to (Number_Files - 1) do
     VFiles [Bcl] := VFiles [Bcl + 1];
   end;
   (* erase last one *)
   With VFiles [Number_Files] do
   begin
    DiskNumb := 0;
    OrigName := '';
    FileDriv := '';
    FileName := '';
    FilePath := '';
    Compress := 0;
    CopyFile := 1;
    SizeNorm := 0;
    SizeComp := 0;
    PackFile := 0;
   end;
   Dec (Number_Files);
  end;
 end;
 CheckMenu (Sender);
end;

(* modify *)
procedure TMainDialog.Fil_ModClick(Sender: TObject);
var Tmp : integer;
    Lop : integer;
begin
 if Number_Files > 0 then
 begin
  MakeHistory ('Modifying a file');
  VTrans.Title := 'Choose a file';
  VTrans.Number := 1;
  VTrans.Positi := 0;
  if ListFiles.SelCount = 1 then
  begin
   if ListFiles.ItemIndex <> -1 then
   begin
    VTrans.Number := ListFiles.ItemIndex + 1;
    Tmp := VFiles [VTrans.Number].CopyFile;
    FileModDialog.ShowModal;
   end
   else
   begin
    if ChooseDialog.ShowModal = mrOk then
    begin
     Inc (VTrans.Number);
     if VTrans.Number > 0 then
     begin
      Tmp := VFiles [VTrans.Number].CopyFile;
      FileModDialog.ShowModal;
     end;
    end;
   end;
   (* copy to not copy *)
   With VFiles [VTrans.Number] do
   begin
    if (Tmp = 1) and (CopyFile = 0) then
    begin
     if Compress = 1 then
      Disk_Space := Disk_Space - SizeComp
     else
      Disk_Space := Disk_Space - SizeNorm;
    end;
    (* not copy to copy *)
    if (Tmp = 0) and (CopyFile = 1) then
    begin
     if Compress = 1 then
      Disk_Space := Disk_Space + SizeComp
     else
      Disk_Space := Disk_Space + SizeNorm;
    end;
   end;
  end
  else
  (* multiple *)
  begin
   VTrans.Positi := 1;
   With MultiF do
   begin
    FileDriv := VPath [1].LettDriv;
    FilePath := VPath [1].PathDriv;
    CopyFile := 1;
    PackFile := 0;
   end;
   if FileModDialog.ShowModal = mrOk then
   begin
    for Lop := 0 to (ListFiles.Items.Count - 1) do
    begin
     if ListFiles.Selected [Lop] = true then
     begin
      With VFiles [Lop + 1] do
      begin
       (* packetfile *)
       PackFile := MultiF.PackFile;
       (* copyFile *)
       CopyFile := MultiF.CopyFile;
       (* path *)
       FileDriv := MultiF.FileDriv;
       FilePath := MultiF.FilePath;
       (* copy to not copy *)
       Tmp := CopyFile;
       if (Tmp = 1) and (MultiF.CopyFile = 0) then
       begin
        if Compress = 1 then
         Disk_Space := Disk_Space - SizeComp
        else
         Disk_Space := Disk_Space - SizeNorm;
       end;
       (* not copy to copy *)
       if (Tmp = 0) and (MultiF.CopyFile = 1) then
       begin
        if Compress = 1 then
         Disk_Space := Disk_Space + SizeComp
        else
         Disk_Space := Disk_Space + SizeNorm;
       end;
       CopyFile := MultiF.CopyFile;
      end;
     end;
    end;
   end;
  end;
 end;
 CheckMenu (Sender);
end;


(*********)
(* icons *)
(*********)

(* adding *)
procedure TMainDialog.Ico_AddClick(Sender: TObject);
var ICtr : integer;
begin
 if (Number_Icons + 1) < Max_Icons then
 begin
  MakeHistory ('Adding an icon');
  if Add_Icons.Execute then
  begin
   for Ictr := 0 to (Add_Icons.Files.count - 1) do
   begin
    if (Number_Icons  + 1) <= Max_Icons then
    begin
     Modification := True;
     Inc (Number_Icons);
     StoreFile (Add_Icons.Files[iCtr],Number_Icons,Typ_Ico);
     With VIcons [Number_Icons] do
     begin
{      MessageDlg ('File ' + inttostr (Number_Icons) + #13 +
                  IconName + #13 +
                  FileDriv + '|' + FilePath + '|'+
                  FileName + #13 +
                  'Size ' + inttostr (SizeNorm) + #13 +
                  'Compress ' + inttostr (Compress) + '|' + IntTostr (SizeComp),
                  mtinformation,[mbok],0);}
      Disk_Current := Disk_Current + SizeNorm;
      if Compress = 1 then
       Disk_Space := Disk_Space + SizeComp
      else
       Disk_Space := Disk_Space + SizeNorm;
      GroupNum := 1;
     end;
    end
    else
    begin
     MessageDlg ('Maximum of icons reached',mtInformation,[mbok],0);
     CheckMenu (Sender);
     Exit;
    end;
   end;
  end;
 end
 else
  MessageDlg ('Maximum of icons reached',mtInformation,[mbok],0);
 CheckMenu (Sender);
end;

(* delete *)
procedure TMainDialog.Ico_DelClick(Sender: TObject);
var Bcl : integer;
    Tmp : integer;
begin
 if Number_Icons > 0 then
 begin
  MakeHistory ('Deleting an icon');
  (* prepare dialog *)
  VTrans.Title := 'Delete an icon';
  VTrans.Number := Number_Icons;
  if ListIcons.ItemIndex <> -1 then
   VTrans.Positi := ListIcons.ItemIndex + 1
  else
   VTrans.Positi := -1;
  for Bcl := 1 to Number_Icons do
  begin
   VLibel [Bcl].Libelle := VIcons [Bcl].FileName;
   VLibel [Bcl].Exists := True;
  end;
  if DeleteDialog.ShowModal = mrOk then
  begin
   (* looking delete *)
   Tmp := 0;
   for Bcl := 1 to Number_Icons do
    if VLibel [Bcl].Exists = False then Tmp := Bcl;
   if Tmp <> 0 then
   begin
    Disk_Current := Disk_Current - VIcons [Tmp].SizeNorm;
    if VIcons [Tmp].Compress = 1 then
     Disk_Space := Disk_Space - VIcons [Tmp].SizeComp
    else
     Disk_Space := Disk_Space - VIcons [Tmp].SizeNorm;
   end;
   if Tmp < Number_Icons then
   begin
    for Bcl := Tmp to (Number_Icons - 1) do
     VIcons [Bcl] := VIcons [Bcl + 1];
   end;
   (* erase last one *)
   With VIcons [Number_Icons] do
   begin
    DiskNumb := 0;
    OrigName := '';
    FileDriv := '';
    FileName := '';
    FilePath := '';
    Compress := 0;
    SizeNorm := 0;
    SizeComp := 0;
    IconName := '';
    GroupNum := 1;
    PackFile := 0;
   end;
   Dec (Number_Icons);
  end;
 end;
 CheckMenu (Sender);
end;

(* modify *)
procedure TMainDialog.Ico_ModClick(Sender: TObject);
var Bcl : integer;
begin
 if Number_Icons > 0 then
 begin
  MakeHistory ('Modifying an icon');
  VTrans.Title := 'Choose an icon';
  VTrans.Number := 2;
  VTrans.Positi := 0;
  if ListIcons.SelCount = 1 then
  (* one icon *)
  begin
   if ListIcons.ItemIndex <> -1 then
   begin
    VTrans.Number := ListIcons.ItemIndex + 1;
    IconModDialog.ShowModal;
   end
   else
   begin
    if ChooseDialog.ShowModal = mrOk then
    begin
     Inc (VTrans.Number);
     if VTrans.Number > 0 then
      IconModDialog.ShowModal;
    end;
   end;
  end
  else
  (* multiple *)
  begin
   VTrans.Positi := 1;
   With MultiI do
   begin
    FileDriv := VPath [1].LettDriv;
    FilePath := VPath [1].PathDriv;
    PackFile := 0;
    GroupNum := 0;
   end;
   if IconModDialog.ShowModal = mrOk then
   begin
    for Bcl := 0 to (ListIcons.Items.Count - 1) do
    begin
     if ListIcons.Selected [Bcl] = true then
     begin
      with VIcons [Bcl + 1] do
      begin
       FileDriv := MultiI.FileDriv;
       FilePath := MultiI.FilePath;
       PackFile := MultiI.PackFile;
       GroupNum := MultiI.GroupNum;
      end;
     end;
    end;
   end;
  end;
 end;
 CheckMenu (Sender);
end;


(***************)
(* application *)
(***************)

(* adding *)
procedure TMainDialog.App_AddClick(Sender: TObject);
begin
 if (Number_Run + 1) < Max_Run then
 begin
  MakeHistory ('Add a document');
  if AddAppDialog.ShowModal = mrOk then
  begin
   Inc (Number_Run);
   With VRun [Number_Run] do
   begin
    Case VTrans.Number of
     1 : (* a file *)
         begin
          DocsDriv := VFiles [VTrans.Positi].FileDriv;
          DocsPath := VFiles [VTrans.Positi].FilePath;
          DocsName := VFiles [VTrans.Positi].FileName;
          PackFile := VFiles [VTrans.Positi].PackFile;
         end;
     2 : (* icons *)
         begin
          DocsDriv := VIcons [VTrans.Positi].FileDriv;
          DocsPath := VIcons [VTrans.Positi].FilePath;
          DocsName := VIcons [VTrans.Positi].FileName;
          PackFile := VFiles [VTrans.Positi].PackFile;
         end;
    end;
    DocsPath := LookDir (DocsDriv + DocsPath);
    FilePath := '%W';
    if pos ('.HLP',DocsName) <> 0 then
     FileName := 'WINHELP.EXE'
    else
     if pos ('.WRI',DocsName) <> 0 then
      FileName := 'WRITE.EXE'
     else
      FileName := 'NOTEPAD.EXE';
{    MessageDlg ('Document' + #13 +
                DocsPath + '|' + DocsName +
                #13 +
                FilePath + '|' + FileName,
                mtinformation,[mbok],0);}
    if VTrans.Number = 1 then
    (* file *)
    begin
     if VFiles [VTrans.Positi].Compress = 1 then
      DocsName := VFiles [VTrans.Positi].OrigName;
    end
    else
    (* icon *)
    begin
     if VIcons [VTrans.Positi].Compress = 1 then
      DocsName := VIcons [VTrans.Positi].OrigName;
    end;
   end;
  end;
 end
 else
  MessageDlg ('Maximum of documents reached',mtInformation,[mbok],0);
 CheckMenu (Sender);
end;

(* delete *)
procedure TMainDialog.App_DelClick(Sender: TObject);
var Bcl : integer;
    Tmp : integer;
begin
 if Number_Run > 0 then
 begin
  MakeHistory ('Deleting a document');
  (* prepare dialog *)
  VTrans.Title := 'Delete a document';
  VTrans.Number := Number_Run;
  if ListApp.ItemIndex <> -1 then
   VTrans.Positi := ListApp.ItemIndex + 1
  else
   VTrans.Positi := -1;
  for Bcl := 1 to Number_Run do
  begin
   VLibel [Bcl].Libelle := VRun [Bcl].DocsName;
   VLibel [Bcl].Exists := True;
  end;
  if DeleteDialog.ShowModal = mrOk then
  begin
   (* looking delete *)
   for Bcl := 1 to Number_Run do
    if VLibel [Bcl].Exists = False then Tmp := Bcl;
   if Tmp < Number_Run then
   begin
    for Bcl := Tmp to (Number_Run - 1) do
     VRun [Bcl] := VRun [Bcl + 1];
   end;
   (* erase last one *)
   With VRun [Number_Run] do
   begin
    FileName := '';
    FilePath := '';
    DocsDriv := '';
    DocsName := '';
    DocsPath := '';
    PackFile := 0;
   end;
   Dec (Number_Run);
  end;
 end;
 CheckMenu (Sender);
end;

(* modify *)
procedure TMainDialog.App_ModClick(Sender: TObject);
var Bcl : integer;
begin
 if Number_Run > 0 then
 begin
  MakeHistory ('Modifying a document');
  VTrans.Title := 'Choose a document';
  VTrans.Number := 3;
  VTrans.Positi := 0;
  if ListApp.SelCount = 1 then
  (* one *)
  begin
   if ListApp.ItemIndex <> -1 then
   begin
    VTrans.Number := ListApp.ItemIndex + 1;
    AppModDialog.ShowModal;
   end
   else
   begin
    if ChooseDialog.ShowModal = mrOk then
    begin
     Inc (VTrans.Number);
     if VTrans.Number > 0 then
      AppModDialog.ShowModal;
    end;
   end;
  end
  else
  (* multiple *)
  begin
   VTrans.Positi := 1;
   With MultiD do
   begin
    DocsPath := VPath [1].PathDriv;
    DocsDriv := VPath [1].LettDriv;
   end;
   if AppModDialog.ShowModal = mrOk then
   begin
    for Bcl := 0 to (ListApp.Items.Count - 1) do
    begin
     if ListApp.Selected [Bcl] = true then
     begin
      With VRun [Bcl + 1] do
      begin
       DocsPath := MultiD.DocsPath;
       DocsDriv := MultiD.DocsDriv;
       FileName := MultiD.FileName;
       FilePath := MultiD.FilePath;
       PackFile := MultiD.PackFile;
      end;
     end;
    end;
   end;
  end;
 end;
 CheckMenu (Sender);
end;


(*************)
(* ini files *)
(*************)

(* add *)
procedure TMainDialog.Ini_AddClick(Sender: TObject);
begin
 MakeHistory ('Adding an Ini file');
 VTrans.Number := 0;
 IniDialog.ShowModal;
 CheckMenu (Sender);
end;

(* modify *)
procedure TMainDialog.Ini_ModClick(Sender: TObject);
begin
 if Number_Ini > 0 then
 begin
  MakeHistory ('Modifying an Ini file');
  VTrans.Title := 'Choose an Ini file';
  VTrans.Number := 4;
  if ListIni.ItemIndex <> -1 then
  begin
   VTrans.Number := ListIni.ItemIndex + 1;
   IniDialog.ShowModal;
  end
  else
  begin
   if ChooseDialog.ShowModal = mrOk then
   begin
    Inc (VTrans.Number);
    if VTrans.Number > 0 then
     IniDialog.ShowModal;
   end;
  end;
 end;
 CheckMenu (Sender);
end;

(* delete *)
procedure TMainDialog.Ini_DelClick(Sender: TObject);
var Bcl : integer;
    Tmp : integer;
begin
 if Number_Ini > 0 then
 begin
  MakeHistory ('Deleting an Ini file');
  (* prepare dialog *)
  VTrans.Title := 'Delete an Ini file';
  VTrans.Number := Number_Ini;
  if ListIni.ItemIndex <> -1 then
   VTrans.Positi := ListIni.ItemIndex + 1
  else
   VTrans.Positi := -1;
  for Bcl := 1 to Number_Ini do
  begin
   VLibel [Bcl].Libelle := VIniF [Bcl].FileName;
   VLibel [Bcl].Exists := True;
  end;
  if DeleteDialog.ShowModal = mrOk then
  begin
   (* looking delete *)
   Tmp := 0;
   for Bcl := 1 to Number_Ini do
    if VLibel [Bcl].Exists = False then Tmp := Bcl;
   if Tmp < Number_Ini then
   begin
    for Bcl := Tmp to (Number_Ini - 1) do
     VIniF [Bcl] := VIniF [Bcl + 1];
   end;
   (* erase last one *)
   With VIniF [Number_Files] do
   begin
    FilePath := '';
    FileName := '';
    INISecti := '';
    INIField := '';
    INIValue := '';
   end;
   Dec (Number_Ini);
  end;
 end;
 CheckMenu (Sender);
end;


(***********)
(* Options *)
(***********)

(* Project *)
procedure TMainDialog.Opt_ProClick(Sender: TObject);
begin
 MakeHistory ('Project information');
 if ProjectDialog.ShowModal = mrOk then
  UpDateScreen;
end;

(* Item group *)
procedure TMainDialog.Opt_GrpClick(Sender: TObject);
begin
 MakeHistory ('Setting group informations');
 GroupDialog.ShowModal;
end;

(* source drive and directory *)
procedure TMainDialog.Opt_SrcClick(Sender: TObject);
begin
 MakeHistory ('Setting source');
 SourceDialog.ShowModal;
end;

(* targets drives and directories *)
procedure TMainDialog.Opt_TrgClick(Sender: TObject);
begin
 MakeHistory ('Setting targets');
 TargetDialog.ShowModal;
end;

(* pack file button *)
procedure TMainDialog.Opt_PackClick(Sender: TObject);
begin
 MakeHistory ('Setting packet files');
 PackDialog.ShowModal;
end;

(* check packing lst file *)
procedure TMainDialog.Opt_PckClick(Sender: TObject);
begin
 Opt_Pck.Checked := not (Opt_Pck.Checked);
 if Opt_Pck.Checked = true then
  MakeHistory ('Packing list file On')
 else
  MakeHistory ('Packing list file Off');
 Modification := true;
end;

(********)
(* help *)
(********)
                        
(* Help index *)
procedure TMainDialog.Hlp_IdxClick(Sender: TObject);
begin
 Application.HelpFile := 'CREATE.HLP';
 Application.HelpCommand(HELP_CONTENTS, 0);
end;

(* about Create *)
procedure TMainDialog.Hlp_AbtClick(Sender: TObject);
begin
 AboutDialog.ShowModal;
end;

(********************)
(* dialog functions *)
(********************)

(* check all menu *)
procedure TMainDialog.CheckMenu (Sender : TObject);
begin
 (* menu *)
 Pro_Gen.Enabled := ProjectName <> '';
 Pro_Mak.Enabled := ProjectName <> '';
 Fil_Add.Enabled := Number_Files < Max_Files;
 Fil_Del.Enabled := Number_Files > 0;
 Fil_Mod.Enabled := Number_Files > 0;
 Ico_Add.Enabled := Number_Icons < Max_Icons;
 Ico_Del.Enabled := Number_Icons > 0;
 Ico_Mod.Enabled := Number_Icons > 0;
 App_Add.Enabled := (Number_Run < Max_Run) and
                    ((Number_Files > 0) or (Number_Icons > 0));
 App_Del.Enabled := Number_Run > 0;
 App_Mod.Enabled := Number_Run > 0;
 Ini_Add.Enabled := Number_Ini < Max_IniF;
 Ini_Del.Enabled := Number_Ini > 0;
 Ini_Mod.Enabled := Number_Ini> 0;
 (* buttons *)
 btGene.Enabled := ProjectName <> '';
 btMake.Enabled := ProjectName <> '';
 btFilAdd.Enabled := Number_Files < Max_Files;
 btFilDel.Enabled := Number_Files > 0;
 btFilMod.Enabled := Number_Files > 0;
 btIcoAdd.Enabled := Number_Icons < Max_Icons;
 btIcoDel.Enabled := Number_Icons > 0;
 btIcoMod.Enabled := Number_Icons > 0;
 btAppAdd.Enabled := (Number_Run < Max_Run) and
                     ((Number_Files > 0) or (Number_Icons > 0));
 btAppDel.Enabled := Number_Run > 0;
 btAppMod.Enabled := Number_Run > 0;
 btIniAdd.Enabled := Number_Ini < Max_IniF;
 btIniDel.Enabled := Number_Ini > 0;
 btIniMod.Enabled := Number_Ini > 0;
 Application.ProcessMessages;
 (* info on screen *)
 UpdateScreen;
 Application.ProcessMessages;
end;

(* update screen *)
procedure TMainDialog.UpdateScreen;
var Bcl : integer;
begin
 (* lists *)
 ListFiles.Clear;
 if Number_Files > 0 then
  For Bcl := 1 to Number_Files do
   ListFiles.Items.Add (VFiles [Bcl].FileName);
 PNbrF.Caption := IntToStr (Number_Files);
 ListIcons.Clear;
 if Number_Icons > 0 then
  For Bcl := 1 to Number_Icons do
   ListIcons.Items.Add (VIcons [Bcl].FileName);
 ListApp.Clear;
 PNbrI.Caption := IntToStr (Number_Icons);
 if Number_Run > 0 then
  For Bcl := 1 to Number_Run do
   ListApp.Items.Add (VRun [Bcl].DocsName);
 PNbrA.Caption := IntToStr (Number_Run);
 ListIni.Clear;
 if Number_Ini > 0 then
  For Bcl := 1 to Number_Ini do
   ListIni.Items.Add (VIniF [Bcl].FileName + ',' +
                      VIniF [Bcl].INISecti + ',' +
                      VIniF [Bcl].INIField + ',' +
                      VIniF [Bcl].IniValue);
 PNbrN.Caption := IntToStr (Number_Ini);
 (* project info *)
 PTitle.text := Title;
 PSubTitle.text := SubTitle;
 PVersion.text := Version;
 PAuthor.text := Author;
 PCopyRight.text := CopyRight;
 (* sizes *)
 Disk_Number := Disk_Current DIV One_Meg;
 if Disk_Current MOD One_Meg <> 0 then Inc (Disk_Number);
 PFlop.Caption := IntToStr (Disk_Number);
 PSrcSize.Caption := IntToStr (Disk_Current);
 PTrgSize.Caption := IntToStr (Disk_Space);
end;


(******************)
(* Initialisation *)
(******************)

(* init dialog *)
procedure TMainDialog.Initialisation(Sender: TObject);
begin
 Caption := Prg_Title + ' v' + Prg_Versi + ' (Untitled)';
 Width := 640;
 Height := 480;
 Refresh;
 InitAll;
 MainInit;
 CheckMenu (Sender);
end;

(* init all screen componenet *)
procedure TMainDialog.MainInit;
begin
 History.Clear;
 ListFiles.Clear;
 ListIcons.Clear;
 ListApp.Clear;
 PTitle.Text := '';
 PSubTitle.Text := '';
 PVersion.Text := '';
 PCopyRight.text := '';
 PAuthor.text := '';
 PFlop.Caption := '0';
 PSrcSize.Caption := '0';
 PTrgSize.Caption := '0';
 PNbrF.Caption := '0';
 PNbrI.Caption := '0';
 PNbrA.Caption := '0';
 MakeHistory (Prg_Title + ' v' + Prg_Versi);
 MakeHistory ('(c)' + Prg_Year + ' by ' + Prg_Autho);
 MakeHistory ('');
end;

(* init all variables *)
procedure TMainDialog.InitAll;
var Bcl : integer;
begin
 (* project *)
 ProjectName := '';
 Title     := '';
 SubTitle  := '';
 Version   := '';
 Author    := '';
 CopyRight := '';
 Disk_Number := 0;
 Disk_Space  := 0;
 Disk_Current := 0;
 Modification := false;
 Opt_Pck.Checked := false;
 (* targetdirectory *)
 Number_Direc := 0;
 for Bcl := 1 to Max_Path do
 begin
  with VPath [Bcl] do
  begin
   LettDriv := '';
   PathDriv := '';
  end;
 end;
 (* Group *)
 Number_Group := 0;
 For Bcl := 1 to Max_Group do
 begin
  With VGroup [Bcl] do
  begin
   GroupName := '';
   GroupFile := '';
  end;
 end;
 (* files *)
 Number_Files := 0;
 for Bcl := 1 to Max_Files do
 begin
  With VFiles [Bcl] do
  begin
   DiskNumb := 0;
   OrigName := '';
   FileDriv := '';
   FilePath := '';
   FileName := '';
   Compress := 0;
   CopyFile := 1;
   SizeNorm := 0;
   SizeComp := 0;
   PackFile := 0;
  end;
 end;
 (* icons *)
 Number_Icons := 0;
 for Bcl := 1 to Max_Icons do
 begin
  With VIcons [Bcl] do
  begin
   DiskNumb := 0;
   OrigName := '';
   FileDriv := '';
   FilePath := '';
   FileName := '';
   Compress := 0;
   SizeNorm := 0;
   SizeComp := 0;
   IconName := '';
   GroupNum := 1;
   PackFile := 0;
  end;
 end;
 (* document *)
 Number_Run := 0;
 for Bcl := 1 to Max_Run do
 begin
  With VRun [Bcl] do
  begin
   FilePath := '';
   FileName := '';
   DocsDriv := '';
   DocsPath := '';
   DocsName := '';
   PackFile := 0;
  end;
 end;
 (* Ini Files *)
 Number_Ini := 0;
 For Bcl := 1 to Max_IniF do
 begin
  With VIniF [Bcl] do
  begin
   FileName := '';
   FilePath := '';
   INISecti := '';
   INIField := '';
   INIValue := '';
  end;
 end;
 (* packet file *)
 Number_Pack := 0;
 for Bcl := 1 to Max_Pack do
  VPack [Bcl].Libelle := '';
end;

(* get all screen info *)
procedure TMainDialog.GetScreenInfo;
begin
 Title := PTitle.Text;
 SubTitle := PSubTitle.Text;
 Version := PVersion.Text;
 Author := PAuthor.Text;
 CopyRight := PCopyRight.Text;
end;

(* store a new file,icon,app *)
procedure TMainDialog.StoreFile (Name : string;Number : integer;Tipe : byte);
var Tmp : integer;
    Tm1 : integer;
begin
 Tmp := FileInfo (Name);
 if Tmp = 0 then
 begin
  case Tipe of
   Typ_Fil : (* a file     *)
             begin
              Tm1 := SetPath (VFileI.Driv + ':' + VFileI.Path);
              with VFiles [Number] do
              begin
               DiskNumb := 0;
               OrigPath := '%' + IntToStr (Tm1);
               OrigName := VFileI.ONam;
               FileDriv := VFileI.Driv + ':';
               FilePath := '%' + IntToStr (Tm1);
               Compress := VFileI.FlgC;
               CopyFile := 1;
               FileName := VFileI.Fich.Name;
               SizeNorm := VFileI.Fich.Size;
               SizeComp := VFileI.Comp.Size;
              end;
             end;
   Typ_Ico : (* an icon    *)
             begin
              Tm1 := SetPath (VFileI.Driv + ':' + VFileI.Path);
              with VIcons [Number] do
              begin
               DiskNumb := 0;
               OrigPath := '%' + IntToStr (Tm1);
               OrigName := VFileI.ONam;
               FileDriv := VFileI.Driv + ':';
               FilePath := '%' + IntToStr (Tm1);
               Compress := VFileI.FlgC;
               FileName := VFileI.Fich.Name;
               SizeNorm := VFileI.Fich.Size;
               SizeComp := VFileI.Comp.Size;
               IconName := Name;
               GroupNum := 1;
              end;
             end;
  end;
 end;
end;

(* looking for a % directory *)
function TMainDialog.LookDir (Path : string) : string;
var Tmp : integer;
    Tm1 : string;
    Bcl : integer;
    tm2 : string;
begin
 Tmp := 0;
 if Number_Direc > 0 then
 begin
  for Bcl := 1 to Number_Direc do
  begin
   if Path = VPath [Bcl].LettDriv +
             VPath [Bcl].PathDriv then
    Tmp := Bcl;
  end;
 end;
 if Tmp = 0 then
 begin
  Tm1 := Path;
  System.Delete (Tm1,1,pos (':',Tm1));
 end
 else
 begin
  Str (Tmp:1,Tm1);
  Tm1 := '%' + Tm1;
 end;
 tm2 := lowercase (WinDir); if path = tm2 then tm1 := '%W';
 tm2 := lowercase (SysDir); if path = tm2 then tm1 := '%S';
 LookDir := Tm1;
end;

(* add a line to history *)
procedure TMainDialog.MakeHistory (Line : string);
begin
 History.Lines.Add (Line);
end;

procedure TMainDialog.HistClearbtClick(Sender: TObject);
begin
 History.Clear;
end;

(* keep size : don't move *)
procedure TMainDialog.FormResize(Sender: TObject);
begin
 Width := 640;
 Height := 480;
end;

(* modification on Edit zones *)
procedure TMainDialog.ChangeModif(Sender: TObject);
begin
 Modification := True;
 GetScreenInfo;
 CheckMenu (Sender);
end;

(******************)
(* Input / Output *)
(******************)

(* save current project *)
procedure TMainDialog.SaveProject;
var Fch : System.Text;
    Bcl : integer;
begin
 GetScreenInfo;
 System.Assign (Fch,ProjectName);
 {$I-}; Rewrite (Fch); {$I+};
 if ioresult <> 0 then
  MessageDlg ('Unable to save project',mtError,[mbok],0)
 else
 begin
  (* project *)
  Writeln (Fch,Title);
  Writeln (Fch,SubTitle);
  Writeln (Fch,Version);
  Writeln (Fch,CopyRight);
  Writeln (Fch,Author);
  (* Group *)
  Writeln (Fch,Number_Group);
  if Number_Group > 0 then
  begin
   for Bcl := 1 to Number_Group do
   begin
    with VGroup [Bcl] do
    begin
     Writeln (Fch,GroupName);
     Writeln (Fch,GroupFile);
    end;
   end;
  end;
  (* directories *)
  Writeln (Fch,Number_Direc);
  if Number_Direc > 0 then
  begin
   for Bcl := 1 to Number_Direc do
   begin
    with VPath [Bcl] do
    begin
     Writeln (Fch,LettDriv);
     Writeln (Fch,PathDriv);
    end;
   end;
  end;
  Writeln (Fch,VPath [Max_Path].LettDriv);
  Writeln (Fch,VPath [Max_Path].PathDriv);
  (* packet files *)
  Writeln (Fch,Number_Pack);
  if Number_Pack > 0 then
  begin
   for Bcl := 1 to Number_Pack do
    Writeln (Fch,VPack [Bcl].Libelle);
  end;
  (* files *)
  Writeln (Fch,Number_Files);
  if Number_Files > 0 then
  begin
   For Bcl := 1 to Number_Files do
   begin
    With VFiles [Bcl] do
    begin
     Writeln (Fch,DiskNumb);
     Writeln (Fch,OrigPath);
     Writeln (Fch,OrigName);
     Writeln (Fch,FileDriv);
     Writeln (Fch,FileName);
     Writeln (Fch,FilePath);
     Writeln (Fch,Compress);
     Writeln (Fch,CopyFile);
     Writeln (Fch,SizeNorm);
     Writeln (Fch,SizeComp);
     Writeln (Fch,PackFile);
    end;
   end;
  end;
  (* icons *)
  Writeln (Fch,Number_Icons);
  if Number_Icons > 0 then
  begin
   For Bcl := 1 to Number_Icons do
   begin
    With VIcons [Bcl] do
    begin
     Writeln (Fch,DiskNumb);
     Writeln (Fch,OrigPath);
     Writeln (Fch,OrigName);
     Writeln (Fch,FileDriv);
     Writeln (Fch,FileName);
     Writeln (Fch,FilePath);
     Writeln (Fch,Compress);
     Writeln (Fch,SizeNorm);
     Writeln (Fch,SizeComp);
     Writeln (Fch,IconName);
     Writeln (Fch,GroupNum);
     Writeln (Fch,PackFile);
    end;
   end;
  end;
  (* documents *)
  Writeln (Fch,Number_Run);
  if Number_Run > 0 then
  begin
   For Bcl := 1 to Number_Run do
   begin
    With VRun [Bcl] do
    begin
     Writeln (Fch,FileName);
     Writeln (Fch,FilePath);
     Writeln (Fch,DocsDriv);
     Writeln (Fch,DocsName);
     Writeln (Fch,DocsPath);
     Writeln (Fch,PackFile);
    end;
   end;
  end;
  (* ini files *)
  Writeln (Fch,Number_Ini);
  if Number_Ini > 0 then
  begin
   for Bcl := 1 to Number_Ini do
   begin
    With VIniF [Bcl] do
    begin
     Writeln (Fch,FileName);
     Writeln (Fch,FilePath);
     Writeln (Fch,INISecti);
     writeln (Fch,INIField);
     writeln (Fch,INIValue);
    end;
   end;
  end;
  (* options *)
  Writeln (Fch,Disk_Number);
  Writeln (Fch,Disk_Space);
  Writeln (Fch,Disk_Current);
  if Opt_Pck.Checked = true then Writeln (Fch,1)
                            else Writeln (Fch,0);
  System.Close (Fch);
 end;
end;

(* load an existing project *)
procedure TMainDialog.LoadProject;
var Fch : System.Text;
    Bcl : integer;
    Tmp : integer;
begin
 System.Assign (Fch,ProjectName);
 {$I-}; Reset (Fch); {$I+};
 if ioresult <> 0 then
  MessageDlg ('Unable to load project',mtError,[mbok],0)
 else
 begin
  (* project *)
  Readln (Fch,Title);
  Readln (Fch,SubTitle);
  Readln (Fch,Version);
  Readln (Fch,CopyRight);
  Readln (Fch,Author);
  (* Group *)
  Readln (Fch,Number_Group);
  if Number_Group > 0 then
  begin
   for Bcl := 1 to Number_Group do
   begin
    with VGroup [Bcl] do
    begin
     Readln (Fch,GroupName);
     Readln (Fch,GroupFile);
    end;
   end;
  end;
  (* directories *)
  Readln (Fch,Number_Direc);
  if Number_Direc > 0 then
  begin
   for Bcl := 1 to Number_Direc do
   begin
    with VPath [Bcl] do
    begin
     Readln (Fch,LettDriv);
     Readln (Fch,PathDriv);
    end;
   end;
  end;
  Readln (Fch,VPath [Max_Path].LettDriv);
  Readln (Fch,VPath [Max_Path].PathDriv);
  (* packet files *)
  Readln (Fch,Number_Pack);
  if Number_Pack > 0 then
  begin
   for Bcl := 1 to Number_Pack do
    Readln (Fch,VPack [Bcl].Libelle);
  end;
  (* files *)
  Readln (Fch,Number_Files);
  if Number_Files > 0 then
  begin
   For Bcl := 1 to Number_Files do
   begin
    With VFiles [Bcl] do
    begin
     Readln (Fch,DiskNumb);
     Readln (Fch,OrigPath);
     Readln (Fch,OrigName);
     Readln (Fch,FileDriv);
     Readln (Fch,FileName);
     Readln (Fch,FilePath);
     Readln (Fch,Compress);
     Readln (Fch,CopyFile);
     Readln (Fch,SizeNorm);
     Readln (Fch,SizeComp);
     Readln (Fch,PackFile);
    end;
   end;
  end;
  (* icons *)
  Readln (Fch,Number_Icons);
  if Number_Icons > 0 then
  begin
   For Bcl := 1 to Number_Icons do
   begin
    With VIcons [Bcl] do
    begin
     Readln (Fch,DiskNumb);
     Readln (Fch,OrigPath);
     Readln (Fch,OrigName);
     Readln (Fch,FileDriv);
     Readln (Fch,FileName);
     Readln (Fch,FilePath);
     Readln (Fch,Compress);
     Readln (Fch,SizeNorm);
     Readln (Fch,SizeComp);
     Readln (Fch,IconName);
     Readln (Fch,GroupNum);
     Readln (Fch,PackFile);
    end;
   end;
  end;
  (* documents *)
  Readln (Fch,Number_Run);
  if Number_Run > 0 then
  begin
   For Bcl := 1 to Number_Run do
   begin
    With VRun [Bcl] do
    begin
     Readln (Fch,FileName);
     Readln (Fch,FilePath);
     Readln (Fch,DocsDriv);
     Readln (Fch,DocsName);
     Readln (Fch,DocsPath);
     Readln (Fch,PackFile);
    end;
   end;
  end;
  (* ini files *)
  Readln (Fch,Number_Ini);
  if Number_Ini > 0 then
  begin
   for Bcl := 1 to Number_Ini do
   begin
    With VIniF [Bcl] do
    begin
     Readln (Fch,FileName);
     Readln (Fch,FilePath);
     Readln (Fch,INISecti);
     Readln (Fch,INIField);
     Readln (Fch,INIValue);
    end;
   end;
  end;
  (* options *)
  Readln (Fch,Disk_Number);
  Readln (Fch,Disk_Space);
  Readln (Fch,Disk_Current);
  Readln (Fch,Tmp);
  if Tmp = 1 then Opt_Pck.Checked := true
             else Opt_Pck.Checked := false;
  System.Close (Fch);
 end;
end;

(* generate setup.ins file *)
procedure TMainDialog.GenerateProject;
var Fch : System.Text;

 function Wr (Line : string) : integer;
 var Tmp : integer;
 begin
  Tmp := 0;
  {$I-}; writeln (Fch,Line); {$I+};
  if ioresult <> 0 then
  begin
   MessageDlg ('Unabled to write into Setup.ins file',
               mtError,[mbok],0);
   Tmp := 1;
  end;
  Wr := Tmp;
 end;

var Bcl : integer;
    Tmp : integer;
    Pat : string;
    Fil : string;
    Cur : integer;
    Max : longint;
    Siz : longint;
begin
 Siz := 0; Max := One_Meg - 20480; Cur := 1;
 pat := ProjectName;
 fil := projectName;
 while pos ('\',Fil) <> 0 do System.delete (Fil,1,pos ('\',Fil));
 System.delete (pat,pos (fil,pat),length (fil));
 System.Assign (Fch,Pat + Fch_Ins + 'INS');
 {$I-}; Rewrite (Fch); {$I+};
 if ioresult <> 0 then
  MessageDlg ('Unable to create "' + Fch_Ins + 'Ins" file',mtError,[mbok],0)
 else
 begin
  (* header *)
  Wr ('');
  Wr ('; Setup script file by Create for Setup');
  Wr ('; (c)1996 by J. BERTRAND and L. TANNER');
  (* information *)
  Wr ('');
  Wr ('[INFORMATION]');
  Wr ('TITLE=' + Title);
  Wr ('SUBTITLE=' + SubTitle);
  Wr ('VERSION=' + Version);
  Wr ('AUTHOR=' + Author);
  Wr ('COPYRIGHT=' + CopyRight);
  (* Disks *)
  Wr ('');
  Wr ('[DISKS]');
  Wr ('DSK=' + inttostr (Disk_Number));
  Wr ('SPC=' + inttostr (Disk_Space));
  (* origin *)
  Wr ('');
  Wr ('[ORIGIN]');
  Wr ('ODSK=' + uppercase (VPath [Max_Path].LettDriv));
  Wr ('OPAT=' + uppercase (VPath [Max_Path].PathDriv));
  (* destination *)
  Wr ('');
  Wr ('[DESTINATION]');
  Wr ('NUM=' + inttostr (Number_Direc));
  if Number_Direc > 0 then
  begin
   for Bcl := 1 to Number_Direc do
   begin
    With VPath [Bcl] do
    begin
     Wr ('DDSK=' + uppercase (LettDriv));
     Wr ('DPAT=' + uppercase (PathDriv));
    end;
   end;
  end;
  (* packet files *)
  Wr ('');
  wr ('[PACKET FILES]');
  Wr ('NUM=' + IntToStr (Number_Pack));
  if Number_Pack > 0 then
  begin
   For Bcl := 1 to Number_Pack do
   begin
    with VPack [Bcl] do
    begin
     Wr (IntToStr (Bcl) + '=' +
         Libelle);
    end;
   end;
  end;
  (* group *)
  Wr ('');
  Wr ('[GROUP]');
  Wr ('NUM=' + IntToStr (Number_Group));
  if Number_Group > 0 then
  begin
   for Bcl := 1 to Number_Group do
   begin
    with VGroup [Bcl] do
    begin
     wr (IntToStr (Bcl) + '=' +
         GroupName + ',' +
         uppercase (GroupFile) + '.GRP');
    end;
   end;
  end;
  (* icons *)
  Wr ('');
  Wr ('[ICONS]');
  Wr ('NUM=' + inttostr (Number_Icons));
  if Number_Icons > 0 then
  begin
   for Bcl := 1 to Number_Icons do
   begin
    With VIcons [Bcl] do
    begin
     Inc (Siz,SizeNorm);
     if Siz > Max then
     begin
      Siz := SizeNorm;
      Inc (Cur);
     end;
     DiskNumb := Cur;
     Wr (IntToStr (Bcl) + '=' +
         IntToStr (Cur) + ',' +
         uppercase (FileName) + ',' +
         uppercase (FilePath) + ',' +
         IconName + ',' +
         IntToStr (GroupNum) + ',' +
         IntToStr (PackFile));
    end;
   end;
  end;
  (* files *)
  Wr ('');
  Wr ('[FILES]');
  Tmp := 0;
  if Number_Files > 0 then
   for Bcl := 1 to Number_Files do
    if VFiles [Bcl].CopyFile = 1 then Inc (Tmp);
  Wr ('NUM=' + inttostr (Tmp));
  if Number_Files > 0 then
  begin
   Tmp := 0;
   for Bcl := 1 to Number_Files do
   begin
    With VFiles [Bcl] do
    begin
     Inc (Siz,SizeNorm);
     if Siz > Max then
     begin
      Siz := SizeNorm;
      Inc (Cur);
     end;
     DiskNumb := Cur;
     if CopyFile = 1 then
     begin
      Inc (Tmp);
      Wr (IntToStr (Tmp) + '=' +
          IntToStr (Cur) + ',' +
          uppercase (FileName) + ',' +
          uppercase (FilePath) + ',' +
          IntToStr (PackFile));
     end;
    end;
   end;
  end;
  (* run *)
  Wr ('');
  Wr ('[RUN]');
  Wr ('NUM=' + inttostr (Number_Run));
  if Number_Run > 0 then
  begin
   for Bcl := 1 to Number_Run do
   begin
    With VRun [Bcl] do
    begin
     Wr (IntToStr (Bcl) + '=' +
         uppercase(FileName) + ',' +
         uppercase(FilePath) + ',' +
         uppercase(DocsName) + ',' +
         uppercase(DocsPath) + ',' +
         IntToStr (PackFile));
    end;
   end;
  end;
  (* ini *)
  Wr ('');
  Wr ('[INI]');
  wr ('NUM=' + inttostr (Number_Ini));
  if Number_Ini > 0 then
  begin
   for Bcl := 1 to Number_Ini do
   begin
    With VIniF [Bcl] do
    begin
     Wr (IntToStr (Bcl) + '=' +
         uppercase(FileName) + ',' +
         uppercase(FilePath) + ',' +
         INISecti + ',' +
         INIField + ',' +
         INIValue);
    end;
   end;
  end;
  (* footer *)
  Wr ('');
  Wr ('; End of Setup.ins file');
  Wr ('');
  System.Close (Fch);
 end;
 if Opt_Pck.Checked = true then PackingLstFile;
end;

(********************)
(* packing lst file *)
(********************)
procedure TMainDialog.PackingLstFile;
var Fch : System.Text;
    Bcl : integer;
    Tmp : byte;
    Err : integer;
    Tm1 : string;
    ico : string [30];
    nam : string [12];
    dsk : string [06];
begin
 MakeHistory ('Generating PACKING.LST file');
 System.Assign (Fch,'PACKING.LST');
 {$I-}; System.Rewrite (Fch); {$I+};
 if ioresult = 0 then
 begin
  (* header *)
  Writeln (Fch,'');
  Writeln (Fch,'Packing file of ' + Title);
  Writeln (Fch,'');
  Writeln (Fch,Title + ' v ' + Version);
  Writeln (Fch,SubTitle);
  Writeln (Fch,'(c)' + CopyRight + ' by ' + Author);
  Writeln (Fch,'');
  Writeln (Fch,'');
  Writeln (Fch,IntToStr (Number_Icons),' Icons');
  (* informations *)
  If Number_Icons > 0 then
  begin
   Writeln (Fch,'');
   Writeln (Fch,'Disk #':6,' ',
                'Icon name           ':30,' ',
                'File name  ':12,' ',
                'Destination file path');
   For Bcl := 1 to Number_Icons do
   begin
    With VIcons [Bcl] do
    begin
     case FilePath [2] of
      'W' : Tm1 := WinDir;
      'S' : Tm1 := SysDir;
      'R' : Tm1 := VPath [2].LettDriv + '\';
      else
      begin
       val (copy (FilePath,2,2),Tmp,Err);
       Tm1 := VPath [Tmp].PathDriv;
      end;
     end;
     (* disk id *)
     Dsk := IntToStr (DiskNumb);
     Tmp := (6 - length (dsk)) DIV 2;
     for Err := 1 to Tmp do Dsk := ' ' + Dsk + ' ';
     (* icon name *)
     Ico := IconName;
     Tmp := (30 - length (ico)) DIV 2;
     For Err := 1 to Tmp do Ico := ' ' + Ico + ' ';
     (* file name *)
     Nam := FileName;
     While length (Nam) <> 12 do Insert (' ',Nam,pos ('.',Nam));
     WriteLn (Fch,Dsk:6,' ',Ico:30,' ',Nam:12,' ',Tm1);
    end;
   end;
  end;
  Writeln (Fch,'');
  Writeln (Fch,IntToStr (Number_Files),' Files');
  if Number_Files > 0 then
  begin
   Writeln (Fch,'');
   Writeln (Fch,'Disk #':6,' ',
                'File name  ':12,' ',
                'Destination file path');
   for Bcl := 1 to Number_Files do
   begin
    With VFiles [Bcl] do
    begin
     case FilePath [2] of
      'W' : Tm1 := WinDir;
      'S' : Tm1 := SysDir;
      'R' : Tm1 := VPath [2].LettDriv + '\';
      else
      begin
       val (copy (FilePath,2,2),Tmp,Err);
       Tm1 := VPath [Tmp].PathDriv;
      end;
     end;
     (* disk id *)
     Dsk := IntToStr (DiskNumb);
     Tmp := Round ((6 - length (dsk)) / 2);
     for Err := 1 to Tmp do Dsk := ' ' + Dsk + ' ';
     (* file name *)
     Nam := FileName;
     While length (Nam) <> 12 do Insert (' ',Nam,pos ('.',Nam));
     WriteLn (Fch,Dsk:6,' ',Nam:12,' ',Tm1);
    end;
   end;
  end;
  System.Close (Fch);
 end;
end;

(*************************)
(* functions around path *)
(*************************)

(* determine compressed file *)
function TMainDialog.IsCompressed (sFile : string) : boolean;
var bReturn      : boolean;
    pFileName     : Array [0..256] of Char;
    pInternalName : Array [0..256] of Char;
    iTmp          : integer;
begin
 bReturn := false;
 if FileExists (sFile) then
 begin
  StrPCopy (pFileName,sFile);
  iTmp := GetExpandedName (pFileName,pInternalName);
  if iTmp < 0 then
   bReturn := false
  else
  begin
   if (StrEnd (pInternalName) - pInternalName) > 0 then
    if ExtractFileName (sFile) = ExtractFileName (StrPas (pInternalName)) then
     bReturn := false
    else
     bReturn := true;
  end;
 end;
 IsCompressed := bReturn;
end;

(*********************)
(* make all floppies *)
(*********************)

(* create disk ID *)
function TMainDialog.MakeNewDisk (Number : byte) : integer;
var Tmp : string;
    Nam : string;
    Pat : string;
    Ret : integer;
    Fch : system.Text;
    Cur : hCursor;
begin
 Cur := Screen.Cursor;
 Screen.Cursor := crDefault;
 Ret := 0;
 if messagedlg ('Please insert a new formatted floppy into drive ' +
                VPath [Max_Path].LettDriv,
                mtConfirmation,[mbok,mbCancel],0) = mrOk then
 begin
  Tmp := IntToStr (Number);
  while length (Tmp) < 3 do Tmp := '0' + Tmp;
  nam := 'DISK.' + Tmp;
  pat := VPath [Max_Path].LettDriv + VPath [Max_Path].PathDriv;
  if pat [length (pat)] <> '\' then pat := pat + '\';
  system.Assign (fch,pat + nam);
  {$I-}; system.rewrite (fch); {$I+};
  if ioresult = 0 then
  begin
   writeln (Fch,Prg_Title + ' v ' + Prg_Versi);
   system.close (fch);
  end
  else
   Ret := 6;
 end
 else
  Ret := 7;
 Screen.Cursor := Cur;
 MakeNewDisk := Ret;
end;

(* copy files and icons *)
function TMainDialog.MakeFloppies : integer;
var Bcl : integer;
    FrF : string;
    ToF : string;
    Cur : byte;
    Siz : longint;
    Err : integer;
    Tm1 : integer;
    Ero : integer;
begin
 Screen.Cursor := crHourGlass;
 (* A:\ for source by default *)
 if VPath [max_Path].LettDriv = '' then VPath [Max_Path].LettDriv := 'A:';
 if VPath [max_path].PathDriv = '' then VPath [Max_Path].PathDriv := '\';
 Cur := 0; Siz := One_Meg + 1; Err := 0;
 (* copy files *)
 if Err = 0 then
 begin
  for Bcl := 1 to Number_Files do
  begin
   With VFiles [Bcl] do
   begin
    if err = 0 then
    begin
     if (Siz + SizeNorm) > One_Meg then
     begin
      Siz := SizeNorm;
      Inc (Cur);
      Err := MakeNewDisk (Cur);
     end
     else
      Inc (Siz,SizeNorm);
     (* source *)
     if Err = 0 then
     begin
      Val (copy (OrigPath,2,2),Tm1,Ero);
      if Ero = 0 then
      begin
       FrF := VPath [Tm1].LettDriv + VPath [Tm1].PathDriv;
       if FrF [length (FrF)] <> '\' then FrF := FrF + '\';
       FrF := FrF + FileName;
       (* destination *)
       ToF := VPath [Max_Path].LettDriv + VPath [Max_Path].PathDriv;
       if ToF [length (ToF)] <> '\' then ToF := ToF + '\';
       ToF := ToF + FileName;
       (* copy *)
       Screen.Cursor := crDefault;
       if MessageDlg ('Copy file ' + uppercase (FrF) + #10 +
                      'To ' + uppercase (ToF),
                      mtconfirmation,[mbok,mbCancel],0) = mrOk then
       begin
        Screen.Cursor := crHourGlass;
        Err := HardCopyFile (FrF,ToF,1);
       end
       else
        Err := 7;
       Screen.Cursor := crHourGlass;
      end
      else
       Err := 8;
     end;
    end;
   end;
  end;
 end;
 (* copy icons *)
 if Err = 0 then
 begin
  for Bcl := 1 to Number_Icons do
  begin
   With VIcons [Bcl] do
   begin
    if err = 0 then
    begin
     if (Siz + SizeNorm) > One_Meg then
     begin
      Siz := SizeNorm;
      Inc (Cur);
      Err := MakeNewDisk (Cur);
     end
     else
      Inc (Siz,SizeNorm);
     (* source *)
     if Err = 0 then
     begin
      Val (copy (OrigPath,2,2),Tm1,Ero);
      if Ero = 0 then
      begin
       FrF := VPath [Tm1].LettDriv + VPath [Tm1].PathDriv;
       if FrF [length (FrF)] <> '\' then FrF := FrF + '\';
       FrF := FrF + FileName;
       (* destination *)
       ToF := VPath [Max_Path].LettDriv + VPath [Max_Path].PathDriv;
       if ToF [length (ToF)] <> '\' then ToF := ToF + '\';
       ToF := ToF + FileName;
       (* copy *)
       Screen.Cursor := crDefault;
       if MessageDlg ('Copy icon ' + uppercase (FrF) + #10 +
                      'To ' + uppercase (ToF),
                      mtconfirmation,[mbok,mbCancel],0) = mrOk then
       begin
        Screen.Cursor := crHourGlass;
        Err := HardCopyFile (FrF,ToF,1);
       end
       else
        Err := 7;
       Screen.Cursor := crHourGlass;
      end
      else
       Err := 8;
     end;
    end;
   end;
  end;
 end;
 Screen.Cursor := crDefault;
 MakeFloppies := Err;
end;

end.
