unit Filmod;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
     StdCtrls, ExtCtrls,SysUtils,Dialogs;

type
  TFileModDialog = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    DNameFile: TEdit;
    DCompFile: TCheckBox;
    Label3: TLabel;
    Label4: TLabel;
    DSizeSour: TEdit;
    DSizeTarg: TEdit;
    DCopyFile: TCheckBox;
    Bevel2: TBevel;
    Bevel3: TBevel;
    DFilePath: TEdit;
    Liste: TListBox;
    Label5: TLabel;
    Label6: TLabel;
    DDrivFile: TEdit;
    PackList: TListBox;
    Label7: TLabel;
    AssoBtn: TButton;
    procedure Initialise(Sender: TObject);
    procedure KeepIt(Sender: TObject);
    procedure ChangeDir(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure ChangeCop(Sender: TObject);
    procedure AssoBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FileModDialog: TFileModDialog;

implementation

uses Decla,Disque;

{$R *.DFM}

(* init dialog *)
procedure TFileModDialog.Initialise(Sender: TObject);
var Bcl : integer;
    Num : integer;
    Err : integer;
begin
 Label2.Enabled := true;
 DNameFile.Enabled := true;
 DCompFile.Enabled := true;
 Label3.Enabled := true;
 Label5.enabled := true;
 DSizeSour.Enabled := true;
 Label4.Enabled := true;
 Label6.enabled := true;
 DSizeTarg.Enabled := true;
 (* init *)
 PackList .Clear;
 if Number_Pack > 0 then
 begin
  for Bcl := 1 to Number_Pack do
   PackList.Items.Add (VPack [Bcl].Libelle);
 end;
 Liste.Clear;
 Liste.Items.Add ('Other');
 Liste.Items.Add (copy (WinDir,3,length (Windir) - 2));
 Liste.Items.Add (copy (SysDir,3,length (Sysdir) - 2));
 if Number_Direc > 0 then
 begin
  for Bcl := 1 to Number_Direc do
   Liste.Items.Add (VPath [Bcl].PathDriv);
 end;
 if VTrans.Positi = 0 then
 (* one file *)
 begin
  with VFiles [VTrans.Number] do
  begin
   (* name *)
   DNameFile.Text := FileName;
   (* drive *)
   DDrivFile.Text := FileDriv [1];
   (* path *)
   if FilePath [1] = '%' then
   begin
    if FilePath [2] = 'W' then
    begin
     Liste.ItemIndex := 1;
     DFilePath.Text := copy (Windir,3,length (Windir) - 2);
    end
    else
    begin
     if FilePath [2] = 'S' then
     begin
      Liste.ItemIndex := 2;
      DFilePath.Text := copy (Sysdir,3,length (Windir) - 2);
     end
     else
     begin
      Val (copy (FilePath,2,2),Num,Err);
      if Err = 0 then
      begin
       DFilePath.Text := VPath [Num].PathDriv;
       Liste.ItemIndex := Num + 2;
      end
      else
      begin
       DFilePath.Text := FilePath;
       Liste.ItemIndex := 0;
      end;
     end;
    end;
   end
   else
   begin
    DFilePath.Text := FilePath;
    Liste.ItemIndex := 0;
   end;
   (* packet file *)
   PackList.ItemIndex := VFiles [VTrans.Number].PackFile - 1;
   (* sizes *)
   if CopyFile = 1 then
   begin
    DSizeSour.Text := IntToStr (SizeNorm);
    if Compress = 1 then DSizeTarg.Text := IntToStr (SizeComp)
                    else DSizeTarg.Text := IntToStr (SizeNorm);
   end
   else
   begin
    DSizeSour.Text := IntToStr (SizeNorm);
    DSizeTarg.Text := '0';
   end;
   (* compress *)
   if Compress = 1 then DCompFile.State := cbChecked
                   else DCompFile.State := cbUnChecked;
   (* copy *)
   if CopyFile = 1 then DCopyFile.State := cbChecked
                   else DCopyFile.State := cbUnChecked;
  end;
 end
 else
 (* multiple files *)
 begin
  Label2.Enabled := false;
  DNameFile.Enabled := false;
  DCompFile.Enabled := false;
  Label3.Enabled := false;
  Label5.enabled := false;
  DSizeSour.Enabled := false;
  Label4.Enabled := false;
  Label6.enabled := false;
  DSizeTarg.Enabled := false;
  (* name *)
  DNameFile.Text := '';
  (* drive *)
  DDrivFile.Text := VPath [1].LettDriv [1];
  (* path *)
  DFilePath.Text := VPath [1].PathDriv [1];
  (* packet file *)
  PackList.ItemIndex := -1;
  (* sizes *)
  DSizeSour.Text := '';
  DSizeTarg.Text := '';
  (* compress *)
  DCompFile.State := cbGrayed;
  (* copy *)
  DCopyFile.State := cbChecked;
 end;
end;

(* do not modify this flag *)
procedure TFileModDialog.KeepIt(Sender: TObject);
begin
 if VTrans.Positi = 0 then
 begin
  With VFiles [VTrans.Number] do
  begin
   if Compress = 1 then DCompFile.State := cbChecked
                   else DCompFile.State := cbUnChecked;
  end;
 end
 else
  DCompFile.State := cbGrayed;
end;

(* synchronize listbox and editzone*)
procedure TFileModDialog.ChangeDir(Sender: TObject);
begin
 if VTrans.Positi = 0 then
 begin
  if Liste.ItemIndex > 2 then
   DFilePath.Text := VPath [Liste.ItemIndex - 2].PathDriv
  else
  begin
   case Liste.ItemIndex of
    0 : DFilePath.Text := VFiles [VTrans.Number].FilePath;
    1 : DFilePath.Text := copy (WinDir,3,length (Windir) - 2);
    2 : DFilePath.Text := copy (SysDir,3,length (Sysdir) - 2);
   end;
  end;
 end
 else
 begin
  if Liste.ItemIndex > 2 then
   DFilePath.Text := VPath [Liste.ItemIndex - 2].PathDriv
  else
  begin
   case Liste.ItemIndex of
    0 : DFilePath.Text := '';
    1 : DFilePath.Text := copy (WinDir,3,length (Windir) - 2);
    2 : DFilePath.Text := copy (SysDir,3,length (Sysdir) - 2);
   end;
  end;
 end;
end;

(* Ok button *)
procedure TFileModDialog.OKBtnClick(Sender: TObject);
var Tm1 : integer;
    Tmp : string;
begin
 if VTrans.Positi = 0 then
 begin
  With VFiles [VTrans.Number] do
  begin
   PackFile := PackList.ItemIndex + 1;
   case Liste.ItemIndex of
    0 : begin
         Tmp := DFilePath.Text;
         if Tmp [1] <> '%' then
          if Tmp [1] <> '\' then Tmp := '\' + Tmp;
         if pos ('%',Tmp) = 0 then
         begin
          Tm1 := SetPath (DDrivFile.Text [1] + ':' + Tmp);
          FilePath := '%' + IntToStr (Tm1);
         end
         else
          FilePath := Tmp;
        end;
    1 : FilePath := '%W';
    2 : FilePath := '%S';
    else
    begin
     Str ((Liste.ItemIndex - 2):1,FilePath);
     FilePath := '%' + FilePath;
    end;
   end;
   if DCopyFile.State = cbChecked then
    CopyFile := 1
   else
   begin
    CopyFile := 0;
    FilePath := '';
   end;
  end;
 end
 else
 (* multiple files *)
 begin
  with MultiF do
  begin
   (* packet file *)
   PackFile := PackList.ItemIndex + 1;
   (* drive *)
   FileDriv := DDrivFile.Text [1] + ':';
   (* path *)
   case Liste.ItemIndex of
    0 : begin
         Tmp := DFilePath.Text;
         if Tmp [1] <> '%' then
          if Tmp [1] <> '\' then Tmp := '\' + Tmp;
         if pos ('%',Tmp) = 0 then
         begin
          Tm1 := SetPath (DDrivFile.Text [1] + ':' + Tmp);
          FilePath := '%' + IntToStr (Tm1);
         end
         else
          FilePath := Tmp;
        end;
    1 : FilePath := '%W';
    2 : FilePath := '%S';
    else
    begin
     Str ((Liste.ItemIndex - 2):1,FilePath);
     FilePath := '%' + FilePath;
    end;
   end;
   (* copy *)
   if DCopyFile.State = cbChecked then CopyFile := 1
                                  else CopyFile := 0;
  end;
 end;
 ModalResult := mrOk;
end;

(* Changing copy *)
procedure TFileModDialog.ChangeCop(Sender: TObject);
begin
 if VTrans.Positi = 0 then
 begin
  With VFiles [VTrans.Number] do
  begin
   if DCopyFile.State = cbChecked then CopyFile := 1
                                  else CopyFile := 0;
   (* sizes *)
   if CopyFile = 1 then
   begin
    DSizeSour.Text := IntToStr (SizeNorm);
    if Compress = 1 then DSizeTarg.Text := IntToStr (SizeComp)
                    else DSizeTarg.Text := IntToStr (SizeNorm);
   end
   else
   begin
    DSizeSour.Text := IntToStr (SizeNorm);
    DSizeTarg.Text := '0';
   end;
  end;
 end
 else
 begin
  if DCopyFile.State = cbChecked then MultiF.CopyFile := 1
                                 else MultiF.CopyFile := 0;
 end;
end;

(* No association button *)
procedure TFileModDialog.AssoBtnClick(Sender: TObject);
begin
 PackList.ItemIndex := -1;
end;

end.
