UNIT W95Meter;

{This component is a Windows 95 style progress meter.  It is free
 and donated to the public domain.

 by John Newlin CIS 71535,665}

interface

uses
  WinTypes, WinProcs, Messages, SysUtils, Classes, Controls,
  Forms, Menus, Graphics, Dialogs;


Type
  StyleType = (st95None,st95Lowered,st95Raised);
  TW95Meter = class(TGraphicControl)
  private
    FPercent : Integer;
    FBackColor : TColor;
    FSegColor:Tcolor;
    FSegWidth:integer;
    FSegGap:integer;
    FEdgeStyle:StyleType;
    procedure Initialize;
    procedure SetPercent(Value : Integer);
    procedure SetBackColor(value:Tcolor);
    procedure SetSegColor(value:Tcolor);
    procedure SetSegWidth(value:Integer);
    procedure SetSegGap(value:integer);
    procedure SetStyle(value:StyleType);
  protected
    procedure UpdateProgress;
    procedure Paint; Override;
  public
    constructor Create(AOwner: TComponent); override;
    property Canvas;
    function IntPercent(High,Low : Longint) : integer;
    function RealPercent(High,Low : real) : integer;
  published
    property OnClick;
    property OnDblClick;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property EdgeStyle:StyleType read FEdgeStyle write SetStyle default st95Lowered;
    property SegmentGap:integer read FSegGap write SetSegGap default 2;
    property SegmentWidth:integer read FSegWidth write SetSegWidth default 8;
    property SegmentColor:Tcolor read FSegColor write SetSegColor default clNavy;
    property BackGroundColor:TColor read FBackColor write SetBackColor default clBtnFace;
    property Percent : Integer read FPercent write SetPercent default 0;
    property Width default 100;
    property Height default 18;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Utility', [TW95Meter]);
end;

procedure TW95Meter.SetSegWidth(value:integer);
begin
  if (value > 0) and (value <> FSegWidth) then
    begin
      FSegWidth := value;
      paint;
    end;
end;

procedure TW95Meter.SetSegGap(value:integer);
begin
  if (Value > 0) and (Value <> FSegGap) then
    begin
      FSegGap := Value;
      Paint;
    end;
end;

procedure TW95Meter.SetBackColor(value:Tcolor);
begin
  if FBackColor <> value then
    begin
      FBackColor := value;
      paint;
    end;
end;

procedure TW95Meter.SetSegColor(value:Tcolor);
begin
  if FSegColor <> Value then
    begin
      FSegColor := Value;
      Paint;
    end;
end;

procedure TW95Meter.SetPercent(Value : Integer);
begin
  if Value <> FPercent then
    begin
      FPercent := Value;
      if FPercent < 0 then FPercent := 0 else
      if FPercent > 100 then FPercent := 100;
      if (Fpercent = 0) or (csDesigning in ComponentState) then Paint;
      UPdateProgress;
    end;
end;

procedure TW95Meter.SetStyle(value:StyleType);
begin
  if value <> FEdgeStyle then
    begin
      FEdgeStyle := value;
      Paint;
    end;
end;

procedure TW95Meter.Initialize;
begin
  Width := 100;
  Height := 18;
  FPercent := 0;
  FBackColor := clBtnFace;
  FSegColor := clNavy;
  FSegWidth := 8;
  FSegGap := 2;
  FEdgeStyle := st95Lowered;
end;

constructor TW95Meter.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Initialize;
end;

procedure TW95Meter.UpdateProgress;
var
  x1,y1,x2,y2,max : integer;
  bg : Tcolor;

procedure DoHorizontal;
var
  i : integer;
begin
  x1 := 4;
  x2 := x1+FSegWidth;
  y1 := 4;
  y2 := Height-4;
  max := Width div (FSegWidth+FSegGap);
  Max := round(max * (FPerCent / 100));
  for i := 1 to Max do with canvas do
    begin
      if x2 <= width - 4 then Rectangle(x1,y1,x2,y2);
      x1 := x1+FSegWidth+FSegGap;
      x2 := x1+FSegWidth;
    end;
end;

procedure DoVertical;
var
  i,h : integer;
begin
  h := height;
  x1 := 4;
  x2 := Width-4;
  y1 := Height-(FSegWidth+4);
  y2 := Height-4;
  max := Height div (FSegWidth+FSegGap);
  max := round(max * (FPercent / 100));
  for i := 1 to max do with canvas do
    begin
      if y1 >= 4 then Rectangle(x1,y1,x2,y2);
      y1 := y1-(FSegWidth+FSegGap);
      y2 := y1+ FsegWidth;
    end;
end;

begin
  canvas.pen.color := FSegColor;
  canvas.brush.color := FsegColor;
  if Width > Height then DoHorizontal else DoVertical;
end;

procedure TW95Meter.Paint;
begin
  with Canvas do
    begin
     Brush.Color := FBackColor;
     if FEdgeStyle = st95none then
       begin
         pen.Width := 1;
         Pen.Color := clBlack;
         Rectangle(1,1,width-1,height-1);
         exit;
       end;
     pen.Width := 2;
     if FEdgeStyle = st95Lowered then pen.color := clgray else
       pen.color := clWhite;
     moveto(0,height);
     lineto(0,0);
     lineto(width-1,0);
     if FEdgeStyle = st95Lowered then pen.color:=clWhite else
       pen.color := clGray;
     lineto(width-1,height-1);
     lineto(0,height-1);
     Pen.Width := 0;
     Brush.Color :=  FBackColor;
     Pen.Color := FBackColor;;
     Rectangle(1, 1, Width-1, Height-1);
     if FPercent > 0 then UpdateProgress;
    end;
end;

Function TW95Meter.RealPercent(High,Low : real) : integer;
Begin
  result := 0;
  if High = 0.0 then exit;
  Result := Round( (Low / High) * 100.0);
End;

Function TW95Meter.IntPercent(High,Low : Longint) : integer;
Begin
  result := 0;
  if High = 0 then exit;
  Result := Round( (low / high) * 100.0);
End;

END.
