unit Project;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls;

type
  TProjectDialog = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    PTitle: TEdit;
    PSubTitle: TEdit;
    Label3: TLabel;
    PVersion: TEdit;
    Label4: TLabel;
    PYear: TEdit;
    Label5: TLabel;
    PAuthor: TEdit;
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure Initialise(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ProjectDialog: TProjectDialog;

implementation

uses Decla;

{$R *.DFM}

(* Ok button *)
procedure TProjectDialog.OKBtnClick(Sender: TObject);
begin
 Title := PTitle.Text;
 SubTitle := PSubTitle.Text;
 Version := PVersion.Text;
 CopyRight := PYear.Text;
 Author := PAuthor.Text;
 ModalResult := mrOk;
end;

(* Cancel button *)
procedure TProjectDialog.CancelBtnClick(Sender: TObject);
begin
 ModalResult := mrCancel;
end;

(* init dialog *)
procedure TProjectDialog.Initialise(Sender: TObject);
begin
 PTitle.Text := Title;
 PSubTitle.Text := SubTitle;
 PVersion.Text := Version;
 PYear.Text := CopyRight;
 PAuthor.Text := Author;
 ActiveControl := PTitle;
end;

end.
