unit Process;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
     StdCtrls, ExtCtrls,SysUtils, Gauges,Dialogs, DdeMan,ShellAPI,FileCtrl,
     LZExpand,W95Meter;

type
  TProcessDialog = class(TForm)
    Bevel1: TBevel;
    btCancel: TButton;
    DdeClientConv: TDdeClientConv;
    btInstall: TButton;
    WMeter: TW95Meter;
    MeterCurrent: TW95Meter;
    Label1: TLabel;
    SrcFile: TLabel;
    Label3: TLabel;
    TrgFile: TLabel;
    Label2: TLabel;
    WhatUp: TLabel;
    DdeClientConv2: TDdeClientConv;
    DdeClientConv3: TDdeClientConv;
    procedure btCancelClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btTerminateClick(Sender: TObject);
    procedure Initialisation(Sender: TObject);
    procedure btInstallClick(Sender: TObject);
  private
    { Private declarations }
    Ending   : boolean;
    procedure MakeHistory (SourceFile,TargetFile : string);
    procedure CreateUnInstall;
    procedure MakeUnInstall (Line : string);
    function  ProcessMakeDirectory : integer;
    function  CheckCreate (Direct : string) : integer;
    function  ShouldICopy( Const sSourceFile,sTargetFile : string) : boolean;
    function  GetFileSize(const FileName : string): LongInt;
    function  ProcessCopyFiles : integer;
    function  ProcessCopyIcons : integer;
    function  ProcessMakeGroupIcons : integer;
    function  ProcessUpdateIniFiles : integer;
    function  CreateAGroup(GroupName,GroupFile : string) : integer;
    function  CreateAnItem(GroupName,GroupFile : string;
                           ItemName,ItemCommand,ItemWorkDir : string) : integer;
    function  DoesItemExist(GroupName : string; ItemName : String) : boolean;
    function  CloseManager : integer;
    function  CopyGauge (FromFile,ToFile : TFileName) : integer;
    function  GetName (sFile : string) : string;
   public
    { Public declarations }
    AbortInstall : boolean;
  end;

var
  ProcessDialog: TProcessDialog;

implementation

uses Decla,Disque,Lecture,Generale;

{$R *.DFM}

(* cancel button *)
procedure TProcessDialog.btCancelClick(Sender: TObject);
begin
 if Ending = False then
 begin
  AbortInstall := True;
  if MessageDlg ('Are you sure you want to abort installation process',
                 mtConfirmation,[mbYes,mbNo],0) = mrYes then
  Error := 1;
 end;
 if Error = 0 then CurrentWin := 6
              else CurrentWin := 7;
 Direction := 0;
 Close;
end;

(* closing dialog *)
procedure TProcessDialog.FormClose(Sender: TObject;var Action: TCloseAction);
begin
 MainBack.Initialisation (Sender);
end;

(* terminate button *)
procedure TProcessDialog.btTerminateClick(Sender: TObject);
begin
 if Ending = False then
  Error := 1;
 if Error = 0 then CurrentWin := 6
              else CurrentWin := 7;
 Direction := 0;
 Close;
end;

(* add history lines *)
procedure TProcessDialog.MakeHistory (SourceFile,TargetFile : string);
begin
 SrcFile.Caption := SourceFile;
 TrgFile.Caption := TargetFile;
end;

(* make UnInstall file *)
procedure TProcessDialog.CreateUnInstall;
var Fch : System.Text;
    Nam : string;
    Nom : string;
begin
 Nam := VPath [2].LettDriv + VPath [2].PathDriv;
 if Nam [length (Nam)] <> '\' then Nam := Nam + '\';
 Nom := Nam + Fch_UnIns + 'LOG';
 Nam := Nam + Fch_UnIns + 'INS';
 System.Assign (Fch,Nam);
 {$I-}; System.Rewrite (Fch); {$I+};
 if ioresult = 0 then
 begin
  Writeln (Fch,'');
  Writeln (Fch,'; UnSetup file (c)1996 by J. BERTRAND & L. TANNER');
  Writeln (Fch,'');
  Writeln (Fch,'; ' + Title + ' v ' + Version);
  Writeln (Fch,'; ' + SubTitle);
  Writeln (Fch,'; (c)' + CopyRight + ' by ' + Author);
  Writeln (Fch,'');
  Writeln (Fch,'; Main directory of application : ' + VPath [2].LettDriv +
                                                      VPath [2].PathDriv);
  Writeln (Fch,'');
  System.Close (Fch);
 end;
 System.Assign (Fch,Nom);
 {$I-}; System.Rewrite (Fch); {$I+};
 if ioresult = 0 then
 begin
  Writeln (Fch,'');
  Writeln (Fch,'Log file about installation of -' + Title + ' -');
  Writeln (Fch,'');
  Writeln (Fch,Title + ' v ' + Version);
  Writeln (Fch,SubTitle);
  Writeln (Fch,'(c)' + CopyRight + ' by ' + Author);
  Writeln (Fch,'');
  Writeln (Fch,'Main directory of application : ' + VPath [2].LettDriv +
                                                    VPath [2].PathDriv);
  Writeln (Fch,'');
  System.Close (Fch);
 end;
end;

(* make UnInstall file *)
procedure TProcessDialog.MakeUnInstall (Line : string);
var Fch : System.Text;
    Nam : string;
    Nom : string;
    Tmp : string;
begin
 Nam := VPath [2].LettDriv + VPath [2].PathDriv;
 if Nam [length (Nam)] <> '\' then Nam := Nam + '\';
 Nom := Nam + Fch_UnIns + 'LOG';
 Nam := Nam + Fch_UnIns + 'INS';
 System.Assign (Fch,Nam);
 {$I-}; System.Append (Fch); {$I+};
 if ioresult = 0 then
  System.Close (Fch)
 else
  CreateUnInstall;
 {$I-}; System.Append (Fch); {$I+};
 if ioresult = 0 then
 begin
  Writeln (Fch,Line);
  System.Close (Fch);
 end;
 System.Assign (Fch,Nom);
 {$I-}; System.Append (Fch); {$I+};
 if ioresult = 0 then
  System.Close (Fch);
 {$I-}; System.Append (Fch); {$I+};
 if ioresult = 0 then
 begin
  Tmp := copy (Line,3,length (Line) - 2);
  case Line [1] of
   '0' : Tmp := 'Making directory : ' + Tmp;
   '1' : Tmp := 'Creating file : ' + Tmp;
   '2' : Tmp := 'Creating group : ' + Tmp;
  end;
  Writeln (Fch,Tmp);
  System.Close (Fch);
 end;
end;

(* starting installation *)
procedure TProcessDialog.btInstallClick(Sender: TObject);
var Tmp : longint;
    Bcl : integer;
    fch : system.text;
begin
{ System.Assign (Fch,'c:\delphi\travail\setup\setup1.ins');}
{ System.Assign (Fch,'e:\delphi\setup\setup1.ins');}
{ System.Rewrite (Fch);
 writeln(fch,'Packet');
 for bcl := 1 to number_pack do
 begin
  writeln (fch,Vpack [Bcl].Libelle);
 end;
 writeln(fch,'path');
 for Bcl := 1 to max_path do
 begin
  writeln (fch,VPath[Bcl].lettDriv + '|' + VPath [Bcl].PathDriv);
 end;
 writeln(fch,'group');
 for Bcl := 1 to number_group do
 begin
  writeln (fch,VGroup [Bcl].GroupName + '|' + VGroup [Bcl].GroupFile);
 end;
 writeln(fch,'fichiers');
 for Bcl := 1 to number_files do
 begin
  with VFiles [Bcl] do
  begin
   writeln (Fch,disknumb,'|',filepath,'|',filename,'|C',compress,'|P',packfile);
  end;
 end;
 writeln(fch,'icones');
 for Bcl := 1 to number_icons do
 begin
  with Vicons [Bcl] do
  begin
   writeln (Fch,disknumb,'|',filepath,'|',filename,'|C',compress,'|G',GroupNum,'|P',packfile,'|N',iconname);
  end;
 end;
 writeln(fch,'appli');
 for Bcl := 1 to Number_Run do
 begin
  with VRun [Bcl] do
  begin
   writeln (Fch,filepath,'|',filename,'|',docspath,'-',docsname);
  end;
 end;
 writeln(fch,'ini fichier');
 for Bcl := 1 to Number_Ini do
 begin
  With VIniF [Bcl] do
  begin
   writeln (Fch,filepath,'|',filename,'|',IniSecti,'|',IniField,'|',IniValue);
  end;
 end;
 System.Close (Fch);}
{ Exit;}
 btInstall.Enabled := false;
 ActiveControl := btCancel;
 Tmp := DiskSize (ord (upcase(VPath [2].LettDriv [1])) - 64);
 if Disk_Space > Tmp then
 begin
  MessageDlg ('You need more hard disk space to install',
              mtError,[mbok],0);
  Error := 2;
  BtInstall.Enabled := false;
  Ending := true;
  btCancelClick (Sender);
 end;
 if Error = 0 then
 begin
  WhatUp.Caption := 'Installation starting ...';
  Screen.Cursor := crHourGlass;
  ProcessMakeDirectory;
  Error := ProcessCopyIcons;
  if Error = 0 then Error := ProcessCopyFiles;
  if Error = 0 then Error := ProcessUpdateIniFiles;
  if Error = 0 then Error := ProcessMakeGroupIcons;
  if Error = 0 then CloseManager;
  Screen.Cursor := crDefault;
  btCancel.Enabled := True;
  btInstall.Enabled := false;
  ActiveControl := btCancel;
  BringToFront;
  Ending := True;
 end;
 btCancelClick (Sender);
end;

(* dialog init *)
procedure TProcessDialog.Initialisation(Sender: TObject);
begin
 Ending := false;
 AbortInstall := False;
 WMeter.Percent := 0;
 MakeHistory ('','');
 Application.ProcessMessages;
end;

(* make directory *)
function TProcessDialog.ProcessMakeDirectory : integer;
var Tmp : integer;
    Bcl : integer;
    Rep : string;
begin
 Tmp := 0;
 (* jump number #1 because source directory *)
 for Bcl := 2 to Max_Path do
 begin
  if VPath[Bcl].PathDriv = '' then
   break;  { if you hit a blank, we're done}
  Rep := VPath [Bcl].LettDriv + VPath [Bcl].PathDriv;
  WhatUp.Caption := 'Creating directory ... ' + Rep;
  Tmp := CreateDirectory (Rep);
  if Tmp = 0 then
  begin
   if UnInstallFil = true then
   begin
    if Bcl = 2 then CreateUnInstall;
    if length( Rep ) > 2 then MakeUnInstall ('0,' + Rep);
   end;
  end
  else
   Tmp := 1;
 end;
 ProcessMakeDirectory := Tmp;
end;

(* check if directry exist *)
function TProcessDialog.CheckCreate (Direct : string) : integer;
var Tmp : integer;
    Tm1 : integer;
begin
 Tmp := 0;
 if copy (Direct,Length (Direct),1) = '\' then
  Direct := copy (Direct,1,length (Direct) - 1);
 if Pos (':',Direct) = 0 then
 begin
  Direct := VPath [2].LettDriv + Direct;
  if Direct [3] <> '\' then System.Insert ('\',Direct,3);
 end;
 if DirectoryExists (Direct) = False then
 begin
  WhatUp.Caption := 'Creating directory ... ' + Direct;
  Tm1 := CreateDirectory (Direct);
  if Tm1 = 0 then
  begin
   if UnInstallFil = True then
    MakeUnInstall ('0,' + Direct);
  end
  else
   Tmp := 1;
 end;
 CheckCreate := Tmp;
end;

(* check if file should bze copied *)
function TProcessDialog.ShouldICopy( Const sSourceFile,sTargetFile : string) : boolean;
begin
 if not FileExists (sTargetFile ) then
 (* no target *)
 begin
  result := true;
  exit;
 end;
 if FileAge (sTargetFile) < FileAge (sSourceFile) then
 (* target newer *)
 begin
  result := true;
  exit;
 end;
 if GetFileSize( sTargetFile ) < 1 then
 (* target empty *)
 begin
  result := true;
  exit;
 end;
 if ( FileAge( sTargetFile ) = FileAge( sSourceFile ) ) and
    ( GetFileSize( sTargetFile ) <> GetFileSize( sSourceFile ) ) then
 (* size different *)
 begin
  result := true;
  exit;
 end;
 result := false;
end;

(* Return size without opening file *)
function TProcessDialog.GetFileSize(const FileName: string): LongInt;
var SearchRec: TSearchRec;
begin
 if FindFirst(ExpandFileName(FileName), faAnyFile, SearchRec) = 0 then
  Result := SearchRec.Size
 else
  Result := -1;
end;

(* copy all files *)
function TProcessDialog.ProcessCopyFiles : integer;
var Tmp : integer;
    Bcl : integer;
    Flp : boolean;
    Flg : boolean;
    FrF : string;
    ToF : string;
    Tm1 : integer;
    Res : integer;
    Stk : integer;
    Err : integer;
    Tm2 : string;
begin
 Tmp := 0;
 if Number_Files > 0 then
 begin
  WhatUp.Caption := 'Copying files ... ';
  for Bcl := 1 to Number_Files do
  begin
   WMeter.Percent := WMeter.Percent +
                     (100 DIV (Number_Files + Number_Icons));
   With VFiles [Bcl] do
   begin
    (* check floppy *)
    repeat
     Res := DiskIDCorrect (VPath [1].LettDriv,VPath [1].PathDriv,DiskNumb);
     case Res of
      0 : Flg := true;
      1 : Flg := false;
      2 : begin
           Flg := true;
           Tmp := 1;
          end;
     end;
    until Flg = true;
    (* copy file *)
    if (Flg = true) and (Res = 0) then
    begin
     FrF := VPath [1].LettDriv + VPath [1].PathDriv;
     if FrF [length (FrF)] <> '\' then FrF := FrF + '\' + FileName
                                  else FrF := FrF + FileName;
     if FilePath [1] = '%' then
     begin
      case upcase (FilePath [2]) of
       'W' : ToF := Windir + '\';
       'S' : ToF := SysDir + '\';
       'R' : ToF := '\';
      else
       begin
        val (copy (FilePath,2,2),Stk,Err);
        if Err = 0 then
        begin
         ToF := VPath [Stk + 1].LettDriv + VPath [Stk + 1].PathDriv;
         if ToF [length (ToF)] <> '\' then ToF := ToF + '\';
        end;
       end;
      end;
     end
     else
     begin
      if pos (':',FilePath) = 0 then ToF := VPath [2].LettDriv + FilePath
                                else ToF := FilePath;
      if ToF [length (ToF)] <> '\' then ToF := ToF + '\';
      CheckCreate (Copy (ToF,1,length (ToF) - 1));
     end;
     (* check UnInstall options *)
     if (PackFile = 0) or (VPack [PackFile].Selecte = true) then
     begin
      Tm2 := GetName (FrF);
      while pos ('\',tm2) <> 0 do system.delete (tm2,1,pos ('\',Tm2));
      FileName := Tm2;
      ToF := ToF + Tm2;
      MakeHistory (FrF,ToF);
      if UnInstallCop = true then
      begin
       Tm1 := CopyGauge (FrF,ToF);
       if Tm1 <> 0 then
        Tmp := Tm1 + 3
       else
       begin
        if UnInstallFil = true then
         MakeUnInstall ('1,' + ToF);
       end;
      end
      else
      begin
       if pos (Fch_UnIns,FileName) = 0 then
       begin
        Tm1 := CopyGauge (FrF,ToF);
        if Tm1 <> 0 then
         Tmp := Tm1 + 3
        else
        begin
         if UnInstallFil = true then
          MakeUnInstall ('1,' + ToF);
        end;
       end;
      end;
     end;
    end
    else
    begin
     WMeter.Percent := WMeter.Percent -
                       round (100 DIV (Number_Files + Number_Icons));
     ProcessCopyFiles := 1;
     exit;
    end;
   end;
  end;
 end;
 ProcessCopyFiles := Tmp;
end;

(* copy all icons *)
function TProcessDialog.ProcessCopyIcons : integer;
var Tmp : integer;
    Bcl : integer;
    Flp : boolean;
    Flg : boolean;
    FrF : string;
    ToF : string;
    Tm1 : integer;
    Res : integer;
    Stk : integer;
    Err : integer;
    Tm2 : string;
begin
 Tmp := 0;
 if Number_Icons > 0 then
 begin
  WhatUp.Caption := 'Copying icons ... ';
  for Bcl := 1 to Number_Icons do
  begin
   WMeter.Percent := WMeter.Percent +
                     round (100 DIV (Number_Files + Number_Icons));
   With VIcons [Bcl] do
   begin
    (* check floppy *)
    repeat
     Res := DiskIDCorrect (VPath [1].LettDriv,VPath [1].PathDriv,DiskNumb);
     case Res of
      0 : Flg := true;
      1 : Flg := false;
      2 : begin
           Flg := true;
           Tmp := 1;
          end;
     end;
    until Flg = true;
    (* copy file *)
    if (Flg = true) and (Res = 0) then
    begin
     FrF := VPath [1].LettDriv + VPath [1].PathDriv;
     if FrF [length (FrF)] <> '\' then FrF := FrF + '\' + FileName
                                  else FrF := FrF + FileName;
     if FilePath [1] = '%' then
     begin
      case upcase (FilePath [2]) of
       'W' : ToF := Windir + '\';
       'S' : ToF := SysDir + '\';
       'R' : ToF := '\';
      else
       begin
        val (copy (FilePath,2,2),Stk,Err);
        if Err = 0 then
        begin
         ToF := VPath [Stk + 1].LettDriv + VPath [Stk + 1].PathDriv;
         if ToF [length (ToF)] <> '\' then ToF := ToF + '\';
        end;
       end;
      end;
     end
     else
     begin
      if pos (':',FilePath) = 0 then ToF := VPath [2].LettDriv + FilePath
                                else ToF := FilePath;
      if ToF [length (ToF)] <> '\' then ToF := ToF + '\';
      CheckCreate (Copy (ToF,1,length (ToF) - 1));
     end;
     (* check UnInstall options *)
     if (PackFile = 0) or (VPack [PackFile].Selecte = true) then
     begin
      Tm2 := GetName (FrF);
      while pos ('\',tm2) <> 0 do system.delete (tm2,1,pos ('\',Tm2));
      ToF := ToF + Tm2;
      FileName := Tm2;
      MakeHistory (FrF,ToF);
      if UnInstallCop = true then
      begin
       Tm1 := CopyGauge (FrF,ToF);
       if Tm1 <> 0 then
        Tmp := Tm1 + 3
       else
       begin
        if UnInstallFil = true then
         MakeUnInstall ('1,' + ToF);
       end;
      end
      else
      begin
       if pos (Fch_UnIns,FileName) = 0 then
       begin
        Tm1 := CopyGauge (FrF,ToF);
        if Tm1 <> 0 then
         Tmp := Tm1 + 3
        else
        begin
         if UnInstallFil = true then
          MakeUnInstall ('1,' + ToF);
        end;
       end;
      end;
     end;
    end
    else
    begin
     WMeter.Percent := WMeter.Percent -
                       round (100 DIV (Number_Files + Number_Icons));
     ProcessCopyIcons := 1;
     exit;
    end;
   end;
  end;
 end;
 ProcessCopyIcons := Tmp;
end;

(* make group and icons *)
function TProcessDialog.ProcessMakeGroupIcons : integer;
var Tmp : integer;
    Bcl : integer;
    Rep : string;
    ToF : string;
    Stk : integer;
    Err : integer;
begin
 Tmp := 0;
 if Number_Group > 0 then
 begin
  (* multi groups *)
  WhatUp.Caption := 'Creating group ...';
  for Bcl := 1 to Number_Group do
  begin
   With VGroup [Bcl] do
   begin
    CreateAGroup (GroupName,GroupFile);
    if UnInstallFil = true then
     MakeUnInstall ('2,' + GroupName);
   end;
  end;
  (* icons *)
  if Number_Icons > 0 then
  begin
   WhatUp.Caption := 'Creating items ...';
   {open here to avoid GPF caused by opening and closing DDE}
   DDEClientConv.ConnectMode := DDEAutomatic;
   DDEClientConv2.ConnectMode := ddeAutomatic;
   if WinVersion > Old_Win then
   begin
    DDEClientConv.SetLink('','PROGMAN');
    DDEClientConv2.SetLink('','PROGMAN');
   end
   else
   begin
    DDEClientConv.SetLink('PROGMAN','PROGMAN');
    DDEClientConv2.SetLink('PROGMAN','PROGMAN');
   end;
   DDEClientConv.OpenLink;
   DDEClientConv2.OpenLink;
   for Bcl := 1 to Number_Icons do
   begin
    with VIcons [Bcl] do
    begin
     if (PackFile = 0) or (VPack [PackFile].Selecte = true) then
     begin
      if FilePath [1] = '%' then
      begin
       case upcase (FilePath [2]) of
        'W' : ToF := Windir + '\' + FileName;
        'S' : ToF := SysDir + '\' + FileName;
        'R' : ToF := '\' + FileName;
       else
        begin
         val (copy (FilePath,2,2),Stk,Err);
         if Err = 0 then
         begin
          ToF := VPath [Stk + 1].LettDriv + VPath [Stk + 1].PathDriv;
          if ToF [length (ToF)] <> '\' then ToF := ToF + '\';
          ToF := ToF + FileName;
         end;
        end;
       end;
      end
      else
      begin
       if pos (':',FilePath) = 0 then ToF := VPath [2].LettDriv + FilePath
                                 else ToF := FilePath;
       if ToF [length (ToF)] <> '\' then ToF := ToF + '\';
       ToF := ToF + FileName;
      end;
      Rep := copy (ToF,1,pos (FileName,ToF) - 2);
      Tmp := CreateAnItem (VGroup [GroupNum].GroupName,
                           VGroup [GroupNum].GroupFile,
                           IconName,ToF,Rep);
     end;
    end;
   end;
   DDEClientConv.CloseLink;
   DDEClientConv2.CloseLink;
  end;
 end;
 ProcessMakeGroupIcons := 0;
end;

(* update all ini files *)
function TProcessDialog.ProcessUpdateIniFiles : integer;
var Tmp : integer;
    Bcl : integer;
    Fch : string;
    Stk : integer;
    Err : integer;
begin
 Tmp := 0;
 if Number_Ini > 0 then
 begin
  For Bcl := 1 to Number_Ini do
  begin
   WhatUp.Caption := 'Updating Ini files ... ';
   with VIniF [Bcl] do
   begin
    if FilePath [1] = '%' then
    begin
     case upcase (FilePath [2]) of
      'W' : Fch := Windir + '\' + FileName;
      'S' : Fch := SysDir + '\' + FileName;
      'R' : Fch := '\' + FileName;
     else
      begin
       val (copy (FilePath,2,2),Stk,Err);
       if Err = 0 then
       begin
        Fch := VPath [Stk + 1].LettDriv + VPath [Stk + 1].PathDriv;
        if Fch [length (Fch)] <> '\' then Fch := Fch + '\';
        Fch := Fch + FileName;
       end;
      end;
     end;
    end
    else
    begin
     if pos (':',FilePath) = 0 then Fch := VPath [2].LettDriv + FilePath
                               else Fch := FilePath;
     if Fch [length (Fch)] <> '\' then Fch := Fch + '\';
     Fch := Fch + FileName;
    end;
    if (IniSecti = '') or (IniField = '') or (IniValue = '') then
    begin
     if ExistFile (Fch) = 1 then
     begin
      if IniSecti = '' then
      begin
       if (FileName = 'WIN.INI') or (FileName = 'SYSTEM.INI') then
        Tmp := 10
       else
        DeleteIniFile (Fch);
      end
      else
       if IniField = '' then
        DeleteIniSection (Fch,IniSecti)
       else
        if IniValue = '' then
         DeleteIniField (Fch,IniSecti,IniField);
     end
     else
      Tmp := 9;
    end
    else
    begin
     if ExistFile (Fch) = 1 then
      ModifyIniValue (Fch,IniSecti,IniField,IniValue)
     else
     begin
      if CreateIniFile (Fch) = 0 then
      begin
       ModifyIniValue (Fch,IniSecti,IniField,IniValue);
       if UnInstallFil = true then
        MakeUnInstall ('1,' + Fch);
      end;
     end;
    end;
   end;
  end;
 end;
 ProcessUpdateIniFiles := tmp;
end;

(* create a specified program manager group *)
function TProcessDialog.CreateAGroup(GroupName,GroupFile : string) : integer;
var SetupString : string;
    Tmp : integer;
    DDECommands : TStringList;
begin
 Tmp := 0;
 if GroupName = '' then
  Tmp := 1
 else
 {(c) Larry E TANNER updated by J. BERTRAND}
 begin
  SetupString := '[CreateGroup(' + TrimString (GroupName) + ',' + GroupFile + ')]';
  DDECommands := TStringList.Create;
  DDECommands.Clear;
  DDECommands.Add(SetupString);
  (* try DDE Conversation *)
  DDEClientConv3.ConnectMode := DDEAutomatic;
  if WinVersion > Old_Win then
   DDEClientConv3.SetLink('','PROGMAN')
  else
   DDEClientConv3.SetLink('PROGMAN','PROGMAN');
  DDEClientConv3.OpenLink;
  DDEClientConv3.ExecuteMacroLines(DDECommands,True);
  While DDEClientConv3.WaitStat Do
   Application.ProcessMessages;
  DDEClientConv3.CloseLink;
  DDECommands.Free;
 end;
 CreateAGroup := Tmp;
end;

(* create a specified program manager item *)
function TProcessDialog.CreateAnItem (GroupName,GroupFile : string;
                                      ItemName,ItemCommand,ItemWorkDir : string) : integer;
var Tmp : integer;
    DDECommands : TStringList;
begin
 Tmp := 0;
 if (GroupName = '') or (ItemCommand = '') then
  Tmp := 1
 else
 {(c) Larry E TANNER updated by J. BERTRAND}
 begin
  if Copy (ItemWorkDir,length(ItemWorkDir),1) = '\' then
     ItemWorkDir := Copy (ItemWorkDir,1,(length (ItemWorkDir) - 1));
  CreateAGroup(TrimString (GroupName),GroupFile);
  Application.ProcessMessages;
  if not ((pos (Fch_UnIns,ItemCommand) <> 0) and
          (UnInstallCop = false)) then
  begin
   DDECommands := TStringList.Create;
   DDECommands.Clear;
   if DoesItemExist(GroupName,ItemName) = True then
   begin
    DDECommands.Add('[ShowGroup('+GroupName+',4)]');
    DDECommands.Add('[ReplaceItem('+ItemName+')]');
    DDECommands.Add('[AddItem('+ItemCommand+','+ItemName+',,,,,'+ItemWorkDir+')]');
    (*  DDE Connection moved to ICON routine before 'for' logic *)
   end
   else
   begin
    DDECommands.Add('[ShowGroup('+GroupName+',4)]');
    DDECommands.Add('[AddItem('+ItemCommand+','+ItemName+',,,,,'+ItemWorkDir+ ')]');
   end;
   DDEClientConv.ExecuteMacroLines(DDECommands,false);
   DDECommands.Free;
  end;
  While DDEClientConv.WaitStat Do
   Application.ProcessMessages;
 end;
 CreateAnItem := Tmp;
end;

(* check to see if a specified program manager item exists *)
function TProcessDialog.DoesItemExist(GroupName : string; ItemName : String) : boolean;
var AllTheItemsInTheGroup : TStrings;
    Looper : integer;
    ProgmanResult : pChar;
    ParsedItemName : string;
    Tmp : boolean;
begin
 Tmp := False;
 AllTheItemsInTheGroup := TStringList.Create;
 ProgmanResult := DDEClientConv2.RequestData(TrimString (GroupName));
 Application.ProcessMessages;
 AllTheItemsInTheGroup.SetText (ProgmanResult);
 StrDispose(ProgmanResult);
 for looper := 1 to AllTheItemsInTheGroup.Count-1 do
 begin
  ParsedItemName := Copy (AllTheItemsInTheGroup[looper],2,
                          (Pos(',',AllTheItemsInTheGroup[looper])-1)-2);
  if UpperCase(ParsedItemName) = UpperCase(ItemName) then
   Tmp := True;
 end;
 AllTheItemsInTheGroup.Free;
 DoesItemExist := Tmp;
end;

(* close program manager *)
function TProcessDialog.CloseManager : integer;
var SetupString : string; {program manager macro in string form}
    Tmp : integer;
    DDECommands : TStringList;
begin
 Tmp := 0;
 SetupString := 'Close';
 DDECommands := TStringList.Create;
 DDECommands.Clear;
 DDECommands.Add(SetupString);
 (* try DDE Conversation *)
 DDEClientConv.ConnectMode := DDEAutomatic;
 if WinVersion > Old_Win then
  DDEClientConv.SetLink('','PROGMAN')
 else
  DDEClientConv.SetLink('PROGMAN','PROGMAN');
 DDEClientConv.ExecuteMacroLines(DDECommands,True);
 While DDEClientConv.WaitStat Do
  Application.ProcessMessages;
 DDEClientConv.CloseLink;
 DDECommands.Free;
 CloseManager := Tmp;
end;

(* Copy and expand compressed file or not to target with a W95Meter graph *)
{Returns: 0 : OK file copied
         1 : Unable to open Source File
         2 : Unable to open destination file
         3 : Unable to read from Source File
         4 : Unable to write to destination file
         5 : Unable to determine compressed file name
         8 : File is missing}
function TProcessDialog.CopyGauge (FromFile,ToFile : TFileName) : integer;
const Block : longint = 8192;
var iReturn     : integer;
    iTmpReturn  : Integer;
    iHandle     : Integer;
    iNewHandle  : Integer;
    iLongReturn : LongInt;
    pFrom       : Array [0 .. 256] of Char;
    pTo         : Array [0 .. 256] of Char;
    Buffer      : Array [0 .. 8192] of Char;
    fileTo      : TFileName;
    TotalBytes  : longint;
    TotalProce  : longint;
    bytesCopie  : longint;
    ReOpenBuf   : TOFStruct;
    Fichier     : file of byte;
    Tmp         : integer;
    TimeStamp   : longint;
    OldCur      : hCursor;
begin
 iReturn := 0;
 iLongReturn := 0;
 if FileExists (FromFile) = false then
 begin
  iReturn := 8;
  OldCur := Cursor;
  Screen.Cursor := crDefault;
  MessageDlg ('File ' + FromFile + #10 +
              'is missing in source drive.', mtError, [mbOk], 0);
  Screen.Cursor := oldCur;
 end
 else
  begin
  StrPCopy (pFrom,FromFile);
  iTmpReturn := GetExpandedName (pFrom,pTo);
  if iTmpReturn < 0 then
   iReturn := 5
  else
  begin
   if (StrEnd (pTo) - pTo) > 0 then
   begin
    FileTo := ExtractFilePath (ToFile) + ExtractFileName (StrPas (pTo));
    if ShouldICopy (FromFile,ToFile) = true then
    begin
     TimeStamp := FileAge(FromFile); { get source's time stamp }
     LZStart;
     iHandle := LZOpenFile (pFrom, ReOpenBuf,of_Read or of_share_deny_write);
     if iHandle < 1 then
      iReturn := 1
     else
     begin
      iNewHandle := FileCreate (fileTo);
      if iNewHandle < 1 then
      begin
       iReturn := 2;
       FileClose( iHandle );
      end
      else
      begin
       TotalProce := 0;
       TotalBytes := LZSeek (iHandle,0,2);
       repeat
        Application.ProcessMessages;
        LZSeek (iHandle,TotalProce,0);
        BytesCopie := LZRead (iHandle,Buffer,Block);
        if BytesCopie <> LZERROR_UNKNOWNALG then
        begin
         TotalProce := TotalProce + BytesCopie;
         if BytesCopie > 0 then Application.ProcessMessages;
         if TotalBytes > 0 then
          MeterCurrent.Percent := (TotalProce * 100) DIV TotalBytes;
         _lwrite (iNewHandle,Buffer,BytesCopie);
        end
        else
         iReturn := 3;
       until BytesCopie < Block;
       if iLongReturn < 0 then
        iReturn := 4;
       LZClose (iHandle);
       FileSetDate(iNewHandle, TimeStamp);
       FileClose (iNewHandle);
      end;
     end;
     LZDone;
    end;
   end;
  end;
 end;
 CopyGauge := iReturn;
end;

(* give real name of compress or normal file without path *)
function TProcessDialog.GetName (sFile : string) : string;
var sReturn      : string;
    pFileName     : Array [0 .. 256] of Char;
    pInternalName : Array [0 .. 256] of Char;
    iTmp          : integer;
begin
 StrPCopy (pFileName,sFile);
 iTmp := GetExpandedName (pFileName,pInternalName);
 if iTmp < 0 then
  sReturn := uppercase (ExtractFileName (sFile))
 else
  sReturn := uppercase (ExtractFileName (StrPas (pInternalName)));
 GetName := sReturn;
end;

end.

