(*********************************)
(*                               *)
(* Functions to install programs *)
(* version 1.00                  *)
(* (c)1996 by J. BERTRAND        *)
(*                               *)
(* ----------------------------- *)
(*                               *)
(* windows function (directory)  *)
(* directory functions           *)
(* file functions                *)
(* group & icons functions       *)
(*                               *)
(*********************************)
unit Disque;

interface

Const DiskName = 'DISK.';

(*******************)
(* extra functions *)
(*******************)
function WinDir : string;
                  {Windows directory without '\' at the end
                   none if can't find it}
function SysDir : string;
                  {Windows system directory without '\' at the end
                   none if can't find it}
function StartApp (AppName,AppParams,AppDir : string) : integer;
                  {0..32 : Error look to ShellExecute for explanations of error
                   other values > 32 : Ok application lauched Return = Handle of App}
function CheckDsk (Path : string;Number : integer) : integer;
                  {0 : OK it is the right disk in
                   1 : It isn't the right disk}
function DosVersion : real;
function WinVersion : real;

(***********************)
(* directory functions *)
(***********************)

function CreateDirectory (DirectoryName : string) : integer;
                  {0 : OK   directory created
                   1 : Unable to create}
function DestroyDirectory (DirectoryName : string) : integer;
                  {0 : OK directory deleted
                   1 : Unable to destroy}

(******************)
(* file functions *)
(******************)

function SizeFile (Fichier : string) : longint;
                  {-2 : Unable to set size
                   -1 : File doesn't exist
                   >0 : Size of the file}
function DeleteFile (Fichier : string) : integer;
                  {0 : OK file deleted
                   1 : Unable to delete}
function ExistFile (Fichier : string) : integer;
                  {0 : File doesn't exist
                   1 : File exist}
function RenameFile (OldName,NewName : string) : integer;
                  {0 : OK file renammed
                   1 : OldName does't exist
                   2 : NewNameAlReadyExist
                   3 : Unable to rename}
function EnougthSpace (DriveUnit: char;Fichier : string) : integer;
                  {0 : OK enougth space
                   1 : File Doesn't exist
                   2 : Not enougth space
                   3 : Wrong letter Drive}
function CopyFile (FromFile,ToFile : string;Switch : byte) : integer;
                  {Switch > 0 : Don't overwrite  1 : Overwrite if exist}
                  {0 : OK file copied
                   1 : File already exist and Switch = 0
                   2 : Unable to open Source File
                   3 : Unable to open destination file
                   4 : Unable to read from Source File
                   5 : Unable to write to destination file}

implementation

uses SysUtils,WinProcs,DdeMan,ShellAPI,FileCtrl,Decla,Dialogs;

(*********************)
(*                   *)
(* FONCTIONS EN PLUS *)
(*                   *)
(*********************)

(*************************)
(* repertoire de windows *)
(*************************)
function WinDir : string;
var Tmp : string;
    Pas : array [0 .. 254] of char;
    Siz : integer;
begin
 Tmp := '';
 if GetWindowsDirectory(Pas,Sizeof (Pas)) <> 0 then
  Tmp := StrPas (Pas);
 WinDir := Tmp;
end;

(*******************)
(* windows version *)
(*******************)
function WinVersion : real;
var version : longint;
    winveri : word;
    tempo   : string;
    Temp    : real;
    err     : integer;
begin
 version := GetVersion;
 winveri := version shl 32;
 Tempo  := inttostr (lo (WinVeri)) + '.' + inttostr (hi (winveri));
 val (tempo,temp,err);
 WinVersion := Temp;
end;

(***************)
(* dos version *)
(***************)
function DosVersion : real;
var version : longint;
    dosveri : word;
    tempo   : string;
    temp    : real;
    err     : integer;
begin
 version := GetVersion;
 dosveri := version shr 24;
 tempo := inttostr (lo (dosveri)) + '.' + inttostr (hi (dosveri));
 val (tempo,temp,err);
 DosVersion := Temp;
end;


(*********************)
(* repertoire system *)
(*********************)
function SysDir : string;
var Tmp : string;
    Pas : array [0 .. 254] of char;
    Siz : integer;
begin
 Tmp := '';
 if GetSystemDirectory (Pas,Sizeof (Pas)) <> 0 then
  Tmp := StrPas (Pas);
 SysDir := Tmp;
end;

(*******************************)
(* lancement d'une application *)
(*******************************)
function StartApp (AppName,AppParams,AppDir : string) : integer;
var Tmp : Integer;
    zFileName : array [0 .. 79] of char;
    zParams   : array [0 .. 79] of char;
    zDir      : array [0 .. 79] of Char;
begin
 Tmp := 0;
 StrPCopy (zFileName,AppName);
 StrPCopy (zParams,AppParams);
 StrPCopy (zDir,AppDir);
 Tmp := ShellExecute (0,Nil,zFileName,zParams,zDir,1);
 StartApp := Tmp;
end;

(********************************)
(* verification d'une disquette *)
(********************************)
function CheckDsk (Path : string;Number : integer) : integer;
var Tmp : integer;
    Nbr : string [3];
    Nam : string [12];
begin
 Tmp := 0;
 str (Number:3,Nbr);
 while pos (' ',Nbr) <> 0 do Nbr [pos (' ',Nbr)] := '0';
 while length (Nbr) < 3 do Nbr := '0' + Nbr;
 Nam := DiskName + Nbr;
 if ExistFile (Path + Nam) = 0 then
  Tmp := 1;
 CheckDsk := Tmp;
end;

(*********************************)
(*                               *)
(* FONCTIONS SUR LES REPERTOIRES *)
(*                               *)
(*********************************)

(****************************)
(* creation d'un repertoire *)
(****************************)
function CreateDirectory (DirectoryName : string) : integer;
var Tmp : integer;
begin
 Tmp := 0;
 {$I-}; mkdir (DirectoryName) {$I+};
 if ioresult <> 0 then Tmp := 1;
 CreateDirectory := tmp;
end;

(**************************)
(* destruction repertoire *)
(**************************)
function DestroyDirectory (DirectoryName : string) : integer;
var Tmp : integer;
begin
 Tmp := 0;
 (* application directory *)
 if DirectoryExists (DirectoryName) then
 begin
  {$I-}; RmDir (DirectoryName); {$I+};
  if ioresult <> 0 then Tmp := 1;
 end;
 (* other branch upper *)
 if Tmp = 0 then
 begin
  (* scan all branchs *)
  while length (DirectoryName) > 1 do
  begin
   While (copy (DirectoryName,length (DirectoryName),1) <> '\') and
         (Length (DirectoryName) > 0) do
    Delete (DirectoryName,Length (DirectoryName),1);
   if Length (DirectoryName) > 0 then
   begin
    Delete (DirectoryName,Length (DirectoryName),1);
    (* not root directory *)
    if Pos ('\',DirectoryName) > 0 then
    begin
     {$I-}; RmDir (DirectoryName); {$I+};
    end;
   end;
  end;
 end;
 DestroyDirectory := Tmp;
end;

(******************************)
(*                            *)
(* FONCTIONS SUR LES FICHIERS *)
(*                            *)
(******************************)

(***********************)
(* taille d'un fichier *)
(***********************)
function SizeFile (Fichier : string) : longint;
var Tmp : longint;
    Siz : longint;
    Fch : file;
begin
 if ExistFile (Fichier) = 0 then
  Tmp := -1
 else
 begin
  assign (Fch,Fichier);
  {$I-}; Siz := FileSize (Fch); {$I+};
  if ioresult <> 0 then Tmp := -2
                   else Tmp := Siz;
 end;
 SizeFile := Tmp;
end;

(*********************)
(* efface un fichier *)
(*********************)
function DeleteFile (Fichier : string) : integer;
var Tmp : integer;
    Fch : file;
begin
 Tmp := 0;
 if ExistFile (Fichier) = 1 then
 begin
  Assign (Fch,Fichier);
  {$I-}; Erase (Fch); {$I+};
  if ioresult <> 0 then Tmp := 1;
 end;
 DeleteFile := Tmp;
end;

(******************************)
(* teste si un fichier existe *)
(******************************)
function ExistFile (Fichier : string) : integer;
var Fch : file;
    Tmp : integer;
begin
 Tmp := 1;
 assign (Fch,Fichier);
 {$I-}; reset (Fch); {$I+};
 if ioresult = 0 then Close (Fch)
                 else Tmp := 0;
 ExistFile := Tmp;
end;

(**********************)
(* renomme un fichier *)
(**********************)
function RenameFile (OldName,NewName : string) : integer;
var Tmp : integer;
    Fch : file;
begin
 Tmp := 0;
 if ExistFile (OldName) = 1 then
  Tmp := 1
 else
  if ExistFile (NewName) = 1 then
   Tmp := 2
  else
  begin
   assign (Fch,OldName);
   {$I-}; rename (Fch,NewName) {$I+};
   if ioresult <> 0 then Tmp := 3;
  end;
 RenameFile := Tmp;
end;

(***************************)
(* y a t il assez de place *)
(***************************)
function EnougthSpace (DriveUnit : char;Fichier : string) : integer;
var Tmp : integer;
    Siz : longint;
    Dsk : integer;
    DFr : longint;
begin
 Tmp := 0;
 Dsk := ord (upcase (DriveUnit)) - 64;
 if Dsk < 1 then
  Tmp := 3
 else
 begin
  if ExistFile (Fichier) = 0 then
   Tmp := 1
  else
  begin
   Siz := SizeFile (Fichier);
   if Siz > -1 then
   begin
    DFr := DiskFree (Dsk);
    if Dfr < 0 then
     tmp := 3
    else
     if Siz > DiskFree (Dsk) then Tmp := 2;
   end;
  end;
 end;
 EnougthSpace := Tmp;
end;

(**********************)
(* copie d'un fichier *)
(**********************)
function CopyFile (FromFile,ToFile : string ; Switch : byte) : integer;
var Tmp : integer;
    FromF, ToF: file;
    NumRead, NumWritten: Word;
    Buf: array[1..4096] of Char;
begin
 Tmp := 0;
 If (ExistFile (ToFile) = 1) and (Switch = 0) then
  Tmp := 1
 else
 begin
  System.Assign(FromF,FromFile);
  {$I-}; System.Reset(FromF, 1); {$I+};
  if ioresult = 0 then
  begin
   System.Assign(ToF,ToFile);
   {$I-};System.Rewrite(ToF, 1); {$I+};
   if ioresult = 0 then
   begin
    repeat
     {$I-}; System.BlockRead(FromF, Buf, SizeOf(Buf), NumRead); {$I+};
     if ioresult = 0 then
     begin
      {$I-};System.BlockWrite(ToF, Buf, NumRead, NumWritten); {$I+};
      if ioresult <> 0 then
       Tmp := 5;
     end
     else
      Tmp := 4;
    until (NumRead = 0) or (NumWritten <> NumRead);
    System.Close(ToF);
   end
   else
    Tmp := 3;
   System.Close(FromF);
  end
  else
   Tmp := 2;
 end;
 CopyFile := Tmp;
end;

end.

